/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOpsumListMapper;
import com.yqbsoft.laser.service.data.domain.DaOpsumBean;
import com.yqbsoft.laser.service.data.domain.DaOpsumDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsumListDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsumListReDomain;
import com.yqbsoft.laser.service.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.data.domain.UmUser;
import com.yqbsoft.laser.service.data.domain.UmUserinfo;
import com.yqbsoft.laser.service.data.model.DaOpsum;
import com.yqbsoft.laser.service.data.model.DaOpsumList;
import com.yqbsoft.laser.service.data.service.DaOpsumListService;
import com.yqbsoft.laser.service.data.service.DaOpsumService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaOpsumListServiceImpl
extends BaseServiceImpl
implements DaOpsumListService {
    private static final String SYS_CODE = "da.DaOpsumListServiceImpl";
    private DaOpsumService daOpsumService;
    private DaOpsumListMapper daOpsumListMapper;

    public void setDaOpsumService(DaOpsumService daOpsumService) {
        this.daOpsumService = daOpsumService;
    }

    public void setDaOpsumListMapper(DaOpsumListMapper daOpsumListMapper) {
        this.daOpsumListMapper = daOpsumListMapper;
    }

    private Date getSysDate() {
        try {
            return this.daOpsumListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOpsumList(DaOpsumListDomain daOpsumListDomain) {
        if (null == daOpsumListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOpsumListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpsumListDefault(DaOpsumList daOpsumList) {
        if (null == daOpsumList) {
            return;
        }
        if (null == daOpsumList.getDataState()) {
            daOpsumList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOpsumList.getGmtCreate()) {
            daOpsumList.setGmtCreate(date);
        }
        daOpsumList.setGmtModified(date);
        if (StringUtils.isBlank((String)daOpsumList.getOpsumListCode())) {
            daOpsumList.setOpsumListCode(this.getNo(null, "DaOpsumList", "daOpsumList", daOpsumList.getTenantCode()));
        }
    }

    private int getOpsumListMaxCode() {
        int code = 0;
        try {
            return this.daOpsumListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.getOpsumListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpsumListUpdataDefault(DaOpsumList daOpsumList) {
        if (null == daOpsumList) {
            return;
        }
        daOpsumList.setGmtModified(this.getSysDate());
    }

    private void saveOpsumListModel(DaOpsumList daOpsumList) throws ApiException {
        if (null == daOpsumList) {
            return;
        }
        try {
            this.daOpsumListMapper.insert(daOpsumList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.saveOpsumListModel.ex", (Throwable)e);
        }
    }

    private void saveOpsumListBatchModel(List<DaOpsumList> daOpsumListList) throws ApiException {
        if (null == daOpsumListList || daOpsumListList.isEmpty()) {
            return;
        }
        try {
            this.daOpsumListMapper.insertBatch(daOpsumListList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.saveOpsumListBatchModel.ex", (Throwable)e);
        }
    }

    private DaOpsumList getOpsumListModelById(Integer opsumlistId) {
        if (null == opsumlistId) {
            return null;
        }
        try {
            return this.daOpsumListMapper.selectByPrimaryKey(opsumlistId);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.getOpsumListModelById", (Throwable)e);
            return null;
        }
    }

    private DaOpsumList getOpsumListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daOpsumListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.getOpsumListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void updateModelNumByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumListMapper.updateNumByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateModelNumByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateModelNumByCode.num");
        }
    }

    private void delOpsumListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.delOpsumListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumListServiceImpl.delOpsumListModelByCode.num");
        }
    }

    private void deleteOpsumListModel(Integer opsumlistId) throws ApiException {
        if (null == opsumlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumListMapper.deleteByPrimaryKey(opsumlistId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.deleteOpsumListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumListServiceImpl.deleteOpsumListModel.num");
        }
    }

    private void updateOpsumListModel(DaOpsumList daOpsumList) throws ApiException {
        if (null == daOpsumList) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumListMapper.updateByPrimaryKey(daOpsumList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateOpsumListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateOpsumListModel.num");
        }
    }

    private void updateStateOpsumListModel(Integer opsumlistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opsumlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opsumlistId", opsumlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOpsumListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateStateOpsumListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateStateOpsumListModel.null");
        }
    }

    private void updateStateOpsumListModelByCode(String tenantCode, String opsumlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opsumlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumlistCode", opsumlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOpsumListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateStateOpsumListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateStateOpsumListModelByCode.null");
        }
    }

    private DaOpsumList makeOpsumList(DaOpsumListDomain daOpsumListDomain, DaOpsumList daOpsumList) {
        if (null == daOpsumListDomain) {
            return null;
        }
        if (null == daOpsumList) {
            daOpsumList = new DaOpsumList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumList, (Object)daOpsumListDomain);
            return daOpsumList;
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.makeOpsumList", (Throwable)e);
            return null;
        }
    }

    private DaOpsumListReDomain makeDaOpsumListReDomain(DaOpsumList daOpsumList) {
        if (null == daOpsumList) {
            return null;
        }
        DaOpsumListReDomain daOpsumListReDomain = new DaOpsumListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumListReDomain, (Object)daOpsumList);
            return daOpsumListReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.makeDaOpsumListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaOpsumList> queryOpsumListModelPage(Map<String, Object> parammap) {
        try {
            return this.daOpsumListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.queryOpsumListModel", (Throwable)e);
            return null;
        }
    }

    private int countOpsumList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOpsumListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.countOpsumList", (Throwable)e);
        }
        return i;
    }

    private DaOpsumList createDaOpsumList(DaOpsumListDomain daOpsumListDomain) {
        String msg = this.checkOpsumList(daOpsumListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOpsumListServiceImpl.saveOpsumList.checkOpsumList", msg);
        }
        DaOpsumList daOpsumList = this.makeOpsumList(daOpsumListDomain, null);
        this.setOpsumListDefault(daOpsumList);
        return daOpsumList;
    }

    @Override
    public String saveOpsumList(DaOpsumListDomain daOpsumListDomain) throws ApiException {
        DaOpsumList daOpsumList = this.createDaOpsumList(daOpsumListDomain);
        this.saveOpsumListModel(daOpsumList);
        return daOpsumList.getOpsumListCode();
    }

    @Override
    public String saveOpsumListBatch(List<DaOpsumListDomain> daOpsumListDomainList) throws ApiException {
        if (null == daOpsumListDomainList || daOpsumListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaOpsumList> daOpsumListList = new ArrayList<DaOpsumList>();
        String code = "";
        for (DaOpsumListDomain daOpsumListDomain : daOpsumListDomainList) {
            DaOpsumList daOpsumList = this.createDaOpsumList(daOpsumListDomain);
            code = daOpsumList.getOpsumListCode();
            daOpsumListList.add(daOpsumList);
        }
        this.saveOpsumListBatchModel(daOpsumListList);
        return code;
    }

    @Override
    public void updateOpsumListState(Integer opsumlistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateOpsumListModel(opsumlistId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpsumListStateByCode(String tenantCode, String opsumlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateOpsumListModelByCode(tenantCode, opsumlistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpsumList(DaOpsumListDomain daOpsumListDomain) throws ApiException {
        String msg = this.checkOpsumList(daOpsumListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateOpsumList.checkOpsumList", msg);
        }
        DaOpsumList oldDaOpsumList = this.getOpsumListModelById(daOpsumListDomain.getOpsumListId());
        if (null == oldDaOpsumList) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateOpsumList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaOpsumList daOpsumList = this.makeOpsumList(daOpsumListDomain, oldDaOpsumList);
        this.setOpsumListUpdataDefault(daOpsumList);
        this.updateOpsumListModel(daOpsumList);
    }

    @Override
    public DaOpsumList getOpsumList(Integer opsumlistId) {
        return this.getOpsumListModelById(opsumlistId);
    }

    @Override
    public void deleteOpsumList(Integer opsumlistId) throws ApiException {
        this.deleteOpsumListModel(opsumlistId);
    }

    @Override
    public QueryResult<DaOpsumList> queryOpsumListPage(Map<String, Object> map) {
        List<DaOpsumList> daOpsumListList = this.queryOpsumListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpsumList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOpsumListList);
        return queryResult;
    }

    @Override
    public DaOpsumList getOpsumListByCode(String tenantCode, String opsumlistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumlistCode", opsumlistCode);
        return this.getOpsumListModelByCode(map);
    }

    @Override
    public void deleteOpsumListByCode(String tenantCode, String opsumlistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumlistCode", opsumlistCode);
        this.delOpsumListModelByCode(map);
    }

    @Override
    public String saveSumList(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            this.logger.error("da.DaOpsumListServiceImpl.saveSumList.OcContractDomain", (Object)"parm is null");
            return null;
        }
        this.saveOrder("OcContract", new BigDecimal("1"), ocContractDomain.getTenantCode());
        return "success";
    }

    private void saveOrder(String opsetType, BigDecimal num, String tenantCode) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        date = calendar.getTime();
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDate = sdf.format(date);
        DaOpsumBean daOpsumBean = new DaOpsumBean();
        daOpsumBean.setOpsetType(opsetType);
        daOpsumBean.setOpsumDimcode(tenantCode);
        daOpsumBean.setOpsumDimname("\u79df\u6237");
        daOpsumBean.setOpsumType("plat");
        daOpsumBean.setOpsumName("\u5b9e\u65f6\u6570\u636e");
        daOpsumBean.setOpsumListNum(num);
        daOpsumBean.setTenantCode(tenantCode);
        daOpsumBean.setOpsumDate(formatDate);
        this.saveSum(daOpsumBean);
    }

    @Override
    public String saveOrderPay(OcContractDomain ocContractDomain) throws ApiException {
        this.saveOrder("OcContractPay", new BigDecimal("1"), ocContractDomain.getTenantCode());
        this.saveOrder("OcContractPayMoney", ocContractDomain.getDataBmoney(), ocContractDomain.getTenantCode());
        this.saveOrder("OcContractPaySum", new BigDecimal("1"), ocContractDomain.getTenantCode());
        this.saveOrderBack("OcContract", new BigDecimal("-1"), ocContractDomain.getTenantCode());
        return "success";
    }

    private void saveOrderBack(String opsetType, BigDecimal num, String tenantCode) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        date = calendar.getTime();
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDate = sdf.format(date);
        DaOpsumBean daOpsumBean = new DaOpsumBean();
        daOpsumBean.setOpsetType(opsetType);
        daOpsumBean.setOpsumDimcode(tenantCode);
        daOpsumBean.setOpsumDimname("\u79df\u6237");
        daOpsumBean.setOpsumType("next");
        daOpsumBean.setOpsumName("\u5f85\u529e\u4e8b\u9879");
        daOpsumBean.setOpsumListNum(num);
        daOpsumBean.setTenantCode(tenantCode);
        daOpsumBean.setOpsumDate(formatDate);
        this.saveSum(daOpsumBean);
    }

    private void saveSum(DaOpsumBean daOpsumBean) {
        if (null == daOpsumBean) {
            return;
        }
        if (StringUtils.isBlank((String)daOpsumBean.getOpsumDimcode()) || StringUtils.isBlank((String)daOpsumBean.getOpsetType()) || StringUtils.isBlank((String)daOpsumBean.getOpsumType())) {
            return;
        }
        if (StringUtils.isBlank((String)daOpsumBean.getOpsumDate())) {
            Date date = this.getSysDate();
            daOpsumBean.setOpsumDate(DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd"));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", daOpsumBean.getTenantCode());
        map.put("opsumDate", daOpsumBean.getOpsumDate());
        map.put("opsumType", daOpsumBean.getOpsumType());
        map.put("opsumDimcode", daOpsumBean.getOpsumDimcode());
        QueryResult<DaOpsum> daOpsumQueryResult = this.daOpsumService.queryOpsumPage(map);
        String opsumCode = "";
        if (null == daOpsumQueryResult || ListUtil.isEmpty((Collection)daOpsumQueryResult.getList())) {
            DaOpsumDomain daOpsumDomain = new DaOpsumDomain();
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumDomain, (Object)daOpsumBean);
            }
            catch (Exception exception) {
                // empty catch block
            }
            opsumCode = this.daOpsumService.saveOpsum(daOpsumDomain);
        } else {
            DaOpsum daOpsum = (DaOpsum)daOpsumQueryResult.getList().get(0);
            opsumCode = daOpsum.getOpsumCode();
        }
        map.put("opsetType", daOpsumBean.getOpsetType());
        map.put("opsumCode", opsumCode);
        List<DaOpsumList> rlist = this.queryOpsumListModelPage(map);
        if (ListUtil.isEmpty(rlist)) {
            Date date = this.getSysDate();
            DaOpsumListDomain daOpsumListDomain = new DaOpsumListDomain();
            daOpsumListDomain.setOpsetType(daOpsumBean.getOpsetType());
            daOpsumListDomain.setOpsetName(daOpsumBean.getOpsetType());
            daOpsumListDomain.setOpsumCode(opsumCode);
            daOpsumListDomain.setOpsumDate(daOpsumBean.getOpsumDate());
            daOpsumListDomain.setOpsumListNum(daOpsumBean.getOpsumListNum());
            daOpsumListDomain.setTenantCode(daOpsumBean.getTenantCode());
            this.saveOpsumList(daOpsumListDomain);
        } else {
            HashMap<String, Object> nummap = new HashMap<String, Object>();
            nummap.put("tenantCode", daOpsumBean.getTenantCode());
            nummap.put("opsumListNum", daOpsumBean.getOpsumListNum());
            nummap.put("opsumListCode", rlist.get(0).getOpsumListCode());
            this.updateModelNumByCode(nummap);
        }
    }

    @Override
    public String saveUser(UmUser umUser, UmUserinfo umUserinfo) throws ApiException {
        if (umUser == null || umUserinfo == null) {
            this.logger.error("da.DaOpsumListServiceImpl.saveUser.umUser|umUserinfo", (Object)("umUser:" + umUser + ",umUserinfo" + umUserinfo));
            return this.returnResult("error", "\u4f20\u53c2\u4e3a\u7a7a", null);
        }
        Date gmtCreate = umUser.getGmtCreate();
        DaOpsumBean daOpsumBean = new DaOpsumBean();
        daOpsumBean.setOpsetType("UmUserinfo");
        daOpsumBean.setOpsumDate(DateUtil.getDateString((Date)gmtCreate, (String)"yyyy-MM-dd"));
        daOpsumBean.setOpsumDimcode(umUserinfo.getTenantCode());
        daOpsumBean.setOpsumDimname("\u79df\u6237");
        daOpsumBean.setOpsumType("plat");
        daOpsumBean.setOpsumName("\u8fd0\u8425");
        daOpsumBean.setOpsumListNum(new BigDecimal("1"));
        daOpsumBean.setTenantCode(umUserinfo.getTenantCode());
        this.saveSum(daOpsumBean);
        daOpsumBean = new DaOpsumBean();
        daOpsumBean.setOpsetType("UmUserinfoSum");
        daOpsumBean.setOpsumDate(DateUtil.getDateString((Date)gmtCreate, (String)"yyyy-MM-dd"));
        daOpsumBean.setOpsumDimcode(umUserinfo.getTenantCode());
        daOpsumBean.setOpsumDimname("\u79df\u6237");
        daOpsumBean.setOpsumType("plat");
        daOpsumBean.setOpsumName("\u8fd0\u8425");
        daOpsumBean.setOpsumListNum(new BigDecimal("1"));
        daOpsumBean.setTenantCode(umUserinfo.getTenantCode());
        this.saveSum(daOpsumBean);
        return this.returnResult("success", "\u7528\u6237\u6c47\u603b\u63a8\u9001\u6210\u529f", null);
    }

    private String returnResult(String state, String news, String params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", state);
        map.put("news", news);
        map.put("result", params);
        return JsonUtil.buildNormalBinder().toJson(map);
    }
}

