/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOpsumMapper;
import com.yqbsoft.laser.service.data.domain.DaOpsumDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsumReDomain;
import com.yqbsoft.laser.service.data.model.DaOpsum;
import com.yqbsoft.laser.service.data.service.DaOpsumService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaOpsumServiceImpl
extends BaseServiceImpl
implements DaOpsumService {
    private static final String SYS_CODE = "da.DaOpsumServiceImpl";
    private DaOpsumMapper daOpsumMapper;

    public void setDaOpsumMapper(DaOpsumMapper daOpsumMapper) {
        this.daOpsumMapper = daOpsumMapper;
    }

    private Date getSysDate() {
        try {
            return this.daOpsumMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOpsum(DaOpsumDomain daOpsumDomain) {
        if (null == daOpsumDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOpsumDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpsumDefault(DaOpsum daOpsum) {
        if (null == daOpsum) {
            return;
        }
        if (null == daOpsum.getDataState()) {
            daOpsum.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOpsum.getGmtCreate()) {
            daOpsum.setGmtCreate(date);
        }
        daOpsum.setGmtModified(date);
        if (StringUtils.isBlank((String)daOpsum.getOpsumCode())) {
            daOpsum.setOpsumCode(this.getNo(null, "DaOpsum", "daOpsum", daOpsum.getTenantCode()));
        }
    }

    private int getOpsumMaxCode() {
        int code = 0;
        try {
            return this.daOpsumMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumServiceImpl.getOpsumMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpsumUpdataDefault(DaOpsum daOpsum) {
        if (null == daOpsum) {
            return;
        }
        daOpsum.setGmtModified(this.getSysDate());
    }

    private void saveOpsumModel(DaOpsum daOpsum) throws ApiException {
        if (null == daOpsum) {
            return;
        }
        try {
            this.daOpsumMapper.insert(daOpsum);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumServiceImpl.saveOpsumModel.ex", (Throwable)e);
        }
    }

    private void saveOpsumBatchModel(List<DaOpsum> daOpsumList) throws ApiException {
        if (null == daOpsumList || daOpsumList.isEmpty()) {
            return;
        }
        try {
            this.daOpsumMapper.insertBatch(daOpsumList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumServiceImpl.saveOpsumBatchModel.ex", (Throwable)e);
        }
    }

    private DaOpsum getOpsumModelById(Integer opsumId) {
        if (null == opsumId) {
            return null;
        }
        try {
            return this.daOpsumMapper.selectByPrimaryKey(opsumId);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumServiceImpl.getOpsumModelById", (Throwable)e);
            return null;
        }
    }

    private DaOpsum getOpsumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daOpsumMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumServiceImpl.getOpsumModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpsumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumServiceImpl.delOpsumModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumServiceImpl.delOpsumModelByCode.num");
        }
    }

    private void deleteOpsumModel(Integer opsumId) throws ApiException {
        if (null == opsumId) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumMapper.deleteByPrimaryKey(opsumId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumServiceImpl.deleteOpsumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumServiceImpl.deleteOpsumModel.num");
        }
    }

    private void updateOpsumModel(DaOpsum daOpsum) throws ApiException {
        if (null == daOpsum) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumMapper.updateByPrimaryKey(daOpsum);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumServiceImpl.updateOpsumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumServiceImpl.updateOpsumModel.num");
        }
    }

    private void updateStateOpsumModel(Integer opsumId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opsumId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opsumId", opsumId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOpsumMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumServiceImpl.updateStateOpsumModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOpsumServiceImpl.updateStateOpsumModel.null");
        }
    }

    private void updateStateOpsumModelByCode(String tenantCode, String opsumCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opsumCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumCode", opsumCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOpsumMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumServiceImpl.updateStateOpsumModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOpsumServiceImpl.updateStateOpsumModelByCode.null");
        }
    }

    private DaOpsum makeOpsum(DaOpsumDomain daOpsumDomain, DaOpsum daOpsum) {
        if (null == daOpsumDomain) {
            return null;
        }
        if (null == daOpsum) {
            daOpsum = new DaOpsum();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOpsum, (Object)daOpsumDomain);
            return daOpsum;
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumServiceImpl.makeOpsum", (Throwable)e);
            return null;
        }
    }

    private DaOpsumReDomain makeDaOpsumReDomain(DaOpsum daOpsum) {
        if (null == daOpsum) {
            return null;
        }
        DaOpsumReDomain daOpsumReDomain = new DaOpsumReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumReDomain, (Object)daOpsum);
            return daOpsumReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumServiceImpl.makeDaOpsumReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaOpsum> queryOpsumModelPage(Map<String, Object> parammap) {
        try {
            return this.daOpsumMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumServiceImpl.queryOpsumModel", (Throwable)e);
            return null;
        }
    }

    private int countOpsum(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOpsumMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumServiceImpl.countOpsum", (Throwable)e);
        }
        return i;
    }

    private DaOpsum createDaOpsum(DaOpsumDomain daOpsumDomain) {
        String msg = this.checkOpsum(daOpsumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOpsumServiceImpl.saveOpsum.checkOpsum", msg);
        }
        DaOpsum daOpsum = this.makeOpsum(daOpsumDomain, null);
        this.setOpsumDefault(daOpsum);
        return daOpsum;
    }

    @Override
    public String saveOpsum(DaOpsumDomain daOpsumDomain) throws ApiException {
        DaOpsum daOpsum = this.createDaOpsum(daOpsumDomain);
        this.saveOpsumModel(daOpsum);
        return daOpsum.getOpsumCode();
    }

    @Override
    public String saveOpsumBatch(List<DaOpsumDomain> daOpsumDomainList) throws ApiException {
        if (null == daOpsumDomainList || daOpsumDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaOpsum> daOpsumList = new ArrayList<DaOpsum>();
        String code = "";
        for (DaOpsumDomain daOpsumDomain : daOpsumDomainList) {
            DaOpsum daOpsum = this.createDaOpsum(daOpsumDomain);
            code = daOpsum.getOpsumCode();
            daOpsumList.add(daOpsum);
        }
        this.saveOpsumBatchModel(daOpsumList);
        return code;
    }

    @Override
    public void updateOpsumState(Integer opsumId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateOpsumModel(opsumId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpsumStateByCode(String tenantCode, String opsumCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateOpsumModelByCode(tenantCode, opsumCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpsum(DaOpsumDomain daOpsumDomain) throws ApiException {
        String msg = this.checkOpsum(daOpsumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOpsumServiceImpl.updateOpsum.checkOpsum", msg);
        }
        DaOpsum oldDaOpsum = this.getOpsumModelById(daOpsumDomain.getOpsumId());
        if (null == oldDaOpsum) {
            throw new ApiException("da.DaOpsumServiceImpl.updateOpsum.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaOpsum daOpsum = this.makeOpsum(daOpsumDomain, oldDaOpsum);
        this.setOpsumUpdataDefault(daOpsum);
        this.updateOpsumModel(daOpsum);
    }

    @Override
    public DaOpsum getOpsum(Integer opsumId) {
        return this.getOpsumModelById(opsumId);
    }

    @Override
    public void deleteOpsum(Integer opsumId) throws ApiException {
        this.deleteOpsumModel(opsumId);
    }

    @Override
    public QueryResult<DaOpsum> queryOpsumPage(Map<String, Object> map) {
        List<DaOpsum> daOpsumList = this.queryOpsumModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpsum(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOpsumList);
        return queryResult;
    }

    @Override
    public DaOpsum getOpsumByCode(String tenantCode, String opsumCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumCode", opsumCode);
        return this.getOpsumModelByCode(map);
    }

    @Override
    public void deleteOpsumByCode(String tenantCode, String opsumCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumCode", opsumCode);
        this.delOpsumModelByCode(map);
    }
}

