/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOpsumListMapper;
import com.yqbsoft.laser.service.data.domain.CmsTginfo;
import com.yqbsoft.laser.service.data.domain.DaOpsumBean;
import com.yqbsoft.laser.service.data.domain.DaOpsumDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsumListDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsumListReDomain;
import com.yqbsoft.laser.service.data.domain.DisChannel;
import com.yqbsoft.laser.service.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.data.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.data.domain.TmProappEnv;
import com.yqbsoft.laser.service.data.domain.UmUser;
import com.yqbsoft.laser.service.data.domain.UmUserinfo;
import com.yqbsoft.laser.service.data.model.DaOpsum;
import com.yqbsoft.laser.service.data.model.DaOpsumList;
import com.yqbsoft.laser.service.data.service.DaOpsumListService;
import com.yqbsoft.laser.service.data.service.DaOpsumService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaOpsumListServiceImpl
extends BaseServiceImpl
implements DaOpsumListService {
    private static final String SYS_CODE = "da.DaOpsumListServiceImpl";
    private DaOpsumService daOpsumService;
    private DaOpsumListMapper daOpsumListMapper;

    public void setDaOpsumService(DaOpsumService daOpsumService) {
        this.daOpsumService = daOpsumService;
    }

    public void setDaOpsumListMapper(DaOpsumListMapper daOpsumListMapper) {
        this.daOpsumListMapper = daOpsumListMapper;
    }

    private Date getSysDate() {
        try {
            return this.daOpsumListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOpsumList(DaOpsumListDomain daOpsumListDomain) {
        if (null == daOpsumListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOpsumListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpsumListDefault(DaOpsumList daOpsumList) {
        if (null == daOpsumList) {
            return;
        }
        if (null == daOpsumList.getDataState()) {
            daOpsumList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOpsumList.getGmtCreate()) {
            daOpsumList.setGmtCreate(date);
        }
        daOpsumList.setGmtModified(date);
        if (StringUtils.isBlank((String)daOpsumList.getOpsumListCode())) {
            daOpsumList.setOpsumListCode(this.getNo(null, "DaOpsumList", "daOpsumList", daOpsumList.getTenantCode()));
        }
    }

    private int getOpsumListMaxCode() {
        int code = 0;
        try {
            return this.daOpsumListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.getOpsumListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpsumListUpdataDefault(DaOpsumList daOpsumList) {
        if (null == daOpsumList) {
            return;
        }
        daOpsumList.setGmtModified(this.getSysDate());
    }

    private void saveOpsumListModel(DaOpsumList daOpsumList) throws ApiException {
        if (null == daOpsumList) {
            return;
        }
        try {
            this.daOpsumListMapper.insert(daOpsumList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.saveOpsumListModel.ex", (Throwable)e);
        }
    }

    private void saveOpsumListBatchModel(List<DaOpsumList> daOpsumListList) throws ApiException {
        if (null == daOpsumListList || daOpsumListList.isEmpty()) {
            return;
        }
        try {
            this.daOpsumListMapper.insertBatch(daOpsumListList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.saveOpsumListBatchModel.ex", (Throwable)e);
        }
    }

    private DaOpsumList getOpsumListModelById(Integer opsumlistId) {
        if (null == opsumlistId) {
            return null;
        }
        try {
            return this.daOpsumListMapper.selectByPrimaryKey(opsumlistId);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.getOpsumListModelById", (Throwable)e);
            return null;
        }
    }

    private DaOpsumList getOpsumListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daOpsumListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.getOpsumListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void updateModelNumByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumListMapper.updateNumByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateModelNumByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateModelNumByCode.num");
        }
    }

    private void delOpsumListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.delOpsumListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumListServiceImpl.delOpsumListModelByCode.num");
        }
    }

    private void deleteOpsumListModel(Integer opsumlistId) throws ApiException {
        if (null == opsumlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumListMapper.deleteByPrimaryKey(opsumlistId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.deleteOpsumListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumListServiceImpl.deleteOpsumListModel.num");
        }
    }

    private void updateOpsumListModel(DaOpsumList daOpsumList) throws ApiException {
        if (null == daOpsumList) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumListMapper.updateByPrimaryKey(daOpsumList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateOpsumListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateOpsumListModel.num");
        }
    }

    private void updateStateOpsumListModel(Integer opsumlistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opsumlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opsumlistId", opsumlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOpsumListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateStateOpsumListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateStateOpsumListModel.null");
        }
    }

    private void updateStateOpsumListModelByCode(String tenantCode, String opsumlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opsumlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumlistCode", opsumlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOpsumListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateStateOpsumListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateStateOpsumListModelByCode.null");
        }
    }

    private DaOpsumList makeOpsumList(DaOpsumListDomain daOpsumListDomain, DaOpsumList daOpsumList) {
        if (null == daOpsumListDomain) {
            return null;
        }
        if (null == daOpsumList) {
            daOpsumList = new DaOpsumList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumList, (Object)daOpsumListDomain);
            return daOpsumList;
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.makeOpsumList", (Throwable)e);
            return null;
        }
    }

    private DaOpsumListReDomain makeDaOpsumListReDomain(DaOpsumList daOpsumList) {
        if (null == daOpsumList) {
            return null;
        }
        DaOpsumListReDomain daOpsumListReDomain = new DaOpsumListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumListReDomain, (Object)daOpsumList);
            return daOpsumListReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.makeDaOpsumListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaOpsumList> queryOpsumListModelPage(Map<String, Object> parammap) {
        try {
            return this.daOpsumListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.queryOpsumListModel", (Throwable)e);
            return null;
        }
    }

    private int countOpsumList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOpsumListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumListServiceImpl.countOpsumList", (Throwable)e);
        }
        return i;
    }

    private DaOpsumList createDaOpsumList(DaOpsumListDomain daOpsumListDomain) {
        String msg = this.checkOpsumList(daOpsumListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOpsumListServiceImpl.saveOpsumList.checkOpsumList", msg);
        }
        DaOpsumList daOpsumList = this.makeOpsumList(daOpsumListDomain, null);
        this.setOpsumListDefault(daOpsumList);
        return daOpsumList;
    }

    @Override
    public String saveOpsumList(DaOpsumListDomain daOpsumListDomain) throws ApiException {
        DaOpsumList daOpsumList = this.createDaOpsumList(daOpsumListDomain);
        this.saveOpsumListModel(daOpsumList);
        return daOpsumList.getOpsumListCode();
    }

    @Override
    public String saveOpsumListBatch(List<DaOpsumListDomain> daOpsumListDomainList) throws ApiException {
        if (null == daOpsumListDomainList || daOpsumListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaOpsumList> daOpsumListList = new ArrayList<DaOpsumList>();
        String code = "";
        for (DaOpsumListDomain daOpsumListDomain : daOpsumListDomainList) {
            DaOpsumList daOpsumList = this.createDaOpsumList(daOpsumListDomain);
            code = daOpsumList.getOpsumListCode();
            daOpsumListList.add(daOpsumList);
        }
        this.saveOpsumListBatchModel(daOpsumListList);
        return code;
    }

    @Override
    public void updateOpsumListState(Integer opsumlistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateOpsumListModel(opsumlistId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpsumListStateByCode(String tenantCode, String opsumlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateOpsumListModelByCode(tenantCode, opsumlistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpsumList(DaOpsumListDomain daOpsumListDomain) throws ApiException {
        String msg = this.checkOpsumList(daOpsumListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateOpsumList.checkOpsumList", msg);
        }
        DaOpsumList oldDaOpsumList = this.getOpsumListModelById(daOpsumListDomain.getOpsumListId());
        if (null == oldDaOpsumList) {
            throw new ApiException("da.DaOpsumListServiceImpl.updateOpsumList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaOpsumList daOpsumList = this.makeOpsumList(daOpsumListDomain, oldDaOpsumList);
        this.setOpsumListUpdataDefault(daOpsumList);
        this.updateOpsumListModel(daOpsumList);
    }

    @Override
    public DaOpsumList getOpsumList(Integer opsumlistId) {
        return this.getOpsumListModelById(opsumlistId);
    }

    @Override
    public void deleteOpsumList(Integer opsumlistId) throws ApiException {
        this.deleteOpsumListModel(opsumlistId);
    }

    @Override
    public QueryResult<DaOpsumList> queryOpsumListPage(Map<String, Object> map) {
        List<DaOpsumList> daOpsumListList = this.queryOpsumListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpsumList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOpsumListList);
        return queryResult;
    }

    @Override
    public DaOpsumList getOpsumListByCode(String tenantCode, String opsumlistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumlistCode", opsumlistCode);
        return this.getOpsumListModelByCode(map);
    }

    @Override
    public void deleteOpsumListByCode(String tenantCode, String opsumlistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumlistCode", opsumlistCode);
        this.delOpsumListModelByCode(map);
    }

    protected String getBusMember(String channelCode, String tenantCode) {
        DisChannel disChannel;
        String busMember = "";
        if (StringUtils.isNotBlank((String)channelCode) && null != (disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class))) {
            busMember = disChannel.getMemberCode();
        }
        if (StringUtils.isBlank((String)busMember)) {
            busMember = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        }
        return busMember;
    }

    @Override
    public String saveSumList(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            this.logger.error("da.DaOpsumListServiceImpl.saveSumList.OcContractDomain", (Object)"parm is null");
            return null;
        }
        String tenantCode = ocContractDomain.getTenantCode();
        String channelCode = ocContractDomain.getChannelCode();
        String busMember = this.getBusMember(channelCode, tenantCode);
        this.saveOrder("OcContract", new BigDecimal("1"), ocContractDomain.getTenantCode(), "\u79df\u6237", ocContractDomain.getTenantCode());
        this.saveOrder("OcContract", new BigDecimal("1"), busMember, "\u8fd0\u8425", ocContractDomain.getTenantCode());
        this.saveOrder("OcContract", new BigDecimal("1"), ocContractDomain.getMemberCode(), "\u7528\u6237", ocContractDomain.getTenantCode());
        return "success";
    }

    private void saveOrderForPay(String opsetType, BigDecimal num, String opsumDimcode, String opsumDimname, String tenantCode, String opsumDimcode1, String opsumDimname1) {
        if (StringUtils.isBlank((String)opsumDimcode)) {
            return;
        }
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        date = calendar.getTime();
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDate = sdf.format(date);
        DaOpsumBean daOpsumBean = new DaOpsumBean();
        daOpsumBean.setOpsetType(opsetType);
        daOpsumBean.setOpsumDimcode(opsumDimcode);
        daOpsumBean.setOpsumDimname(opsumDimname);
        daOpsumBean.setOpsumDimcode1(StringUtils.isBlank((String)opsumDimcode1) ? "all" : opsumDimcode1);
        daOpsumBean.setOpsumDimname1(StringUtils.isBlank((String)opsumDimname1) ? "all" : opsumDimname1);
        daOpsumBean.setOpsumDimcode2("all");
        daOpsumBean.setOpsumDimname2("all");
        daOpsumBean.setOpsumType("plat");
        daOpsumBean.setOpsumName("\u5b9e\u65f6\u6570\u636e");
        daOpsumBean.setOpsumListNum(num);
        daOpsumBean.setTenantCode(tenantCode);
        daOpsumBean.setOpsumDate(formatDate);
        this.saveSum(daOpsumBean);
    }

    private void saveOrder(String opsetType, BigDecimal num, String opsumDimcode, String opsumDimname, String tenantCode) {
        if (StringUtils.isBlank((String)opsumDimcode)) {
            return;
        }
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        date = calendar.getTime();
        DaOpsumBean daOpsumBean = new DaOpsumBean();
        daOpsumBean.setOpsetType(opsetType);
        daOpsumBean.setOpsumDimcode(opsumDimcode);
        daOpsumBean.setOpsumDimname(opsumDimname);
        daOpsumBean.setOpsumType("next");
        daOpsumBean.setOpsumName("\u5f85\u529e\u4e8b\u9879");
        daOpsumBean.setOpsumListNum(num);
        daOpsumBean.setTenantCode(tenantCode);
        daOpsumBean.setOpsumDate("next");
        this.saveSum(daOpsumBean);
    }

    @Override
    public String saveOrderPay(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "success";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        String channelCode = ocContractDomain.getChannelCode();
        String busMember = this.getBusMember(channelCode, tenantCode);
        this.saveOrderForPay("OcContractPay", new BigDecimal("1"), ocContractDomain.getTenantCode(), "\u79df\u6237", ocContractDomain.getTenantCode(), null, null);
        this.saveOrderForPay("OcContractPay", new BigDecimal("1"), busMember, "\u8fd0\u8425", ocContractDomain.getTenantCode(), null, null);
        this.saveOrderForPay("OcContractPay", new BigDecimal("1"), ocContractDomain.getMemberCode(), "\u7528\u6237", ocContractDomain.getTenantCode(), null, null);
        this.saveOrderForPay("OcContractPayMoney", ocContractDomain.getDataBmoney(), ocContractDomain.getTenantCode(), "\u79df\u6237", ocContractDomain.getTenantCode(), null, null);
        this.saveOrderForPay("OcContractPayMoney", ocContractDomain.getDataBmoney(), busMember, "\u8fd0\u8425", ocContractDomain.getTenantCode(), null, null);
        this.saveOrderForPay("OcContractPayMoney", ocContractDomain.getDataBmoney(), ocContractDomain.getMemberCode(), "\u7528\u6237", ocContractDomain.getTenantCode(), null, null);
        this.saveOrder("OcContractSend", new BigDecimal("1"), ocContractDomain.getTenantCode(), "\u79df\u6237", ocContractDomain.getTenantCode());
        this.saveOrder("OcContractSend", new BigDecimal("1"), busMember, "\u8fd0\u8425", ocContractDomain.getTenantCode());
        this.saveOrder("OcContractSend", new BigDecimal("1"), ocContractDomain.getMemberCode(), "\u7528\u6237", ocContractDomain.getTenantCode());
        this.saveOrderForPay("OcContractPaySum", new BigDecimal("1"), ocContractDomain.getTenantCode(), "\u79df\u6237", ocContractDomain.getTenantCode(), null, null);
        this.saveOrderForPay("OcContractPaySum", new BigDecimal("1"), busMember, "\u8fd0\u8425", ocContractDomain.getTenantCode(), null, null);
        this.saveOrderForPay("OcContractPaySum", new BigDecimal("1"), ocContractDomain.getMemberCode(), "\u7528\u6237", ocContractDomain.getTenantCode(), null, null);
        this.saveOrderBack("OcContract", new BigDecimal("-1"), ocContractDomain.getTenantCode(), "\u79df\u6237", "next", "\u5f85\u529e\u4e8b\u9879", ocContractDomain.getTenantCode());
        this.saveOrderBack("OcContract", new BigDecimal("-1"), busMember, "\u8fd0\u8425", "next", "\u5f85\u529e\u4e8b\u9879", ocContractDomain.getTenantCode());
        this.saveOrderBack("OcContract", new BigDecimal("-1"), ocContractDomain.getMemberCode(), "\u7528\u6237", "next", "\u5f85\u529e\u4e8b\u9879", ocContractDomain.getTenantCode());
        return "success";
    }

    @Override
    public String saveRefundOk(OcRefundReDomain ocRefundReDomain) throws ApiException {
        String memthodIntoParam = "\u9000\u6b3e\u4f20\u53c2\uff1a" + JsonUtil.buildNonDefaultBinder().toJson((Object)ocRefundReDomain);
        HashMap<String, String> msg = new HashMap<String, String>();
        String result = "";
        ocRefundReDomain.getChannelCode();
        String tenantCode = ocRefundReDomain.getTenantCode();
        String channelCode = ocRefundReDomain.getChannelCode();
        String busMember = this.getBusMember(channelCode, tenantCode);
        if (null == ocRefundReDomain || StringUtils.isBlank((Integer)ocRefundReDomain.getDataState())) {
            this.logger.error("da.DaOpsumListServiceImpl.saveRefund.ocRefundReDomain:", (Object)(ocRefundReDomain + "|" + memthodIntoParam));
            msg.put("news", "ocRefundReDomain\u503c\u4e3a\u7a7a");
            msg.put("state", "error");
            result = JsonUtil.buildNormalBinder().toJson(msg);
            return result;
        }
        this.saveOrder("OcRefund", new BigDecimal("-1"), ocRefundReDomain.getTenantCode(), "\u79df\u6237", ocRefundReDomain.getTenantCode());
        this.saveOrder("OcRefund", new BigDecimal("-1"), busMember, "\u8fd0\u8425", ocRefundReDomain.getTenantCode());
        this.saveOrder("OcRefund", new BigDecimal("-1"), ocRefundReDomain.getMemberCode(), "\u7528\u6237", ocRefundReDomain.getTenantCode());
        msg.put("news", "\u5df2\u5ba1\u6838\u6c47\u603b\u6210\u529f!");
        msg.put("state", "success");
        result = JsonUtil.buildNormalBinder().toJson(msg);
        return result;
    }

    @Override
    public String saveRefund(OcRefundReDomain ocRefundReDomain) throws ApiException {
        String memthodIntoParam = "\u9000\u6b3e\u4f20\u53c2\uff1a" + JsonUtil.buildNonDefaultBinder().toJson((Object)ocRefundReDomain);
        HashMap<String, String> msg = new HashMap<String, String>();
        String result = "";
        ocRefundReDomain.getChannelCode();
        String tenantCode = ocRefundReDomain.getTenantCode();
        String channelCode = ocRefundReDomain.getChannelCode();
        String busMember = this.getBusMember(channelCode, tenantCode);
        if (null == ocRefundReDomain || StringUtils.isBlank((Integer)ocRefundReDomain.getDataState())) {
            this.logger.error("da.DaOpsumListServiceImpl.saveRefund.ocRefundReDomain:", (Object)(ocRefundReDomain + "|" + memthodIntoParam));
            msg.put("news", "ocRefundReDomain\u503c\u4e3a\u7a7a");
            msg.put("state", "error");
            result = JsonUtil.buildNormalBinder().toJson(msg);
            return result;
        }
        this.saveOrder("OcRefund", new BigDecimal("1"), ocRefundReDomain.getTenantCode(), "\u79df\u6237", ocRefundReDomain.getTenantCode());
        this.saveOrder("OcRefund", new BigDecimal("1"), busMember, "\u8fd0\u8425", ocRefundReDomain.getTenantCode());
        this.saveOrder("OcRefund", new BigDecimal("1"), ocRefundReDomain.getMemberCode(), "\u7528\u6237", ocRefundReDomain.getTenantCode());
        msg.put("news", "\u5f85\u5ba1\u6838\u6c47\u603b\u6210\u529f!");
        msg.put("state", "success");
        result = JsonUtil.buildNormalBinder().toJson(msg);
        return result;
    }

    private void saveOrderBack(String opsetType, BigDecimal num, String opsumDimcode, String opsumDimname, String sumType, String sumName, String tenantCode) {
        if (StringUtils.isBlank((String)opsumDimcode)) {
            return;
        }
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        date = calendar.getTime();
        DaOpsumBean daOpsumBean = new DaOpsumBean();
        daOpsumBean.setOpsetType(opsetType);
        daOpsumBean.setOpsumDimcode(opsumDimcode);
        daOpsumBean.setOpsumDimname(opsumDimname);
        daOpsumBean.setOpsumType(sumType);
        daOpsumBean.setOpsumName(sumName);
        daOpsumBean.setOpsumListNum(num);
        daOpsumBean.setTenantCode(tenantCode);
        daOpsumBean.setOpsumDate(sumType);
        this.saveSumBack(daOpsumBean);
    }

    private void saveSumBack(DaOpsumBean daOpsumBean) {
        if (null == daOpsumBean) {
            return;
        }
        if (StringUtils.isBlank((String)daOpsumBean.getOpsumDimcode()) || StringUtils.isBlank((String)daOpsumBean.getOpsetType()) || StringUtils.isBlank((String)daOpsumBean.getOpsumType())) {
            return;
        }
        if (StringUtils.isBlank((String)daOpsumBean.getOpsumDate())) {
            Date date = this.getSysDate();
            daOpsumBean.setOpsumDate(DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd"));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", daOpsumBean.getTenantCode());
        map.put("opsumDate", daOpsumBean.getOpsumDate());
        map.put("opsumType", daOpsumBean.getOpsumType());
        map.put("opsumDimcode", daOpsumBean.getOpsumDimcode());
        map.put("opsumDimname", daOpsumBean.getOpsumDimname());
        map.put("opsetType", daOpsumBean.getOpsetType());
        QueryResult<DaOpsum> daOpsumQueryResult = this.daOpsumService.queryOpsumPage(map);
        if (null == daOpsumQueryResult || ListUtil.isEmpty((Collection)daOpsumQueryResult.getList())) {
            return;
        }
        List rlist = daOpsumQueryResult.getList();
        String opsumCode = ((DaOpsum)rlist.get(0)).getOpsumCode();
        map.put("opsetType", daOpsumBean.getOpsetType());
        map.put("opsumCode", opsumCode);
        List<DaOpsumList> rlist22 = this.queryOpsumListModelPage(map);
        if (ListUtil.isNotEmpty(rlist22)) {
            HashMap<String, Object> nummap = new HashMap<String, Object>();
            nummap.put("tenantCode", daOpsumBean.getTenantCode());
            nummap.put("opsumListNum", daOpsumBean.getOpsumListNum());
            nummap.put("opsumListCode", rlist22.get(0).getOpsumListCode());
            this.updateModelNumByCode(nummap);
        }
    }

    private void saveSum(DaOpsumBean daOpsumBean) {
        if (null == daOpsumBean) {
            return;
        }
        if (StringUtils.isBlank((String)daOpsumBean.getOpsumDimcode()) || StringUtils.isBlank((String)daOpsumBean.getOpsetType()) || StringUtils.isBlank((String)daOpsumBean.getOpsumType())) {
            return;
        }
        if (StringUtils.isBlank((String)daOpsumBean.getOpsumDate())) {
            Date date = this.getSysDate();
            daOpsumBean.setOpsumDate(DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd"));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", daOpsumBean.getTenantCode());
        map.put("opsumDate", daOpsumBean.getOpsumDate());
        map.put("opsumType", daOpsumBean.getOpsumType());
        map.put("opsumDimcode", daOpsumBean.getOpsumDimcode());
        map.put("opsumDimcode1", daOpsumBean.getOpsumDimcode1());
        map.put("opsumDimcode2", daOpsumBean.getOpsumDimcode2());
        QueryResult<DaOpsum> daOpsumQueryResult = this.daOpsumService.queryOpsumPage(map);
        String opsumCode = "";
        if (null == daOpsumQueryResult || ListUtil.isEmpty((Collection)daOpsumQueryResult.getList())) {
            DaOpsumDomain daOpsumDomain = new DaOpsumDomain();
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumDomain, (Object)daOpsumBean);
            }
            catch (Exception e) {
                // empty catch block
            }
            opsumCode = this.daOpsumService.saveOpsum(daOpsumDomain);
        } else {
            DaOpsum daOpsum = (DaOpsum)daOpsumQueryResult.getList().get(0);
            opsumCode = daOpsum.getOpsumCode();
        }
        map.put("opsumCode", opsumCode);
        List<DaOpsumList> rlist = this.queryOpsumListModelPage(map);
        if (ListUtil.isEmpty(rlist)) {
            DaOpsumListDomain daOpsumListDomain = new DaOpsumListDomain();
            daOpsumListDomain.setOpsetType(daOpsumBean.getOpsetType());
            daOpsumListDomain.setOpsetName(daOpsumBean.getOpsetType());
            daOpsumListDomain.setOpsumCode(opsumCode);
            daOpsumListDomain.setOpsumDimcode(daOpsumBean.getOpsumDimcode());
            daOpsumListDomain.setOpsumDimname(daOpsumBean.getOpsumDimname());
            daOpsumListDomain.setOpsumDimcode1(daOpsumBean.getOpsumDimcode1());
            daOpsumListDomain.setOpsumDimname1(daOpsumBean.getOpsumDimname1());
            daOpsumListDomain.setOpsumDimcode2(daOpsumBean.getOpsumDimcode2());
            daOpsumListDomain.setOpsumDimname2(daOpsumBean.getOpsumDimname2());
            daOpsumListDomain.setOpsumDate(daOpsumBean.getOpsumDate());
            daOpsumListDomain.setOpsumListNum(daOpsumBean.getOpsumListNum());
            daOpsumListDomain.setTenantCode(daOpsumBean.getTenantCode());
            this.saveOpsumList(daOpsumListDomain);
        } else {
            HashMap<String, Object> nummap = new HashMap<String, Object>();
            nummap.put("tenantCode", daOpsumBean.getTenantCode());
            nummap.put("opsumListNum", daOpsumBean.getOpsumListNum());
            nummap.put("opsumListCode", rlist.get(0).getOpsumListCode());
            this.updateModelNumByCode(nummap);
        }
    }

    @Override
    public String saveUser(UmUser umUser, UmUserinfo umUserinfo) throws ApiException {
        List<String> memList;
        if (umUser == null || umUserinfo == null) {
            this.logger.error("da.DaOpsumListServiceImpl.saveUser.umUser|umUserinfo", (Object)("umUser:" + umUser + ",umUserinfo" + umUserinfo));
            return this.returnResult("error", "\u4f20\u53c2\u4e3a\u7a7a", null);
        }
        String busMember = umUserinfo.getUserinfoParentCode();
        if (StringUtils.isBlank((String)busMember)) {
            busMember = SupDisUtil.getMap((String)"tmtenant-user-code", (String)umUserinfo.getTenantCode());
        }
        Date gmtCreate = umUser.getGmtCreate();
        String opsumDate = DateUtil.getDateString((Date)gmtCreate, (String)"yyyy-MM-dd");
        this.saveUser(umUserinfo.getTenantCode(), "\u79df\u6237", umUserinfo.getTenantCode(), opsumDate);
        String qualityStr = umUser.getUserinfoQuality();
        if (StringUtils.isBlank((String)qualityStr)) {
            qualityStr = "buy";
        }
        if (ListUtil.isNotEmpty(memList = this.getchannelMemStr(qualityStr, umUserinfo.getTenantCode(), busMember))) {
            for (String mem : memList) {
                this.saveUser(mem, "\u8fd0\u8425", umUserinfo.getTenantCode(), opsumDate);
            }
        } else {
            this.saveUser(busMember, "\u8fd0\u8425", umUserinfo.getTenantCode(), opsumDate);
        }
        return this.returnResult("success", "\u7528\u6237\u6c47\u603b\u63a8\u9001\u6210\u529f", null);
    }

    private List<String> getchannelMemStr(String qualityStr, String tenantCode, String busMember) {
        if (StringUtils.isBlank((String)qualityStr)) {
            return null;
        }
        String[] qualityS = qualityStr.split("\\,");
        if (null == qualityS || qualityS.length == 0) {
            return null;
        }
        ArrayList<String> buylist = new ArrayList<String>();
        for (String quality : qualityS) {
            List<String> tlist = this.getchannelMem(quality, tenantCode);
            if (!ListUtil.isNotEmpty(tlist)) continue;
            buylist.addAll(tlist);
        }
        if (ListUtil.isEmpty(buylist)) {
            return null;
        }
        List<String> channleList = this.getTginfoProapp(buylist, tenantCode);
        if (null == channleList) {
            channleList = new ArrayList<String>();
        }
        if (ListUtil.isEmpty(channleList = this.getproappEnv(buylist, channleList, tenantCode))) {
            return null;
        }
        ArrayList<String> memlist = new ArrayList<String>();
        for (String channelCode : channleList) {
            DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
            if (null == disChannel || null == disChannel.getMemberCode() || disChannel.getMemberCode().equals(busMember)) continue;
            memlist.add(disChannel.getMemberCode());
        }
        return memlist;
    }

    private List<String> getproappEnv(List<String> buylist, List<String> channleList, String tenantCode) {
        if (ListUtil.isEmpty(buylist)) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult qlist = this.sendReSupObject("tm.proapp.queryProappEnvPage", paramMap, TmProappEnv.class);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        for (TmProappEnv tmProappEnv : qlist.getList()) {
            if (StringUtils.isBlank((String)tmProappEnv.getProappCode()) || StringUtils.isBlank((String)tmProappEnv.getChannelCode()) || !buylist.contains(tmProappEnv.getProappCode()) || channleList.contains(tmProappEnv.getChannelCode())) continue;
            channleList.add(tmProappEnv.getChannelCode());
        }
        return channleList;
    }

    private List<String> getTginfoProapp(List<String> buylist, String tenantCode) {
        if (ListUtil.isEmpty(buylist)) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult qlist = this.sendReSupObject("cms.tginfo.queryTginfoPage", paramMap, CmsTginfo.class);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        ArrayList<String> relist = new ArrayList<String>();
        this.logger.error("da.DaOpsumListServiceImplgetTginfoProapp.relist====" + relist);
        for (CmsTginfo cmsTginfo : qlist.getList()) {
            if (StringUtils.isBlank((String)cmsTginfo.getProappCode()) || StringUtils.isBlank((String)cmsTginfo.getChannelCode()) || !buylist.contains(cmsTginfo.getProappCode()) || relist.contains(cmsTginfo.getChannelCode())) continue;
            relist.add(cmsTginfo.getChannelCode());
        }
        return relist;
    }

    private List<String> getchannelMem(String quality, String tenantCode) {
        if (StringUtils.isBlank((String)quality)) {
            return null;
        }
        String platbuykey = quality + "-" + "00000000";
        String key = quality + "-" + tenantCode;
        List buylist = SupDisUtil.getMapListJson((String)"UmQualityProapp-list", (String)key, String.class);
        if (ListUtil.isEmpty((Collection)buylist)) {
            buylist = SupDisUtil.getMapListJson((String)"UmQualityProapp-list", (String)platbuykey, String.class);
        }
        return buylist;
    }

    private void saveUser(String busMember, String name, String tenantCode, String opsumDate) {
        DaOpsumBean daOpsumBean = new DaOpsumBean();
        daOpsumBean.setOpsetType("UmUserinfo");
        daOpsumBean.setOpsumDate(opsumDate);
        daOpsumBean.setOpsumDimcode(busMember);
        daOpsumBean.setOpsumDimname(name);
        daOpsumBean.setOpsumType("plat");
        daOpsumBean.setOpsumName("\u5b9e\u65f6\u6570\u636e");
        daOpsumBean.setOpsumListNum(new BigDecimal("1"));
        daOpsumBean.setTenantCode(tenantCode);
        this.saveSum(daOpsumBean);
        daOpsumBean = new DaOpsumBean();
        daOpsumBean.setOpsetType("UmUserinfoSum");
        daOpsumBean.setOpsumDate(opsumDate);
        daOpsumBean.setOpsumDimcode(busMember);
        daOpsumBean.setOpsumDimname(name);
        daOpsumBean.setOpsumType("plat");
        daOpsumBean.setOpsumName("\u5b9e\u65f6\u6570\u636e");
        daOpsumBean.setOpsumListNum(new BigDecimal("1"));
        daOpsumBean.setTenantCode(tenantCode);
        this.saveSum(daOpsumBean);
    }

    private String returnResult(String state, String news, String params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", state);
        map.put("news", news);
        map.put("result", params);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    @Override
    public String saveSendgoods(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "success";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        String channelCode = ocContractDomain.getChannelCode();
        String busMember = this.getBusMember(channelCode, tenantCode);
        this.saveOrderBack("OcContractSend", new BigDecimal("-1"), ocContractDomain.getTenantCode(), "\u79df\u6237", "next", "\u5f85\u529e\u4e8b\u9879", ocContractDomain.getTenantCode());
        this.saveOrderBack("OcContractSend", new BigDecimal("-1"), busMember, "\u8fd0\u8425", "next", "\u5f85\u529e\u4e8b\u9879", ocContractDomain.getTenantCode());
        this.saveOrderBack("OcContractSend", new BigDecimal("-1"), ocContractDomain.getMemberCode(), "\u7528\u6237", "next", "\u5f85\u529e\u4e8b\u9879", ocContractDomain.getTenantCode());
        return "success";
    }

    @Override
    public String saveSend(SgSendgoodsReDomain sgSendgoodsReDomain) throws ApiException {
        if (null == sgSendgoodsReDomain) {
            return "success";
        }
        String tenantCode = sgSendgoodsReDomain.getTenantCode();
        String channelCode = sgSendgoodsReDomain.getChannelCode();
        String busMember = this.getBusMember(channelCode, tenantCode);
        this.saveOrder("SgSendgoods", new BigDecimal("1"), sgSendgoodsReDomain.getTenantCode(), "\u79df\u6237", sgSendgoodsReDomain.getTenantCode());
        this.saveOrder("SgSendgoods", new BigDecimal("1"), busMember, "\u8fd0\u8425", sgSendgoodsReDomain.getTenantCode());
        this.saveOrder("SgSendgoods", new BigDecimal("1"), sgSendgoodsReDomain.getMemberCode(), "\u7528\u6237", sgSendgoodsReDomain.getTenantCode());
        return "success";
    }

    @Override
    public String saveSendOk(SgSendgoodsReDomain sgSendgoodsReDomain) throws ApiException {
        if (null == sgSendgoodsReDomain) {
            return "success";
        }
        String tenantCode = sgSendgoodsReDomain.getTenantCode();
        String channelCode = sgSendgoodsReDomain.getChannelCode();
        String busMember = this.getBusMember(channelCode, tenantCode);
        this.saveOrderBack("SgSendgoods", new BigDecimal("-1"), sgSendgoodsReDomain.getTenantCode(), "\u79df\u6237", "next", "\u5f85\u529e\u4e8b\u9879", sgSendgoodsReDomain.getTenantCode());
        this.saveOrderBack("SgSendgoods", new BigDecimal("-1"), busMember, "\u8fd0\u8425", "next", "\u5f85\u529e\u4e8b\u9879", sgSendgoodsReDomain.getTenantCode());
        this.saveOrderBack("SgSendgoods", new BigDecimal("-1"), sgSendgoodsReDomain.getMemberCode(), "\u7528\u6237", "next", "\u5f85\u529e\u4e8b\u9879", sgSendgoodsReDomain.getTenantCode());
        return "success";
    }

    @Override
    public String savePayOk(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "success";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        String channelCode = ocContractDomain.getChannelCode();
        String busMember = this.getBusMember(channelCode, tenantCode);
        this.saveOrderBack("OcContract", new BigDecimal("-1"), ocContractDomain.getTenantCode(), "\u79df\u6237", "next", "\u5f85\u529e\u4e8b\u9879", ocContractDomain.getTenantCode());
        this.saveOrderBack("OcContract", new BigDecimal("-1"), busMember, "\u8fd0\u8425", "next", "\u5f85\u529e\u4e8b\u9879", ocContractDomain.getTenantCode());
        this.saveOrderBack("OcContract", new BigDecimal("-1"), ocContractDomain.getMemberCode(), "\u7528\u6237", "next", "\u5f85\u529e\u4e8b\u9879", ocContractDomain.getTenantCode());
        return "success";
    }

    @Override
    public String saveOrderAll(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return "success";
        }
        String tenantCode = (String)map.get("tenantCode");
        String channelCode = (String)map.get("channelCode");
        String channelName = (String)map.get("channelName");
        String memberCode = (String)map.get("memberCode");
        String memberCcode = (String)map.get("memberCcode");
        Object dataBmoneyObj = map.get("dataBmoney");
        BigDecimal dataBmoney = BigDecimal.ZERO;
        BigDecimal backDataBmoney = BigDecimal.ZERO;
        if (null != backDataBmoney) {
            dataBmoney = new BigDecimal(dataBmoneyObj.toString());
            backDataBmoney = dataBmoney.multiply(new BigDecimal("-1"));
        }
        String busMember = this.getBusMember(channelCode, tenantCode);
        String opsetTypeStr = (String)map.get("opsetTypeStr");
        String opsetTypeDimcodeStr = (String)map.get("opsetTypeDimcodeStr");
        String opsetTypeMoenyStr = (String)map.get("opsetTypeMoenyStr");
        String opsetTypeMoenyDimcodeStr = (String)map.get("opsetTypeMoenyDimcodeStr");
        String opsetTypeBackStr = (String)map.get("opsetTypeBackStr");
        String opsetTypeBackDimcodeStr = (String)map.get("opsetTypeBackDimcodeStr");
        String opsetTypeMoenyBackStr = (String)map.get("opsetTypeMoenyBackStr");
        String opsetTypeMoenyBackDimcodeStr = (String)map.get("opsetTypeMoenyBackDimcodeStr");
        if (StringUtils.isBlank((String)opsetTypeBackStr) && StringUtils.isBlank((String)opsetTypeMoenyBackStr) && StringUtils.isBlank((String)opsetTypeStr) && StringUtils.isBlank((String)opsetTypeMoenyStr)) {
            return "success";
        }
        BigDecimal num = new BigDecimal("1");
        BigDecimal backnum = new BigDecimal("-1");
        if (StringUtils.isNotBlank((String)opsetTypeStr)) {
            for (String type : opsetTypeStr.split("\\,")) {
                if (StringUtils.isBlank((String)opsetTypeDimcodeStr)) {
                    this.saveOrderForPay(type, num, tenantCode, "\u79df\u6237", tenantCode, null, null);
                    this.saveOrderForPay(type, num, busMember, "\u8fd0\u8425", tenantCode, null, null);
                    this.saveOrderForPay(type, num, memberCode, "\u7528\u6237", tenantCode, null, null);
                    this.saveOrderForPay(type, num, memberCcode, "\u95e8\u5e97", tenantCode, null, null);
                    this.saveOrderForPay(type, num, tenantCode, "\u79df\u6237", tenantCode, channelCode, channelName);
                    this.saveOrderForPay(type, num, busMember, "\u8fd0\u8425", tenantCode, channelCode, channelName);
                    this.saveOrderForPay(type, num, memberCode, "\u7528\u6237", tenantCode, channelCode, channelName);
                    this.saveOrderForPay(type, num, memberCcode, "\u95e8\u5e97", tenantCode, channelCode, channelName);
                    continue;
                }
                for (String dimcode : opsetTypeDimcodeStr.split("\\,")) {
                    if ("tenantCode".equals(dimcode)) {
                        this.saveOrderForPay(type, num, tenantCode, "\u79df\u6237", tenantCode, null, null);
                        this.saveOrderForPay(type, num, tenantCode, "\u79df\u6237", tenantCode, channelCode, channelName);
                        continue;
                    }
                    if ("busMember".equals(dimcode)) {
                        this.saveOrderForPay(type, num, busMember, "\u8fd0\u8425", tenantCode, null, null);
                        this.saveOrderForPay(type, num, busMember, "\u8fd0\u8425", tenantCode, channelCode, channelName);
                        continue;
                    }
                    if ("memberCode".equals(dimcode)) {
                        this.saveOrderForPay(type, num, memberCode, "\u7528\u6237", tenantCode, null, null);
                        this.saveOrderForPay(type, num, memberCode, "\u7528\u6237", tenantCode, channelCode, channelName);
                        continue;
                    }
                    if (!"memberCcode".equals(dimcode)) continue;
                    this.saveOrderForPay(type, num, memberCcode, "\u95e8\u5e97", tenantCode, null, null);
                    this.saveOrderForPay(type, num, memberCcode, "\u95e8\u5e97", tenantCode, channelCode, channelName);
                }
            }
        }
        if (StringUtils.isNotBlank((String)opsetTypeMoenyStr)) {
            for (String type : opsetTypeMoenyStr.split("\\,")) {
                if (StringUtils.isBlank((String)opsetTypeMoenyDimcodeStr)) {
                    this.saveOrderForPay(type, dataBmoney, tenantCode, "\u79df\u6237", tenantCode, null, null);
                    this.saveOrderForPay(type, dataBmoney, busMember, "\u8fd0\u8425", tenantCode, null, null);
                    this.saveOrderForPay(type, dataBmoney, memberCode, "\u7528\u6237", tenantCode, null, null);
                    this.saveOrderForPay(type, dataBmoney, memberCcode, "\u95e8\u5e97", tenantCode, null, null);
                    this.saveOrderForPay(type, dataBmoney, tenantCode, "\u79df\u6237", tenantCode, channelCode, channelName);
                    this.saveOrderForPay(type, dataBmoney, busMember, "\u8fd0\u8425", tenantCode, channelCode, channelName);
                    this.saveOrderForPay(type, dataBmoney, memberCode, "\u7528\u6237", tenantCode, channelCode, channelName);
                    this.saveOrderForPay(type, dataBmoney, memberCcode, "\u95e8\u5e97", tenantCode, channelCode, channelName);
                    continue;
                }
                for (String dimcode : opsetTypeMoenyDimcodeStr.split("\\,")) {
                    if ("tenantCode".equals(dimcode)) {
                        this.saveOrderForPay(type, dataBmoney, tenantCode, "\u79df\u6237", tenantCode, null, null);
                        this.saveOrderForPay(type, dataBmoney, tenantCode, "\u79df\u6237", tenantCode, channelCode, channelName);
                        continue;
                    }
                    if ("busMember".equals(dimcode)) {
                        this.saveOrderForPay(type, dataBmoney, busMember, "\u8fd0\u8425", tenantCode, null, null);
                        this.saveOrderForPay(type, dataBmoney, memberCcode, "\u8fd0\u8425", tenantCode, channelCode, channelName);
                        continue;
                    }
                    if ("memberCode".equals(dimcode)) {
                        this.saveOrderForPay(type, dataBmoney, memberCode, "\u7528\u6237", tenantCode, null, null);
                        this.saveOrderForPay(type, dataBmoney, memberCode, "\u7528\u6237", tenantCode, channelCode, channelName);
                        continue;
                    }
                    if (!"memberCcode".equals(dimcode)) continue;
                    this.saveOrderForPay(type, dataBmoney, memberCcode, "\u95e8\u5e97", tenantCode, null, null);
                    this.saveOrderForPay(type, dataBmoney, memberCcode, "\u95e8\u5e97", tenantCode, channelCode, channelName);
                }
            }
        }
        if (StringUtils.isNotBlank((String)opsetTypeBackStr)) {
            for (String type : opsetTypeBackStr.split("\\,")) {
                if (StringUtils.isBlank((String)opsetTypeBackDimcodeStr)) {
                    this.saveOrderForPay(type, backnum, tenantCode, "\u79df\u6237", tenantCode, null, null);
                    this.saveOrderForPay(type, backnum, busMember, "\u8fd0\u8425", tenantCode, null, null);
                    this.saveOrderForPay(type, backnum, memberCode, "\u7528\u6237", tenantCode, null, null);
                    this.saveOrderForPay(type, backnum, memberCcode, "\u95e8\u5e97", tenantCode, null, null);
                    this.saveOrderForPay(type, backnum, tenantCode, "\u79df\u6237", tenantCode, channelCode, channelName);
                    this.saveOrderForPay(type, backnum, busMember, "\u8fd0\u8425", tenantCode, channelCode, channelName);
                    this.saveOrderForPay(type, backnum, memberCode, "\u7528\u6237", tenantCode, channelCode, channelName);
                    this.saveOrderForPay(type, backnum, memberCcode, "\u95e8\u5e97", tenantCode, channelCode, channelName);
                    continue;
                }
                for (String dimcode : opsetTypeBackDimcodeStr.split("\\,")) {
                    if ("tenantCode".equals(dimcode)) {
                        this.saveOrderForPay(type, backnum, tenantCode, "\u79df\u6237", tenantCode, null, null);
                        this.saveOrderForPay(type, backnum, tenantCode, "\u79df\u6237", tenantCode, channelCode, channelName);
                        continue;
                    }
                    if ("busMember".equals(dimcode)) {
                        this.saveOrderForPay(type, backnum, busMember, "\u8fd0\u8425", tenantCode, null, null);
                        this.saveOrderForPay(type, backnum, busMember, "\u8fd0\u8425", tenantCode, channelCode, channelName);
                        continue;
                    }
                    if ("memberCode".equals(dimcode)) {
                        this.saveOrderForPay(type, backnum, memberCode, "\u7528\u6237", tenantCode, null, null);
                        this.saveOrderForPay(type, backnum, memberCode, "\u7528\u6237", tenantCode, channelCode, channelName);
                        continue;
                    }
                    if (!"memberCcode".equals(dimcode)) continue;
                    this.saveOrderForPay(type, backnum, memberCcode, "\u95e8\u5e97", tenantCode, null, null);
                    this.saveOrderForPay(type, backnum, memberCcode, "\u95e8\u5e97", tenantCode, channelCode, channelName);
                }
            }
        }
        if (StringUtils.isNotBlank((String)opsetTypeMoenyBackStr)) {
            for (String type : opsetTypeMoenyBackStr.split("\\,")) {
                if (StringUtils.isBlank((String)opsetTypeMoenyBackDimcodeStr)) {
                    this.saveOrderForPay(type, backDataBmoney, tenantCode, "\u79df\u6237", tenantCode, null, null);
                    this.saveOrderForPay(type, backDataBmoney, busMember, "\u8fd0\u8425", tenantCode, null, null);
                    this.saveOrderForPay(type, backDataBmoney, memberCode, "\u7528\u6237", tenantCode, null, null);
                    this.saveOrderForPay(type, backDataBmoney, memberCcode, "\u95e8\u5e97", tenantCode, null, null);
                    this.saveOrderForPay(type, backDataBmoney, tenantCode, "\u79df\u6237", tenantCode, channelCode, channelName);
                    this.saveOrderForPay(type, backDataBmoney, busMember, "\u8fd0\u8425", tenantCode, channelCode, channelName);
                    this.saveOrderForPay(type, backDataBmoney, memberCode, "\u7528\u6237", tenantCode, channelCode, channelName);
                    this.saveOrderForPay(type, backDataBmoney, memberCcode, "\u95e8\u5e97", tenantCode, channelCode, channelName);
                    continue;
                }
                for (String dimcode : opsetTypeMoenyBackDimcodeStr.split("\\,")) {
                    if ("tenantCode".equals(dimcode)) {
                        this.saveOrderForPay(type, backDataBmoney, tenantCode, "\u79df\u6237", tenantCode, null, null);
                        this.saveOrderForPay(type, backDataBmoney, tenantCode, "\u79df\u6237", tenantCode, channelCode, channelName);
                        continue;
                    }
                    if ("busMember".equals(dimcode)) {
                        this.saveOrderForPay(type, backDataBmoney, busMember, "\u8fd0\u8425", tenantCode, null, null);
                        this.saveOrderForPay(type, backDataBmoney, busMember, "\u8fd0\u8425", tenantCode, channelCode, channelName);
                        continue;
                    }
                    if ("memberCode".equals(dimcode)) {
                        this.saveOrderForPay(type, backDataBmoney, memberCode, "\u7528\u6237", tenantCode, null, null);
                        this.saveOrderForPay(type, backDataBmoney, memberCode, "\u7528\u6237", tenantCode, null, null);
                        continue;
                    }
                    if (!"memberCcode".equals(dimcode)) continue;
                    this.saveOrderForPay(type, backDataBmoney, memberCcode, "\u95e8\u5e97", tenantCode, null, null);
                    this.saveOrderForPay(type, backDataBmoney, memberCcode, "\u95e8\u5e97", tenantCode, channelCode, channelName);
                }
            }
        }
        return "success";
    }
}

