/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOpsumOrderlistMapper;
import com.yqbsoft.laser.service.data.domain.DaOpsumOrderlistDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsumOrderlistReDomain;
import com.yqbsoft.laser.service.data.domain.DisChannel;
import com.yqbsoft.laser.service.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.data.model.DaOpsumOrderlist;
import com.yqbsoft.laser.service.data.model.OcContract;
import com.yqbsoft.laser.service.data.model.OcContractGoods;
import com.yqbsoft.laser.service.data.model.OcPackage;
import com.yqbsoft.laser.service.data.model.SgSendgoodsGoods;
import com.yqbsoft.laser.service.data.service.DaOpsumOrderlistService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaOpsumOrderlistServiceImpl
extends BaseServiceImpl
implements DaOpsumOrderlistService {
    private static final String SYS_CODE = "da.DaOpsumOrderlistServiceImpl";
    private DaOpsumOrderlistMapper daOpsumOrderlistMapper;

    public void setDaOpsumOrderlistMapper(DaOpsumOrderlistMapper daOpsumOrderlistMapper) {
        this.daOpsumOrderlistMapper = daOpsumOrderlistMapper;
    }

    private Date getSysDate() {
        try {
            return this.daOpsumOrderlistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOpsumOrderList(DaOpsumOrderlistDomain daOpsumOrderlistDomain) {
        if (null == daOpsumOrderlistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOpsumOrderlistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpsumOrderListDefault(DaOpsumOrderlist daOpsumOrderlist) {
        if (null == daOpsumOrderlist) {
            return;
        }
        if (null == daOpsumOrderlist.getDataState()) {
            daOpsumOrderlist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOpsumOrderlist.getGmtCreate()) {
            daOpsumOrderlist.setGmtCreate(date);
        }
        daOpsumOrderlist.setGmtModified(date);
        if (StringUtils.isBlank((String)daOpsumOrderlist.getOpsumOrderlistCode())) {
            daOpsumOrderlist.setOpsumOrderlistCode(this.getNo(null, "DaOpsumOrderlist", "daOpsumOrderlist", daOpsumOrderlist.getTenantCode()));
        }
    }

    private int getOpsumOrderListMaxCode() {
        int code = 0;
        try {
            return this.daOpsumOrderlistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.getOpsumOrderListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpsumOrderListUpdataDefault(DaOpsumOrderlist daOpsumOrderlist) {
        if (null == daOpsumOrderlist) {
            return;
        }
        daOpsumOrderlist.setGmtModified(this.getSysDate());
    }

    private void saveOpsumOrderListModel(DaOpsumOrderlist daOpsumOrderlist) throws ApiException {
        if (null == daOpsumOrderlist) {
            return;
        }
        try {
            this.daOpsumOrderlistMapper.insert(daOpsumOrderlist);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.saveOpsumOrderListModel.ex", (Throwable)e);
        }
    }

    private void saveOpsumOrderListBatchModel(List<DaOpsumOrderlist> daOpsumOrderlistList) throws ApiException {
        if (null == daOpsumOrderlistList || daOpsumOrderlistList.isEmpty()) {
            return;
        }
        try {
            this.daOpsumOrderlistMapper.insertBatch(daOpsumOrderlistList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.saveOpsumOrderListBatchModel.ex", (Throwable)e);
        }
    }

    private DaOpsumOrderlist getOpsumOrderListModelById(Integer opsumOrderlistId) {
        if (null == opsumOrderlistId) {
            return null;
        }
        try {
            return this.daOpsumOrderlistMapper.selectByPrimaryKey(opsumOrderlistId);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.getOpsumOrderListModelById", (Throwable)e);
            return null;
        }
    }

    private DaOpsumOrderlist getOpsumOrderListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daOpsumOrderlistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.getOpsumOrderListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpsumOrderListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumOrderlistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.delOpsumOrderListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.delOpsumOrderListModelByCode.num");
        }
    }

    private void deleteOpsumOrderListModel(Integer opsumOrderlistId) throws ApiException {
        if (null == opsumOrderlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumOrderlistMapper.deleteByPrimaryKey(opsumOrderlistId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.deleteOpsumOrderListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.deleteOpsumOrderListModel.num");
        }
    }

    private void updateOpsumOrderListModel(DaOpsumOrderlist daOpsumOrderlist) throws ApiException {
        if (null == daOpsumOrderlist) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsumOrderlistMapper.updateByPrimaryKey(daOpsumOrderlist);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateOpsumOrderListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateOpsumOrderListModel.num");
        }
    }

    private void updateStateOpsumOrderListModel(Integer opsumOrderlistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opsumOrderlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opsumOrderlistId", opsumOrderlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOpsumOrderlistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateStateOpsumOrderListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateStateOpsumOrderListModel.null");
        }
    }

    private void updateStateOpsumOrderListModelByCode(String tenantCode, String opsumOrderlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opsumOrderlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumOrderlistCode", opsumOrderlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOpsumOrderlistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateStateOpsumOrderListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateStateOpsumOrderListModelByCode.null");
        }
    }

    private DaOpsumOrderlist makeOpsumOrderList(DaOpsumOrderlistDomain daOpsumOrderlistDomain, DaOpsumOrderlist daOpsumOrderlist) {
        if (null == daOpsumOrderlistDomain) {
            return null;
        }
        if (null == daOpsumOrderlist) {
            daOpsumOrderlist = new DaOpsumOrderlist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumOrderlist, (Object)daOpsumOrderlistDomain);
            return daOpsumOrderlist;
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.makeOpsumOrderList", (Throwable)e);
            return null;
        }
    }

    private DaOpsumOrderlistReDomain makeDaOpsumOrderlistReDomain(DaOpsumOrderlist daOpsumOrderlist) {
        if (null == daOpsumOrderlist) {
            return null;
        }
        DaOpsumOrderlistReDomain daOpsumOrderlistReDomain = new DaOpsumOrderlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumOrderlistReDomain, (Object)daOpsumOrderlist);
            return daOpsumOrderlistReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.makeDaOpsumOrderlistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaOpsumOrderlist> queryOpsumOrderListModelPage(Map<String, Object> parammap) {
        try {
            return this.daOpsumOrderlistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.queryOpsumOrderListModel", (Throwable)e);
            return null;
        }
    }

    private int countOpsumOrderList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOpsumOrderlistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.countOpsumOrderList", (Throwable)e);
        }
        return i;
    }

    private DaOpsumOrderlist createDaOpsumOrderlist(DaOpsumOrderlistDomain daOpsumOrderlistDomain) {
        String msg = this.checkOpsumOrderList(daOpsumOrderlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.saveOpsumOrderList.checkOpsumOrderList", msg);
        }
        DaOpsumOrderlist daOpsumOrderlist = this.makeOpsumOrderList(daOpsumOrderlistDomain, null);
        this.setOpsumOrderListDefault(daOpsumOrderlist);
        return daOpsumOrderlist;
    }

    @Override
    public String saveOpsumOrderList(DaOpsumOrderlistDomain daOpsumOrderlistDomain) throws ApiException {
        DaOpsumOrderlist daOpsumOrderlist = this.createDaOpsumOrderlist(daOpsumOrderlistDomain);
        this.saveOpsumOrderListModel(daOpsumOrderlist);
        return daOpsumOrderlist.getOpsumOrderlistCode();
    }

    @Override
    public String saveOpsumOrderListBatch(List<DaOpsumOrderlistDomain> daOpsumOrderlistDomainList) throws ApiException {
        if (null == daOpsumOrderlistDomainList || daOpsumOrderlistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaOpsumOrderlist> daOpsumOrderlistList = new ArrayList<DaOpsumOrderlist>();
        String code = "";
        for (DaOpsumOrderlistDomain daOpsumOrderlistDomain : daOpsumOrderlistDomainList) {
            DaOpsumOrderlist daOpsumOrderlist = this.createDaOpsumOrderlist(daOpsumOrderlistDomain);
            code = daOpsumOrderlist.getOpsumOrderlistCode();
            daOpsumOrderlistList.add(daOpsumOrderlist);
        }
        this.saveOpsumOrderListBatchModel(daOpsumOrderlistList);
        return code;
    }

    @Override
    public void updateOpsumOrderListState(Integer opsumOrderlistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opsumOrderlistId) {
            return;
        }
        this.updateStateOpsumOrderListModel(opsumOrderlistId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpsumOrderListStateByCode(String tenantCode, String opsumOrderlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opsumOrderlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOpsumOrderListModelByCode(tenantCode, opsumOrderlistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpsumOrderList(DaOpsumOrderlistDomain daOpsumOrderlistDomain) throws ApiException {
        String msg = this.checkOpsumOrderList(daOpsumOrderlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateOpsumOrderList.checkOpsumOrderList", msg);
        }
        DaOpsumOrderlist oldDaOpsumOrderlist = this.getOpsumOrderListModelById(daOpsumOrderlistDomain.getOpsumOrderlistId());
        if (null == oldDaOpsumOrderlist) {
            throw new ApiException("da.DaOpsumOrderlistServiceImpl.updateOpsumOrderList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaOpsumOrderlist daOpsumOrderlist = this.makeOpsumOrderList(daOpsumOrderlistDomain, oldDaOpsumOrderlist);
        this.setOpsumOrderListUpdataDefault(daOpsumOrderlist);
        this.updateOpsumOrderListModel(daOpsumOrderlist);
    }

    @Override
    public DaOpsumOrderlist getOpsumOrderList(Integer opsumOrderlistId) {
        if (null == opsumOrderlistId) {
            return null;
        }
        return this.getOpsumOrderListModelById(opsumOrderlistId);
    }

    @Override
    public void deleteOpsumOrderList(Integer opsumOrderlistId) throws ApiException {
        if (null == opsumOrderlistId) {
            return;
        }
        this.deleteOpsumOrderListModel(opsumOrderlistId);
    }

    @Override
    public QueryResult<DaOpsumOrderlist> queryOpsumOrderListPage(Map<String, Object> map) {
        List<DaOpsumOrderlist> daOpsumOrderlistList = this.queryOpsumOrderListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpsumOrderList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOpsumOrderlistList);
        return queryResult;
    }

    @Override
    public DaOpsumOrderlist getOpsumOrderListByCode(String tenantCode, String opsumOrderlistCode) throws ApiException {
        if (StringUtils.isBlank((String)opsumOrderlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumOrderlistCode", opsumOrderlistCode);
        return this.getOpsumOrderListModelByCode(map);
    }

    @Override
    public void deleteOpsumOrderListByCode(String tenantCode, String opsumOrderlistCode) throws ApiException {
        if (StringUtils.isBlank((String)opsumOrderlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumOrderlistCode", opsumOrderlistCode);
        this.delOpsumOrderListModelByCode(map);
    }

    protected String getBusMember(String channelCode, String tenantCode) {
        DisChannel disChannel;
        String busMember = "";
        if (StringUtils.isNotBlank((String)channelCode) && null != (disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class))) {
            busMember = disChannel.getMemberCode();
        }
        if (StringUtils.isBlank((String)busMember)) {
            busMember = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        }
        return busMember;
    }

    @Override
    public String saveOrderAll(Map<String, Object> map) throws ApiException {
        return null;
    }

    @Override
    public String orderInfo(OcContractReDomain ocContractDomain) throws ApiException {
        this.logger.error("da.DaOpsumOrderlistServiceImpl.queryOpsumOrderListModel", (Object)("ocContractReDomain is" + ocContractDomain));
        if (ocContractDomain == null) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.queryOpsumOrderListModel", (Object)("ocContractReDomain is" + ocContractDomain));
            return "error";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", ocContractDomain.getTenantCode());
        paramMap.put("opsetDatacode1", ocContractDomain.getGoodsList().get(0).getMemberMcode());
        boolean flag1 = true;
        boolean flag2 = true;
        boolean flag3 = true;
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            this.updateOrSaveAll(paramMap, ocContractDomain, ocContractGoodsDomain, flag1);
            paramMap.remove("opsetDatacode");
            if (!ocContractGoodsDomain.getMemberCcode().equals("10000210370767")) {
                paramMap.put("opsumCode", "-1");
                this.saveOrUpdateOther(paramMap, ocContractDomain, ocContractGoodsDomain, flag2);
                this.creatAllDataByDay(ocContractGoodsDomain, ocContractDomain, flag3);
                flag2 = false;
                flag3 = false;
                continue;
            }
            paramMap.put("opsumCode", ocContractGoodsDomain.getMemberCcode());
            Date gmtCreate = ocContractDomain.getGmtCreate();
            Map<String, Object> dataMap = this.getDataMap(gmtCreate);
            for (String strKey : dataMap.keySet()) {
                paramMap.put("opsetDatacode2", dataMap.get(strKey));
                paramMap.put("opsetDatacode", "NOT-ALL");
                for (String qua : this.getQuaList()) {
                    paramMap.put("opsetDatacode3", qua);
                    QueryResult<DaOpsumOrderlist> queryResult = this.queryOpsumOrderListPage(paramMap);
                    if (ListUtil.isEmpty((Collection)queryResult.getList())) {
                        this.saveNewDataInfo(ocContractDomain, strKey, ocContractGoodsDomain, qua, false);
                        continue;
                    }
                    DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)queryResult.getList().get(0);
                    DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
                    DaOpsumOrderlist daOpsumOrderlist1 = this.buildDa(daOpsumOrderlist, ocContractDomain, ocContractGoodsDomain, flag1);
                    try {
                        BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.updateOpsumOrderList(daOpsumOrderlistDomain);
                }
                this.creatStoreDate(ocContractGoodsDomain, dataMap);
            }
            this.updateOrSaveAllInfo(paramMap, ocContractDomain, ocContractGoodsDomain, flag1);
            this.creatAllDataByDay(ocContractGoodsDomain, ocContractDomain, flag3);
            flag1 = false;
            flag3 = false;
        }
        int day = DateUtil.getDay((Date)ocContractDomain.getGmtCreate());
        if (day == 1) {
            this.creatLastMonthData(ocContractDomain);
        }
        return "success";
    }

    public void creatAllDataByDay(OcContractGoodsDomain ocContractGoodsDomain, OcContractReDomain ocContractReDomain, boolean flag) {
        this.logger.error("da.DaOpsumOrderlistServiceImpl.creatAllDataByDay", (Object)("ocContractGoodsDomain is " + ocContractGoodsDomain));
        List<String> quaList = this.getQuaList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String dateString = DateUtil.getDateString((Date)ocContractReDomain.getGmtCreate(), (String)"yyyy-MM-dd");
        for (String qua : quaList) {
            QueryResult<DaOpsumOrderlist> queryResult;
            List list;
            paramMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            paramMap.put("opsumCode", "ALL-DATA");
            paramMap.put("opsetDatacode3", qua);
            paramMap.put("opsetDatacode2", dateString);
            if (qua.equals("retail")) {
                paramMap.put("OpsetDatacode1", ocContractGoodsDomain.getMemberMcode());
            }
            if (ListUtil.isEmpty((Collection)(list = (queryResult = this.queryOpsumOrderListPage(paramMap)).getList()))) {
                this.saveAllDataParam(ocContractGoodsDomain, qua, dateString, ocContractReDomain);
                continue;
            }
            DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)list.get(0);
            DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
            DaOpsumOrderlist daOpsumOrderlist1 = this.buildAllDataParam(daOpsumOrderlist, ocContractGoodsDomain, qua, dateString, ocContractReDomain, flag);
            if (daOpsumOrderlist1 == null) {
                this.logger.error("da.DaOpsumOrderlistServiceImpl.queryOpsumOrderListModel", (Object)"daOpsumOrderlist1 is null");
                continue;
            }
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.logger.error("da.DaOpsumOrderlistServiceImpl.creatAllDataByDay", (Object)("daOpsumOrderlistDomain is" + daOpsumOrderlistDomain));
            this.updateOpsumOrderList(daOpsumOrderlistDomain);
        }
    }

    public void saveAllDataParam(OcContractGoodsDomain ocContractGoodsDomain, String qua, String dayTime, OcContractReDomain ocContractReDomain) {
        DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
        daOpsumOrderlistDomain.setOpsumCode("ALL-DATA");
        daOpsumOrderlistDomain.setTenantCode(ocContractGoodsDomain.getTenantCode());
        daOpsumOrderlistDomain.setOpsetDatacode3(qua);
        daOpsumOrderlistDomain.setOpsetDatacode2(dayTime);
        if (qua.equals("retail")) {
            daOpsumOrderlistDomain.setOpsetDatacode1(ocContractGoodsDomain.getMemberMcode());
        }
        daOpsumOrderlistDomain.setOpsumListNum2(new BigDecimal(1));
        HashMap<String, BigDecimal> jsonToMap = new HashMap<String, BigDecimal>();
        jsonToMap.put("contractMoney", ocContractGoodsDomain.getContractGoodsMoney());
        String memberBcode = ocContractReDomain.getGoodsList().get(0).getMemberBcode();
        SupDisUtil.set((String)("memberMcode" + ocContractReDomain.getMemberMcode()), (String)memberBcode, (int)this.getMillis());
        HashMap<String, BigDecimal> paramMap = new HashMap<String, BigDecimal>();
        paramMap.put("contractStore", new BigDecimal(1));
        daOpsumOrderlistDomain.setOpsetDatavalue(JsonUtil.buildNonDefaultBinder().toJson(jsonToMap));
        daOpsumOrderlistDomain.setOpsetDatavalue1(JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        this.saveOpsumOrderList(daOpsumOrderlistDomain);
    }

    public DaOpsumOrderlist buildAllDataParam(DaOpsumOrderlist daOpsumOrderlist, OcContractGoodsDomain ocContractGoodsDomain, String qua, String dayTime, OcContractReDomain ocContractReDomain, boolean flag) {
        if (flag) {
            BigDecimal opsumListNum2 = daOpsumOrderlist.getOpsumListNum2();
            BigDecimal addOrderNum = opsumListNum2.add(new BigDecimal(1));
            daOpsumOrderlist.setOpsumListNum2(addOrderNum);
        }
        String opsetDatavalue = daOpsumOrderlist.getOpsetDatavalue();
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(opsetDatavalue, String.class, Object.class);
        if (jsonToMap.containsKey("contractMoney")) {
            BigDecimal bigDecimal = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("contractMoney"))));
            BigDecimal contractMoney = bigDecimal.add(ocContractGoodsDomain.getContractGoodsMoney());
            jsonToMap.put("contractMoney", contractMoney);
        } else {
            jsonToMap.put("contractMoney", ocContractGoodsDomain.getContractGoodsMoney());
        }
        String opsetDatavalue1 = daOpsumOrderlist.getOpsetDatavalue1();
        Map paramMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(opsetDatavalue1, String.class, Object.class);
        String memberBcode = ocContractReDomain.getGoodsList().get(0).getMemberBcode();
        if (paramMap.containsKey("contractStore")) {
            BigDecimal contractStore = new BigDecimal(Double.valueOf(String.valueOf(paramMap.get("contractStore"))));
            String strValue = SupDisUtil.getRemot((String)("memberMcode-AllData-" + ocContractGoodsDomain.getMemberMcode()));
            this.logger.error("da.DaOpsumOrderlistServiceImpl.updateAllDataParam", (Object)("strValue is " + strValue + "=======> key =:=memberMcode-AllData-" + ocContractGoodsDomain.getMemberMcode()));
            if (strValue != null && !strValue.contains(memberBcode)) {
                BigDecimal addResult = contractStore.add(new BigDecimal(1));
                paramMap.put("contractStore", addResult);
                String str = strValue + "," + memberBcode;
                SupDisUtil.set((String)("memberMcode-AllData-" + ocContractGoodsDomain.getMemberMcode()), (String)str, (int)this.getMillis());
            }
        } else {
            SupDisUtil.set((String)("memberMcode" + memberBcode), (String)memberBcode);
            paramMap.put("contractStore", new BigDecimal(1));
        }
        daOpsumOrderlist.setOpsetDatavalue(JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToMap));
        daOpsumOrderlist.setOpsetDatavalue1(JsonUtil.buildNonDefaultBinder().toJson((Object)paramMap));
        return daOpsumOrderlist;
    }

    public void creatLastMonthData(OcContractReDomain ocContractDomain) {
        Map<String, Object> dataMap = this.getDataMap(ocContractDomain.getGmtCreate());
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("opsetDatacode1", ocContractDomain.getMemberMcode());
        queryMap.put("opsetDatacode3", "MONTHU_RE");
        queryMap.put("tenantCode", ocContractDomain.getTenantCode());
        QueryResult<DaOpsumOrderlist> queryResult = this.queryOpsumOrderListPage(queryMap);
        String lastMonth = DateUtil.getAfterMonth((String)String.valueOf(dataMap.get("date")), (int)-1, (String)"yyyy-MM");
        HashMap<String, Object> queryLastMonthMap = new HashMap<String, Object>();
        queryLastMonthMap.put("opsumCode", ocContractDomain.getMemberCcode());
        queryLastMonthMap.put("tenantCode", ocContractDomain.getTenantCode());
        queryLastMonthMap.put("opsetDatacode", "NOT-ALL");
        queryLastMonthMap.put("opsetDatacode2", lastMonth);
        QueryResult<DaOpsumOrderlist> lastMonthResult = this.queryOpsumOrderListPage(queryLastMonthMap);
        if (ListUtil.isEmpty((Collection)lastMonthResult.getList())) {
            return;
        }
        DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)lastMonthResult.getList().get(0);
        String opsetDatavalue = daOpsumOrderlist.getOpsetDatavalue();
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(opsetDatavalue, String.class, Object.class);
        if (!jsonToMap.containsKey("GIV")) {
            return;
        }
        BigDecimal GIV = new BigDecimal(String.valueOf(jsonToMap.get("GIV")));
        if (ListUtil.isEmpty((Collection)queryResult.getList())) {
            DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
            daOpsumOrderlistDomain.setTenantCode(ocContractDomain.getTenantCode());
            daOpsumOrderlistDomain.setOpsetDatacode3("MONTHU_RE");
            daOpsumOrderlistDomain.setOpsetDatacode1(ocContractDomain.getMemberMcode());
            daOpsumOrderlistDomain.setOpsumListNum(GIV);
            daOpsumOrderlistDomain.setOpsumListNum1(new BigDecimal(1));
            this.saveOpsumOrderList(daOpsumOrderlistDomain);
        } else {
            DaOpsumOrderlist rawData = (DaOpsumOrderlist)queryResult.getList().get(0);
            BigDecimal opsumListNum = rawData.getOpsumListNum();
            BigDecimal addResult = opsumListNum.add(GIV);
            rawData.setOpsumListNum(addResult);
            BigDecimal opsumListNum1 = rawData.getOpsumListNum1();
            BigDecimal monthNum = opsumListNum1.add(new BigDecimal(1));
            rawData.setOpsumListNum1(monthNum);
            DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)rawData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateOpsumOrderList(daOpsumOrderlistDomain);
        }
    }

    public void creatPLatDate(OcContractGoodsDomain ocContractGoodsDomain, Map<String, Object> dataMap, OcContractReDomain ocContractReDomain) {
        if (ocContractGoodsDomain == null || ocContractGoodsDomain.getMemberBcode() == null) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
        paramMap.put("opsumCode", "plat");
        for (String key : dataMap.keySet()) {
            paramMap.put("opsetDatacode2", dataMap.get(key));
            List list = this.queryOpsumOrderListPage(paramMap).getList();
            if (ListUtil.isEmpty((Collection)list)) {
                this.logger.error("da.DaOpsumOrderlistServiceImpl.queryOpsumOrderListModel", (Object)"list is null");
                this.saveNewDataInfo(ocContractReDomain, key, ocContractGoodsDomain, "plat", false);
                continue;
            }
            DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)list.get(0);
            BigDecimal opsumListNum = daOpsumOrderlist.getOpsumListNum();
            DaOpsumOrderlist daOpsumOrderlist1 = this.buildDa(daOpsumOrderlist, ocContractReDomain, ocContractGoodsDomain, true);
            DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.logger.error("da.DaOpsumOrderlistServiceImpl.queryOpsumOrderListModel", (Object)("daOpsumOrderlistDomain is" + daOpsumOrderlistDomain));
            this.updateOpsumOrderList(daOpsumOrderlistDomain);
        }
    }

    public void savePlatDate(OcContractGoodsDomain ocContractGoodsDomain) {
        DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
        daOpsumOrderlistDomain.setOpsetDatacode3("plat");
        if (ocContractGoodsDomain.getMemberCcode().equals("10000210370767")) {
            daOpsumOrderlistDomain.setOpsumCode("10000210370767");
        } else {
            daOpsumOrderlistDomain.setOpsumCode("-1");
        }
        daOpsumOrderlistDomain.setTenantCode(ocContractGoodsDomain.getTenantCode());
        daOpsumOrderlistDomain.setOpsumListNum(ocContractGoodsDomain.getContractGoodsInmoney());
        this.saveOpsumOrderList(daOpsumOrderlistDomain);
    }

    public void creatStoreDate(OcContractGoodsDomain ocContractGoodsDomain, Map dateMap) {
        if (ocContractGoodsDomain == null || ocContractGoodsDomain.getMemberBcode() == null) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
        paramMap.put("opsetDatacode1", ocContractGoodsDomain.getMemberBcode());
        paramMap.put("opsetDatacode2", String.valueOf(dateMap.get("month")));
        paramMap.put("opsumCode", ocContractGoodsDomain.getMemberMcode());
        paramMap.put("opsetDatacode3", "dealer");
        List list = this.queryOpsumOrderListPage(paramMap).getList();
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.queryOpsumOrderListModel", (Object)"list is null");
            this.saveStoreDate(ocContractGoodsDomain, dateMap);
            return;
        }
        DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)list.get(0);
        BigDecimal opsumListNum = daOpsumOrderlist.getOpsumListNum();
        BigDecimal addMoney = opsumListNum.add(ocContractGoodsDomain.getContractGoodsInmoney());
        daOpsumOrderlist.setOpsumListNum(addMoney);
        DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.error("da.DaOpsumOrderlistServiceImpl.queryOpsumOrderListModel", (Object)("daOpsumOrderlistDomain is" + daOpsumOrderlistDomain));
        this.updateOpsumOrderList(daOpsumOrderlistDomain);
    }

    public void saveStoreDate(OcContractGoodsDomain ocContractGoodsDomain, Map dateMap) {
        DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
        daOpsumOrderlistDomain.setOpsumCode(ocContractGoodsDomain.getMemberMcode());
        daOpsumOrderlistDomain.setOpsetDatacode1(ocContractGoodsDomain.getMemberBcode());
        daOpsumOrderlistDomain.setTenantCode(ocContractGoodsDomain.getTenantCode());
        daOpsumOrderlistDomain.setOpsetDatacode2(String.valueOf(dateMap.get("month")));
        daOpsumOrderlistDomain.setOpsetDatacode3("dealer");
        daOpsumOrderlistDomain.setOpsumListNum(ocContractGoodsDomain.getContractGoodsInmoney());
        daOpsumOrderlistDomain.setOpsumOrderlistCode("store" + String.valueOf(dateMap.get("month")));
        this.saveOpsumOrderList(daOpsumOrderlistDomain);
    }

    public void updateOrSaveAllInfo(Map paramMap, OcContractReDomain ocContractReDomain, OcContractGoodsDomain ocContractGoodsDomain, boolean flag) {
        List<String> quaList = this.getQuaList();
        for (String str : quaList) {
            paramMap.put("opsetDatacode", "SUP-ALL");
            paramMap.remove("opsetDatacode2");
            paramMap.put("opsetDatacode3", str);
            QueryResult<DaOpsumOrderlist> queryResult = this.queryOpsumOrderListPage(paramMap);
            if (ListUtil.isEmpty((Collection)queryResult.getList())) {
                this.saveNewDataInfo(ocContractReDomain, null, ocContractGoodsDomain, str, false);
                continue;
            }
            DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)queryResult.getList().get(0);
            DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
            DaOpsumOrderlist daOpsumOrderlist1 = this.buildDa(daOpsumOrderlist, ocContractReDomain, ocContractGoodsDomain, flag);
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateOpsumOrderList(daOpsumOrderlistDomain);
        }
    }

    public void updateOrSaveAll(Map paramMap, OcContractReDomain ocContractReDomain, OcContractGoodsDomain ocContractGoodsDomain, boolean flag) {
        List<String> quaList = this.getQuaList();
        for (String str : quaList) {
            paramMap.put("opsetDatacode", "TOTAL-ALL");
            paramMap.remove("opsetDatacode2");
            paramMap.put("opsumCode", "ALL");
            paramMap.put("opsetDatacode3", str);
            QueryResult<DaOpsumOrderlist> queryResult = this.queryOpsumOrderListPage(paramMap);
            if (ListUtil.isEmpty((Collection)queryResult.getList())) {
                this.saveNewDataInfo(ocContractReDomain, null, ocContractGoodsDomain, str, true);
                continue;
            }
            DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)queryResult.getList().get(0);
            DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
            DaOpsumOrderlist daOpsumOrderlist1 = this.buildDa(daOpsumOrderlist, ocContractReDomain, ocContractGoodsDomain, flag);
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateOpsumOrderList(daOpsumOrderlistDomain);
            this.logger.error("da.DaOpsumOrderlistServiceImpl.updateOrSaveAll", (Object)"update success");
        }
    }

    public void saveOrUpdateOther(Map paramMap, OcContractReDomain ocContractReDomain, OcContractGoodsDomain ocContractGoodsDomain, boolean flag) {
        for (String qua : this.getQuaList()) {
            paramMap.put("opsetDatacode3", qua);
            if (qua.equals("plat")) {
                paramMap.remove("opsetDatacode1");
            } else {
                paramMap.put("opsetDatacode1", ocContractGoodsDomain.getMemberMcode());
            }
            QueryResult<DaOpsumOrderlist> queryResult = this.queryOpsumOrderListPage(paramMap);
            if (ListUtil.isEmpty((Collection)queryResult.getList())) {
                this.logger.error("da.DaOpsumOrderlistServiceImpl.saveOrUpdateOther", (Object)("queryResult is null===>paramMap is" + paramMap));
                this.saveNewDataInfo(ocContractReDomain, null, ocContractGoodsDomain, qua, false);
                continue;
            }
            DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)queryResult.getList().get(0);
            DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
            DaOpsumOrderlist daOpsumOrderlist1 = this.buildDa(daOpsumOrderlist, ocContractReDomain, ocContractGoodsDomain, flag);
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateOpsumOrderList(daOpsumOrderlistDomain);
        }
    }

    public DaOpsumOrderlist buildDa(DaOpsumOrderlist daOpsumOrderlist, OcContractReDomain ocContractReDomain, OcContractGoodsDomain ocContractGoodsDomain, boolean flag) {
        BigDecimal addResult;
        BigDecimal bigDecimal;
        String goodsOrigin = ocContractGoodsDomain.getGoodsOrigin();
        if (StringUtils.isNotBlank((String)goodsOrigin) && goodsOrigin.equals("8")) {
            String contractBillcode = ocContractReDomain.getContractBillcode();
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("contractBillcode", contractBillcode);
            queryMap.put("tenantCode", ocContractReDomain.getTenantCode());
            HashMap<String, String> invokeMap = new HashMap<String, String>();
            invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryMap));
            QueryResult queryResutl = this.getQueryResutl("sg.sendgoods.querySendgoodsGoodsPage", invokeMap, SgSendgoodsGoods.class);
            List sgList = queryResutl.getList();
            if (ListUtil.isEmpty((Collection)sgList)) {
                this.logger.error("da.DaOpsumOrderlistServiceImpl.saveNewDataInfo", (Object)("sgList is null ======>param is " + queryMap));
                return null;
            }
            for (SgSendgoodsGoods sgSendgoodsGoods : sgList) {
                DaOpsumOrderlist daOpsumOrderlist1 = this.buildUpdateCombinedGoods(daOpsumOrderlist, ocContractReDomain, sgSendgoodsGoods, flag);
                if (daOpsumOrderlist1 != null) continue;
            }
        }
        BigDecimal opsumListNum1 = daOpsumOrderlist.getOpsumListNum1();
        BigDecimal opsumListNum = opsumListNum1.add(ocContractGoodsDomain.getContractGoodsInmoney());
        daOpsumOrderlist.setOpsumListNum1(opsumListNum);
        if (flag) {
            BigDecimal opsumListNum2 = daOpsumOrderlist.getOpsumListNum2();
            BigDecimal orderNum = opsumListNum2.add(new BigDecimal(1));
            daOpsumOrderlist.setOpsumListNum2(orderNum);
        }
        BigDecimal opsumListNum3 = daOpsumOrderlist.getOpsumListNum();
        BigDecimal subtract = ocContractGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsPrice());
        BigDecimal discountPrice = subtract.multiply(ocContractGoodsDomain.getGoodsNum());
        BigDecimal goodsPmoney = opsumListNum3.add(discountPrice);
        daOpsumOrderlist.setOpsumListNum(goodsPmoney);
        String opsetDatavalue = daOpsumOrderlist.getOpsetDatavalue();
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(opsetDatavalue, String.class, Object.class);
        if (jsonToMap.containsKey("GIV")) {
            BigDecimal addResult2 = bigDecimal = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("GIV"))));
            BigDecimal multiply = ocContractGoodsDomain.getGoodsNum().multiply(ocContractGoodsDomain.getPricesetBaseprice());
            addResult2 = addResult2.add(multiply);
            jsonToMap.put("GIV", addResult2);
        } else {
            BigDecimal addResult3 = new BigDecimal(0);
            BigDecimal multiply = ocContractGoodsDomain.getGoodsNum().multiply(ocContractGoodsDomain.getPricesetBaseprice());
            addResult3 = addResult3.add(multiply);
            jsonToMap.put("GIV", addResult3);
        }
        if (jsonToMap.containsKey("contractMoney")) {
            bigDecimal = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("contractMoney"))));
            BigDecimal contractMoney = bigDecimal.add(ocContractGoodsDomain.getContractGoodsMoney());
            jsonToMap.put("contractMoney", contractMoney);
        } else {
            jsonToMap.put("contractMoney", ocContractGoodsDomain.getContractGoodsMoney());
        }
        String memberBcode = ocContractReDomain.getGoodsList().get(0).getMemberBcode();
        HashMap<String, BigDecimal> paramMap = new HashMap<String, BigDecimal>();
        if (jsonToMap.containsKey("contractStore")) {
            BigDecimal contractStore = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("contractStore"))));
            String strValue = SupDisUtil.getRemot((String)("memberMcode" + ocContractGoodsDomain.getMemberMcode()));
            if (!strValue.contains(memberBcode)) {
                addResult = contractStore.add(new BigDecimal(1));
                paramMap.put("contractStore", addResult);
                String str = strValue + "," + memberBcode;
                SupDisUtil.set((String)("memberMcode" + ocContractGoodsDomain.getMemberMcode()), (String)str, (int)this.getMillis());
            }
        } else {
            SupDisUtil.set((String)("memberMcode" + memberBcode), (String)memberBcode);
            paramMap.put("contractStore", new BigDecimal(1));
        }
        String strValue = SupDisUtil.getRemot((String)("memberMcode" + ocContractGoodsDomain.getMemberMcode()));
        this.logger.error("da.DaOpsumOrderlistServiceImpl.buildDa", (Object)("strValue is" + strValue));
        if (StringUtils.isNotBlank((String)strValue) && strValue.contains(memberBcode)) {
            if (jsonToMap.containsKey("buyBackStore")) {
                BigDecimal contractStore = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("contractStore"))));
                addResult = contractStore.add(new BigDecimal(1));
                paramMap.put("buyBackStore", addResult);
            }
        } else {
            paramMap.put("buyBackStore", new BigDecimal(1));
        }
        daOpsumOrderlist.setOpsetDatavalue(JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToMap));
        daOpsumOrderlist.setOpsetDatavalue1(JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        return daOpsumOrderlist;
    }

    public Map<String, Object> getDataMap(Date data) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sdf.format(data);
        String[] split = dateStr.split("-");
        HashMap<String, Object> dateMap = new HashMap<String, Object>();
        dateMap.put("year", split[0]);
        dateMap.put("month", split[0] + "-" + split[1]);
        dateMap.put("date", dateStr);
        return dateMap;
    }

    public DaOpsumOrderlist buildUpdateCombinedGoods(DaOpsumOrderlist daOpsumOrderlist, OcContractReDomain ocContractReDomain, SgSendgoodsGoods sgSendgoodsGoods, boolean flag) {
        BigDecimal addResult;
        BigDecimal bigDecimal;
        BigDecimal opsumListNum1 = daOpsumOrderlist.getOpsumListNum1();
        BigDecimal opsumListNum = opsumListNum1.add(sgSendgoodsGoods.getContractGoodsInmoney());
        daOpsumOrderlist.setOpsumListNum1(opsumListNum);
        if (flag) {
            BigDecimal opsumListNum2 = daOpsumOrderlist.getOpsumListNum2();
            BigDecimal orderNum = opsumListNum2.add(new BigDecimal(1));
            daOpsumOrderlist.setOpsumListNum2(orderNum);
        }
        BigDecimal opsumListNum3 = daOpsumOrderlist.getOpsumListNum();
        BigDecimal subtract = sgSendgoodsGoods.getPricesetNprice().subtract(sgSendgoodsGoods.getContractGoodsPrice());
        BigDecimal discountPrice = subtract.multiply(sgSendgoodsGoods.getGoodsNum());
        BigDecimal goodsPmoney = opsumListNum3.add(discountPrice);
        daOpsumOrderlist.setOpsumListNum(goodsPmoney);
        String opsetDatavalue = daOpsumOrderlist.getOpsetDatavalue();
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(opsetDatavalue, String.class, Object.class);
        if (jsonToMap.containsKey("GIV")) {
            BigDecimal addResult2 = bigDecimal = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("GIV"))));
            BigDecimal multiply = sgSendgoodsGoods.getGoodsNum().multiply(sgSendgoodsGoods.getContractGoodsMoney());
            addResult2 = addResult2.add(multiply);
            jsonToMap.put("GIV", addResult2);
        } else {
            BigDecimal addResult3 = new BigDecimal(0);
            BigDecimal multiply = sgSendgoodsGoods.getGoodsNum().multiply(sgSendgoodsGoods.getContractGoodsMoney());
            addResult3 = addResult3.add(multiply);
            jsonToMap.put("GIV", addResult3);
        }
        if (jsonToMap.containsKey("contractMoney")) {
            bigDecimal = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("contractMoney"))));
            BigDecimal contractMoney = bigDecimal.add(sgSendgoodsGoods.getContractGoodsMoney());
            jsonToMap.put("contractMoney", contractMoney);
        } else {
            jsonToMap.put("contractMoney", sgSendgoodsGoods.getContractGoodsMoney());
        }
        String memberBcode = ocContractReDomain.getGoodsList().get(0).getMemberBcode();
        HashMap<String, BigDecimal> paramMap = new HashMap<String, BigDecimal>();
        if (jsonToMap.containsKey("contractStore")) {
            BigDecimal contractStore = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("contractStore"))));
            String strValue = SupDisUtil.getRemot((String)("memberMcode" + sgSendgoodsGoods.getMemberMcode()));
            if (!strValue.contains(memberBcode)) {
                addResult = contractStore.add(new BigDecimal(1));
                paramMap.put("contractStore", addResult);
                String str = strValue + "," + memberBcode;
                SupDisUtil.set((String)("memberMcode" + sgSendgoodsGoods.getMemberMcode()), (String)str, (int)this.getMillis());
            }
        } else {
            SupDisUtil.set((String)("memberMcode" + memberBcode), (String)memberBcode);
            paramMap.put("contractStore", new BigDecimal(1));
        }
        String strValue = SupDisUtil.getRemot((String)("memberMcode" + sgSendgoodsGoods.getMemberMcode()));
        this.logger.error("da.DaOpsumOrderlistServiceImpl.buildDa", (Object)("strValue is" + strValue));
        if (StringUtils.isNotBlank((String)strValue) && strValue.contains(memberBcode)) {
            if (jsonToMap.containsKey("buyBackStore")) {
                BigDecimal contractStore = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("contractStore"))));
                addResult = contractStore.add(new BigDecimal(1));
                paramMap.put("buyBackStore", addResult);
            }
        } else {
            paramMap.put("buyBackStore", new BigDecimal(1));
        }
        daOpsumOrderlist.setOpsetDatavalue(JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToMap));
        daOpsumOrderlist.setOpsetDatavalue1(JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        return daOpsumOrderlist;
    }

    public void saveNewDataInfo(OcContractReDomain ocContractReDomain, String strKey, OcContractGoodsDomain ocContractGoodsDomain, String qualifications, boolean b) {
        String goodsOrigin = ocContractGoodsDomain.getGoodsOrigin();
        if (StringUtils.isNotBlank((String)goodsOrigin) && goodsOrigin.equals("8")) {
            String contractBillcode = ocContractReDomain.getContractBillcode();
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("contractBillcode", contractBillcode);
            queryMap.put("tenantCode", ocContractReDomain.getTenantCode());
            HashMap<String, String> invokeMap = new HashMap<String, String>();
            invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryMap));
            QueryResult queryResutl = this.getQueryResutl("sg.sendgoods.querySendgoodsGoodsPage", invokeMap, SgSendgoodsGoods.class);
            List sgList = queryResutl.getList();
            if (ListUtil.isEmpty((Collection)sgList)) {
                this.logger.error("da.DaOpsumOrderlistServiceImpl.saveNewDataInfo", (Object)("sgList is null ======>param is " + queryMap));
                return;
            }
            for (SgSendgoodsGoods sgSendgoodsGoods : sgList) {
                DaOpsumOrderlistDomain daOpsumOrderlistDomain = this.buildCombinedGoodsParam(sgSendgoodsGoods, b, strKey, qualifications, ocContractReDomain);
                if (daOpsumOrderlistDomain == null) continue;
                this.saveOpsumOrderList(daOpsumOrderlistDomain);
            }
        }
        Date gmtCreate = ocContractReDomain.getGmtCreate();
        Map<String, Object> dataMap = this.getDataMap(gmtCreate);
        DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
        daOpsumOrderlistDomain.setOpsetDatacode1(ocContractGoodsDomain.getMemberMcode());
        daOpsumOrderlistDomain.setOpsetDatacode("TOTAL-ALL");
        daOpsumOrderlistDomain.setOpsumCode("ALL");
        if (!b) {
            daOpsumOrderlistDomain.setOpsumCode("-1");
            daOpsumOrderlistDomain.setOpsetDatacode(null);
            if (ocContractGoodsDomain.getMemberCcode().equals("10000210370767")) {
                daOpsumOrderlistDomain.setOpsumCode(ocContractGoodsDomain.getMemberCcode());
                daOpsumOrderlistDomain.setOpsetDatacode("SUP-ALL");
                if (StringUtils.isNotBlank((String)strKey)) {
                    daOpsumOrderlistDomain.setOpsetDatacode("NOT-ALL");
                    daOpsumOrderlistDomain.setOpsetDatacode2(String.valueOf(dataMap.get(strKey)));
                }
            }
        }
        daOpsumOrderlistDomain.setOpsetDatacode3(qualifications);
        daOpsumOrderlistDomain.setOpsumListNum1(ocContractGoodsDomain.getContractGoodsInmoney());
        daOpsumOrderlistDomain.setOpsumListNum2(new BigDecimal(1));
        BigDecimal subtract = ocContractGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsPrice());
        BigDecimal discountPrice = subtract.multiply(ocContractGoodsDomain.getGoodsNum());
        daOpsumOrderlistDomain.setOpsumListNum(discountPrice);
        daOpsumOrderlistDomain.setTenantCode(ocContractReDomain.getTenantCode());
        HashMap<String, BigDecimal> jsonToMap = new HashMap<String, BigDecimal>();
        BigDecimal addResult = new BigDecimal(0);
        BigDecimal multiply = ocContractGoodsDomain.getGoodsNum().multiply(ocContractGoodsDomain.getPricesetBaseprice());
        addResult = addResult.add(multiply);
        jsonToMap.put("GIV", addResult);
        jsonToMap.put("contractMoney", ocContractGoodsDomain.getContractGoodsMoney());
        String memberBcode = ocContractReDomain.getGoodsList().get(0).getMemberBcode();
        SupDisUtil.set((String)("memberMcode" + ocContractGoodsDomain.getMemberMcode()), (String)memberBcode, (int)this.getMillis());
        HashMap<String, BigDecimal> paramMap = new HashMap<String, BigDecimal>();
        paramMap.put("contractStore", new BigDecimal(1));
        String strValue = SupDisUtil.getRemot((String)("memberMcode" + ocContractGoodsDomain.getMemberMcode()));
        this.logger.error("da.DaOpsumOrderlistServiceImpl.saveNewDataInfo", (Object)("strValue is" + strValue));
        if (StringUtils.isNotBlank((String)strValue) && strValue.contains(memberBcode)) {
            paramMap.put("buyBackStore", new BigDecimal(1));
        }
        daOpsumOrderlistDomain.setOpsetDatavalue(JsonUtil.buildNonDefaultBinder().toJson(jsonToMap));
        daOpsumOrderlistDomain.setOpsetDatavalue1(JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        this.saveOpsumOrderList(daOpsumOrderlistDomain);
    }

    public DaOpsumOrderlistDomain buildCombinedGoodsParam(SgSendgoodsGoods sgSendgoodsGoods, boolean b, String strKey, String qualifications, OcContractReDomain ocContractReDomain) {
        Date gmtCreate = sgSendgoodsGoods.getGmtCreate();
        Map<String, Object> dataMap = this.getDataMap(gmtCreate);
        DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
        daOpsumOrderlistDomain.setOpsetDatacode1(sgSendgoodsGoods.getMemberMcode());
        daOpsumOrderlistDomain.setOpsetDatacode("TOTAL-ALL");
        daOpsumOrderlistDomain.setOpsumCode("ALL");
        if (!b) {
            daOpsumOrderlistDomain.setOpsumCode("-1");
            daOpsumOrderlistDomain.setOpsetDatacode(null);
            if (sgSendgoodsGoods.getMemberCcode().equals("10000210370767")) {
                daOpsumOrderlistDomain.setOpsumCode(sgSendgoodsGoods.getMemberCcode());
                daOpsumOrderlistDomain.setOpsetDatacode("SUP-ALL");
                if (StringUtils.isNotBlank((String)strKey)) {
                    daOpsumOrderlistDomain.setOpsetDatacode("NOT-ALL");
                    daOpsumOrderlistDomain.setOpsetDatacode2(String.valueOf(dataMap.get(strKey)));
                }
            }
        }
        daOpsumOrderlistDomain.setOpsetDatacode3(qualifications);
        daOpsumOrderlistDomain.setOpsumListNum1(sgSendgoodsGoods.getContractGoodsInmoney());
        daOpsumOrderlistDomain.setOpsumListNum2(new BigDecimal(1));
        BigDecimal subtract = sgSendgoodsGoods.getPricesetNprice().subtract(sgSendgoodsGoods.getContractGoodsPrice());
        BigDecimal discountPrice = subtract.multiply(sgSendgoodsGoods.getGoodsNum());
        daOpsumOrderlistDomain.setOpsumListNum(discountPrice);
        daOpsumOrderlistDomain.setTenantCode(sgSendgoodsGoods.getTenantCode());
        HashMap<String, BigDecimal> jsonToMap = new HashMap<String, BigDecimal>();
        BigDecimal addResult = new BigDecimal(0);
        BigDecimal multiply = sgSendgoodsGoods.getGoodsNum().multiply(sgSendgoodsGoods.getContractGoodsMoney());
        addResult = addResult.add(multiply);
        jsonToMap.put("GIV", addResult);
        jsonToMap.put("contractMoney", sgSendgoodsGoods.getContractGoodsMoney());
        String memberBcode = ocContractReDomain.getGoodsList().get(0).getMemberBcode();
        SupDisUtil.set((String)("memberMcode" + sgSendgoodsGoods.getMemberMcode()), (String)memberBcode, (int)this.getMillis());
        HashMap<String, BigDecimal> paramMap = new HashMap<String, BigDecimal>();
        paramMap.put("contractStore", new BigDecimal(1));
        String strValue = SupDisUtil.getRemot((String)("memberMcode" + sgSendgoodsGoods.getMemberMcode()));
        this.logger.error("da.DaOpsumOrderlistServiceImpl.buildCombinedGoodsParam", (Object)("strValue is" + strValue));
        if (StringUtils.isNotBlank((String)strValue) && strValue.contains(memberBcode)) {
            paramMap.put("buyBackStore", new BigDecimal(1));
        }
        daOpsumOrderlistDomain.setOpsetDatavalue(JsonUtil.buildNonDefaultBinder().toJson(jsonToMap));
        daOpsumOrderlistDomain.setOpsetDatavalue1(JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        return daOpsumOrderlistDomain;
    }

    public List<String> getQuaList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("plat");
        list.add("retail");
        return list;
    }

    public int getMillis() {
        long l = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sdf.format(new Date());
        String[] split = dateStr.split("-");
        calendar.set(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        long millis = calendar.getTimeInMillis();
        return (int)millis;
    }

    @Override
    public String refundInfo(OcRefundReDomain ocRefundDomain) throws ApiException {
        this.logger.error("da.DaOpsumOrderlistServiceImpl.refundInfo", (Object)("ocRefundDomain is" + ocRefundDomain));
        if (ocRefundDomain == null) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.refundInfo", (Object)("ocRefundDomain is" + ocRefundDomain));
            return "error";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", ocRefundDomain.getTenantCode());
        List<OcRefundGoodsDomain> ocRefundGoodsDomainList = ocRefundDomain.getOcRefundGoodsDomainList();
        boolean orderFlag = true;
        boolean notSupFlag = true;
        boolean supFlag = true;
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
            this.updateTodayAllData(ocRefundGoodsDomain, ocRefundDomain, orderFlag);
            this.updateAllData(ocRefundGoodsDomain, orderFlag);
            orderFlag = false;
            String memberCcode = ocRefundGoodsDomain.getMemberCcode();
            if (!memberCcode.equals("10000210370767")) {
                this.updateNotSup(ocRefundGoodsDomain, notSupFlag);
                notSupFlag = false;
                continue;
            }
            Map<String, Object> dataMap = this.getDataMap(ocRefundDomain.getGmtCreate());
            paramMap.put("opsetDatacode1", ocRefundDomain.getMemberMcode());
            paramMap.put("opsumCode", ocRefundGoodsDomain.getMemberCcode());
            for (String strKey : dataMap.keySet()) {
                paramMap.put("opsetDatacode2", dataMap.get(strKey));
                for (String qua : this.getQuaList()) {
                    paramMap.put("opsetDatacode3", qua);
                    QueryResult<DaOpsumOrderlist> queryResult = this.queryOpsumOrderListPage(paramMap);
                    DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)queryResult.getList().get(0);
                    DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
                    DaOpsumOrderlist daOpsumOrderlist1 = this.buildRefundDa(daOpsumOrderlist, ocRefundGoodsDomain, supFlag);
                    if (daOpsumOrderlist1 == null) {
                        return "error";
                    }
                    try {
                        BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.updateOpsumOrderList(daOpsumOrderlistDomain);
                }
            }
            supFlag = false;
        }
        return "success";
    }

    @Override
    public String refundInfoAll(OcRefundReDomain ocRefundDomain) throws ApiException {
        this.logger.error("da.DaOpsumOrderlistServiceImpl.refundInfoAll", (Object)("ocRefundDomain is" + ocRefundDomain));
        if (ocRefundDomain == null) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.refundInfoAll", (Object)("ocRefundDomain is" + ocRefundDomain));
            return "error";
        }
        for (String qua : this.getQuaList()) {
            this.updateTotalAllRefundDa(ocRefundDomain, qua);
            this.updateTodayAllRefundDa(ocRefundDomain, qua);
            boolean checkGoodsSup = this.checkGoodsSup(ocRefundDomain);
            if (checkGoodsSup) {
                this.updateNotSupAllRefund(ocRefundDomain, qua);
            }
            Map<String, Object> dataMap = this.getDataMap(ocRefundDomain.getGmtCreate());
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("tenantCode", ocRefundDomain.getTenantCode());
            for (String strKey : dataMap.keySet()) {
                QueryResult<DaOpsumOrderlist> queryResult;
                paramMap.put("opsetDatacode2", dataMap.get(strKey));
                paramMap.put("opsetDatacode3", qua);
                if (qua.equals("retail")) {
                    paramMap.put("opsetDatacode1", ocRefundDomain.getMemberMcode());
                }
                if (qua.equals("plat") && paramMap.containsKey("opsetDatacode1")) {
                    paramMap.remove("opsetDatacode1");
                }
                if (ListUtil.isEmpty((Collection)(queryResult = this.queryOpsumOrderListPage(paramMap)).getList())) {
                    this.logger.error("da.DaOpsumOrderlistServiceImpl.refundInfoAll", (Object)("queryResult is null===>paramMap is" + JsonUtil.buildNonNullBinder().toJson(paramMap)));
                    continue;
                }
                DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)queryResult.getList().get(0);
                DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
                DaOpsumOrderlist daOpsumOrderlist1 = this.buildAllRefundDa(daOpsumOrderlist);
                if (daOpsumOrderlist1 == null) continue;
                try {
                    BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.updateOpsumOrderList(daOpsumOrderlistDomain);
            }
        }
        return "success";
    }

    public boolean checkGoodsSup(OcRefundReDomain ocRefundDomain) {
        boolean checkSup = false;
        List<OcRefundGoodsDomain> ocRefundGoodsDomainList = ocRefundDomain.getOcRefundGoodsDomainList();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
            String memberCcode = ocRefundGoodsDomain.getMemberCcode();
            if (!StringUtils.isNotBlank((String)memberCcode) || "10000210370767".equals(memberCcode)) continue;
            return true;
        }
        return checkSup;
    }

    public void updateNotSupAllRefund(OcRefundReDomain ocRefundDomain, String qua) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (qua.equals("retail")) {
            queryMap.put("opsetDatacode1", ocRefundDomain.getMemberMcode());
        }
        queryMap.put("tenantCode", ocRefundDomain.getTenantCode());
        queryMap.put("opsumCode", "-1");
        QueryResult<DaOpsumOrderlist> notSupResult = this.queryOpsumOrderListPage(queryMap);
        if (ListUtil.isEmpty((Collection)notSupResult.getList())) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.updateNotSupAll", (Object)("notSupResult is null===> queryMap is" + JsonUtil.buildNonNullBinder().toJson(queryMap)));
            return;
        }
        DaOpsumOrderlist daOpsumOrderlistNotSup = (DaOpsumOrderlist)notSupResult.getList().get(0);
        if (daOpsumOrderlistNotSup == null) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.updateNotSupAll", (Object)("daOpsumOrderlistNotSup is null===> queryMap is" + JsonUtil.buildNonNullBinder().toJson(queryMap)));
            return;
        }
        DaOpsumOrderlist daOpsumOrderlist = this.buildAllRefundDa(daOpsumOrderlistNotSup);
        DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
        DaOpsumOrderlist daOpsumOrderlist1 = this.buildAllRefundDa(daOpsumOrderlist);
        if (daOpsumOrderlist1 == null) {
            return;
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.error("da.DaOpsumOrderlistServiceImpl.updateTotalAllRefundDa", (Object)("daOpsumOrderlistDomain is " + daOpsumOrderlistDomain));
        this.updateOpsumOrderList(daOpsumOrderlistDomain);
    }

    public DaOpsumOrderlist buildAllRefundDa(DaOpsumOrderlist daOpsumOrderlist) {
        BigDecimal opsumListNum2 = daOpsumOrderlist.getOpsumListNum2();
        BigDecimal orderNum = opsumListNum2.subtract(new BigDecimal(1));
        this.logger.error("da.DaOpsumOrderlistServiceImpl.buildRefundDa", (Object)("orderNum is " + orderNum));
        daOpsumOrderlist.setOpsumListNum2(orderNum);
        return daOpsumOrderlist;
    }

    public void updateTotalAllRefundDa(OcRefundReDomain ocRefundDomain, String qua) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (qua.equals("retail")) {
            queryMap.put("opsetDatacode1", ocRefundDomain.getMemberMcode());
        }
        queryMap.put("tenantCode", ocRefundDomain.getTenantCode());
        queryMap.put("opsumCode", "ALL");
        queryMap.put("opsetDatacode", "TOTAL-ALL");
        QueryResult<DaOpsumOrderlist> totalAllResult = this.queryOpsumOrderListPage(queryMap);
        if (ListUtil.isEmpty((Collection)totalAllResult.getList())) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.updateTotalAllRefundDa", (Object)("totalAllResult is null===> queryMap is" + JsonUtil.buildNonNullBinder().toJson(queryMap)));
            return;
        }
        DaOpsumOrderlist daOpsumOrderlistTotal = (DaOpsumOrderlist)totalAllResult.getList().get(0);
        if (daOpsumOrderlistTotal == null) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.updateTotalAllRefundDa", (Object)("daOpsumOrderlistTotal is null===> queryMap is" + JsonUtil.buildNonNullBinder().toJson(queryMap)));
            return;
        }
        DaOpsumOrderlist daOpsumOrderlist = this.buildAllRefundDa(daOpsumOrderlistTotal);
        DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
        DaOpsumOrderlist daOpsumOrderlist1 = this.buildAllRefundDa(daOpsumOrderlist);
        if (daOpsumOrderlist1 == null) {
            return;
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.error("da.DaOpsumOrderlistServiceImpl.updateTotalAllRefundDa", (Object)("daOpsumOrderlistDomain is " + daOpsumOrderlistDomain));
        this.updateOpsumOrderList(daOpsumOrderlistDomain);
    }

    public void updateTodayAllRefundDa(OcRefundReDomain ocRefundDomain, String qua) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (qua.equals("retail")) {
            queryMap.put("opsetDatacode1", ocRefundDomain.getMemberMcode());
        }
        queryMap.put("tenantCode", ocRefundDomain.getTenantCode());
        queryMap.put("opsumCode", "ALL-DATA");
        String dateString = DateUtil.getDateString((Date)ocRefundDomain.getGmtCreate(), (String)"yyyy-MM-dd");
        queryMap.put("opsetDatacode2", dateString);
        QueryResult<DaOpsumOrderlist> totalAllResult = this.queryOpsumOrderListPage(queryMap);
        if (ListUtil.isEmpty((Collection)totalAllResult.getList())) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.updateTotalAllRefundDa", (Object)("totalAllResult is null===> queryMap is" + JsonUtil.buildNonNullBinder().toJson(queryMap)));
            return;
        }
        DaOpsumOrderlist daOpsumOrderlistToday = (DaOpsumOrderlist)totalAllResult.getList().get(0);
        if (daOpsumOrderlistToday == null) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.updateTotalAllRefundDa", (Object)("daOpsumOrderlistTotal is null===> queryMap is" + JsonUtil.buildNonNullBinder().toJson(queryMap)));
            return;
        }
        DaOpsumOrderlist daOpsumOrderlist = this.buildAllRefundDa(daOpsumOrderlistToday);
        DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
        DaOpsumOrderlist daOpsumOrderlist1 = this.buildAllRefundDa(daOpsumOrderlist);
        if (daOpsumOrderlist1 == null) {
            return;
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.error("da.DaOpsumOrderlistServiceImpl.updateTodayAllRefundDa", (Object)("daOpsumOrderlistDomain is " + daOpsumOrderlistDomain));
        this.updateOpsumOrderList(daOpsumOrderlistDomain);
    }

    public void updateNotSup(OcRefundGoodsDomain ocRefundGoodsDomain, boolean orderFlag) {
        List<String> quaList = this.getQuaList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("opsumCode", "-1");
        for (String qua : quaList) {
            if (qua.equals("retail")) {
                paramMap.put("opsetDatacode1", ocRefundGoodsDomain.getMemberMcode());
            }
            paramMap.put("opsetDatacode3", qua);
            QueryResult<DaOpsumOrderlist> queryResult = this.queryOpsumOrderListPage(paramMap);
            List list = queryResult.getList();
            if (ListUtil.isEmpty((Collection)list)) {
                this.logger.error("da.DaOpsumOrderlistServiceImpl.updateNotSup", (Object)("list is list======> paramMap is" + paramMap));
                continue;
            }
            DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)list.get(0);
            DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
            DaOpsumOrderlist daOpsumOrderlist1 = this.buildRefundDa(daOpsumOrderlist, ocRefundGoodsDomain, orderFlag);
            if (daOpsumOrderlist1 == null) {
                return;
            }
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateOpsumOrderList(daOpsumOrderlistDomain);
        }
    }

    public void updateTodayAllData(OcRefundGoodsDomain ocRefundGoodsDomain, OcRefundReDomain ocRefundReDomain, boolean orderFlag) {
        String dateString = DateUtil.getDateString((Date)ocRefundReDomain.getGmtCreate(), (String)"yyyy-MM-dd");
        List<String> quaList = this.getQuaList();
        for (String qua : quaList) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("opsumCode", "ALL-DATA");
            paramMap.put("opsetDatacode2", dateString);
            paramMap.put("tenantCode", ocRefundGoodsDomain.getTenantCode());
            paramMap.put("opsetDatacode3", qua);
            QueryResult<DaOpsumOrderlist> queryResult = this.queryOpsumOrderListPage(paramMap);
            List list = queryResult.getList();
            if (ListUtil.isEmpty((Collection)list)) {
                this.logger.error("da.DaOpsumOrderlistServiceImpl.updateNotSup", (Object)("list is list======> paramMap is" + paramMap));
                continue;
            }
            DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)list.get(0);
            DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
            DaOpsumOrderlist daOpsumOrderlist1 = this.buildRefundDa(daOpsumOrderlist, ocRefundGoodsDomain, orderFlag);
            if (daOpsumOrderlist1 == null) {
                return;
            }
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateOpsumOrderList(daOpsumOrderlistDomain);
        }
    }

    public void updateAllData(OcRefundGoodsDomain ocRefundGoodsDomain, boolean orderFlag) {
        List<String> quaList = this.getQuaList();
        for (String qua : quaList) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("opsumCode", "ALL");
            paramMap.put("tenantCode", ocRefundGoodsDomain.getTenantCode());
            paramMap.put("opsetDatacode3", qua);
            paramMap.put("opsetDatacode", "TOTAL-ALL");
            QueryResult<DaOpsumOrderlist> queryResult = this.queryOpsumOrderListPage(paramMap);
            List list = queryResult.getList();
            if (ListUtil.isEmpty((Collection)list)) {
                this.logger.error("da.DaOpsumOrderlistServiceImpl.updateAllData", (Object)("list is list======> paramMap is" + paramMap));
                continue;
            }
            DaOpsumOrderlist daOpsumOrderlist = (DaOpsumOrderlist)list.get(0);
            DaOpsumOrderlistDomain daOpsumOrderlistDomain = new DaOpsumOrderlistDomain();
            DaOpsumOrderlist daOpsumOrderlist1 = this.buildRefundDa(daOpsumOrderlist, ocRefundGoodsDomain, orderFlag);
            if (daOpsumOrderlist1 == null) {
                return;
            }
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumOrderlistDomain, (Object)daOpsumOrderlist1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateOpsumOrderList(daOpsumOrderlistDomain);
        }
    }

    public DaOpsumOrderlist buildRefundDa(DaOpsumOrderlist daOpsumOrderlist, OcRefundGoodsDomain ocRefundGoodsDomain, boolean orderFlag) {
        BigDecimal bigDecimal;
        OcContract orderInfo = this.getOrderInfo(ocRefundGoodsDomain.getContractBillcode(), ocRefundGoodsDomain.getTenantCode());
        if (orderInfo == null) {
            return null;
        }
        this.logger.error("da.DaOpsumOrderlistServiceImpl.buildRefundDa", (Object)("orderInfo is " + JsonUtil.buildNormalBinder().toJson((Object)orderInfo)));
        List<OcPackage> packageList = orderInfo.getPackageList();
        OcContractGoods ocContractGoods = null;
        if (ListUtil.isEmpty(packageList)) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.buildRefundDa", (Object)"packageList is null");
            return null;
        }
        for (OcPackage ocPackage : packageList) {
            List<OcContractGoods> contractGoodsList = ocPackage.getContractGoodsList();
            for (OcContractGoods ocContractGoodsByDb : contractGoodsList) {
                if (!StringUtils.isNotBlank((String)ocContractGoodsByDb.getSkuNo()) || !ocContractGoodsByDb.getSkuNo().equals(ocRefundGoodsDomain.getSkuBarcode())) continue;
                ocContractGoods = ocContractGoodsByDb;
            }
        }
        if (ocContractGoods == null) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.buildRefundDa", (Object)"ocContractGoods is null");
            return null;
        }
        this.logger.error("da.DaOpsumOrderlistServiceImpl.buildRefundDa", (Object)("ocContractGoods is " + JsonUtil.buildNormalBinder().toJson(ocContractGoods)));
        if (daOpsumOrderlist.getOpsumListNum1() != null) {
            BigDecimal opsumListNum1 = daOpsumOrderlist.getOpsumListNum1();
            BigDecimal opsumListNum = opsumListNum1.subtract(ocContractGoods.getContractGoodsInmoney());
            daOpsumOrderlist.setOpsumListNum1(opsumListNum);
        }
        Integer dataState = orderInfo.getDataState();
        this.logger.error("da.DaOpsumOrderlistServiceImpl.buildRefundDa", (Object)("dataState is " + dataState + "orderFlag is" + orderFlag));
        if (daOpsumOrderlist.getOpsumListNum() != null) {
            BigDecimal opsumListNum3 = daOpsumOrderlist.getOpsumListNum();
            BigDecimal subtract = ocRefundGoodsDomain.getPricesetNprice().subtract(ocContractGoods.getContractGoodsPrice());
            BigDecimal discountPrice = subtract.multiply(ocContractGoods.getGoodsNum());
            BigDecimal goodsPmoney = opsumListNum3.subtract(discountPrice);
            daOpsumOrderlist.setOpsumListNum(goodsPmoney);
        }
        String opsetDatavalue = daOpsumOrderlist.getOpsetDatavalue();
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(opsetDatavalue, String.class, Object.class);
        if (jsonToMap.containsKey("GIV")) {
            BigDecimal addResult = bigDecimal = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("GIV"))));
            BigDecimal multiply = ocContractGoods.getGoodsNum().multiply(ocContractGoods.getPricesetBaseprice());
            addResult = addResult.subtract(multiply);
            jsonToMap.put("GIV", addResult);
        }
        if (jsonToMap.containsKey("contractMoney")) {
            bigDecimal = new BigDecimal(Double.valueOf(String.valueOf(jsonToMap.get("contractMoney"))));
            BigDecimal contractMoney = bigDecimal.subtract(ocContractGoods.getContractGoodsMoney());
            jsonToMap.put("contractMoney", contractMoney);
        }
        daOpsumOrderlist.setOpsetDatavalue(JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToMap));
        return daOpsumOrderlist;
    }

    public String getStrKey(String str, String removeStr) {
        String replace = str.replace(removeStr, "");
        if (replace.lastIndexOf(",") == replace.length() - 1) {
            String substring = replace.substring(0, replace.length() - 2);
            return substring;
        }
        if (replace.indexOf(",", 0) == 0) {
            String substring = replace.substring(1);
            return substring;
        }
        if (replace.indexOf(",,") != -1) {
            String replace1 = replace.replace(",,", ",");
            return replace1;
        }
        return replace;
    }

    public OcContract getOrderInfo(String contractBillcode, String tenantCode) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("contractBillcode", contractBillcode);
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("childFlag", "true");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryMap));
        QueryResult queryResutl = this.getQueryResutl("oc.contract.queryContractPage", invokeMap, OcContract.class);
        List list = queryResutl.getList();
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error("da.DaOpsumOrderlistServiceImpl.getOrderInfo", (Object)("list is null======> paramMap is" + queryMap));
            return null;
        }
        return (OcContract)list.get(0);
    }
}

