/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOpsetMapper;
import com.yqbsoft.laser.service.data.domain.DaOpsetDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsetReDomain;
import com.yqbsoft.laser.service.data.model.DaOpset;
import com.yqbsoft.laser.service.data.service.DaOpsetService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaOpsetServiceImpl
extends BaseServiceImpl
implements DaOpsetService {
    private static final String SYS_CODE = "da.DaOpsetServiceImpl";
    private DaOpsetMapper daOpsetMapper;

    public void setDaOpsetMapper(DaOpsetMapper daOpsetMapper) {
        this.daOpsetMapper = daOpsetMapper;
    }

    private Date getSysDate() {
        try {
            return this.daOpsetMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsetServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOpset(DaOpsetDomain daOpsetDomain) {
        if (null == daOpsetDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOpsetDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpsetDefault(DaOpset daOpset) {
        if (null == daOpset) {
            return;
        }
        if (null == daOpset.getDataState()) {
            daOpset.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOpset.getGmtCreate()) {
            daOpset.setGmtCreate(date);
        }
        daOpset.setGmtModified(date);
        if (StringUtils.isBlank((String)daOpset.getOpsetCode())) {
            daOpset.setOpsetCode(this.getNo(null, "DaOpset", "daOpset", daOpset.getTenantCode()));
        }
    }

    private int getOpsetMaxCode() {
        int code = 0;
        try {
            return this.daOpsetMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsetServiceImpl.getOpsetMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpsetUpdataDefault(DaOpset daOpset) {
        if (null == daOpset) {
            return;
        }
        daOpset.setGmtModified(this.getSysDate());
    }

    private void saveOpsetModel(DaOpset daOpset) throws ApiException {
        if (null == daOpset) {
            return;
        }
        try {
            this.daOpsetMapper.insert(daOpset);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsetServiceImpl.saveOpsetModel.ex", (Throwable)e);
        }
    }

    private void saveOpsetBatchModel(List<DaOpset> daOpsetList) throws ApiException {
        if (null == daOpsetList || daOpsetList.isEmpty()) {
            return;
        }
        try {
            this.daOpsetMapper.insertBatch(daOpsetList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsetServiceImpl.saveOpsetBatchModel.ex", (Throwable)e);
        }
    }

    private DaOpset getOpsetModelById(Integer opsetId) {
        if (null == opsetId) {
            return null;
        }
        try {
            return this.daOpsetMapper.selectByPrimaryKey(opsetId);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsetServiceImpl.getOpsetModelById", (Throwable)e);
            return null;
        }
    }

    private DaOpset getOpsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daOpsetMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsetServiceImpl.getOpsetModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsetMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsetServiceImpl.delOpsetModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsetServiceImpl.delOpsetModelByCode.num");
        }
    }

    private void deleteOpsetModel(Integer opsetId) throws ApiException {
        if (null == opsetId) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsetMapper.deleteByPrimaryKey(opsetId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsetServiceImpl.deleteOpsetModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsetServiceImpl.deleteOpsetModel.num");
        }
    }

    private void updateOpsetModel(DaOpset daOpset) throws ApiException {
        if (null == daOpset) {
            return;
        }
        int i = 0;
        try {
            i = this.daOpsetMapper.updateByPrimaryKey(daOpset);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsetServiceImpl.updateOpsetModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOpsetServiceImpl.updateOpsetModel.num");
        }
    }

    private void updateStateOpsetModel(Integer opsetId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opsetId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opsetId", opsetId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOpsetMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsetServiceImpl.updateStateOpsetModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOpsetServiceImpl.updateStateOpsetModel.null");
        }
    }

    private void updateStateOpsetModelByCode(String tenantCode, String opsetCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opsetCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsetCode", opsetCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOpsetMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOpsetServiceImpl.updateStateOpsetModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOpsetServiceImpl.updateStateOpsetModelByCode.null");
        }
    }

    private DaOpset makeOpset(DaOpsetDomain daOpsetDomain, DaOpset daOpset) {
        if (null == daOpsetDomain) {
            return null;
        }
        if (null == daOpset) {
            daOpset = new DaOpset();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOpset, (Object)daOpsetDomain);
            return daOpset;
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsetServiceImpl.makeOpset", (Throwable)e);
            return null;
        }
    }

    private DaOpsetReDomain makeDaOpsetReDomain(DaOpset daOpset) {
        if (null == daOpset) {
            return null;
        }
        DaOpsetReDomain daOpsetReDomain = new DaOpsetReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOpsetReDomain, (Object)daOpset);
            return daOpsetReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsetServiceImpl.makeDaOpsetReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaOpset> queryOpsetModelPage(Map<String, Object> parammap) {
        try {
            return this.daOpsetMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsetServiceImpl.queryOpsetModel", (Throwable)e);
            return null;
        }
    }

    private int countOpset(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOpsetMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOpsetServiceImpl.countOpset", (Throwable)e);
        }
        return i;
    }

    private DaOpset createDaOpset(DaOpsetDomain daOpsetDomain) {
        String msg = this.checkOpset(daOpsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOpsetServiceImpl.saveOpset.checkOpset", msg);
        }
        DaOpset daOpset = this.makeOpset(daOpsetDomain, null);
        this.setOpsetDefault(daOpset);
        return daOpset;
    }

    @Override
    public String saveOpset(DaOpsetDomain daOpsetDomain) throws ApiException {
        DaOpset daOpset = this.createDaOpset(daOpsetDomain);
        this.saveOpsetModel(daOpset);
        return daOpset.getOpsetCode();
    }

    @Override
    public String saveOpsetBatch(List<DaOpsetDomain> daOpsetDomainList) throws ApiException {
        if (null == daOpsetDomainList || daOpsetDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaOpset> daOpsetList = new ArrayList<DaOpset>();
        String code = "";
        for (DaOpsetDomain daOpsetDomain : daOpsetDomainList) {
            DaOpset daOpset = this.createDaOpset(daOpsetDomain);
            code = daOpset.getOpsetCode();
            daOpsetList.add(daOpset);
        }
        this.saveOpsetBatchModel(daOpsetList);
        return code;
    }

    @Override
    public void updateOpsetState(Integer opsetId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateOpsetModel(opsetId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpsetStateByCode(String tenantCode, String opsetCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateOpsetModelByCode(tenantCode, opsetCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpset(DaOpsetDomain daOpsetDomain) throws ApiException {
        String msg = this.checkOpset(daOpsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOpsetServiceImpl.updateOpset.checkOpset", msg);
        }
        DaOpset oldDaOpset = this.getOpsetModelById(daOpsetDomain.getOpsetId());
        if (null == oldDaOpset) {
            throw new ApiException("da.DaOpsetServiceImpl.updateOpset.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaOpset daOpset = this.makeOpset(daOpsetDomain, oldDaOpset);
        this.setOpsetUpdataDefault(daOpset);
        this.updateOpsetModel(daOpset);
    }

    @Override
    public DaOpset getOpset(Integer opsetId) {
        return this.getOpsetModelById(opsetId);
    }

    @Override
    public void deleteOpset(Integer opsetId) throws ApiException {
        this.deleteOpsetModel(opsetId);
    }

    @Override
    public QueryResult<DaOpset> queryOpsetPage(Map<String, Object> map) {
        List<DaOpset> daOpsetList = this.queryOpsetModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpset(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOpsetList);
        return queryResult;
    }

    @Override
    public DaOpset getOpsetByCode(String tenantCode, String opsetCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsetCode", opsetCode);
        return this.getOpsetModelByCode(map);
    }

    @Override
    public void deleteOpsetByCode(String tenantCode, String opsetCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsetCode", opsetCode);
        this.delOpsetModelByCode(map);
    }
}

