/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaStatisticsMapper;
import com.yqbsoft.laser.service.data.domain.DaStatisticsDomain;
import com.yqbsoft.laser.service.data.domain.DaStatisticsReDomain;
import com.yqbsoft.laser.service.data.model.DaStatistics;
import com.yqbsoft.laser.service.data.service.DaStatisticsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaStatisticsServiceImpl
extends BaseServiceImpl
implements DaStatisticsService {
    private static final String SYS_CODE = "da.DaStatisticsServiceImpl";
    private DaStatisticsMapper daStatisticsMapper;

    public void setDaStatisticsMapper(DaStatisticsMapper daStatisticsMapper) {
        this.daStatisticsMapper = daStatisticsMapper;
    }

    private Date getSysDate() {
        try {
            return this.daStatisticsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaStatisticsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStatistics(DaStatisticsDomain daStatisticsDomain) {
        if (null == daStatisticsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daStatisticsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStatisticsDefault(DaStatistics daStatistics) {
        if (null == daStatistics) {
            return;
        }
        if (null == daStatistics.getDataState()) {
            daStatistics.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daStatistics.getGmtCreate()) {
            daStatistics.setGmtCreate(date);
        }
        daStatistics.setGmtModified(date);
        if (StringUtils.isBlank((String)daStatistics.getStatisticsCode())) {
            daStatistics.setStatisticsCode(this.getNo(null, "DaStatistics", "daStatistics", daStatistics.getTenantCode()));
        }
    }

    private int getStatisticsMaxCode() {
        int code = 0;
        try {
            return this.daStatisticsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaStatisticsServiceImpl.getStatisticsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStatisticsUpdataDefault(DaStatistics daStatistics) {
        if (null == daStatistics) {
            return;
        }
        daStatistics.setGmtModified(this.getSysDate());
    }

    private void saveStatisticsModel(DaStatistics daStatistics) throws ApiException {
        if (null == daStatistics) {
            return;
        }
        try {
            this.daStatisticsMapper.insert(daStatistics);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStatisticsServiceImpl.saveStatisticsModel.ex", (Throwable)e);
        }
    }

    private void saveStatisticsBatchModel(List<DaStatistics> daStatisticsList) throws ApiException {
        if (null == daStatisticsList || daStatisticsList.isEmpty()) {
            return;
        }
        try {
            this.daStatisticsMapper.insertBatch(daStatisticsList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStatisticsServiceImpl.saveStatisticsBatchModel.ex", (Throwable)e);
        }
    }

    private DaStatistics getStatisticsModelById(Integer statisticsId) {
        if (null == statisticsId) {
            return null;
        }
        try {
            return this.daStatisticsMapper.selectByPrimaryKey(statisticsId);
        }
        catch (Exception e) {
            this.logger.error("da.DaStatisticsServiceImpl.getStatisticsModelById", (Throwable)e);
            return null;
        }
    }

    private DaStatistics getStatisticsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daStatisticsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaStatisticsServiceImpl.getStatisticsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStatisticsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daStatisticsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStatisticsServiceImpl.delStatisticsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaStatisticsServiceImpl.delStatisticsModelByCode.num");
        }
    }

    private void deleteStatisticsModel(Integer statisticsId) throws ApiException {
        if (null == statisticsId) {
            return;
        }
        int i = 0;
        try {
            i = this.daStatisticsMapper.deleteByPrimaryKey(statisticsId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStatisticsServiceImpl.deleteStatisticsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaStatisticsServiceImpl.deleteStatisticsModel.num");
        }
    }

    private void updateStatisticsModel(DaStatistics daStatistics) throws ApiException {
        if (null == daStatistics) {
            return;
        }
        int i = 0;
        try {
            i = this.daStatisticsMapper.updateByPrimaryKey(daStatistics);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStatisticsServiceImpl.updateStatisticsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaStatisticsServiceImpl.updateStatisticsModel.num");
        }
    }

    private void updateStateStatisticsModel(Integer statisticsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == statisticsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statisticsId", statisticsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daStatisticsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStatisticsServiceImpl.updateStateStatisticsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaStatisticsServiceImpl.updateStateStatisticsModel.null");
        }
    }

    private void updateStateStatisticsModelByCode(String tenantCode, String statisticsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)statisticsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statisticsCode", statisticsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daStatisticsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStatisticsServiceImpl.updateStateStatisticsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaStatisticsServiceImpl.updateStateStatisticsModelByCode.null");
        }
    }

    private DaStatistics makeStatistics(DaStatisticsDomain daStatisticsDomain, DaStatistics daStatistics) {
        if (null == daStatisticsDomain) {
            return null;
        }
        if (null == daStatistics) {
            daStatistics = new DaStatistics();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daStatistics, (Object)daStatisticsDomain);
            return daStatistics;
        }
        catch (Exception e) {
            this.logger.error("da.DaStatisticsServiceImpl.makeStatistics", (Throwable)e);
            return null;
        }
    }

    private DaStatisticsReDomain makeDaStatisticsReDomain(DaStatistics daStatistics) {
        if (null == daStatistics) {
            return null;
        }
        DaStatisticsReDomain daStatisticsReDomain = new DaStatisticsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daStatisticsReDomain, (Object)daStatistics);
            return daStatisticsReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaStatisticsServiceImpl.makeDaStatisticsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaStatistics> queryStatisticsModelPage(Map<String, Object> parammap) {
        try {
            return this.daStatisticsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaStatisticsServiceImpl.queryStatisticsModel", (Throwable)e);
            return null;
        }
    }

    private int countStatistics(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daStatisticsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaStatisticsServiceImpl.countStatistics", (Throwable)e);
        }
        return i;
    }

    private DaStatistics createDaStatistics(DaStatisticsDomain daStatisticsDomain) {
        String msg = this.checkStatistics(daStatisticsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaStatisticsServiceImpl.saveStatistics.checkStatistics", msg);
        }
        DaStatistics daStatistics = this.makeStatistics(daStatisticsDomain, null);
        this.setStatisticsDefault(daStatistics);
        return daStatistics;
    }

    @Override
    public String saveStatistics(DaStatisticsDomain daStatisticsDomain) throws ApiException {
        DaStatistics daStatistics = this.createDaStatistics(daStatisticsDomain);
        this.saveStatisticsModel(daStatistics);
        return daStatistics.getStatisticsCode();
    }

    @Override
    public String saveStatisticsBatch(List<DaStatisticsDomain> daStatisticsDomainList) throws ApiException {
        if (null == daStatisticsDomainList || daStatisticsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaStatistics> daStatisticsList = new ArrayList<DaStatistics>();
        String code = "";
        for (DaStatisticsDomain daStatisticsDomain : daStatisticsDomainList) {
            DaStatistics daStatistics = this.createDaStatistics(daStatisticsDomain);
            code = daStatistics.getStatisticsCode();
            daStatisticsList.add(daStatistics);
        }
        this.saveStatisticsBatchModel(daStatisticsList);
        return code;
    }

    @Override
    public void updateStatisticsState(Integer statisticsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == statisticsId) {
            return;
        }
        this.updateStateStatisticsModel(statisticsId, dataState, oldDataState, map);
    }

    @Override
    public void updateStatisticsStateByCode(String tenantCode, String statisticsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)statisticsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateStatisticsModelByCode(tenantCode, statisticsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStatistics(DaStatisticsDomain daStatisticsDomain) throws ApiException {
        String msg = this.checkStatistics(daStatisticsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaStatisticsServiceImpl.updateStatistics.checkStatistics", msg);
        }
        DaStatistics oldDaStatistics = this.getStatisticsModelById(daStatisticsDomain.getStatisticsId());
        if (null == oldDaStatistics) {
            throw new ApiException("da.DaStatisticsServiceImpl.updateStatistics.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaStatistics daStatistics = this.makeStatistics(daStatisticsDomain, oldDaStatistics);
        this.setStatisticsUpdataDefault(daStatistics);
        this.updateStatisticsModel(daStatistics);
    }

    @Override
    public DaStatistics getStatistics(Integer statisticsId) {
        if (null == statisticsId) {
            return null;
        }
        return this.getStatisticsModelById(statisticsId);
    }

    @Override
    public void deleteStatistics(Integer statisticsId) throws ApiException {
        if (null == statisticsId) {
            return;
        }
        this.deleteStatisticsModel(statisticsId);
    }

    @Override
    public QueryResult<DaStatistics> queryStatisticsPage(Map<String, Object> map) {
        List<DaStatistics> daStatisticsList = this.queryStatisticsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStatistics(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daStatisticsList);
        return queryResult;
    }

    @Override
    public DaStatistics getStatisticsByCode(String tenantCode, String statisticsCode) throws ApiException {
        if (StringUtils.isBlank((String)statisticsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statisticsCode", statisticsCode);
        return this.getStatisticsModelByCode(map);
    }

    @Override
    public void deleteStatisticsByCode(String tenantCode, String statisticsCode) throws ApiException {
        if (StringUtils.isBlank((String)statisticsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statisticsCode", statisticsCode);
        this.delStatisticsModelByCode(map);
    }

    @Override
    public DaStatistics queryMasterStatistics(String tenantCode, String category, String brand, String memberCcode, String dsr, String startTime, String endTime, String memberCode, Integer isPGGoods) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("category", category);
        map.put("brand", brand);
        map.put("memberCcode", memberCcode);
        map.put("dsr", dsr);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("memberCode", memberCode);
        map.put("isPGGoods", isPGGoods);
        return this.daStatisticsMapper.queryMasterStatistics(map);
    }

    @Override
    public Map<String, Object> queryStatisticsGroupByMemberBCode(String tenantCode, String category, String brand, String memberCcode, String dsr, String startTime, String endTime, String memberCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("category", category);
        map.put("brand", brand);
        map.put("memberCcode", memberCcode);
        map.put("dsr", dsr);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("memberCode", memberCode);
        return null;
    }

    @Override
    public int queryStoreCount(String tenantCode, String category, String brand, String memberCcode, String dsr, String startTime, String endTime, String memberCode, Integer isPGGoods) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("category", category);
        map.put("brand", brand);
        map.put("memberCcode", memberCcode);
        map.put("dsr", dsr);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("memberCode", memberCode);
        map.put("isPGGoods", isPGGoods);
        List<DaStatistics> result = this.daStatisticsMapper.countStore(map);
        return result == null ? 0 : result.size();
    }

    @Override
    public int queryBackStoreCount(String tenantCode, String category, String brand, String memberCcode, String dsr, String startTime, String endTime, String memberCode, Integer isPGGoods) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("category", category);
        map.put("brand", brand);
        map.put("memberCcode", memberCcode);
        map.put("dsr", dsr);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("memberCode", memberCode);
        map.put("isPGGoods", isPGGoods);
        List<Integer> result = this.daStatisticsMapper.countBackStore(map);
        int count = 0;
        if (result != null) {
            for (Integer i : result) {
                if (i == null || i <= 1) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public int queryOrderCount(String tenantCode, String category, String brand, String memberCcode, String dsr, String startTime, String endTime, String memberCode, Integer isPGGoods) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("category", category);
        map.put("brand", brand);
        map.put("memberCcode", memberCcode);
        map.put("dsr", dsr);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("memberCode", memberCode);
        map.put("isPGGoods", isPGGoods);
        List<DaStatistics> result = this.daStatisticsMapper.countOrder(map);
        return result == null ? 0 : result.size();
    }
}

