/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaSumOrderMapper;
import com.yqbsoft.laser.service.data.domain.DaSumOrderDomain;
import com.yqbsoft.laser.service.data.domain.DaSumOrderReDomain;
import com.yqbsoft.laser.service.data.model.DaSumOrder;
import com.yqbsoft.laser.service.data.service.DaSumOrderDeaService;
import com.yqbsoft.laser.service.data.service.DaSumOrderService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaSumOrderServiceImpl
extends BaseServiceImpl
implements DaSumOrderService {
    private static final String SYS_CODE = SYS_CODE + ".DaSumOrderServiceImpl";
    private DaSumOrderMapper daSumOrderMapper;
    private DaSumOrderDeaService daSumOrderDeaService;

    public void setDaSumOrderMapper(DaSumOrderMapper daSumOrderMapper) {
        this.daSumOrderMapper = daSumOrderMapper;
    }

    public void setDaSumOrderDeaService(DaSumOrderDeaService daSumOrderDeaService) {
        this.daSumOrderDeaService = daSumOrderDeaService;
    }

    private Date getSysDate() {
        try {
            return this.daSumOrderMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSumOrder(DaSumOrderDomain daSumOrderDomain) {
        if (null == daSumOrderDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daSumOrderDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSumOrderDefault(DaSumOrder daSumOrder) {
        if (null == daSumOrder) {
            return;
        }
        if (null == daSumOrder.getDataState()) {
            daSumOrder.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daSumOrder.getGmtCreate()) {
            daSumOrder.setGmtCreate(date);
        }
        daSumOrder.setGmtModified(date);
        if (StringUtils.isBlank((String)daSumOrder.getSumOrderCode())) {
            daSumOrder.setSumOrderCode(this.getNo(null, "DaSumOrder", "daSumOrder", daSumOrder.getTenantCode()));
        }
    }

    private int getSumOrderMaxCode() {
        int code = 0;
        try {
            return this.daSumOrderMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSumOrderMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSumOrderUpdataDefault(DaSumOrder daSumOrder) {
        if (null == daSumOrder) {
            return;
        }
        daSumOrder.setGmtModified(this.getSysDate());
    }

    private void saveSumOrderModel(DaSumOrder daSumOrder) throws ApiException {
        if (null == daSumOrder) {
            return;
        }
        try {
            this.daSumOrderMapper.insert(daSumOrder);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveSumOrderModel.ex", (Throwable)e);
        }
    }

    private void saveSumOrderBatchModel(List<DaSumOrder> daSumOrderList) throws ApiException {
        if (null == daSumOrderList || daSumOrderList.isEmpty()) {
            return;
        }
        try {
            this.daSumOrderMapper.insertBatch(daSumOrderList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveSumOrderBatchModel.ex", (Throwable)e);
        }
    }

    private DaSumOrder getSumOrderModelById(Integer sumOrderId) {
        if (null == sumOrderId) {
            return null;
        }
        try {
            return this.daSumOrderMapper.selectByPrimaryKey(sumOrderId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSumOrderModelById", (Throwable)e);
            return null;
        }
    }

    private DaSumOrder getSumOrderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daSumOrderMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSumOrderModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSumOrderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daSumOrderMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delSumOrderModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delSumOrderModelByCode.num");
        }
    }

    private void deleteSumOrderModel(Integer sumOrderId) throws ApiException {
        if (null == sumOrderId) {
            return;
        }
        int i = 0;
        try {
            i = this.daSumOrderMapper.deleteByPrimaryKey(sumOrderId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteSumOrderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteSumOrderModel.num");
        }
    }

    private void updateSumOrderModel(DaSumOrder daSumOrder) throws ApiException {
        if (null == daSumOrder) {
            return;
        }
        int i = 0;
        try {
            i = this.daSumOrderMapper.updateByPrimaryKey(daSumOrder);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateSumOrderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateSumOrderModel.num");
        }
    }

    private void updateStateSumOrderModel(Integer sumOrderId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == sumOrderId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sumOrderId", sumOrderId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daSumOrderMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateSumOrderModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateSumOrderModel.null");
        }
    }

    private void updateStateSumOrderModelByCode(String tenantCode, String sumOrderCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)sumOrderCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sumOrderCode", sumOrderCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daSumOrderMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateSumOrderModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateSumOrderModelByCode.null");
        }
    }

    private DaSumOrder makeSumOrder(DaSumOrderDomain daSumOrderDomain, DaSumOrder daSumOrder) {
        if (null == daSumOrderDomain) {
            return null;
        }
        if (null == daSumOrder) {
            daSumOrder = new DaSumOrder();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daSumOrder, (Object)daSumOrderDomain);
            return daSumOrder;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeSumOrder", (Throwable)e);
            return null;
        }
    }

    private DaSumOrderReDomain makeDaSumOrderReDomain(DaSumOrder daSumOrder) {
        if (null == daSumOrder) {
            return null;
        }
        DaSumOrderReDomain daSumOrderReDomain = new DaSumOrderReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daSumOrderReDomain, (Object)daSumOrder);
            return daSumOrderReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaSumOrderReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaSumOrder> querySumOrderModelPage(Map<String, Object> parammap) {
        try {
            return this.daSumOrderMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".querySumOrderModel", (Throwable)e);
            return null;
        }
    }

    private int countSumOrder(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daSumOrderMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countSumOrder", (Throwable)e);
        }
        return i;
    }

    private DaSumOrder createDaSumOrder(DaSumOrderDomain daSumOrderDomain) {
        String msg = this.checkSumOrder(daSumOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveSumOrder.checkSumOrder", msg);
        }
        DaSumOrder daSumOrder = this.makeSumOrder(daSumOrderDomain, null);
        this.setSumOrderDefault(daSumOrder);
        return daSumOrder;
    }

    @Override
    public String saveSumOrder(DaSumOrderDomain daSumOrderDomain) throws ApiException {
        DaSumOrder daSumOrder = this.createDaSumOrder(daSumOrderDomain);
        this.saveSumOrderModel(daSumOrder);
        return daSumOrder.getSumOrderCode();
    }

    @Override
    public String saveSumOrderBatch(List<DaSumOrderDomain> daSumOrderDomainList) throws ApiException {
        if (null == daSumOrderDomainList || daSumOrderDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaSumOrder> daSumOrderList = new ArrayList<DaSumOrder>();
        String code = "";
        for (DaSumOrderDomain daSumOrderDomain : daSumOrderDomainList) {
            DaSumOrder daSumOrder = this.createDaSumOrder(daSumOrderDomain);
            code = daSumOrder.getSumOrderCode();
            daSumOrderList.add(daSumOrder);
        }
        this.saveSumOrderBatchModel(daSumOrderList);
        return code;
    }

    @Override
    public void updateSumOrderState(Integer sumOrderId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == sumOrderId) {
            return;
        }
        this.updateStateSumOrderModel(sumOrderId, dataState, oldDataState, map);
    }

    @Override
    public void updateSumOrderStateByCode(String tenantCode, String sumOrderCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)sumOrderCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSumOrderModelByCode(tenantCode, sumOrderCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSumOrder(DaSumOrderDomain daSumOrderDomain) throws ApiException {
        String msg = this.checkSumOrder(daSumOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateSumOrder.checkSumOrder", msg);
        }
        DaSumOrder oldDaSumOrder = this.getSumOrderModelById(daSumOrderDomain.getSumOrderId());
        if (null == oldDaSumOrder) {
            throw new ApiException(SYS_CODE + ".updateSumOrder.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaSumOrder daSumOrder = this.makeSumOrder(daSumOrderDomain, oldDaSumOrder);
        this.setSumOrderUpdataDefault(daSumOrder);
        this.updateSumOrderModel(daSumOrder);
    }

    @Override
    public DaSumOrder getSumOrder(Integer sumOrderId) {
        if (null == sumOrderId) {
            return null;
        }
        return this.getSumOrderModelById(sumOrderId);
    }

    @Override
    public void deleteSumOrder(Integer sumOrderId) throws ApiException {
        if (null == sumOrderId) {
            return;
        }
        this.deleteSumOrderModel(sumOrderId);
    }

    @Override
    public QueryResult<DaSumOrder> querySumOrderPage(Map<String, Object> map) {
        List<DaSumOrder> daSumOrderList = this.querySumOrderModelPage(map);
        if (ListUtil.isNotEmpty(daSumOrderList)) {
            for (DaSumOrder daSumOrder : daSumOrderList) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("tenantCode", daSumOrder.getTenantCode());
                param.put("sumOrderCode", daSumOrder.getSumOrderCode());
                List deaList = this.daSumOrderDeaService.querySumOrderDeaPage(param).getList();
                daSumOrder.setDaSumOrderDeaList(deaList);
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSumOrder(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daSumOrderList);
        return queryResult;
    }

    @Override
    public DaSumOrder getSumOrderByCode(String tenantCode, String sumOrderCode) throws ApiException {
        if (StringUtils.isBlank((String)sumOrderCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sumOrderCode", sumOrderCode);
        return this.getSumOrderModelByCode(map);
    }

    @Override
    public void deleteSumOrderByCode(String tenantCode, String sumOrderCode) throws ApiException {
        if (StringUtils.isBlank((String)sumOrderCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sumOrderCode", sumOrderCode);
        this.delSumOrderModelByCode(map);
    }
}

