/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOrderTotalMapper;
import com.yqbsoft.laser.service.data.domain.DaOrderTotal;
import com.yqbsoft.laser.service.data.service.DaOrderTotalService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DaOrderTotalServiceImpl
extends BaseServiceImpl
implements DaOrderTotalService {
    private static final String SYS_CODE = SYS_CODE + ".DaOrderTotalServiceImpl";
    private DaOrderTotalMapper daOrderTotalMapper;

    @Override
    public QueryResult<DaOrderTotal> queryOrderTotalPage(Map<String, Object> map) {
        List<DaOrderTotal> daOrderTotalList = this.queryOrderTotalModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrderTotal(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOrderTotalList);
        return queryResult;
    }

    @Override
    public String saveOrderTotalReBatch(List<DaOrderTotal> daOrderTotalList) throws ApiException {
        if (null == daOrderTotalList || daOrderTotalList.isEmpty()) {
            return null;
        }
        ArrayList<DaOrderTotal> daOrderTotalLists = new ArrayList<DaOrderTotal>();
        String code = "";
        for (DaOrderTotal orderTotal : daOrderTotalList) {
            this.setOrderTotalDefault(orderTotal);
            code = orderTotal.getOrderTotalCode();
            daOrderTotalLists.add(orderTotal);
        }
        this.saveOrderTotalBatchModel(daOrderTotalLists);
        return code;
    }

    @Override
    public String updateOrderTotalCyy(Map<String, Object> map) throws ApiException {
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateOrderTotalCyy(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalDataOcstate.ex", (Throwable)e);
        }
        return "success";
    }

    private List<DaOrderTotal> queryOrderTotalModelPage(Map<String, Object> parammap) {
        try {
            return this.daOrderTotalMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryOrderTotalModel", (Throwable)e);
            return null;
        }
    }

    private int countOrderTotal(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOrderTotalMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countOrderTotal", (Throwable)e);
        }
        return i;
    }

    private void setOrderTotalDefault(DaOrderTotal daOrderTotal) {
        if (null == daOrderTotal) {
            return;
        }
        if (null == daOrderTotal.getDataState()) {
            daOrderTotal.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOrderTotal.getGmtCreate()) {
            daOrderTotal.setGmtCreate(date);
        }
        daOrderTotal.setGmtModified(date);
        if (StringUtils.isBlank((String)daOrderTotal.getOrderTotalCode())) {
            daOrderTotal.setOrderTotalCode(this.getNo(null, "DaOrderTotal", "daOrderTotal", daOrderTotal.getTenantCode()));
        }
    }

    private void saveOrderTotalBatchModel(List<DaOrderTotal> daOrderTotalList) throws ApiException {
        if (null == daOrderTotalList || daOrderTotalList.isEmpty()) {
            return;
        }
        try {
            this.daOrderTotalMapper.insertBatch(daOrderTotalList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalBatchModel.ex", (Throwable)e);
        }
    }

    private Date getSysDate() {
        try {
            return this.daOrderTotalMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }
}

