/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaStoreSellMapper;
import com.yqbsoft.laser.service.data.domain.DaStoreSellDomain;
import com.yqbsoft.laser.service.data.domain.DaStoreSellReDomain;
import com.yqbsoft.laser.service.data.model.DaStoreSell;
import com.yqbsoft.laser.service.data.service.DaStoreSellService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaStoreSellServiceImpl
extends BaseServiceImpl
implements DaStoreSellService {
    private static final String SYS_CODE = "da.DaStoreSellServiceImpl";
    private DaStoreSellMapper daStoreSellMapper;

    public void setDaStoreSellMapper(DaStoreSellMapper daStoreSellMapper) {
        this.daStoreSellMapper = daStoreSellMapper;
    }

    private Date getSysDate() {
        try {
            return this.daStoreSellMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaStoreSellServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStoreSell(DaStoreSellDomain daStoreSellDomain) {
        if (null == daStoreSellDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daStoreSellDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStoreSellDefault(DaStoreSell daStoreSell) {
        if (null == daStoreSell) {
            return;
        }
        if (null == daStoreSell.getDataState()) {
            daStoreSell.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daStoreSell.getGmtCreate()) {
            daStoreSell.setGmtCreate(date);
        }
        daStoreSell.setGmtModified(date);
        if (StringUtils.isBlank((String)daStoreSell.getStoreSellCode())) {
            daStoreSell.setStoreSellCode(this.getNo(null, "DaStoreSell", "daStoreSell", daStoreSell.getTenantCode()));
        }
    }

    private int getStoreSellMaxCode() {
        int code = 0;
        try {
            return this.daStoreSellMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaStoreSellServiceImpl.getStoreSellMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreSellUpdataDefault(DaStoreSell daStoreSell) {
        if (null == daStoreSell) {
            return;
        }
        daStoreSell.setGmtModified(this.getSysDate());
    }

    private void saveStoreSellModel(DaStoreSell daStoreSell) throws ApiException {
        if (null == daStoreSell) {
            return;
        }
        try {
            this.daStoreSellMapper.insert(daStoreSell);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStoreSellServiceImpl.saveStoreSellModel.ex", (Throwable)e);
        }
    }

    private void saveStoreSellBatchModel(List<DaStoreSell> daStoreSellList) throws ApiException {
        if (null == daStoreSellList || daStoreSellList.isEmpty()) {
            return;
        }
        try {
            this.daStoreSellMapper.insertBatch(daStoreSellList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStoreSellServiceImpl.saveStoreSellBatchModel.ex", (Throwable)e);
        }
    }

    private DaStoreSell getStoreSellModelById(Integer storeSellId) {
        if (null == storeSellId) {
            return null;
        }
        try {
            return this.daStoreSellMapper.selectByPrimaryKey(storeSellId);
        }
        catch (Exception e) {
            this.logger.error("da.DaStoreSellServiceImpl.getStoreSellModelById", (Throwable)e);
            return null;
        }
    }

    private DaStoreSell getStoreSellModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daStoreSellMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaStoreSellServiceImpl.getStoreSellModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStoreSellModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daStoreSellMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStoreSellServiceImpl.delStoreSellModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaStoreSellServiceImpl.delStoreSellModelByCode.num");
        }
    }

    private void deleteStoreSellModel(Integer storeSellId) throws ApiException {
        if (null == storeSellId) {
            return;
        }
        int i = 0;
        try {
            i = this.daStoreSellMapper.deleteByPrimaryKey(storeSellId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStoreSellServiceImpl.deleteStoreSellModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaStoreSellServiceImpl.deleteStoreSellModel.num");
        }
    }

    private void updateStoreSellModel(DaStoreSell daStoreSell) throws ApiException {
        if (null == daStoreSell) {
            return;
        }
        int i = 0;
        try {
            i = this.daStoreSellMapper.updateByPrimaryKey(daStoreSell);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStoreSellServiceImpl.updateStoreSellModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaStoreSellServiceImpl.updateStoreSellModel.num");
        }
    }

    private void updateStateStoreSellModel(Integer storeSellId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == storeSellId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeSellId", storeSellId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daStoreSellMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStoreSellServiceImpl.updateStateStoreSellModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaStoreSellServiceImpl.updateStateStoreSellModel.null");
        }
    }

    private void updateStateStoreSellModelByCode(String tenantCode, String storeSellCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)storeSellCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSellCode", storeSellCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daStoreSellMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaStoreSellServiceImpl.updateStateStoreSellModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaStoreSellServiceImpl.updateStateStoreSellModelByCode.null");
        }
    }

    private DaStoreSell makeStoreSell(DaStoreSellDomain daStoreSellDomain, DaStoreSell daStoreSell) {
        if (null == daStoreSellDomain) {
            return null;
        }
        if (null == daStoreSell) {
            daStoreSell = new DaStoreSell();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daStoreSell, (Object)daStoreSellDomain);
            return daStoreSell;
        }
        catch (Exception e) {
            this.logger.error("da.DaStoreSellServiceImpl.makeStoreSell", (Throwable)e);
            return null;
        }
    }

    private DaStoreSellReDomain makeDaStoreSellReDomain(DaStoreSell daStoreSell) {
        if (null == daStoreSell) {
            return null;
        }
        DaStoreSellReDomain daStoreSellReDomain = new DaStoreSellReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daStoreSellReDomain, (Object)daStoreSell);
            return daStoreSellReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaStoreSellServiceImpl.makeDaStoreSellReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaStoreSell> queryStoreSellModelPage(Map<String, Object> parammap) {
        try {
            return this.daStoreSellMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaStoreSellServiceImpl.queryStoreSellModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreSell(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daStoreSellMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaStoreSellServiceImpl.countStoreSell", (Throwable)e);
        }
        return i;
    }

    private DaStoreSell createDaStoreSell(DaStoreSellDomain daStoreSellDomain) {
        String msg = this.checkStoreSell(daStoreSellDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaStoreSellServiceImpl.saveStoreSell.checkStoreSell", msg);
        }
        DaStoreSell daStoreSell = this.makeStoreSell(daStoreSellDomain, null);
        this.setStoreSellDefault(daStoreSell);
        return daStoreSell;
    }

    @Override
    public String saveStoreSell(DaStoreSellDomain daStoreSellDomain) throws ApiException {
        DaStoreSell daStoreSell = this.createDaStoreSell(daStoreSellDomain);
        this.saveStoreSellModel(daStoreSell);
        return daStoreSell.getStoreSellCode();
    }

    @Override
    public String saveStoreSellBatch(List<DaStoreSellDomain> daStoreSellDomainList) throws ApiException {
        if (null == daStoreSellDomainList || daStoreSellDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaStoreSell> daStoreSellList = new ArrayList<DaStoreSell>();
        String code = "";
        for (DaStoreSellDomain daStoreSellDomain : daStoreSellDomainList) {
            DaStoreSell daStoreSell = this.createDaStoreSell(daStoreSellDomain);
            code = daStoreSell.getStoreSellCode();
            daStoreSellList.add(daStoreSell);
        }
        this.saveStoreSellBatchModel(daStoreSellList);
        return code;
    }

    @Override
    public void updateStoreSellState(Integer storeSellId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == storeSellId) {
            return;
        }
        this.updateStateStoreSellModel(storeSellId, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreSellStateByCode(String tenantCode, String storeSellCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)storeSellCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateStoreSellModelByCode(tenantCode, storeSellCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreSell(DaStoreSellDomain daStoreSellDomain) throws ApiException {
        String msg = this.checkStoreSell(daStoreSellDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaStoreSellServiceImpl.updateStoreSell.checkStoreSell", msg);
        }
        DaStoreSell oldDaStoreSell = this.getStoreSellModelById(daStoreSellDomain.getStoreSellId());
        if (null == oldDaStoreSell) {
            throw new ApiException("da.DaStoreSellServiceImpl.updateStoreSell.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaStoreSell daStoreSell = this.makeStoreSell(daStoreSellDomain, oldDaStoreSell);
        this.setStoreSellUpdataDefault(daStoreSell);
        this.updateStoreSellModel(daStoreSell);
    }

    @Override
    public DaStoreSell getStoreSell(Integer storeSellId) {
        if (null == storeSellId) {
            return null;
        }
        return this.getStoreSellModelById(storeSellId);
    }

    @Override
    public void deleteStoreSell(Integer storeSellId) throws ApiException {
        if (null == storeSellId) {
            return;
        }
        this.deleteStoreSellModel(storeSellId);
    }

    @Override
    public QueryResult<DaStoreSell> queryStoreSellPage(Map<String, Object> map) {
        List<DaStoreSell> daStoreSellList = this.queryStoreSellModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreSell(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daStoreSellList);
        return queryResult;
    }

    @Override
    public DaStoreSell getStoreSellByCode(String tenantCode, String storeSellCode) throws ApiException {
        if (StringUtils.isBlank((String)storeSellCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSellCode", storeSellCode);
        return this.getStoreSellModelByCode(map);
    }

    @Override
    public void deleteStoreSellByCode(String tenantCode, String storeSellCode) throws ApiException {
        if (StringUtils.isBlank((String)storeSellCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSellCode", storeSellCode);
        this.delStoreSellModelByCode(map);
    }

    @Override
    public Map<String, Object> sumOrderStoreCount(String tenantCode, String conStr, String memberCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("condition", conStr);
        map.put("memberCode", memberCode);
        Map<String, Object> stringObjectMap = this.daStoreSellMapper.sumOrderStoreCount(map);
        this.logger.error("=====stringObjectMap=====", (Object)JsonUtil.buildNonNullBinder().toJson(stringObjectMap));
        return stringObjectMap;
    }

    @Override
    public Map<String, Object> sumBPStoreSellCount(String tenantCode, String conStr) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("condition", conStr);
        Map<String, Object> count = this.daStoreSellMapper.sumBPStoreSellCount(map);
        this.logger.error("=====sumBPStoreSellCount===count==", (Object)JsonUtil.buildNonNullBinder().toJson(count));
        return count;
    }

    @Override
    public Map<String, Object> sumNotBPStoreSellCount(String tenantCode, String conStr) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("condition", conStr);
        Map<String, Object> count = this.daStoreSellMapper.sumNotBPStoreSellCount(map);
        this.logger.error("=====sumNotBPStoreSellCount===count==", (Object)JsonUtil.buildNonNullBinder().toJson(count));
        return count;
    }

    @Override
    public Map<String, Object> sumOrderAgainStoreCount(String tenantCode, String conStr) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("condition", conStr);
        Map<String, Object> count = this.daStoreSellMapper.sumOrderAgainStoreCount(map);
        this.logger.error("=====sumOrderAgainStoreCount===count==", (Object)JsonUtil.buildNonNullBinder().toJson(count));
        return count;
    }

    @Override
    public Map<String, Object> sumBPOrderAgainStoreCount(String tenantCode, String conStr) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("condition", conStr);
        Map<String, Object> count = this.daStoreSellMapper.sumBPOrderAgainStoreCount(map);
        this.logger.error("=====sumBPOrderAgainStoreCount===count==", (Object)JsonUtil.buildNonNullBinder().toJson(count));
        return count;
    }

    @Override
    public Map<String, Object> sumNotBPOrderAgainStoreCount(String tenantCode, String conStr) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("condition", conStr);
        Map<String, Object> count = this.daStoreSellMapper.sumNotBPOrderAgainStoreCount(map);
        this.logger.error("=====sumNotBPOrderAgainStoreCount===count==", (Object)JsonUtil.buildNonNullBinder().toJson(count));
        return count;
    }

    @Override
    public Map<String, Object> sumBpDiscountMoney(String tenantCode, String conStr) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("condition", conStr);
        Map<String, Object> count = this.daStoreSellMapper.sumBpDiscountMoney(map);
        this.logger.error("=====sumBpDiscountMoney===count==", (Object)JsonUtil.buildNonNullBinder().toJson(count));
        return count;
    }

    @Override
    public Map<String, Object> sumNotBpDiscountMoney(String tenantCode, String conStr) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("condition", conStr);
        Map<String, Object> count = this.daStoreSellMapper.sumNotBpDiscountMoney(map);
        this.logger.error("=====sumNotBpDiscountMoney===count==", (Object)JsonUtil.buildNonNullBinder().toJson(count));
        return count;
    }

    @Override
    public Map<String, Object> sumBPActualContractMoney(String tenantCode, String conStr) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("condition", conStr);
        Map<String, Object> count = this.daStoreSellMapper.sumBPActualContractMoney(map);
        this.logger.error("=====sumBPActualContractMoney===count==", (Object)JsonUtil.buildNonNullBinder().toJson(count));
        return count;
    }

    @Override
    public Map<String, Object> sumNotBPActualContractMoney(String tenantCode, String conStr) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("condition", conStr);
        Map<String, Object> count = this.daStoreSellMapper.sumNotBPActualContractMoney(map);
        this.logger.error("=====sumNotBPActualContractMoney===count==", (Object)JsonUtil.buildNonNullBinder().toJson(count));
        return count;
    }

    @Override
    public List<DaStoreSell> selectMemberBCodeList(String tenantCode, String conStr) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("condition", conStr);
        List<DaStoreSell> list = this.daStoreSellMapper.selectMemberBCodeList(map);
        this.logger.error("=====selectMemberBCodeList===list==", (Object)JsonUtil.buildNonNullBinder().toJson(list));
        return list;
    }
}

