/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.thread;

import com.yqbsoft.laser.service.data.domain.DaOrderLogDomain;
import com.yqbsoft.laser.service.data.domain.DaStatisticsDomain;
import com.yqbsoft.laser.service.data.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.data.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.data.model.DaOrderLog;
import com.yqbsoft.laser.service.data.service.DaOrderLogService;
import com.yqbsoft.laser.service.data.service.DaStatisticsService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatisticsThread
implements Runnable {
    private final DaStatisticsService statisticsService;
    private final SgSendgoodsReDomain sendGoodsReDomain;
    private final DaOrderLogService orderLogService;
    private DaOrderLogDomain orderLogDomain;
    private final SupperLogUtil log = new SupperLogUtil(this.getClass());

    public StatisticsThread(DaStatisticsService statisticsService, SgSendgoodsReDomain sendGoodsReDomain, DaOrderLogService orderLogService, DaOrderLogDomain orderLogDomain) {
        this.statisticsService = statisticsService;
        this.sendGoodsReDomain = sendGoodsReDomain;
        this.orderLogService = orderLogService;
        this.orderLogDomain = orderLogDomain;
    }

    @Override
    public void run() {
        this.log.error("================\u603b\u8868\u7edf\u8ba1==============");
        List<SgSendgoodsGoodsDomain> list = this.sendGoodsReDomain.getSgSendgoodsGoodsDomainList();
        ArrayList<DaStatisticsDomain> domainList = new ArrayList<DaStatisticsDomain>();
        HashMap<String, DaStatisticsDomain> temp = new HashMap<String, DaStatisticsDomain>();
        Date dat = new Date();
        for (SgSendgoodsGoodsDomain goods : list) {
            String pl = goods.getPntreeCode();
            DaStatisticsDomain dsd = (DaStatisticsDomain)temp.get(pl);
            if (null == dsd) {
                dsd = new DaStatisticsDomain();
                dsd.setMemberCode(this.sendGoodsReDomain.getMemberCode());
                dsd.setMemberName(this.sendGoodsReDomain.getMemberName());
                dsd.setMemberBcode(this.sendGoodsReDomain.getMemberBcode());
                dsd.setMemberBname(this.sendGoodsReDomain.getMemberBname());
                dsd.setContractBillCode(this.sendGoodsReDomain.getContractBillcode());
                dsd.setParamName("PIN_LEI");
                dsd.setParamId(pl);
                dsd.setParamCode(goods.getPntreeName());
                dsd.setSellingPrice(goods.getContractGoodsInmoney());
                dsd.setPaidIn(goods.getPricesetBaseprice().multiply(goods.getGoodsNum()));
                dsd.setGoodsCost(goods.getPricesetNprice());
                dsd.setDiscountCount(goods.getContractGoodsInmoney().subtract(goods.getContractGoodsMoney()));
                dsd.setCreateTime(dat);
                temp.put(pl, dsd);
            } else {
                dsd.setSellingPrice(dsd.getSellingPrice().add(goods.getContractGoodsInmoney()));
                dsd.setPaidIn(dsd.getPaidIn().add(goods.getPricesetBaseprice().multiply(goods.getGoodsNum())));
                dsd.setGoodsCost(dsd.getGoodsCost().add(goods.getPricesetNprice()));
                dsd.setDiscountCount(dsd.getDiscountCount().add(goods.getContractGoodsInmoney().subtract(goods.getContractGoodsMoney())));
            }
            String brandCode = goods.getBrandCode();
            DaStatisticsDomain brand = (DaStatisticsDomain)temp.get(brandCode);
            if (null == brand) {
                brand = new DaStatisticsDomain();
                brand.setMemberCode(this.sendGoodsReDomain.getMemberCode());
                brand.setMemberName(this.sendGoodsReDomain.getMemberName());
                brand.setMemberBcode(this.sendGoodsReDomain.getMemberBcode());
                brand.setMemberBname(this.sendGoodsReDomain.getMemberBname());
                brand.setContractBillCode(this.sendGoodsReDomain.getContractBillcode());
                brand.setParamName("PIN_PAI");
                brand.setParamId(pl);
                brand.setParamCode(goods.getPntreeName());
                brand.setSellingPrice(goods.getContractGoodsInmoney());
                brand.setPaidIn(goods.getPricesetBaseprice().multiply(goods.getGoodsNum()));
                brand.setGoodsCost(goods.getPricesetNprice());
                brand.setDiscountCount(goods.getContractGoodsInmoney().subtract(goods.getContractGoodsMoney()));
                brand.setCreateTime(dat);
                temp.put(pl, brand);
            } else {
                brand.setSellingPrice(dsd.getSellingPrice().add(goods.getContractGoodsInmoney()));
                brand.setPaidIn(dsd.getPaidIn().add(goods.getPricesetBaseprice().multiply(goods.getGoodsNum())));
                brand.setGoodsCost(dsd.getGoodsCost().add(goods.getPricesetNprice()));
                brand.setDiscountCount(dsd.getDiscountCount().add(goods.getContractGoodsInmoney().subtract(goods.getContractGoodsMoney())));
            }
            String memberCcode = goods.getMemberCcode();
            DaStatisticsDomain member = (DaStatisticsDomain)temp.get(memberCcode);
            if (null == member) {
                member = new DaStatisticsDomain();
                member.setMemberCode(this.sendGoodsReDomain.getMemberCode());
                member.setMemberName(this.sendGoodsReDomain.getMemberName());
                member.setMemberBcode(this.sendGoodsReDomain.getMemberBcode());
                member.setMemberBname(this.sendGoodsReDomain.getMemberBname());
                member.setContractBillCode(this.sendGoodsReDomain.getContractBillcode());
                member.setParamName("SUPPLIER");
                member.setParamId(pl);
                member.setParamCode(goods.getPntreeName());
                member.setSellingPrice(goods.getContractGoodsInmoney());
                member.setPaidIn(goods.getPricesetBaseprice().multiply(goods.getGoodsNum()));
                member.setGoodsCost(goods.getPricesetNprice());
                member.setDiscountCount(goods.getContractGoodsInmoney().subtract(goods.getContractGoodsMoney()));
                member.setCreateTime(dat);
                temp.put(pl, member);
            } else {
                member.setSellingPrice(dsd.getSellingPrice().add(goods.getContractGoodsInmoney()));
                member.setPaidIn(dsd.getPaidIn().add(goods.getPricesetBaseprice().multiply(goods.getGoodsNum())));
                member.setGoodsCost(dsd.getGoodsCost().add(goods.getPricesetNprice()));
                member.setDiscountCount(dsd.getDiscountCount().add(goods.getContractGoodsInmoney().subtract(goods.getContractGoodsMoney())));
            }
            String dsr = "";
            for (Map.Entry obj : temp.entrySet()) {
                domainList.add((DaStatisticsDomain)obj.getValue());
            }
        }
        this.statisticsService.saveStatisticsBatch(domainList);
        DaOrderLog log = this.orderLogService.getOrderLogByCode(this.sendGoodsReDomain.getTenantCode(), this.orderLogDomain.getContractBillCode());
        if (null != log) {
            DaOrderLogDomain dld = new DaOrderLogDomain();
            try {
                BeanUtils.copyAllPropertys((Object)dld, (Object)log);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dld.setLogStat(false);
            this.orderLogService.updateOrderLog(dld);
        }
    }

    public void start() {
        new Thread(this).start();
    }
}

