/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOrderTotalGoodsMapper;
import com.yqbsoft.laser.service.data.dao.DaOrderTotalMapper;
import com.yqbsoft.laser.service.data.domain.DaOrderTotalGoodsDomain;
import com.yqbsoft.laser.service.data.domain.DaOrderTotalGoodsReDomain;
import com.yqbsoft.laser.service.data.domain.DaOrderTotalReDomain;
import com.yqbsoft.laser.service.data.model.DaOrderTotal;
import com.yqbsoft.laser.service.data.model.DaOrderTotalGoods;
import com.yqbsoft.laser.service.data.service.DaOrderTotalGoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaOrderTotalGoodsServiceImpl
extends BaseServiceImpl
implements DaOrderTotalGoodsService {
    private static final String SYS_CODE = SYS_CODE + ".DaOrderTotalGoodsServiceImpl";
    private DaOrderTotalGoodsMapper daOrderTotalGoodsMapper;
    private DaOrderTotalMapper daOrderTotalMapper;

    public void setDaOrderTotalGoodsMapper(DaOrderTotalGoodsMapper daOrderTotalGoodsMapper) {
        this.daOrderTotalGoodsMapper = daOrderTotalGoodsMapper;
    }

    public void setDaOrderTotalMapper(DaOrderTotalMapper daOrderTotalMapper) {
        this.daOrderTotalMapper = daOrderTotalMapper;
    }

    private Date getSysDate() {
        try {
            return this.daOrderTotalGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOrderTotalGoods(DaOrderTotalGoodsDomain daOrderTotalGoodsDomain) {
        if (null == daOrderTotalGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOrderTotalGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOrderTotalGoodsDefault(DaOrderTotalGoods daOrderTotalGoods) {
        if (null == daOrderTotalGoods) {
            return;
        }
        if (null == daOrderTotalGoods.getDataState()) {
            daOrderTotalGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOrderTotalGoods.getGmtCreate()) {
            daOrderTotalGoods.setGmtCreate(date);
        }
        daOrderTotalGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)daOrderTotalGoods.getOrderTotalGoodsCode())) {
            daOrderTotalGoods.setOrderTotalGoodsCode(this.getNo(null, "DaOrderTotalGoods", "daOrderTotalGoods", daOrderTotalGoods.getTenantCode()));
        }
    }

    private int getOrderTotalGoodsMaxCode() {
        int code = 0;
        try {
            return this.daOrderTotalGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getOrderTotalGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOrderTotalGoodsUpdataDefault(DaOrderTotalGoods daOrderTotalGoods) {
        if (null == daOrderTotalGoods) {
            return;
        }
        daOrderTotalGoods.setGmtModified(this.getSysDate());
    }

    private void saveOrderTotalGoodsModel(DaOrderTotalGoods daOrderTotalGoods) throws ApiException {
        if (null == daOrderTotalGoods) {
            return;
        }
        try {
            this.daOrderTotalGoodsMapper.insert(daOrderTotalGoods);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveOrderTotalGoodsBatchModel(List<DaOrderTotalGoods> daOrderTotalGoodsList) throws ApiException {
        if (null == daOrderTotalGoodsList || daOrderTotalGoodsList.isEmpty()) {
            return;
        }
        try {
            this.daOrderTotalGoodsMapper.insertBatch(daOrderTotalGoodsList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private DaOrderTotalGoods getOrderTotalGoodsModelById(Integer orderTotalGoodsId) {
        if (null == orderTotalGoodsId) {
            return null;
        }
        try {
            return this.daOrderTotalGoodsMapper.selectByPrimaryKey(orderTotalGoodsId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getOrderTotalGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private DaOrderTotalGoods getOrderTotalGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daOrderTotalGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getOrderTotalGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOrderTotalGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderTotalGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delOrderTotalGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delOrderTotalGoodsModelByCode.num");
        }
    }

    private void deleteOrderTotalGoodsModel(Integer orderTotalGoodsId) throws ApiException {
        if (null == orderTotalGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderTotalGoodsMapper.deleteByPrimaryKey(orderTotalGoodsId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteOrderTotalGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteOrderTotalGoodsModel.num");
        }
    }

    private void updateOrderTotalGoodsModel(DaOrderTotalGoods daOrderTotalGoods) throws ApiException {
        if (null == daOrderTotalGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderTotalGoodsMapper.updateByPrimaryKey(daOrderTotalGoods);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalGoodsModel.num");
        }
    }

    private void updateStateOrderTotalGoodsModel(Integer orderTotalGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == orderTotalGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderTotalGoodsId", orderTotalGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOrderTotalGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateOrderTotalGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateOrderTotalGoodsModel.null");
        }
    }

    private void updateStateOrderTotalGoodsModelByCode(String tenantCode, String orderTotalGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)orderTotalGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orderTotalGoodsCode", orderTotalGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOrderTotalGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateOrderTotalGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateOrderTotalGoodsModelByCode.null");
        }
    }

    private DaOrderTotalGoods makeOrderTotalGoods(DaOrderTotalGoodsDomain daOrderTotalGoodsDomain, DaOrderTotalGoods daOrderTotalGoods) {
        if (null == daOrderTotalGoodsDomain) {
            return null;
        }
        if (null == daOrderTotalGoods) {
            daOrderTotalGoods = new DaOrderTotalGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOrderTotalGoods, (Object)daOrderTotalGoodsDomain);
            return daOrderTotalGoods;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeOrderTotalGoods", (Throwable)e);
            return null;
        }
    }

    private DaOrderTotalGoodsReDomain makeDaOrderTotalGoodsReDomain(DaOrderTotalGoods daOrderTotalGoods) {
        if (null == daOrderTotalGoods) {
            return null;
        }
        DaOrderTotalGoodsReDomain daOrderTotalGoodsReDomain = new DaOrderTotalGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOrderTotalGoodsReDomain, (Object)daOrderTotalGoods);
            return daOrderTotalGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaOrderTotalGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaOrderTotalGoods> queryOrderTotalGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.daOrderTotalGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryOrderTotalGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countOrderTotalGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOrderTotalGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countOrderTotalGoods", (Throwable)e);
        }
        return i;
    }

    private DaOrderTotalGoods createDaOrderTotalGoods(DaOrderTotalGoodsDomain daOrderTotalGoodsDomain) {
        String msg = this.checkOrderTotalGoods(daOrderTotalGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalGoods.checkOrderTotalGoods", msg);
        }
        DaOrderTotalGoods daOrderTotalGoods = this.makeOrderTotalGoods(daOrderTotalGoodsDomain, null);
        this.setOrderTotalGoodsDefault(daOrderTotalGoods);
        return daOrderTotalGoods;
    }

    @Override
    public String saveOrderTotalGoods(DaOrderTotalGoodsDomain daOrderTotalGoodsDomain) throws ApiException {
        DaOrderTotalGoods daOrderTotalGoods = this.createDaOrderTotalGoods(daOrderTotalGoodsDomain);
        this.saveOrderTotalGoodsModel(daOrderTotalGoods);
        return daOrderTotalGoods.getOrderTotalGoodsCode();
    }

    @Override
    public String saveOrderTotalGoodsBatch(List<DaOrderTotalGoodsDomain> daOrderTotalGoodsDomainList) throws ApiException {
        if (null == daOrderTotalGoodsDomainList || daOrderTotalGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaOrderTotalGoods> daOrderTotalGoodsList = new ArrayList<DaOrderTotalGoods>();
        String code = "";
        for (DaOrderTotalGoodsDomain daOrderTotalGoodsDomain : daOrderTotalGoodsDomainList) {
            DaOrderTotalGoods daOrderTotalGoods = this.createDaOrderTotalGoods(daOrderTotalGoodsDomain);
            code = daOrderTotalGoods.getOrderTotalGoodsCode();
            daOrderTotalGoodsList.add(daOrderTotalGoods);
        }
        this.saveOrderTotalGoodsBatchModel(daOrderTotalGoodsList);
        return code;
    }

    @Override
    public void updateOrderTotalGoodsState(Integer orderTotalGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == orderTotalGoodsId) {
            return;
        }
        this.updateStateOrderTotalGoodsModel(orderTotalGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateOrderTotalGoodsStateByCode(String tenantCode, String orderTotalGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)orderTotalGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOrderTotalGoodsModelByCode(tenantCode, orderTotalGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOrderTotalGoods(DaOrderTotalGoodsDomain daOrderTotalGoodsDomain) throws ApiException {
        String msg = this.checkOrderTotalGoods(daOrderTotalGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalGoods.checkOrderTotalGoods", msg);
        }
        DaOrderTotalGoods oldDaOrderTotalGoods = this.getOrderTotalGoodsModelById(daOrderTotalGoodsDomain.getOrderTotalGoodsId());
        if (null == oldDaOrderTotalGoods) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaOrderTotalGoods daOrderTotalGoods = this.makeOrderTotalGoods(daOrderTotalGoodsDomain, oldDaOrderTotalGoods);
        this.setOrderTotalGoodsUpdataDefault(daOrderTotalGoods);
        this.updateOrderTotalGoodsModel(daOrderTotalGoods);
    }

    @Override
    public DaOrderTotalGoods getOrderTotalGoods(Integer orderTotalGoodsId) {
        if (null == orderTotalGoodsId) {
            return null;
        }
        return this.getOrderTotalGoodsModelById(orderTotalGoodsId);
    }

    @Override
    public void deleteOrderTotalGoods(Integer orderTotalGoodsId) throws ApiException {
        if (null == orderTotalGoodsId) {
            return;
        }
        this.deleteOrderTotalGoodsModel(orderTotalGoodsId);
    }

    @Override
    public QueryResult<DaOrderTotalGoods> queryOrderTotalGoodsPage(Map<String, Object> map) {
        List<DaOrderTotalGoods> daOrderTotalGoodsList = this.queryOrderTotalGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrderTotalGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOrderTotalGoodsList);
        return queryResult;
    }

    @Override
    public DaOrderTotalGoods getOrderTotalGoodsByCode(String tenantCode, String orderTotalGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)orderTotalGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orderTotalGoodsCode", orderTotalGoodsCode);
        return this.getOrderTotalGoodsModelByCode(map);
    }

    @Override
    public void deleteOrderTotalGoodsByCode(String tenantCode, String orderTotalGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)orderTotalGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orderTotalGoodsCode", orderTotalGoodsCode);
        this.delOrderTotalGoodsModelByCode(map);
    }

    @Override
    public QueryResult<DaOrderTotalGoodsReDomain> queryOrderTotalGoodsReDomainPage(Map<String, Object> map) {
        List<DaOrderTotalGoods> daOrderTotalGoodsList = this.queryOrderTotalGoodsModelPage(map);
        ArrayList<DaOrderTotalGoodsReDomain> reDomainList = new ArrayList<DaOrderTotalGoodsReDomain>();
        for (DaOrderTotalGoods goods : daOrderTotalGoodsList) {
            reDomainList.add(this.makeDaOrderTotalGoodsOrder(goods));
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrderTotalGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(reDomainList);
        return queryResult;
    }

    @Override
    public DaOrderTotalGoodsReDomain getOrderTotalGoodsReDomainByCode(String tenantCode, String orderTotalGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)orderTotalGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orderTotalGoodsCode", orderTotalGoodsCode);
        DaOrderTotalGoods goods = this.getOrderTotalGoodsModelByCode(map);
        return this.makeDaOrderTotalGoodsOrder(goods);
    }

    public DaOrderTotalGoodsReDomain makeDaOrderTotalGoodsOrder(DaOrderTotalGoods goods) {
        DaOrderTotalGoodsReDomain goodsDomain = this.makeDaOrderTotalGoodsReDomain(goods);
        if (goodsDomain == null) {
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", goodsDomain.getTenantCode());
        param.put("orderTotalCode", goodsDomain.getOrderTotalGoodsCode());
        this.logger.info(SYS_CODE + "goods params is" + ((Object)param).toString());
        DaOrderTotal orderTotal = this.daOrderTotalMapper.getByCode(param);
        goodsDomain.setDaOrderTotalDomain(this.makeDaOrderTotalReDomain(orderTotal));
        return goodsDomain;
    }

    private DaOrderTotalReDomain makeDaOrderTotalReDomain(DaOrderTotal daOrderTotal) {
        if (null == daOrderTotal) {
            return null;
        }
        DaOrderTotalReDomain daOrderTotalReDomain = new DaOrderTotalReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOrderTotalReDomain, (Object)daOrderTotal);
            return daOrderTotalReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaOrderTotalReDomain", (Throwable)e);
            return null;
        }
    }
}

