/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaClassSellMapper;
import com.yqbsoft.laser.service.data.domain.DaClassSellDomain;
import com.yqbsoft.laser.service.data.domain.DaClassSellReDomain;
import com.yqbsoft.laser.service.data.model.DaClassSell;
import com.yqbsoft.laser.service.data.service.DaClassSellService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaClassSellServiceImpl
extends BaseServiceImpl
implements DaClassSellService {
    private static final String SYS_CODE = "da.DaClassSellServiceImpl";
    private DaClassSellMapper daClassSellMapper;

    public void setDaClassSellMapper(DaClassSellMapper daClassSellMapper) {
        this.daClassSellMapper = daClassSellMapper;
    }

    private Date getSysDate() {
        try {
            return this.daClassSellMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaClassSellServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkClassSell(DaClassSellDomain daClassSellDomain) {
        if (null == daClassSellDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daClassSellDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setClassSellDefault(DaClassSell daClassSell) {
        if (null == daClassSell) {
            return;
        }
        if (null == daClassSell.getDataState()) {
            daClassSell.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daClassSell.getGmtCreate()) {
            daClassSell.setGmtCreate(date);
        }
        daClassSell.setGmtModified(date);
        if (StringUtils.isBlank((String)daClassSell.getClassSellcode())) {
            daClassSell.setClassSellcode(this.getNo(null, "DaClassSell", "daClassSell", daClassSell.getTenantCode()));
        }
    }

    private int getClassSellMaxCode() {
        int code = 0;
        try {
            return this.daClassSellMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaClassSellServiceImpl.getClassSellMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setClassSellUpdataDefault(DaClassSell daClassSell) {
        if (null == daClassSell) {
            return;
        }
        daClassSell.setGmtModified(this.getSysDate());
    }

    private void saveClassSellModel(DaClassSell daClassSell) throws ApiException {
        if (null == daClassSell) {
            return;
        }
        try {
            this.daClassSellMapper.insert(daClassSell);
        }
        catch (Exception e) {
            throw new ApiException("da.DaClassSellServiceImpl.saveClassSellModel.ex", (Throwable)e);
        }
    }

    private void saveClassSellBatchModel(List<DaClassSell> daClassSellList) throws ApiException {
        if (null == daClassSellList || daClassSellList.isEmpty()) {
            return;
        }
        try {
            this.daClassSellMapper.insertBatch(daClassSellList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaClassSellServiceImpl.saveClassSellBatchModel.ex", (Throwable)e);
        }
    }

    private DaClassSell getClassSellModelById(Integer classSellId) {
        if (null == classSellId) {
            return null;
        }
        try {
            return this.daClassSellMapper.selectByPrimaryKey(classSellId);
        }
        catch (Exception e) {
            this.logger.error("da.DaClassSellServiceImpl.getClassSellModelById", (Throwable)e);
            return null;
        }
    }

    private DaClassSell getClassSellModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daClassSellMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaClassSellServiceImpl.getClassSellModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delClassSellModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daClassSellMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaClassSellServiceImpl.delClassSellModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaClassSellServiceImpl.delClassSellModelByCode.num");
        }
    }

    private void deleteClassSellModel(Integer classSellId) throws ApiException {
        if (null == classSellId) {
            return;
        }
        int i = 0;
        try {
            i = this.daClassSellMapper.deleteByPrimaryKey(classSellId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaClassSellServiceImpl.deleteClassSellModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaClassSellServiceImpl.deleteClassSellModel.num");
        }
    }

    private void updateClassSellModel(DaClassSell daClassSell) throws ApiException {
        if (null == daClassSell) {
            return;
        }
        int i = 0;
        try {
            i = this.daClassSellMapper.updateByPrimaryKey(daClassSell);
        }
        catch (Exception e) {
            throw new ApiException("da.DaClassSellServiceImpl.updateClassSellModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaClassSellServiceImpl.updateClassSellModel.num");
        }
    }

    private void updateStateClassSellModel(Integer classSellId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == classSellId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classSellId", classSellId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daClassSellMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaClassSellServiceImpl.updateStateClassSellModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaClassSellServiceImpl.updateStateClassSellModel.null");
        }
    }

    private void updateStateClassSellModelByCode(String tenantCode, String classSellCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)classSellCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("classSellCode", classSellCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daClassSellMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaClassSellServiceImpl.updateStateClassSellModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaClassSellServiceImpl.updateStateClassSellModelByCode.null");
        }
    }

    private DaClassSell makeClassSell(DaClassSellDomain daClassSellDomain, DaClassSell daClassSell) {
        if (null == daClassSellDomain) {
            return null;
        }
        if (null == daClassSell) {
            daClassSell = new DaClassSell();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daClassSell, (Object)daClassSellDomain);
            return daClassSell;
        }
        catch (Exception e) {
            this.logger.error("da.DaClassSellServiceImpl.makeClassSell", (Throwable)e);
            return null;
        }
    }

    private DaClassSellReDomain makeDaClassSellReDomain(DaClassSell daClassSell) {
        if (null == daClassSell) {
            return null;
        }
        DaClassSellReDomain daClassSellReDomain = new DaClassSellReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daClassSellReDomain, (Object)daClassSell);
            return daClassSellReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaClassSellServiceImpl.makeDaClassSellReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaClassSell> queryClassSellModelPage(Map<String, Object> parammap) {
        try {
            return this.daClassSellMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaClassSellServiceImpl.queryClassSellModel", (Throwable)e);
            return null;
        }
    }

    private int countClassSell(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daClassSellMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaClassSellServiceImpl.countClassSell", (Throwable)e);
        }
        return i;
    }

    private DaClassSell createDaClassSell(DaClassSellDomain daClassSellDomain) {
        String msg = this.checkClassSell(daClassSellDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaClassSellServiceImpl.saveClassSell.checkClassSell", msg);
        }
        DaClassSell daClassSell = this.makeClassSell(daClassSellDomain, null);
        this.setClassSellDefault(daClassSell);
        return daClassSell;
    }

    @Override
    public String saveClassSell(DaClassSellDomain daClassSellDomain) throws ApiException {
        DaClassSell daClassSell = this.createDaClassSell(daClassSellDomain);
        this.saveClassSellModel(daClassSell);
        return daClassSell.getClassSellcode();
    }

    @Override
    public String saveClassSellBatch(List<DaClassSellDomain> daClassSellDomainList) throws ApiException {
        if (null == daClassSellDomainList || daClassSellDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaClassSell> daClassSellList = new ArrayList<DaClassSell>();
        String code = "";
        for (DaClassSellDomain daClassSellDomain : daClassSellDomainList) {
            DaClassSell daClassSell = this.createDaClassSell(daClassSellDomain);
            code = daClassSell.getClassSellcode();
            daClassSellList.add(daClassSell);
        }
        this.saveClassSellBatchModel(daClassSellList);
        return code;
    }

    @Override
    public void updateClassSellState(Integer classSellId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == classSellId) {
            return;
        }
        this.updateStateClassSellModel(classSellId, dataState, oldDataState, map);
    }

    @Override
    public void updateClassSellStateByCode(String tenantCode, String classSellCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)classSellCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateClassSellModelByCode(tenantCode, classSellCode, dataState, oldDataState, map);
    }

    @Override
    public void updateClassSell(DaClassSellDomain daClassSellDomain) throws ApiException {
        String msg = this.checkClassSell(daClassSellDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaClassSellServiceImpl.updateClassSell.checkClassSell", msg);
        }
        DaClassSell oldDaClassSell = this.getClassSellModelById(daClassSellDomain.getClassSellId());
        if (null == oldDaClassSell) {
            throw new ApiException("da.DaClassSellServiceImpl.updateClassSell.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaClassSell daClassSell = this.makeClassSell(daClassSellDomain, oldDaClassSell);
        this.setClassSellUpdataDefault(daClassSell);
        this.updateClassSellModel(daClassSell);
    }

    @Override
    public DaClassSell getClassSell(Integer classSellId) {
        if (null == classSellId) {
            return null;
        }
        return this.getClassSellModelById(classSellId);
    }

    @Override
    public void deleteClassSell(Integer classSellId) throws ApiException {
        if (null == classSellId) {
            return;
        }
        this.deleteClassSellModel(classSellId);
    }

    @Override
    public QueryResult<DaClassSell> queryClassSellPage(Map<String, Object> map) {
        List<DaClassSell> daClassSellList = this.queryClassSellModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countClassSell(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daClassSellList);
        return queryResult;
    }

    @Override
    public DaClassSell getClassSellByCode(String tenantCode, String classSellCode) throws ApiException {
        if (StringUtils.isBlank((String)classSellCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("classSellCode", classSellCode);
        return this.getClassSellModelByCode(map);
    }

    @Override
    public void deleteClassSellByCode(String tenantCode, String classSellCode) throws ApiException {
        if (StringUtils.isBlank((String)classSellCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("classSellCode", classSellCode);
        this.delClassSellModelByCode(map);
    }
}

