/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisDgoodsMapper;
import com.yqbsoft.laser.service.distribution.dao.DisDgoodsScopelistMapper;
import com.yqbsoft.laser.service.distribution.dao.DisDgoodsupMapper;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsScopelistDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsScopelistReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsupDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsupReDomain;
import com.yqbsoft.laser.service.distribution.model.DisDgoods;
import com.yqbsoft.laser.service.distribution.model.DisDgoodsScopelist;
import com.yqbsoft.laser.service.distribution.model.DisDgoodsup;
import com.yqbsoft.laser.service.distribution.service.DisDgoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DisDgoodsServiceImpl
extends BaseServiceImpl
implements DisDgoodsService {
    private static final String SYS_CODE = "dis.DisDgoodsServiceImpl";
    private DisDgoodsMapper disDgoodsMapper;
    private DisDgoodsScopelistMapper disDgoodsScopelistMapper;
    private DisDgoodsupMapper disDgoodsupMapper;
    private String cacheDgoods = "DisDgoods-channelCode";
    private String cacheDgoodsup = "DisDgoodsup-channelCode";
    private String cacheScopelist = "DisDgoodsScopelist-DgoodsCode";

    public void setDisDgoodsMapper(DisDgoodsMapper disDgoodsMapper) {
        this.disDgoodsMapper = disDgoodsMapper;
    }

    public void setDisDgoodsScopelistMapper(DisDgoodsScopelistMapper disDgoodsScopelistMapper) {
        this.disDgoodsScopelistMapper = disDgoodsScopelistMapper;
    }

    public void setDisDgoodsupMapper(DisDgoodsupMapper disDgoodsupMapper) {
        this.disDgoodsupMapper = disDgoodsupMapper;
    }

    private Date getSysDate() {
        try {
            return this.disDgoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDgoods(DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDgoodsDomain.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disDgoodsDomain.getMemberMcode())) {
            msg = msg + "MemberMcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disDgoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgoodsDefault(DisDgoods disDgoods) {
        if (null == disDgoods) {
            return;
        }
        if (null == disDgoods.getDataState()) {
            disDgoods.setDataState(0);
        }
        if (null == disDgoods.getGmtCreate()) {
            disDgoods.setGmtCreate(this.getSysDate());
        }
        disDgoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)disDgoods.getDgoodsCode())) {
            disDgoods.setDgoodsCode(this.createUUIDString());
        }
    }

    private int getDgoodsMaxCode() {
        int code = 0;
        try {
            return this.disDgoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.getDgoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgoodsUpdataDefault(DisDgoods disDgoods) {
        if (null == disDgoods) {
            return;
        }
        disDgoods.setGmtModified(this.getSysDate());
    }

    private void saveDgoodsModel(DisDgoods disDgoods) throws ApiException {
        if (null == disDgoods) {
            return;
        }
        try {
            this.disDgoodsMapper.insert(disDgoods);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.saveDgoodsModel.ex", (Throwable)e);
        }
    }

    public void saveDgoodsBatchModel(List<DisDgoods> disDgoodsList) throws ApiException {
        if (null == disDgoodsList || disDgoodsList.isEmpty()) {
            return;
        }
        try {
            this.disDgoodsMapper.insertBatch(disDgoodsList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.saveDgoodsBatchModel.ex", (Throwable)e);
        }
    }

    private DisDgoods getDgoodsModelById(Integer dgoodsId) {
        if (null == dgoodsId) {
            return null;
        }
        try {
            return this.disDgoodsMapper.selectByPrimaryKey(dgoodsId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.getDgoodsModelById", (Throwable)e);
            return null;
        }
    }

    private DisDgoods getDgoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDgoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.getDgoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.delDgoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsServiceImpl.delDgoodsModelByCode.num");
        }
    }

    private void deleteDgoodsModel(Integer dgoodsId) throws ApiException {
        if (null == dgoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsMapper.deleteByPrimaryKey(dgoodsId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.deleteDgoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsServiceImpl.deleteDgoodsModel.num");
        }
    }

    private void updateDgoodsModel(DisDgoods disDgoods) throws ApiException {
        if (null == disDgoods) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsMapper.updateByPrimaryKeySelective(disDgoods);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoodsModel.num");
        }
    }

    private void updateStateDgoodsModel(Integer dgoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == dgoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgoodsId", dgoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDgoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateStateDgoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateStateDgoodsModel.null");
        }
    }

    private void updateStateDgoodsModelByCode(String tenantCode, String dgoodsCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsCode", dgoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDgoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateStateDgoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateStateDgoodsModelByCode.null");
        }
    }

    private DisDgoods makeDgoods(DisDgoodsDomain disDgoodsDomain, DisDgoods disDgoods) {
        if (null == disDgoodsDomain) {
            return null;
        }
        if (null == disDgoods) {
            disDgoods = new DisDgoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDgoods, (Object)disDgoodsDomain);
            return disDgoods;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.makeDgoods", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsReDomain makeDisDgoodsReDomain(DisDgoods disDgoods) {
        if (null == disDgoods) {
            return null;
        }
        DisDgoodsReDomain disDgoodsReDomain = new DisDgoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsReDomain, (Object)disDgoods);
            return disDgoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.makeDisDgoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDgoods> queryDgoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.disDgoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.queryDgoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countDgoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDgoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.countDgoods", (Throwable)e);
        }
        return i;
    }

    private DisDgoods createDisDgoods(DisDgoodsDomain disDgoodsDomain) {
        String msg = this.checkDgoods(disDgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsServiceImpl.saveDgoods.checkDgoods", msg);
        }
        DisDgoods disDgoods = this.makeDgoods(disDgoodsDomain, null);
        this.setDgoodsDefault(disDgoods);
        return disDgoods;
    }

    private String checkDgoodsScopelist(DisDgoodsScopelistDomain disDgoodsScopelistDomain) {
        if (null == disDgoodsScopelistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDgoodsScopelistDomain.getDgoodsCode())) {
            msg = msg + "DgoodsCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disDgoodsScopelistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgoodsScopelistDefault(DisDgoodsScopelist disDgoodsScopelist) {
        if (null == disDgoodsScopelist) {
            return;
        }
        if (null == disDgoodsScopelist.getDataState()) {
            disDgoodsScopelist.setDataState(0);
        }
        if (null == disDgoodsScopelist.getGmtCreate()) {
            disDgoodsScopelist.setGmtCreate(this.getSysDate());
        }
        disDgoodsScopelist.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)disDgoodsScopelist.getDgoodsScopelistCode())) {
            disDgoodsScopelist.setDgoodsScopelistCode(this.createUUIDString());
        }
    }

    private int getDgoodsScopelistMaxCode() {
        int code = 0;
        try {
            return this.disDgoodsScopelistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.getDgoodsScopelistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgoodsScopelistUpdataDefault(DisDgoodsScopelist disDgoodsScopelist) {
        if (null == disDgoodsScopelist) {
            return;
        }
        disDgoodsScopelist.setGmtModified(this.getSysDate());
    }

    private void saveDgoodsScopelistModel(DisDgoodsScopelist disDgoodsScopelist) throws ApiException {
        if (null == disDgoodsScopelist) {
            return;
        }
        try {
            this.disDgoodsScopelistMapper.insert(disDgoodsScopelist);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.saveDgoodsScopelistModel.ex", (Throwable)e);
        }
    }

    private void saveDgoodsScopelistBatchModel(List<DisDgoodsScopelist> disDgoodsScopelistList) throws ApiException {
        if (null == disDgoodsScopelistList || disDgoodsScopelistList.isEmpty()) {
            return;
        }
        try {
            this.disDgoodsScopelistMapper.insertBatch(disDgoodsScopelistList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.saveDgoodsScopelistBatchModel.ex", (Throwable)e);
        }
    }

    private DisDgoodsScopelist getDgoodsScopelistModelById(Integer dgoodsScopelistId) {
        if (null == dgoodsScopelistId) {
            return null;
        }
        try {
            return this.disDgoodsScopelistMapper.selectByPrimaryKey(dgoodsScopelistId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.getDgoodsScopelistModelById", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsScopelist getDgoodsScopelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDgoodsScopelistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.getDgoodsScopelistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgoodsScopelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsScopelistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.delDgoodsScopelistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsServiceImpl.delDgoodsScopelistModelByCode.num");
        }
    }

    private void delDgoodsScopelistModelByDgoodsCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.disDgoodsScopelistMapper.delByDgoodsCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.delDgoodsScopelistModelByDgoodsCode.ex", (Throwable)e);
        }
    }

    private void deleteDgoodsScopelistModel(Integer dgoodsScopelistId) throws ApiException {
        if (null == dgoodsScopelistId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsScopelistMapper.deleteByPrimaryKey(dgoodsScopelistId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.deleteDgoodsScopelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsServiceImpl.deleteDgoodsScopelistModel.num");
        }
    }

    private void updateDgoodsScopelistModel(DisDgoodsScopelist disDgoodsScopelist) throws ApiException {
        if (null == disDgoodsScopelist) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsScopelistMapper.updateByPrimaryKeySelective(disDgoodsScopelist);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoodsScopelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoodsScopelistModel.num");
        }
    }

    private void updateStateDgoodsScopelistModel(Integer dgoodsScopelistId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == dgoodsScopelistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgoodsScopelistId", dgoodsScopelistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDgoodsScopelistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateStateDgoodsScopelistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateStateDgoodsScopelistModel.null");
        }
    }

    private void updateStateDgoodsScopelistModelByCode(String tenantCode, String dgoodsScopelistCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsScopelistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsScopelistCode", dgoodsScopelistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDgoodsScopelistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateStateDgoodsScopelistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateStateDgoodsScopelistModelByCode.null");
        }
    }

    private DisDgoodsScopelist makeDgoodsScopelist(DisDgoodsScopelistDomain disDgoodsScopelistDomain, DisDgoodsScopelist disDgoodsScopelist) {
        if (null == disDgoodsScopelistDomain) {
            return null;
        }
        if (null == disDgoodsScopelist) {
            disDgoodsScopelist = new DisDgoodsScopelist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsScopelist, (Object)disDgoodsScopelistDomain);
            return disDgoodsScopelist;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.makeDgoodsScopelist", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsScopelistReDomain makeDisDgoodsScopelistReDomain(DisDgoodsScopelist disDgoodsScopelist) {
        if (null == disDgoodsScopelist) {
            return null;
        }
        DisDgoodsScopelistReDomain disDgoodsScopelistReDomain = new DisDgoodsScopelistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsScopelistReDomain, (Object)disDgoodsScopelist);
            return disDgoodsScopelistReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.makeDisDgoodsScopelistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDgoodsScopelist> queryDgoodsScopelistModelPage(Map<String, Object> parammap) {
        try {
            return this.disDgoodsScopelistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.queryDgoodsScopelistModel", (Throwable)e);
            return null;
        }
    }

    private int countDgoodsScopelist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDgoodsScopelistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.countDgoodsScopelist", (Throwable)e);
        }
        return i;
    }

    private DisDgoodsScopelist createDisDgoodsScopelist(DisDgoodsScopelistDomain disDgoodsScopelistDomain) {
        String msg = this.checkDgoodsScopelist(disDgoodsScopelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsServiceImpl.saveDgoodsScopelist.checkDgoodsScopelist", msg);
        }
        DisDgoodsScopelist disDgoodsScopelist = this.makeDgoodsScopelist(disDgoodsScopelistDomain, null);
        this.setDgoodsScopelistDefault(disDgoodsScopelist);
        return disDgoodsScopelist;
    }

    private String checkDgoodsup(DisDgoodsupDomain disDgoodsupDomain) {
        if (null == disDgoodsupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDgoodsupDomain.getDgoodsupPeotype())) {
            msg = msg + "DgoodsupPeotype\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disDgoodsupDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgoodsupDefault(DisDgoodsup disDgoodsup) {
        if (null == disDgoodsup) {
            return;
        }
        if (null == disDgoodsup.getDataState()) {
            disDgoodsup.setDataState(0);
        }
        if (null == disDgoodsup.getGmtCreate()) {
            disDgoodsup.setGmtCreate(this.getSysDate());
        }
        disDgoodsup.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)disDgoodsup.getDgoodsupCode())) {
            disDgoodsup.setDgoodsupCode(this.createUUIDString());
        }
    }

    private int getDgoodsupMaxCode() {
        int code = 0;
        try {
            return this.disDgoodsupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.getDgoodsupMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgoodsupUpdataDefault(DisDgoodsup disDgoodsup) {
        if (null == disDgoodsup) {
            return;
        }
        disDgoodsup.setGmtModified(this.getSysDate());
    }

    private void saveDgoodsupModel(DisDgoodsup disDgoodsup) throws ApiException {
        if (null == disDgoodsup) {
            return;
        }
        try {
            this.disDgoodsupMapper.insert(disDgoodsup);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.saveDgoodsupModel.ex", (Throwable)e);
        }
    }

    private void saveDgoodsupBatchModel(List<DisDgoodsup> disDgoodsupList) throws ApiException {
        if (null == disDgoodsupList || disDgoodsupList.isEmpty()) {
            return;
        }
        try {
            this.disDgoodsupMapper.insertBatch(disDgoodsupList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.saveDgoodsupBatchModel.ex", (Throwable)e);
        }
    }

    private DisDgoodsup getDgoodsupModelById(Integer dgoodsupId) {
        if (null == dgoodsupId) {
            return null;
        }
        try {
            return this.disDgoodsupMapper.selectByPrimaryKey(dgoodsupId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.getDgoodsupModelById", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsup getDgoodsupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDgoodsupMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.getDgoodsupModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgoodsupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsupMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.delDgoodsupModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsServiceImpl.delDgoodsupModelByCode.num");
        }
    }

    private void deleteDgoodsupModel(Integer dgoodsupId) throws ApiException {
        if (null == dgoodsupId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsupMapper.deleteByPrimaryKey(dgoodsupId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.deleteDgoodsupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsServiceImpl.deleteDgoodsupModel.num");
        }
    }

    private void updateDgoodsupModel(DisDgoodsup disDgoodsup) throws ApiException {
        if (null == disDgoodsup) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsupMapper.updateByPrimaryKeySelective(disDgoodsup);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoodsupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoodsupModel.num");
        }
    }

    private void updateStateDgoodsupModel(Integer dgoodsupId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == dgoodsupId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgoodsupId", dgoodsupId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDgoodsupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateStateDgoodsupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateStateDgoodsupModel.null");
        }
    }

    private void updateStateDgoodsupModelByCode(String tenantCode, String dgoodsupCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsupCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsupCode", dgoodsupCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDgoodsupMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateStateDgoodsupModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateStateDgoodsupModelByCode.null");
        }
    }

    private DisDgoodsup makeDgoodsup(DisDgoodsupDomain disDgoodsupDomain, DisDgoodsup disDgoodsup) {
        if (null == disDgoodsupDomain) {
            return null;
        }
        if (null == disDgoodsup) {
            disDgoodsup = new DisDgoodsup();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsup, (Object)disDgoodsupDomain);
            return disDgoodsup;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.makeDgoodsup", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsupReDomain makeDisDgoodsupReDomain(DisDgoodsup disDgoodsup) {
        if (null == disDgoodsup) {
            return null;
        }
        DisDgoodsupReDomain disDgoodsupReDomain = new DisDgoodsupReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsupReDomain, (Object)disDgoodsup);
            return disDgoodsupReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.makeDisDgoodsupReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDgoodsup> queryDgoodsupModelPage(Map<String, Object> parammap) {
        try {
            return this.disDgoodsupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.queryDgoodsupModel", (Throwable)e);
            return null;
        }
    }

    private int countDgoodsup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDgoodsupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsServiceImpl.countDgoodsup", (Throwable)e);
        }
        return i;
    }

    private DisDgoodsup createDisDgoodsup(DisDgoodsupDomain disDgoodsupDomain) {
        String msg = this.checkDgoodsup(disDgoodsupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsServiceImpl.saveDgoodsup.checkDgoodsup", msg);
        }
        DisDgoodsup disDgoodsup = this.makeDgoodsup(disDgoodsupDomain, null);
        this.setDgoodsupDefault(disDgoodsup);
        return disDgoodsup;
    }

    @Override
    public String saveDgoods(DisDgoodsDomain disDgoodsDomain) throws ApiException {
        DisDgoods disDgoods = this.createDisDgoods(disDgoodsDomain);
        this.saveDgoodsModel(disDgoods);
        this.saveDgoodsListDomain(disDgoodsDomain.getDisDgoodsScopelistDomainList(), disDgoods);
        this.updateDgoodsCache(disDgoods);
        return disDgoods.getDgoodsCode();
    }

    private void saveDgoodsListDomain(List<DisDgoodsScopelistDomain> disDgoodsScopelistDomainList, DisDgoods disDgoods) {
        if (ListUtil.isEmpty(disDgoodsScopelistDomainList) || null == disDgoods) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgoodsCode", disDgoods.getDgoodsCode());
        map.put("tenantCode", disDgoods.getTenantCode());
        this.delDgoodsScopelistModelByDgoodsCode(map);
        for (DisDgoodsScopelistDomain disDgoodsScopelistDomain : disDgoodsScopelistDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)disDgoodsScopelistDomain, (Object)disDgoods);
            }
            catch (Exception e) {}
        }
        this.saveDgoodsScopelistBatch(disDgoodsScopelistDomainList);
    }

    private void updateDgoodsListDomain(List<DisDgoodsScopelistDomain> disDgoodsScopelistDomainList, DisDgoods disDgoods) {
        if (ListUtil.isEmpty(disDgoodsScopelistDomainList) || null == disDgoods) {
            return;
        }
        this.delDgoodsScopelistModelByDgoodsCode(this.getQueryMapParam("dgoodsCode,tenantCode", new Object[]{disDgoods.getDgoodsCode(), disDgoods.getTenantCode()}));
        this.saveDgoodsListDomain(disDgoodsScopelistDomainList, disDgoods);
    }

    @Override
    public String saveDgoodsBatch(List<DisDgoodsDomain> disDgoodsDomainList) throws ApiException {
        if (null == disDgoodsDomainList || disDgoodsDomainList.isEmpty()) {
            return null;
        }
        for (DisDgoodsDomain disDgoodsDomain : disDgoodsDomainList) {
            this.saveDgoods(disDgoodsDomain);
        }
        return "";
    }

    @Override
    public void updateDgoodsState(Integer dgoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDgoodsModel(dgoodsId, dataState, oldDataState);
        if (-1 == dataState) {
            DisDgoods disDgoods = this.getDgoods(dgoodsId);
            this.deleteDgoodsCache(disDgoods);
        }
    }

    @Override
    public void updateDgoodsStateByCode(String tenantCode, String dgoodsCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDgoodsModelByCode(tenantCode, dgoodsCode, dataState, oldDataState);
        if (-1 == dataState) {
            DisDgoods disDgoods = this.getDgoodsByCode(tenantCode, dgoodsCode);
            this.deleteDgoodsCache(disDgoods);
        }
    }

    @Override
    public void updateDgoods(DisDgoodsDomain disDgoodsDomain) throws ApiException {
        String msg = this.checkDgoods(disDgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoods.checkDgoods", msg);
        }
        DisDgoods oldDisDgoods = this.getDgoodsModelById(disDgoodsDomain.getDgoodsId());
        if (null == oldDisDgoods) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDgoods disDgoods = this.makeDgoods(disDgoodsDomain, oldDisDgoods);
        this.setDgoodsUpdataDefault(disDgoods);
        this.updateDgoodsModel(disDgoods);
        oldDisDgoods = this.getDgoodsModelById(disDgoodsDomain.getDgoodsId());
        if (null == oldDisDgoods) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateDgoodsCache(oldDisDgoods);
        this.updateDgoodsListDomain(disDgoodsDomain.getDisDgoodsScopelistDomainList(), oldDisDgoods);
    }

    @Override
    public DisDgoods getDgoods(Integer dgoodsId) {
        return this.getDgoodsModelById(dgoodsId);
    }

    @Override
    public void deleteDgoods(Integer dgoodsId) throws ApiException {
        DisDgoods disDgoods = this.getDgoods(dgoodsId);
        this.deleteDgoodsCache(disDgoods);
        this.deleteDgoodsModel(dgoodsId);
    }

    @Override
    public QueryResult<DisDgoods> queryDgoodsPage(Map<String, Object> map) {
        List<DisDgoods> disDgoodsList = this.queryDgoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDgoodsList);
        return queryResult;
    }

    @Override
    public DisDgoods getDgoodsByCode(String tenantCode, String dgoodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsCode", dgoodsCode);
        return this.getDgoodsModelByCode(map);
    }

    @Override
    public void deleteDgoodsByCode(String tenantCode, String dgoodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsCode", dgoodsCode);
        DisDgoods disDgoods = this.getDgoodsByCode(tenantCode, dgoodsCode);
        this.delDgoodsModelByCode(map);
        this.deleteDgoodsCache(disDgoods);
    }

    @Override
    public String saveDgoodsScopelist(DisDgoodsScopelistDomain disDgoodsScopelistDomain) throws ApiException {
        DisDgoodsScopelist disDgoodsScopelist = this.createDisDgoodsScopelist(disDgoodsScopelistDomain);
        this.saveDgoodsScopelistModel(disDgoodsScopelist);
        this.updateDgoodsScopeCache(disDgoodsScopelist);
        return disDgoodsScopelist.getDgoodsScopelistCode();
    }

    @Override
    public String saveDgoodsScopelistBatch(List<DisDgoodsScopelistDomain> disDgoodsScopelistDomainList) throws ApiException {
        if (null == disDgoodsScopelistDomainList || disDgoodsScopelistDomainList.isEmpty()) {
            return null;
        }
        if (StringUtils.isBlank((String)disDgoodsScopelistDomainList.get(0).getDgoodsCode())) {
            return null;
        }
        ArrayList<DisDgoodsScopelist> disDgoodsScopelistList = new ArrayList<DisDgoodsScopelist>();
        String code = "";
        if (!"removeAll".equals(disDgoodsScopelistDomainList.get(0).getDgoodsScopelistValuen())) {
            for (DisDgoodsScopelistDomain disDgoodsScopelistDomain : disDgoodsScopelistDomainList) {
                DisDgoodsScopelist disDgoodsScopelist = this.createDisDgoodsScopelist(disDgoodsScopelistDomain);
                code = disDgoodsScopelist.getDgoodsScopelistCode();
                disDgoodsScopelistList.add(disDgoodsScopelist);
            }
            this.saveDgoodsScopelistBatchModel(disDgoodsScopelistList);
            for (DisDgoodsScopelist disDgoodsScopelist2 : disDgoodsScopelistList) {
                this.updateDgoodsScopeCache(disDgoodsScopelist2);
            }
        }
        return code;
    }

    @Override
    public void updateDgoodsScopelistState(Integer dgoodsScopelistId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDgoodsScopelistModel(dgoodsScopelistId, dataState, oldDataState);
        if (-1 == dataState) {
            DisDgoodsScopelist disDgoodsScopelist = this.getDgoodsScopelist(dgoodsScopelistId);
            this.deleteDgoodsScopeCache(disDgoodsScopelist);
        } else if (-1 == oldDataState) {
            DisDgoodsScopelist disDgoodsScopelist = this.getDgoodsScopelist(dgoodsScopelistId);
            this.updateDgoodsScopeCache(disDgoodsScopelist);
        }
    }

    @Override
    public void updateDgoodsScopelistStateByCode(String tenantCode, String dgoodsScopelistCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDgoodsScopelistModelByCode(tenantCode, dgoodsScopelistCode, dataState, oldDataState);
        if (-1 == dataState) {
            DisDgoodsScopelist disDgoodsScopelist = this.getDgoodsScopelistByCode(tenantCode, dgoodsScopelistCode);
            this.deleteDgoodsScopeCache(disDgoodsScopelist);
        } else if (-1 == oldDataState) {
            DisDgoodsScopelist disDgoodsScopelist = this.getDgoodsScopelistByCode(tenantCode, dgoodsScopelistCode);
            this.updateDgoodsScopeCache(disDgoodsScopelist);
        }
    }

    @Override
    public void updateDgoodsScopelist(DisDgoodsScopelistDomain disDgoodsScopelistDomain) throws ApiException {
        String msg = this.checkDgoodsScopelist(disDgoodsScopelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoodsScopelist.checkDgoodsScopelist", msg);
        }
        DisDgoodsScopelist oldDisDgoodsScopelist = this.getDgoodsScopelistModelById(disDgoodsScopelistDomain.getDgoodsScopelistId());
        if (null == oldDisDgoodsScopelist) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoodsScopelist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDgoodsScopelist disDgoodsScopelist = this.makeDgoodsScopelist(disDgoodsScopelistDomain, oldDisDgoodsScopelist);
        this.setDgoodsScopelistUpdataDefault(disDgoodsScopelist);
        this.updateDgoodsScopelistModel(disDgoodsScopelist);
        this.updateDgoodsScopeCache(disDgoodsScopelist);
    }

    @Override
    public DisDgoodsScopelist getDgoodsScopelist(Integer dgoodsScopelistId) {
        return this.getDgoodsScopelistModelById(dgoodsScopelistId);
    }

    @Override
    public void deleteDgoodsScopelist(Integer dgoodsScopelistId) throws ApiException {
        DisDgoodsScopelist disDgoodsScopelist = this.getDgoodsScopelist(dgoodsScopelistId);
        this.deleteDgoodsScopelistModel(dgoodsScopelistId);
        this.deleteDgoodsScopeCache(disDgoodsScopelist);
    }

    @Override
    public QueryResult<DisDgoodsScopelist> queryDgoodsScopelistPage(Map<String, Object> map) {
        List<DisDgoodsScopelist> disDgoodsScopelistList = this.queryDgoodsScopelistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgoodsScopelist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDgoodsScopelistList);
        return queryResult;
    }

    @Override
    public DisDgoodsScopelist getDgoodsScopelistByCode(String tenantCode, String dgoodsScopelistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsScopelistCode", dgoodsScopelistCode);
        return this.getDgoodsScopelistModelByCode(map);
    }

    @Override
    public void deleteDgoodsScopelistByCode(String tenantCode, String dgoodsScopelistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsScopelistCode", dgoodsScopelistCode);
        DisDgoodsScopelist disDgoodsScopelist = this.getDgoodsScopelistByCode(tenantCode, dgoodsScopelistCode);
        this.delDgoodsScopelistModelByCode(map);
        this.deleteDgoodsScopeCache(disDgoodsScopelist);
    }

    @Override
    public String saveDgoodsup(DisDgoodsupDomain disDgoodsupDomain) throws ApiException {
        DisDgoodsup disDgoodsup = this.createDisDgoodsup(disDgoodsupDomain);
        this.saveDgoodsupModel(disDgoodsup);
        this.updateDgoodsupCache(disDgoodsup);
        return disDgoodsup.getDgoodsupCode();
    }

    @Override
    public String saveDgoodsupBatch(List<DisDgoodsupDomain> disDgoodsupDomainList) throws ApiException {
        if (null == disDgoodsupDomainList || disDgoodsupDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDgoodsup> disDgoodsupList = new ArrayList<DisDgoodsup>();
        String code = "";
        for (DisDgoodsupDomain disDgoodsupDomain : disDgoodsupDomainList) {
            DisDgoodsup disDgoodsup = this.createDisDgoodsup(disDgoodsupDomain);
            code = disDgoodsup.getDgoodsupCode();
            disDgoodsupList.add(disDgoodsup);
        }
        this.saveDgoodsupBatchModel(disDgoodsupList);
        for (DisDgoodsup disDgoodsup2 : disDgoodsupList) {
            this.updateDgoodsupCache(disDgoodsup2);
        }
        return code;
    }

    @Override
    public void updateDgoodsupState(Integer dgoodsupId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDgoodsupModel(dgoodsupId, dataState, oldDataState);
        if (-1 == dataState) {
            DisDgoodsup disDgoodsup = this.getDgoodsup(dgoodsupId);
            this.deleteDgoodsupCache(disDgoodsup);
        }
    }

    @Override
    public void updateDgoodsupStateByCode(String tenantCode, String dgoodsupCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDgoodsupModelByCode(tenantCode, dgoodsupCode, dataState, oldDataState);
        if (-1 == dataState) {
            DisDgoodsup disDgoodsup = this.getDgoodsupByCode(tenantCode, dgoodsupCode);
            this.deleteDgoodsupCache(disDgoodsup);
        }
    }

    @Override
    public void updateDgoodsup(DisDgoodsupDomain disDgoodsupDomain) throws ApiException {
        String msg = this.checkDgoodsup(disDgoodsupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoodsup.checkDgoodsup", msg);
        }
        DisDgoodsup oldDisDgoodsup = this.getDgoodsupModelById(disDgoodsupDomain.getDgoodsupId());
        if (null == oldDisDgoodsup) {
            throw new ApiException("dis.DisDgoodsServiceImpl.updateDgoodsup.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDgoodsup disDgoodsup = this.makeDgoodsup(disDgoodsupDomain, oldDisDgoodsup);
        this.setDgoodsupUpdataDefault(disDgoodsup);
        this.updateDgoodsupModel(disDgoodsup);
        this.updateDgoodsupCache(disDgoodsup);
    }

    @Override
    public DisDgoodsup getDgoodsup(Integer dgoodsupId) {
        return this.getDgoodsupModelById(dgoodsupId);
    }

    @Override
    public void deleteDgoodsup(Integer dgoodsupId) throws ApiException {
        DisDgoodsup disDgoodsup = this.getDgoodsup(dgoodsupId);
        this.deleteDgoodsupModel(dgoodsupId);
        this.deleteDgoodsupCache(disDgoodsup);
    }

    @Override
    public QueryResult<DisDgoodsup> queryDgoodsupPage(Map<String, Object> map) {
        List<DisDgoodsup> disDgoodsupList = this.queryDgoodsupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgoodsup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDgoodsupList);
        return queryResult;
    }

    @Override
    public DisDgoodsup getDgoodsupByCode(String tenantCode, String dgoodsupCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsupCode", dgoodsupCode);
        return this.getDgoodsupModelByCode(map);
    }

    @Override
    public void deleteDgoodsupByCode(String tenantCode, String dgoodsupCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsupCode", dgoodsupCode);
        DisDgoodsup disDgoodsup = this.getDgoodsupByCode(tenantCode, dgoodsupCode);
        this.delDgoodsupModelByCode(map);
        this.deleteDgoodsupCache(disDgoodsup);
    }

    private void deleteDgoodsupCache(DisDgoodsup disDgoodsup) {
        if (null == disDgoodsup) {
            return;
        }
        String json = DisUtil.getRemotMap((String)this.cacheDgoodsup, (String)(disDgoodsup.getChannelCode() + "-" + disDgoodsup.getTenantCode()));
        List scopeList = StringUtils.isBlank((String)json) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgoodsup.class);
        if (null == scopeList) {
            scopeList = new ArrayList();
        } else if (!scopeList.isEmpty()) {
            ArrayList<DisDgoodsup> configcacheList = new ArrayList<DisDgoodsup>();
            for (DisDgoodsup disDgoodsup2 : scopeList) {
                if (disDgoodsup2.getDgoodsCode().equals(disDgoodsup.getChannelCode())) continue;
                configcacheList.add(disDgoodsup2);
            }
            scopeList = configcacheList;
        }
        if (null == scopeList || scopeList.isEmpty()) {
            DisUtil.delMap((String)this.cacheDgoodsup, (String[])new String[]{disDgoodsup.getChannelCode() + disDgoodsup.getTenantCode()});
        } else {
            DisUtil.setMapVer((String)this.cacheDgoodsup, (String)(disDgoodsup.getChannelCode() + "-" + disDgoodsup.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(scopeList));
        }
    }

    private void updateDgoodsupCache(DisDgoodsup disDgoodsup) {
        if (null == disDgoodsup) {
            return;
        }
        String json = DisUtil.getRemotMap((String)this.cacheDgoodsup, (String)(disDgoodsup.getChannelCode() + "-" + disDgoodsup.getTenantCode()));
        List scopeList = StringUtils.isBlank((String)json) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgoodsup.class);
        if (null == scopeList) {
            scopeList = new ArrayList();
        } else if (!scopeList.isEmpty()) {
            ArrayList<DisDgoodsup> configcacheList = new ArrayList<DisDgoodsup>();
            for (DisDgoodsup disDgoodsup2 : scopeList) {
                if (disDgoodsup2.getDgoodsCode().equals(disDgoodsup.getDgoodsCode())) {
                    configcacheList.add(disDgoodsup);
                    continue;
                }
                configcacheList.add(disDgoodsup2);
            }
            scopeList = configcacheList;
        }
        scopeList.add(disDgoodsup);
        DisUtil.setMapVer((String)this.cacheDgoodsup, (String)(disDgoodsup.getChannelCode() + "-" + disDgoodsup.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(scopeList));
    }

    private void deleteDgoodsScopeCache(DisDgoodsScopelist disDgoodsScopelist) {
        if (null == disDgoodsScopelist) {
            return;
        }
        String json = DisUtil.getRemotMap((String)this.cacheScopelist, (String)(disDgoodsScopelist.getDgoodsCode() + "-" + disDgoodsScopelist.getTenantCode()));
        List scopeList = StringUtils.isBlank((String)json) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgoodsScopelist.class);
        if (null == scopeList) {
            scopeList = new ArrayList();
        } else if (!scopeList.isEmpty()) {
            ArrayList<DisDgoodsScopelist> configcacheList = new ArrayList<DisDgoodsScopelist>();
            for (DisDgoodsScopelist disDgoodsScopelist2 : scopeList) {
                if (disDgoodsScopelist2.getDgoodsScopelistCode().equals(disDgoodsScopelist.getDgoodsScopelistCode())) continue;
                configcacheList.add(disDgoodsScopelist2);
            }
            scopeList = configcacheList;
        }
        if (null == scopeList || scopeList.isEmpty()) {
            DisUtil.delMap((String)this.cacheScopelist, (String[])new String[]{disDgoodsScopelist.getDgoodsCode() + "-" + disDgoodsScopelist.getTenantCode()});
        } else {
            DisUtil.setMapVer((String)this.cacheScopelist, (String)(disDgoodsScopelist.getDgoodsCode() + "-" + disDgoodsScopelist.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(scopeList));
        }
    }

    private void updateDgoodsScopeCache(DisDgoodsScopelist disDgoodsScopelist) {
        if (null == disDgoodsScopelist) {
            return;
        }
        String json = DisUtil.getRemotMap((String)this.cacheScopelist, (String)(disDgoodsScopelist.getDgoodsCode() + "-" + disDgoodsScopelist.getTenantCode()));
        List scopeList = StringUtils.isBlank((String)json) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgoodsScopelist.class);
        if (null == scopeList) {
            scopeList = new ArrayList();
        } else if (!scopeList.isEmpty()) {
            ArrayList<DisDgoodsScopelist> configcacheList = new ArrayList<DisDgoodsScopelist>();
            for (DisDgoodsScopelist disDgoodsScopelist2 : scopeList) {
                if (disDgoodsScopelist2.getDgoodsScopelistCode().equals(disDgoodsScopelist.getDgoodsScopelistCode())) {
                    configcacheList.add(disDgoodsScopelist);
                    continue;
                }
                configcacheList.add(disDgoodsScopelist2);
            }
            scopeList = configcacheList;
        }
        scopeList.add(disDgoodsScopelist);
        DisUtil.setMapVer((String)this.cacheScopelist, (String)(disDgoodsScopelist.getDgoodsCode() + "-" + disDgoodsScopelist.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(scopeList));
    }

    private void deleteDgoodsCache(DisDgoods disDgoods) {
        if (null == disDgoods) {
            return;
        }
        DisUtil.delMap((String)this.cacheDgoods, (String[])new String[]{disDgoods.getChannelCode() + "-" + disDgoods.getTenantCode()});
    }

    private void updateDgoodsCache(DisDgoods disDgoods) {
        if (null == disDgoods) {
            return;
        }
        DisUtil.setMapVer((String)this.cacheDgoods, (String)(disDgoods.getChannelCode() + "-" + disDgoods.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)disDgoods));
    }

    @Override
    public void queryDgoodLoadCache() {
        this.logger.info("DisDgoodsService.queryDgoodLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<DisDgoods> disDgoodsList = this.queryDgoodsModelPage(parammap);
        if (null == disDgoodsList || disDgoodsList.isEmpty()) {
            DisUtil.delVer((String)this.cacheDgoods);
            DisUtil.delVer((String)this.cacheDgoodsup);
            DisUtil.delVer((String)this.cacheScopelist);
            this.logger.info("DisDgoodsService.queryDgoodLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> dgoodsMap = new ConcurrentHashMap<String, String>();
        for (DisDgoods disDgoods : disDgoodsList) {
            dgoodsMap.put(disDgoods.getChannelCode() + "-" + disDgoods.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)disDgoods));
        }
        DisUtil.setMapVer((String)this.cacheDgoods, dgoodsMap);
        List<DisDgoodsup> uplist = this.queryDgoodsupModelPage(parammap);
        ConcurrentHashMap<String, String> dgoodsupMap = new ConcurrentHashMap<String, String>();
        if (null != uplist && !uplist.isEmpty()) {
            ConcurrentHashMap<String, ArrayList<DisDgoodsup>> dgoodsupListMap = new ConcurrentHashMap<String, ArrayList<DisDgoodsup>>();
            for (DisDgoodsup disDgoodsup : uplist) {
                ArrayList<DisDgoodsup> upcachelist = (ArrayList<DisDgoodsup>)dgoodsupListMap.get(disDgoodsup.getChannelCode() + "-" + disDgoodsup.getTenantCode());
                if (null == upcachelist) {
                    upcachelist = new ArrayList<DisDgoodsup>();
                    dgoodsupListMap.put(disDgoodsup.getChannelCode() + "-" + disDgoodsup.getTenantCode(), upcachelist);
                }
                upcachelist.add(disDgoodsup);
            }
            for (String key : dgoodsupListMap.keySet()) {
                dgoodsupMap.put(key, JsonUtil.buildNormalBinder().toJson(dgoodsupListMap.get(key)));
            }
            DisUtil.setMapVer((String)this.cacheDgoodsup, dgoodsupMap);
        }
        List<DisDgoodsScopelist> scopelist = this.queryDgoodsScopelistModelPage(parammap);
        ConcurrentHashMap<String, String> scopeMap = new ConcurrentHashMap<String, String>();
        if (null != scopelist && !scopelist.isEmpty()) {
            ConcurrentHashMap<String, ArrayList<DisDgoodsScopelist>> scopeListMap = new ConcurrentHashMap<String, ArrayList<DisDgoodsScopelist>>();
            for (DisDgoodsScopelist disDgoodsScopelist : scopelist) {
                ArrayList<DisDgoodsScopelist> upcachelist = (ArrayList<DisDgoodsScopelist>)scopeListMap.get(disDgoodsScopelist.getDgoodsCode() + "-" + disDgoodsScopelist.getTenantCode());
                if (null == upcachelist) {
                    upcachelist = new ArrayList<DisDgoodsScopelist>();
                    scopeListMap.put(disDgoodsScopelist.getDgoodsCode() + "-" + disDgoodsScopelist.getTenantCode(), upcachelist);
                }
                upcachelist.add(disDgoodsScopelist);
            }
            for (String key : scopeListMap.keySet()) {
                scopeMap.put(key, JsonUtil.buildNormalBinder().toJson(scopeListMap.get(key)));
            }
            DisUtil.setMapVer((String)this.cacheScopelist, scopeMap);
        }
    }

    @Override
    public void deleteDgoodsScopelistByScopeCode(String tenantCode, String dgoodsScopeCode) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsScopeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgoodsScopeCode", dgoodsScopeCode);
        map.put("tenantCode", tenantCode);
        this.delDgoodsScopelistModelByDgoodsCode(map);
    }
}

