/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisOauthTokenMapper;
import com.yqbsoft.laser.service.distribution.domain.DisOauthTokenDomain;
import com.yqbsoft.laser.service.distribution.domain.DisOauthTokenReDomain;
import com.yqbsoft.laser.service.distribution.es.TokenSendPollThread;
import com.yqbsoft.laser.service.distribution.es.TokenSendPutThread;
import com.yqbsoft.laser.service.distribution.es.TokenSendService;
import com.yqbsoft.laser.service.distribution.model.DisOauthToken;
import com.yqbsoft.laser.service.distribution.service.DisOauthTokenService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DisOauthTokenServiceImpl
extends BaseServiceImpl
implements DisOauthTokenService {
    private static final String SYS_CODE = "dis.DisOauthTokenServiceImpl";
    private DisOauthTokenMapper disOauthTokenMapper;
    private String cachekey = "DisOauthToken-channelCode";
    private static TokenSendService tokenSendService;
    private static Object lock;
    String apiCode = "cmc.disOauth.reflashToken";

    public void setDisOauthTokenMapper(DisOauthTokenMapper disOauthTokenMapper) {
        this.disOauthTokenMapper = disOauthTokenMapper;
    }

    private Date getSysDate() {
        try {
            return this.disOauthTokenMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisOauthTokenServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOauthToken(DisOauthTokenDomain disOauthTokenDomain) {
        if (null == disOauthTokenDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disOauthTokenDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOauthTokenDefault(DisOauthToken disOauthToken) {
        if (null == disOauthToken) {
            return;
        }
        if (null == disOauthToken.getDataState()) {
            disOauthToken.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disOauthToken.getGmtCreate()) {
            disOauthToken.setGmtCreate(date);
        }
        disOauthToken.setGmtModified(date);
        if (StringUtils.isBlank((String)disOauthToken.getOauthTokenCode())) {
            disOauthToken.setOauthTokenCode(this.getNo(null, "DisOauthToken", "disOauthToken", disOauthToken.getTenantCode()));
        }
        if (StringUtils.isBlank((String)disOauthToken.getMemberCode())) {
            // empty if block
        }
    }

    private int getOauthTokenMaxCode() {
        int code = 0;
        try {
            return this.disOauthTokenMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisOauthTokenServiceImpl.getOauthTokenMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOauthTokenUpdataDefault(DisOauthToken disOauthToken) {
        if (null == disOauthToken) {
            return;
        }
        disOauthToken.setGmtModified(this.getSysDate());
    }

    private void saveOauthTokenModel(DisOauthToken disOauthToken) throws ApiException {
        if (null == disOauthToken) {
            return;
        }
        try {
            this.disOauthTokenMapper.insert(disOauthToken);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.saveOauthTokenModel.ex", (Throwable)e);
        }
    }

    private void saveOauthTokenBatchModel(List<DisOauthToken> disOauthTokenList) throws ApiException {
        if (null == disOauthTokenList || disOauthTokenList.isEmpty()) {
            return;
        }
        try {
            this.disOauthTokenMapper.insertBatch(disOauthTokenList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.saveOauthTokenBatchModel.ex", (Throwable)e);
        }
    }

    private DisOauthToken getOauthTokenModelById(Integer oauthTokenId) {
        if (null == oauthTokenId) {
            return null;
        }
        try {
            return this.disOauthTokenMapper.selectByPrimaryKey(oauthTokenId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisOauthTokenServiceImpl.getOauthTokenModelById", (Throwable)e);
            return null;
        }
    }

    private DisOauthToken getOauthTokenModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disOauthTokenMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisOauthTokenServiceImpl.getOauthTokenModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOauthTokenModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disOauthTokenMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.delOauthTokenModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.delOauthTokenModelByCode.num");
        }
    }

    private void deleteOauthTokenModel(Integer oauthTokenId) throws ApiException {
        if (null == oauthTokenId) {
            return;
        }
        int i = 0;
        try {
            i = this.disOauthTokenMapper.deleteByPrimaryKey(oauthTokenId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.deleteOauthTokenModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.deleteOauthTokenModel.num");
        }
    }

    private void updateOauthTokenModel(DisOauthToken disOauthToken) throws ApiException {
        if (null == disOauthToken) {
            return;
        }
        int i = 0;
        try {
            i = this.disOauthTokenMapper.updateByPrimaryKey(disOauthToken);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.updateOauthTokenModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.updateOauthTokenModel.num");
        }
    }

    private void updateStateOauthTokenModel(Integer oauthTokenId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == oauthTokenId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oauthTokenId", oauthTokenId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disOauthTokenMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.updateStateOauthTokenModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.updateStateOauthTokenModel.null");
        }
    }

    private void updateStateOauthTokenModelByCode(String tenantCode, String oauthTokenCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)oauthTokenCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("oauthTokenCode", oauthTokenCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disOauthTokenMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.updateStateOauthTokenModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.updateStateOauthTokenModelByCode.null");
        }
    }

    private DisOauthToken makeOauthToken(DisOauthTokenDomain disOauthTokenDomain, DisOauthToken disOauthToken) {
        if (null == disOauthTokenDomain) {
            return null;
        }
        if (null == disOauthToken) {
            disOauthToken = new DisOauthToken();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disOauthToken, (Object)disOauthTokenDomain);
            return disOauthToken;
        }
        catch (Exception e) {
            this.logger.error("dis.DisOauthTokenServiceImpl.makeOauthToken", (Throwable)e);
            return null;
        }
    }

    private DisOauthTokenReDomain makeDisOauthTokenReDomain(DisOauthToken disOauthToken) {
        if (null == disOauthToken) {
            return null;
        }
        DisOauthTokenReDomain disOauthTokenReDomain = new DisOauthTokenReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disOauthTokenReDomain, (Object)disOauthToken);
            return disOauthTokenReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisOauthTokenServiceImpl.makeDisOauthTokenReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisOauthToken> queryOauthTokenModelPage(Map<String, Object> parammap) {
        try {
            return this.disOauthTokenMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisOauthTokenServiceImpl.queryOauthTokenModel", (Throwable)e);
            return null;
        }
    }

    private List<DisOauthToken> queryExt() {
        try {
            return this.disOauthTokenMapper.queryExt();
        }
        catch (Exception e) {
            this.logger.error("dis.DisOauthTokenServiceImpl.queryExt", (Throwable)e);
            return null;
        }
    }

    private int countOauthToken(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disOauthTokenMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisOauthTokenServiceImpl.countOauthToken", (Throwable)e);
        }
        return i;
    }

    private DisOauthToken createDisOauthToken(DisOauthTokenDomain disOauthTokenDomain) {
        String msg = this.checkOauthToken(disOauthTokenDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.saveOauthToken.checkOauthToken", msg);
        }
        DisOauthToken disOauthToken = this.makeOauthToken(disOauthTokenDomain, null);
        this.setOauthTokenDefault(disOauthToken);
        return disOauthToken;
    }

    @Override
    public String saveOauthToken(DisOauthTokenDomain disOauthTokenDomain) throws ApiException {
        if (null == disOauthTokenDomain || StringUtils.isBlank((String)disOauthTokenDomain.getChannelCode()) || StringUtils.isBlank((String)disOauthTokenDomain.getMemberCode()) || StringUtils.isBlank((String)disOauthTokenDomain.getTenantCode())) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.saveOauthToken.disOauthTokenDomain");
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("channelCode", disOauthTokenDomain.getChannelCode());
        parammap.put("memberCode", disOauthTokenDomain.getMemberCode());
        parammap.put("tenantCode", disOauthTokenDomain.getTenantCode());
        List<DisOauthToken> list = this.queryOauthTokenModelPage(parammap);
        if (ListUtil.isEmpty(list)) {
            DisOauthToken disOauthToken = this.createDisOauthToken(disOauthTokenDomain);
            this.saveOauthTokenModel(disOauthToken);
            this.updateCache(disOauthToken);
            return disOauthToken.getOauthTokenCode();
        }
        disOauthTokenDomain.setOauthTokenCode(list.get(0).getOauthTokenCode());
        disOauthTokenDomain.setOauthTokenId(list.get(0).getOauthTokenId());
        this.updateOauthToken(disOauthTokenDomain);
        return disOauthTokenDomain.getOauthTokenCode();
    }

    @Override
    public String saveOauthTokenBatch(List<DisOauthTokenDomain> disOauthTokenDomainList) throws ApiException {
        if (null == disOauthTokenDomainList || disOauthTokenDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisOauthToken> disOauthTokenList = new ArrayList<DisOauthToken>();
        String code = "";
        for (DisOauthTokenDomain disOauthTokenDomain : disOauthTokenDomainList) {
            DisOauthToken disOauthToken = this.createDisOauthToken(disOauthTokenDomain);
            code = disOauthToken.getOauthTokenCode();
            disOauthTokenList.add(disOauthToken);
            this.updateCache(disOauthToken);
        }
        this.saveOauthTokenBatchModel(disOauthTokenList);
        return code;
    }

    @Override
    public void updateOauthTokenState(Integer oauthTokenId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateOauthTokenModel(oauthTokenId, dataState, oldDataState, map);
        DisOauthToken disOauthToken = this.getOauthTokenModelById(oauthTokenId);
        if (-1 == dataState) {
            this.deleteCache(disOauthToken);
        } else {
            this.updateCache(disOauthToken);
        }
    }

    @Override
    public void updateOauthTokenStateByCode(String tenantCode, String oauthTokenCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateOauthTokenModelByCode(tenantCode, oauthTokenCode, dataState, oldDataState, map);
        DisOauthToken disOauthToken = this.getOauthTokenByCode(tenantCode, oauthTokenCode);
        if (-1 == dataState) {
            this.deleteCache(disOauthToken);
        } else {
            this.updateCache(disOauthToken);
        }
    }

    @Override
    public void updateOauthToken(DisOauthTokenDomain disOauthTokenDomain) throws ApiException {
        String msg = this.checkOauthToken(disOauthTokenDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.updateOauthToken.checkOauthToken", msg);
        }
        DisOauthToken oldDisOauthToken = this.getOauthTokenModelById(disOauthTokenDomain.getOauthTokenId());
        if (null == oldDisOauthToken) {
            throw new ApiException("dis.DisOauthTokenServiceImpl.updateOauthToken.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisOauthToken disOauthToken = this.makeOauthToken(disOauthTokenDomain, oldDisOauthToken);
        this.setOauthTokenUpdataDefault(disOauthToken);
        this.updateOauthTokenModel(disOauthToken);
        this.updateCache(disOauthToken);
    }

    @Override
    public DisOauthToken getOauthToken(Integer oauthTokenId) {
        return this.getOauthTokenModelById(oauthTokenId);
    }

    @Override
    public void deleteOauthToken(Integer oauthTokenId) throws ApiException {
        this.deleteOauthTokenModel(oauthTokenId);
    }

    @Override
    public QueryResult<DisOauthToken> queryOauthTokenPage(Map<String, Object> map) {
        List<DisOauthToken> disOauthTokenList = this.queryOauthTokenModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOauthToken(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disOauthTokenList);
        return queryResult;
    }

    @Override
    public DisOauthToken getOauthTokenByCode(String tenantCode, String oauthTokenCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("oauthTokenCode", oauthTokenCode);
        return this.getOauthTokenModelByCode(map);
    }

    @Override
    public void deleteOauthTokenByCode(String tenantCode, String oauthTokenCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("oauthTokenCode", oauthTokenCode);
        this.delOauthTokenModelByCode(map);
    }

    private void deleteCache(DisOauthToken disOauthToken) {
        if (null == disOauthToken) {
            return;
        }
        if (StringUtils.isBlank((String)disOauthToken.getMemberCode())) {
            disOauthToken.setMemberCode("");
        }
        DisUtil.delMap((String)this.cachekey, (String[])new String[]{disOauthToken.getChannelCode() + "-" + disOauthToken.getMemberCode() + "-" + disOauthToken.getTenantCode()});
    }

    private void updateCache(DisOauthToken disOauthToken) {
        if (null == disOauthToken) {
            return;
        }
        if (StringUtils.isBlank((String)disOauthToken.getMemberCode())) {
            disOauthToken.setMemberCode("");
        }
        DisUtil.setMap((String)this.cachekey, (String)(disOauthToken.getChannelCode() + "-" + disOauthToken.getMemberCode() + "-" + disOauthToken.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)disOauthToken));
    }

    @Override
    public void loadCacheDb() {
        this.logger.info("dis.DisOauthTokenServiceImpl.loadCacheDb", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<DisOauthToken> disOauthTokenList = this.queryOauthTokenModelPage(parammap);
        if (null == disOauthTokenList || disOauthTokenList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("dis.DisOauthTokenServiceImplloadCacheDb", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        for (DisOauthToken disOauthToken : disOauthTokenList) {
            if (StringUtils.isBlank((String)disOauthToken.getMemberCode())) {
                disOauthToken.setMemberCode("");
            }
            ddMap.put(disOauthToken.getChannelCode() + "-" + disOauthToken.getMemberCode() + "-" + disOauthToken.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)disOauthToken));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.info("dis.DisOauthTokenServiceImplloadCacheDb", (Object)"===========add-end==========");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TokenSendService getTokenSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == tokenSendService) {
                tokenSendService = new TokenSendService((DisOauthTokenService)SpringApplicationContextUtil.getBean((String)"disOauthTokenService"));
                for (int i = 0; i < 5; ++i) {
                    tokenSendService.addPollPool(new TokenSendPollThread(tokenSendService));
                }
            }
            return tokenSendService;
        }
    }

    @Override
    public void queryRefExt() {
        List<DisOauthToken> disOauthTokenList = this.queryExt();
        if (ListUtil.isEmpty(disOauthTokenList)) {
            return;
        }
        DisOauthTokenServiceImpl.getTokenSendService().addPutPool(new TokenSendPutThread(DisOauthTokenServiceImpl.getTokenSendService(), disOauthTokenList));
    }

    @Override
    public void updateTime(DisOauthToken disOauthToken) {
        if (null == disOauthToken) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", disOauthToken.getTenantCode());
        paramMap.put("channelCode", disOauthToken.getChannelCode());
        paramMap.put("memberCode", disOauthToken.getMemberCode());
        paramMap.put("oauthRefreshToken", disOauthToken.getOauthTokenRefreshToken());
        String msg = this.internalInvoke(this.apiCode, paramMap);
        if ("success".equals(msg)) {
            if (null == disOauthToken.getOauthTokenUpdateTime()) {
                disOauthToken.setOauthTokenUpdateTime(this.getSysDate());
            }
            Long updateTime = disOauthToken.getOauthTokenUpdateTime().getTime() + (long)disOauthToken.getOauthTokenExpireIn().intValue();
            disOauthToken.setOauthTokenUpdateTime(new Date(updateTime));
            this.updateOauthTokenModel(disOauthToken);
        }
    }

    static {
        lock = new Object();
    }
}

