/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisDorderMapper;
import com.yqbsoft.laser.service.distribution.domain.DisContractlogDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDorderDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDorderReDomain;
import com.yqbsoft.laser.service.distribution.model.DisChannel;
import com.yqbsoft.laser.service.distribution.model.DisDictionary;
import com.yqbsoft.laser.service.distribution.model.DisDorder;
import com.yqbsoft.laser.service.distribution.orderes.SendPollThread;
import com.yqbsoft.laser.service.distribution.orderes.SendPutThread;
import com.yqbsoft.laser.service.distribution.orderes.SendService;
import com.yqbsoft.laser.service.distribution.service.DisChannelService;
import com.yqbsoft.laser.service.distribution.service.DisChannelsendBaseService;
import com.yqbsoft.laser.service.distribution.service.DisDictionaryService;
import com.yqbsoft.laser.service.distribution.service.DisDorderService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DisDorderServiceImpl
extends BaseServiceImpl
implements DisDorderService {
    private static final String SYS_CODE = "dis.DisDorderServiceImpl";
    private DisDorderMapper disDorderMapper;
    private String cachekey = "DisDorder-channelCode";
    private static SendService sendService;
    private static Object lock;
    DisChannelsendBaseService disChannelsendBaseService;
    DisChannelService disChannelService;
    DisDictionaryService disDictionaryService;

    public void setDisDorderMapper(DisDorderMapper disDorderMapper) {
        this.disDorderMapper = disDorderMapper;
    }

    private Date getSysDate() {
        try {
            return this.disDorderMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDorderServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDorder(DisDorderDomain disDorderDomain) {
        if (null == disDorderDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDorderDomain.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disDorderDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDorderDefault(DisDorder disDorder) {
        if (null == disDorder) {
            return;
        }
        if (null == disDorder.getDataState()) {
            disDorder.setDataState(0);
        }
        if (null == disDorder.getGmtCreate()) {
            disDorder.setGmtCreate(this.getSysDate());
        }
        disDorder.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)disDorder.getDorderCode())) {
            disDorder.setDorderCode(this.createUUIDString());
        }
    }

    private int getDorderMaxCode() {
        int code = 0;
        try {
            return this.disDorderMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDorderServiceImpl.getDorderMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDorderUpdataDefault(DisDorder disDorder) {
        if (null == disDorder) {
            return;
        }
        disDorder.setGmtModified(this.getSysDate());
    }

    private void saveDorderModel(DisDorder disDorder) throws ApiException {
        if (null == disDorder) {
            return;
        }
        try {
            this.disDorderMapper.insert(disDorder);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDorderServiceImpl.saveDorderModel.ex", (Throwable)e);
        }
    }

    private void saveDorderBatchModel(List<DisDorder> disDorderList) throws ApiException {
        if (null == disDorderList || disDorderList.isEmpty()) {
            return;
        }
        try {
            this.disDorderMapper.insertBatch(disDorderList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDorderServiceImpl.saveDorderBatchModel.ex", (Throwable)e);
        }
    }

    private DisDorder getDorderModelById(Integer dorderId) {
        if (null == dorderId) {
            return null;
        }
        try {
            return this.disDorderMapper.selectByPrimaryKey(dorderId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDorderServiceImpl.getDorderModelById", (Throwable)e);
            return null;
        }
    }

    private DisDorder getDorderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDorderMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDorderServiceImpl.getDorderModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDorderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDorderMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDorderServiceImpl.delDorderModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDorderServiceImpl.delDorderModelByCode.num");
        }
    }

    private void deleteDorderModel(Integer dorderId) throws ApiException {
        if (null == dorderId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDorderMapper.deleteByPrimaryKey(dorderId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDorderServiceImpl.deleteDorderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDorderServiceImpl.deleteDorderModel.num");
        }
    }

    private void updateDorderModel(DisDorder disDorder) throws ApiException {
        if (null == disDorder) {
            return;
        }
        int i = 0;
        try {
            i = this.disDorderMapper.updateByPrimaryKeySelective(disDorder);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDorderServiceImpl.updateDorderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDorderServiceImpl.updateDorderModel.num");
        }
    }

    private void updateStateDorderModel(Integer dorderId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == dorderId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dorderId", dorderId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDorderMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDorderServiceImpl.updateStateDorderModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDorderServiceImpl.updateStateDorderModel.null");
        }
    }

    private void updateStateDorderModelByCode(String tenantCode, String dorderCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)dorderCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dorderCode", dorderCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDorderMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDorderServiceImpl.updateStateDorderModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDorderServiceImpl.updateStateDorderModelByCode.null");
        }
    }

    private DisDorder makeDorder(DisDorderDomain disDorderDomain, DisDorder disDorder) {
        if (null == disDorderDomain) {
            return null;
        }
        if (null == disDorder) {
            disDorder = new DisDorder();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDorder, (Object)disDorderDomain);
            return disDorder;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDorderServiceImpl.makeDorder", (Throwable)e);
            return null;
        }
    }

    private DisDorderReDomain makeDisDorderReDomain(DisDorder disDorder) {
        if (null == disDorder) {
            return null;
        }
        DisDorderReDomain disDorderReDomain = new DisDorderReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDorderReDomain, (Object)disDorder);
            return disDorderReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDorderServiceImpl.makeDisDorderReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDorder> queryDorderModelPage(Map<String, Object> parammap) {
        try {
            return this.disDorderMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDorderServiceImpl.queryDorderModel", (Throwable)e);
            return null;
        }
    }

    private int countDorder(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDorderMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDorderServiceImpl.countDorder", (Throwable)e);
        }
        return i;
    }

    private DisDorder createDisDorder(DisDorderDomain disDorderDomain) {
        String msg = this.checkDorder(disDorderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDorderServiceImpl.saveDorder.checkDorder", msg);
        }
        DisDorder disDorder = this.makeDorder(disDorderDomain, null);
        this.setDorderDefault(disDorder);
        return disDorder;
    }

    @Override
    public String saveDorder(DisDorderDomain disDorderDomain) throws ApiException {
        DisDorder disDorder = this.createDisDorder(disDorderDomain);
        this.saveDorderModel(disDorder);
        this.updateDorderCache(disDorder);
        return disDorder.getDorderCode();
    }

    @Override
    public String saveDorderBatch(List<DisDorderDomain> disDorderDomainList) throws ApiException {
        if (null == disDorderDomainList || disDorderDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDorder> disDorderList = new ArrayList<DisDorder>();
        String code = "";
        for (DisDorderDomain disDorderDomain : disDorderDomainList) {
            DisDorder disDorder = this.createDisDorder(disDorderDomain);
            code = disDorder.getDorderCode();
            disDorderList.add(disDorder);
        }
        this.saveDorderBatchModel(disDorderList);
        for (DisDorder disDorder2 : disDorderList) {
            this.updateDorderCache(disDorder2);
        }
        return code;
    }

    @Override
    public void updateDorderState(Integer dorderId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDorderModel(dorderId, dataState, oldDataState);
        if (-1 == dataState) {
            DisDorder disDorder = this.getDorder(dorderId);
            this.deleteDorderCache(disDorder);
        }
    }

    @Override
    public void updateDorderStateByCode(String tenantCode, String dorderCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDorderModelByCode(tenantCode, dorderCode, dataState, oldDataState);
        if (-1 == dataState) {
            DisDorder disDorder = this.getDorderByCode(tenantCode, dorderCode);
            this.deleteDorderCache(disDorder);
        }
    }

    @Override
    public void updateDorder(DisDorderDomain disDorderDomain) throws ApiException {
        String msg = this.checkDorder(disDorderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDorderServiceImpl.updateDorder.checkDorder", msg);
        }
        DisDorder oldDisDorder = this.getDorderModelById(disDorderDomain.getDorderId());
        if (null == oldDisDorder) {
            throw new ApiException("dis.DisDorderServiceImpl.updateDorder.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDorder disDorder = this.makeDorder(disDorderDomain, oldDisDorder);
        this.setDorderUpdataDefault(disDorder);
        this.updateDorderModel(disDorder);
        this.updateDorderCache(disDorder);
    }

    @Override
    public DisDorder getDorder(Integer dorderId) {
        return this.getDorderModelById(dorderId);
    }

    @Override
    public void deleteDorder(Integer dorderId) throws ApiException {
        DisDorder disDorder = this.getDorder(dorderId);
        this.deleteDorderModel(dorderId);
        this.deleteDorderCache(disDorder);
    }

    @Override
    public QueryResult<DisDorder> queryDorderPage(Map<String, Object> map) {
        List<DisDorder> disDorderList = this.queryDorderModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDorder(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDorderList);
        return queryResult;
    }

    @Override
    public DisDorder getDorderByCode(String tenantCode, String dorderCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dorderCode", dorderCode);
        return this.getDorderModelByCode(map);
    }

    @Override
    public void deleteDorderByCode(String tenantCode, String dorderCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dorderCode", dorderCode);
        DisDorder disDorder = this.getDorderByCode(tenantCode, dorderCode);
        this.delDorderModelByCode(map);
        this.deleteDorderCache(disDorder);
    }

    private void deleteDorderCache(DisDorder disDorder) {
        if (null == disDorder) {
            return;
        }
        DisUtil.delMap((String)this.cachekey, (String[])new String[]{disDorder.getChannelCode() + "-" + disDorder.getTenantCode()});
    }

    private void updateDorderCache(DisDorder disDorder) {
        if (null == disDorder) {
            return;
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(disDorder.getChannelCode() + "-" + disDorder.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)disDorder));
    }

    @Override
    public void queryDorderLoadCache() {
        this.logger.info("DisDorderService.queryDorderLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<DisDorder> disDorderList = this.queryDorderModelPage(parammap);
        if (null == disDorderList || disDorderList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("DisDorderService.queryDorderLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        for (DisDorder disDorder : disDorderList) {
            ddMap.put(disDorder.getChannelCode() + "-" + disDorder.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)disDorder));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.info("DisDorderService.queryDorderLoadCache", (Object)"===========add-end==========");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((DisDorderService)SpringApplicationContextUtil.getBean((String)"disDorderService"));
                for (int i = 0; i < 5; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    @Override
    public void saveSendDorderLoad() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dorderUp", "1");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            int startRow = 0;
            boolean flag = true;
            QueryResult<DisDorder> result = null;
            do {
                startRow = DisDorderServiceImpl.getSendService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", DisDorderServiceImpl.getSendService().getPage());
                result = this.queryDorderPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    DisDorderServiceImpl.getSendService().addPutPool(new SendPutThread(DisDorderServiceImpl.getSendService(), result.getRows()));
                    if (result.getRows().size() != DisDorderServiceImpl.getSendService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
            } while (flag);
            DisDorderServiceImpl.getSendService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDorderServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    public void setDisChannelsendBaseService(DisChannelsendBaseService disChannelsendBaseService) {
        this.disChannelsendBaseService = disChannelsendBaseService;
    }

    public void setDisChannelService(DisChannelService disChannelService) {
        this.disChannelService = disChannelService;
    }

    @Override
    public void saveDorderQuery(DisDorder disDorder) {
        Object end_time;
        Object start_time;
        int timenum;
        if (null == disDorder) {
            return;
        }
        List<DisDictionary> storeList = this.queryStore(disDorder.getChannelCode(), disDorder.getTenantCode());
        if (ListUtil.isEmpty(storeList)) {
            return;
        }
        DisChannel disChannel = this.disChannelService.getChannelByCode(disDorder.getTenantCode(), disDorder.getChannelCode());
        if (null == disChannel) {
            return;
        }
        ArrayList<DisContractlogDomain> disContractlogDomainList = new ArrayList<DisContractlogDomain>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer timetype = disDorder.getDorderTimetype();
        if (null == timetype) {
            timetype = 0;
        }
        Date date = this.getSysDate();
        String timeStr = disDorder.getDorderTime();
        Map oldmap = null;
        if (StringUtils.isNotBlank((String)timeStr)) {
            oldmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(timeStr, String.class, Object.class);
        }
        int n = timenum = null == disDorder.getDorderTimenum() ? 0 : disDorder.getDorderTimenum();
        if (0 == timenum) {
            timenum = 1440;
        }
        if (timenum <= 5) {
            timenum = 10;
        }
        if (0 == timetype) {
            String dateStr;
            String param = "";
            if (MapUtil.isNotEmpty((Map)oldmap)) {
                param = (String)oldmap.get("param");
            }
            if ((dateStr = DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd")).equals(param)) {
                return;
            }
            map.put("param", dateStr);
        } else if (1 == timetype) {
            start_time = MapUtil.isNotEmpty((Map)oldmap) ? Long.valueOf(String.valueOf(oldmap.get("end_time"))) : Long.valueOf(DateUtil.addMinutes((Date)date, (int)(-timenum)).getTime());
            end_time = DateUtil.addMinutes((Date)date, (int)-5).getTime();
            if ((Long)end_time <= (Long)start_time) {
                return;
            }
            map.put("start_time", start_time);
            map.put("end_time", end_time);
        } else {
            start_time = MapUtil.isNotEmpty((Map)oldmap) ? String.valueOf(oldmap.get("end_time")) : DateUtil.getDateString((Date)DateUtil.addMinutes((Date)date, (int)(-timenum)), (String)"yyyy-MM-dd HH:mm:ss");
            end_time = DateUtil.getDateString((Date)DateUtil.addMinutes((Date)date, (int)-5), (String)"yyyy-MM-dd HH:mm:ss");
            if (DateUtil.getDiffDay((String)end_time, (String)start_time) <= 0L) {
                return;
            }
            map.put("start_time", start_time);
            map.put("end_time", end_time);
        }
        disDorder.setDorderTime(JsonUtil.buildNormalBinder().toJson(map));
        for (DisDictionary disDictionary : storeList) {
            map.put("memberCode", disDictionary.getDictionaryValue());
            DisContractlogDomain disContractlogDomain = new DisContractlogDomain();
            disContractlogDomain.setChannelApiCode(disDorder.getDorderApicode());
            disContractlogDomain.setChannelCode(disChannel.getChannelCode());
            disContractlogDomain.setChannelName(disChannel.getChannelName());
            disContractlogDomain.setMemberCode(disChannel.getMemberCode());
            disContractlogDomain.setMemberName(disChannel.getMemberName());
            disContractlogDomain.setContractlogPage(BigDecimal.valueOf(disDorder.getDorderNum().intValue()));
            disContractlogDomain.setContractlogParam(JsonUtil.buildNormalBinder().toJson(map));
            disContractlogDomainList.add(disContractlogDomain);
        }
        this.updateDorderModel(disDorder);
        this.disChannelsendBaseService.sendSaveContractlogBatch(disContractlogDomainList);
    }

    public void setDisDictionaryService(DisDictionaryService disDictionaryService) {
        this.disDictionaryService = disDictionaryService;
    }

    private List<DisDictionary> queryStore(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        map.put("dictionaryType", "UmUserinfo");
        map.put("dictionaryGoods", "userinfoCode");
        map.put("dictionaryDisgoods", "shopId");
        QueryResult<DisDictionary> qlist = this.disDictionaryService.queryDictionaryPage(map);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        return qlist.getList();
    }

    static {
        lock = new Object();
    }
}

