/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisChannelConfigMapper;
import com.yqbsoft.laser.service.distribution.dao.DisChannelMapper;
import com.yqbsoft.laser.service.distribution.domain.DisChannelConfigDomain;
import com.yqbsoft.laser.service.distribution.domain.DisChannelConfigReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisChannelDomain;
import com.yqbsoft.laser.service.distribution.domain.DisChannelReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisChannelsendDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsDomain;
import com.yqbsoft.laser.service.distribution.domain.TmProappEnvDomain;
import com.yqbsoft.laser.service.distribution.model.DisChannel;
import com.yqbsoft.laser.service.distribution.model.DisChannelConfig;
import com.yqbsoft.laser.service.distribution.model.DisChannelsend;
import com.yqbsoft.laser.service.distribution.service.DisChannelService;
import com.yqbsoft.laser.service.distribution.service.DisChannelsendService;
import com.yqbsoft.laser.service.distribution.service.DisDgoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jsoup.helper.StringUtil;

public class DisChannelServiceImpl
extends BaseServiceImpl
implements DisChannelService {
    private static final String SYS_CODE = "dis.DisChannelServiceImpl";
    private DisChannelMapper disChannelMapper;
    private DisChannelConfigMapper disChannelConfigMapper;
    DisChannelsendService disChannelsendService;
    DisDgoodsService disDgoodsService;
    private String cacheMember = "DisChannel-memberCode";
    private String cacheMmberList = "DisChannel-memberMcode";
    private String cacheCmember = "DisChannel-memberCcode";
    private String cacheProapp = "DisChannel-proappCode";
    private String cacheTginfo = "DisChannel-tginfoCode";
    private String cacheChannel = "DisChannel-channelCode";
    private String cacheChannelConfig = "DisChannelConfig-channelCode";
    private String cacheOutMember = "DisChannel-channelMemcode";
    private String cacheThirdMember = "DisChannel-thirdmemberCode";

    public void setDisChannelMapper(DisChannelMapper disChannelMapper) {
        this.disChannelMapper = disChannelMapper;
    }

    public void setDisChannelConfigMapper(DisChannelConfigMapper disChannelConfigMapper) {
        this.disChannelConfigMapper = disChannelConfigMapper;
    }

    private Date getSysDate() {
        try {
            return this.disChannelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkChannel(DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disChannelDomain.getChannelSort())) {
            msg = msg + "ChannelSort\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disChannelDomain.getChannelType())) {
            msg = msg + "ChannelType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disChannelDomain.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disChannelDomain.getMemberMcode())) {
            msg = msg + "MemberMcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disChannelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setChannelDefault(DisChannel disChannel) {
        if (null == disChannel) {
            return;
        }
        if (null == disChannel.getDataState()) {
            disChannel.setDataState(0);
        }
        if (null == disChannel.getGmtCreate()) {
            disChannel.setGmtCreate(this.getSysDate());
        }
        disChannel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)disChannel.getChannelCode())) {
            disChannel.setChannelCode(this.getNo(null, "DisChannel", "channelCode", disChannel.getTenantCode()));
        }
    }

    private int getChannelMaxCode() {
        int code = 0;
        try {
            return this.disChannelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.getChannelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setChannelUpdataDefault(DisChannel disChannel) {
        if (null == disChannel) {
            return;
        }
        disChannel.setGmtModified(this.getSysDate());
    }

    private void saveChannelModel(DisChannel disChannel) throws ApiException {
        if (null == disChannel) {
            return;
        }
        try {
            this.disChannelMapper.insert(disChannel);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.saveChannelModel.ex", (Throwable)e);
        }
    }

    private void saveChannelBatchModel(List<DisChannel> disChannelList) throws ApiException {
        if (null == disChannelList || disChannelList.isEmpty()) {
            return;
        }
        try {
            this.disChannelMapper.insertBatch(disChannelList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.saveChannelBatchModel.ex", (Throwable)e);
        }
    }

    private DisChannel getChannelModelById(Integer channelId) {
        if (null == channelId) {
            return null;
        }
        try {
            return this.disChannelMapper.selectByPrimaryKey(channelId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.getChannelModelById", (Throwable)e);
            return null;
        }
    }

    private DisChannel getChannelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disChannelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.getChannelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delChannelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disChannelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.delChannelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisChannelServiceImpl.delChannelModelByCode.num");
        }
    }

    private void deleteChannelModel(Integer channelId) throws ApiException {
        if (null == channelId) {
            return;
        }
        int i = 0;
        try {
            i = this.disChannelMapper.deleteByPrimaryKey(channelId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.deleteChannelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisChannelServiceImpl.deleteChannelModel.num");
        }
    }

    private void updateChannelModel(DisChannel disChannel) throws ApiException {
        if (null == disChannel) {
            return;
        }
        int i = 0;
        try {
            i = this.disChannelMapper.updateByPrimaryKeySelective(disChannel);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.updateChannelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisChannelServiceImpl.updateChannelModel.num");
        }
    }

    private void updateStateChannelModel(Integer channelId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == channelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelId", channelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disChannelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.updateStateChannelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisChannelServiceImpl.updateStateChannelModel.null");
        }
    }

    private void updateStateChannelModelByCode(String tenantCode, String channelCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)channelCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disChannelMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.updateStateChannelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisChannelServiceImpl.updateStateChannelModelByCode.null");
        }
    }

    private DisChannel makeChannel(DisChannelDomain disChannelDomain, DisChannel disChannel) {
        if (null == disChannelDomain) {
            return null;
        }
        if (null == disChannel) {
            disChannel = new DisChannel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disChannel, (Object)disChannelDomain);
            return disChannel;
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.makeChannel", (Throwable)e);
            return null;
        }
    }

    private DisChannelReDomain makeDisChannelReDomain(DisChannel disChannel) {
        if (null == disChannel) {
            return null;
        }
        DisChannelReDomain disChannelReDomain = new DisChannelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disChannelReDomain, (Object)disChannel);
            return disChannelReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.makeDisChannelReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisChannel> queryChannelModelPage(Map<String, Object> parammap) {
        try {
            return this.disChannelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.queryChannelModel", (Throwable)e);
            return null;
        }
    }

    private int countChannel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disChannelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.countChannel", (Throwable)e);
        }
        return i;
    }

    private DisChannel createDisChannel(DisChannelDomain disChannelDomain) {
        String msg = this.checkChannel(disChannelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisChannelServiceImpl.saveChannel.checkChannel", msg);
        }
        DisChannel disChannel = this.makeChannel(disChannelDomain, null);
        this.setChannelDefault(disChannel);
        return disChannel;
    }

    private String checkChannelConfig(DisChannelConfigDomain disChannelConfigDomain) {
        if (null == disChannelConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disChannelConfigDomain.getChannelCode())) {
            msg = msg + "ChannelCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disChannelConfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setChannelConfigDefault(DisChannelConfig disChannelConfig) {
        if (null == disChannelConfig) {
            return;
        }
        if (null == disChannelConfig.getDataState()) {
            disChannelConfig.setDataState(0);
        }
        if (null == disChannelConfig.getGmtCreate()) {
            disChannelConfig.setGmtCreate(this.getSysDate());
        }
        disChannelConfig.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)disChannelConfig.getChannelConfigCode())) {
            disChannelConfig.setChannelConfigCode(this.createUUIDString());
        }
    }

    private int getChannelConfigMaxCode() {
        int code = 0;
        try {
            return this.disChannelConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.getChannelConfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setChannelConfigUpdataDefault(DisChannelConfig disChannelConfig) {
        if (null == disChannelConfig) {
            return;
        }
        disChannelConfig.setGmtModified(this.getSysDate());
    }

    private void saveChannelConfigModel(DisChannelConfig disChannelConfig) throws ApiException {
        if (null == disChannelConfig) {
            return;
        }
        try {
            this.disChannelConfigMapper.insert(disChannelConfig);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.saveChannelConfigModel.ex", (Throwable)e);
        }
    }

    private void saveChannelConfigBatchModel(List<DisChannelConfig> disChannelConfigList) throws ApiException {
        if (null == disChannelConfigList || disChannelConfigList.isEmpty()) {
            return;
        }
        try {
            this.disChannelConfigMapper.insertBatch(disChannelConfigList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.saveChannelConfigBatchModel.ex", (Throwable)e);
        }
    }

    private DisChannelConfig getChannelConfigModelById(Integer channelConfigId) {
        if (null == channelConfigId) {
            return null;
        }
        try {
            return this.disChannelConfigMapper.selectByPrimaryKey(channelConfigId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.getChannelConfigModelById", (Throwable)e);
            return null;
        }
    }

    private DisChannelConfig getChannelConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disChannelConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.getChannelConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delChannelConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disChannelConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.delChannelConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisChannelServiceImpl.delChannelConfigModelByCode.num");
        }
    }

    private void deleteChannelConfigModel(Integer channelConfigId) throws ApiException {
        if (null == channelConfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.disChannelConfigMapper.deleteByPrimaryKey(channelConfigId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.deleteChannelConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisChannelServiceImpl.deleteChannelConfigModel.num");
        }
    }

    private void updateChannelConfigModel(DisChannelConfig disChannelConfig) throws ApiException {
        if (null == disChannelConfig) {
            return;
        }
        int i = 0;
        try {
            i = this.disChannelConfigMapper.updateByPrimaryKeySelective(disChannelConfig);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.updateChannelConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisChannelServiceImpl.updateChannelConfigModel.num");
        }
    }

    private void updateStateChannelConfigModel(Integer channelConfigId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == channelConfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelConfigId", channelConfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disChannelConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.updateStateChannelConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisChannelServiceImpl.updateStateChannelConfigModel.null");
        }
    }

    private void updateStateChannelConfigModelByCode(String tenantCode, String channelConfigCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)channelConfigCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelConfigCode", channelConfigCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disChannelConfigMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.updateStateChannelConfigModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisChannelServiceImpl.updateStateChannelConfigModelByCode.null");
        }
    }

    private DisChannelConfig makeChannelConfig(DisChannelConfigDomain disChannelConfigDomain, DisChannelConfig disChannelConfig) {
        if (null == disChannelConfigDomain) {
            return null;
        }
        if (null == disChannelConfig) {
            disChannelConfig = new DisChannelConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disChannelConfig, (Object)disChannelConfigDomain);
            return disChannelConfig;
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.makeChannelConfig", (Throwable)e);
            return null;
        }
    }

    private DisChannelConfigReDomain makeDisChannelConfigReDomain(DisChannelConfig disChannelConfig) {
        if (null == disChannelConfig) {
            return null;
        }
        DisChannelConfigReDomain disChannelConfigReDomain = new DisChannelConfigReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disChannelConfigReDomain, (Object)disChannelConfig);
            return disChannelConfigReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.makeDisChannelConfigReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisChannelConfig> queryChannelConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.disChannelConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.queryChannelConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countChannelConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disChannelConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.countChannelConfig", (Throwable)e);
        }
        return i;
    }

    private DisChannelConfig createDisChannelConfig(DisChannelConfigDomain disChannelConfigDomain) {
        String msg = this.checkChannelConfig(disChannelConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisChannelServiceImpl.saveChannelConfig.checkChannelConfig", msg);
        }
        DisChannelConfig disChannelConfig = this.makeChannelConfig(disChannelConfigDomain, null);
        this.setChannelConfigDefault(disChannelConfig);
        return disChannelConfig;
    }

    @Override
    public String saveChannel(DisChannelDomain disChannelDomain) throws ApiException {
        DisChannel disChannel = this.createDisChannel(disChannelDomain);
        this.saveChannelModel(disChannel);
        this.updateCache(disChannel);
        return disChannel.getChannelCode();
    }

    public void setDisChannelsendService(DisChannelsendService disChannelsendService) {
        this.disChannelsendService = disChannelsendService;
    }

    @Override
    public List<DisChannelsend> saveChannelBatch(List<DisChannelDomain> disChannelDomainList) throws ApiException {
        if (null == disChannelDomainList || disChannelDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisChannel> disChannelList = new ArrayList<DisChannel>();
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
        for (DisChannelDomain disChannelDomain : disChannelDomainList) {
            DisChannel disChannel = this.createDisChannel(disChannelDomain);
            disChannelList.add(disChannel);
            this.saveDgoods(disChannelDomain.getDisDgoodsDomainList(), disChannel);
            DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
            disChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)disChannel));
            disChannelsendDomain.setChannelCode(disChannel.getChannelCode());
            disChannelsendDomain.setChannelsendDir(disChannel.getChannelSort() + disChannel.getChannelType());
            disChannelsendDomain.setChannelsendType("DisChannel");
            disChannelsendDomain.setTenantCode(disChannel.getTenantCode());
            disChannelsendDomainList.add(disChannelsendDomain);
        }
        this.saveChannelBatchModel(disChannelList);
        for (DisChannel disChannelcache : disChannelList) {
            this.updateCache(disChannelcache);
        }
        return this.disChannelsendService.saveChannelsendBatch(disChannelsendDomainList);
    }

    public void setDisDgoodsService(DisDgoodsService disDgoodsService) {
        this.disDgoodsService = disDgoodsService;
    }

    private void saveDgoods(List<DisDgoodsDomain> disDgoodsDomainList, DisChannel disChannel) {
        if (ListUtil.isEmpty(disDgoodsDomainList) || null == disChannel) {
            return;
        }
        for (DisDgoodsDomain disDgoodsDomain : disDgoodsDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)disDgoodsDomain, (Object)disChannel);
            }
            catch (Exception e) {}
        }
        this.disDgoodsService.saveDgoodsBatch(disDgoodsDomainList);
    }

    @Override
    public void updateChannelState(Integer channelId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateChannelModel(channelId, dataState, oldDataState);
        if (dataState == -1) {
            DisChannel disChannel = this.getChannel(channelId);
            this.deleteCache(disChannel);
        }
    }

    @Override
    public void updateChannelStateByCode(String tenantCode, String channelCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateChannelModelByCode(tenantCode, channelCode, dataState, oldDataState);
        if (dataState == -1) {
            DisChannel disChannel = this.getChannelByCode(tenantCode, channelCode);
            this.deleteCache(disChannel);
        }
    }

    @Override
    public void updateChannel(DisChannelDomain disChannelDomain) throws ApiException {
        String msg = this.checkChannel(disChannelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisChannelServiceImpl.updateChannel.checkChannel", msg);
        }
        DisChannel oldDisChannel = this.getChannelModelById(disChannelDomain.getChannelId());
        if (null == oldDisChannel) {
            throw new ApiException("dis.DisChannelServiceImpl.updateChannel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisChannel disChannel = this.makeChannel(disChannelDomain, oldDisChannel);
        this.setChannelUpdataDefault(disChannel);
        this.updateChannelModel(disChannel);
        this.updateCache(disChannel);
    }

    @Override
    public DisChannel getChannel(Integer channelId) {
        return this.getChannelModelById(channelId);
    }

    @Override
    public void deleteChannel(Integer channelId) throws ApiException {
        DisChannel disChannel = this.getChannel(channelId);
        this.deleteChannelModel(channelId);
        this.deleteCache(disChannel);
    }

    private void deleteCache(DisChannel disChannel) {
        ArrayList<DisChannel> configcacheList;
        if (null == disChannel) {
            return;
        }
        if (!"2".equals(disChannel.getChannelType())) {
            String memberKey = disChannel.getMemberCode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode();
            if (!"0".equals(disChannel.getChannelSort())) {
                memberKey = disChannel.getMemberCcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode();
            }
            DisUtil.delMap((String)this.cacheMember, (String[])new String[]{memberKey});
        } else {
            String thirdmberListKey = disChannel.getMemberCode() + "-" + disChannel.getChannelType() + "-" + disChannel.getTenantCode();
            String outjson = DisUtil.getMap((String)this.cacheThirdMember, (String)thirdmberListKey);
            List thirdmemberList = StringUtils.isBlank((String)outjson) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(outjson, DisChannel.class);
            if (null == thirdmemberList) {
                thirdmemberList = new ArrayList();
            } else if (!thirdmemberList.isEmpty()) {
                configcacheList = new ArrayList<DisChannel>();
                for (DisChannel disChannel2 : thirdmemberList) {
                    if (disChannel2.getChannelCode().equals(disChannel.getChannelCode())) continue;
                    configcacheList.add(disChannel2);
                }
                thirdmemberList = configcacheList;
            }
            if (null == thirdmemberList || thirdmemberList.isEmpty()) {
                DisUtil.delMap((String)this.cacheThirdMember, (String[])new String[]{thirdmberListKey});
            } else {
                DisUtil.setMapVer((String)this.cacheThirdMember, (String)thirdmberListKey, (String)JsonUtil.buildNormalBinder().toJson(thirdmemberList));
            }
        }
        String mmberListKey = disChannel.getMemberMcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode();
        String json = DisUtil.getMap((String)this.cacheMmberList, (String)mmberListKey);
        List mmemberList = StringUtils.isBlank((String)json) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisChannel.class);
        if (null == mmemberList) {
            mmemberList = new ArrayList();
        } else if (!mmemberList.isEmpty()) {
            configcacheList = new ArrayList();
            for (DisChannel disChannel2 : mmemberList) {
                if (disChannel2.getChannelCode().equals(disChannel.getChannelCode())) continue;
                configcacheList.add(disChannel2);
            }
            mmemberList = configcacheList;
        }
        if (null == mmemberList || mmemberList.isEmpty()) {
            DisUtil.delMap((String)this.cacheMmberList, (String[])new String[]{mmberListKey});
        } else {
            DisUtil.setMapVer((String)this.cacheMmberList, (String)mmberListKey, (String)JsonUtil.buildNormalBinder().toJson(mmemberList));
        }
        if ("1".equals(disChannel.getChannelGoodstype()) && StringUtils.isNotBlank((String)disChannel.getChannelMemcode())) {
            String outmberListKey = disChannel.getChannelMemcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode();
            String outjson = DisUtil.getMap((String)this.cacheOutMember, (String)outmberListKey);
            List outmemberList = StringUtils.isBlank((String)outjson) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(outjson, DisChannel.class);
            if (null == outmemberList) {
                outmemberList = new ArrayList();
            } else if (!outmemberList.isEmpty()) {
                ArrayList<DisChannel> configcacheList2 = new ArrayList<DisChannel>();
                for (DisChannel disChannel2 : outmemberList) {
                    if (disChannel2.getChannelCode().equals(disChannel.getChannelCode())) continue;
                    configcacheList2.add(disChannel2);
                }
                outmemberList = configcacheList2;
            }
            if (null == outmemberList || outmemberList.isEmpty()) {
                DisUtil.delMap((String)this.cacheOutMember, (String[])new String[]{outmberListKey});
            } else {
                DisUtil.setMapVer((String)this.cacheOutMember, (String)outmberListKey, (String)JsonUtil.buildNormalBinder().toJson(outmemberList));
            }
        }
        DisUtil.delMap((String)this.cacheCmember, (String[])new String[]{disChannel.getMemberCcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode()});
        json = DisUtil.getMap((String)this.cacheProapp, (String)(disChannel.getProappCode() + "-" + disChannel.getTenantCode()));
        List proappList = StringUtils.isBlank((String)json) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisChannel.class);
        if (null == proappList) {
            proappList = new ArrayList();
        } else if (!proappList.isEmpty()) {
            ArrayList<DisChannel> configcacheList3 = new ArrayList<DisChannel>();
            for (DisChannel disChannel2 : proappList) {
                if (disChannel2.getChannelCode().equals(disChannel.getChannelCode())) continue;
                configcacheList3.add(disChannel2);
            }
            proappList = configcacheList3;
        }
        if (null == proappList || proappList.isEmpty()) {
            DisUtil.delMap((String)this.cacheProapp, (String[])new String[]{disChannel.getProappCode() + "-" + disChannel.getTenantCode()});
        } else {
            DisUtil.setMapVer((String)this.cacheProapp, (String)(disChannel.getProappCode() + "-" + disChannel.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(proappList));
        }
        DisUtil.delMap((String)this.cacheTginfo, (String[])new String[]{disChannel.getTginfoCode() + "-" + disChannel.getTenantCode()});
        DisUtil.delMap((String)this.cacheChannel, (String[])new String[]{disChannel.getChannelCode() + "-" + disChannel.getTenantCode()});
    }

    private void updateCache(DisChannel disChannel) {
        ArrayList<DisChannel> configcacheList;
        if (null == disChannel) {
            return;
        }
        if (!"2".equals(disChannel.getChannelType())) {
            String memberKey = disChannel.getMemberCode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode();
            if (!"0".equals(disChannel.getChannelSort())) {
                memberKey = disChannel.getMemberCcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode();
            }
            DisUtil.setMapVer((String)this.cacheMember, (String)memberKey, (String)JsonUtil.buildNormalBinder().toJson((Object)disChannel));
        } else {
            String thirdmberListKey = disChannel.getMemberCode() + "-" + disChannel.getChannelType() + "-" + disChannel.getTenantCode();
            String outjson = DisUtil.getMap((String)this.cacheThirdMember, (String)thirdmberListKey);
            List thirdmemberList = StringUtils.isBlank((String)outjson) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(outjson, DisChannel.class);
            if (null == thirdmemberList) {
                thirdmemberList = new ArrayList();
            } else if (!thirdmemberList.isEmpty()) {
                configcacheList = new ArrayList<DisChannel>();
                for (DisChannel disChannel2 : thirdmemberList) {
                    if (disChannel2.getChannelCode().equals(disChannel.getChannelCode())) continue;
                    configcacheList.add(disChannel2);
                }
                thirdmemberList = configcacheList;
            }
            thirdmemberList.add(disChannel);
            DisUtil.setMapVer((String)this.cacheThirdMember, (String)thirdmberListKey, (String)JsonUtil.buildNormalBinder().toJson(thirdmemberList));
        }
        String mmberListKey = disChannel.getMemberMcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode();
        String json = DisUtil.getRemotMap((String)this.cacheMmberList, (String)mmberListKey);
        List mmemberList = StringUtils.isBlank((String)json) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisChannel.class);
        if (null == mmemberList) {
            mmemberList = new ArrayList();
        } else if (!mmemberList.isEmpty()) {
            configcacheList = new ArrayList();
            for (DisChannel disChannel2 : mmemberList) {
                if (disChannel2.getChannelCode().equals(disChannel.getChannelCode())) continue;
                configcacheList.add(disChannel2);
            }
            mmemberList = configcacheList;
        }
        mmemberList.add(disChannel);
        DisUtil.setMapVer((String)this.cacheMmberList, (String)mmberListKey, (String)JsonUtil.buildNormalBinder().toJson(mmemberList));
        if ("1".equals(disChannel.getChannelGoodstype()) && StringUtils.isNotBlank((String)disChannel.getChannelMemcode())) {
            String outmberListKey = disChannel.getChannelMemcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode();
            String outjson = DisUtil.getRemotMap((String)this.cacheOutMember, (String)outmberListKey);
            List outmemberList = StringUtils.isBlank((String)outjson) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(outjson, DisChannel.class);
            if (null == outmemberList) {
                outmemberList = new ArrayList();
            } else if (!outmemberList.isEmpty()) {
                ArrayList<DisChannel> configcacheList2 = new ArrayList<DisChannel>();
                for (DisChannel disChannel2 : outmemberList) {
                    if (disChannel2.getChannelCode().equals(disChannel.getChannelCode())) continue;
                    configcacheList2.add(disChannel2);
                }
                outmemberList = configcacheList2;
            }
            outmemberList.add(disChannel);
            DisUtil.setMapVer((String)this.cacheOutMember, (String)outmberListKey, (String)JsonUtil.buildNormalBinder().toJson(outmemberList));
        }
        DisUtil.setMapVer((String)this.cacheCmember, (String)(disChannel.getMemberCcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)disChannel));
        json = DisUtil.getRemotMap((String)this.cacheProapp, (String)(disChannel.getProappCode() + "-" + disChannel.getTenantCode()));
        List proappList = StringUtils.isBlank((String)json) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisChannel.class);
        if (null == proappList) {
            proappList = new ArrayList();
        } else if (!proappList.isEmpty()) {
            ArrayList<DisChannel> configcacheList3 = new ArrayList<DisChannel>();
            for (DisChannel disChannel2 : proappList) {
                if (disChannel2.getChannelCode().equals(disChannel.getChannelCode())) continue;
                configcacheList3.add(disChannel2);
            }
            proappList = configcacheList3;
        }
        proappList.add(disChannel);
        DisUtil.setMapVer((String)this.cacheProapp, (String)(disChannel.getProappCode() + "-" + disChannel.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(proappList));
        DisUtil.setMapVer((String)this.cacheTginfo, (String)(disChannel.getTginfoCode() + "-" + disChannel.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)disChannel));
        DisUtil.setMapVer((String)this.cacheChannel, (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)disChannel));
    }

    @Override
    public QueryResult<DisChannel> queryChannelPage(Map<String, Object> map) {
        List<DisChannel> disChannelList = this.queryChannelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disChannelList);
        return queryResult;
    }

    @Override
    public DisChannel getChannelByCode(String tenantCode, String channelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        return this.getChannelModelByCode(map);
    }

    @Override
    public void deleteChannelByCode(String tenantCode, String channelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        this.delChannelModelByCode(map);
    }

    @Override
    public String saveChannelConfig(DisChannelConfigDomain disChannelConfigDomain) throws ApiException {
        DisChannelConfig disChannelConfig = this.createDisChannelConfig(disChannelConfigDomain);
        this.saveChannelConfigModel(disChannelConfig);
        this.updateConfigCache(disChannelConfig);
        return disChannelConfig.getChannelConfigCode();
    }

    @Override
    public String saveChannelConfigBatch(List<DisChannelConfigDomain> disChannelConfigDomainList) throws ApiException {
        if (null == disChannelConfigDomainList || disChannelConfigDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisChannelConfig> disChannelConfigList = new ArrayList<DisChannelConfig>();
        String code = "";
        for (DisChannelConfigDomain disChannelConfigDomain : disChannelConfigDomainList) {
            DisChannelConfig disChannelConfig = this.createDisChannelConfig(disChannelConfigDomain);
            code = disChannelConfig.getChannelConfigCode();
            disChannelConfigList.add(disChannelConfig);
        }
        this.saveChannelConfigBatchModel(disChannelConfigList);
        for (DisChannelConfig disChannelConfig2 : disChannelConfigList) {
            this.updateConfigCache(disChannelConfig2);
        }
        return code;
    }

    @Override
    public void updateChannelConfigState(Integer channelConfigId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateChannelConfigModel(channelConfigId, dataState, oldDataState);
    }

    @Override
    public void updateChannelConfigStateByCode(String tenantCode, String channelConfigCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateChannelConfigModelByCode(tenantCode, channelConfigCode, dataState, oldDataState);
    }

    @Override
    public void updateChannelConfig(DisChannelConfigDomain disChannelConfigDomain) throws ApiException {
        String msg = this.checkChannelConfig(disChannelConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisChannelServiceImpl.updateChannelConfig.checkChannelConfig", msg);
        }
        DisChannelConfig oldDisChannelConfig = this.getChannelConfigModelById(disChannelConfigDomain.getChannelConfigId());
        if (null == oldDisChannelConfig) {
            throw new ApiException("dis.DisChannelServiceImpl.updateChannelConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisChannelConfig disChannelConfig = this.makeChannelConfig(disChannelConfigDomain, oldDisChannelConfig);
        this.setChannelConfigUpdataDefault(disChannelConfig);
        this.updateChannelConfigModel(disChannelConfig);
        this.updateConfigCache(disChannelConfig);
    }

    @Override
    public DisChannelConfig getChannelConfig(Integer channelConfigId) {
        return this.getChannelConfigModelById(channelConfigId);
    }

    @Override
    public void deleteChannelConfig(Integer channelConfigId) throws ApiException {
        DisChannelConfig disChannelConfig = this.getChannelConfig(channelConfigId);
        this.deleteChannelConfigModel(channelConfigId);
        this.deleteConfigCache(disChannelConfig);
    }

    @Override
    public QueryResult<DisChannelConfig> queryChannelConfigPage(Map<String, Object> map) {
        List<DisChannelConfig> disChannelConfigList = this.queryChannelConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disChannelConfigList);
        return queryResult;
    }

    @Override
    public DisChannelConfig getChannelConfigByCode(String tenantCode, String channelConfigCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelConfigCode", channelConfigCode);
        return this.getChannelConfigModelByCode(map);
    }

    @Override
    public void deleteChannelConfigByCode(String tenantCode, String channelConfigCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelConfigCode", channelConfigCode);
        DisChannelConfig disChannelConfig = this.getChannelConfigByCode(tenantCode, channelConfigCode);
        this.delChannelConfigModelByCode(map);
        this.deleteConfigCache(disChannelConfig);
    }

    private void deleteConfigCache(DisChannelConfig disChannelConfig) {
        if (null == disChannelConfig) {
            return;
        }
        DisUtil.delMap((String)this.cacheChannelConfig, (String[])new String[]{disChannelConfig.getChannelCode() + "-" + disChannelConfig.getChannelApiCode() + "-" + disChannelConfig.getTenantCode()});
    }

    private void updateConfigCache(DisChannelConfig disChannelConfig) {
        if (null == disChannelConfig) {
            return;
        }
        String json = DisUtil.getMap((String)this.cacheChannelConfig, (String)(disChannelConfig.getChannelCode() + "-" + disChannelConfig.getChannelApiCode() + "-" + disChannelConfig.getTenantCode()));
        List configList = StringUtils.isBlank((String)json) ? new ArrayList() : (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisChannelConfig.class);
        if (null == configList) {
            configList = new ArrayList();
        } else if (!configList.isEmpty()) {
            ArrayList<DisChannelConfig> configcacheList = new ArrayList<DisChannelConfig>();
            for (DisChannelConfig disChannelConfig2 : configList) {
                if (disChannelConfig2.getChannelConfigCode().equals(disChannelConfig.getChannelConfigCode())) continue;
                configcacheList.add(disChannelConfig2);
            }
            configList = configcacheList;
        }
        configList.add(disChannelConfig);
        DisUtil.setMapVer((String)this.cacheChannelConfig, (String)(disChannelConfig.getChannelCode() + "-" + disChannelConfig.getChannelApiCode() + "-" + disChannelConfig.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(configList));
    }

    @Override
    public void queryChannelLoadCache() {
        this.logger.info("DisChannelService.queryChannelLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<DisChannel> channelList = this.queryChannelModelPage(parammap);
        if (null == channelList || channelList.isEmpty()) {
            DisUtil.delVer((String)this.cacheMember);
            DisUtil.delVer((String)this.cacheMmberList);
            DisUtil.delVer((String)this.cacheCmember);
            DisUtil.delVer((String)this.cacheProapp);
            DisUtil.delVer((String)this.cacheTginfo);
            DisUtil.delVer((String)this.cacheChannel);
            DisUtil.delVer((String)this.cacheOutMember);
            DisUtil.delVer((String)this.cacheThirdMember);
            this.logger.info("DisChannelService.queryChannelLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> memberMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, ArrayList<DisChannel>> mmemberMap = new ConcurrentHashMap<String, ArrayList<DisChannel>>();
        ConcurrentHashMap<String, String> cmemberMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap proappMap = new ConcurrentHashMap();
        ConcurrentHashMap<String, String> tginfoMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> channelMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, ArrayList<DisChannel>> outmemberMap = new ConcurrentHashMap<String, ArrayList<DisChannel>>();
        ConcurrentHashMap<String, ArrayList<DisChannel>> thirdmemberMap = new ConcurrentHashMap<String, ArrayList<DisChannel>>();
        String memberKey = null;
        for (DisChannel disChannel : channelList) {
            ArrayList<DisChannel> mmemberList;
            if (!"2".equals(disChannel.getChannelType())) {
                memberKey = disChannel.getMemberCode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode();
                if (!"0".equals(disChannel.getChannelSort())) {
                    memberKey = disChannel.getMemberCcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode();
                }
                memberMap.put(memberKey, JsonUtil.buildNormalBinder().toJson((Object)disChannel));
            } else {
                ArrayList<DisChannel> thirdmemberList = (ArrayList<DisChannel>)thirdmemberMap.get(disChannel.getMemberCode() + "-" + disChannel.getChannelType() + "-" + disChannel.getTenantCode());
                if (null == thirdmemberList) {
                    thirdmemberList = new ArrayList<DisChannel>();
                    thirdmemberMap.put(disChannel.getMemberCode() + "-" + disChannel.getChannelType() + "-" + disChannel.getTenantCode(), thirdmemberList);
                }
                thirdmemberList.add(disChannel);
            }
            if (StringUtils.isNotBlank((String)disChannel.getChannelGoodstype()) && "1".equals(disChannel.getChannelGoodstype()) && StringUtils.isNotBlank((String)disChannel.getChannelMemcode())) {
                ArrayList<DisChannel> outmemberList = (ArrayList<DisChannel>)outmemberMap.get(disChannel.getChannelMemcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode());
                if (null == outmemberList) {
                    outmemberList = new ArrayList<DisChannel>();
                    outmemberMap.put(disChannel.getChannelMemcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode(), outmemberList);
                }
                outmemberList.add(disChannel);
            }
            if (null == (mmemberList = (ArrayList<DisChannel>)mmemberMap.get(disChannel.getMemberMcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode()))) {
                mmemberList = new ArrayList<DisChannel>();
                mmemberMap.put(disChannel.getMemberMcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode(), mmemberList);
            }
            mmemberList.add(disChannel);
            cmemberMap.put(disChannel.getMemberCcode() + "-" + disChannel.getChannelSort() + "-" + disChannel.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)disChannel));
            ArrayList proappList = (ArrayList)proappMap.get(disChannel.getProappCode() + "-" + disChannel.getTenantCode());
            if (null == proappList) {
                proappList = new ArrayList();
                proappMap.put(disChannel.getProappCode() + "-" + disChannel.getTenantCode(), proappList);
            }
            tginfoMap.put(disChannel.getTginfoCode() + "-" + disChannel.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)disChannel));
            channelMap.put(disChannel.getChannelCode() + "-" + disChannel.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)disChannel));
        }
        ConcurrentHashMap<String, String> outmembercacheMap = new ConcurrentHashMap<String, String>();
        for (String key : outmemberMap.keySet()) {
            outmembercacheMap.put(key, JsonUtil.buildNormalBinder().toJson(outmemberMap.get(key)));
        }
        ConcurrentHashMap<String, String> thirdmembercacheMap = new ConcurrentHashMap<String, String>();
        for (String key : thirdmemberMap.keySet()) {
            thirdmembercacheMap.put(key, JsonUtil.buildNormalBinder().toJson(thirdmemberMap.get(key)));
        }
        ConcurrentHashMap<String, String> mmembercacheMap = new ConcurrentHashMap<String, String>();
        for (String key : mmemberMap.keySet()) {
            mmembercacheMap.put(key, JsonUtil.buildNormalBinder().toJson(mmemberMap.get(key)));
        }
        ConcurrentHashMap<String, String> proappcacheMap = new ConcurrentHashMap<String, String>();
        for (String key : proappMap.keySet()) {
            proappcacheMap.put(key, JsonUtil.buildNormalBinder().toJson(proappMap.get(key)));
        }
        DisUtil.setMapVer((String)this.cacheThirdMember, thirdmembercacheMap);
        DisUtil.setMapVer((String)this.cacheOutMember, outmembercacheMap);
        DisUtil.setMapVer((String)this.cacheMember, memberMap);
        DisUtil.setMapVer((String)this.cacheMmberList, mmembercacheMap);
        DisUtil.setMapVer((String)this.cacheCmember, cmemberMap);
        DisUtil.setMapVer((String)this.cacheProapp, proappcacheMap);
        DisUtil.setMapVer((String)this.cacheTginfo, tginfoMap);
        DisUtil.setMapVer((String)this.cacheChannel, channelMap);
        this.logger.info("DisChannelService.queryChannelLoadCache", (Object)"===========add-end==========");
        List<DisChannelConfig> configList = this.queryChannelConfigModelPage(null);
        if (null == configList || configList.isEmpty()) {
            DisUtil.delVer((String)this.cacheChannelConfig);
            return;
        }
        HashMap<String, HashMap<String, String>> map = new HashMap<String, HashMap<String, String>>();
        String key = "";
        HashMap<String, String> kmap = null;
        for (DisChannelConfig disChannelConfig : configList) {
            if (StringUtils.isBlank((String)disChannelConfig.getChannelApiCode())) {
                disChannelConfig.setChannelApiCode("all");
            }
            if (null == (kmap = (HashMap<String, String>)map.get(key = disChannelConfig.getChannelCode() + "-" + disChannelConfig.getChannelApiCode() + "-" + disChannelConfig.getChannelConfigScope() + "-" + disChannelConfig.getTenantCode()))) {
                kmap = new HashMap<String, String>();
                map.put(key, kmap);
            }
            kmap.put(disChannelConfig.getChannelConfigKey(), this.getValue(disChannelConfig.getChannelConfigValue(), disChannelConfig.getChannelConfigScope(), disChannelConfig.getChannelCode(), disChannelConfig.getTenantCode()));
        }
        HashMap<String, String> cmap = new HashMap<String, String>();
        for (String mkey : map.keySet()) {
            String value = JsonUtil.buildNormalBinder().toJson(map.get(mkey));
            if (StringUtil.isBlank((String)value)) continue;
            cmap.put(mkey, JsonUtil.buildNormalBinder().toJson(map.get(mkey)));
        }
        DisUtil.setMapVer((String)this.cacheChannelConfig, cmap);
    }

    private String getValue(String fchannelConfigValue, String fchannelConfigScope, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)fchannelConfigValue)) {
            return "";
        }
        if (fchannelConfigValue.indexOf("{") < 0) {
            return fchannelConfigValue;
        }
        if (fchannelConfigValue.indexOf("{channelConfigScope}") >= 0) {
            fchannelConfigValue = fchannelConfigValue.replaceAll("\\{hannelConfigScope\\}", fchannelConfigScope);
        }
        if (fchannelConfigValue.indexOf("{tenantCode}") >= 0) {
            fchannelConfigValue = fchannelConfigValue.replaceAll("\\{tenantCode\\}", tenantCode);
        }
        if (fchannelConfigValue.indexOf("{channelCode}") >= 0) {
            fchannelConfigValue = fchannelConfigValue.replaceAll("\\{channelCode\\}", channelCode);
        }
        if (fchannelConfigValue.indexOf("{") < 0 || fchannelConfigValue.indexOf("}") < 0) {
            this.logger.error("dis.DisChannelServiceImpl.getValue.start", (Object)(fchannelConfigValue + "==" + tenantCode));
            return fchannelConfigValue;
        }
        String code = fchannelConfigValue.substring(fchannelConfigValue.indexOf("{"));
        if (code.indexOf("}") < 0) {
            this.logger.error("dis.DisChannelServiceImpl.getValue.start1", (Object)(fchannelConfigValue + "==" + tenantCode));
            return fchannelConfigValue;
        }
        String json = DisUtil.getMap((String)"TmProappEnv-tenant-ProappCode", (String)(code = code.substring(1, code.indexOf("}"))));
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("dis.DisChannelServiceImpl.getValue.start2", (Object)(fchannelConfigValue + "==" + tenantCode + "==" + code));
            return fchannelConfigValue;
        }
        TmProappEnvDomain tmProappEnvDomain = (TmProappEnvDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, TmProappEnvDomain.class);
        if (null == tmProappEnvDomain) {
            this.logger.error("dis.DisChannelServiceImpl.getValue.start3", (Object)(fchannelConfigValue + "==" + tenantCode + "==" + code));
            return fchannelConfigValue;
        }
        String domain = tmProappEnvDomain.getProappEnvDomain();
        if (StringUtils.isBlank((String)domain)) {
            domain = tmProappEnvDomain.getProappEnvDomain1();
        }
        if (StringUtils.isBlank((String)domain)) {
            domain = tmProappEnvDomain.getProappEnvDomain2();
        }
        if (StringUtils.isBlank((String)domain)) {
            this.logger.error("dis.DisChannelServiceImpl.getValue.start4", (Object)(fchannelConfigValue + "==" + tenantCode + "==" + code));
            domain = "";
        }
        fchannelConfigValue = fchannelConfigValue.replaceAll("\\{" + code + "\\}", domain);
        return fchannelConfigValue;
    }
}

