/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisDpriceConfMapper;
import com.yqbsoft.laser.service.distribution.dao.DisDpriceConfbakMapper;
import com.yqbsoft.laser.service.distribution.dao.DisDpriceMapper;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceConfDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceConfReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceConfbakDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceConfbakReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceReDomain;
import com.yqbsoft.laser.service.distribution.model.DisDprice;
import com.yqbsoft.laser.service.distribution.model.DisDpriceConf;
import com.yqbsoft.laser.service.distribution.model.DisDpriceConfbak;
import com.yqbsoft.laser.service.distribution.service.DisChannelsendBaseService;
import com.yqbsoft.laser.service.distribution.service.DisDpriceService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DisDpriceServiceImpl
extends BaseServiceImpl
implements DisDpriceService {
    private static final String SYS_CODE = "dis.DisDpriceServiceImpl";
    private DisDpriceMapper disDpriceMapper;
    private DisDpriceConfMapper disDpriceConfMapper;
    private DisDpriceConfbakMapper disDpriceConfbakMapper;
    private String cachekey = "DisDpriceConf-channelCode";
    DisChannelsendBaseService disChannelsendBaseService;

    public void setDisDpriceMapper(DisDpriceMapper disDpriceMapper) {
        this.disDpriceMapper = disDpriceMapper;
    }

    public void setDisDpriceConfMapper(DisDpriceConfMapper disDpriceConfMapper) {
        this.disDpriceConfMapper = disDpriceConfMapper;
    }

    public void setDisDpriceConfbakMapper(DisDpriceConfbakMapper disDpriceConfbakMapper) {
        this.disDpriceConfbakMapper = disDpriceConfbakMapper;
    }

    private Date getSysDate() {
        try {
            return this.disDpriceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDprice(DisDpriceDomain disDpriceDomain) {
        if (null == disDpriceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDpriceDomain.getChannelCode())) {
            msg = msg + "ChannelCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disDpriceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDpriceDefault(DisDprice disDprice) {
        if (null == disDprice) {
            return;
        }
        if (null == disDprice.getDataState()) {
            disDprice.setDataState(0);
        }
        if (null == disDprice.getGmtCreate()) {
            disDprice.setGmtCreate(this.getSysDate());
        }
        disDprice.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)disDprice.getDpriceCode())) {
            disDprice.setDpriceCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
            disDprice.setChannelCode("all");
        }
    }

    private int getDpriceMaxCode() {
        int code = 0;
        try {
            return this.disDpriceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDpriceUpdataDefault(DisDprice disDprice) {
        if (null == disDprice) {
            return;
        }
        disDprice.setGmtModified(this.getSysDate());
    }

    private void saveDpriceModel(DisDprice disDprice) throws ApiException {
        if (null == disDprice) {
            return;
        }
        try {
            this.disDpriceMapper.insert(disDprice);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceModel.ex", (Throwable)e);
        }
    }

    private void saveDpriceBatchModel(List<DisDprice> disDpriceList) throws ApiException {
        if (null == disDpriceList || disDpriceList.isEmpty()) {
            return;
        }
        try {
            this.disDpriceMapper.insertBatch(disDpriceList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceBatchModel.ex", (Throwable)e);
        }
    }

    private DisDprice getDpriceModelById(Integer dpriceId) {
        if (null == dpriceId) {
            return null;
        }
        try {
            return this.disDpriceMapper.selectByPrimaryKey(dpriceId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceModelById", (Throwable)e);
            return null;
        }
    }

    private DisDprice getDpriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDpriceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDpriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceModelByCode.num");
        }
    }

    public void delDpriceModelByDgoodesCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.disDpriceMapper.deleteByDgGoodsCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceModelByDgoodesCode.ex", (Throwable)e);
        }
    }

    private void deleteDpriceModel(Integer dpriceId) throws ApiException {
        if (null == dpriceId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceMapper.deleteByPrimaryKey(dpriceId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.deleteDpriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.deleteDpriceModel.num");
        }
    }

    private void updateDpriceModel(DisDprice disDprice) throws ApiException {
        if (null == disDprice) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceMapper.updateByPrimaryKeySelective(disDprice);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceModel.num");
        }
    }

    private void updateStateDpriceModel(Integer dpriceId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == dpriceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceId", dpriceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDpriceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceModel.null");
        }
    }

    private void updateStateDpriceModelByCode(String tenantCode, String dpriceCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)dpriceCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceCode", dpriceCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDpriceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceModelByCode.null");
        }
    }

    private DisDprice makeDprice(DisDpriceDomain disDpriceDomain, DisDprice disDprice) {
        if (null == disDpriceDomain) {
            return null;
        }
        if (null == disDprice) {
            disDprice = new DisDprice();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDprice, (Object)disDpriceDomain);
            return disDprice;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.makeDprice", (Throwable)e);
            return null;
        }
    }

    private DisDpriceReDomain makeDisDpriceReDomain(DisDprice disDprice) {
        if (null == disDprice) {
            return null;
        }
        DisDpriceReDomain disDpriceReDomain = new DisDpriceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceReDomain, (Object)disDprice);
            return disDpriceReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.makeDisDpriceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDprice> queryDpriceModelPage(Map<String, Object> parammap) {
        try {
            return this.disDpriceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.queryDpriceModel", (Throwable)e);
            return null;
        }
    }

    private int countDprice(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDpriceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.countDprice", (Throwable)e);
        }
        return i;
    }

    private DisDprice createDisDprice(DisDpriceDomain disDpriceDomain) {
        String msg = this.checkDprice(disDpriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDprice.checkDprice", msg);
        }
        DisDprice disDprice = this.makeDprice(disDpriceDomain, null);
        this.setDpriceDefault(disDprice);
        return disDprice;
    }

    private String checkDpriceConf(DisDpriceConfDomain disDpriceConfDomain) {
        if (null == disDpriceConfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDpriceConfDomain.getDpriceConfType())) {
            msg = msg + "DpriceConfType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disDpriceConfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDpriceConfDefault(DisDpriceConf disDpriceConf) {
        if (null == disDpriceConf) {
            return;
        }
        if (null == disDpriceConf.getDataState()) {
            disDpriceConf.setDataState(0);
        }
        if (null == disDpriceConf.getGmtCreate()) {
            disDpriceConf.setGmtCreate(this.getSysDate());
        }
        disDpriceConf.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)disDpriceConf.getDpriceConfCode())) {
            disDpriceConf.setDpriceConfCode(this.createUUIDString());
        }
    }

    private int getDpriceConfMaxCode() {
        int code = 0;
        try {
            return this.disDpriceConfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceConfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDpriceConfUpdataDefault(DisDpriceConf disDpriceConf) {
        if (null == disDpriceConf) {
            return;
        }
        disDpriceConf.setGmtModified(this.getSysDate());
    }

    private void saveDpriceConfModel(DisDpriceConf disDpriceConf) throws ApiException {
        if (null == disDpriceConf) {
            return;
        }
        try {
            this.disDpriceConfMapper.insert(disDpriceConf);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConfModel.ex", (Throwable)e);
        }
    }

    private void saveDpriceConfBatchModel(List<DisDpriceConf> disDpriceConfList) throws ApiException {
        if (null == disDpriceConfList || disDpriceConfList.isEmpty()) {
            return;
        }
        try {
            this.disDpriceConfMapper.insertBatch(disDpriceConfList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConfBatchModel.ex", (Throwable)e);
        }
    }

    private DisDpriceConf getDpriceConfModelById(Integer dpriceConfId) {
        if (null == dpriceConfId) {
            return null;
        }
        try {
            return this.disDpriceConfMapper.selectByPrimaryKey(dpriceConfId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceConfModelById", (Throwable)e);
            return null;
        }
    }

    private DisDpriceConf getDpriceConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDpriceConfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceConfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDpriceConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceConfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceConfModelByCode.num");
        }
    }

    private void deleteDpriceConfModel(Integer dpriceConfId) throws ApiException {
        if (null == dpriceConfId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfMapper.deleteByPrimaryKey(dpriceConfId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.deleteDpriceConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.deleteDpriceConfModel.num");
        }
    }

    private void updateDpriceConfModel(DisDpriceConf disDpriceConf) throws ApiException {
        if (null == disDpriceConf) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfMapper.updateByPrimaryKeySelective(disDpriceConf);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfModel.num");
        }
    }

    private void updateStateDpriceConfModel(Integer dpriceConfId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == dpriceConfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceConfId", dpriceConfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDpriceConfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfModel.null");
        }
    }

    private void updateStateDpriceConfModelByCode(String tenantCode, String dpriceConfCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)dpriceConfCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfCode", dpriceConfCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDpriceConfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfModelByCode.null");
        }
    }

    private DisDpriceConf makeDpriceConf(DisDpriceConfDomain disDpriceConfDomain, DisDpriceConf disDpriceConf) {
        if (null == disDpriceConfDomain) {
            return null;
        }
        if (null == disDpriceConf) {
            disDpriceConf = new DisDpriceConf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceConf, (Object)disDpriceConfDomain);
            return disDpriceConf;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.makeDpriceConf", (Throwable)e);
            return null;
        }
    }

    private DisDpriceConfReDomain makeDisDpriceConfReDomain(DisDpriceConf disDpriceConf) {
        if (null == disDpriceConf) {
            return null;
        }
        DisDpriceConfReDomain disDpriceConfReDomain = new DisDpriceConfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceConfReDomain, (Object)disDpriceConf);
            return disDpriceConfReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.makeDisDpriceConfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDpriceConf> queryDpriceConfModelPage(Map<String, Object> parammap) {
        try {
            return this.disDpriceConfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.queryDpriceConfModel", (Throwable)e);
            return null;
        }
    }

    private int countDpriceConf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDpriceConfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.countDpriceConf", (Throwable)e);
        }
        return i;
    }

    private DisDpriceConf createDisDpriceConf(DisDpriceConfDomain disDpriceConfDomain) {
        String msg = this.checkDpriceConf(disDpriceConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConf.checkDpriceConf", msg);
        }
        DisDpriceConf disDpriceConf = this.makeDpriceConf(disDpriceConfDomain, null);
        this.setDpriceConfDefault(disDpriceConf);
        return disDpriceConf;
    }

    private String checkDpriceConfbak(DisDpriceConfbakDomain disDpriceConfbakDomain) {
        if (null == disDpriceConfbakDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDpriceConfbakDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDpriceConfbakDefault(DisDpriceConfbak disDpriceConfbak) {
        if (null == disDpriceConfbak) {
            return;
        }
        if (null == disDpriceConfbak.getDataState()) {
            disDpriceConfbak.setDataState(0);
        }
        if (null == disDpriceConfbak.getGmtCreate()) {
            disDpriceConfbak.setGmtCreate(this.getSysDate());
        }
        disDpriceConfbak.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)disDpriceConfbak.getDpriceConfbakCode())) {
            disDpriceConfbak.setDpriceConfbakCode(this.createUUIDString());
        }
    }

    private int getDpriceConfbakMaxCode() {
        int code = 0;
        try {
            return this.disDpriceConfbakMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceConfbakMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDpriceConfbakUpdataDefault(DisDpriceConfbak disDpriceConfbak) {
        if (null == disDpriceConfbak) {
            return;
        }
        disDpriceConfbak.setGmtModified(this.getSysDate());
    }

    private void saveDpriceConfbakModel(DisDpriceConfbak disDpriceConfbak) throws ApiException {
        if (null == disDpriceConfbak) {
            return;
        }
        try {
            this.disDpriceConfbakMapper.insert(disDpriceConfbak);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConfbakModel.ex", (Throwable)e);
        }
    }

    private void saveDpriceConfbakBatchModel(List<DisDpriceConfbak> disDpriceConfbakList) throws ApiException {
        if (null == disDpriceConfbakList || disDpriceConfbakList.isEmpty()) {
            return;
        }
        try {
            this.disDpriceConfbakMapper.insertBatch(disDpriceConfbakList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConfbakBatchModel.ex", (Throwable)e);
        }
    }

    private DisDpriceConfbak getDpriceConfbakModelById(Integer dpriceConfbakId) {
        if (null == dpriceConfbakId) {
            return null;
        }
        try {
            return this.disDpriceConfbakMapper.selectByPrimaryKey(dpriceConfbakId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceConfbakModelById", (Throwable)e);
            return null;
        }
    }

    private DisDpriceConfbak getDpriceConfbakModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDpriceConfbakMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceConfbakModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDpriceConfbakModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfbakMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceConfbakModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceConfbakModelByCode.num");
        }
    }

    private void deleteDpriceConfbakModel(Integer dpriceConfbakId) throws ApiException {
        if (null == dpriceConfbakId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfbakMapper.deleteByPrimaryKey(dpriceConfbakId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.deleteDpriceConfbakModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.deleteDpriceConfbakModel.num");
        }
    }

    private void updateDpriceConfbakModel(DisDpriceConfbak disDpriceConfbak) throws ApiException {
        if (null == disDpriceConfbak) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfbakMapper.updateByPrimaryKeySelective(disDpriceConfbak);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfbakModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfbakModel.num");
        }
    }

    private void updateStateDpriceConfbakModel(Integer dpriceConfbakId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == dpriceConfbakId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceConfbakId", dpriceConfbakId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDpriceConfbakMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfbakModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfbakModel.null");
        }
    }

    private void updateStateDpriceConfbakModelByCode(String tenantCode, String dpriceConfbakCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)dpriceConfbakCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfbakCode", dpriceConfbakCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDpriceConfbakMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfbakModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfbakModelByCode.null");
        }
    }

    private DisDpriceConfbak makeDpriceConfbak(DisDpriceConfbakDomain disDpriceConfbakDomain, DisDpriceConfbak disDpriceConfbak) {
        if (null == disDpriceConfbakDomain) {
            return null;
        }
        if (null == disDpriceConfbak) {
            disDpriceConfbak = new DisDpriceConfbak();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceConfbak, (Object)disDpriceConfbakDomain);
            return disDpriceConfbak;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.makeDpriceConfbak", (Throwable)e);
            return null;
        }
    }

    private DisDpriceConfbakReDomain makeDisDpriceConfbakReDomain(DisDpriceConfbak disDpriceConfbak) {
        if (null == disDpriceConfbak) {
            return null;
        }
        DisDpriceConfbakReDomain disDpriceConfbakReDomain = new DisDpriceConfbakReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceConfbakReDomain, (Object)disDpriceConfbak);
            return disDpriceConfbakReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.makeDisDpriceConfbakReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDpriceConfbak> queryDpriceConfbakModelPage(Map<String, Object> parammap) {
        try {
            return this.disDpriceConfbakMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.queryDpriceConfbakModel", (Throwable)e);
            return null;
        }
    }

    private int countDpriceConfbak(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDpriceConfbakMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.countDpriceConfbak", (Throwable)e);
        }
        return i;
    }

    private DisDpriceConfbak createDisDpriceConfbak(DisDpriceConfbakDomain disDpriceConfbakDomain) {
        String msg = this.checkDpriceConfbak(disDpriceConfbakDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConfbak.checkDpriceConfbak", msg);
        }
        DisDpriceConfbak disDpriceConfbak = this.makeDpriceConfbak(disDpriceConfbakDomain, null);
        this.setDpriceConfbakDefault(disDpriceConfbak);
        return disDpriceConfbak;
    }

    @Override
    public String saveDprice(DisDpriceDomain disDpriceDomain) throws ApiException {
        DisDprice disDprice = this.createDisDprice(disDpriceDomain);
        this.saveDpriceModel(disDprice);
        List<DisDpriceConf> disDpriceConfList = disDpriceDomain.getDisDpriceConfList();
        if (ListUtil.isNotEmpty(disDpriceConfList)) {
            for (DisDpriceConf disDpriceConf : disDpriceConfList) {
                disDpriceConf.setDpriceCode(disDprice.getDpriceCode());
            }
            this.saveDpriceConfBatchModel(disDpriceConfList);
            for (DisDpriceConf disDpriceConf : disDpriceConfList) {
                this.updateDpriceConfCache(disDpriceConf);
            }
        }
        this.updateDpriceCache(disDprice);
        return disDprice.getDpriceCode();
    }

    @Override
    public String saveDpriceBatch(List<DisDpriceDomain> disDpriceDomainList) throws ApiException {
        if (null == disDpriceDomainList || disDpriceDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDprice> disDpriceList = new ArrayList<DisDprice>();
        String code = "";
        for (DisDpriceDomain disDpriceDomain : disDpriceDomainList) {
            DisDprice disDprice = this.createDisDprice(disDpriceDomain);
            code = disDprice.getDpriceCode();
            disDpriceList.add(disDprice);
        }
        this.saveDpriceBatchModel(disDpriceList);
        for (DisDprice disDprice2 : disDpriceList) {
            this.updateDpriceCache(disDprice2);
        }
        return code;
    }

    @Override
    public void updateDpriceState(Integer dpriceId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDpriceModel(dpriceId, dataState, oldDataState);
        if (-1 == dataState) {
            DisDprice disDprice = this.getDprice(dpriceId);
            this.deleteDpriceCache(disDprice);
        }
    }

    @Override
    public void updateDpriceStateByCode(String tenantCode, String dpriceCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDpriceModelByCode(tenantCode, dpriceCode, dataState, oldDataState);
        if (-1 == dataState) {
            DisDprice disDprice = this.getDpriceByCode(tenantCode, dpriceCode);
            this.deleteDpriceCache(disDprice);
        }
    }

    @Override
    public void updateDprice(DisDpriceDomain disDpriceDomain) throws ApiException {
        String msg = this.checkDprice(disDpriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDprice.checkDprice", msg);
        }
        DisDprice oldDisDprice = this.getDpriceModelById(disDpriceDomain.getDpriceId());
        if (null == oldDisDprice) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDprice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDprice disDprice = this.makeDprice(disDpriceDomain, oldDisDprice);
        this.setDpriceUpdataDefault(disDprice);
        List<DisDpriceConf> disDpriceConfList = disDpriceDomain.getDisDpriceConfList();
        if (ListUtil.isNotEmpty(disDpriceConfList)) {
            this.deleteDisPriceConfBypriceCode(oldDisDprice.getDpriceCode(), oldDisDprice.getTenantCode());
            this.saveDpriceConfBatchModel(disDpriceConfList);
            for (DisDpriceConf disDpriceConf : disDpriceConfList) {
                this.updateDpriceConfCache(disDpriceConf);
            }
        }
        this.updateDpriceModel(disDprice);
        oldDisDprice = this.getDpriceModelById(disDpriceDomain.getDpriceId());
        if (null == oldDisDprice) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDprice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateDpriceCache(oldDisDprice);
    }

    @Override
    public DisDprice getDprice(Integer dpriceId) {
        DisDprice dpriceModelById = this.getDpriceModelById(dpriceId);
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dpriceCode", dpriceModelById.getDpriceCode());
        parammap.put("tenantCode", dpriceModelById.getTenantCode());
        List<DisDpriceConf> disDpriceConfs = this.queryDpriceConfModelPage(parammap);
        dpriceModelById.setDisDpriceConfList(disDpriceConfs);
        return dpriceModelById;
    }

    private void deleteDisPriceConfBypriceCode(String dpriceCode, String tenantCode) {
        if (StringUtils.isBlank((String)dpriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceCode", dpriceCode);
        map.put("tenantCode", tenantCode);
        this.disDpriceConfMapper.deleteDisPriceConfBypriceCode(map);
    }

    @Override
    public void deleteDprice(Integer dpriceId) throws ApiException {
        DisDprice disDprice = this.getDprice(dpriceId);
        this.deleteDpriceModel(dpriceId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceCode", disDprice.getDpriceCode());
        map.put("tenantCode", disDprice.getTenantCode());
        List<DisDpriceConf> disDpriceConfs = this.queryDpriceConfModelPage(map);
        for (DisDpriceConf disDpriceConf : disDpriceConfs) {
            this.deleteDpriceConf(disDpriceConf.getDpriceConfId());
        }
        this.deleteDpriceCache(disDprice);
    }

    @Override
    public QueryResult<DisDprice> queryDpricePage(Map<String, Object> map) {
        List<DisDprice> disDpriceList = this.queryDpriceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDprice(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDpriceList);
        return queryResult;
    }

    @Override
    public DisDprice getDpriceByCode(String tenantCode, String dpriceCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceCode", dpriceCode);
        return this.getDpriceModelByCode(map);
    }

    @Override
    public void deleteDpriceByCode(String tenantCode, String dpriceCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceCode", dpriceCode);
        DisDprice disDprice = this.getDpriceByCode(tenantCode, dpriceCode);
        this.delDpriceModelByCode(map);
        this.deleteDpriceCache(disDprice);
    }

    @Override
    public String saveDpriceConf(DisDpriceConfDomain disDpriceConfDomain) throws ApiException {
        DisDpriceConf disDpriceConf = this.createDisDpriceConf(disDpriceConfDomain);
        this.saveDpriceConfModel(disDpriceConf);
        this.updateDpriceConfCache(disDpriceConf);
        return disDpriceConf.getDpriceConfCode();
    }

    @Override
    public String saveDpriceConfBatch(List<DisDpriceConfDomain> disDpriceConfDomainList) throws ApiException {
        if (null == disDpriceConfDomainList || disDpriceConfDomainList.isEmpty()) {
            return null;
        }
        String dpriceCode = disDpriceConfDomainList.get(0).getDpriceCode();
        String tenantCode = disDpriceConfDomainList.get(0).getTenantCode();
        this.deleteDisPriceConfBypriceCode(dpriceCode, tenantCode);
        ArrayList<DisDpriceConf> disDpriceConfList = new ArrayList<DisDpriceConf>();
        String code = "";
        for (DisDpriceConfDomain disDpriceConfDomain : disDpriceConfDomainList) {
            DisDpriceConf disDpriceConf = this.createDisDpriceConf(disDpriceConfDomain);
            code = disDpriceConf.getDpriceConfCode();
            disDpriceConfList.add(disDpriceConf);
        }
        this.saveDpriceConfBatchModel(disDpriceConfList);
        for (DisDpriceConf disDpriceConf2 : disDpriceConfList) {
            this.updateDpriceConfCache(disDpriceConf2);
        }
        return code;
    }

    @Override
    public void updateDpriceConfState(Integer dpriceConfId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDpriceConfModel(dpriceConfId, dataState, oldDataState);
        if (-1 == dataState) {
            DisDpriceConf disDpriceConf = this.getDpriceConf(dpriceConfId);
            this.deleteDpriceConfCache(disDpriceConf);
        }
    }

    @Override
    public void updateDpriceConfStateByCode(String tenantCode, String dpriceConfCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDpriceConfModelByCode(tenantCode, dpriceConfCode, dataState, oldDataState);
        if (-1 == dataState) {
            DisDpriceConf disDpriceConf = this.getDpriceConfByCode(tenantCode, dpriceConfCode);
            this.deleteDpriceConfCache(disDpriceConf);
        }
    }

    @Override
    public void updateDpriceConf(DisDpriceConfDomain disDpriceConfDomain) throws ApiException {
        String msg = this.checkDpriceConf(disDpriceConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConf.checkDpriceConf", msg);
        }
        DisDpriceConf oldDisDpriceConf = this.getDpriceConfModelById(disDpriceConfDomain.getDpriceConfId());
        if (null == oldDisDpriceConf) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDpriceConf disDpriceConf = this.makeDpriceConf(disDpriceConfDomain, oldDisDpriceConf);
        this.setDpriceConfUpdataDefault(disDpriceConf);
        this.updateDpriceConfModel(disDpriceConf);
        this.updateDpriceConfCache(disDpriceConf);
    }

    @Override
    public DisDpriceConf getDpriceConf(Integer dpriceConfId) {
        return this.getDpriceConfModelById(dpriceConfId);
    }

    @Override
    public void deleteDpriceConf(Integer dpriceConfId) throws ApiException {
        DisDpriceConf disDpriceConf = this.getDpriceConf(dpriceConfId);
        this.deleteDpriceConfModel(dpriceConfId);
        this.deleteDpriceConfCache(disDpriceConf);
    }

    @Override
    public QueryResult<DisDpriceConf> queryDpriceConfPage(Map<String, Object> map) {
        List<DisDpriceConf> disDpriceConfList = this.queryDpriceConfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDpriceConf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDpriceConfList);
        return queryResult;
    }

    @Override
    public DisDpriceConf getDpriceConfByCode(String tenantCode, String dpriceConfCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfCode", dpriceConfCode);
        return this.getDpriceConfModelByCode(map);
    }

    @Override
    public void deleteDpriceConfByCode(String tenantCode, String dpriceConfCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfCode", dpriceConfCode);
        DisDpriceConf disDpriceConf = this.getDpriceConfByCode(tenantCode, dpriceConfCode);
        this.delDpriceConfModelByCode(map);
        this.deleteDpriceConfCache(disDpriceConf);
    }

    @Override
    public String saveDpriceConfbak(DisDpriceConfbakDomain disDpriceConfbakDomain) throws ApiException {
        DisDpriceConfbak disDpriceConfbak = this.createDisDpriceConfbak(disDpriceConfbakDomain);
        this.saveDpriceConfbakModel(disDpriceConfbak);
        return disDpriceConfbak.getDpriceConfbakCode();
    }

    @Override
    public String saveDpriceConfbakBatch(List<DisDpriceConfbakDomain> disDpriceConfbakDomainList) throws ApiException {
        if (null == disDpriceConfbakDomainList || disDpriceConfbakDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDpriceConfbak> disDpriceConfbakList = new ArrayList<DisDpriceConfbak>();
        String code = "";
        for (DisDpriceConfbakDomain disDpriceConfbakDomain : disDpriceConfbakDomainList) {
            DisDpriceConfbak disDpriceConfbak = this.createDisDpriceConfbak(disDpriceConfbakDomain);
            code = disDpriceConfbak.getDpriceConfbakCode();
            disDpriceConfbakList.add(disDpriceConfbak);
        }
        this.saveDpriceConfbakBatchModel(disDpriceConfbakList);
        return code;
    }

    @Override
    public void updateDpriceConfbakState(Integer dpriceConfbakId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDpriceConfbakModel(dpriceConfbakId, dataState, oldDataState);
    }

    @Override
    public void updateDpriceConfbakStateByCode(String tenantCode, String dpriceConfbakCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDpriceConfbakModelByCode(tenantCode, dpriceConfbakCode, dataState, oldDataState);
    }

    @Override
    public void updateDpriceConfbak(DisDpriceConfbakDomain disDpriceConfbakDomain) throws ApiException {
        String msg = this.checkDpriceConfbak(disDpriceConfbakDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfbak.checkDpriceConfbak", msg);
        }
        DisDpriceConfbak oldDisDpriceConfbak = this.getDpriceConfbakModelById(disDpriceConfbakDomain.getDpriceConfbakId());
        if (null == oldDisDpriceConfbak) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfbak.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDpriceConfbak disDpriceConfbak = this.makeDpriceConfbak(disDpriceConfbakDomain, oldDisDpriceConfbak);
        this.setDpriceConfbakUpdataDefault(disDpriceConfbak);
        this.updateDpriceConfbakModel(disDpriceConfbak);
    }

    @Override
    public DisDpriceConfbak getDpriceConfbak(Integer dpriceConfbakId) {
        return this.getDpriceConfbakModelById(dpriceConfbakId);
    }

    @Override
    public void deleteDpriceConfbak(Integer dpriceConfbakId) throws ApiException {
        this.deleteDpriceConfbakModel(dpriceConfbakId);
    }

    @Override
    public QueryResult<DisDpriceConfbak> queryDpriceConfbakPage(Map<String, Object> map) {
        List<DisDpriceConfbak> disDpriceConfbakList = this.queryDpriceConfbakModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDpriceConfbak(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDpriceConfbakList);
        return queryResult;
    }

    @Override
    public DisDpriceConfbak getDpriceConfbakByCode(String tenantCode, String dpriceConfbakCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfbakCode", dpriceConfbakCode);
        return this.getDpriceConfbakModelByCode(map);
    }

    @Override
    public void deleteDpriceConfbakByCode(String tenantCode, String dpriceConfbakCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfbakCode", dpriceConfbakCode);
        this.delDpriceConfbakModelByCode(map);
    }

    private void deleteDpriceCache(DisDprice disDprice) {
        String json;
        if (null == disDprice) {
            return;
        }
        if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
            disDprice.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getMap((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()))))) {
            return;
        }
        List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDpriceDomain.class);
        ArrayList<DisDpriceDomain> dlist2 = new ArrayList<DisDpriceDomain>();
        for (DisDpriceDomain disDpriceDomain2 : dlist) {
            if (disDpriceDomain2.getDpriceCode().equals(disDprice.getDpriceCode())) continue;
            dlist2.add(disDpriceDomain2);
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist2)));
    }

    private void deleteDpriceConfCache(DisDpriceConf disDpriceConf) {
        String json;
        if (null == disDpriceConf) {
            return;
        }
        DisDprice disDprice = this.getDpriceByCode(disDpriceConf.getTenantCode(), disDpriceConf.getDpriceCode());
        if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
            disDprice.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getMap((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()))))) {
            return;
        }
        List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDpriceDomain.class);
        ArrayList<DisDpriceDomain> dlist1 = new ArrayList<DisDpriceDomain>();
        for (DisDpriceDomain disDpriceDomain2 : dlist) {
            if (disDpriceDomain2.getDpriceCode().equals(disDprice.getDpriceCode())) {
                ArrayList<DisDpriceConf> configcacheList = new ArrayList<DisDpriceConf>();
                disDpriceDomain2.setDisDpriceConfList(configcacheList);
                for (DisDpriceConf disDpriceConf2 : disDpriceDomain2.getDisDpriceConfList()) {
                    if (disDpriceConf2.getDpriceConfCode().equals(disDpriceConf.getDpriceConfCode())) continue;
                    configcacheList.add(disDpriceConf2);
                }
            }
            dlist1.add(disDpriceDomain2);
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDpriceConf.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist1)));
    }

    private void updateDpriceCache(DisDprice disDprice) {
        if (null == disDprice) {
            return;
        }
        DisDpriceDomain disDpriceDomain = this.makeDisDpriceDomain(disDprice);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dpriceCode", disDprice.getDpriceCode());
        confparammap.put("tenantCode", disDprice.getTenantCode());
        List<DisDpriceConf> upcachelist = this.queryDpriceConfModelPage(confparammap);
        disDpriceDomain.setDisDpriceConfList(upcachelist);
        String json = DisUtil.getMap((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<DisDpriceDomain> dlist = new ArrayList<DisDpriceDomain>();
            dlist.add(disDpriceDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        } else {
            List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDpriceDomain.class);
            for (DisDpriceDomain disDpriceDomain2 : dlist) {
                if (!disDpriceDomain2.getDpriceCode().equals(disDprice.getDpriceCode())) continue;
                disDpriceDomain2 = disDpriceDomain;
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        }
    }

    private void updateDpriceConfCache(DisDpriceConf disDpriceConf) {
        if (null == disDpriceConf) {
            return;
        }
        DisDprice disDprice = this.getDpriceByCode(disDpriceConf.getTenantCode(), disDpriceConf.getDpriceCode());
        if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
            disDprice.setChannelCode("all");
        }
        DisDpriceDomain disDpriceDomain = this.makeDisDpriceDomain(disDprice);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dpriceCode", disDprice.getDpriceCode());
        confparammap.put("tenantCode", disDprice.getTenantCode());
        List<DisDpriceConf> upcachelist = this.queryDpriceConfModelPage(confparammap);
        disDpriceDomain.setDisDpriceConfList(upcachelist);
        String json = DisUtil.getMap((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<DisDpriceDomain> dlist = new ArrayList<DisDpriceDomain>();
            dlist.add(disDpriceDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDpriceConf.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        } else {
            List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDpriceDomain.class);
            for (DisDpriceDomain disDpriceDomain2 : dlist) {
                if (!disDpriceDomain2.getDpriceCode().equals(disDprice.getDpriceCode())) continue;
                for (DisDpriceConf disDpriceConf2 : disDpriceDomain2.getDisDpriceConfList()) {
                    if (!disDpriceConf2.getDpriceConfCode().equals(disDpriceConf.getDpriceConfCode())) continue;
                    disDpriceConf2 = disDpriceConf;
                }
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDpriceConf.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        }
    }

    @Override
    public void queryDpriceLoadCache() {
        this.logger.info("DisDpriceService.queryDpriceLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<DisDprice> disDpriceList = this.queryDpriceModelPage(parammap);
        if (null == disDpriceList || disDpriceList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("DisDpriceService.queryDpriceLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap<String, ArrayList<DisDpriceDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<DisDpriceDomain>>();
        for (DisDprice disDprice : disDpriceList) {
            if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
                disDprice.setChannelCode("all");
            }
            DisDpriceDomain disDpriceDomain = this.makeDisDpriceDomain(disDprice);
            confparammap.put("dpriceCode", disDprice.getDpriceCode());
            confparammap.put("tenantCode", disDprice.getTenantCode());
            List<DisDpriceConf> upcachelist = this.queryDpriceConfModelPage(confparammap);
            disDpriceDomain.setDisDpriceConfList(upcachelist);
            ArrayList<DisDpriceDomain> dlist = (ArrayList<DisDpriceDomain>)ddListMap.get(disDprice.getChannelCode() + "-" + disDprice.getTenantCode());
            if (null == dlist) {
                dlist = new ArrayList<DisDpriceDomain>();
                ddListMap.put(disDprice.getChannelCode() + "-" + disDprice.getTenantCode(), dlist);
            }
            dlist.add(disDpriceDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.disDomainsort((List)ddListMap.get(key))));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.info("DisDpriceService.queryDpriceLoadCache", (Object)"===========add-end==========");
    }

    private List<DisDpriceDomain> disDomainsort(List<DisDpriceDomain> dlist) {
        if (ListUtil.isEmpty(dlist)) {
            return null;
        }
        Collections.sort(dlist, new Comparator<DisDpriceDomain>(){

            @Override
            public int compare(DisDpriceDomain arg0, DisDpriceDomain arg1) {
                if (arg0.getDpriceWeight() > arg1.getDpriceWeight()) {
                    return 1;
                }
                if (arg0.getDpriceWeight() < arg1.getDpriceWeight()) {
                    return -1;
                }
                return arg0.getDpriceWeight().compareTo(arg0.getDpriceWeight());
            }
        });
        return dlist;
    }

    private DisDpriceDomain makeDisDpriceDomain(DisDprice disDprice) {
        if (null == disDprice) {
            return null;
        }
        DisDpriceDomain disDpriceDomain = new DisDpriceDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceDomain, (Object)disDprice);
            return disDpriceDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDisChannelsendBaseService(DisChannelsendBaseService disChannelsendBaseService) {
        this.disChannelsendBaseService = disChannelsendBaseService;
    }

    @Override
    public void makeDpriceLoadCache() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<DisDprice> disDpriceList = this.queryDpriceModelPage(parammap);
        if (null == disDpriceList || disDpriceList.isEmpty()) {
            return;
        }
        for (DisDprice disDprice : disDpriceList) {
            if (null == disDprice.getDpriceEydate() || disDprice.getDpriceEydate().getTime() > this.getSysDate().getTime()) continue;
            try {
                this.updateDpriceState(disDprice.getDpriceId(), -1, 0);
                this.disChannelsendBaseService.sendSaveDgoodsUpdate(disDprice.getChannelCode(), disDprice.getTenantCode());
            }
            catch (Exception e) {}
        }
    }
}

