/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisStatementsetMapper;
import com.yqbsoft.laser.service.distribution.domain.DisContractlogDomain;
import com.yqbsoft.laser.service.distribution.domain.DisStatementsetDomain;
import com.yqbsoft.laser.service.distribution.domain.DisStatementsetReDomain;
import com.yqbsoft.laser.service.distribution.model.DisChannel;
import com.yqbsoft.laser.service.distribution.model.DisStatementset;
import com.yqbsoft.laser.service.distribution.service.DisChannelService;
import com.yqbsoft.laser.service.distribution.service.DisChannelsendBaseService;
import com.yqbsoft.laser.service.distribution.service.DisStatementsetService;
import com.yqbsoft.laser.service.distribution.stateres.SendPollThread;
import com.yqbsoft.laser.service.distribution.stateres.SendPutThread;
import com.yqbsoft.laser.service.distribution.stateres.SendService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisStatementsetServiceImpl
extends BaseServiceImpl
implements DisStatementsetService {
    private static final String SYS_CODE = "dis.DisStatementsetServiceImpl";
    private DisStatementsetMapper disStatementsetMapper;
    private static SendService sendService;
    private static Object lock;
    DisChannelsendBaseService disChannelsendBaseService;
    DisChannelService disChannelService;

    public void setDisStatementsetMapper(DisStatementsetMapper disStatementsetMapper) {
        this.disStatementsetMapper = disStatementsetMapper;
    }

    private Date getSysDate() {
        try {
            return this.disStatementsetMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementsetServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStatementset(DisStatementsetDomain disStatementsetDomain) {
        if (null == disStatementsetDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disStatementsetDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStatementsetDefault(DisStatementset disStatementset) {
        if (null == disStatementset) {
            return;
        }
        if (null == disStatementset.getDataState()) {
            disStatementset.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disStatementset.getGmtCreate()) {
            disStatementset.setGmtCreate(date);
        }
        disStatementset.setGmtModified(date);
        if (StringUtils.isBlank((String)disStatementset.getStatementsetCode())) {
            disStatementset.setStatementsetCode(this.getNo(null, "DisStatementset", "disStatementset", disStatementset.getTenantCode()));
        }
    }

    private int getStatementsetMaxCode() {
        int code = 0;
        try {
            return this.disStatementsetMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementsetServiceImpl.getStatementsetMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStatementsetUpdataDefault(DisStatementset disStatementset) {
        if (null == disStatementset) {
            return;
        }
        disStatementset.setGmtModified(this.getSysDate());
    }

    private void saveStatementsetModel(DisStatementset disStatementset) throws ApiException {
        if (null == disStatementset) {
            return;
        }
        try {
            this.disStatementsetMapper.insert(disStatementset);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementsetServiceImpl.saveStatementsetModel.ex", (Throwable)e);
        }
    }

    private void saveStatementsetBatchModel(List<DisStatementset> disStatementsetList) throws ApiException {
        if (null == disStatementsetList || disStatementsetList.isEmpty()) {
            return;
        }
        try {
            this.disStatementsetMapper.insertBatch(disStatementsetList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementsetServiceImpl.saveStatementsetBatchModel.ex", (Throwable)e);
        }
    }

    private DisStatementset getStatementsetModelById(Integer statementsetId) {
        if (null == statementsetId) {
            return null;
        }
        try {
            return this.disStatementsetMapper.selectByPrimaryKey(statementsetId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementsetServiceImpl.getStatementsetModelById", (Throwable)e);
            return null;
        }
    }

    private DisStatementset getStatementsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disStatementsetMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementsetServiceImpl.getStatementsetModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStatementsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatementsetMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementsetServiceImpl.delStatementsetModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatementsetServiceImpl.delStatementsetModelByCode.num");
        }
    }

    private void deleteStatementsetModel(Integer statementsetId) throws ApiException {
        if (null == statementsetId) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatementsetMapper.deleteByPrimaryKey(statementsetId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementsetServiceImpl.deleteStatementsetModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatementsetServiceImpl.deleteStatementsetModel.num");
        }
    }

    private void updateStatementsetModel(DisStatementset disStatementset) throws ApiException {
        if (null == disStatementset) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatementsetMapper.updateByPrimaryKey(disStatementset);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementsetServiceImpl.updateStatementsetModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatementsetServiceImpl.updateStatementsetModel.num");
        }
    }

    private void updateStateStatementsetModel(Integer statementsetId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == statementsetId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statementsetId", statementsetId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disStatementsetMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementsetServiceImpl.updateStateStatementsetModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisStatementsetServiceImpl.updateStateStatementsetModel.null");
        }
    }

    private void updateStateStatementsetModelByCode(String tenantCode, String statementsetCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)statementsetCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statementsetCode", statementsetCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disStatementsetMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementsetServiceImpl.updateStateStatementsetModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisStatementsetServiceImpl.updateStateStatementsetModelByCode.null");
        }
    }

    private DisStatementset makeStatementset(DisStatementsetDomain disStatementsetDomain, DisStatementset disStatementset) {
        if (null == disStatementsetDomain) {
            return null;
        }
        if (null == disStatementset) {
            disStatementset = new DisStatementset();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disStatementset, (Object)disStatementsetDomain);
            return disStatementset;
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementsetServiceImpl.makeStatementset", (Throwable)e);
            return null;
        }
    }

    private DisStatementsetReDomain makeDisStatementsetReDomain(DisStatementset disStatementset) {
        if (null == disStatementset) {
            return null;
        }
        DisStatementsetReDomain disStatementsetReDomain = new DisStatementsetReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disStatementsetReDomain, (Object)disStatementset);
            return disStatementsetReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementsetServiceImpl.makeDisStatementsetReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisStatementset> queryStatementsetModelPage(Map<String, Object> parammap) {
        try {
            return this.disStatementsetMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementsetServiceImpl.queryStatementsetModel", (Throwable)e);
            return null;
        }
    }

    private int countStatementset(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disStatementsetMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementsetServiceImpl.countStatementset", (Throwable)e);
        }
        return i;
    }

    private DisStatementset createDisStatementset(DisStatementsetDomain disStatementsetDomain) {
        String msg = this.checkStatementset(disStatementsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisStatementsetServiceImpl.saveStatementset.checkStatementset", msg);
        }
        DisStatementset disStatementset = this.makeStatementset(disStatementsetDomain, null);
        this.setStatementsetDefault(disStatementset);
        return disStatementset;
    }

    @Override
    public String saveStatementset(DisStatementsetDomain disStatementsetDomain) throws ApiException {
        DisStatementset disStatementset = this.createDisStatementset(disStatementsetDomain);
        this.saveStatementsetModel(disStatementset);
        return disStatementset.getStatementsetCode();
    }

    @Override
    public String saveStatementsetBatch(List<DisStatementsetDomain> disStatementsetDomainList) throws ApiException {
        if (null == disStatementsetDomainList || disStatementsetDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisStatementset> disStatementsetList = new ArrayList<DisStatementset>();
        String code = "";
        for (DisStatementsetDomain disStatementsetDomain : disStatementsetDomainList) {
            DisStatementset disStatementset = this.createDisStatementset(disStatementsetDomain);
            code = disStatementset.getStatementsetCode();
            disStatementsetList.add(disStatementset);
        }
        this.saveStatementsetBatchModel(disStatementsetList);
        return code;
    }

    @Override
    public void updateStatementsetState(Integer statementsetId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == statementsetId) {
            return;
        }
        this.updateStateStatementsetModel(statementsetId, dataState, oldDataState, map);
    }

    @Override
    public void updateStatementsetStateByCode(String tenantCode, String statementsetCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)statementsetCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateStatementsetModelByCode(tenantCode, statementsetCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStatementset(DisStatementsetDomain disStatementsetDomain) throws ApiException {
        String msg = this.checkStatementset(disStatementsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisStatementsetServiceImpl.updateStatementset.checkStatementset", msg);
        }
        DisStatementset oldDisStatementset = this.getStatementsetModelById(disStatementsetDomain.getStatementsetId());
        if (null == oldDisStatementset) {
            throw new ApiException("dis.DisStatementsetServiceImpl.updateStatementset.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisStatementset disStatementset = this.makeStatementset(disStatementsetDomain, oldDisStatementset);
        this.setStatementsetUpdataDefault(disStatementset);
        this.updateStatementsetModel(disStatementset);
    }

    @Override
    public DisStatementset getStatementset(Integer statementsetId) {
        if (null == statementsetId) {
            return null;
        }
        return this.getStatementsetModelById(statementsetId);
    }

    @Override
    public void deleteStatementset(Integer statementsetId) throws ApiException {
        if (null == statementsetId) {
            return;
        }
        this.deleteStatementsetModel(statementsetId);
    }

    @Override
    public QueryResult<DisStatementset> queryStatementsetPage(Map<String, Object> map) {
        List<DisStatementset> disStatementsetList = this.queryStatementsetModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStatementset(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disStatementsetList);
        return queryResult;
    }

    @Override
    public DisStatementset getStatementsetByCode(String tenantCode, String statementsetCode) throws ApiException {
        if (StringUtils.isBlank((String)statementsetCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statementsetCode", statementsetCode);
        return this.getStatementsetModelByCode(map);
    }

    @Override
    public void deleteStatementsetByCode(String tenantCode, String statementsetCode) throws ApiException {
        if (StringUtils.isBlank((String)statementsetCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statementsetCode", statementsetCode);
        this.delStatementsetModelByCode(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((DisStatementsetService)SpringApplicationContextUtil.getBean((String)"disStatementsetService"));
                for (int i = 0; i < 5; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    @Override
    public void saveSendStatementLoad() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dorderUp", "1");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            int startRow = 0;
            boolean flag = true;
            QueryResult<DisStatementset> result = null;
            do {
                startRow = DisStatementsetServiceImpl.getSendService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", DisStatementsetServiceImpl.getSendService().getPage());
                result = this.queryStatementsetPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    this.logger.info("dis.DisStatementsetServiceImpl.loadDb.result1", (Object)((Object)map).toString());
                    startRow = result.getPageTools().getRecordCountNo();
                    DisStatementsetServiceImpl.getSendService().addPutPool(new SendPutThread(DisStatementsetServiceImpl.getSendService(), result.getRows()));
                    if (result.getRows().size() != DisStatementsetServiceImpl.getSendService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
            } while (flag);
            DisStatementsetServiceImpl.getSendService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementsetServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    public void setDisChannelsendBaseService(DisChannelsendBaseService disChannelsendBaseService) {
        this.disChannelsendBaseService = disChannelsendBaseService;
    }

    public void setDisChannelService(DisChannelService disChannelService) {
        this.disChannelService = disChannelService;
    }

    @Override
    public void saveStatementQuery(DisStatementset disStatementset) {
        int timenum;
        if (null == disStatementset) {
            return;
        }
        DisChannel disChannel = this.disChannelService.getChannelByCode(disStatementset.getTenantCode(), disStatementset.getChannelCode());
        if (null == disChannel) {
            this.logger.error("dis.DisStatementsetServiceImpl.saveStatementsetQuery.disChannel", (Object)(disStatementset.getChannelCode() + "=" + disStatementset.getTenantCode()));
            return;
        }
        ArrayList<DisContractlogDomain> disContractlogDomainList = new ArrayList<DisContractlogDomain>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer timetype = disStatementset.getStatementsetTimetype();
        if (null == timetype) {
            timetype = 0;
        }
        Date date = this.getSysDate();
        String timeStr = disStatementset.getStatementsetTime();
        Map oldmap = null;
        if (StringUtils.isNotBlank((String)timeStr)) {
            oldmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(timeStr, String.class, Object.class);
        }
        int n = timenum = null == disStatementset.getStatementsetTimenum() ? 0 : disStatementset.getStatementsetTimenum();
        if (0 == timenum) {
            timenum = 1440;
        }
        if (timenum <= 2) {
            timenum = 3;
        }
        if (0 == timetype) {
            String dateStr;
            String param = "";
            if (MapUtil.isNotEmpty((Map)oldmap)) {
                param = (String)oldmap.get("param");
            }
            if ((dateStr = DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd")).equals(param)) {
                this.logger.error("dis.DisStatementsetServiceImpl.saveStatementsetQuery.param", (Object)(disStatementset.getStatementsetCode() + "=" + disStatementset.getChannelCode() + "=" + disStatementset.getTenantCode()));
                return;
            }
            map.put("param", dateStr);
        } else if (1 == timetype) {
            Long start_time = MapUtil.isNotEmpty((Map)oldmap) ? Long.valueOf(String.valueOf(oldmap.get("end_time"))) : Long.valueOf(DateUtil.addMinutes((Date)date, (int)(-timenum)).getTime());
            Long end_time = DateUtil.addMinutes((Date)date, (int)-1).getTime();
            if (end_time <= start_time) {
                this.logger.error("dis.DisStatementsetServiceImpl.saveStatementsetQuery.end_time", (Object)(end_time + "=" + start_time + "=" + timenum + "=" + disStatementset.getStatementsetCode() + "=" + disStatementset.getChannelCode() + "=" + disStatementset.getTenantCode()));
                return;
            }
            map.put("start_time", start_time);
            map.put("end_time", end_time);
        } else if (2 == timetype) {
            Date start_time = MapUtil.isNotEmpty((Map)oldmap) ? DateUtil.getDateToString((String)((String)oldmap.get("end_time")), (String)"yyyy-MM-dd HH:mm:ss") : DateUtil.addMinutes((Date)date, (int)(-timenum));
            Date end_time = DateUtil.addMinutes((Date)date, (int)-1);
            if (end_time.getTime() <= start_time.getTime()) {
                this.logger.error("dis.DisStatementsetServiceImpl.saveStatementsetQuery.end_time1", (Object)(end_time + "=" + start_time + "=" + timenum + "=" + disStatementset.getStatementsetCode() + "=" + disStatementset.getChannelCode() + "=" + disStatementset.getTenantCode()));
                return;
            }
            map.put("start_time", start_time);
            map.put("end_time", end_time);
        } else {
            String end_time;
            String start_time = MapUtil.isNotEmpty((Map)oldmap) ? String.valueOf(oldmap.get("end_time")) : DateUtil.getDateString((Date)DateUtil.addMinutes((Date)date, (int)(-timenum)), (String)"yyyy-MM-dd HH:mm:ss");
            if (DateUtil.getDiffDay((String)start_time, (String)(end_time = DateUtil.getDateString((Date)DateUtil.addMinutes((Date)date, (int)-1), (String)"yyyy-MM-dd HH:mm:ss"))) <= 0L) {
                this.logger.error("dis.DisStatementsetServiceImpl.saveStatementsetQuery.end_time1", (Object)(end_time + "=" + start_time + "=" + timenum + "=" + disStatementset.getStatementsetCode() + "=" + disStatementset.getChannelCode() + "=" + disStatementset.getTenantCode()));
                return;
            }
            map.put("start_time", start_time);
            map.put("end_time", end_time);
        }
        disStatementset.setStatementsetTime(JsonUtil.buildNormalBinder().toJson(map));
        DisContractlogDomain disContractlogDomain = new DisContractlogDomain();
        disContractlogDomain.setTenantCode(disStatementset.getTenantCode());
        disContractlogDomain.setChannelApiCode(disStatementset.getStatementsetApicode());
        disContractlogDomain.setChannelCode(disChannel.getChannelCode());
        disContractlogDomain.setChannelName(disChannel.getChannelName());
        disContractlogDomain.setMemberCode(disChannel.getMemberCode());
        disContractlogDomain.setMemberName(disChannel.getMemberName());
        disContractlogDomain.setContractlogPage(BigDecimal.valueOf(disStatementset.getStatementsetNum().intValue()));
        disContractlogDomain.setContractlogParam(JsonUtil.buildNormalBinder().toJson(map));
        disContractlogDomainList.add(disContractlogDomain);
        this.updateStatementsetModel(disStatementset);
        this.disChannelsendBaseService.sendSaveContractlogBatch(disContractlogDomainList);
    }

    static {
        lock = new Object();
    }
}

