/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisDgmcnumMapper;
import com.yqbsoft.laser.service.distribution.dao.DisDgmcnumlistMapper;
import com.yqbsoft.laser.service.distribution.domain.DisDgmcnumDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgmcnumReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgmcnumlistDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgmcnumlistReDomain;
import com.yqbsoft.laser.service.distribution.model.DisDgmcnum;
import com.yqbsoft.laser.service.distribution.model.DisDgmcnumlist;
import com.yqbsoft.laser.service.distribution.service.DisDgmcnumService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DisDgmcnumServiceImpl
extends BaseServiceImpl
implements DisDgmcnumService {
    private static final String SYS_CODE = "dis.DisDgmcnumServiceImpl";
    private DisDgmcnumMapper disDgmcnumMapper;
    private DisDgmcnumlistMapper disDgmcnumlistMapper;
    private String cachekey = "DisDgmcnumList-channelCode";

    public void setDisDgmcnumMapper(DisDgmcnumMapper disDgmcnumMapper) {
        this.disDgmcnumMapper = disDgmcnumMapper;
    }

    public void setDisDgmcnumlistMapper(DisDgmcnumlistMapper disDgmcnumlistMapper) {
        this.disDgmcnumlistMapper = disDgmcnumlistMapper;
    }

    private Date getSysDate() {
        try {
            return this.disDgmcnumMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDgmcnum(DisDgmcnumDomain disDgmcnumDomain) {
        if (null == disDgmcnumDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDgmcnumDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgmcnumDefault(DisDgmcnum disDgmcnum) {
        if (null == disDgmcnum) {
            return;
        }
        if (null == disDgmcnum.getDataState()) {
            disDgmcnum.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDgmcnum.getGmtCreate()) {
            disDgmcnum.setGmtCreate(date);
        }
        disDgmcnum.setGmtModified(date);
        if (StringUtils.isBlank((String)disDgmcnum.getDgmcnumCode())) {
            disDgmcnum.setDgmcnumCode(this.getNo(null, "DisDgmcnum", "disDgmcnum", disDgmcnum.getTenantCode()));
        }
    }

    private int getDgmcnumMaxCode() {
        int code = 0;
        try {
            return this.disDgmcnumMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.getDgmcnumMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgmcnumUpdataDefault(DisDgmcnum disDgmcnum) {
        if (null == disDgmcnum) {
            return;
        }
        disDgmcnum.setGmtModified(this.getSysDate());
    }

    private void saveDgmcnumModel(DisDgmcnum disDgmcnum) throws ApiException {
        if (null == disDgmcnum) {
            return;
        }
        try {
            this.disDgmcnumMapper.insert(disDgmcnum);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.saveDgmcnumModel.ex", (Throwable)e);
        }
    }

    private void saveDgmcnumBatchModel(List<DisDgmcnum> disDgmcnumlist) throws ApiException {
        if (null == disDgmcnumlist || disDgmcnumlist.isEmpty()) {
            return;
        }
        try {
            this.disDgmcnumMapper.insertBatch(disDgmcnumlist);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.saveDgmcnumBatchModel.ex", (Throwable)e);
        }
    }

    private DisDgmcnum getDgmcnumModelById(Integer dgmcnumId) {
        if (null == dgmcnumId) {
            return null;
        }
        try {
            return this.disDgmcnumMapper.selectByPrimaryKey(dgmcnumId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.getDgmcnumModelById", (Throwable)e);
            return null;
        }
    }

    private DisDgmcnum getDgmcnumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDgmcnumMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.getDgmcnumModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgmcnumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgmcnumMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.delDgmcnumModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.delDgmcnumModelByCode.num");
        }
    }

    private void deleteDgmcnumModel(Integer dgmcnumId) throws ApiException {
        if (null == dgmcnumId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgmcnumMapper.deleteByPrimaryKey(dgmcnumId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.deleteDgmcnumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.deleteDgmcnumModel.num");
        }
    }

    private void updateDgmcnumModel(DisDgmcnum disDgmcnum) throws ApiException {
        if (null == disDgmcnum) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgmcnumMapper.updateByPrimaryKey(disDgmcnum);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateDgmcnumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateDgmcnumModel.num");
        }
    }

    private void updateStateDgmcnumModel(Integer dgmcnumId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dgmcnumId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgmcnumId", dgmcnumId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgmcnumMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateStateDgmcnumModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateStateDgmcnumModel.null");
        }
    }

    private void updateStateDgmcnumModelByCode(String tenantCode, String dgmcnumCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dgmcnumCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgmcnumCode", dgmcnumCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgmcnumMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateStateDgmcnumModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateStateDgmcnumModelByCode.null");
        }
    }

    private DisDgmcnum makeDgmcnum(DisDgmcnumDomain disDgmcnumDomain, DisDgmcnum disDgmcnum) {
        if (null == disDgmcnumDomain) {
            return null;
        }
        if (null == disDgmcnum) {
            disDgmcnum = new DisDgmcnum();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDgmcnum, (Object)disDgmcnumDomain);
            return disDgmcnum;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.makeDgmcnum", (Throwable)e);
            return null;
        }
    }

    private DisDgmcnumReDomain makeDisDgmcnumReDomain(DisDgmcnum disDgmcnum) {
        if (null == disDgmcnum) {
            return null;
        }
        DisDgmcnumReDomain disDgmcnumReDomain = new DisDgmcnumReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgmcnumReDomain, (Object)disDgmcnum);
            return disDgmcnumReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.makeDisDgmcnumReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDgmcnum> queryDgmcnumModelPage(Map<String, Object> parammap) {
        try {
            return this.disDgmcnumMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.queryDgmcnumModel", (Throwable)e);
            return null;
        }
    }

    private int countDgmcnum(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDgmcnumMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.countDgmcnum", (Throwable)e);
        }
        return i;
    }

    private DisDgmcnum createDisDgmcnum(DisDgmcnumDomain disDgmcnumDomain) {
        String msg = this.checkDgmcnum(disDgmcnumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.saveDgmcnum.checkDgmcnum", msg);
        }
        DisDgmcnum disDgmcnum = this.makeDgmcnum(disDgmcnumDomain, null);
        this.setDgmcnumDefault(disDgmcnum);
        return disDgmcnum;
    }

    private String checkDgmcnumlist(DisDgmcnumlistDomain disDgmcnumlistDomain) {
        if (null == disDgmcnumlistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDgmcnumlistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgmcnumlistDefault(DisDgmcnumlist disDgmcnumlist) {
        if (null == disDgmcnumlist) {
            return;
        }
        if (null == disDgmcnumlist.getDataState()) {
            disDgmcnumlist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDgmcnumlist.getGmtCreate()) {
            disDgmcnumlist.setGmtCreate(date);
        }
        disDgmcnumlist.setGmtModified(date);
        if (StringUtils.isBlank((String)disDgmcnumlist.getDgmcnumlistCode())) {
            disDgmcnumlist.setDgmcnumlistCode(this.getNo(null, "DisDgmcnumlist", "disDgmcnumlist", disDgmcnumlist.getTenantCode()));
        }
    }

    private int getDgmcnumlistMaxCode() {
        int code = 0;
        try {
            return this.disDgmcnumlistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.getDgmcnumlistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgmcnumlistUpdataDefault(DisDgmcnumlist disDgmcnumlist) {
        if (null == disDgmcnumlist) {
            return;
        }
        disDgmcnumlist.setGmtModified(this.getSysDate());
    }

    private void saveDgmcnumlistModel(DisDgmcnumlist disDgmcnumlist) throws ApiException {
        if (null == disDgmcnumlist) {
            return;
        }
        try {
            this.disDgmcnumlistMapper.insert(disDgmcnumlist);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.saveDgmcnumlistModel.ex", (Throwable)e);
        }
    }

    private void saveDgmcnumlistBatchModel(List<DisDgmcnumlist> disDgmcnumlistList) throws ApiException {
        if (null == disDgmcnumlistList || disDgmcnumlistList.isEmpty()) {
            return;
        }
        try {
            this.disDgmcnumlistMapper.insertBatch(disDgmcnumlistList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.saveDgmcnumlistBatchModel.ex", (Throwable)e);
        }
    }

    private DisDgmcnumlist getDgmcnumlistModelById(Integer dgmcnumlistId) {
        if (null == dgmcnumlistId) {
            return null;
        }
        try {
            return this.disDgmcnumlistMapper.selectByPrimaryKey(dgmcnumlistId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.getDgmcnumlistModelById", (Throwable)e);
            return null;
        }
    }

    private DisDgmcnumlist getDgmcnumlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDgmcnumlistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.getDgmcnumlistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgmcnumlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgmcnumlistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.delDgmcnumlistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.delDgmcnumlistModelByCode.num");
        }
    }

    private void deleteDgmcnumlistModel(Integer dgmcnumlistId) throws ApiException {
        if (null == dgmcnumlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgmcnumlistMapper.deleteByPrimaryKey(dgmcnumlistId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.deleteDgmcnumlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.deleteDgmcnumlistModel.num");
        }
    }

    private void updateDgmcnumlistModel(DisDgmcnumlist disDgmcnumlist) throws ApiException {
        if (null == disDgmcnumlist) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgmcnumlistMapper.updateByPrimaryKey(disDgmcnumlist);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateDgmcnumlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateDgmcnumlistModel.num");
        }
    }

    private void updateStateDgmcnumlistModel(Integer dgmcnumlistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dgmcnumlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgmcnumlistId", dgmcnumlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgmcnumlistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateStateDgmcnumlistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateStateDgmcnumlistModel.null");
        }
    }

    private void updateStateDgmcnumlistModelByCode(String tenantCode, String dgmcnumlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dgmcnumlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgmcnumlistCode", dgmcnumlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgmcnumlistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateStateDgmcnumlistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateStateDgmcnumlistModelByCode.null");
        }
    }

    private DisDgmcnumlist makeDgmcnumlist(DisDgmcnumlistDomain disDgmcnumlistDomain, DisDgmcnumlist disDgmcnumlist) {
        if (null == disDgmcnumlistDomain) {
            return null;
        }
        if (null == disDgmcnumlist) {
            disDgmcnumlist = new DisDgmcnumlist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDgmcnumlist, (Object)disDgmcnumlistDomain);
            return disDgmcnumlist;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.makeDgmcnumlist", (Throwable)e);
            return null;
        }
    }

    private DisDgmcnumlistReDomain makeDisDgmcnumlistReDomain(DisDgmcnumlist disDgmcnumlist) {
        if (null == disDgmcnumlist) {
            return null;
        }
        DisDgmcnumlistReDomain disDgmcnumlistReDomain = new DisDgmcnumlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgmcnumlistReDomain, (Object)disDgmcnumlist);
            return disDgmcnumlistReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.makeDisDgmcnumlistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDgmcnumlist> queryDgmcnumlistModelPage(Map<String, Object> parammap) {
        try {
            return this.disDgmcnumlistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.queryDgmcnumlistModel", (Throwable)e);
            return null;
        }
    }

    private int countDgmcnumlist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDgmcnumlistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgmcnumServiceImpl.countDgmcnumlist", (Throwable)e);
        }
        return i;
    }

    private DisDgmcnumlist createDisDgmcnumlist(DisDgmcnumlistDomain disDgmcnumlistDomain) {
        String msg = this.checkDgmcnumlist(disDgmcnumlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.saveDgmcnumlist.checkDgmcnumlist", msg);
        }
        DisDgmcnumlist disDgmcnumlist = this.makeDgmcnumlist(disDgmcnumlistDomain, null);
        this.setDgmcnumlistDefault(disDgmcnumlist);
        return disDgmcnumlist;
    }

    private void delModelByGnumCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.disDgmcnumlistMapper.delByGnumCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.delModelByGnumCode.ex", (Throwable)e);
        }
    }

    @Override
    public String saveDgmcnum(DisDgmcnumDomain disDgmcnumDomain) throws ApiException {
        if (null != disDgmcnumDomain.getDgmcnumId()) {
            if (StringUtils.isBlank((String)disDgmcnumDomain.getDgmcnumCode())) {
                DisDgmcnum oldDisDgmcnum = this.getDgmcnumModelById(disDgmcnumDomain.getDgmcnumId());
                if (null == oldDisDgmcnum) {
                    throw new ApiException("dis.DisDgmcnumServiceImpl.saveDgmcnum.null", "\u6570\u636e\u4e3a\u7a7a");
                }
                disDgmcnumDomain.setDgmcnumCode(oldDisDgmcnum.getDgmcnumCode());
            }
            this.deleteDgmcnum(disDgmcnumDomain.getDgmcnumId());
        }
        DisDgmcnum disDgmcnum = this.createDisDgmcnum(disDgmcnumDomain);
        this.saveDgmcnumModel(disDgmcnum);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgmcnumCode", disDgmcnum.getDgmcnumCode());
        map.put("tenantCode", disDgmcnum.getTenantCode());
        this.delModelByGnumCode(map);
        if (ListUtil.isNotEmpty(disDgmcnumDomain.getDisDgmcnumlistDomainList())) {
            this.saveDgmcnumListDomain(disDgmcnumDomain.getDisDgmcnumlistDomainList(), disDgmcnum);
        }
        this.updateDgmcnumCache(disDgmcnum);
        return disDgmcnum.getDgmcnumCode();
    }

    private void saveDgmcnumListDomain(List<DisDgmcnumlistDomain> disDgmcnumlistDomainList, DisDgmcnum disDgmcnum) {
        if (ListUtil.isEmpty(disDgmcnumlistDomainList) || null == disDgmcnum) {
            return;
        }
        for (DisDgmcnumlistDomain disDgmcnumListDomain : disDgmcnumlistDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)disDgmcnumListDomain, (Object)disDgmcnum);
            }
            catch (Exception e) {}
        }
        this.saveDgmcnumlistBatch(disDgmcnumlistDomainList);
    }

    @Override
    public String saveDgmcnumBatch(List<DisDgmcnumDomain> disDgmcnumDomainList) throws ApiException {
        if (null == disDgmcnumDomainList || disDgmcnumDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDgmcnum> disDgmcnumlist = new ArrayList<DisDgmcnum>();
        String code = "";
        for (DisDgmcnumDomain disDgmcnumDomain : disDgmcnumDomainList) {
            DisDgmcnum disDgmcnum = this.createDisDgmcnum(disDgmcnumDomain);
            code = disDgmcnum.getDgmcnumCode();
            disDgmcnumlist.add(disDgmcnum);
        }
        this.saveDgmcnumBatchModel(disDgmcnumlist);
        return code;
    }

    @Override
    public void updateDgmcnumState(Integer dgmcnumId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dgmcnumId) {
            return;
        }
        this.updateStateDgmcnumModel(dgmcnumId, dataState, oldDataState, map);
        if (dataState == 0 && oldDataState != 0) {
            DisDgmcnum disDgmcnum = this.getDgmcnumModelById(dgmcnumId);
            this.updateDgmcnumCache(disDgmcnum);
        } else if (oldDataState == 0 && dataState != 0) {
            DisDgmcnum disDgmcnum = this.getDgmcnumModelById(dgmcnumId);
            this.deleteDgmcnumCache(disDgmcnum);
        }
    }

    @Override
    public void updateDgmcnumStateByCode(String tenantCode, String dgmcnumCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dgmcnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDgmcnumModelByCode(tenantCode, dgmcnumCode, dataState, oldDataState, map);
        if (dataState == 0 && oldDataState != 0) {
            DisDgmcnum disDgmcnum = this.getDgmcnumModelByCode(this.getQueryMapParam("dgmcnumCode,tenantCode", new Object[]{dgmcnumCode, tenantCode}));
            this.updateDgmcnumCache(disDgmcnum);
        } else if (oldDataState == 0 && dataState != 0) {
            DisDgmcnum disDgmcnum = this.getDgmcnumModelByCode(this.getQueryMapParam("dgmcnumCode,tenantCode", new Object[]{dgmcnumCode, tenantCode}));
            this.deleteDgmcnumCache(disDgmcnum);
        }
    }

    @Override
    public void updateDgmcnum(DisDgmcnumDomain disDgmcnumDomain) throws ApiException {
        String msg = this.checkDgmcnum(disDgmcnumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateDgmcnum.checkDgmcnum", msg);
        }
        DisDgmcnum oldDisDgmcnum = this.getDgmcnumModelById(disDgmcnumDomain.getDgmcnumId());
        if (null == oldDisDgmcnum) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateDgmcnum.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDgmcnum disDgmcnum = this.makeDgmcnum(disDgmcnumDomain, oldDisDgmcnum);
        this.setDgmcnumUpdataDefault(disDgmcnum);
        this.updateDgmcnumModel(disDgmcnum);
        oldDisDgmcnum = this.getDgmcnumModelById(disDgmcnumDomain.getDgmcnumId());
        if (null == oldDisDgmcnum) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateDgmcnum.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateDgmcnumlistDomain(disDgmcnumDomain.getDisDgmcnumlistDomainList(), oldDisDgmcnum);
        this.updateDgmcnumCache(oldDisDgmcnum);
    }

    private void updateDgmcnumlistDomain(List<DisDgmcnumlistDomain> disDgmcnumlistDomainList, DisDgmcnum disDgmcnum) {
        if (ListUtil.isEmpty(disDgmcnumlistDomainList) || null == disDgmcnum) {
            return;
        }
        this.delModelByGnumCode(this.getQueryMapParam("dgmcnumCode,tenantCode", new Object[]{disDgmcnum.getDgmcnumCode(), disDgmcnum.getTenantCode()}));
        this.saveDgmcnumListDomain(disDgmcnumlistDomainList, disDgmcnum);
    }

    @Override
    public DisDgmcnum getDgmcnum(Integer dgmcnumId) {
        if (null == dgmcnumId) {
            return null;
        }
        return this.getDgmcnumModelById(dgmcnumId);
    }

    @Override
    public void deleteDgmcnum(Integer dgmcnumId) throws ApiException {
        if (null == dgmcnumId) {
            return;
        }
        DisDgmcnum disDgmcnum = this.getDgmcnumModelById(dgmcnumId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgmcnumCode", disDgmcnum.getDgmcnumCode());
        map.put("tenantCode", disDgmcnum.getTenantCode());
        List<DisDgmcnumlist> disDgmcnumlists = this.queryDgmcnumlistModelPage(map);
        if (ListUtil.isNotEmpty(disDgmcnumlists)) {
            for (DisDgmcnumlist disDgmcnumlist : disDgmcnumlists) {
                this.deleteDgmcnumlistCache(disDgmcnumlist);
                this.deleteDgmcnumlist(disDgmcnumlist.getDgmcnumlistId());
            }
        }
        this.deleteDgmcnumCache(disDgmcnum);
        this.deleteDgmcnumModel(dgmcnumId);
        this.delModelByGnumCode(map);
    }

    @Override
    public QueryResult<DisDgmcnum> queryDgmcnumPage(Map<String, Object> map) {
        List<DisDgmcnum> disDgmcnumlist = this.queryDgmcnumModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgmcnum(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDgmcnumlist);
        return queryResult;
    }

    @Override
    public DisDgmcnum getDgmcnumByCode(String tenantCode, String dgmcnumCode) throws ApiException {
        if (StringUtils.isBlank((String)dgmcnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgmcnumCode", dgmcnumCode);
        return this.getDgmcnumModelByCode(map);
    }

    @Override
    public void deleteDgmcnumByCode(String tenantCode, String dgmcnumCode) throws ApiException {
        if (StringUtils.isBlank((String)dgmcnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgmcnumCode", dgmcnumCode);
        DisDgmcnum disDgmcnum = this.getDgmcnumModelByCode(map);
        this.delDgmcnumModelByCode(map);
        this.deleteDgmcnumCache(disDgmcnum);
    }

    @Override
    public String saveDgmcnumlist(DisDgmcnumlistDomain disDgmcnumlistDomain) throws ApiException {
        DisDgmcnumlist disDgmcnumlist = this.createDisDgmcnumlist(disDgmcnumlistDomain);
        this.saveDgmcnumlistModel(disDgmcnumlist);
        this.updateDgmcnumlistCache(disDgmcnumlist);
        return disDgmcnumlist.getDgmcnumlistCode();
    }

    @Override
    public String saveDgmcnumlistBatch(List<DisDgmcnumlistDomain> disDgmcnumlistDomainList) throws ApiException {
        if (null == disDgmcnumlistDomainList || disDgmcnumlistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDgmcnumlist> disDgmcnumlistList = new ArrayList<DisDgmcnumlist>();
        String code = "";
        for (DisDgmcnumlistDomain disDgmcnumlistDomain : disDgmcnumlistDomainList) {
            DisDgmcnumlist disDgmcnumlist = this.createDisDgmcnumlist(disDgmcnumlistDomain);
            code = disDgmcnumlist.getDgmcnumlistCode();
            disDgmcnumlistList.add(disDgmcnumlist);
        }
        this.saveDgmcnumlistBatchModel(disDgmcnumlistList);
        return code;
    }

    @Override
    public void updateDgmcnumlistState(Integer dgmcnumlistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dgmcnumlistId) {
            return;
        }
        this.updateStateDgmcnumlistModel(dgmcnumlistId, dataState, oldDataState, map);
    }

    @Override
    public void updateDgmcnumlistStateByCode(String tenantCode, String dgmcnumlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dgmcnumlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDgmcnumlistModelByCode(tenantCode, dgmcnumlistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateDgmcnumlist(DisDgmcnumlistDomain disDgmcnumlistDomain) throws ApiException {
        String msg = this.checkDgmcnumlist(disDgmcnumlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateDgmcnumlist.checkDgmcnumlist", msg);
        }
        DisDgmcnumlist oldDisDgmcnumlist = this.getDgmcnumlistModelById(disDgmcnumlistDomain.getDgmcnumlistId());
        if (null == oldDisDgmcnumlist) {
            throw new ApiException("dis.DisDgmcnumServiceImpl.updateDgmcnumlist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDgmcnumlist disDgmcnumlist = this.makeDgmcnumlist(disDgmcnumlistDomain, oldDisDgmcnumlist);
        this.setDgmcnumlistUpdataDefault(disDgmcnumlist);
        this.updateDgmcnumlistModel(disDgmcnumlist);
        this.updateDgmcnumlistCache(disDgmcnumlist);
    }

    @Override
    public DisDgmcnumlist getDgmcnumlist(Integer dgmcnumlistId) {
        if (null == dgmcnumlistId) {
            return null;
        }
        return this.getDgmcnumlistModelById(dgmcnumlistId);
    }

    @Override
    public void deleteDgmcnumlist(Integer dgmcnumlistId) throws ApiException {
        if (null == dgmcnumlistId) {
            return;
        }
        DisDgmcnumlist disDgmcnumlist = this.getDgmcnumlistModelById(dgmcnumlistId);
        this.deleteDgmcnumlistModel(dgmcnumlistId);
        this.deleteDgmcnumlistCache(disDgmcnumlist);
    }

    @Override
    public QueryResult<DisDgmcnumlist> queryDgmcnumlistPage(Map<String, Object> map) {
        List<DisDgmcnumlist> disDgmcnumlistList = this.queryDgmcnumlistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgmcnumlist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDgmcnumlistList);
        return queryResult;
    }

    @Override
    public DisDgmcnumlist getDgmcnumlistByCode(String tenantCode, String dgmcnumlistCode) throws ApiException {
        if (StringUtils.isBlank((String)dgmcnumlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgmcnumlistCode", dgmcnumlistCode);
        return this.getDgmcnumlistModelByCode(map);
    }

    @Override
    public void deleteDgmcnumlistByCode(String tenantCode, String dgmcnumlistCode) throws ApiException {
        if (StringUtils.isBlank((String)dgmcnumlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgmcnumlistCode", dgmcnumlistCode);
        DisDgmcnumlist disDgmcnumlist = this.getDgmcnumlistModelByCode(map);
        this.delDgmcnumlistModelByCode(map);
        this.deleteDgmcnumlistCache(disDgmcnumlist);
    }

    private void deleteDgmcnumCache(DisDgmcnum disDgmcnum) {
        String json;
        if (null == disDgmcnum) {
            return;
        }
        if (StringUtils.isBlank((String)disDgmcnum.getGoodsNo())) {
            disDgmcnum.setGoodsNo("");
        }
        if (StringUtils.isBlank((String)disDgmcnum.getSkuNo())) {
            disDgmcnum.setSkuNo("");
        }
        if (StringUtils.isBlank((String)disDgmcnum.getChannelCode())) {
            disDgmcnum.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getMap((String)this.cachekey, (String)(disDgmcnum.getChannelCode() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnum.getTenantCode()))))) {
            return;
        }
        List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgmcnumDomain.class);
        ArrayList<DisDgmcnumDomain> dlist2 = new ArrayList<DisDgmcnumDomain>();
        for (DisDgmcnumDomain disDgmcnumDomain2 : dlist) {
            if (disDgmcnumDomain2.getDgmcnumCode().equals(disDgmcnum.getDgmcnumCode())) continue;
            dlist2.add(disDgmcnumDomain2);
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(disDgmcnum.getChannelCode() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnum.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(dlist2));
    }

    private void deleteDgmcnumlistCache(DisDgmcnumlist disDgmcnumlist) {
        String json;
        if (null == disDgmcnumlist) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", disDgmcnumlist.getTenantCode());
        map.put("dgmcnumCode", disDgmcnumlist.getDgmcnumCode());
        DisDgmcnum disDgmcnum = this.getDgmcnumModelByCode(map);
        if (StringUtils.isBlank((String)disDgmcnum.getGoodsNo())) {
            disDgmcnum.setGoodsNo("");
        }
        if (StringUtils.isBlank((String)disDgmcnum.getSkuNo())) {
            disDgmcnum.setSkuNo("");
        }
        if (StringUtils.isBlank((String)disDgmcnum.getChannelCode())) {
            disDgmcnum.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getMap((String)this.cachekey, (String)(disDgmcnum.getChannelCode() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnum.getTenantCode()))))) {
            return;
        }
        List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgmcnumDomain.class);
        ArrayList<DisDgmcnumDomain> dlist1 = new ArrayList<DisDgmcnumDomain>();
        for (DisDgmcnumDomain disDgmcnumDomain2 : dlist) {
            if (disDgmcnumDomain2.getDgmcnumCode().equals(disDgmcnum.getDgmcnumCode())) {
                ArrayList<DisDgmcnumlist> configcacheList = new ArrayList<DisDgmcnumlist>();
                disDgmcnumDomain2.setDisDgmcnumlistList(configcacheList);
                for (DisDgmcnumlist disDgmcnumlist2 : disDgmcnumDomain2.getDisDgmcnumlistList()) {
                    if (disDgmcnumlist2.getDgmcnumlistCode().equals(disDgmcnumlist.getDgmcnumlistCode())) continue;
                    configcacheList.add(disDgmcnumlist2);
                }
            }
            dlist1.add(disDgmcnumDomain2);
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(disDgmcnum.getChannelCode() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnumlist.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(dlist1));
    }

    private void updateDgmcnumCache(DisDgmcnum disDgmcnum) {
        if (null == disDgmcnum) {
            return;
        }
        if (StringUtils.isBlank((String)disDgmcnum.getChannelCode())) {
            disDgmcnum.setChannelCode("all");
        }
        DisDgmcnumDomain disDgmcnumDomain = this.makeDisDgmcnumDomain(disDgmcnum);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dgmcnumCode", disDgmcnum.getDgmcnumCode());
        confparammap.put("tenantCode", disDgmcnum.getTenantCode());
        if (StringUtils.isBlank((String)disDgmcnum.getGoodsNo())) {
            disDgmcnum.setGoodsNo("");
        }
        if (StringUtils.isBlank((String)disDgmcnum.getSkuNo())) {
            disDgmcnum.setSkuNo("");
        }
        List<DisDgmcnumlist> upcachelist = this.queryDgmcnumlistModelPage(confparammap);
        disDgmcnumDomain.setDisDgmcnumlistList(upcachelist);
        String json = DisUtil.getMap((String)this.cachekey, (String)(disDgmcnum.getChannelCode() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnum.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<DisDgmcnumDomain> dlist = new ArrayList<DisDgmcnumDomain>();
            dlist.add(disDgmcnumDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(disDgmcnum.getChannelCode() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnum.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(dlist));
        } else {
            List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgmcnumDomain.class);
            ArrayList<DisDgmcnumDomain> cachedlist = new ArrayList<DisDgmcnumDomain>();
            for (DisDgmcnumDomain disDgmcnumDomain2 : dlist) {
                if (disDgmcnumDomain2.getDgmcnumCode().equals(disDgmcnum.getDgmcnumCode())) {
                    cachedlist.add(disDgmcnumDomain);
                    continue;
                }
                cachedlist.add(disDgmcnumDomain2);
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(disDgmcnum.getChannelCode() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnum.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(cachedlist));
        }
    }

    private void updateDgmcnumlistCache(DisDgmcnumlist disDgmcnumlist) {
        if (null == disDgmcnumlist) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", disDgmcnumlist.getTenantCode());
        map.put("dgmcnumCode", disDgmcnumlist.getDgmcnumCode());
        DisDgmcnum disDgmcnum = this.getDgmcnumModelByCode(map);
        if (StringUtils.isBlank((String)disDgmcnum.getChannelCode())) {
            disDgmcnum.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)disDgmcnum.getGoodsNo())) {
            disDgmcnum.setGoodsNo("");
        }
        if (StringUtils.isBlank((String)disDgmcnum.getSkuNo())) {
            disDgmcnum.setSkuNo("");
        }
        DisDgmcnumDomain disDgmcnumDomain = this.makeDisDgmcnumDomain(disDgmcnum);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dgmcnumCode", disDgmcnum.getDgmcnumCode());
        confparammap.put("tenantCode", disDgmcnum.getTenantCode());
        List<DisDgmcnumlist> upcachelist = this.queryDgmcnumlistModelPage(confparammap);
        disDgmcnumDomain.setDisDgmcnumlistList(upcachelist);
        String json = DisUtil.getMap((String)this.cachekey, (String)(disDgmcnum.getChannelCode() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnum.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<DisDgmcnumDomain> dlist = new ArrayList<DisDgmcnumDomain>();
            dlist.add(disDgmcnumDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(disDgmcnum.getChannelCode() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnumlist.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(dlist));
        } else {
            List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgmcnumDomain.class);
            for (DisDgmcnumDomain disDgmcnumDomain2 : dlist) {
                if (!disDgmcnumDomain2.getDgmcnumCode().equals(disDgmcnum.getDgmcnumCode())) continue;
                ArrayList<DisDgmcnumlist> cachedlist = new ArrayList<DisDgmcnumlist>();
                for (DisDgmcnumlist disDgmcnumlist2 : disDgmcnumDomain2.getDisDgmcnumlistList()) {
                    if (disDgmcnumlist2.getDgmcnumlistCode().equals(disDgmcnumlist.getDgmcnumlistCode())) {
                        cachedlist.add(disDgmcnumlist);
                        continue;
                    }
                    cachedlist.add(disDgmcnumlist2);
                }
                disDgmcnumDomain2.setDisDgmcnumlistList(cachedlist);
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(disDgmcnum.getChannelCode() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnumlist.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)dlist));
        }
    }

    @Override
    public void queryDgmcnumLoadCache() {
        this.logger.info("DisDgmcnumService.queryDgmcnumLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<DisDgmcnum> disDgmcnumlist = this.queryDgmcnumModelPage(parammap);
        if (null == disDgmcnumlist || disDgmcnumlist.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("DisDgmcnumService.queryDgmcnumLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap<String, ArrayList<DisDgmcnumDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<DisDgmcnumDomain>>();
        for (DisDgmcnum disDgmcnum : disDgmcnumlist) {
            if (StringUtils.isBlank((String)disDgmcnum.getGoodsNo())) {
                disDgmcnum.setGoodsNo("");
            }
            if (StringUtils.isBlank((String)disDgmcnum.getSkuNo())) {
                disDgmcnum.setSkuNo("");
            }
            if (StringUtils.isBlank((String)disDgmcnum.getChannelCode())) {
                disDgmcnum.setChannelCode("all");
            }
            DisDgmcnumDomain disDgmcnumDomain = this.makeDisDgmcnumDomain(disDgmcnum);
            confparammap.put("dgmcnumCode", disDgmcnum.getDgmcnumCode());
            confparammap.put("tenantCode", disDgmcnum.getTenantCode());
            List<DisDgmcnumlist> disDgmcnumlistList = this.queryDgmcnumlistModelPage(confparammap);
            disDgmcnumDomain.setDisDgmcnumlistList(disDgmcnumlistList);
            ArrayList<DisDgmcnumDomain> dlist = (ArrayList<DisDgmcnumDomain>)ddListMap.get(disDgmcnum.getChannelCode() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnum.getTenantCode());
            if (null == dlist) {
                dlist = new ArrayList<DisDgmcnumDomain>();
                ddListMap.put(disDgmcnum.getChannelCode() + "-" + disDgmcnum.getGoodsNo() + "-" + disDgmcnum.getSkuNo() + "-" + disDgmcnum.getTenantCode(), dlist);
            }
            dlist.add(disDgmcnumDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(ddListMap.get(key)));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.info("DisDgmcnumService.queryDgmcnumLoadCache", (Object)"===========add-end==========");
    }

    private DisDgmcnumDomain makeDisDgmcnumDomain(DisDgmcnum disDgmcnum) {
        if (null == disDgmcnum) {
            return null;
        }
        DisDgmcnumDomain disDgmcnumDomain = new DisDgmcnumDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgmcnumDomain, (Object)disDgmcnum);
            return disDgmcnumDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

