/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisDictionaryMapper;
import com.yqbsoft.laser.service.distribution.domain.DisDictionaryDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDictionaryReDomain;
import com.yqbsoft.laser.service.distribution.model.DisDictionary;
import com.yqbsoft.laser.service.distribution.service.DisDictionaryService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DisDictionaryServiceImpl
extends BaseServiceImpl
implements DisDictionaryService {
    private static final String SYS_CODE = "dis.DisDictionaryServiceImpl";
    private DisDictionaryMapper disDictionaryMapper;
    private String cachekey = "DisDictionary-channelCode";
    private String cachediskey = "DisDictionaryDis-channelCode";

    public void setDisDictionaryMapper(DisDictionaryMapper disDictionaryMapper) {
        this.disDictionaryMapper = disDictionaryMapper;
    }

    private Date getSysDate() {
        try {
            return this.disDictionaryMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDictionaryServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDictionary(DisDictionaryDomain disDictionaryDomain) {
        if (null == disDictionaryDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDictionaryDomain.getDictionaryBvalue())) {
            msg = msg + "DictionaryBvalue\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disDictionaryDomain.getDictionaryValue())) {
            msg = msg + "DictionaryValue\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disDictionaryDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDictionaryDefault(DisDictionary disDictionary) {
        if (null == disDictionary) {
            return;
        }
        if (null == disDictionary.getDataState()) {
            disDictionary.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDictionary.getGmtCreate()) {
            disDictionary.setGmtCreate(date);
        }
        disDictionary.setGmtModified(date);
        if (StringUtils.isBlank((String)disDictionary.getDictionaryCode())) {
            disDictionary.setDictionaryCode(this.createUUIDString());
        }
    }

    private int getDictionaryMaxCode() {
        int code = 0;
        try {
            return this.disDictionaryMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDictionaryServiceImpl.getDictionaryMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDictionaryUpdataDefault(DisDictionary disDictionary) {
        if (null == disDictionary) {
            return;
        }
        disDictionary.setGmtModified(this.getSysDate());
    }

    private void saveDictionaryModel(DisDictionary disDictionary) throws ApiException {
        if (null == disDictionary) {
            return;
        }
        try {
            this.disDictionaryMapper.insert(disDictionary);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDictionaryServiceImpl.saveDictionaryModel.ex", (Throwable)e);
        }
    }

    private void saveDictionaryBatchModel(List<DisDictionary> disDictionaryList) throws ApiException {
        if (null == disDictionaryList || disDictionaryList.isEmpty()) {
            return;
        }
        try {
            this.disDictionaryMapper.insertBatch(disDictionaryList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDictionaryServiceImpl.saveDictionaryBatchModel.ex", (Throwable)e);
        }
    }

    private DisDictionary getDictionaryModelById(Integer dictionaryId) {
        if (null == dictionaryId) {
            return null;
        }
        try {
            return this.disDictionaryMapper.selectByPrimaryKey(dictionaryId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDictionaryServiceImpl.getDictionaryModelById", (Throwable)e);
            return null;
        }
    }

    private DisDictionary getDictionaryModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDictionaryMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDictionaryServiceImpl.getDictionaryModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDictionaryModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDictionaryMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDictionaryServiceImpl.delDictionaryModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDictionaryServiceImpl.delDictionaryModelByCode.num");
        }
    }

    private void deleteDictionaryModel(Integer dictionaryId) throws ApiException {
        if (null == dictionaryId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDictionaryMapper.deleteByPrimaryKey(dictionaryId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDictionaryServiceImpl.deleteDictionaryModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDictionaryServiceImpl.deleteDictionaryModel.num");
        }
    }

    private void updateDictionaryModel(DisDictionary disDictionary) throws ApiException {
        if (null == disDictionary) {
            return;
        }
        int i = 0;
        try {
            i = this.disDictionaryMapper.updateByPrimaryKeySelective(disDictionary);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDictionaryServiceImpl.updateDictionaryModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDictionaryServiceImpl.updateDictionaryModel.num");
        }
    }

    private void updateStateDictionaryModel(Integer dictionaryId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == dictionaryId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dictionaryId", dictionaryId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDictionaryMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDictionaryServiceImpl.updateStateDictionaryModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDictionaryServiceImpl.updateStateDictionaryModel.null");
        }
    }

    private void updateStateDictionaryModelByCode(String tenantCode, String dictionaryCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)dictionaryCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dictionaryCode", dictionaryCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDictionaryMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDictionaryServiceImpl.updateStateDictionaryModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDictionaryServiceImpl.updateStateDictionaryModelByCode.null");
        }
    }

    private DisDictionary makeDictionary(DisDictionaryDomain disDictionaryDomain, DisDictionary disDictionary) {
        if (null == disDictionaryDomain) {
            return null;
        }
        if (null == disDictionary) {
            disDictionary = new DisDictionary();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDictionary, (Object)disDictionaryDomain);
            return disDictionary;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDictionaryServiceImpl.makeDictionary", (Throwable)e);
            return null;
        }
    }

    private DisDictionaryReDomain makeDisDictionaryReDomain(DisDictionary disDictionary) {
        if (null == disDictionary) {
            return null;
        }
        DisDictionaryReDomain disDictionaryReDomain = new DisDictionaryReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDictionaryReDomain, (Object)disDictionary);
            return disDictionaryReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDictionaryServiceImpl.makeDisDictionaryReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDictionary> queryDictionaryModelPage(Map<String, Object> parammap) {
        try {
            return this.disDictionaryMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDictionaryServiceImpl.queryDictionaryModel", (Throwable)e);
            return null;
        }
    }

    private int countDictionary(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDictionaryMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDictionaryServiceImpl.countDictionary", (Throwable)e);
        }
        return i;
    }

    private DisDictionary createDisDictionary(DisDictionaryDomain disDictionaryDomain) {
        String msg = this.checkDictionary(disDictionaryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDictionaryServiceImpl.saveDictionary.checkDictionary", msg);
        }
        DisDictionary disDictionary = this.makeDictionary(disDictionaryDomain, null);
        this.setDictionaryDefault(disDictionary);
        return disDictionary;
    }

    @Override
    public String saveDictionary(DisDictionaryDomain disDictionaryDomain) throws ApiException {
        if (null == disDictionaryDomain || StringUtils.isBlank((String)disDictionaryDomain.getTenantCode()) || StringUtils.isBlank((String)disDictionaryDomain.getChannelCode()) || StringUtils.isBlank((String)disDictionaryDomain.getDictionaryValue()) || StringUtils.isBlank((String)disDictionaryDomain.getDictionaryDisgoods()) || StringUtils.isBlank((String)disDictionaryDomain.getDictionaryGoods()) || StringUtils.isBlank((String)disDictionaryDomain.getDictionaryType())) {
            throw new ApiException("dis.DisDictionaryServiceImpl.saveDictionary.disDictionaryDomain");
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", disDictionaryDomain.getTenantCode());
        parammap.put("channelCode", disDictionaryDomain.getChannelCode());
        parammap.put("dictionaryValue", disDictionaryDomain.getDictionaryValue());
        parammap.put("dictionaryDisgoods", disDictionaryDomain.getDictionaryDisgoods());
        parammap.put("dictionaryGoods", disDictionaryDomain.getDictionaryGoods());
        parammap.put("dictionaryType", disDictionaryDomain.getDictionaryType());
        List<DisDictionary> disDictionaryList = this.queryDictionaryModelPage(parammap);
        if (ListUtil.isEmpty(disDictionaryList)) {
            DisDictionary disDictionary = this.createDisDictionary(disDictionaryDomain);
            this.saveDictionaryModel(disDictionary);
            this.updateDictionaryCache(disDictionary);
            return disDictionary.getDictionaryCode();
        }
        disDictionaryDomain.setDictionaryId(disDictionaryList.get(0).getDictionaryId());
        disDictionaryDomain.setDictionaryCode(disDictionaryList.get(0).getDictionaryCode());
        this.updateDictionary(disDictionaryDomain);
        return disDictionaryDomain.getDictionaryCode();
    }

    @Override
    public String saveDictionaryBatch(List<DisDictionaryDomain> disDictionaryDomainList) throws ApiException {
        if (null == disDictionaryDomainList || disDictionaryDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDictionary> disDictionaryList = new ArrayList<DisDictionary>();
        String code = "";
        for (DisDictionaryDomain disDictionaryDomain : disDictionaryDomainList) {
            DisDictionary disDictionary = this.createDisDictionary(disDictionaryDomain);
            code = disDictionary.getDictionaryCode();
            disDictionaryList.add(disDictionary);
        }
        this.saveDictionaryBatchModel(disDictionaryList);
        for (DisDictionary disDictionary2 : disDictionaryList) {
            this.updateDictionaryCache(disDictionary2);
        }
        return code;
    }

    @Override
    public void updateDictionaryState(Integer dictionaryId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDictionaryModel(dictionaryId, dataState, oldDataState);
        if (-1 == dataState) {
            DisDictionary disDictionary = this.getDictionary(dictionaryId);
            this.deleteDictionaryCache(disDictionary);
        }
    }

    @Override
    public void updateDictionaryStateByCode(String tenantCode, String dictionaryCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDictionaryModelByCode(tenantCode, dictionaryCode, dataState, oldDataState);
        if (-1 == dataState) {
            DisDictionary disDictionary = this.getDictionaryByCode(tenantCode, dictionaryCode);
            this.deleteDictionaryCache(disDictionary);
        }
    }

    @Override
    public void updateDictionary(DisDictionaryDomain disDictionaryDomain) throws ApiException {
        String msg = this.checkDictionary(disDictionaryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDictionaryServiceImpl.updateDictionary.checkDictionary", msg);
        }
        DisDictionary oldDisDictionary = this.getDictionaryModelById(disDictionaryDomain.getDictionaryId());
        if (null == oldDisDictionary) {
            throw new ApiException("dis.DisDictionaryServiceImpl.updateDictionary.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDictionary disDictionary = this.makeDictionary(disDictionaryDomain, oldDisDictionary);
        this.setDictionaryUpdataDefault(disDictionary);
        this.updateDictionaryModel(disDictionary);
        this.updateDictionaryCache(disDictionary);
    }

    @Override
    public DisDictionary getDictionary(Integer dictionaryId) {
        return this.getDictionaryModelById(dictionaryId);
    }

    @Override
    public void deleteDictionary(Integer dictionaryId) throws ApiException {
        DisDictionary disDictionary = this.getDictionary(dictionaryId);
        this.deleteDictionaryModel(dictionaryId);
        this.deleteDictionaryCache(disDictionary);
    }

    @Override
    public QueryResult<DisDictionary> queryDictionaryPage(Map<String, Object> map) {
        List<DisDictionary> disDictionaryList = this.queryDictionaryModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDictionary(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDictionaryList);
        return queryResult;
    }

    @Override
    public DisDictionary getDictionaryByCode(String tenantCode, String dictionaryCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dictionaryCode", dictionaryCode);
        return this.getDictionaryModelByCode(map);
    }

    @Override
    public void deleteDictionaryByCode(String tenantCode, String dictionaryCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dictionaryCode", dictionaryCode);
        DisDictionary disDictionary = this.getDictionaryByCode(tenantCode, dictionaryCode);
        this.delDictionaryModelByCode(map);
        this.deleteDictionaryCache(disDictionary);
    }

    private void deleteDictionaryCache(DisDictionary disDictionary) {
        if (null == disDictionary) {
            return;
        }
        DisUtil.delMap((String)this.cachekey, (String[])new String[]{disDictionary.getChannelCode() + "-" + disDictionary.getDictionaryType() + "-" + disDictionary.getDictionaryGoods() + "-" + disDictionary.getDictionaryValue() + "-" + disDictionary.getTenantCode()});
        DisUtil.delMap((String)this.cachediskey, (String[])new String[]{disDictionary.getChannelCode() + "-" + disDictionary.getDictionaryType() + "-" + disDictionary.getDictionaryDisgoods() + "-" + disDictionary.getDictionaryBvalue() + "-" + disDictionary.getTenantCode()});
    }

    private void updateDictionaryCache(DisDictionary disDictionary) {
        if (null == disDictionary) {
            return;
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(disDictionary.getChannelCode() + "-" + disDictionary.getDictionaryType() + "-" + disDictionary.getDictionaryGoods() + "-" + disDictionary.getDictionaryValue() + "-" + disDictionary.getTenantCode()), (String)(disDictionary.getDictionaryDisgoods() + "," + disDictionary.getDictionaryBvalue()));
        DisUtil.setMapVer((String)this.cachediskey, (String)(disDictionary.getChannelCode() + "-" + disDictionary.getDictionaryType() + "-" + disDictionary.getDictionaryDisgoods() + "-" + disDictionary.getDictionaryBvalue() + "-" + disDictionary.getTenantCode()), (String)(disDictionary.getDictionaryGoods() + "," + disDictionary.getDictionaryValue()));
    }

    @Override
    public void queryDictionaryLoadCache() {
        this.logger.info("DisDictionaryService.queryDgoodLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<DisDictionary> disDictionaryList = this.queryDictionaryModelPage(parammap);
        if (null == disDictionaryList || disDictionaryList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("DisDictionaryService.queryDictionaryLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> disMap = new ConcurrentHashMap<String, String>();
        for (DisDictionary disDictionary : disDictionaryList) {
            ddMap.put(disDictionary.getChannelCode() + "-" + disDictionary.getDictionaryType() + "-" + disDictionary.getDictionaryGoods() + "-" + disDictionary.getDictionaryValue() + "-" + disDictionary.getTenantCode(), disDictionary.getDictionaryDisgoods() + "," + disDictionary.getDictionaryBvalue());
            disMap.put(disDictionary.getChannelCode() + "-" + disDictionary.getDictionaryType() + "-" + disDictionary.getDictionaryDisgoods() + "-" + disDictionary.getDictionaryBvalue() + "-" + disDictionary.getTenantCode(), disDictionary.getDictionaryGoods() + "," + disDictionary.getDictionaryValue());
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        DisUtil.setMapVer((String)this.cachediskey, disMap);
        this.logger.info("DisDictionaryService.queryDictionaryLoadCache", (Object)"===========add-end==========");
    }

    @Override
    public void sendQueryMappingCategory() throws ApiException {
        List<DisDictionary> disDictionaries = this.queryDictionaryModelPage(null);
        HashMap<String, String> disMap = new HashMap<String, String>();
        disMap.put("disDictionaries", JsonUtil.buildNonDefaultBinder().toJson(disDictionaries));
        String result = (String)this.getInternalRouter().inInvoke("omns.mb.sendQueryMappingCategory", disMap);
        if (StringUtils.isBlank((String)result) || !result.equals("success")) {
            this.logger.error("dis.DisDictionaryServiceImpl.sendQueryMappingCategory", (Object)("error,\u8fd4\u56de\u7ed3\u679cresult:" + result));
            return;
        }
    }
}

