/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisContractSettlMapper;
import com.yqbsoft.laser.service.distribution.domain.DisContractSettlDomain;
import com.yqbsoft.laser.service.distribution.domain.DisContractSettlReDomain;
import com.yqbsoft.laser.service.distribution.model.DisContractSettl;
import com.yqbsoft.laser.service.distribution.service.DisContractSettlService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisContractSettlServiceImpl
extends BaseServiceImpl
implements DisContractSettlService {
    private static final String SYS_CODE = "dis.DisContractSettlServiceImpl";
    private DisContractSettlMapper disContractSettlMapper;

    public void setDisContractSettlMapper(DisContractSettlMapper disContractSettlMapper) {
        this.disContractSettlMapper = disContractSettlMapper;
    }

    private Date getSysDate() {
        try {
            return this.disContractSettlMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractSettlServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContractSettl(DisContractSettlDomain disContractSettlDomain) {
        if (null == disContractSettlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disContractSettlDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractSettlDefault(DisContractSettl disContractSettl) {
        if (null == disContractSettl) {
            return;
        }
        if (null == disContractSettl.getDataState()) {
            disContractSettl.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disContractSettl.getGmtCreate()) {
            disContractSettl.setGmtCreate(date);
        }
        disContractSettl.setGmtModified(date);
        if (StringUtils.isBlank((String)disContractSettl.getContractSettlBillcode())) {
            disContractSettl.setContractSettlBillcode(this.getNo(null, "DisContractSettl", "disContractSettl", disContractSettl.getTenantCode()));
        }
    }

    private int getContractSettlMaxCode() {
        int code = 0;
        try {
            return this.disContractSettlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractSettlServiceImpl.getContractSettlMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractSettlUpdataDefault(DisContractSettl disContractSettl) {
        if (null == disContractSettl) {
            return;
        }
        disContractSettl.setGmtModified(this.getSysDate());
    }

    private void saveContractSettlModel(DisContractSettl disContractSettl) throws ApiException {
        if (null == disContractSettl) {
            return;
        }
        try {
            this.disContractSettlMapper.insert(disContractSettl);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractSettlServiceImpl.saveContractSettlModel.ex", (Throwable)e);
        }
    }

    private void saveContractSettlBatchModel(List<DisContractSettl> disContractSettlList) throws ApiException {
        if (null == disContractSettlList || disContractSettlList.isEmpty()) {
            return;
        }
        try {
            this.disContractSettlMapper.insertBatch(disContractSettlList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractSettlServiceImpl.saveContractSettlBatchModel.ex", (Throwable)e);
        }
    }

    private DisContractSettl getContractSettlModelById(Integer contractSettlId) {
        if (null == contractSettlId) {
            return null;
        }
        try {
            return this.disContractSettlMapper.selectByPrimaryKey(contractSettlId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractSettlServiceImpl.getContractSettlModelById", (Throwable)e);
            return null;
        }
    }

    private DisContractSettl getContractSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disContractSettlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractSettlServiceImpl.getContractSettlModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractSettlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractSettlServiceImpl.delContractSettlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractSettlServiceImpl.delContractSettlModelByCode.num");
        }
    }

    private void deleteContractSettlModel(Integer contractSettlId) throws ApiException {
        if (null == contractSettlId) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractSettlMapper.deleteByPrimaryKey(contractSettlId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractSettlServiceImpl.deleteContractSettlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractSettlServiceImpl.deleteContractSettlModel.num");
        }
    }

    private void updateContractSettlModel(DisContractSettl disContractSettl) throws ApiException {
        if (null == disContractSettl) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractSettlMapper.updateByPrimaryKey(disContractSettl);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractSettlServiceImpl.updateContractSettlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractSettlServiceImpl.updateContractSettlModel.num");
        }
    }

    private void updateStateContractSettlModel(Integer contractSettlId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractSettlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractSettlId", contractSettlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disContractSettlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractSettlServiceImpl.updateStateContractSettlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractSettlServiceImpl.updateStateContractSettlModel.null");
        }
    }

    private void updateStateContractSettlModelByCode(String tenantCode, String contractSettlBillcode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractSettlBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSettlBillcode", contractSettlBillcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disContractSettlMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractSettlServiceImpl.updateStateContractSettlModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractSettlServiceImpl.updateStateContractSettlModelByCode.null");
        }
    }

    private DisContractSettl makeContractSettl(DisContractSettlDomain disContractSettlDomain, DisContractSettl disContractSettl) {
        if (null == disContractSettlDomain) {
            return null;
        }
        if (null == disContractSettl) {
            disContractSettl = new DisContractSettl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disContractSettl, (Object)disContractSettlDomain);
            return disContractSettl;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractSettlServiceImpl.makeContractSettl", (Throwable)e);
            return null;
        }
    }

    private DisContractSettlReDomain makeDisContractSettlReDomain(DisContractSettl disContractSettl) {
        if (null == disContractSettl) {
            return null;
        }
        DisContractSettlReDomain disContractSettlReDomain = new DisContractSettlReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disContractSettlReDomain, (Object)disContractSettl);
            return disContractSettlReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractSettlServiceImpl.makeDisContractSettlReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisContractSettl> queryContractSettlModelPage(Map<String, Object> parammap) {
        try {
            return this.disContractSettlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractSettlServiceImpl.queryContractSettlModel", (Throwable)e);
            return null;
        }
    }

    private int countContractSettl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disContractSettlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractSettlServiceImpl.countContractSettl", (Throwable)e);
        }
        return i;
    }

    private DisContractSettl createDisContractSettl(DisContractSettlDomain disContractSettlDomain) {
        String msg = this.checkContractSettl(disContractSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisContractSettlServiceImpl.saveContractSettl.checkContractSettl", msg);
        }
        DisContractSettl disContractSettl = this.makeContractSettl(disContractSettlDomain, null);
        this.setContractSettlDefault(disContractSettl);
        return disContractSettl;
    }

    @Override
    public String saveContractSettl(DisContractSettlDomain disContractSettlDomain) throws ApiException {
        DisContractSettl disContractSettl = this.createDisContractSettl(disContractSettlDomain);
        this.saveContractSettlModel(disContractSettl);
        return disContractSettl.getContractSettlBillcode();
    }

    @Override
    public String saveContractSettlBatch(List<DisContractSettlDomain> disContractSettlDomainList) throws ApiException {
        if (null == disContractSettlDomainList || disContractSettlDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisContractSettl> disContractSettlList = new ArrayList<DisContractSettl>();
        String code = "";
        for (DisContractSettlDomain disContractSettlDomain : disContractSettlDomainList) {
            DisContractSettl disContractSettl = this.createDisContractSettl(disContractSettlDomain);
            code = disContractSettl.getContractSettlBillcode();
            disContractSettlList.add(disContractSettl);
        }
        this.saveContractSettlBatchModel(disContractSettlList);
        return code;
    }

    @Override
    public void updateContractSettlState(Integer contractSettlId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contractSettlId) {
            return;
        }
        this.updateStateContractSettlModel(contractSettlId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractSettlStateByCode(String tenantCode, String contractSettlBillcode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contractSettlBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContractSettlModelByCode(tenantCode, contractSettlBillcode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractSettl(DisContractSettlDomain disContractSettlDomain) throws ApiException {
        String msg = this.checkContractSettl(disContractSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisContractSettlServiceImpl.updateContractSettl.checkContractSettl", msg);
        }
        DisContractSettl oldDisContractSettl = this.getContractSettlModelById(disContractSettlDomain.getContractSettlId());
        if (null == oldDisContractSettl) {
            throw new ApiException("dis.DisContractSettlServiceImpl.updateContractSettl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisContractSettl disContractSettl = this.makeContractSettl(disContractSettlDomain, oldDisContractSettl);
        this.setContractSettlUpdataDefault(disContractSettl);
        this.updateContractSettlModel(disContractSettl);
    }

    @Override
    public DisContractSettl getContractSettl(Integer contractSettlId) {
        if (null == contractSettlId) {
            return null;
        }
        return this.getContractSettlModelById(contractSettlId);
    }

    @Override
    public void deleteContractSettl(Integer contractSettlId) throws ApiException {
        if (null == contractSettlId) {
            return;
        }
        this.deleteContractSettlModel(contractSettlId);
    }

    @Override
    public QueryResult<DisContractSettl> queryContractSettlPage(Map<String, Object> map) {
        List<DisContractSettl> disContractSettlList = this.queryContractSettlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractSettl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disContractSettlList);
        return queryResult;
    }

    @Override
    public DisContractSettl getContractSettlByCode(String tenantCode, String contractSettlBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractSettlBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSettlBillcode", contractSettlBillcode);
        return this.getContractSettlModelByCode(map);
    }

    @Override
    public void deleteContractSettlByCode(String tenantCode, String contractSettlBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractSettlBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSettlBillcode", contractSettlBillcode);
        this.delContractSettlModelByCode(map);
    }

    @Override
    public List<DisContractSettlDomain> queryContractSettlByOrerCode(String tenantCode, String contractBillcode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        List<DisContractSettl> list = this.queryContractSettlModelPage(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        ArrayList<DisContractSettlDomain> domainList = new ArrayList<DisContractSettlDomain>();
        for (DisContractSettl disContractSettl : list) {
            DisContractSettlDomain disContractSettlDomain = new DisContractSettlDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disContractSettlDomain, (Object)disContractSettl);
                domainList.add(disContractSettlDomain);
            }
            catch (Exception e) {}
        }
        return domainList;
    }
}

