/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.DistributionConstants;
import com.yqbsoft.laser.service.distribution.dao.DisDpriceConfMapper;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.distribution.model.DisDprice;
import com.yqbsoft.laser.service.distribution.model.DisDpriceConf;
import com.yqbsoft.laser.service.distribution.service.DisDpriceConfService;
import com.yqbsoft.laser.service.distribution.service.DisDpriceService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DisDpriceConfServiceImpl
extends BaseServiceImpl
implements DisDpriceConfService {
    private static final String SYS_CODE = "dis.DisDpriceConfServiceImpl";
    private String cachekey = "DisDpriceConf-channelCode";
    @Autowired
    private DisDpriceConfMapper disDpriceConfMapper;
    @Autowired
    private DisDpriceService disDpriceService;

    @Override
    public void resetDisPriceConf(Map<String, Object> map) throws ApiException {
        this.logger.error("log >>> desc: resetDisPriceConf params{}{\u91cd\u7f6e\u7279\u4ef7\u5ba1\u6279\u5f00\u59cb}");
        this.logger.error("log >>> debug: resetDisPriceConf params{map}", map);
        List<DisDpriceConf> disDPriceConfReList = this.queryDPriceConfBySkuCode(map.get("skuCode").toString());
        BigDecimal priceSetNPrice = new BigDecimal(map.get("priceSetNPrice").toString());
        for (DisDpriceConf disDPriceConfRe : disDPriceConfReList) {
            this.resetDPriceConf(disDPriceConfRe, priceSetNPrice);
        }
        this.logger.error("log >>> desc: resetDisPriceConf params{}{\u91cd\u7f6e\u7279\u4ef7\u5ba1\u6279\u7ed3\u675f}");
    }

    private List<DisDpriceConf> queryDPriceConfBySkuCode(String skuCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dpriceConfValueno", skuCode);
        return this.disDpriceConfMapper.query(params);
    }

    private void resetDPriceConf(DisDpriceConf disDPriceConfRe, BigDecimal priceSetNPrice) {
        DisDpriceConf disDPriceConfDomain = this.makeDisDPriceConf(null, disDPriceConfRe);
        disDPriceConfDomain.setDataState(DistributionConstants.dataState_add);
        if (priceSetNPrice != null) {
            disDPriceConfDomain.setDpriceConfPrice(priceSetNPrice);
        }
        disDPriceConfDomain.setMemo(null);
        this.updateDPriceConf(disDPriceConfDomain);
    }

    private void updateDPriceConf(DisDpriceConf disDPriceConfDomain) {
        String msg = this.checkDisDPriceConf(disDPriceConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceConfServiceImpl.updateDPriceConf.checkDisDPriceConf", msg);
        }
        DisDpriceConf disDpriceConf = this.getDPriceConfModelById(disDPriceConfDomain.getDpriceConfId());
        if (disDpriceConf == null) {
            throw new ApiException("dis.DisDpriceConfServiceImpl.updateDPriceConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.makeDisDPriceConf(disDpriceConf, disDPriceConfDomain);
        this.setDisDPriceConfDefault(disDpriceConf);
        this.updateDPriceConfModel(disDpriceConf);
        this.updateDPriceConfCache(disDpriceConf);
    }

    private void updateDPriceConfCache(DisDpriceConf disDpriceConf) {
        if (null == disDpriceConf) {
            return;
        }
        DisDprice disDprice = this.disDpriceService.getDpriceByCode(disDpriceConf.getTenantCode(), disDpriceConf.getDpriceCode());
        if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
            disDprice.setChannelCode("all");
        }
        DisDpriceDomain disDpriceDomain = this.makeDisDpriceDomain(disDprice);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dpriceCode", disDprice.getDpriceCode());
        confparammap.put("tenantCode", disDprice.getTenantCode());
        List<DisDpriceConf> upcachelist = this.disDpriceConfMapper.query(confparammap);
        disDpriceDomain.setDisDpriceConfList(upcachelist);
        String json = DisUtil.getRemotMap((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<DisDpriceDomain> dlist = new ArrayList<DisDpriceDomain>();
            dlist.add(disDpriceDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDpriceConf.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        } else {
            ArrayList<DisDpriceDomain> dlist = (ArrayList<DisDpriceDomain>)JsonUtil.buildNormalBinder().getJsonToList(json, DisDpriceDomain.class);
            if (ListUtil.isEmpty((Collection)dlist)) {
                dlist = new ArrayList<DisDpriceDomain>();
                dlist.add(disDpriceDomain);
            } else {
                for (DisDpriceDomain disDpriceDomain2 : dlist) {
                    if (!disDpriceDomain2.getDpriceCode().equals(disDprice.getDpriceCode())) continue;
                    disDpriceDomain2.setDisDpriceConfList(upcachelist);
                    break;
                }
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDpriceConf.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        }
    }

    private void updateDPriceConfModel(DisDpriceConf disDPriceConf) {
        if (disDPriceConf == null) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfMapper.updateByPrimaryKey(disDPriceConf);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceConfServiceImplupdateDPriceConfModel.ex", (Throwable)e);
        }
        if (i != 1) {
            throw new ApiException("dis.DisDpriceConfServiceImplupdateDPriceConfModel.num");
        }
    }

    private DisDpriceConf makeDisDPriceConf(DisDpriceConf target, DisDpriceConf source) {
        if (source == null) {
            return null;
        }
        try {
            if (target == null) {
                target = new DisDpriceConf();
            }
            BeanUtils.copyAllPropertys((Object)target, (Object)source);
            return target;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String checkDisDPriceConf(DisDpriceConf disDPriceConfDomain) {
        if (disDPriceConfDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a;";
        }
        String msg = "";
        if (disDPriceConfDomain.getTenantCode() == null) {
            msg = msg + "tenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private DisDpriceConf getDPriceConfModelById(Integer id) {
        if (id == null) {
            return null;
        }
        try {
            return this.disDpriceConfMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceConfServiceImpl.getDPriceConfModelById.null", (Throwable)e);
            return null;
        }
    }

    private void setDisDPriceConfDefault(DisDpriceConf disDPriceConf) {
        if (disDPriceConf == null) {
            return;
        }
        Date date = this.getSysDate();
        disDPriceConf.setGmtModified(date);
        if (disDPriceConf.getGmtCreate() == null) {
            disDPriceConf.setGmtCreate(date);
        }
        if (disDPriceConf.getDpriceConfCode() == null) {
            disDPriceConf.setDpriceConfCode(this.createUUIDString());
        }
        if (disDPriceConf.getDataState() == null) {
            disDPriceConf.setDataState(DistributionConstants.dataState_add);
        }
    }

    private Date getSysDate() {
        try {
            return this.disDpriceConfMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceConfServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private DisDpriceDomain makeDisDpriceDomain(DisDprice disDprice) {
        if (null == disDprice) {
            return null;
        }
        DisDpriceDomain disDpriceDomain = new DisDpriceDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceDomain, (Object)disDprice);
            return disDpriceDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<DisDpriceDomain> disDomainsort(List<DisDpriceDomain> dlist) {
        if (ListUtil.isEmpty(dlist)) {
            return null;
        }
        Collections.sort(dlist, new Comparator<DisDpriceDomain>(){

            @Override
            public int compare(DisDpriceDomain arg0, DisDpriceDomain arg1) {
                if (arg0.getDpriceWeight() > arg1.getDpriceWeight()) {
                    return 1;
                }
                if (arg0.getDpriceWeight() < arg1.getDpriceWeight()) {
                    return -1;
                }
                return arg0.getDpriceWeight().compareTo(arg0.getDpriceWeight());
            }
        });
        return dlist;
    }

    private BigDecimal getSkuPrice(String skuCode) {
        HashMap<String, String> mapSku = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("skuCode", skuCode);
        mapSku.put("map", JsonUtil.buildNormalBinder().toJson(mapSku));
        String skuResult = this.internalInvoke("rs.sku.getSkuDomainByCode", mapSku);
        JSONObject jsonObject = (JSONObject)JsonUtil.buildNormalBinder().getJsonToObject(skuResult, JSONObject.class);
        String priceSetNPrice = jsonObject.getString("pricesetNprice");
        if (priceSetNPrice != null) {
            return new BigDecimal("priceSetNPrice");
        }
        return null;
    }
}

