/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.DistributionConstants;
import com.yqbsoft.laser.service.distribution.dao.DisDpriceConfMapper;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.distribution.model.DisDprice;
import com.yqbsoft.laser.service.distribution.model.DisDpriceConf;
import com.yqbsoft.laser.service.distribution.service.DisDpriceConfService;
import com.yqbsoft.laser.service.distribution.service.DisDpriceService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DisDpriceConfServiceImpl
extends BaseServiceImpl
implements DisDpriceConfService {
    private static final String SYS_CODE = "dis.DisDpriceConfServiceImpl";
    private String cachekey = "DisDpriceConf-channelCode";
    @Autowired
    private DisDpriceConfMapper disDpriceConfMapper;
    @Autowired
    private DisDpriceService disDpriceService;

    @Override
    public void resetDisPriceConf(Map<String, Object> map) throws ApiException {
        this.logger.error("log >>> desc: resetDisPriceConf params{}{\u91cd\u7f6e\u7279\u4ef7\u5ba1\u6279\u5f00\u59cb}");
        this.logger.error("log >>> debug: resetDisPriceConf params{map}", map);
        this.updateDPriceConfByMap(map);
        List<DisDpriceConf> disDPriceConfReList = this.queryDPriceConfBySkuNo(map);
        for (DisDpriceConf disDPriceConfRe : disDPriceConfReList) {
            this.updateDPriceConfCache(disDPriceConfRe);
        }
        this.updateGoodsEs(map);
        this.logger.error("log >>> desc: resetDisPriceConf params{}{\u91cd\u7f6e\u7279\u4ef7\u5ba1\u6279\u7ed3\u675f}");
    }

    private boolean deleteSkuEs(DisDpriceConf disDPriceConfRe) {
        this.logger.error("log >>> debug: deleteSkuEs {}=====", (Object)disDPriceConfRe.getDpriceConfValueno());
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType("skudelete");
        storeDomain.setBizType("sku");
        storeDomain.setTenantCode(disDPriceConfRe.getTenantCode());
        storeDomain.setBizId(disDPriceConfRe.getTenantCode() + disDPriceConfRe.getDpriceConfValueno());
        boolean flag = this.sendEs(storeDomain);
        if (!flag) {
            return flag;
        }
        storeDomain.setBizType("skuNo");
        storeDomain.setBizId(disDPriceConfRe.getTenantCode() + "00" + disDPriceConfRe.getDpriceConfValue());
        this.sendEs(storeDomain);
        this.logger.error("log >>> debug: deleteSkuEs {\u5220\u9664es\u7ed3\u675f}=====", (Object)flag);
        return true;
    }

    private boolean sendEs(StoreDomain storeDomain) {
        if (null == storeDomain) {
            return false;
        }
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        String result = (String)this.getInternalRouter().inInvoke("es.searchengine.store", "1.0", "0", paramMap1);
        if (StringUtils.isEmpty((String)result) || "false".equals(result)) {
            this.logger.error("dis.DisDpriceConfServiceImpl.sendEs.result", (Object)result);
            return false;
        }
        return true;
    }

    private void updateGoodsEs(Map<String, Object> map) {
        try {
            if (map.get("goodsId") == null) {
                return;
            }
            HashMap disMap = new HashMap();
            ArrayList<Integer> goodsIds = new ArrayList<Integer>();
            goodsIds.add(Integer.valueOf(map.get("goodsId").toString()));
            disMap.put("goodsIds", goodsIds);
            this.internalInvoke("rs.resource.sendUpdateSoldOutGoods", disMap);
            disMap.clear();
            disMap.put("goodsIds", goodsIds);
            this.internalInvoke("rs.resource.sendUpdateShelveGoods", disMap);
        }
        catch (Exception e) {
            this.logger.error(".updateAuditCall", (Object)"\u5546\u54c1\u4e0a\u4e0b\u67b6\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    private String getDPriceConfDes(Map<String, Object> map) {
        List<DisDpriceConf> disDPriceConfReList = this.queryDPriceConfBySkuNo(map);
        Iterator<DisDpriceConf> i$ = disDPriceConfReList.iterator();
        if (i$.hasNext()) {
            DisDpriceConf disDPriceConfRe = i$.next();
            return disDPriceConfRe.getDpriceConfDes();
        }
        return null;
    }

    private void updateDPriceConfByMap(Map<String, Object> map) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataState", DistributionConstants.dataState_add);
        params.put("dpriceConfDes", this.buildDPriceConfDes(map));
        params.put("dpriceConfPrice", "null");
        params.put("memo", "null");
        params.put("dpriceConfValue", map.get("orderBom").toString());
        this.disDpriceConfMapper.updateStateByOrderBom(params);
    }

    private String buildDPriceConfDes(Map<String, Object> map) {
        StringBuffer dPriceConfDes = new StringBuffer();
        String dPriceConfDesOld = this.getDPriceConfDes(map);
        String priceSetNPrice = map.get("priceSetNPrice").toString();
        String[] des = dPriceConfDesOld.split(",");
        des[1] = priceSetNPrice;
        for (String str : des) {
            dPriceConfDes.append(str).append(",");
        }
        return dPriceConfDes.substring(0, dPriceConfDes.length() - 1);
    }

    private List<DisDpriceConf> queryDPriceConfBySkuNo(Map<String, Object> map) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dpriceConfValue", map.get("orderBom").toString());
        return this.queryDPriceConfByMap(params);
    }

    private List<DisDpriceConf> queryDPriceConfByMap(Map<String, Object> params) {
        return this.disDpriceConfMapper.query(params);
    }

    private List<DisDpriceConf> queryDPriceConfBySkuCode(String skuCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dpriceConfValueno", skuCode);
        return this.disDpriceConfMapper.query(params);
    }

    private void resetDPriceConf(DisDpriceConf disDPriceConfRe) {
        DisDpriceConf disDPriceConfDomain = this.makeDisDPriceConf(null, disDPriceConfRe);
        disDPriceConfDomain.setDataState(DistributionConstants.dataState_add);
        disDPriceConfDomain.setMemo(null);
        disDPriceConfDomain.setDpriceConfPrice(null);
        this.updateDPriceConf(disDPriceConfDomain);
    }

    private void updateDPriceConf(DisDpriceConf disDPriceConfDomain) {
        String msg = this.checkDisDPriceConf(disDPriceConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceConfServiceImpl.updateDPriceConf.checkDisDPriceConf", msg);
        }
        DisDpriceConf disDpriceConf = this.getDPriceConfModelById(disDPriceConfDomain.getDpriceConfId());
        if (disDpriceConf == null) {
            throw new ApiException("dis.DisDpriceConfServiceImpl.updateDPriceConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.makeDisDPriceConf(disDpriceConf, disDPriceConfDomain);
        this.setDisDPriceConfDefault(disDpriceConf);
        this.updateDPriceConfModel(disDpriceConf);
        this.deleteDpriceConfCache(disDpriceConf, null);
    }

    private void updateDPriceConfCache(DisDpriceConf disDpriceConf) {
        if (null == disDpriceConf) {
            return;
        }
        DisDprice disDprice = this.disDpriceService.getDpriceByCode(disDpriceConf.getTenantCode(), disDpriceConf.getDpriceCode());
        if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
            disDprice.setChannelCode("all");
        }
        DisDpriceDomain disDpriceDomain = this.makeDisDpriceDomain(disDprice);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dpriceCode", disDprice.getDpriceCode());
        confparammap.put("tenantCode", disDprice.getTenantCode());
        List<DisDpriceConf> upcachelist = this.disDpriceConfMapper.query(confparammap);
        disDpriceDomain.setDisDpriceConfList(upcachelist);
        String json = DisUtil.getRemotMap((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<DisDpriceDomain> dlist = new ArrayList<DisDpriceDomain>();
            dlist.add(disDpriceDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDpriceConf.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        } else {
            ArrayList<DisDpriceDomain> dlist = (ArrayList<DisDpriceDomain>)JsonUtil.buildNormalBinder().getJsonToList(json, DisDpriceDomain.class);
            if (ListUtil.isEmpty((Collection)dlist)) {
                dlist = new ArrayList<DisDpriceDomain>();
                dlist.add(disDpriceDomain);
            } else {
                for (DisDpriceDomain disDpriceDomain2 : dlist) {
                    if (!disDpriceDomain2.getDpriceCode().equals(disDprice.getDpriceCode())) continue;
                    disDpriceDomain2.setDisDpriceConfList(upcachelist);
                    break;
                }
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDpriceConf.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        }
    }

    private void deleteDpriceConfCache(DisDpriceConf disDpriceConf, DisDprice disDprice) {
        String json;
        if (null == disDpriceConf) {
            return;
        }
        if (null == disDprice) {
            disDprice = this.disDpriceService.getDpriceByCode(disDpriceConf.getTenantCode(), disDpriceConf.getDpriceCode());
        }
        if (null == disDprice) {
            return;
        }
        if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
            disDprice.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getRemotMap((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()))))) {
            return;
        }
        List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDpriceDomain.class);
        ArrayList<DisDpriceDomain> dlist1 = new ArrayList<DisDpriceDomain>();
        if (ListUtil.isNotEmpty((Collection)dlist)) {
            for (DisDpriceDomain disDpriceDomain2 : dlist) {
                if (disDpriceDomain2.getDpriceCode().equals(disDprice.getDpriceCode())) {
                    ArrayList<DisDpriceConf> configcacheList = new ArrayList<DisDpriceConf>();
                    disDpriceDomain2.setDisDpriceConfList(configcacheList);
                    for (DisDpriceConf disDpriceConf2 : disDpriceDomain2.getDisDpriceConfList()) {
                        if (disDpriceConf2.getDpriceConfCode().equals(disDpriceConf.getDpriceConfCode())) continue;
                        configcacheList.add(disDpriceConf2);
                    }
                }
                dlist1.add(disDpriceDomain2);
            }
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDpriceConf.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist1)));
    }

    private void updateDPriceConfModel(DisDpriceConf disDPriceConf) {
        if (disDPriceConf == null) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfMapper.updateByPrimaryKey(disDPriceConf);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceConfServiceImplupdateDPriceConfModel.ex", (Throwable)e);
        }
        if (i != 1) {
            throw new ApiException("dis.DisDpriceConfServiceImplupdateDPriceConfModel.num");
        }
    }

    private DisDpriceConf makeDisDPriceConf(DisDpriceConf target, DisDpriceConf source) {
        if (source == null) {
            return null;
        }
        try {
            if (target == null) {
                target = new DisDpriceConf();
            }
            BeanUtils.copyAllPropertys((Object)target, (Object)source);
            return target;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String checkDisDPriceConf(DisDpriceConf disDPriceConfDomain) {
        if (disDPriceConfDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a;";
        }
        String msg = "";
        if (disDPriceConfDomain.getTenantCode() == null) {
            msg = msg + "tenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private DisDpriceConf getDPriceConfModelById(Integer id) {
        if (id == null) {
            return null;
        }
        try {
            return this.disDpriceConfMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceConfServiceImpl.getDPriceConfModelById.null", (Throwable)e);
            return null;
        }
    }

    private void setDisDPriceConfDefault(DisDpriceConf disDPriceConf) {
        if (disDPriceConf == null) {
            return;
        }
        Date date = this.getSysDate();
        disDPriceConf.setGmtModified(date);
        if (disDPriceConf.getGmtCreate() == null) {
            disDPriceConf.setGmtCreate(date);
        }
        if (disDPriceConf.getDpriceConfCode() == null) {
            disDPriceConf.setDpriceConfCode(this.createUUIDString());
        }
        if (disDPriceConf.getDataState() == null) {
            disDPriceConf.setDataState(DistributionConstants.dataState_add);
        }
    }

    private Date getSysDate() {
        try {
            return this.disDpriceConfMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceConfServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private DisDpriceDomain makeDisDpriceDomain(DisDprice disDprice) {
        if (null == disDprice) {
            return null;
        }
        DisDpriceDomain disDpriceDomain = new DisDpriceDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceDomain, (Object)disDprice);
            return disDpriceDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<DisDpriceDomain> disDomainsort(List<DisDpriceDomain> dlist) {
        if (ListUtil.isEmpty(dlist)) {
            return null;
        }
        Collections.sort(dlist, new Comparator<DisDpriceDomain>(){

            @Override
            public int compare(DisDpriceDomain arg0, DisDpriceDomain arg1) {
                if (arg0.getDpriceWeight() > arg1.getDpriceWeight()) {
                    return 1;
                }
                if (arg0.getDpriceWeight() < arg1.getDpriceWeight()) {
                    return -1;
                }
                return arg0.getDpriceWeight().compareTo(arg0.getDpriceWeight());
            }
        });
        return dlist;
    }

    private String getSkuPriceDes(JSONObject jsonObjectSku) {
        if (jsonObjectSku == null) {
            return null;
        }
        StringBuffer priceDes = new StringBuffer();
        String priceSetNPrice = jsonObjectSku.getString("pricesetNprice");
        String skuName = jsonObjectSku.getString("skuName");
        if (skuName != null) {
            priceDes.append(skuName);
        }
        if (priceSetNPrice != null) {
            priceDes.append(",").append(priceSetNPrice);
        }
        return priceDes.toString();
    }

    private JSONObject getSkuBySkuCode(String skuCode) {
        HashMap<String, String> mapSku = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("skuCode", skuCode);
        mapSku.put("map", JsonUtil.buildNormalBinder().toJson(mapSku));
        String skuResult = this.internalInvoke("rs.sku.getSkuDomainByCode", mapSku);
        JSONObject jsonObject = (JSONObject)JsonUtil.buildNormalBinder().getJsonToObject(skuResult, JSONObject.class);
        return jsonObject;
    }
}

