/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.DistributionConstants;
import com.yqbsoft.laser.service.distribution.dao.DisDpriceSubMapper;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceSubDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceSubReDomain;
import com.yqbsoft.laser.service.distribution.model.DisDpriceSub;
import com.yqbsoft.laser.service.distribution.service.DisDpriceService;
import com.yqbsoft.laser.service.distribution.service.DisDpriceSubService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DisDpriceSubServiceImpl
extends BaseServiceImpl
implements DisDpriceSubService {
    private static final String SYS_CODE = "dis.disDpriceSubServiceImpl";
    private DisDpriceSubMapper disDpriceSubMapper;
    @Autowired
    private DisDpriceService disDpriceService;
    private String cachekey = "DisDpriceSubList-channelCode";
    private String cacheSubKey = "DisDpriceSubList-channelCode";

    public void setdisDpriceSubMapper(DisDpriceSubMapper disDpriceSubMapper) {
        this.disDpriceSubMapper = disDpriceSubMapper;
    }

    private Date getSysDate() {
        try {
            return this.disDpriceSubMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.disDpriceSubServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDpriceSub(DisDpriceSubDomain disDpriceSubDomain) {
        if (null == disDpriceSubDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDpriceSubDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDpriceSubDefault(DisDpriceSub disDpriceSub) {
        if (null == disDpriceSub) {
            return;
        }
        if (null == disDpriceSub.getDataState()) {
            disDpriceSub.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDpriceSub.getGmtCreate()) {
            disDpriceSub.setGmtCreate(date);
        }
        disDpriceSub.setGmtModified(date);
        if (StringUtils.isBlank((String)disDpriceSub.getDpriceSubCode())) {
            disDpriceSub.setDpriceSubCode(this.getNo(null, "disDpriceSub", "disDpriceSub", disDpriceSub.getTenantCode()));
        }
    }

    private int getDpriceSubMaxCode() {
        int code = 0;
        try {
            return this.disDpriceSubMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.disDpriceSubServiceImpl.getDpriceSubMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDpriceSubUpdataDefault(DisDpriceSub disDpriceSub) {
        if (null == disDpriceSub) {
            return;
        }
        disDpriceSub.setGmtModified(this.getSysDate());
    }

    private void saveDpriceSubModel(DisDpriceSub disDpriceSub) throws ApiException {
        if (null == disDpriceSub) {
            return;
        }
        try {
            this.disDpriceSubMapper.insert(disDpriceSub);
        }
        catch (Exception e) {
            throw new ApiException("dis.disDpriceSubServiceImpl.saveDpriceSubModel.ex", (Throwable)e);
        }
    }

    private void saveDpriceSubBatchModel(List<DisDpriceSub> disDpriceSubList) throws ApiException {
        if (null == disDpriceSubList || disDpriceSubList.isEmpty()) {
            return;
        }
        try {
            this.disDpriceSubMapper.insertBatch(disDpriceSubList);
        }
        catch (Exception e) {
            throw new ApiException("dis.disDpriceSubServiceImpl.saveDpriceSubBatchModel.ex", (Throwable)e);
        }
    }

    private DisDpriceSub getDpriceSubModelById(Integer dpriceSubId) {
        if (null == dpriceSubId) {
            return null;
        }
        try {
            return this.disDpriceSubMapper.selectByPrimaryKey(dpriceSubId);
        }
        catch (Exception e) {
            this.logger.error("dis.disDpriceSubServiceImpl.getDpriceSubModelById", (Throwable)e);
            return null;
        }
    }

    private DisDpriceSub getDpriceSubModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDpriceSubMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.disDpriceSubServiceImpl.getDpriceSubModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDpriceSubModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceSubMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.disDpriceSubServiceImpl.delDpriceSubModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.disDpriceSubServiceImpl.delDpriceSubModelByCode.num");
        }
    }

    private void deleteDpriceSubModel(Integer dpriceSubId) throws ApiException {
        if (null == dpriceSubId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceSubMapper.deleteByPrimaryKey(dpriceSubId);
        }
        catch (Exception e) {
            throw new ApiException("dis.disDpriceSubServiceImpl.deleteDpriceSubModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.disDpriceSubServiceImpl.deleteDpriceSubModel.num");
        }
    }

    private void updateDpriceSubModel(DisDpriceSub disDpriceSub) throws ApiException {
        if (null == disDpriceSub) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceSubMapper.updateByPrimaryKey(disDpriceSub);
        }
        catch (Exception e) {
            throw new ApiException("dis.disDpriceSubServiceImpl.updateDpriceSubModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.disDpriceSubServiceImpl.updateDpriceSubModel.num");
        }
    }

    private void updateStateDpriceSubModel(Integer dpriceSubId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dpriceSubId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceSubId", dpriceSubId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDpriceSubMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.disDpriceSubServiceImpl.updateStateDpriceSubModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.disDpriceSubServiceImpl.updateStateDpriceSubModel.null");
        }
    }

    private void updateStateDpriceSubModelByCode(String tenantCode, String dpriceSubCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dpriceSubCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceSubCode", dpriceSubCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDpriceSubMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.disDpriceSubServiceImpl.updateStateDpriceSubModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.disDpriceSubServiceImpl.updateStateDpriceSubModelByCode.null");
        }
    }

    private DisDpriceSub makeDpriceSub(DisDpriceSubDomain disDpriceSubDomain, DisDpriceSub disDpriceSub) {
        if (null == disDpriceSubDomain) {
            return null;
        }
        if (null == disDpriceSub) {
            disDpriceSub = new DisDpriceSub();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceSub, (Object)disDpriceSubDomain);
            return disDpriceSub;
        }
        catch (Exception e) {
            this.logger.error("dis.disDpriceSubServiceImpl.makeDpriceSub", (Throwable)e);
            return null;
        }
    }

    private DisDpriceSubReDomain makedisDpriceSubReDomain(DisDpriceSub disDpriceSub) {
        if (null == disDpriceSub) {
            return null;
        }
        DisDpriceSubReDomain disDpriceSubReDomain = new DisDpriceSubReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceSubReDomain, (Object)disDpriceSub);
            return disDpriceSubReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.disDpriceSubServiceImpl.makedisDpriceSubReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDpriceSub> queryDpriceSubModelPage(Map<String, Object> parammap) {
        try {
            return this.disDpriceSubMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.disDpriceSubServiceImpl.queryDpriceSubModel", (Throwable)e);
            return null;
        }
    }

    private int countDpriceSub(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDpriceSubMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.disDpriceSubServiceImpl.countDpriceSub", (Throwable)e);
        }
        return i;
    }

    private DisDpriceSub createdisDpriceSub(DisDpriceSubDomain disDpriceSubDomain) {
        String msg = this.checkDpriceSub(disDpriceSubDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.disDpriceSubServiceImpl.saveDpriceSub.checkDpriceSub", msg);
        }
        DisDpriceSub disDpriceSub = this.makeDpriceSub(disDpriceSubDomain, null);
        this.setDpriceSubDefault(disDpriceSub);
        return disDpriceSub;
    }

    @Override
    public String saveDpriceSub(DisDpriceSubDomain disDpriceSubDomain) throws ApiException {
        DisDpriceSub disDpriceSub = this.createdisDpriceSub(disDpriceSubDomain);
        this.saveDpriceSubModel(disDpriceSub);
        return disDpriceSub.getDpriceSubCode();
    }

    @Override
    public String saveDpriceSubBatch(List<DisDpriceSubDomain> disDpriceSubDomainList) throws ApiException {
        if (null == disDpriceSubDomainList || disDpriceSubDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDpriceSub> disDpriceSubList = new ArrayList<DisDpriceSub>();
        String code = "";
        for (DisDpriceSubDomain disDpriceSubDomain : disDpriceSubDomainList) {
            DisDpriceSub disDpriceSub = this.createdisDpriceSub(disDpriceSubDomain);
            code = disDpriceSub.getDpriceSubCode();
            disDpriceSubList.add(disDpriceSub);
        }
        this.saveDpriceSubBatchModel(disDpriceSubList);
        return code;
    }

    @Override
    public void updateDpriceSubState(Integer dpriceSubId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dpriceSubId) {
            return;
        }
        this.updateStateDpriceSubModel(dpriceSubId, dataState, oldDataState, map);
    }

    @Override
    public void updateDpriceSubStateByCode(String tenantCode, String dpriceSubCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dpriceSubCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDpriceSubModelByCode(tenantCode, dpriceSubCode, dataState, oldDataState, map);
    }

    @Override
    public void updateDpriceSub(DisDpriceSubDomain disDpriceSubDomain) throws ApiException {
        String msg = this.checkDpriceSub(disDpriceSubDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.disDpriceSubServiceImpl.updateDpriceSub.checkDpriceSub", msg);
        }
        DisDpriceSub olddisDpriceSub = this.getDpriceSubModelById(disDpriceSubDomain.getDpriceSubId());
        if (null == olddisDpriceSub) {
            throw new ApiException("dis.disDpriceSubServiceImpl.updateDpriceSub.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDpriceSub disDpriceSub = this.makeDpriceSub(disDpriceSubDomain, olddisDpriceSub);
        this.setDpriceSubUpdataDefault(disDpriceSub);
        this.updateDpriceSubModel(disDpriceSub);
    }

    @Override
    public DisDpriceSub getDpriceSub(Integer dpriceSubId) {
        if (null == dpriceSubId) {
            return null;
        }
        return this.getDpriceSubModelById(dpriceSubId);
    }

    @Override
    public void deleteDpriceSub(Integer dpriceSubId) throws ApiException {
        if (null == dpriceSubId) {
            return;
        }
        this.deleteDpriceSubModel(dpriceSubId);
        DisDpriceSub disDpriceSub = this.getDpriceSub(dpriceSubId);
        this.loadDisDpriceSubCache(disDpriceSub.getDpriceCode(), disDpriceSub.getTenantCode());
    }

    private void loadDisDpriceSubCache(String dpriceCode, String tenantCode) {
        this.logger.error("dis.disDpriceSubServiceImpl.saveDisDpriceSubCache.params", (Object)("dpriceCode:" + dpriceCode));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dpriceCode", dpriceCode);
        params.put("dataState", DistributionConstants.PRICE_SUB_STATE_1);
        params.put("tenantCode", tenantCode);
        List<DisDpriceSub> disDpriceSubList = this.disDpriceSubMapper.query(params);
        DisUtil.setMapVer((String)this.cacheSubKey, (String)this.getCacheFieldKey(dpriceCode, tenantCode), (String)JsonUtil.buildNormalBinder().toJson(disDpriceSubList));
        this.logger.error("dis.disDpriceSubServiceImpl.saveDisDpriceSubCache.desc", (Object)"\u66f4\u65b0\u4ef7\u683c\u7ec4\u7f13\u5b58\u7ed3\u675f");
    }

    @Override
    public QueryResult<DisDpriceSub> queryDpriceSubPage(Map<String, Object> map) {
        List<DisDpriceSub> disDpriceSubList = this.queryDpriceSubModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDpriceSub(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDpriceSubList);
        return queryResult;
    }

    @Override
    public DisDpriceSub getDpriceSubByCode(String tenantCode, String dpriceSubCode) throws ApiException {
        if (StringUtils.isBlank((String)dpriceSubCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceSubCode", dpriceSubCode);
        return this.getDpriceSubModelByCode(map);
    }

    @Override
    public void deleteDpriceSubByCode(String tenantCode, String dpriceSubCode) throws ApiException {
        if (StringUtils.isBlank((String)dpriceSubCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceSubCode", dpriceSubCode);
        this.delDpriceSubModelByCode(map);
    }

    private void saveDisDpriceSubCache(String dpriceCode, String tenantCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dpriceCode", dpriceCode);
        params.put("tenantCode", tenantCode);
        List<DisDpriceSub> disDpriceSubList = this.disDpriceSubMapper.query(params);
        DisUtil.setMapVer((String)this.cachekey, (String)this.getCacheFieldKey(dpriceCode, tenantCode), (String)JsonUtil.buildNormalBinder().toJson(disDpriceSubList));
    }

    private void updateDisDpriceSubCache() {
    }

    private String getCacheFieldKey(DisDpriceSubDomain disDpriceSub) {
        return this.getCacheFieldKey(disDpriceSub.getChannelCode(), disDpriceSub.getTenantCode());
    }

    private String getCacheFieldKey(String channelCode, String tenantCode) {
        return channelCode + "-" + tenantCode;
    }
}

