/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisChannelPlistMapper;
import com.yqbsoft.laser.service.distribution.domain.DisChannelPlistDomain;
import com.yqbsoft.laser.service.distribution.domain.DisChannelPlistReDomain;
import com.yqbsoft.laser.service.distribution.model.DisChannelPlist;
import com.yqbsoft.laser.service.distribution.service.DisChannelPlistService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisChannelPlistServiceImpl
extends BaseServiceImpl
implements DisChannelPlistService {
    private static final String SYS_CODE = "dis.DisChannelPlistServiceImpl";
    private DisChannelPlistMapper disChannelPlistMapper;

    public void setDisChannelPlistMapper(DisChannelPlistMapper disChannelPlistMapper) {
        this.disChannelPlistMapper = disChannelPlistMapper;
    }

    private Date getSysDate() {
        try {
            return this.disChannelPlistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelPlistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkChannelPlist(DisChannelPlistDomain disChannelPlistDomain) {
        if (null == disChannelPlistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disChannelPlistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setChannelPlistDefault(DisChannelPlist disChannelPlist) {
        if (null == disChannelPlist) {
            return;
        }
        if (null == disChannelPlist.getDataState()) {
            disChannelPlist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disChannelPlist.getGmtCreate()) {
            disChannelPlist.setGmtCreate(date);
        }
        disChannelPlist.setGmtModified(date);
        if (StringUtils.isBlank((String)disChannelPlist.getChannelPlistCode())) {
            disChannelPlist.setChannelPlistCode(this.getNo(null, "DisChannelPlist", "disChannelPlist", disChannelPlist.getTenantCode()));
        }
    }

    private int getChannelPlistMaxCode() {
        int code = 0;
        try {
            return this.disChannelPlistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelPlistServiceImpl.getChannelPlistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setChannelPlistUpdataDefault(DisChannelPlist disChannelPlist) {
        if (null == disChannelPlist) {
            return;
        }
        disChannelPlist.setGmtModified(this.getSysDate());
    }

    private void saveChannelPlistModel(DisChannelPlist disChannelPlist) throws ApiException {
        if (null == disChannelPlist) {
            return;
        }
        try {
            this.disChannelPlistMapper.insert(disChannelPlist);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.saveChannelPlistModel.ex", (Throwable)e);
        }
    }

    private void saveChannelPlistBatchModel(List<DisChannelPlist> disChannelPlistList) throws ApiException {
        if (null == disChannelPlistList || disChannelPlistList.isEmpty()) {
            return;
        }
        try {
            this.disChannelPlistMapper.insertBatch(disChannelPlistList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.saveChannelPlistBatchModel.ex", (Throwable)e);
        }
    }

    private DisChannelPlist getChannelPlistModelById(Integer channelPlistId) {
        if (null == channelPlistId) {
            return null;
        }
        try {
            return this.disChannelPlistMapper.selectByPrimaryKey(channelPlistId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelPlistServiceImpl.getChannelPlistModelById", (Throwable)e);
            return null;
        }
    }

    private DisChannelPlist getChannelPlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disChannelPlistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelPlistServiceImpl.getChannelPlistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delChannelPlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disChannelPlistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.delChannelPlistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.delChannelPlistModelByCode.num");
        }
    }

    private void deleteChannelPlistModel(Integer channelPlistId) throws ApiException {
        if (null == channelPlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.disChannelPlistMapper.deleteByPrimaryKey(channelPlistId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.deleteChannelPlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.deleteChannelPlistModel.num");
        }
    }

    private void updateChannelPlistModel(DisChannelPlist disChannelPlist) throws ApiException {
        if (null == disChannelPlist) {
            return;
        }
        int i = 0;
        try {
            i = this.disChannelPlistMapper.updateByPrimaryKey(disChannelPlist);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.updateChannelPlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.updateChannelPlistModel.num");
        }
    }

    private void updateStateChannelPlistModel(Integer channelPlistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == channelPlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelPlistId", channelPlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disChannelPlistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.updateStateChannelPlistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.updateStateChannelPlistModel.null");
        }
    }

    private void updateStateChannelPlistModelByCode(String tenantCode, String channelPlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)channelPlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelPlistCode", channelPlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disChannelPlistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.updateStateChannelPlistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.updateStateChannelPlistModelByCode.null");
        }
    }

    private DisChannelPlist makeChannelPlist(DisChannelPlistDomain disChannelPlistDomain, DisChannelPlist disChannelPlist) {
        if (null == disChannelPlistDomain) {
            return null;
        }
        if (null == disChannelPlist) {
            disChannelPlist = new DisChannelPlist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disChannelPlist, (Object)disChannelPlistDomain);
            return disChannelPlist;
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelPlistServiceImpl.makeChannelPlist", (Throwable)e);
            return null;
        }
    }

    private DisChannelPlistReDomain makeDisChannelPlistReDomain(DisChannelPlist disChannelPlist) {
        if (null == disChannelPlist) {
            return null;
        }
        DisChannelPlistReDomain disChannelPlistReDomain = new DisChannelPlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disChannelPlistReDomain, (Object)disChannelPlist);
            return disChannelPlistReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelPlistServiceImpl.makeDisChannelPlistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisChannelPlist> queryChannelPlistModelPage(Map<String, Object> parammap) {
        try {
            return this.disChannelPlistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelPlistServiceImpl.queryChannelPlistModel", (Throwable)e);
            return null;
        }
    }

    private int countChannelPlist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disChannelPlistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelPlistServiceImpl.countChannelPlist", (Throwable)e);
        }
        return i;
    }

    private DisChannelPlist createDisChannelPlist(DisChannelPlistDomain disChannelPlistDomain) {
        String msg = this.checkChannelPlist(disChannelPlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.saveChannelPlist.checkChannelPlist", msg);
        }
        DisChannelPlist disChannelPlist = this.makeChannelPlist(disChannelPlistDomain, null);
        this.setChannelPlistDefault(disChannelPlist);
        return disChannelPlist;
    }

    @Override
    public String saveChannelPlist(DisChannelPlistDomain disChannelPlistDomain) throws ApiException {
        DisChannelPlist disChannelPlist = this.createDisChannelPlist(disChannelPlistDomain);
        this.saveChannelPlistModel(disChannelPlist);
        return disChannelPlist.getChannelPlistCode();
    }

    @Override
    public String saveChannelPlistBatch(List<DisChannelPlistDomain> disChannelPlistDomainList) throws ApiException {
        if (null == disChannelPlistDomainList || disChannelPlistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisChannelPlist> disChannelPlistList = new ArrayList<DisChannelPlist>();
        String code = "";
        for (DisChannelPlistDomain disChannelPlistDomain : disChannelPlistDomainList) {
            DisChannelPlist disChannelPlist = this.createDisChannelPlist(disChannelPlistDomain);
            code = disChannelPlist.getChannelPlistCode();
            disChannelPlistList.add(disChannelPlist);
        }
        this.saveChannelPlistBatchModel(disChannelPlistList);
        return code;
    }

    @Override
    public void updateChannelPlistState(Integer channelPlistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == channelPlistId) {
            return;
        }
        this.updateStateChannelPlistModel(channelPlistId, dataState, oldDataState, map);
    }

    @Override
    public void updateChannelPlistStateByCode(String tenantCode, String channelPlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)channelPlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateChannelPlistModelByCode(tenantCode, channelPlistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateChannelPlist(DisChannelPlistDomain disChannelPlistDomain) throws ApiException {
        String msg = this.checkChannelPlist(disChannelPlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.updateChannelPlist.checkChannelPlist", msg);
        }
        DisChannelPlist oldDisChannelPlist = this.getChannelPlistModelById(disChannelPlistDomain.getChannelPlistId());
        if (null == oldDisChannelPlist) {
            throw new ApiException("dis.DisChannelPlistServiceImpl.updateChannelPlist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisChannelPlist disChannelPlist = this.makeChannelPlist(disChannelPlistDomain, oldDisChannelPlist);
        this.setChannelPlistUpdataDefault(disChannelPlist);
        this.updateChannelPlistModel(disChannelPlist);
    }

    @Override
    public DisChannelPlist getChannelPlist(Integer channelPlistId) {
        if (null == channelPlistId) {
            return null;
        }
        return this.getChannelPlistModelById(channelPlistId);
    }

    @Override
    public void deleteChannelPlist(Integer channelPlistId) throws ApiException {
        if (null == channelPlistId) {
            return;
        }
        this.deleteChannelPlistModel(channelPlistId);
    }

    @Override
    public QueryResult<DisChannelPlist> queryChannelPlistPage(Map<String, Object> map) {
        List<DisChannelPlist> disChannelPlistList = this.queryChannelPlistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelPlist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disChannelPlistList);
        return queryResult;
    }

    @Override
    public DisChannelPlist getChannelPlistByCode(String tenantCode, String channelPlistCode) throws ApiException {
        if (StringUtils.isBlank((String)channelPlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelPlistCode", channelPlistCode);
        return this.getChannelPlistModelByCode(map);
    }

    @Override
    public void deleteChannelPlistByCode(String tenantCode, String channelPlistCode) throws ApiException {
        if (StringUtils.isBlank((String)channelPlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelPlistCode", channelPlistCode);
        this.delChannelPlistModelByCode(map);
    }
}

