/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.DistributionConstants;
import com.yqbsoft.laser.service.distribution.dao.DisDpriceConfMapper;
import com.yqbsoft.laser.service.distribution.dao.DisDpriceConfbakMapper;
import com.yqbsoft.laser.service.distribution.dao.DisDpriceMapper;
import com.yqbsoft.laser.service.distribution.dao.DisDpriceSubMapper;
import com.yqbsoft.laser.service.distribution.domain.ActCommonDomain;
import com.yqbsoft.laser.service.distribution.domain.ActSubmitDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceConfDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceConfReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceConfbakDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceConfbakReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDpriceSubDomain;
import com.yqbsoft.laser.service.distribution.model.DisChannel;
import com.yqbsoft.laser.service.distribution.model.DisDprice;
import com.yqbsoft.laser.service.distribution.model.DisDpriceConf;
import com.yqbsoft.laser.service.distribution.model.DisDpriceConfbak;
import com.yqbsoft.laser.service.distribution.model.DisDpriceSub;
import com.yqbsoft.laser.service.distribution.service.DisChannelService;
import com.yqbsoft.laser.service.distribution.service.DisChannelsendBaseService;
import com.yqbsoft.laser.service.distribution.service.DisDpriceService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DisDpriceServiceImpl
extends BaseServiceImpl
implements DisDpriceService {
    private static final String SYS_CODE = "dis.DisDpriceServiceImpl";
    private DisDpriceMapper disDpriceMapper;
    private DisDpriceConfMapper disDpriceConfMapper;
    private DisDpriceConfbakMapper disDpriceConfbakMapper;
    private DisChannelService disChannelService;
    private DisDpriceSubMapper disDpriceSubMapper;
    private String cachekey = "DisDpriceConf-channelCode";
    DisChannelsendBaseService disChannelsendBaseService;

    public void setDisChannelService(DisChannelService disChannelService) {
        this.disChannelService = disChannelService;
    }

    public void setDisDpriceMapper(DisDpriceMapper disDpriceMapper) {
        this.disDpriceMapper = disDpriceMapper;
    }

    public void setDisDpriceConfMapper(DisDpriceConfMapper disDpriceConfMapper) {
        this.disDpriceConfMapper = disDpriceConfMapper;
    }

    public void setDisDpriceConfbakMapper(DisDpriceConfbakMapper disDpriceConfbakMapper) {
        this.disDpriceConfbakMapper = disDpriceConfbakMapper;
    }

    public void setDisDpriceSubMapper(DisDpriceSubMapper disDpriceSubMapper) {
        this.disDpriceSubMapper = disDpriceSubMapper;
    }

    private Date getSysDate() {
        try {
            return this.disDpriceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDprice(DisDpriceDomain disDpriceDomain) {
        if (null == disDpriceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDpriceDomain.getChannelCode())) {
            msg = msg + "ChannelCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disDpriceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDpriceDefault(DisDprice disDprice) {
        if (null == disDprice) {
            return;
        }
        if (null == disDprice.getDataState()) {
            disDprice.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDprice.getGmtCreate()) {
            disDprice.setGmtCreate(date);
        }
        disDprice.setGmtModified(date);
        if (StringUtils.isBlank((String)disDprice.getDpriceCode())) {
            disDprice.setDpriceCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
            disDprice.setChannelCode("all");
        }
        if (null != disDprice.getDpriceSydate() && disDprice.getDpriceSydate().getTime() > date.getTime()) {
            disDprice.setDataState(2);
        } else if (null != disDprice.getDpriceSydate() && disDprice.getDpriceSydate().getTime() <= date.getTime()) {
            disDprice.setDataState(1);
        }
        if (null != disDprice.getDpriceEydate() && disDprice.getDpriceEydate().getTime() <= date.getTime()) {
            disDprice.setDataState(-1);
        }
    }

    private int getDpriceMaxCode() {
        int code = 0;
        try {
            return this.disDpriceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDpriceUpdataDefault(DisDprice disDprice) {
        if (null == disDprice) {
            return;
        }
        Date date = this.getSysDate();
        disDprice.setGmtModified(date);
        if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
            disDprice.setChannelCode("all");
        }
        disDprice.setDataState(0);
        if (null != disDprice.getDpriceEydate() && disDprice.getDpriceEydate().getTime() <= date.getTime()) {
            disDprice.setDataState(-1);
        }
    }

    private void saveDpriceModel(DisDprice disDprice) throws ApiException {
        if (null == disDprice) {
            return;
        }
        try {
            this.disDpriceMapper.insert(disDprice);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceModel.ex", (Throwable)e);
        }
    }

    public void saveDpriceBatchModel(List<DisDprice> disDpriceList) throws ApiException {
        if (null == disDpriceList || disDpriceList.isEmpty()) {
            return;
        }
        try {
            this.disDpriceMapper.insertBatch(disDpriceList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceBatchModel.ex", (Throwable)e);
        }
    }

    private DisDprice getDpriceModelById(Integer dpriceId) {
        if (null == dpriceId) {
            return null;
        }
        try {
            return this.disDpriceMapper.selectByPrimaryKey(dpriceId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceModelById", (Throwable)e);
            return null;
        }
    }

    private DisDprice getDpriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDpriceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDpriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceModelByCode.num");
        }
    }

    public void delDpriceModelByDgoodesCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.disDpriceMapper.deleteByDgGoodsCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceModelByDgoodesCode.ex", (Throwable)e);
        }
    }

    private void deleteDpriceModel(Integer dpriceId) throws ApiException {
        if (null == dpriceId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceMapper.deleteByPrimaryKey(dpriceId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.deleteDpriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.deleteDpriceModel.num");
        }
    }

    private void updateDpriceModel(DisDprice disDprice) throws ApiException {
        if (null == disDprice) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceMapper.updateByPrimaryKeySelective(disDprice);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceModel.num");
        }
    }

    private void updateStateDpriceModel(Integer dpriceId, Integer dataState, Integer oldDataState, Integer channelVer) throws ApiException {
        if (null == dpriceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceId", dpriceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("channelVer", channelVer);
        int i = 0;
        try {
            i = this.disDpriceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceModel.null");
        }
    }

    private void updateStateDpriceModelByCode(String tenantCode, String dpriceCode, Integer dataState, Integer oldDataState, Integer channelVer) throws ApiException {
        if (StringUtils.isBlank((String)dpriceCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceCode", dpriceCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("channelVer", channelVer);
        int i = 0;
        try {
            i = this.disDpriceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceModelByCode.null");
        }
    }

    private DisDprice makeDprice(DisDpriceDomain disDpriceDomain, DisDprice disDprice) {
        if (null == disDpriceDomain) {
            return null;
        }
        if (null == disDprice) {
            disDprice = new DisDprice();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDprice, (Object)disDpriceDomain);
            return disDprice;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.makeDprice", (Throwable)e);
            return null;
        }
    }

    private DisDpriceReDomain makeDisDpriceReDomain(DisDprice disDprice) {
        if (null == disDprice) {
            return null;
        }
        DisDpriceReDomain disDpriceReDomain = new DisDpriceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceReDomain, (Object)disDprice);
            return disDpriceReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.makeDisDpriceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDprice> queryDpriceModelPage(Map<String, Object> parammap) {
        try {
            return this.disDpriceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.queryDpriceModel", (Throwable)e);
            return null;
        }
    }

    private int countDprice(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDpriceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.countDprice", (Throwable)e);
        }
        return i;
    }

    private DisDprice createDisDprice(DisDpriceDomain disDpriceDomain) {
        String msg = this.checkDprice(disDpriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDprice.checkDprice", msg);
        }
        DisDprice disDprice = this.makeDprice(disDpriceDomain, null);
        this.setDpriceDefault(disDprice);
        return disDprice;
    }

    private String checkDpriceConf(DisDpriceConfDomain disDpriceConfDomain) {
        if (null == disDpriceConfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDpriceConfDomain.getDpriceConfType())) {
            msg = msg + "DpriceConfType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)disDpriceConfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDpriceConfDefault(DisDpriceConf disDpriceConf) {
        if (null == disDpriceConf) {
            return;
        }
        if (null == disDpriceConf.getDataState()) {
            disDpriceConf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDpriceConf.getGmtCreate()) {
            disDpriceConf.setGmtCreate(date);
        }
        disDpriceConf.setGmtModified(date);
        if (StringUtils.isBlank((String)disDpriceConf.getDpriceConfCode())) {
            disDpriceConf.setDpriceConfCode(this.createUUIDString());
        }
    }

    private int getDpriceConfMaxCode() {
        int code = 0;
        try {
            return this.disDpriceConfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceConfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDpriceConfUpdataDefault(DisDpriceConf disDpriceConf) {
        if (null == disDpriceConf) {
            return;
        }
        disDpriceConf.setGmtModified(this.getSysDate());
    }

    private void saveDpriceConfModel(DisDpriceConf disDpriceConf) throws ApiException {
        if (null == disDpriceConf) {
            return;
        }
        try {
            this.disDpriceConfMapper.insert(disDpriceConf);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConfModel.ex", (Throwable)e);
        }
    }

    private void saveDpriceConfBatchModel(List<DisDpriceConf> disDpriceConfList) throws ApiException {
        if (null == disDpriceConfList || disDpriceConfList.isEmpty()) {
            return;
        }
        try {
            this.disDpriceConfMapper.insertBatch(disDpriceConfList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConfBatchModel.ex", (Throwable)e);
        }
    }

    private DisDpriceConf getDpriceConfModelById(Integer dpriceConfId) {
        if (null == dpriceConfId) {
            return null;
        }
        try {
            return this.disDpriceConfMapper.selectByPrimaryKey(dpriceConfId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceConfModelById", (Throwable)e);
            return null;
        }
    }

    private DisDpriceConf getDpriceConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDpriceConfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceConfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDpriceConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceConfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceConfModelByCode.num");
        }
    }

    private void deleteDpriceConfModel(Integer dpriceConfId) throws ApiException {
        if (null == dpriceConfId) {
            return;
        }
        try {
            this.disDpriceConfMapper.deleteByPrimaryKey(dpriceConfId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.deleteDpriceConfModel.ex", (Throwable)e);
        }
    }

    private void updateDpriceConfModel(DisDpriceConf disDpriceConf) throws ApiException {
        if (null == disDpriceConf) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfMapper.updateByPrimaryKeySelective(disDpriceConf);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfModel.num");
        }
    }

    private void updateDpriceSubModel(DisDpriceSub disDpriceSub) throws ApiException {
        if (null == disDpriceSub) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceSubMapper.updateByPrimaryKeySelective(disDpriceSub);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfModel.num");
        }
    }

    private void updateStateDpriceConfModel(Integer dpriceConfId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == dpriceConfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceConfId", dpriceConfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDpriceConfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfModel.null");
        }
    }

    private void updateStateDpriceConfModelByCode(String tenantCode, String dpriceConfCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)dpriceConfCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfCode", dpriceConfCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDpriceConfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfModelByCode.null");
        }
    }

    private DisDpriceConf makeDpriceConf(DisDpriceConfDomain disDpriceConfDomain, DisDpriceConf disDpriceConf) {
        if (null == disDpriceConfDomain) {
            return null;
        }
        if (null == disDpriceConf) {
            disDpriceConf = new DisDpriceConf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceConf, (Object)disDpriceConfDomain);
            return disDpriceConf;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.makeDpriceConf", (Throwable)e);
            return null;
        }
    }

    private DisDpriceConfReDomain makeDisDpriceConfReDomain(DisDpriceConf disDpriceConf) {
        if (null == disDpriceConf) {
            return null;
        }
        DisDpriceConfReDomain disDpriceConfReDomain = new DisDpriceConfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceConfReDomain, (Object)disDpriceConf);
            return disDpriceConfReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.makeDisDpriceConfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDpriceConf> queryDpriceConfModelPage(Map<String, Object> parammap) {
        try {
            return this.disDpriceConfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.queryDpriceConfModel", (Throwable)e);
            return null;
        }
    }

    private List<DisDpriceSub> queryDpriceSubModelPage(Map<String, Object> parammap) {
        try {
            return this.disDpriceSubMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.queryDpriceConfModel", (Throwable)e);
            return null;
        }
    }

    private int countDpriceConf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDpriceConfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.countDpriceConf", (Throwable)e);
        }
        return i;
    }

    private DisDpriceConf createDisDpriceConf(DisDpriceConfDomain disDpriceConfDomain) {
        String msg = this.checkDpriceConf(disDpriceConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConf.checkDpriceConf", msg);
        }
        DisDpriceConf disDpriceConf = this.makeDpriceConf(disDpriceConfDomain, null);
        this.setDpriceConfDefault(disDpriceConf);
        return disDpriceConf;
    }

    private String checkDpriceConfbak(DisDpriceConfbakDomain disDpriceConfbakDomain) {
        if (null == disDpriceConfbakDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDpriceConfbakDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDpriceConfbakDefault(DisDpriceConfbak disDpriceConfbak) {
        if (null == disDpriceConfbak) {
            return;
        }
        if (null == disDpriceConfbak.getDataState()) {
            disDpriceConfbak.setDataState(0);
        }
        if (null == disDpriceConfbak.getGmtCreate()) {
            disDpriceConfbak.setGmtCreate(this.getSysDate());
        }
        disDpriceConfbak.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)disDpriceConfbak.getDpriceConfbakCode())) {
            disDpriceConfbak.setDpriceConfbakCode(this.createUUIDString());
        }
    }

    private int getDpriceConfbakMaxCode() {
        int code = 0;
        try {
            return this.disDpriceConfbakMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceConfbakMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDpriceConfbakUpdataDefault(DisDpriceConfbak disDpriceConfbak) {
        if (null == disDpriceConfbak) {
            return;
        }
        disDpriceConfbak.setGmtModified(this.getSysDate());
    }

    private void saveDpriceConfbakModel(DisDpriceConfbak disDpriceConfbak) throws ApiException {
        if (null == disDpriceConfbak) {
            return;
        }
        try {
            this.disDpriceConfbakMapper.insert(disDpriceConfbak);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConfbakModel.ex", (Throwable)e);
        }
    }

    private void saveDpriceConfbakBatchModel(List<DisDpriceConfbak> disDpriceConfbakList) throws ApiException {
        if (null == disDpriceConfbakList || disDpriceConfbakList.isEmpty()) {
            return;
        }
        try {
            this.disDpriceConfbakMapper.insertBatch(disDpriceConfbakList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConfbakBatchModel.ex", (Throwable)e);
        }
    }

    private DisDpriceConfbak getDpriceConfbakModelById(Integer dpriceConfbakId) {
        if (null == dpriceConfbakId) {
            return null;
        }
        try {
            return this.disDpriceConfbakMapper.selectByPrimaryKey(dpriceConfbakId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceConfbakModelById", (Throwable)e);
            return null;
        }
    }

    private DisDpriceConfbak getDpriceConfbakModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDpriceConfbakMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDpriceConfbakModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDpriceConfbakModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfbakMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceConfbakModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.delDpriceConfbakModelByCode.num");
        }
    }

    private void deleteDpriceConfbakModel(Integer dpriceConfbakId) throws ApiException {
        if (null == dpriceConfbakId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfbakMapper.deleteByPrimaryKey(dpriceConfbakId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.deleteDpriceConfbakModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.deleteDpriceConfbakModel.num");
        }
    }

    private void updateDpriceConfbakModel(DisDpriceConfbak disDpriceConfbak) throws ApiException {
        if (null == disDpriceConfbak) {
            return;
        }
        int i = 0;
        try {
            i = this.disDpriceConfbakMapper.updateByPrimaryKeySelective(disDpriceConfbak);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfbakModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfbakModel.num");
        }
    }

    private void updateStateDpriceConfbakModel(Integer dpriceConfbakId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == dpriceConfbakId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceConfbakId", dpriceConfbakId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDpriceConfbakMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfbakModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfbakModel.null");
        }
    }

    private void updateStateDpriceConfbakModelByCode(String tenantCode, String dpriceConfbakCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)dpriceConfbakCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfbakCode", dpriceConfbakCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disDpriceConfbakMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfbakModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceConfbakModelByCode.null");
        }
    }

    private DisDpriceConfbak makeDpriceConfbak(DisDpriceConfbakDomain disDpriceConfbakDomain, DisDpriceConfbak disDpriceConfbak) {
        if (null == disDpriceConfbakDomain) {
            return null;
        }
        if (null == disDpriceConfbak) {
            disDpriceConfbak = new DisDpriceConfbak();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceConfbak, (Object)disDpriceConfbakDomain);
            return disDpriceConfbak;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.makeDpriceConfbak", (Throwable)e);
            return null;
        }
    }

    private DisDpriceConfbakReDomain makeDisDpriceConfbakReDomain(DisDpriceConfbak disDpriceConfbak) {
        if (null == disDpriceConfbak) {
            return null;
        }
        DisDpriceConfbakReDomain disDpriceConfbakReDomain = new DisDpriceConfbakReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceConfbakReDomain, (Object)disDpriceConfbak);
            return disDpriceConfbakReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.makeDisDpriceConfbakReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDpriceConfbak> queryDpriceConfbakModelPage(Map<String, Object> parammap) {
        try {
            return this.disDpriceConfbakMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.queryDpriceConfbakModel", (Throwable)e);
            return null;
        }
    }

    private int countDpriceConfbak(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDpriceConfbakMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.countDpriceConfbak", (Throwable)e);
        }
        return i;
    }

    private DisDpriceConfbak createDisDpriceConfbak(DisDpriceConfbakDomain disDpriceConfbakDomain) {
        String msg = this.checkDpriceConfbak(disDpriceConfbakDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConfbak.checkDpriceConfbak", msg);
        }
        DisDpriceConfbak disDpriceConfbak = this.makeDpriceConfbak(disDpriceConfbakDomain, null);
        this.setDpriceConfbakDefault(disDpriceConfbak);
        return disDpriceConfbak;
    }

    @Override
    public String saveDprice(DisDpriceDomain disDpriceDomain) throws ApiException {
        DisDprice disDprice = this.createDisDprice(disDpriceDomain);
        this.saveDpriceModel(disDprice);
        String dpriceCode = disDprice.getDpriceCode();
        String tenantCode = disDprice.getTenantCode();
        List<DisDpriceConf> disDpriceConfList = disDpriceDomain.getDisDpriceConfList();
        if (ListUtil.isEmpty(disDpriceConfList)) {
            this.logger.error("dis.DisDpriceServiceImpl.saveDprice.size", (Object)JsonUtil.buildNormalBinder().toJson(disDpriceConfList));
        }
        if (ListUtil.isNotEmpty(disDpriceConfList)) {
            this.deleteDisPriceConfBypriceCode(dpriceCode, tenantCode);
            ArrayList<DisDpriceConf> list = new ArrayList<DisDpriceConf>();
            for (DisDpriceConf disDpriceConf : disDpriceConfList) {
                this.setDpriceConfDefault(disDpriceConf);
                disDpriceConf.setDpriceCode(disDprice.getDpriceCode());
                list.add(disDpriceConf);
            }
            this.logger.error("dis.DisDpriceServiceImpl.saveDprice.list.size", (Object)list.size());
            this.saveDpriceConfBatchModel(list);
            for (DisDpriceConf disDpriceConf : list) {
                this.updateDpriceConfCache(disDpriceConf);
            }
        }
        if (DistributionConstants.dataState_start.intValue() == disDprice.getDataState().intValue()) {
            this.updateDpriceCache(disDprice);
        }
        return disDprice.getDpriceCode();
    }

    @Override
    public String saveDpriceBatch(List<DisDpriceDomain> disDpriceDomainList) throws ApiException {
        if (null == disDpriceDomainList || disDpriceDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        for (DisDpriceDomain disDpriceDomain : disDpriceDomainList) {
            code = this.saveDprice(disDpriceDomain);
        }
        return code;
    }

    @Override
    public void updateDpriceState(Integer dpriceId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateDpriceState(dpriceId, dataState, oldDataState, null);
    }

    public void updateDpriceState(Integer dpriceId, Integer dataState, Integer oldDataState, Integer channelVer) throws ApiException {
        this.updateStateDpriceModel(dpriceId, dataState, oldDataState, channelVer);
        if (DistributionConstants.dataState_start.intValue() != dataState.intValue()) {
            DisDprice disDprice = this.getDprice(dpriceId);
            this.deleteDpriceCache(disDprice);
        } else if (DistributionConstants.dataState_start.intValue() == dataState.intValue()) {
            DisDprice disDprice = this.getDprice(dpriceId);
            this.updateDpriceCache(disDprice);
        }
    }

    public void updateDpriceStateByCode(String tenantCode, String dpriceCode, Integer dataState, Integer oldDataState, Integer channelVer) throws ApiException {
        this.updateStateDpriceModelByCode(tenantCode, dpriceCode, dataState, oldDataState, channelVer);
        if (DistributionConstants.dataState_start.intValue() != dataState.intValue()) {
            DisDprice disDprice = this.getDpriceByCode(tenantCode, dpriceCode);
            this.deleteDpriceCache(disDprice);
        } else if (DistributionConstants.dataState_start.intValue() == dataState.intValue()) {
            DisDprice disDprice = this.getDpriceByCode(tenantCode, dpriceCode);
            this.updateDpriceCache(disDprice);
        }
    }

    @Override
    public void updateDpriceStateByCode(String tenantCode, String dpriceCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateDpriceStateByCode(tenantCode, dpriceCode, dataState, oldDataState, null);
    }

    @Override
    public void updateDprice(DisDpriceDomain disDpriceDomain) throws ApiException {
        String msg = this.checkDprice(disDpriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDprice.checkDprice", msg);
        }
        DisDprice oldDisDprice = this.getDpriceModelById(disDpriceDomain.getDpriceId());
        if (null == oldDisDprice) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDprice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDprice disDprice = this.makeDprice(disDpriceDomain, oldDisDprice);
        this.setDpriceUpdataDefault(disDprice);
        List<DisDpriceConf> disDpriceConfList = disDpriceDomain.getDisDpriceConfList();
        if (ListUtil.isNotEmpty(disDpriceConfList)) {
            this.deleteDisPriceConfBypriceCode(oldDisDprice.getDpriceCode(), oldDisDprice.getTenantCode());
            this.saveDpriceConfBatchModel(disDpriceConfList);
            for (DisDpriceConf disDpriceConf : disDpriceConfList) {
                this.updateDpriceConfCache(disDpriceConf);
            }
        }
        this.updateDpriceModel(disDprice);
        oldDisDprice = this.getDpriceModelById(disDpriceDomain.getDpriceId());
        if (null == oldDisDprice) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDprice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (oldDisDprice.getDataState().intValue() == DistributionConstants.dataState_start.intValue()) {
            this.updateDpriceCache(oldDisDprice);
        } else {
            this.deleteDpriceCache(oldDisDprice);
        }
    }

    @Override
    public DisDprice getDprice(Integer dpriceId) {
        DisDprice dpriceModelById = this.getDpriceModelById(dpriceId);
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dpriceCode", dpriceModelById.getDpriceCode());
        parammap.put("tenantCode", dpriceModelById.getTenantCode());
        List<DisDpriceConf> disDpriceConfs = this.queryDpriceConfModelPage(parammap);
        dpriceModelById.setDisDpriceConfList(disDpriceConfs);
        return dpriceModelById;
    }

    private void deleteDisPriceConfBypriceCode(String dpriceCode, String tenantCode) {
        if (StringUtils.isBlank((String)dpriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceCode", dpriceCode);
        map.put("tenantCode", tenantCode);
        this.disDpriceConfMapper.deleteDisPriceConfBypriceCode(map);
    }

    @Override
    public void deleteDprice(Integer dpriceId) throws ApiException {
        DisDprice disDprice = this.getDprice(dpriceId);
        this.deleteDpriceModel(dpriceId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceCode", disDprice.getDpriceCode());
        map.put("tenantCode", disDprice.getTenantCode());
        List<DisDpriceConf> disDpriceConfs = this.queryDpriceConfModelPage(map);
        if (ListUtil.isNotEmpty(disDpriceConfs)) {
            for (DisDpriceConf disDpriceConf : disDpriceConfs) {
                this.deleteDpriceConf(disDpriceConf.getDpriceConfId());
            }
        }
        this.deleteDpriceCache(disDprice);
    }

    @Override
    public QueryResult<DisDprice> queryDpricePage(Map<String, Object> map) {
        this.logger.error("==1===", (Object)map.toString());
        List<DisDprice> disDpriceList = this.queryDpriceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDprice(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        if (ListUtil.isEmpty(disDpriceList)) {
            queryResult.setList(null);
            return queryResult;
        }
        for (DisDprice disDprice : disDpriceList) {
            disDprice.setDisDpriceConfList(this.queryDpriceConfModelPage(this.getQueryMapParam("dpriceCode,tenantCode", new Object[]{disDprice.getDpriceCode(), disDprice.getTenantCode()})));
        }
        queryResult.setList(disDpriceList);
        return queryResult;
    }

    @Override
    public DisDprice getDpriceByCode(String tenantCode, String dpriceCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceCode", dpriceCode);
        return this.getDpriceModelByCode(map);
    }

    @Override
    public void deleteDpriceByCode(String tenantCode, String dpriceCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceCode", dpriceCode);
        DisDprice disDprice = this.getDpriceByCode(tenantCode, dpriceCode);
        this.delDpriceModelByCode(map);
        List<DisDpriceConf> disDpriceConfs = this.queryDpriceConfModelPage(map);
        if (ListUtil.isNotEmpty(disDpriceConfs)) {
            for (DisDpriceConf disDpriceConf : disDpriceConfs) {
                this.deleteDpriceConf(disDpriceConf.getDpriceConfId());
            }
        }
        this.deleteDpriceCache(disDprice);
    }

    @Override
    public String saveDpriceConf(DisDpriceConfDomain disDpriceConfDomain) throws ApiException {
        DisDpriceConf disDpriceConf = this.createDisDpriceConf(disDpriceConfDomain);
        DisDprice disDprice = this.getDpriceByCode(disDpriceConf.getTenantCode(), disDpriceConf.getDpriceCode());
        if (null == disDprice) {
            throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConf.disDprice");
        }
        Integer channelVer = this.disChannelService.updateChannelVer(disDprice.getChannelCode(), disDprice.getTenantCode());
        this.updateStateDpriceModelByCode(disDprice.getTenantCode(), disDprice.getDpriceCode(), disDprice.getDataState(), disDprice.getDataState(), channelVer);
        this.saveDpriceConfModel(disDpriceConf);
        this.updateDpriceConfCache(disDpriceConf);
        return disDpriceConf.getDpriceConfCode();
    }

    @Override
    public String saveDpriceConfBatch(List<DisDpriceConfDomain> disDpriceConfDomainList) throws ApiException {
        if (null == disDpriceConfDomainList || disDpriceConfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDpriceConf> disDpriceConfList = new ArrayList<DisDpriceConf>();
        String code = "";
        String tenantCode = "";
        HashMap<String, String> map = new HashMap<String, String>();
        if (!"removeAll".equals(disDpriceConfDomainList.get(0).getDpriceConfValuen())) {
            for (DisDpriceConfDomain disDpriceConfDomain : disDpriceConfDomainList) {
                DisDpriceConf disDpriceConf = this.createDisDpriceConf(disDpriceConfDomain);
                code = disDpriceConf.getDpriceConfCode();
                disDpriceConfList.add(disDpriceConf);
                tenantCode = disDpriceConf.getTenantCode();
                map.put(disDpriceConf.getDpriceCode(), disDpriceConf.getDpriceCode());
            }
            this.saveDpriceConfBatchModel(disDpriceConfList);
            if (MapUtil.isNotEmpty(map)) {
                for (String key : map.keySet()) {
                    DisDprice disDprice = this.getDpriceByCode(tenantCode, key);
                    if (null == disDprice) {
                        throw new ApiException("dis.DisDpriceServiceImpl.saveDpriceConfBatch.disDprice");
                    }
                    Integer channelVer = this.disChannelService.updateChannelVer(disDprice.getChannelCode(), disDprice.getTenantCode());
                    this.updateStateDpriceModelByCode(disDprice.getTenantCode(), disDprice.getDpriceCode(), disDprice.getDataState(), disDprice.getDataState(), channelVer);
                }
            }
            for (DisDpriceConf disDpriceConf2 : disDpriceConfList) {
                this.updateDpriceConfCache(disDpriceConf2);
            }
            if ("2020050600004084".equals(disDpriceConfDomainList.get(0).getTenantCode())) {
                this.sendActiviti(disDpriceConfDomainList);
            }
        }
        return code;
    }

    private void sendActiviti(List<DisDpriceConfDomain> disDpriceConfDomainList) {
        StringBuffer skuCodeStr = new StringBuffer();
        StringBuffer codes = new StringBuffer();
        String auditRemark = disDpriceConfDomainList.get(0).getDpriceConfPicurl();
        for (DisDpriceConfDomain disDpriceConf : disDpriceConfDomainList) {
            disDpriceConf.setDpriceConfPicurl(null);
            skuCodeStr.append(disDpriceConf.getDpriceConfValueno());
            skuCodeStr.append(",");
            codes.append(disDpriceConf.getDpriceConfCode());
            codes.append(",");
        }
        HashMap<String, String> skuMap = new HashMap<String, String>();
        HashMap<String, String> skuMapStr = new HashMap<String, String>();
        skuMapStr.put("skuCodeStr", skuCodeStr.toString());
        skuMapStr.put("tenantCode", disDpriceConfDomainList.get(0).getTenantCode());
        skuMap.put("map", JsonUtil.buildNormalBinder().toJson(skuMapStr));
        String result = this.internalInvoke("rs.sku.querySkuOnePage", skuMap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("dis.DisDpriceServiceImpl.sendActivitiData.ex", "\u67e5\u8be2sku\u6570\u636e\u9519\u8bef\uff01\u53c2\u6570-" + JsonUtil.buildNormalBinder().toJson(skuMap));
        }
        QueryResult jsonToObject = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(result, QueryResult.class);
        String s = JsonUtil.buildNormalBinder().toJson((Object)jsonToObject.getList());
        HashMap<String, JSONObject> jsonObjectMap = new HashMap<String, JSONObject>();
        StringBuffer goodsCodeStr = new StringBuffer();
        HashMap<String, String> goodsReSku = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)result)) {
            JSONArray jsonObjects = JSONArray.json2array((String)s);
            for (JSONObject jsonObject : jsonObjects) {
                jsonObjectMap.put(jsonObject.getString("skuCode"), jsonObject);
                goodsCodeStr.append(jsonObject.getString("goodsCode"));
                goodsCodeStr.append(",");
                goodsReSku.put(jsonObject.getString("goodsCode"), jsonObject.getString("skuCode"));
            }
        }
        BigDecimal gjjlPrice = BigDecimal.ZERO;
        BigDecimal dqPrice = BigDecimal.ZERO;
        BigDecimal pqPrice = BigDecimal.ZERO;
        BigDecimal gjyzPrice = BigDecimal.ZERO;
        BigDecimal gjPrice = BigDecimal.ZERO;
        BigDecimal payPrice = BigDecimal.ZERO;
        int max = 0;
        String applyUserCode = "";
        String applyUserName = "";
        Map<String, String> skuProperty = this.getSkuProperty(goodsCodeStr.toString(), goodsReSku);
        for (DisDpriceConfDomain disDpriceConfDomain : disDpriceConfDomainList) {
            if (disDpriceConfDomain == null) continue;
            BigDecimal money = this.getPrice(disDpriceConfDomain);
            applyUserCode = disDpriceConfDomain.getUserCode();
            applyUserName = disDpriceConfDomain.getUserName();
            int index = 0;
            JSONObject jsonObject = (JSONObject)jsonObjectMap.get(disDpriceConfDomain.getDpriceConfValueno());
            if (jsonObject == null) {
                this.logger.error("dis.DisDpriceServiceImpl.sendActiviti.skuCode is null", (Object)disDpriceConfDomain.getDpriceConfValueno());
                continue;
            }
            if (jsonObject.getBigDecimal("pricesetBaseprice") != null && money.compareTo(jsonObject.getBigDecimal("pricesetBaseprice")) < 0) {
                index = 1;
            }
            if (jsonObject.getBigDecimal("pricesetAsprice") != null && money.compareTo(jsonObject.getBigDecimal("pricesetAsprice")) < 0) {
                index = 2;
            }
            if (jsonObject.getBigDecimal("pricesetPrefprice") != null && money.compareTo(jsonObject.getBigDecimal("pricesetPrefprice")) < 0) {
                index = 3;
            }
            if (jsonObject.getBigDecimal("pricesetInsideprice") != null && money.compareTo(jsonObject.getBigDecimal("pricesetInsideprice")) < 0) {
                index = 4;
            }
            if (jsonObject.getBigDecimal("goodsTopweight") != null && money.compareTo(jsonObject.getBigDecimal("goodsTopweight")) < 0) {
                index = 5;
            }
            if (index == 5) {
                gjjlPrice = jsonObject.getBigDecimal("pricesetBaseprice");
                dqPrice = jsonObject.getBigDecimal("pricesetAsprice");
                pqPrice = jsonObject.getBigDecimal("pricesetPrefprice");
                gjyzPrice = jsonObject.getBigDecimal("pricesetInsideprice");
                gjPrice = jsonObject.getBigDecimal("goodsTopweight");
                payPrice = money;
                break;
            }
            if (index < max) continue;
            max = index;
            gjjlPrice = jsonObject.getBigDecimal("pricesetBaseprice");
            dqPrice = jsonObject.getBigDecimal("pricesetAsprice");
            pqPrice = jsonObject.getBigDecimal("pricesetPrefprice");
            gjyzPrice = jsonObject.getBigDecimal("pricesetInsideprice");
            gjPrice = jsonObject.getBigDecimal("goodsTopweight");
            payPrice = money;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", disDpriceConfDomainList.get(0).getTenantCode());
        paramMap.put("colName", "DPRICE_CONF_CODE");
        paramMap.put("colValue", codes.toString());
        List confList = this.queryDpriceConfPage(paramMap).getList();
        for (DisDpriceConf disDpriceConf : confList) {
            this.updateStateDpriceConfModel(disDpriceConf.getDpriceConfId(), 13, disDpriceConf.getDataState());
            disDpriceConf.setDpriceConfPicurl(skuProperty.get(disDpriceConf.getDpriceConfValueno()));
        }
        DisDpriceConfDomain disDpriceConfDomain = disDpriceConfDomainList.get(0);
        DisDprice disDprice = this.getDpriceByCode(disDpriceConfDomain.getTenantCode(), disDpriceConfDomain.getDpriceCode());
        HashMap<String, String> actParamMap = new HashMap<String, String>();
        HashMap<String, Object> sendparamMap = new HashMap<String, Object>();
        ActCommonDomain actCommonDomain = new ActCommonDomain();
        actCommonDomain.setTenantCode(disDprice.getTenantCode());
        actCommonDomain.setBusinessKey(disDprice.getDpriceCode());
        actCommonDomain.setInterfaceType("DisDpriceDomain");
        actCommonDomain.setCallUrl("dis.dprice.updateAuditCall");
        actCommonDomain.setParamMap(sendparamMap);
        actCommonDomain.setStartUserType("1");
        actCommonDomain.setStartUser(disDprice.getMemberCode());
        actCommonDomain.setStartName(disDprice.getMemberName());
        actCommonDomain.setUserCode(disDprice.getMemberCode());
        sendparamMap.put("applyUserCode", applyUserCode);
        sendparamMap.put("applyUserName", applyUserName);
        sendparamMap.put("gjjlPrice", gjjlPrice);
        sendparamMap.put("pqPrice", pqPrice);
        sendparamMap.put("dqPrice", dqPrice);
        sendparamMap.put("gjyzPrice", gjyzPrice);
        sendparamMap.put("gjPrice", gjPrice);
        sendparamMap.put("payPrice", payPrice);
        sendparamMap.put("disDprice", disDprice);
        sendparamMap.put("confList", confList);
        sendparamMap.put("submitRemark", auditRemark);
        sendparamMap.put("title", disDprice.getDpriceId() + "-" + disDprice.getDpriceName());
        actParamMap.put("actCommonDomain", JsonUtil.buildNormalBinder().toJson((Object)actCommonDomain));
        this.internalInvoke("act.actCommonService.activateProcess", actParamMap);
    }

    private Map<String, String> getSkuProperty(String goodsCodeStr, Map<String, String> goodsReSku) {
        this.logger.error("log >>> desc:getSkuProperty{}{\u83b7\u53d6sku\u539f\u578b\u673a\u578b\u53f7\u5f00\u59cb }");
        this.logger.error("log >>> debug:getSkuProperty{goodsCodeStr}=====", (Object)goodsCodeStr);
        this.logger.error("log >>> debug:getSkuProperty{goodsReSku}=====", goodsReSku);
        return this.buildSkuProperty(goodsReSku, this.queryGoodsProperty(goodsCodeStr));
    }

    private Map<String, String> buildSkuProperty(Map<String, String> goodsReSku, Map<String, String> goodsProperty) {
        HashMap<String, String> skuProperty = new HashMap<String, String>();
        for (String key : goodsReSku.keySet()) {
            skuProperty.put(goodsReSku.get(key), goodsProperty.get(key));
        }
        this.logger.error("log >>> desc:getSkuProperty{}{\u83b7\u53d6sku\u539f\u578b\u673a\u578b\u53f7\u7ed3\u675f}", skuProperty);
        return skuProperty;
    }

    private Map<String, String> queryGoodsProperty(String goodsCodeStr) {
        if (StringUtils.isBlank((String)goodsCodeStr)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> skuMap = new HashMap<String, String>();
        HashMap<String, String> skuMapStr = new HashMap<String, String>();
        skuMapStr.put("goodsCode", goodsCodeStr);
        skuMap.put("map", JsonUtil.buildNormalBinder().toJson(skuMapStr));
        String result = this.internalInvoke("rs.resourceGoods.queryResourceGoodsPage", skuMap);
        QueryResult jsonToObject = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(result, QueryResult.class);
        String s = JsonUtil.buildNormalBinder().toJson((Object)jsonToObject.getList());
        HashMap<String, String> goodsValue = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)result)) {
            JSONArray jsonObjects = JSONArray.json2array((String)s);
            for (JSONObject jsonObject : jsonObjects) {
                goodsValue.put(jsonObject.getString("goodsCode"), jsonObject.getString("goodsProperty1"));
            }
        }
        return goodsValue;
    }

    private BigDecimal getPrice(DisDpriceConfDomain disDpriceConfDomain) {
        BigDecimal money = disDpriceConfDomain.getDpriceConfPrice();
        if (StringUtils.isBlank((String)disDpriceConfDomain.getDpriceConfDes())) {
            this.logger.error("dis.DisDpriceServiceImplgetPrice.desc", (Object)"getDpriceConfDes is null");
            return money;
        }
        String[] arr = disDpriceConfDomain.getDpriceConfDes().split(",");
        if (arr.length < 4) {
            return money;
        }
        if ("DDP\u4ef7\u683c".equals(arr[2])) {
            BigDecimal temp = BigDecimal.ONE;
            if (StringUtils.isNotBlank((String)arr[3])) {
                temp.add(new BigDecimal(arr[3]).divide(new BigDecimal(100)));
            }
            if (StringUtils.isNotBlank((String)arr[4])) {
                temp.add(new BigDecimal(arr[4]).divide(new BigDecimal(100)));
            }
            if (StringUtils.isNotBlank((String)arr[5])) {
                temp.add(new BigDecimal(arr[5]).divide(new BigDecimal(100)));
            }
            money = money.divide(temp, 2, 4);
        } else if (StringUtils.isNotBlank((String)arr[3])) {
            money = money.divide(new BigDecimal("0.13"), 2, 4);
            money = money.divide(new BigDecimal(arr[3]), 2, 4);
        }
        this.logger.error("dis.DisDpriceServiceImplgetPrice.money", (Object)money);
        return money;
    }

    @Override
    public void delDpriceConfByGoods(DisDpriceConfDomain disDpriceConfDomain) throws ApiException {
        if (null == disDpriceConfDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceCode", disDpriceConfDomain.getDpriceCode());
        map.put("dpriceConfType", disDpriceConfDomain.getDpriceConfType());
        map.put("dpriceConfValue", disDpriceConfDomain.getDpriceConfValue());
        map.put("tenantCode", disDpriceConfDomain.getTenantCode());
        List<DisDpriceConf> confList = this.queryDpriceConfModelPage(map);
        if (ListUtil.isNotEmpty(confList)) {
            this.deleteDpriceConf(confList.get(0).getDpriceConfId());
        }
    }

    @Override
    public void saveOrUpdateDpriceBatch(List<DisDpriceDomain> disDpriceDomainList) throws ApiException {
        if (ListUtil.isEmpty(disDpriceDomainList)) {
            this.logger.error(".saveOrUpdateDpriceBatch", (Object)"disDpriceDomainList is null");
        }
        for (DisDpriceDomain disDpriceDomain : disDpriceDomainList) {
            if (disDpriceDomain.getDpriceId() == null) {
                this.saveDprice(disDpriceDomain);
                continue;
            }
            this.updateDprice(disDpriceDomain);
        }
    }

    @Override
    public void updateAuditCall(Map<String, Object> map) throws ApiException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, List<Integer>> disMap = new HashMap<String, List<Integer>>();
        this.logger.error("dis.DisDpriceServiceImpl.updateAuditCall:\u4f20\u5165\u53c2\u6570-", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (map.get("auditStatus") == null) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateAuditCall.ex", "\u5ba1\u6279\u53c2\u6570\u9519\u8bef\uff01");
        }
        String auditStatus = map.get("auditStatus").toString();
        List confList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(map.get("confList")), DisDpriceConf.class);
        paramMap.put("userCode", map.get("auditUserCode").toString());
        paramMap.put("userName", map.get("auditUserName").toString());
        StringBuffer sb = new StringBuffer();
        if ("YES".equals(auditStatus)) {
            ArrayList<String> skuIdList = new ArrayList<String>();
            for (DisDpriceConf disDpriceConf : confList) {
                disDpriceConf.setDataState(1);
                disDpriceConf.setMemo(disDpriceConf.getDpriceConfPrice().toString() + "-" + auditStatus);
                this.updateDpriceConfModel(disDpriceConf);
                skuIdList.add(disDpriceConf.getDpriceConfValueno());
                if (StringUtils.isNotBlank((String)sb.toString())) {
                    sb.append(",");
                }
                sb.append(disDpriceConf.getDpriceConfValueno());
            }
            this.updateDpriceConfCache((DisDpriceConf)confList.get(0));
            try {
                List<Integer> goodsIds = this.getGoodsIds(sb.toString(), ((DisDpriceConf)confList.get(0)).getTenantCode());
                disMap.put("goodsIds", goodsIds);
                this.internalInvoke("rs.resource.sendUpdateSoldOutGoods", disMap);
                disMap.clear();
                disMap.put("goodsIds", goodsIds);
                this.internalInvoke("rs.resource.sendUpdateShelveGoods", disMap);
            }
            catch (Exception e) {
                this.logger.error(".updateAuditCall", (Object)"\u5546\u54c1\u4e0a\u4e0b\u67b6\u5931\u8d25\uff01", (Throwable)e);
            }
        } else {
            for (DisDpriceConf disDpriceConf : confList) {
                this.updateStateDpriceConfModel(disDpriceConf.getDpriceConfId(), DistributionConstants.PRICE_CONF_STATE_14, DistributionConstants.PRICE_CONF_STATE_13);
            }
        }
    }

    private List<Integer> getGoodsIds(String skuCodes, String tenantCode) {
        QueryResult queryResult;
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("skuCode", skuCodes);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeQueryMap = new HashMap<String, String>();
        invokeQueryMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        String goodsStr = this.internalInvoke("rs.resourceGoods.queryRsGoodsSkuPage", invokeQueryMap);
        if (StringUtils.isBlank((String)goodsStr)) {
            this.logger.error("dis.DisDpriceServiceImpl.getGoodsIds:\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f\uff01-", (Object)JsonUtil.buildNormalBinder().toJson(invokeQueryMap));
        }
        if (null == (queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(goodsStr, QueryResult.class))) {
            this.logger.error("dis.DisDpriceServiceImpl.getGoodsIds:\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f1\uff01-", (Object)JsonUtil.buildNormalBinder().toJson(invokeQueryMap));
        }
        JSONArray skuListArr = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()));
        for (JSONObject jsonObject : skuListArr) {
            goodsIds.add(jsonObject.getInteger("goodsId"));
        }
        return goodsIds;
    }

    @Override
    public void saveDpriceToApprovalProcess(List<DisDpriceConfDomain> disDpriceConfDomainList) throws ApiException {
        if (null == disDpriceConfDomainList || disDpriceConfDomainList.isEmpty()) {
            return;
        }
        this.sendActiviti(disDpriceConfDomainList);
    }

    @Override
    public String saveDpriceConfBatchByGoods(List<DisDpriceConfDomain> disDpriceConfDomainList) throws ApiException {
        if (null == disDpriceConfDomainList || disDpriceConfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDpriceConf> disDpriceConfList = new ArrayList<DisDpriceConf>();
        String code = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        DisDpriceConf oldDisDpriceConf = null;
        for (DisDpriceConfDomain disDpriceConfDomain : disDpriceConfDomainList) {
            map.put("dpriceCode", disDpriceConfDomain.getDpriceCode());
            map.put("dpriceConfType", disDpriceConfDomain.getDpriceConfType());
            map.put("dpriceConfValue", disDpriceConfDomain.getDpriceConfValue());
            map.put("tenanCode", disDpriceConfDomain.getTenantCode());
            List<DisDpriceConf> confList = this.queryDpriceConfModelPage(map);
            if (ListUtil.isNotEmpty(confList)) {
                oldDisDpriceConf = confList.get(0);
                disDpriceConfDomain.setDpriceConfId(oldDisDpriceConf.getDpriceConfId());
                disDpriceConfDomain.setDpriceConfCode(oldDisDpriceConf.getDpriceConfCode());
                this.updateDpriceConf(disDpriceConfDomain);
                continue;
            }
            DisDpriceConf disDpriceConf = this.createDisDpriceConf(disDpriceConfDomain);
            code = disDpriceConf.getDpriceConfCode();
            disDpriceConfList.add(disDpriceConf);
        }
        this.saveDpriceConfBatchModel(disDpriceConfList);
        for (DisDpriceConf disDpriceConf2 : disDpriceConfList) {
            this.updateDpriceConfCache(disDpriceConf2);
        }
        return code;
    }

    @Override
    public void updateDpriceConfState(Integer dpriceConfId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDpriceConfModel(dpriceConfId, dataState, oldDataState);
        DisDpriceConf disDpriceConf = this.getDpriceConf(dpriceConfId);
        if (-1 == dataState) {
            this.deleteDpriceConfCache(disDpriceConf, null);
        } else {
            this.updateDpriceConfCache(disDpriceConf);
        }
    }

    @Override
    public void updateDpriceConfStateByCode(String tenantCode, String dpriceConfCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDpriceConfModelByCode(tenantCode, dpriceConfCode, dataState, oldDataState);
        DisDpriceConf disDpriceConf = this.getDpriceConfByCode(tenantCode, dpriceConfCode);
        if (-1 == dataState) {
            this.deleteDpriceConfCache(disDpriceConf, null);
        } else {
            this.updateDpriceConfCache(disDpriceConf);
        }
    }

    @Override
    public void updateDpriceConf(DisDpriceConfDomain disDpriceConfDomain) throws ApiException {
        String msg = this.checkDpriceConf(disDpriceConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConf.checkDpriceConf", msg);
        }
        DisDpriceConf oldDisDpriceConf = this.getDpriceConfModelById(disDpriceConfDomain.getDpriceConfId());
        if (null == oldDisDpriceConf) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDpriceConf disDpriceConf = this.makeDpriceConf(disDpriceConfDomain, oldDisDpriceConf);
        this.setDpriceConfUpdataDefault(disDpriceConf);
        this.updateDpriceConfModel(disDpriceConf);
        this.updateDpriceConfCache(disDpriceConf);
    }

    @Override
    public DisDpriceConf getDpriceConf(Integer dpriceConfId) {
        return this.getDpriceConfModelById(dpriceConfId);
    }

    @Override
    public void deleteDpriceConf(Integer dpriceConfId) throws ApiException {
        DisDpriceConf disDpriceConf = this.getDpriceConf(dpriceConfId);
        this.deleteDpriceConfModel(dpriceConfId);
        this.deleteDpriceConfCache(disDpriceConf, null);
        if ("2020050600004084".equals(disDpriceConf.getTenantCode())) {
            try {
                HashMap<String, List<Integer>> disMap = new HashMap<String, List<Integer>>();
                List<Integer> goodsIds = this.getGoodsIds(disDpriceConf.getDpriceConfValueno(), disDpriceConf.getTenantCode());
                disMap.put("goodsIds", goodsIds);
                this.internalInvoke("rs.resource.sendUpdateSoldOutGoods", disMap);
                disMap.clear();
                disMap.put("goodsIds", goodsIds);
                this.internalInvoke("rs.resource.sendUpdateShelveGoods", disMap);
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("\u5220\u9664\u5546\u54c1\u4ef7\u683c\u8bbe\u7f6e\uff0c\u4e0a\u4e0b\u67b6\u5546\u54c1\u5931\u8d25\uff01skuId=" + disDpriceConf.getDpriceConfValuename()));
            }
        }
    }

    @Override
    public void deleteBatchDpriceConf(List<Integer> dpriceConfIdList) throws ApiException {
        for (Integer dpriceConfId : dpriceConfIdList) {
            this.deleteDpriceConf(dpriceConfId);
        }
    }

    @Override
    public QueryResult<DisDpriceConf> queryDpriceConfPage(Map<String, Object> map) {
        List<DisDpriceConf> disDpriceConfList = this.queryDpriceConfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDpriceConf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDpriceConfList);
        return queryResult;
    }

    @Override
    public DisDpriceConf getDpriceConfByCode(String tenantCode, String dpriceConfCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfCode", dpriceConfCode);
        return this.getDpriceConfModelByCode(map);
    }

    @Override
    public void deleteDpriceConfByCode(String tenantCode, String dpriceConfCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfCode", dpriceConfCode);
        DisDpriceConf disDpriceConf = this.getDpriceConfByCode(tenantCode, dpriceConfCode);
        this.delDpriceConfModelByCode(map);
        this.deleteDpriceConfCache(disDpriceConf, null);
    }

    @Override
    public String saveDpriceConfbak(DisDpriceConfbakDomain disDpriceConfbakDomain) throws ApiException {
        DisDpriceConfbak disDpriceConfbak = this.createDisDpriceConfbak(disDpriceConfbakDomain);
        this.saveDpriceConfbakModel(disDpriceConfbak);
        return disDpriceConfbak.getDpriceConfbakCode();
    }

    @Override
    public String saveDpriceConfbakBatch(List<DisDpriceConfbakDomain> disDpriceConfbakDomainList) throws ApiException {
        if (null == disDpriceConfbakDomainList || disDpriceConfbakDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDpriceConfbak> disDpriceConfbakList = new ArrayList<DisDpriceConfbak>();
        String code = "";
        for (DisDpriceConfbakDomain disDpriceConfbakDomain : disDpriceConfbakDomainList) {
            DisDpriceConfbak disDpriceConfbak = this.createDisDpriceConfbak(disDpriceConfbakDomain);
            code = disDpriceConfbak.getDpriceConfbakCode();
            disDpriceConfbakList.add(disDpriceConfbak);
        }
        this.saveDpriceConfbakBatchModel(disDpriceConfbakList);
        return code;
    }

    @Override
    public void updateDpriceConfbakState(Integer dpriceConfbakId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDpriceConfbakModel(dpriceConfbakId, dataState, oldDataState);
    }

    @Override
    public void updateDpriceConfbakStateByCode(String tenantCode, String dpriceConfbakCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDpriceConfbakModelByCode(tenantCode, dpriceConfbakCode, dataState, oldDataState);
    }

    @Override
    public void updateDpriceConfbak(DisDpriceConfbakDomain disDpriceConfbakDomain) throws ApiException {
        String msg = this.checkDpriceConfbak(disDpriceConfbakDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfbak.checkDpriceConfbak", msg);
        }
        DisDpriceConfbak oldDisDpriceConfbak = this.getDpriceConfbakModelById(disDpriceConfbakDomain.getDpriceConfbakId());
        if (null == oldDisDpriceConfbak) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateDpriceConfbak.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDpriceConfbak disDpriceConfbak = this.makeDpriceConfbak(disDpriceConfbakDomain, oldDisDpriceConfbak);
        this.setDpriceConfbakUpdataDefault(disDpriceConfbak);
        this.updateDpriceConfbakModel(disDpriceConfbak);
    }

    @Override
    public DisDpriceConfbak getDpriceConfbak(Integer dpriceConfbakId) {
        return this.getDpriceConfbakModelById(dpriceConfbakId);
    }

    @Override
    public void deleteDpriceConfbak(Integer dpriceConfbakId) throws ApiException {
        this.deleteDpriceConfbakModel(dpriceConfbakId);
    }

    @Override
    public QueryResult<DisDpriceConfbak> queryDpriceConfbakPage(Map<String, Object> map) {
        List<DisDpriceConfbak> disDpriceConfbakList = this.queryDpriceConfbakModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDpriceConfbak(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDpriceConfbakList);
        return queryResult;
    }

    @Override
    public DisDpriceConfbak getDpriceConfbakByCode(String tenantCode, String dpriceConfbakCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfbakCode", dpriceConfbakCode);
        return this.getDpriceConfbakModelByCode(map);
    }

    @Override
    public void deleteDpriceConfbakByCode(String tenantCode, String dpriceConfbakCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfbakCode", dpriceConfbakCode);
        this.delDpriceConfbakModelByCode(map);
    }

    private void deleteDpriceCache(DisDprice disDprice) {
        String json;
        if (null == disDprice) {
            return;
        }
        if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
            disDprice.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getRemotMap((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()))))) {
            return;
        }
        List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDpriceDomain.class);
        ArrayList<DisDpriceDomain> dlist2 = new ArrayList<DisDpriceDomain>();
        if (ListUtil.isNotEmpty((Collection)dlist)) {
            for (DisDpriceDomain disDpriceDomain2 : dlist) {
                if (disDpriceDomain2.getDpriceCode().equals(disDprice.getDpriceCode())) continue;
                dlist2.add(disDpriceDomain2);
            }
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist2)));
    }

    private void deleteDpriceConfCache(DisDpriceConf disDpriceConf, DisDprice disDprice) {
        String json;
        if (null == disDpriceConf) {
            return;
        }
        if (null == disDprice) {
            disDprice = this.getDpriceByCode(disDpriceConf.getTenantCode(), disDpriceConf.getDpriceCode());
        }
        if (null == disDprice) {
            return;
        }
        if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
            disDprice.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getRemotMap((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()))))) {
            return;
        }
        List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDpriceDomain.class);
        ArrayList<DisDpriceDomain> dlist1 = new ArrayList<DisDpriceDomain>();
        if (ListUtil.isNotEmpty((Collection)dlist)) {
            for (DisDpriceDomain disDpriceDomain2 : dlist) {
                if (disDpriceDomain2.getDpriceCode().equals(disDprice.getDpriceCode())) {
                    ArrayList<DisDpriceConf> configcacheList = new ArrayList<DisDpriceConf>();
                    disDpriceDomain2.setDisDpriceConfList(configcacheList);
                    for (DisDpriceConf disDpriceConf2 : disDpriceDomain2.getDisDpriceConfList()) {
                        if (disDpriceConf2.getDpriceConfCode().equals(disDpriceConf.getDpriceConfCode())) continue;
                        configcacheList.add(disDpriceConf2);
                    }
                }
                dlist1.add(disDpriceDomain2);
            }
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDpriceConf.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist1)));
    }

    private void updateDpriceCache(DisDprice disDprice) {
        if (null == disDprice) {
            return;
        }
        DisDpriceDomain disDpriceDomain = this.makeDisDpriceDomain(disDprice);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dpriceCode", disDprice.getDpriceCode());
        confparammap.put("tenantCode", disDprice.getTenantCode());
        if ("2020050600004084".equals(disDprice.getTenantCode())) {
            confparammap.put("dataState", DistributionConstants.dataState_audt);
        }
        List<DisDpriceConf> upcachelist = this.queryDpriceConfModelPage(confparammap);
        disDpriceDomain.setDisDpriceConfList(upcachelist);
        String json = DisUtil.getRemotMap((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<DisDpriceDomain> dlist = new ArrayList<DisDpriceDomain>();
            dlist.add(disDpriceDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        } else {
            List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDpriceDomain.class);
            ArrayList<DisDpriceDomain> redlist = new ArrayList<DisDpriceDomain>();
            if (ListUtil.isNotEmpty((Collection)dlist)) {
                boolean flag = false;
                for (DisDpriceDomain disDpriceDomain2 : dlist) {
                    if (disDpriceDomain2.getDpriceCode().equals(disDprice.getDpriceCode())) {
                        flag = true;
                        redlist.add(disDpriceDomain);
                        continue;
                    }
                    redlist.add(disDpriceDomain2);
                }
                if (!flag) {
                    redlist.add(disDpriceDomain);
                }
            } else {
                redlist.add(disDpriceDomain);
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(redlist)));
        }
    }

    private void updateDpriceConfCache(DisDpriceConf disDpriceConf) {
        if (null == disDpriceConf) {
            return;
        }
        DisDprice disDprice = this.getDpriceByCode(disDpriceConf.getTenantCode(), disDpriceConf.getDpriceCode());
        if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
            disDprice.setChannelCode("all");
        }
        DisDpriceDomain disDpriceDomain = this.makeDisDpriceDomain(disDprice);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dpriceCode", disDprice.getDpriceCode());
        confparammap.put("tenantCode", disDprice.getTenantCode());
        if ("2020050600004084".equals(disDpriceConf.getTenantCode())) {
            confparammap.put("dataState", DistributionConstants.dataState_audt);
        }
        List<DisDpriceConf> upcachelist = this.queryDpriceConfModelPage(confparammap);
        disDpriceDomain.setDisDpriceConfList(upcachelist);
        String json = DisUtil.getRemotMap((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDprice.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<DisDpriceDomain> dlist = new ArrayList<DisDpriceDomain>();
            dlist.add(disDpriceDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDpriceConf.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        } else {
            ArrayList<DisDpriceDomain> dlist = (ArrayList<DisDpriceDomain>)JsonUtil.buildNormalBinder().getJsonToList(json, DisDpriceDomain.class);
            if (ListUtil.isEmpty((Collection)dlist)) {
                dlist = new ArrayList<DisDpriceDomain>();
                dlist.add(disDpriceDomain);
            } else {
                for (DisDpriceDomain disDpriceDomain2 : dlist) {
                    if (!disDpriceDomain2.getDpriceCode().equals(disDprice.getDpriceCode())) continue;
                    disDpriceDomain2.setDisDpriceConfList(upcachelist);
                    break;
                }
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(disDprice.getChannelCode() + "-" + disDpriceConf.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        }
    }

    @Override
    public void queryDpriceLoadCache() {
        this.logger.info("DisDpriceService.queryDpriceLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", DistributionConstants.dataState_start);
        List<DisDprice> disDpriceList = this.queryDpriceModelPage(parammap);
        if (null == disDpriceList || disDpriceList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("DisDpriceService.queryDpriceLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap<String, ArrayList<DisDpriceDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<DisDpriceDomain>>();
        for (DisDprice disDprice : disDpriceList) {
            if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
                disDprice.setChannelCode("all");
            }
            DisDpriceDomain disDpriceDomain = this.makeDisDpriceDomain(disDprice);
            confparammap.put("dpriceCode", disDprice.getDpriceCode());
            confparammap.put("tenantCode", disDprice.getTenantCode());
            if ("2020050600004084".equals(disDprice.getTenantCode())) {
                confparammap.put("dataState", DistributionConstants.dataState_audt);
            }
            List<DisDpriceConf> upcachelist = this.queryDpriceConfModelPage(confparammap);
            disDpriceDomain.setDisDpriceConfList(upcachelist);
            ArrayList<DisDpriceDomain> dlist = (ArrayList<DisDpriceDomain>)ddListMap.get(disDprice.getChannelCode() + "-" + disDprice.getTenantCode());
            if (null == dlist) {
                dlist = new ArrayList<DisDpriceDomain>();
                ddListMap.put(disDprice.getChannelCode() + "-" + disDprice.getTenantCode(), dlist);
            }
            dlist.add(disDpriceDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.disDomainsort((List)ddListMap.get(key))));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.info("DisDpriceService.queryDpriceLoadCache", (Object)"===========add-end==========");
    }

    @Override
    public void queryDpriceSubLoadCache() {
        this.logger.info("DisDpriceService.queryDpriceLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", DistributionConstants.dataState_start);
        List<DisDprice> disDpriceList = this.queryDpriceModelPage(parammap);
        if (null == disDpriceList || disDpriceList.isEmpty()) {
            this.logger.info("DisDpriceService.queryDpriceLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap<String, ArrayList<DisDpriceDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<DisDpriceDomain>>();
        for (DisDprice disDprice : disDpriceList) {
            if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
                disDprice.setChannelCode("all");
            }
            DisDpriceDomain disDpriceDomain = this.makeDisDpriceDomain(disDprice);
            confparammap.put("dpriceCode", disDprice.getDpriceCode());
            confparammap.put("dataState", DistributionConstants.PRICE_SUB_STATE_1);
            confparammap.put("tenantCode", disDprice.getTenantCode());
            List<DisDpriceSub> upcachelist = this.queryDpriceSubModelPage(confparammap);
            disDpriceDomain.setDisDpriceSubList(upcachelist);
            ArrayList<DisDpriceDomain> dlist = (ArrayList<DisDpriceDomain>)ddListMap.get(disDprice.getChannelCode() + "-" + disDprice.getTenantCode());
            if (null == dlist) {
                dlist = new ArrayList<DisDpriceDomain>();
                ddListMap.put(disDprice.getChannelCode() + "-" + disDprice.getTenantCode(), dlist);
            }
            dlist.add(disDpriceDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(ddListMap.get(key)));
        }
        this.logger.info("DisDpriceService.queryDpriceLoadCache", (Object)"===========add-end==========");
    }

    private List<DisDpriceDomain> disDomainsort(List<DisDpriceDomain> dlist) {
        if (ListUtil.isEmpty(dlist)) {
            return null;
        }
        Collections.sort(dlist, new Comparator<DisDpriceDomain>(){

            @Override
            public int compare(DisDpriceDomain arg0, DisDpriceDomain arg1) {
                if (arg0.getDpriceWeight() > arg1.getDpriceWeight()) {
                    return 1;
                }
                if (arg0.getDpriceWeight() < arg1.getDpriceWeight()) {
                    return -1;
                }
                return arg0.getDpriceWeight().compareTo(arg0.getDpriceWeight());
            }
        });
        return dlist;
    }

    private DisDpriceDomain makeDisDpriceDomain(DisDprice disDprice) {
        if (null == disDprice) {
            return null;
        }
        DisDpriceDomain disDpriceDomain = new DisDpriceDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceDomain, (Object)disDprice);
            return disDpriceDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDisChannelsendBaseService(DisChannelsendBaseService disChannelsendBaseService) {
        this.disChannelsendBaseService = disChannelsendBaseService;
    }

    @Override
    public void saveDpriceLoadCache() {
        HashMap<String, DisDprice> map = new HashMap<String, DisDprice>();
        this.saveStart(map);
        this.saveEnd(map);
        this.saveDel(map);
        if (MapUtil.isNotEmpty(map)) {
            for (String key : map.keySet()) {
                this.disChannelsendBaseService.sendSaveDpriceUpdate((DisDprice)map.get(key));
            }
        }
    }

    private void saveDel(Map<String, DisDprice> map) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", DistributionConstants.dataState_del);
        List<DisDprice> disDpriceList = this.queryDpriceModelPage(parammap);
        if (null == disDpriceList || disDpriceList.isEmpty()) {
            return;
        }
        Integer channelVer = null;
        for (DisDprice disDprice : disDpriceList) {
            DisChannel disChannel = this.disChannelService.getChannelByCode(disDprice.getTenantCode(), disDprice.getChannelCode());
            if (null == disChannel) {
                this.updateDpriceState(disDprice.getDpriceId(), DistributionConstants.dataState_no, DistributionConstants.dataState_del, channelVer);
                continue;
            }
            if (null == map.get(disDprice.getChannelCode() + "-" + disDprice.getTenantCode())) {
                map.put(disDprice.getChannelCode() + "-" + disDprice.getTenantCode(), disDprice);
            }
            try {
                channelVer = this.disChannelService.updateChannelVer(disDprice.getChannelCode(), disDprice.getTenantCode());
                this.updateDpriceState(disDprice.getDpriceId(), DistributionConstants.dataState_no, DistributionConstants.dataState_del, channelVer);
                this.disChannelsendBaseService.sendSaveDpriceUpdate(disDprice);
            }
            catch (Exception e) {
                this.logger.error("dis.DisDpriceServiceImpl.saveDel.e", (Object)disDprice.getDpriceCode(), (Throwable)e);
                return;
            }
        }
    }

    private void saveEnd(Map<String, DisDprice> map) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", DistributionConstants.dataState_start);
        List<DisDprice> disDpriceList = this.queryDpriceModelPage(parammap);
        if (null == disDpriceList || disDpriceList.isEmpty()) {
            return;
        }
        Integer channelVer = null;
        for (DisDprice disDprice : disDpriceList) {
            if (null == disDprice.getDpriceEydate() || disDprice.getDpriceEydate().getTime() > this.getSysDate().getTime()) continue;
            DisChannel disChannel = this.disChannelService.getChannelByCode(disDprice.getTenantCode(), disDprice.getChannelCode());
            if (null == disChannel) {
                this.updateDpriceState(disDprice.getDpriceId(), DistributionConstants.dataState_no, DistributionConstants.dataState_start, channelVer);
                continue;
            }
            if (null == map.get(disDprice.getChannelCode() + "-" + disDprice.getTenantCode())) {
                map.put(disDprice.getChannelCode() + "-" + disDprice.getTenantCode(), disDprice);
            }
            try {
                channelVer = this.disChannelService.updateChannelVer(disDprice.getChannelCode(), disDprice.getTenantCode());
            }
            catch (Exception e) {
                this.logger.error("dis.DisDpriceServiceImpl.saveEnd.e", (Object)disDprice.getDpriceCode(), (Throwable)e);
                return;
            }
        }
    }

    private void saveStart(Map<String, DisDprice> map) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", DistributionConstants.dataState_audt);
        List<DisDprice> disDpriceList = this.queryDpriceModelPage(parammap);
        if (null == disDpriceList || disDpriceList.isEmpty()) {
            return;
        }
        Integer channelVer = null;
        for (DisDprice disDprice : disDpriceList) {
            if (null != disDprice.getDpriceSydate() && disDprice.getDpriceSydate().getTime() > this.getSysDate().getTime()) continue;
            DisChannel disChannel = this.disChannelService.getChannelByCode(disDprice.getTenantCode(), disDprice.getChannelCode());
            if (null == disChannel) {
                this.updateDpriceState(disDprice.getDpriceId(), DistributionConstants.dataState_no, DistributionConstants.dataState_audt, channelVer);
                continue;
            }
            if (null == map.get(disDprice.getChannelCode() + "-" + disDprice.getTenantCode())) {
                map.put(disDprice.getChannelCode() + "-" + disDprice.getTenantCode(), disDprice);
            }
            try {
                channelVer = this.disChannelService.updateChannelVer(disDprice.getChannelCode(), disDprice.getTenantCode());
                this.updateDpriceState(disDprice.getDpriceId(), DistributionConstants.dataState_start, DistributionConstants.dataState_audt, channelVer);
            }
            catch (Exception e) {
                this.logger.error("dis.DisDpriceServiceImpl.saveStart.e", (Object)disDprice.getDpriceCode(), (Throwable)e);
                return;
            }
        }
    }

    @Override
    public void deleteDpriceConfByPriceCode(String tenantCode, String dpriceCode) throws ApiException {
        if (StringUtils.isBlank((String)dpriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.deleteDisPriceConfBypriceCode(dpriceCode, tenantCode);
    }

    private void appendSkuCode(ActSubmitDomain actSubmitDomain) {
        ArrayList<String> skuCodeList = new ArrayList<String>();
        StringBuffer skuCodeStr = new StringBuffer();
        StringBuffer dPriceSubCodeStr = new StringBuffer();
        for (DisDpriceSubDomain disDpriceSubDomain : actSubmitDomain.getDisDpriceSubDomainList()) {
            if (!skuCodeList.contains(disDpriceSubDomain.getSkuCode())) {
                if (StringUtils.isNotBlank((String)skuCodeStr.toString())) {
                    skuCodeStr.append(",");
                }
                skuCodeStr.append(disDpriceSubDomain.getSkuCode());
            }
            if (StringUtils.isNotBlank((String)dPriceSubCodeStr.toString())) {
                dPriceSubCodeStr.append(",");
            }
            dPriceSubCodeStr.append(disDpriceSubDomain.getDpriceSubCode());
            skuCodeList.add(disDpriceSubDomain.getSkuCode());
        }
        actSubmitDomain.setSkuCodeStr(skuCodeStr.toString());
        actSubmitDomain.setdPriceSubCodeStr(dPriceSubCodeStr.toString());
    }

    private void querySku(ActSubmitDomain actSubmitDomain) {
        HashMap<String, String> skuMap = new HashMap<String, String>();
        HashMap<String, String> skuMapStr = new HashMap<String, String>();
        skuMapStr.put("skuCodeStr", actSubmitDomain.getSkuCodeStr());
        skuMapStr.put("tenantCode", actSubmitDomain.getTenantCode());
        skuMap.put("map", JsonUtil.buildNormalBinder().toJson(skuMapStr));
        this.logger.error("dis.DisDpriceServiceImpl.querySku.params", skuMapStr);
        if (actSubmitDomain.getSkuCodeStr().length() == 0) {
            return;
        }
        String result = this.internalInvoke("rs.sku.querySkuOnePage", skuMap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("dis.DisDpriceServiceImpl.sendActivitiData.ex", "\u67e5\u8be2sku\u6570\u636e\u9519\u8bef\uff01\u53c2\u6570-" + JsonUtil.buildNormalBinder().toJson(skuMap));
        }
        QueryResult jsonToObject = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(result, QueryResult.class);
        String s = JsonUtil.buildNormalBinder().toJson((Object)jsonToObject.getList());
        JSONArray jsonObjects = JSONArray.json2array((String)s);
        this.logger.error("dis.DisDpriceServiceImpl.querySku.size", (Object)jsonObjects.size());
        actSubmitDomain.setSkuJsonArray(jsonObjects);
    }

    private void appendGoods(ActSubmitDomain actSubmitDomain) {
        HashMap<String, JSONObject> jsonObjectMap = new HashMap<String, JSONObject>();
        StringBuffer goodsCodeStr = new StringBuffer();
        HashMap<String, String> goodsReSku = new HashMap<String, String>();
        for (JSONObject jsonObject : actSubmitDomain.getSkuJsonArray()) {
            jsonObjectMap.put(jsonObject.getString("skuCode"), jsonObject);
            goodsCodeStr.append(jsonObject.getString("goodsCode"));
            goodsCodeStr.append(",");
            goodsReSku.put(jsonObject.getString("goodsCode"), jsonObject.getString("skuCode"));
        }
        actSubmitDomain.setGoodsReSku(goodsReSku);
        actSubmitDomain.setGoodsCodeStr(goodsCodeStr.toString());
        actSubmitDomain.setSkuJsonObject(jsonObjectMap);
    }

    private BigDecimal getSubPrice(DisDpriceSub disDpriceSubDomain, String qualityQtypeCode) {
        BigDecimal money = new BigDecimal(disDpriceSubDomain.getTempFieild4());
        if (StringUtils.isBlank((String)disDpriceSubDomain.getDpriceConfDes())) {
            return money;
        }
        String[] arr = disDpriceSubDomain.getDpriceConfDes().split(",");
        if (arr.length < 4) {
            return money;
        }
        BigDecimal priceRateTariff = new BigDecimal(arr[3]);
        BigDecimal priceRateFreight = new BigDecimal(arr[4]);
        BigDecimal priceRateReturn = new BigDecimal(arr[5]);
        BigDecimal priceRateForeign = new BigDecimal(arr[6]);
        BigDecimal rateSum = BigDecimal.ONE;
        if (priceRateForeign.compareTo(BigDecimal.ZERO) > 0) {
            money = money.divide(priceRateForeign, 2, 4);
        }
        if (priceRateTariff.compareTo(BigDecimal.ZERO) > 0) {
            priceRateTariff = priceRateTariff.divide(new BigDecimal(100));
            rateSum = rateSum.add(priceRateTariff);
        }
        if (priceRateFreight.compareTo(BigDecimal.ZERO) > 0) {
            priceRateFreight = priceRateFreight.divide(new BigDecimal(100));
            rateSum = rateSum.add(priceRateFreight);
        }
        if (priceRateReturn.compareTo(BigDecimal.ZERO) > 0) {
            priceRateReturn = priceRateReturn.divide(new BigDecimal(100));
            rateSum = rateSum.add(priceRateReturn);
        }
        if ("1".equals(qualityQtypeCode)) {
            rateSum = rateSum.add(new BigDecimal("0.13"));
        }
        money = money.divide(rateSum, 2, 4);
        return money;
    }

    @Override
    public void sendActivitiSub(List<DisDpriceSubDomain> disDpriceSubDomainList) throws ApiException {
        this.logger.error("dis.DisDpriceServiceImpl.sendActivitiSub.desc", (Object)"\u4ef7\u683c\u7ec4\u63d0\u4ea4\u5ba1\u6279\u6d41\u5f00\u59cb");
        this.sendActivitiNew(disDpriceSubDomainList);
    }

    private void loadDisDpriceSubCache(String dpriceCode, String tenantCode) {
        this.logger.error("dis.DisDpriceServiceImpl.saveDisDpriceSubCache.params", (Object)("dpriceCode:" + dpriceCode));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dpriceCode", dpriceCode);
        params.put("dataState", DistributionConstants.PRICE_SUB_STATE_1);
        params.put("tenantCode", tenantCode);
        List<DisDpriceSub> disDpriceSubList = this.disDpriceSubMapper.query(params);
        this.logger.error("dis.DisDpriceServiceImpl.saveDisDpriceSubCache.desc", (Object)"\u66f4\u65b0\u4ef7\u683c\u7ec4\u7f13\u5b58\u7ed3\u675f");
    }

    private String getCacheFieldKey(String channelCode, String tenantCode) {
        return channelCode + "-" + tenantCode;
    }

    private void updateStateDpriceSubModel(String dpriceSubIdStr, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dpriceSubIdStr || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceSubIdStr", dpriceSubIdStr);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("cacheState", DistributionConstants.PRICE_SUB_UPDATE_STATE_0);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDpriceSubMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceSubModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateStateDpriceSubModel.null");
        }
    }

    @Override
    public void updateSubAuditCall(Map<String, Object> map) throws ApiException {
        this.logger.error("dis.DisDpriceServiceImpl.updateSubAuditCall.desc", (Object)"\u4ef7\u683c\u7ec4\u5ba1\u6279\u6d41\u56de\u8c03\u5f00\u59cb");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap disMap = new HashMap();
        if (map.get("auditStatus") == null) {
            throw new ApiException("dis.DisDpriceServiceImpl.updateSubAuditCall.ex", "\u5ba1\u6279\u53c2\u6570\u9519\u8bef\uff01");
        }
        String auditStatus = map.get("auditStatus").toString();
        List confList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(map.get("confList")), DisDpriceConf.class);
        paramMap.put("userCode", map.get("auditUserCode").toString());
        paramMap.put("userName", map.get("auditUserName").toString());
        StringBuffer skuCodeStr = new StringBuffer();
        StringBuffer dPriceSubIdStrAll = new StringBuffer();
        StringBuffer dPriceSubIdStrApprove = new StringBuffer();
        StringBuffer dPriceSubIdStrReject = new StringBuffer();
        ArrayList<String> skuCodeList = new ArrayList<String>();
        ArrayList<String> dPriceSubIdAll = new ArrayList<String>();
        for (DisDpriceConf disDpriceConf : confList) {
            if (StringUtils.isNotBlank((String)dPriceSubIdStrAll.toString())) {
                dPriceSubIdStrAll.append(",");
            }
            dPriceSubIdStrAll.append(disDpriceConf.getDpriceConfId());
            dPriceSubIdAll.add(disDpriceConf.getDpriceConfId() + "");
        }
        this.logger.error("dis.DisDpriceServiceImpl.updateSubAuditCall.dPriceSubIdStrAll:", (Object)dPriceSubIdStrAll);
        ArrayList<String> selectIdList = new ArrayList<String>();
        String selectIdStr = "";
        selectIdStr = StringUtils.isNotBlank((String)map.get("dpriceConfIdStr").toString()) ? map.get("dpriceConfIdStr").toString() : dPriceSubIdStrAll.toString();
        selectIdList.addAll(Arrays.asList(selectIdStr.split(",")));
        this.logger.error("dis.DisDpriceServiceImpl.updateSubAuditCall.selectIdStr:", (Object)selectIdStr);
        for (DisDpriceConf disDpriceConf : confList) {
            if ("YES".equals(auditStatus)) {
                if (selectIdList.contains(disDpriceConf.getDpriceConfId() + "") || !dPriceSubIdAll.containsAll(selectIdList)) {
                    if (!skuCodeList.contains(disDpriceConf.getDpriceConfValueno())) {
                        skuCodeList.add(disDpriceConf.getDpriceConfValueno());
                        if (StringUtils.isNotBlank((String)skuCodeStr.toString())) {
                            skuCodeStr.append(",");
                        }
                        skuCodeStr.append(disDpriceConf.getDpriceConfValueno());
                    }
                    if (StringUtils.isNotBlank((String)dPriceSubIdStrApprove.toString())) {
                        dPriceSubIdStrApprove.append(",");
                    }
                    dPriceSubIdStrApprove.append(disDpriceConf.getDpriceConfId());
                    continue;
                }
                if (StringUtils.isNotBlank((String)dPriceSubIdStrReject.toString())) {
                    dPriceSubIdStrReject.append(",");
                }
                dPriceSubIdStrReject.append(disDpriceConf.getDpriceConfId());
                continue;
            }
            if (StringUtils.isNotBlank((String)dPriceSubIdStrReject.toString())) {
                dPriceSubIdStrReject.append(",");
            }
            dPriceSubIdStrReject.append(disDpriceConf.getDpriceConfId());
        }
        if (dPriceSubIdStrApprove.length() > 0) {
            HashMap<String, Object> expmap = new HashMap<String, Object>();
            expmap.put("auditApprove", "true");
            this.updateStateDpriceSubModel(dPriceSubIdStrApprove.toString(), DistributionConstants.PRICE_SUB_STATE_1, null, expmap);
        }
        if (dPriceSubIdStrReject.length() > 0) {
            this.updateStateDpriceSubModel(dPriceSubIdStrReject.toString(), DistributionConstants.PRICE_SUB_STATE_14, null, null);
        }
        this.logger.error("dis.DisDpriceServiceImpl.updateSubAuditCall.desc", (Object)"\u4ef7\u683c\u7ec4\u5ba1\u6279\u6d41\u56de\u8c03\u7ed3\u675f");
    }

    private String getUserInfoByColumn(String channelCode, String tenantCode, String column) {
        this.logger.error("dis.DisDpriceServiceImpl.getUserInfoByColumn.desc >>> \u67e5\u770b\u7528\u6237\u4fe1\u606f", (Object)("channelCode:" + channelCode));
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("dis.DisDpriceServiceImpl.getUserInfoByColumn.ex >>> null", (Object)("channelCode:" + channelCode));
            return null;
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userinfoCode", this.getDisChannel(tenantCode, channelCode).getMemberCode());
            map.put("tenantCode", tenantCode);
            params.put("map", JsonUtil.buildNormalBinder().toJson(map));
            String userinfoQueryJson = this.internalInvoke("um.userbase.queryUserinfoPage", params);
            QueryResult userinfoResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(userinfoQueryJson, QueryResult.class);
            JSONArray userinfoList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson((Object)userinfoResult.getList()));
            Iterator i$ = userinfoList.iterator();
            if (i$.hasNext()) {
                JSONObject objects = (JSONObject)i$.next();
                return objects.getString(column);
            }
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getUserInfo.ex", (Throwable)e);
        }
        return null;
    }

    private DisChannel getDisChannel(String tenantCode, String channelCode) {
        try {
            return this.disChannelService.getChannelByCode(tenantCode, channelCode);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDpriceServiceImpl.getDisChannel.ex", (Throwable)e);
            return null;
        }
    }

    private void sendActivitiNew(List<DisDpriceSubDomain> disDpriceSubDomainList) {
        StringBuffer skuCodeStr = new StringBuffer();
        StringBuffer codes = new StringBuffer();
        String auditRemark = disDpriceSubDomainList.get(0).getMemo();
        for (DisDpriceSubDomain disDpriceConf : disDpriceSubDomainList) {
            skuCodeStr.append(disDpriceConf.getSkuCode());
            skuCodeStr.append(",");
            codes.append(disDpriceConf.getDpriceSubCode());
            codes.append(",");
        }
        HashMap<String, String> skuMap = new HashMap<String, String>();
        HashMap<String, String> skuMapStr = new HashMap<String, String>();
        skuMapStr.put("skuCodeStr", skuCodeStr.toString());
        skuMapStr.put("tenantCode", disDpriceSubDomainList.get(0).getTenantCode());
        skuMap.put("map", JsonUtil.buildNormalBinder().toJson(skuMapStr));
        String result = this.internalInvoke("rs.sku.querySkuOnePage", skuMap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("dis.DisDpriceServiceImpl.sendActivitiData.ex", "\u67e5\u8be2sku\u6570\u636e\u9519\u8bef\uff01\u53c2\u6570-" + JsonUtil.buildNormalBinder().toJson(skuMap));
        }
        QueryResult jsonToObject = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(result, QueryResult.class);
        String s = JsonUtil.buildNormalBinder().toJson((Object)jsonToObject.getList());
        HashMap<String, JSONObject> jsonObjectMap = new HashMap<String, JSONObject>();
        StringBuffer goodsCodeStr = new StringBuffer();
        HashMap<String, String> goodsReSku = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)result)) {
            JSONArray jsonObjects = JSONArray.json2array((String)s);
            for (JSONObject jsonObject : jsonObjects) {
                jsonObjectMap.put(jsonObject.getString("skuCode"), jsonObject);
                goodsCodeStr.append(jsonObject.getString("goodsCode"));
                goodsCodeStr.append(",");
                goodsReSku.put(jsonObject.getString("goodsCode"), jsonObject.getString("skuCode"));
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", disDpriceSubDomainList.get(0).getTenantCode());
        paramMap.put("dpriceSubCode", codes.toString());
        if (StringUtils.isBlank((String)codes.toString())) {
            this.logger.error("dis.DisDpriceServiceImpl.sendActivitiSub.dpriceSubCode:", (Object)codes.toString());
            return;
        }
        List<DisDpriceSub> confList = this.disDpriceSubMapper.query(paramMap);
        String qualityQtypeCode = this.getUserInfoByColumn(confList.get(0).getChannelCode(), confList.get(0).getTenantCode(), "qualityQtypeCode");
        BigDecimal gjjlPrice = BigDecimal.ZERO;
        BigDecimal dqPrice = BigDecimal.ZERO;
        BigDecimal pqPrice = BigDecimal.ZERO;
        BigDecimal gjyzPrice = BigDecimal.ZERO;
        BigDecimal gjPrice = BigDecimal.ZERO;
        BigDecimal payPrice = BigDecimal.ZERO;
        int max = 0;
        String applyUserCode = "";
        String applyUserName = "";
        for (DisDpriceSubDomain disDpriceConfDomain : disDpriceSubDomainList) {
            DisDpriceSub disDpriceSub = null;
            for (DisDpriceSub disDpriceSubVar : confList) {
                if (!disDpriceConfDomain.getDpriceSubCode().equals(disDpriceSubVar.getDpriceSubCode())) continue;
                disDpriceSub = disDpriceSubVar;
                break;
            }
            BigDecimal money = this.getSubPrice(disDpriceSub, qualityQtypeCode);
            applyUserCode = disDpriceConfDomain.getUserCode();
            applyUserName = disDpriceConfDomain.getUserName();
            int index = 0;
            JSONObject jsonObject = (JSONObject)jsonObjectMap.get(disDpriceConfDomain.getSkuCode());
            if (jsonObject == null) {
                this.logger.error("dis.DisDpriceServiceImpl.sendActiviti.skuCode is null", (Object)disDpriceConfDomain.getSkuCode());
                continue;
            }
            if (jsonObject.getBigDecimal("pricesetBaseprice") != null && money.compareTo(jsonObject.getBigDecimal("pricesetBaseprice")) < 0) {
                index = 1;
            }
            if (jsonObject.getBigDecimal("pricesetAsprice") != null && money.compareTo(jsonObject.getBigDecimal("pricesetAsprice")) < 0) {
                index = 2;
            }
            if (jsonObject.getBigDecimal("pricesetPrefprice") != null && money.compareTo(jsonObject.getBigDecimal("pricesetPrefprice")) < 0) {
                index = 3;
            }
            if (jsonObject.getBigDecimal("pricesetInsideprice") != null && money.compareTo(jsonObject.getBigDecimal("pricesetInsideprice")) < 0) {
                index = 4;
            }
            if (jsonObject.getBigDecimal("goodsTopweight") != null && money.compareTo(jsonObject.getBigDecimal("goodsTopweight")) < 0) {
                index = 5;
            }
            if (index == 5) {
                gjjlPrice = jsonObject.getBigDecimal("pricesetBaseprice");
                dqPrice = jsonObject.getBigDecimal("pricesetAsprice");
                pqPrice = jsonObject.getBigDecimal("pricesetPrefprice");
                gjyzPrice = jsonObject.getBigDecimal("pricesetInsideprice");
                gjPrice = jsonObject.getBigDecimal("goodsTopweight");
                payPrice = money;
                break;
            }
            if (index < max) continue;
            max = index;
            gjjlPrice = jsonObject.getBigDecimal("pricesetBaseprice");
            dqPrice = jsonObject.getBigDecimal("pricesetAsprice");
            pqPrice = jsonObject.getBigDecimal("pricesetPrefprice");
            gjyzPrice = jsonObject.getBigDecimal("pricesetInsideprice");
            gjPrice = jsonObject.getBigDecimal("goodsTopweight");
            payPrice = money;
        }
        StringBuffer dpriceSubIdStr = new StringBuffer();
        for (DisDpriceSub disDpriceSub : confList) {
            if (StringUtils.isNotBlank((String)dpriceSubIdStr.toString())) {
                dpriceSubIdStr.append(",");
            }
            dpriceSubIdStr.append(disDpriceSub.getDpriceSubId());
        }
        this.updateStateDpriceSubModel(dpriceSubIdStr.toString(), DistributionConstants.PRICE_SUB_STATE_13, null, null);
        ArrayList<DisDpriceConfDomain> confListBuild = new ArrayList<DisDpriceConfDomain>();
        for (DisDpriceSub disDpriceSub : confList) {
            DisDpriceConfDomain dpriceConfDomain = new DisDpriceConfDomain();
            try {
                BeanUtils.copyAllPropertys((Object)dpriceConfDomain, (Object)disDpriceSub);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dpriceConfDomain.setDpriceConfId(disDpriceSub.getDpriceSubId());
            dpriceConfDomain.setDpriceConfCode(disDpriceSub.getDpriceSubCode());
            dpriceConfDomain.setDpriceConfPicurl(disDpriceSub.getTempFieild5());
            dpriceConfDomain.setDpriceConfValue(disDpriceSub.getSkuName());
            dpriceConfDomain.setDpriceConfValueno(disDpriceSub.getSkuCode());
            dpriceConfDomain.setDpriceConfValuen(disDpriceSub.getGoodsName());
            dpriceConfDomain.setDpriceConfPrice(new BigDecimal(disDpriceSub.getTempFieild4()));
            dpriceConfDomain.setTradeCode(disDpriceSub.getTradeCode());
            dpriceConfDomain.setTradeName(disDpriceSub.getTradeName());
            dpriceConfDomain.setCurrencyCode(disDpriceSub.getCurrencyCode());
            dpriceConfDomain.setCurrencyName(disDpriceSub.getCurrencyName());
            dpriceConfDomain.setDataState(disDpriceSub.getDataState());
            String[] desParams = disDpriceSub.getDpriceConfDes().split(",");
            dpriceConfDomain.setPriceRateTariff(new BigDecimal(desParams[3]));
            dpriceConfDomain.setPriceRateFreight(new BigDecimal(desParams[4]));
            dpriceConfDomain.setPriceRateReturn(new BigDecimal(desParams[5]));
            dpriceConfDomain.setPriceRateForeign(new BigDecimal(desParams[6]));
            confListBuild.add(dpriceConfDomain);
        }
        DisDpriceSubDomain disDpriceConfDomain = disDpriceSubDomainList.get(0);
        DisDprice disDprice = this.getDpriceByCode(disDpriceConfDomain.getTenantCode(), disDpriceConfDomain.getDpriceCode());
        HashMap<String, String> actParamMap = new HashMap<String, String>();
        HashMap<String, Object> sendparamMap = new HashMap<String, Object>();
        ActCommonDomain actCommonDomain = new ActCommonDomain();
        actCommonDomain.setTenantCode(disDprice.getTenantCode());
        actCommonDomain.setBusinessKey(disDprice.getDpriceCode());
        actCommonDomain.setInterfaceType("DisDpriceDomain");
        actCommonDomain.setCallUrl("dis.dprice.updateSubAuditCall");
        actCommonDomain.setParamMap(sendparamMap);
        actCommonDomain.setStartUserType("1");
        actCommonDomain.setStartUser(disDprice.getMemberCode());
        actCommonDomain.setStartName(disDprice.getMemberName());
        actCommonDomain.setUserCode(disDprice.getMemberCode());
        sendparamMap.put("applyUserCode", applyUserCode);
        sendparamMap.put("applyUserName", applyUserName);
        sendparamMap.put("gjjlPrice", gjjlPrice);
        sendparamMap.put("pqPrice", pqPrice);
        sendparamMap.put("dqPrice", dqPrice);
        sendparamMap.put("gjyzPrice", gjyzPrice);
        sendparamMap.put("gjPrice", gjPrice);
        sendparamMap.put("payPrice", payPrice);
        sendparamMap.put("disDprice", disDprice);
        sendparamMap.put("confList", confListBuild);
        sendparamMap.put("submitRemark", auditRemark);
        sendparamMap.put("qualityQtypeCode", qualityQtypeCode);
        sendparamMap.put("dpriceConfIdStr", dpriceSubIdStr.toString());
        sendparamMap.put("title", disDprice.getDpriceId() + "-" + disDprice.getDpriceName());
        actParamMap.put("actCommonDomain", JsonUtil.buildNormalBinder().toJson((Object)actCommonDomain));
        this.internalInvoke("act.actCommonService.activateProcess", actParamMap);
    }
}

