/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.eqc.service.impl;

import com.yqbsoft.laser.service.eqc.dao.EqcConfigMapper;
import com.yqbsoft.laser.service.eqc.dao.EqcTaskMapper;
import com.yqbsoft.laser.service.eqc.domain.EqcConfigDomain;
import com.yqbsoft.laser.service.eqc.domain.EqcTaskDomain;
import com.yqbsoft.laser.service.eqc.model.EqcConfig;
import com.yqbsoft.laser.service.eqc.model.EqcTask;
import com.yqbsoft.laser.service.eqc.service.ConfigService;
import com.yqbsoft.laser.service.eqc.service.impl.EqcTaskServer;
import com.yqbsoft.laser.service.eqc.service.impl.EqcTaskThread;
import com.yqbsoft.laser.service.eqc.service.impl.LoadInfoThread;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DuplicateKeyException;

public class ConfigServiceImpl
extends BaseServiceImpl
implements ConfigService {
    public static final String SYS_CODE = "ConfigServiceImpl.ConfigServiceImpl";
    private EqcConfigMapper eqcConfigMapper;
    private EqcTaskMapper eqcTaskMapper;
    private Map<String, EqcTaskServer> map = new HashMap<String, EqcTaskServer>();
    private Object obj = new Object();

    public void setEqcConfigMapper(EqcConfigMapper eqcConfigMapper) {
        this.eqcConfigMapper = eqcConfigMapper;
    }

    public void setEqcTaskMapper(EqcTaskMapper eqcTaskMapper) {
        this.eqcTaskMapper = eqcTaskMapper;
    }

    private Date getSysDate() {
        try {
            return this.eqcConfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkEqcConfig(EqcConfigDomain eqcConfigDomain) {
        if (null == eqcConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setEqcConfigDefault(EqcConfig eqcConfig) {
        if (null == eqcConfig) {
            return;
        }
        if (null == eqcConfig.getDataState()) {
            eqcConfig.setDataState(0);
        }
        if (StringUtils.isBlank((String)eqcConfig.getConfigCode())) {
            eqcConfig.setConfigCode(this.createUUIDString());
        }
    }

    private int getEqcConfigMaxCode() {
        int code = 0;
        try {
            return this.eqcConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.getEqcConfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setEqcConfigUpdataDefault(EqcConfig eqcConfig) {
        if (null == eqcConfig) {
            return;
        }
    }

    private void saveEqcConfigModel(EqcConfig eqcConfig) throws ApiException {
        if (null == eqcConfig) {
            return;
        }
        try {
            this.eqcConfigMapper.insert(eqcConfig);
        }
        catch (Exception e) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.saveEqcConfigModel.ex", (Throwable)e);
        }
    }

    private EqcConfig getEqcConfigModelById(Integer ConfigID) {
        if (null == ConfigID) {
            return null;
        }
        try {
            return this.eqcConfigMapper.selectByPrimaryKey(ConfigID);
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.getEqcConfigModelById", (Throwable)e);
            return null;
        }
    }

    public EqcConfig getEqcConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.eqcConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.getEqcConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delEqcConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.eqcConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.delEqcConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.delEqcConfigModelByCode.num");
        }
    }

    private void deleteEqcConfigModel(Integer ConfigID) throws ApiException {
        if (null == ConfigID) {
            return;
        }
        int i = 0;
        try {
            i = this.eqcConfigMapper.deleteByPrimaryKey(ConfigID);
        }
        catch (Exception e) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.deleteEqcConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.deleteEqcConfigModel.num");
        }
    }

    private void updateEqcConfigModel(EqcConfig eqcConfig) throws ApiException {
        if (null == eqcConfig) {
            return;
        }
        try {
            this.eqcConfigMapper.updateByPrimaryKeySelective(eqcConfig);
        }
        catch (Exception e) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.updateEqcConfigModel.ex", (Throwable)e);
        }
    }

    private void updateStateEqcConfigModel(Integer ConfigID, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == ConfigID || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigID", ConfigID);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.eqcConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.updateStateEqcConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.updateStateEqcConfigModel.null");
        }
    }

    private EqcConfig makeEqcConfig(EqcConfigDomain eqcConfigDomain, EqcConfig eqcConfig) {
        if (null == eqcConfigDomain) {
            return null;
        }
        if (null == eqcConfig) {
            eqcConfig = new EqcConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)eqcConfig, (Object)eqcConfigDomain);
            return eqcConfig;
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.makeEqcConfig", (Throwable)e);
            return null;
        }
    }

    private List<EqcConfig> queryEqcConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.eqcConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.queryEqcConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countEqcConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.eqcConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.countEqcConfig", (Throwable)e);
        }
        return i;
    }

    private String checkEqcTask(EqcTaskDomain eqcTaskDomain) {
        if (null == eqcTaskDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setEqcTaskDefault(EqcTask eqcTask) {
        if (null == eqcTask) {
            return;
        }
        if (null == eqcTask.getDataState()) {
            eqcTask.setDataState(0);
        }
        if (null == eqcTask.getGmtCreate()) {
            eqcTask.setGmtCreate(this.getSysDate());
        }
        eqcTask.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)eqcTask.getTaskCode())) {
            eqcTask.setTaskCode(this.createUUIDString());
        }
    }

    private int getEqcTaskMaxCode() {
        int code = 0;
        try {
            return this.eqcTaskMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.getEqcTaskMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setEqcTaskUpdataDefault(EqcTask eqcTask) {
        if (null == eqcTask) {
            return;
        }
        eqcTask.setGmtModified(this.getSysDate());
    }

    private void saveEqcTaskModel(EqcTask eqcTask) throws ApiException {
        if (null == eqcTask) {
            return;
        }
        try {
            this.eqcTaskMapper.insert(eqcTask);
        }
        catch (Exception e) {
            if (e instanceof DuplicateKeyException) {
                return;
            }
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.saveEqcTaskModel.ex", (Throwable)e);
        }
    }

    private EqcTask getEqcTaskModelById(Integer TaskId) {
        if (null == TaskId) {
            return null;
        }
        try {
            return this.eqcTaskMapper.selectByPrimaryKey(TaskId);
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.getEqcTaskModelById", (Throwable)e);
            return null;
        }
    }

    public EqcTask getEqcTaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.eqcTaskMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.getEqcTaskModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delEqcTaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.eqcTaskMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.delEqcTaskModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.delEqcTaskModelByCode.num");
        }
    }

    private void deleteEqcTaskModel(Integer TaskId) throws ApiException {
        if (null == TaskId) {
            return;
        }
        int i = 0;
        try {
            i = this.eqcTaskMapper.deleteByPrimaryKey(TaskId);
        }
        catch (Exception e) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.deleteEqcTaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.deleteEqcTaskModel.num");
        }
    }

    private void updateEqcTaskModel(EqcTask eqcTask) throws ApiException {
        if (null == eqcTask) {
            return;
        }
        try {
            this.eqcTaskMapper.updateByPrimaryKeySelective(eqcTask);
        }
        catch (Exception e) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.updateEqcTaskModel.ex", (Throwable)e);
        }
    }

    private void updateStateEqcTaskModel(Integer TaskId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == TaskId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TaskId", TaskId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.eqcTaskMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.updateStateEqcTaskModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.updateStateEqcTaskModel.null");
        }
    }

    private EqcTask makeEqcTask(EqcTaskDomain eqcTaskDomain, EqcTask eqcTask) {
        if (null == eqcTaskDomain) {
            return null;
        }
        if (null == eqcTask) {
            eqcTask = new EqcTask();
        }
        try {
            BeanUtils.copyAllPropertys((Object)eqcTask, (Object)eqcTaskDomain);
            return eqcTask;
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.makeEqcTask", (Throwable)e);
            return null;
        }
    }

    private List<EqcTask> queryEqcTaskModelPage(Map<String, Object> parammap) {
        try {
            return this.eqcTaskMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.queryEqcTaskModel", (Throwable)e);
            return null;
        }
    }

    private int countEqcTask(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.eqcTaskMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ConfigServiceImpl.ConfigServiceImpl.countEqcTask", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveEqcConfig(EqcConfigDomain eqcConfigDomain) throws ApiException {
        String msg = this.checkEqcConfig(eqcConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.saveEqcConfig.checkEqcConfig", msg);
        }
        EqcConfig eqcConfig = this.makeEqcConfig(eqcConfigDomain, null);
        this.setEqcConfigDefault(eqcConfig);
        this.saveEqcConfigModel(eqcConfig);
    }

    @Override
    public void updateEqcConfigState(Integer ConfigID, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateEqcConfigModel(ConfigID, dataState, oldDataState);
    }

    @Override
    public void updateEqcConfig(EqcConfigDomain eqcConfigDomain) throws ApiException {
        String msg = this.checkEqcConfig(eqcConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.updateEqcConfig.checkEqcConfig", msg);
        }
        EqcConfig oldEqcConfig = this.getEqcConfigModelById(eqcConfigDomain.getConfigId());
        if (null == oldEqcConfig) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.updateEqcConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EqcConfig eqcConfig = this.makeEqcConfig(eqcConfigDomain, oldEqcConfig);
        this.setEqcConfigUpdataDefault(eqcConfig);
        this.updateEqcConfigModel(eqcConfig);
    }

    @Override
    public EqcConfig getEqcConfig(Integer ConfigID) {
        return this.getEqcConfigModelById(ConfigID);
    }

    @Override
    public void deleteEqcConfig(Integer ConfigID) throws ApiException {
        this.deleteEqcConfigModel(ConfigID);
    }

    @Override
    public QueryResult<EqcConfig> queryEqcConfigPage(Map<String, Object> map) {
        List<EqcConfig> eqcConfigList = this.queryEqcConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countEqcConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(eqcConfigList);
        return queryResult;
    }

    @Override
    public EqcConfig getEqcConfigByCode(Map<String, Object> map) {
        return this.getEqcConfigModelByCode(map);
    }

    @Override
    public void delEqcConfigByCode(Map<String, Object> map) throws ApiException {
        this.delEqcConfigModelByCode(map);
    }

    @Override
    public void saveEqcTask(EqcTaskDomain eqcTaskDomain) throws ApiException {
        String msg = this.checkEqcTask(eqcTaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.saveEqcTask.checkEqcTask", msg);
        }
        EqcTask eqcTask = this.makeEqcTask(eqcTaskDomain, null);
        this.setEqcTaskDefault(eqcTask);
        this.saveEqcTaskModel(eqcTask);
    }

    @Override
    public void updateEqcTaskState(Integer TaskId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateEqcTaskModel(TaskId, dataState, oldDataState);
    }

    @Override
    public void updateEqcTask(EqcTaskDomain eqcTaskDomain) throws ApiException {
        String msg = this.checkEqcTask(eqcTaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.updateEqcTask.checkEqcTask", msg);
        }
        EqcTask oldEqcTask = this.getEqcTaskModelById(eqcTaskDomain.getTaskId());
        if (null == oldEqcTask) {
            throw new ApiException("ConfigServiceImpl.ConfigServiceImpl.updateEqcTask.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EqcTask eqcTask = this.makeEqcTask(eqcTaskDomain, oldEqcTask);
        this.setEqcTaskUpdataDefault(eqcTask);
        this.updateEqcTaskModel(eqcTask);
    }

    @Override
    public EqcTask getEqcTask(Integer TaskId) {
        return this.getEqcTaskModelById(TaskId);
    }

    @Override
    public void deleteEqcTask(Integer TaskId) throws ApiException {
        this.deleteEqcTaskModel(TaskId);
    }

    @Override
    public QueryResult<EqcTask> queryEqcTaskPage(Map<String, Object> map) {
        List<EqcTask> eqcTaskList = this.queryEqcTaskModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countEqcTask(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(eqcTaskList);
        return queryResult;
    }

    @Override
    public EqcTask getEqcTaskByCode(Map<String, Object> map) {
        return this.getEqcTaskModelByCode(map);
    }

    @Override
    public void delEqcTaskByCode(Map<String, Object> map) throws ApiException {
        this.delEqcTaskModelByCode(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EqcTaskServer getServer(EqcConfig c) {
        Object object = this.obj;
        synchronized (object) {
            if (null == this.map.get(c.getConfigCode())) {
                EqcTaskServer server = new EqcTaskServer(c);
                this.map.put(c.getConfigCode(), server);
                return server;
            }
            return this.map.get(c.getConfigCode());
        }
    }

    @Override
    public void loadEqcConfig() {
        List<EqcConfig> list = this.queryEqcConfigModelPage(this.getQueryParamMap("dataState", new Object[]{0}));
        ConfigService configService = (ConfigService)SpringApplicationContextUtil.getBean((String)"configService");
        if (null != list && list.size() > 0) {
            for (EqcConfig c : list) {
                EqcTaskServer s = this.getServer(c);
                s.addservicePool(new LoadInfoThread(s, configService), 30L);
                for (int i = 0; i < c.getConsumerCount(); ++i) {
                    s.addPollPool(new EqcTaskThread(s, configService, this.getInternalRouter()));
                }
            }
        }
    }
}

