/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.eqc.service.impl;

import com.yqbsoft.laser.service.eqc.model.EqcConfig;
import com.yqbsoft.laser.service.eqc.model.EqcTask;
import com.yqbsoft.laser.service.eqc.service.impl.EqcTaskThread;
import com.yqbsoft.laser.service.eqc.service.impl.LoadInfoThread;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EqcTaskServer {
    final int QUEUE_SIZE = 250;
    public LinkedBlockingQueue<EqcTask> abq = new LinkedBlockingQueue(250);
    private int min = 1;
    private EqcConfig config;
    private int max;
    private ThreadPoolExecutor pollExecutor;
    private ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
    private Object offLock = new Object();
    private Object pollQueueLock = new Object();
    protected Map<String, String> tkeyMap = new ConcurrentHashMap<String, String>();

    public EqcTaskServer(EqcConfig config) {
        this.config = config;
        this.max = config.getConsumerCount();
        this.pollExecutor = new ThreadPoolExecutor(this.min, this.max, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public EqcConfig getConfig() {
        return this.config;
    }

    public void setConfig(EqcConfig config) {
        this.config = config;
    }

    public boolean isEmpty() {
        return this.abq.isEmpty();
    }

    public boolean shutdownPollExecutor() {
        if (null == this.pollExecutor || this.pollExecutor.isShutdown()) {
            return true;
        }
        this.pollExecutor.shutdown();
        return true;
    }

    public boolean shutdownPutExecutor() {
        if (null == this.service || this.service.isShutdown()) {
            return true;
        }
        this.service.shutdown();
        return true;
    }

    public void addPollPool(EqcTaskThread pollThread) {
        this.pollExecutor.execute(pollThread);
    }

    public void addservicePool(LoadInfoThread loadThread, long s) {
        this.service.scheduleWithFixedDelay(loadThread, 1L, s, TimeUnit.SECONDS);
    }

    private boolean putKey(EqcTask t) {
        String key = this.getKey(t);
        if (null == key) {
            key = "";
        }
        if (this.tkeyMap.containsKey(key)) {
            return false;
        }
        this.tkeyMap.put(key, key);
        return true;
    }

    public boolean removeKey(EqcTask t) {
        String key = this.getKey(t);
        if (null == key) {
            key = "";
        }
        this.tkeyMap.remove(key);
        return true;
    }

    protected String getKey(EqcTask t) {
        return t.getTaskKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putQueue(EqcTask t) {
        Object object = this.offLock;
        synchronized (object) {
            try {
                if (this.abq.contains(t) || !this.putKey(t)) {
                    return true;
                }
                this.abq.put(t);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putQueueRepeat(EqcTask t) {
        Object object = this.offLock;
        synchronized (object) {
            try {
                if (this.abq.contains(t)) {
                    return true;
                }
                this.abq.put(t);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EqcTask pollQueue() {
        Object object = this.pollQueueLock;
        synchronized (object) {
            try {
                EqcTask t = this.abq.poll();
                return t;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

