/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.eqc.service.impl;

import com.yqbsoft.laser.service.eqc.domain.EqcTaskDomain;
import com.yqbsoft.laser.service.eqc.model.EqcConfig;
import com.yqbsoft.laser.service.eqc.model.EqcTask;
import com.yqbsoft.laser.service.eqc.service.ConfigService;
import com.yqbsoft.laser.service.eqc.service.impl.EqcTaskServer;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class EqcTaskThread
extends Thread {
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private ConfigService configService;
    private EqcConfig config;
    private EqcTaskServer server;
    private InternalRouter internalRouter;

    public EqcTaskThread(EqcTaskServer server, ConfigService configService, InternalRouter internalRouter) {
        this.server = server;
        this.config = server.getConfig();
        this.configService = configService;
        this.internalRouter = internalRouter;
    }

    @Override
    public void run() {
        while (true) {
            EqcTask t = this.server.pollQueue();
            try {
                if (null != t) {
                    String rule;
                    if (null == t.getError()) {
                        t.setError(0);
                    }
                    if ("0".equals(rule = this.config.getCallRule())) {
                        if (t.getError() < Integer.valueOf(this.config.getRuleInfo())) {
                            this.toStart(t);
                        } else {
                            t.setDataState(1);
                            this.save(t);
                        }
                    } else if ("1".equals(rule)) {
                        if (DateUtils.parseTime((Date)new Date(), (Date)DateUtils.getDateToString((String)this.config.getRuleInfo(), (String)"HH:mm:ss"))) {
                            this.toStart(t);
                        } else if (t.getError() >= 1) {
                            t.setDataState(1);
                            this.save(t);
                        } else {
                            this.server.putQueueRepeat(t);
                        }
                    } else if ("2".equals(rule)) {
                        String[] ruleinfo = this.config.getRuleInfo().split(",");
                        if (t.getError() >= ruleinfo.length + 1) {
                            t.setDataState(1);
                            this.save(t);
                        } else if (t.getError() == 0) {
                            this.toStart(t);
                        } else {
                            Date d = DateUtils.addMinutes((Date)t.getGmtModified(), (int)Integer.valueOf(ruleinfo[t.getError() - 1]));
                            if (DateUtils.parseTime((Date)new Date(), (Date)d)) {
                                this.toStart(t);
                            } else {
                                this.server.putQueueRepeat(t);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                t.setMemo(StringUtils.substring((String)e.getMessage(), (int)0, (int)500));
                this.server.putQueueRepeat(t);
            }
            super.run();
        }
    }

    private void toStart(EqcTask t) throws Exception {
        t.setError(t.getError() + 1);
        t.setGmtModified(new Date());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String parameter = t.getParameter();
        String[] value = parameter.split("&");
        String paramterKey = this.config.getParameterKey();
        String[] key = paramterKey.split(",");
        for (int i = 0; i < key.length; ++i) {
            paramMap.put(key[i], value[i]);
        }
        this.internalRouter.inInvoke(this.config.getApiCode(), paramMap);
        t.setDataState(2);
        this.save(t);
    }

    private void save(EqcTask t) {
        EqcTaskDomain tdomian = new EqcTaskDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tdomian, (Object)t);
        }
        catch (Exception e) {
            this.logger.error("copy", (Object)e.getMessage());
        }
        this.configService.updateEqcTask(tdomian);
        this.server.removeKey(t);
    }
}

