/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.eqc.service.impl;

import com.yqbsoft.laser.service.eqc.model.EqcConfig;
import com.yqbsoft.laser.service.eqc.model.EqcTask;
import com.yqbsoft.laser.service.eqc.service.ConfigService;
import com.yqbsoft.laser.service.eqc.service.impl.EqcTaskServer;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.util.HashMap;
import java.util.Random;

public class LoadInfoThread
extends Thread {
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private ConfigService configService;
    private EqcConfig config;
    private EqcTaskServer server;
    private int rows = 300;
    private int pagesize = 1;

    public LoadInfoThread(EqcTaskServer server, ConfigService configService) {
        this.configService = configService;
        this.server = server;
        this.config = server.getConfig();
    }

    @Override
    public void run() {
        try {
            if (this.server.isEmpty()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("configCode", this.config.getConfigCode());
                map.put("dataState", 0);
                map.put("appmanageIcode", this.config.getAppmanageIcode());
                map.put("startRow", (this.pagesize - 1) * this.rows);
                map.put("rows", this.rows);
                QueryResult<EqcTask> rs = this.configService.queryEqcTaskPage(map);
                if (rs == null || rs.getList() == null || rs.getList().size() == 0) {
                    this.pagesize = 1;
                    return;
                }
                for (EqcTask t : rs.getList()) {
                    this.server.putQueue(t);
                }
                Thread.sleep(Long.valueOf(new Random().nextDouble() * 2000.0 + 1000.0 + ""));
                ++this.pagesize;
            }
        }
        catch (Exception e) {
            this.logger.error("LoadInfoThread:--", (Object)e.getMessage());
        }
        super.run();
    }
}

