/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppwarDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AppwarUpdateDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppwar;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppwarJar;
import com.yqbsoft.laser.service.esb.appmanage.service.AmAppRegisterService;
import com.yqbsoft.laser.service.esb.appmanage.service.AmAppwarService;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.point.RegeditBean;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AmAppRegisterServiceImpl
extends BaseServiceImpl
implements AmAppRegisterService {
    private static final String SYS_CODE = "am.ESB.APPMANAGE.AmAppRegisterServiceImpl";
    public static final String VFOAPPMANAGE_LINEINFO = "EcoreAppmanage-lineInfo";
    private AmAppwarService amAppwarService;
    private static String cache = "AmAppwar-jar";
    private static String cachewar = "AmAppwar-icode";
    private static String APPMANAGE_KEY = "Appmanage-key-line";
    public static final Long REGEDIT_OVER_TIME = 40000L;

    public AmAppwarService getAmAppwarService() {
        return this.amAppwarService;
    }

    public void setAmAppwarService(AmAppwarService amAppwarService) {
        this.amAppwarService = amAppwarService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveCacheToAppwar() {
        try {
            AmAppRegisterServiceImpl amAppRegisterServiceImpl = this;
            synchronized (amAppRegisterServiceImpl) {
                Map appMap = DisUtil.getRemotMapAll((String)VFOAPPMANAGE_LINEINFO);
                Map warkeyMap = DisUtil.getRemotMapAll((String)"EcoreAppwar-pro");
                this.check(appMap, warkeyMap);
            }
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.queryCacheToAppwar.e", (Object)"", (Throwable)e);
        }
    }

    public static List<RegeditBean> getPointAppKeys(String appmanageIcode) {
        if (StringUtils.isBlank((String)appmanageIcode)) {
            return null;
        }
        Map appkeyMap = DisUtil.getMapAll((String)APPMANAGE_KEY);
        if (null == appkeyMap || appkeyMap.isEmpty()) {
            return null;
        }
        ArrayList<RegeditBean> list = new ArrayList<RegeditBean>();
        for (String key : appkeyMap.keySet()) {
            RegeditBean regeditBean;
            if (!appmanageIcode.equals(appkeyMap.get(key)) || (regeditBean = AmAppRegisterServiceImpl.getRegeditBean(key)) == null) continue;
            list.add(regeditBean);
        }
        return list;
    }

    public static RegeditBean getRegeditBean(String appmanageAppkey) {
        String js = DisUtil.getMap((String)VFOAPPMANAGE_LINEINFO, (String)appmanageAppkey);
        if (StringUtils.isBlank((String)js)) {
            return null;
        }
        RegeditBean regeditBean = (RegeditBean)JsonUtil.buildNormalBinder().getJsonToObject(js, RegeditBean.class);
        return regeditBean;
    }

    private void setNgCache(RegeditBean regeditBean, String tenantCode) {
        String listStr;
        if (null == regeditBean) {
            return;
        }
        String type = regeditBean.getApptype();
        if (StringUtils.isBlank((String)type)) {
            type = "1";
        }
        if (StringUtils.isBlank((String)(listStr = DisUtil.getMap((String)cache, (String)(regeditBean.getAppIcode() + "-" + type + "-" + tenantCode))))) {
            return;
        }
        List jarList = (List)JsonUtil.buildNormalBinder().getJsonToList(listStr, AmAppwarJar.class);
        if (null == jarList || jarList.isEmpty()) {
            return;
        }
        List<RegeditBean> list = AmAppRegisterServiceImpl.getPointAppKeys(regeditBean.getAppkey());
        String url = regeditBean.getAppIp() + ":" + regeditBean.getAppPort() + (StringUtils.isNotBlank((String)regeditBean.getContextPath()) ? "/" + regeditBean.getContextPath() : "");
        if (ListUtil.isNotEmpty(list)) {
            String purl = "";
            for (RegeditBean regeditBean1 : list) {
                if (!StringUtils.isNotBlank((String)regeditBean1.getAppIp())) continue;
                if (StringUtils.isNotBlank((String)purl)) {
                    purl = purl + ",";
                }
                purl = purl + regeditBean.getAppIp() + ":" + regeditBean.getAppPort() + (StringUtils.isNotBlank((String)regeditBean.getContextPath()) ? "/" + regeditBean.getContextPath() : "");
            }
            if (StringUtils.isNotBlank((String)purl)) {
                url = purl;
            }
        }
        for (AmAppwarJar amAppwarJar : jarList) {
            String key = amAppwarJar.getAppmanageIcode();
            if (StringUtils.isBlank((String)key) || key.indexOf(".") < 0) continue;
            key = "/" + key.replace(".", "/");
            DisUtil.set((String)key, (String)url);
        }
    }

    private void setNgPcodeCache(RegeditBean regeditBean, String tenantCode) {
        String listStr;
        if (null == regeditBean) {
            return;
        }
        String type = regeditBean.getApptype();
        if (StringUtils.isBlank((String)type)) {
            type = "1";
        }
        if (StringUtils.isBlank((String)(listStr = DisUtil.getMap((String)cachewar, (String)(regeditBean.getAppIcode() + "-" + tenantCode))))) {
            return;
        }
        List warList = (List)JsonUtil.buildNormalBinder().getJsonToList(listStr, AmAppwar.class);
        if (null == warList || warList.isEmpty()) {
            return;
        }
        List<RegeditBean> list = AmAppRegisterServiceImpl.getPointAppKeys(regeditBean.getAppkey());
        String url = regeditBean.getAppIp() + ":" + regeditBean.getAppPort() + (StringUtils.isNotBlank((String)regeditBean.getContextPath()) ? "/" + regeditBean.getContextPath() : "");
        if (ListUtil.isNotEmpty(list)) {
            String purl = "";
            for (RegeditBean regeditBean1 : list) {
                if (!StringUtils.isNotBlank((String)regeditBean1.getAppIp())) continue;
                if (StringUtils.isNotBlank((String)purl)) {
                    purl = purl + ",";
                }
                purl = purl + regeditBean.getAppIp() + ":" + regeditBean.getAppPort() + (StringUtils.isNotBlank((String)regeditBean.getContextPath()) ? "/" + regeditBean.getContextPath() : "");
            }
            if (StringUtils.isNotBlank((String)purl)) {
                url = purl;
            }
        }
        for (AmAppwar amAppwar : warList) {
            String key = amAppwar.getAppwarIcode();
            key = "/" + key;
            DisUtil.set((String)key, (String)url);
        }
    }

    private void check(Map<String, String> appMap, Map<String, String> warkeyMap) {
        RegeditBean regeditBean;
        String regejson;
        if (null != warkeyMap) {
            regejson = null;
            for (String key : warkeyMap.keySet()) {
                AmAppwar amAppwar = (AmAppwar)JsonUtil.buildNormalBinder().getJsonToObject(warkeyMap.get(key), AmAppwar.class);
                regejson = DisUtil.getRemotMap((String)VFOAPPMANAGE_LINEINFO, (String)key);
                if (StringUtils.isNotBlank((String)regejson)) {
                    regeditBean = (RegeditBean)JsonUtil.buildNormalBinder().getJsonToObject(regejson, RegeditBean.class);
                    this.updateAppwar(amAppwar, regeditBean);
                    this.setNgCache(regeditBean, amAppwar.getTenantCode());
                    this.setNgPcodeCache(regeditBean, amAppwar.getTenantCode());
                    continue;
                }
                if ("2".equals(amAppwar.getAppwarType())) continue;
                this.updateAppwar(amAppwar);
            }
        }
        if (null == appMap) {
            return;
        }
        for (String key : appMap.keySet()) {
            if (null != warkeyMap && null != warkeyMap.get(key)) continue;
            regejson = DisUtil.getRemotMap((String)VFOAPPMANAGE_LINEINFO, (String)key);
            regeditBean = (RegeditBean)JsonUtil.buildNormalBinder().getJsonToObject(regejson, RegeditBean.class);
            if (this.delAppCache(regeditBean)) continue;
            this.insertAppwar(regeditBean);
        }
    }

    private void insertAppwar(RegeditBean regeditBean) {
        if (null == regeditBean) {
            return;
        }
        AmAppwarDomain amAppwarDomain = new AmAppwarDomain();
        amAppwarDomain.setAppwarAppkey(regeditBean.getAppkey());
        amAppwarDomain.setAppwarApptype(regeditBean.getApptype());
        amAppwarDomain.setAppwarFwtype("0");
        amAppwarDomain.setAppwarIcode(regeditBean.getAppIcode());
        amAppwarDomain.setAppwarName(regeditBean.getAppIcode());
        amAppwarDomain.setAppwarType(regeditBean.getApptype());
        if (StringUtils.isBlank((String)amAppwarDomain.getAppwarType())) {
            if (regeditBean.getAppIcode().indexOf("con") == 0) {
                amAppwarDomain.setAppwarType("1");
            } else {
                amAppwarDomain.setAppwarType("0");
            }
        }
        amAppwarDomain.setAppwarUuid(regeditBean.getAppUuid());
        amAppwarDomain.setAppwarIp(regeditBean.getAppIp());
        amAppwarDomain.setAppwarVirip(regeditBean.getAppVirIp());
        amAppwarDomain.setAppwarPort(regeditBean.getAppPort());
        amAppwarDomain.setAppwarContext(regeditBean.getContextPath());
        amAppwarDomain.setAppwarDomain("http://" + regeditBean.getAppIp() + ":" + regeditBean.getAppPort() + "/" + regeditBean.getContextPath());
        amAppwarDomain.setTenantCode("00000000");
        this.amAppwarService.saveAppwar(amAppwarDomain);
    }

    private boolean delAppCache(RegeditBean regeditBean) {
        if (null == regeditBean) {
            return false;
        }
        if (System.currentTimeMillis() > regeditBean.getLastDate().getTime() + REGEDIT_OVER_TIME) {
            this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.delAppCache.cache", (Object)(regeditBean.getAppkey() + "=" + DateUtil.getDateString((Date)regeditBean.getLastDate(), (String)"yyyy-MM-dd HH:mm:ss")));
            DisUtil.delMap((String)VFOAPPMANAGE_LINEINFO, (String[])new String[]{regeditBean.getAppkey()});
            return true;
        }
        return false;
    }

    private void updateAppwar(AmAppwar amAppwar) {
        if (null == amAppwar) {
            return;
        }
        AppwarUpdateDomain appwarUpdateDomain = new AppwarUpdateDomain();
        appwarUpdateDomain.setAppwarAppkey(amAppwar.getAppwarAppkey());
        appwarUpdateDomain.setTenantCode(amAppwar.getTenantCode());
        appwarUpdateDomain.setAppwarIcode(amAppwar.getAppwarIcode());
        appwarUpdateDomain.setAppwarPort(amAppwar.getAppwarPort());
        appwarUpdateDomain.setAppwarContext(amAppwar.getAppwarContext());
        appwarUpdateDomain.setDataStateOld(amAppwar.getDataStateOld());
        this.updateAppwaruuid(amAppwar, appwarUpdateDomain);
    }

    private void updateAppwaruuid(AmAppwar amAppwar, AppwarUpdateDomain appwarUpdateDomain) {
        if (null == appwarUpdateDomain || null == amAppwar) {
            return;
        }
        amAppwar.setAppwarIp(appwarUpdateDomain.getAppwarIp());
        amAppwar.setAppwarDomain(appwarUpdateDomain.getAppwarDomain());
        amAppwar.setAppwarUuid(appwarUpdateDomain.getAppwarUuid());
        amAppwar.setDataStateOld(appwarUpdateDomain.getDataStateOld());
        amAppwar.setAppwarPort(appwarUpdateDomain.getAppwarPort());
        amAppwar.setAppwarContext(appwarUpdateDomain.getAppwarContext());
        amAppwar.setDataState(1);
        this.amAppwarService.updateAppwaruuid(appwarUpdateDomain);
        DisUtil.setMap((String)"EcoreAppwar-pro", (String)amAppwar.getAppwarAppkey(), (String)JsonUtil.buildNonDefaultBinder().toJson((Object)amAppwar));
    }

    private void updateAppwar(AmAppwar amAppwar, RegeditBean regeditBean) {
        if (null == amAppwar || null == regeditBean) {
            return;
        }
        AppwarUpdateDomain appwarUpdateDomain = new AppwarUpdateDomain();
        appwarUpdateDomain.setAppwarAppkey(amAppwar.getAppwarAppkey());
        appwarUpdateDomain.setTenantCode(amAppwar.getTenantCode());
        appwarUpdateDomain.setAppwarIcode(amAppwar.getAppwarIcode());
        appwarUpdateDomain.setAppwarIp(regeditBean.getAppIp());
        appwarUpdateDomain.setAppwarVirip(regeditBean.getAppVirIp());
        appwarUpdateDomain.setAppwarUuid(regeditBean.getAppUuid());
        appwarUpdateDomain.setAppwarPort(regeditBean.getAppPort());
        appwarUpdateDomain.setAppwarContext(regeditBean.getContextPath());
        appwarUpdateDomain.setAppwarType(regeditBean.getApptype());
        String domain = "http://" + regeditBean.getAppIp() + ":" + regeditBean.getAppPort() + "/" + regeditBean.getContextPath();
        appwarUpdateDomain.setAppwarDomain(domain);
        appwarUpdateDomain.setDataStateOld(0);
        if (!this.delAppCache(regeditBean)) {
            if (this.checkHealthy(domain)) {
                appwarUpdateDomain.setDataStateOld(1);
            } else {
                this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.updateAppwar.checkHealthy", (Object)amAppwar.getAppwarAppkey());
            }
        } else {
            this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.updateAppwar.cache", (Object)amAppwar.getAppwarAppkey());
        }
        this.updateAppwaruuid(amAppwar, appwarUpdateDomain);
    }

    private boolean checkHealthy(String domain) {
        if (StringUtils.isBlank((String)domain)) {
            return false;
        }
        try {
            String res = WebUtils.doGet((String)(domain + "/laserDirect/healthy"), null);
            if ("ok".equals(res)) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.checkHealthy.e", (Object)(domain + "/laserDirect/healthy"), (Throwable)e);
        }
        return false;
    }
}

