/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.dao.AmCachekeyMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmCachekeyDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmCachekey;
import com.yqbsoft.laser.service.esb.appmanage.service.AmCachekeyService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.router.AppState;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

public class AmCachekeyServiceImpl
extends BaseServiceImpl
implements AmCachekeyService {
    public static final String SYS_CODE = "am.ESB.APPMANAGE.AmCachekeyServiceImpl";
    private AmCachekeyMapper amCachekeyMapper;

    public void setAmCachekeyMapper(AmCachekeyMapper amCachekeyMapper) {
        this.amCachekeyMapper = amCachekeyMapper;
    }

    private Date getSysDate() {
        try {
            return this.amCachekeyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmCachekeyServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCachekey(AmCachekeyDomain amCachekeyDomain) {
        if (null == amCachekeyDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setCachekeyDefault(AmCachekey amCachekey) {
        if (null == amCachekey) {
            return;
        }
        if (null == amCachekey.getDataState()) {
            amCachekey.setDataState(0);
        }
        if (null == amCachekey.getGmtCreate()) {
            amCachekey.setGmtCreate(this.getSysDate());
        }
        amCachekey.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.amCachekeyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmCachekeyServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCachekeyUpdataDefault(AmCachekey amCachekey) {
        if (null == amCachekey) {
            return;
        }
        amCachekey.setGmtModified(this.getSysDate());
    }

    private void saveCachekeyModel(AmCachekey amCachekey) throws ApiException {
        if (null == amCachekey) {
            return;
        }
        try {
            this.amCachekeyMapper.insert(amCachekey);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmCachekeyServiceImpl.saveCachekeyModel.ex", (Throwable)e);
        }
    }

    private AmCachekey getCachekeyModelById(Integer cachekeyId) {
        if (null == cachekeyId) {
            return null;
        }
        try {
            return this.amCachekeyMapper.selectByPrimaryKey(cachekeyId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmCachekeyServiceImpl.getCachekeyModelById", (Throwable)e);
            return null;
        }
    }

    public AmCachekey getCachekeyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.amCachekeyMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmCachekeyServiceImpl.getCachekeyModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delCachekeyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.amCachekeyMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmCachekeyServiceImpl.delCachekeyModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmCachekeyServiceImpl.delCachekeyModelByCode.num");
        }
    }

    private void deleteCachekeyModel(Integer cachekeyId) throws ApiException {
        if (null == cachekeyId) {
            return;
        }
        int i = 0;
        try {
            i = this.amCachekeyMapper.deleteByPrimaryKey(cachekeyId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmCachekeyServiceImpl.deleteCachekeyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmCachekeyServiceImpl.deleteCachekeyModel.num");
        }
    }

    private void updateCachekeyModel(AmCachekey amCachekey) throws ApiException {
        if (null == amCachekey) {
            return;
        }
        try {
            this.amCachekeyMapper.updateByPrimaryKeySelective(amCachekey);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmCachekeyServiceImpl.updateCachekeyModel.ex", (Throwable)e);
        }
    }

    private void updateStateCachekeyModel(Integer cachekeyKey, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == cachekeyKey || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cachekeyKey", cachekeyKey);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amCachekeyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmCachekeyServiceImpl.updateStateCachekeyModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmCachekeyServiceImpl.updateStateCachekeyModel.null");
        }
    }

    private AmCachekey makeCachekey(AmCachekeyDomain amCachekeyDomain, AmCachekey amCachekey) {
        if (null == amCachekeyDomain) {
            return null;
        }
        if (null == amCachekey) {
            amCachekey = new AmCachekey();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amCachekey, (Object)amCachekeyDomain);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmCachekeyServiceImpl.makeCachekey", (Throwable)e);
        }
        return amCachekey;
    }

    private List<AmCachekey> queryCachekeyModelPage(Map<String, Object> parammap) {
        try {
            return this.amCachekeyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmCachekeyServiceImpl.queryCachekeyModel", (Throwable)e);
            return null;
        }
    }

    private int countCachekey(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amCachekeyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmCachekeyServiceImpl.countCachekey", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveCachekey(AmCachekeyDomain amCachekeyDomain) throws ApiException {
        String msg = this.checkCachekey(amCachekeyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmCachekeyServiceImpl.saveCachekey.checkCachekey", msg);
        }
        AmCachekey amCachekey = this.makeCachekey(amCachekeyDomain, null);
        this.setCachekeyDefault(amCachekey);
        this.saveCachekeyModel(amCachekey);
    }

    @Override
    public void updateCachekeyState(Integer cachekeyKey, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCachekeyModel(cachekeyKey, dataState, oldDataState);
    }

    @Override
    public void updateCachekey(AmCachekeyDomain amCachekeyDomain) throws ApiException {
        String msg = this.checkCachekey(amCachekeyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmCachekeyServiceImpl.updateCachekey.checkCachekey", msg);
        }
        AmCachekey oldAmCachekey = this.getCachekeyModelById(amCachekeyDomain.getCachekeyId());
        if (null == oldAmCachekey) {
            throw new ApiException("am.ESB.APPMANAGE.AmCachekeyServiceImpl.updateCachekey.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmCachekey amCachekey = this.makeCachekey(amCachekeyDomain, oldAmCachekey);
        this.setCachekeyUpdataDefault(amCachekey);
        this.updateCachekeyModel(amCachekey);
    }

    @Override
    public AmCachekey getCachekey(Integer cachekeyId) {
        return this.getCachekeyModelById(cachekeyId);
    }

    @Override
    public void deleteCachekey(Integer cachekeyId) throws ApiException {
        this.deleteCachekeyModel(cachekeyId);
    }

    @Override
    public QueryResult<AmCachekey> queryCachekeyPage(Map<String, Object> map) {
        List<AmCachekey> amCachekeyList = this.queryCachekeyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCachekey(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amCachekeyList);
        return queryResult;
    }

    @Override
    public void queryKeyCache() {
        this.info("am.ESB.APPMANAGE.AmCachekeyServiceImpl.queryKeyCache.start", "=======cachekey\u8c03\u5ea6start=======");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataStates", AppState.getAllStateCode());
        List<AmCachekey> cachekeyList = this.queryCachekeyModelPage(params);
        if (CollectionUtils.isEmpty(cachekeyList)) {
            DisUtil.delVer((String)"synctimer");
            this.info("am.ESB.APPMANAGE.AmCachekeyServiceImpl.queryKeyCache.del", "=======cachekey\u8c03\u5ea6end=======");
            return;
        }
        ConcurrentHashMap<String, String> mmap = new ConcurrentHashMap<String, String>();
        for (AmCachekey amCachekey : cachekeyList) {
            mmap.put(amCachekey.getCachekeyKey(), amCachekey.getCachekeyTime());
        }
        DisUtil.setMap((String)"synctimer", mmap);
        this.info("am.ESB.APPMANAGE.AmCachekeyServiceImpl.queryKeyCache.end", "=======cachekey\u8c03\u5ea6end=======");
    }

    @Override
    public AmCachekey getCachekeyNew(Integer cachekeyId) {
        return this.getCachekeyModelById(cachekeyId);
    }
}

