/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.AppManageConstants;
import com.yqbsoft.laser.service.esb.appmanage.dao.AmAppapiErrorMapper;
import com.yqbsoft.laser.service.esb.appmanage.dao.AmAppapiMapper;
import com.yqbsoft.laser.service.esb.appmanage.dao.AmAppapiParamMapper;
import com.yqbsoft.laser.service.esb.appmanage.dao.AmAppapiRouterMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppapiDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppapiErrorDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppapiErrorReDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppapiParamDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppapiParamReDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppapiReDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppapiRouterDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppapiRouterReDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmDataparamListReDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppapi;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppapiError;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppapiParam;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppapiRouter;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppapimng;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppapimngParam;
import com.yqbsoft.laser.service.esb.appmanage.service.AppapiService;
import com.yqbsoft.laser.service.esb.appmanage.service.DataparamService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.router.ApiProperty;
import com.yqbsoft.laser.service.suppercore.router.ApiRouterProperty;
import com.yqbsoft.laser.service.suppercore.router.ApiState;
import com.yqbsoft.laser.service.suppercore.transformer.ApiError;
import com.yqbsoft.laser.service.suppercore.transformer.ApiParam;
import com.yqbsoft.laser.service.suppercore.transformer.Dataparam;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.TokenUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class AppapiServiceImpl
extends BaseServiceImpl
implements AppapiService {
    public static final String SYS_CODE = "am.ESB.APPMANAGE.AppapiServiceImpl";
    private AmAppapiMapper amAppapiMapper;
    private AmAppapiParamMapper amAppapiParamMapper;
    private AmAppapiRouterMapper amAppapiRouterMapper;
    private AmAppapiErrorMapper amAppapiErrorMapper;
    private DataparamService dataparamService;

    public void setDataparamService(DataparamService dataparamService) {
        this.dataparamService = dataparamService;
    }

    public AmAppapiParamMapper getAmAppapiParamMapper() {
        return this.amAppapiParamMapper;
    }

    public void setAmAppapiParamMapper(AmAppapiParamMapper amAppapiParamMapper) {
        this.amAppapiParamMapper = amAppapiParamMapper;
    }

    public AmAppapiRouterMapper getAmAppapiRouterMapper() {
        return this.amAppapiRouterMapper;
    }

    public void setAmAppapiRouterMapper(AmAppapiRouterMapper amAppapiRouterMapper) {
        this.amAppapiRouterMapper = amAppapiRouterMapper;
    }

    public AmAppapiErrorMapper getAmAppapiErrorMapper() {
        return this.amAppapiErrorMapper;
    }

    public void setAmAppapiErrorMapper(AmAppapiErrorMapper amAppapiErrorMapper) {
        this.amAppapiErrorMapper = amAppapiErrorMapper;
    }

    public AmAppapiMapper getAmAppapiMapper() {
        return this.amAppapiMapper;
    }

    public void setAmAppapiMapper(AmAppapiMapper amAppapiMapper) {
        this.amAppapiMapper = amAppapiMapper;
    }

    private String check(AmAppapi amAppapi) {
        if (null == amAppapi) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amAppapi.getAppapiCode())) {
            msg = msg + "APICODE\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amAppapi.getAppmanageAppkey())) {
            msg = msg + "APPKEY\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkDomain(AmAppapiDomain amAppapiDomain) {
        if (null == amAppapiDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setDefault(AmAppapi amAppapi) {
        if (null == amAppapi) {
            return;
        }
        if (null == amAppapi.getAppapiVersion()) {
            amAppapi.setAppapiVersion("1.0");
        }
        if (null == amAppapi.getDataState()) {
            amAppapi.setDataState(0);
        }
        if (null == amAppapi.getDataCstate()) {
            amAppapi.setDataCstate(0);
        }
        if (null == amAppapi.getGmtCreate()) {
            amAppapi.setGmtCreate(this.getSysDate());
        }
    }

    private void saveApiMode(AmAppapi amAppapi) throws ApiException {
        if (null == amAppapi) {
            return;
        }
        try {
            this.amAppapiMapper.insert(amAppapi);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.saveApiMode.ex", (Throwable)e);
        }
    }

    private Date getSysDate() {
        try {
            return this.amAppapiMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String check(AmAppapiParam amAppapiParam) {
        if (null == amAppapiParam) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amAppapiParam.getAppapiCode())) {
            msg = msg + "APICODE\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amAppapiParam.getAppapiVersion())) {
            msg = msg + "APIVERSION\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(AmAppapiParam amAppapiParam) {
        if (null == amAppapiParam) {
            return;
        }
        if (null == amAppapiParam.getDataState()) {
            amAppapiParam.setDataState(0);
        }
        if (null == amAppapiParam.getDataCstate()) {
            amAppapiParam.setDataCstate(0);
        }
        if (null == amAppapiParam.getGmtCreate()) {
            amAppapiParam.setGmtCreate(this.getSysDate());
        }
    }

    private void saveApiParamMode(AmAppapiParam amAppapiParam) throws ApiException {
        if (null == amAppapiParam) {
            return;
        }
        try {
            this.amAppapiParamMapper.insert(amAppapiParam);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.saveApiParamMode.ex", (Throwable)e);
        }
    }

    private String check(AmAppapiRouter amAppapiRouter) {
        if (null == amAppapiRouter) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amAppapiRouter.getAppapiCode())) {
            msg = msg + "APICODE\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amAppapiRouter.getAppapiVersion())) {
            msg = msg + "APIVERSION\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(AmAppapiRouter amAppapiRouter) {
        if (null == amAppapiRouter) {
            return;
        }
        if (null == amAppapiRouter.getDataState()) {
            amAppapiRouter.setDataState(0);
        }
        if (null == amAppapiRouter.getGmtCreate()) {
            amAppapiRouter.setGmtCreate(this.getSysDate());
        }
    }

    private void saveApiRouterMode(AmAppapiRouter amAppapiRouter) throws ApiException {
        if (null == amAppapiRouter) {
            return;
        }
        try {
            this.amAppapiRouterMapper.insert(amAppapiRouter);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.saveApiRouterMode.ex", (Throwable)e);
        }
    }

    private String check(AmAppapiError amAppapiError) {
        if (null == amAppapiError) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amAppapiError.getAppapiCode())) {
            msg = msg + "APICODE\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amAppapiError.getAppapiVersion())) {
            msg = msg + "APIVERSION\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(AmAppapiError amAppapiError) {
        if (null == amAppapiError) {
            return;
        }
        if (null == amAppapiError.getDataState()) {
            amAppapiError.setDataState(0);
        }
        if (null == amAppapiError.getGmtCreate()) {
            amAppapiError.setGmtCreate(this.getSysDate());
        }
    }

    private void saveApiErrorMode(AmAppapiError amAppapiError) throws ApiException {
        if (null == amAppapiError) {
            return;
        }
        try {
            this.amAppapiErrorMapper.insert(amAppapiError);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.saveApiErrorMode.ex", (Throwable)e);
        }
    }

    private void updateStateAppapiMode(Integer appapiId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == appapiId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiId", appapiId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amAppapiMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiMode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiMode.null");
        }
    }

    private void updateStateAppapiModeByCodeVersion(String appapiCode, String appapiVersion, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == appapiCode || null == appapiVersion) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiCode", appapiCode);
        map.put("appapiVersion", appapiVersion);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amAppapiMapper.updateStateByCodeVersion(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiMode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiMode.null");
        }
    }

    private void updateAppapiCheckMode(Integer appapiId, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        if (null == appapiId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiId", appapiId);
        map.put("dataState", dataState);
        if (dataState == 0) {
            map.put("dataCstate", 0);
        }
        if (dataState == 1) {
            map.put("dataCstate", 1);
        }
        map.put("oldDataState", oldDataState);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.amAppapiMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiMode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiMode.null");
        }
    }

    private void updateStateAppapiParamMode(Integer appapiParamId, Integer dataState, Integer dataCstate, Integer oldDataState) throws ApiException {
        if (null == appapiParamId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiParamId", appapiParamId);
        map.put("dataState", dataState);
        if (null != dataCstate) {
            map.put("dataCstate", dataCstate);
        }
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amAppapiParamMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiParamMode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiParamMode.null");
        }
    }

    private void updateStateAppapiParamModeByUnique(String appapiCode, String appapiVersion, String paramName, String paramDire, Integer dataState, Integer dataCstate, Integer oldDataState) throws ApiException {
        if (null == appapiCode || null == appapiVersion || null == paramName || null == paramDire) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiCode", appapiCode);
        map.put("appapiVersion", appapiVersion);
        map.put("paramName", paramName);
        map.put("paramDire", paramDire);
        map.put("dataState", dataState);
        if (null != dataCstate) {
            map.put("dataCstate", dataCstate);
        }
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amAppapiParamMapper.updateStateByUniqueKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiParamMode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiParamMode.null");
        }
    }

    private void updateStateAppapiRouterMode(Integer appapiRouterId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == appapiRouterId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiRouterId", appapiRouterId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amAppapiRouterMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiRouterMode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiRouterMode.null");
        }
    }

    private void updateStateAppapiErrorMode(Integer errorId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == errorId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorId", errorId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amAppapiErrorMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiErrorMode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiErrorMode.null");
        }
    }

    private List<AmAppapiRouter> queryRouter(Map<String, Object> parammap) {
        try {
            return this.amAppapiRouterMapper.queryApprouter(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.queryRouter", (Throwable)e);
            return null;
        }
    }

    private List<AmAppapi> queryApi(Map<String, Object> parammap) {
        try {
            return this.amAppapiMapper.queryAppapi(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.queryApi", (Throwable)e);
            return null;
        }
    }

    private ApiRouterProperty makeApiRouter(AmAppapiRouter amAppapiRouter) {
        if (null == amAppapiRouter) {
            return null;
        }
        ApiRouterProperty apiRouterProperty = new ApiRouterProperty();
        try {
            BeanUtils.copyAllPropertys((Object)apiRouterProperty, (Object)amAppapiRouter);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.makeApiRouter", (Throwable)e);
        }
        return apiRouterProperty;
    }

    private ApiProperty makeApi(AmAppapi amAppapi) {
        if (null == amAppapi) {
            return null;
        }
        ApiProperty api = new ApiProperty();
        try {
            BeanUtils.copyAllPropertys((Object)api, (Object)amAppapi);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.makeApi", (Throwable)e);
        }
        return api;
    }

    private ApiError makeApiError(AmAppapiError amAppapiError) {
        if (null == amAppapiError) {
            return null;
        }
        ApiError apiError = new ApiError();
        try {
            BeanUtils.copyAllPropertys((Object)apiError, (Object)amAppapiError);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.makeApi", (Throwable)e);
        }
        return apiError;
    }

    private Map<String, List<ApiParam>> getParamMap() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        parammap.put("paramDire", 0);
        parammap.put("order", true);
        List<AmAppapiParam> paramList = this.queryParam(parammap);
        if (CollectionUtils.isEmpty(paramList)) {
            return null;
        }
        Map<String, List<Dataparam>> paramMap = this.dataparamService.queryDataparamToMap();
        String key = null;
        HashMap<String, List<ApiParam>> map = new HashMap<String, List<ApiParam>>();
        for (AmAppapiParam amAppapiParam : paramList) {
            key = "1.0".equals(amAppapiParam.getAppapiVersion()) ? amAppapiParam.getAppapiCode() + "-" + amAppapiParam.getAppapiVersion() : amAppapiParam.getAppapiCode();
            MapUtil.put(map, (Object)key, (Object)this.makeApiParam(amAppapiParam, paramMap));
        }
        return map;
    }

    private List<AmAppapiParam> queryParam(Map<String, Object> parammap) {
        try {
            return this.amAppapiParamMapper.queryAppparam(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.queryParam", (Throwable)e);
            return null;
        }
    }

    private ApiParam makeApiParam(AmAppapiParam amAppapiParam, Map<String, List<Dataparam>> dataparamMap) {
        if (null == amAppapiParam) {
            return null;
        }
        ApiParam apiParam = new ApiParam();
        try {
            BeanUtils.copyAllPropertys((Object)apiParam, (Object)amAppapiParam);
            if (AppManageConstants.API_PARAM_TYPE_DATA.equals(apiParam.getParamPtype()) && null != dataparamMap) {
                apiParam.setDataparamList(dataparamMap.get(apiParam.getParamClassname()));
            } else if (StringUtils.isNotBlank((String)apiParam.getParamListtype()) && null != dataparamMap && apiParam.getParamListtype().indexOf("java.lang.") != 0) {
                apiParam.setDataparamList(dataparamMap.get(apiParam.getParamListtype()));
            }
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.makeApiParam", (Throwable)e);
        }
        return apiParam;
    }

    private List<AmAppapi> queryApipage(Map<String, Object> parammap) {
        try {
            return this.amAppapiMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.queryApipage", (Throwable)e);
            return null;
        }
    }

    private List<AmAppapi> queryApipageFuzzy(Map<String, Object> parammap) {
        try {
            return this.amAppapiMapper.queryFuzzy(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.queryApipageFuzzy", (Throwable)e);
            return null;
        }
    }

    private int countApi(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amAppapiMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.countApi", (Throwable)e);
        }
        return i;
    }

    private int countApiFuzzy(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amAppapiMapper.countFuzzy(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.countApi", (Throwable)e);
        }
        return i;
    }

    private List<AmAppapiParam> queryParamPage(Map<String, Object> parammap) {
        try {
            return this.amAppapiParamMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.queryParamPage", (Throwable)e);
            return null;
        }
    }

    private int countParam(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amAppapiParamMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.countParam", (Throwable)e);
        }
        return i;
    }

    private List<AmAppapiRouter> queryRouterPage(Map<String, Object> parammap) {
        try {
            return this.amAppapiRouterMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.queryRouterPage", (Throwable)e);
            return null;
        }
    }

    private int countRouter(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amAppapiRouterMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.countRouter", (Throwable)e);
        }
        return i;
    }

    private List<AmAppapiParam> queryAppapiListModel(Map<String, Object> parammap) {
        try {
            return this.amAppapiParamMapper.queryAppapiList(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.queryParamPage", (Throwable)e);
            return null;
        }
    }

    private List<AmAppapiParam> queryParamList(Map<String, Object> parammap) {
        try {
            return this.amAppapiParamMapper.queryParamList(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.queryParamList", (Throwable)e);
            return null;
        }
    }

    @Override
    public void saveAppapi(AmAppapi amAppapi) throws ApiException {
        String msg = this.check(amAppapi);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.saveAppapi.null", msg);
        }
        this.setDefault(amAppapi);
        this.saveApiMode(amAppapi);
        this.refreshApiCache(amAppapi, false);
    }

    @Override
    public void saveAppapiParam(AmAppapiParam amAppapiParam) throws ApiException {
        String msg = this.check(amAppapiParam);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.saveAppapiParam.null", msg);
        }
        this.setDefault(amAppapiParam);
        this.saveApiParamMode(amAppapiParam);
        this.refreshParamCache(amAppapiParam, amAppapiParam.getDataState());
    }

    @Override
    public void saveAppapiRouter(AmAppapiRouter amAppapiRouter) throws ApiException {
        String msg = this.check(amAppapiRouter);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.saveAppapiRouter.null", msg);
        }
        this.setDefault(amAppapiRouter);
        this.saveApiRouterMode(amAppapiRouter);
        this.refreshRouterCache(amAppapiRouter, false);
    }

    @Override
    public void saveAppapiError(AmAppapiError amAppapiError) throws ApiException {
        String msg = this.check(amAppapiError);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.saveAppapiError.null", msg);
        }
        this.setDefault(amAppapiError);
        this.saveApiErrorMode(amAppapiError);
    }

    @Override
    public void queryApiLoadCache() {
        this.info("am.ESB.APPMANAGE.AppapiServiceImpl.queryApiLoadCache", "=======api\u8c03\u5ea6start=======");
        this.queryApiCache();
        this.queryApiRouterCache();
        this.queryApiErrorCache();
        this.info("am.ESB.APPMANAGE.AppapiServiceImpl.queryApiLoadCache", "=======api\u8c03\u5ea6end=======");
    }

    @Override
    public void queryApiCache() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataStates", ApiState.getAllStateCode());
        List<AmAppapi> list = this.queryApi(parammap);
        if (CollectionUtils.isEmpty(list)) {
            DisUtil.delVer((String)"EcoreAppapi-pro");
            return;
        }
        Map<String, List<ApiParam>> paramMap = this.getParamMap();
        HashMap<String, ApiProperty> apiPropMap = new HashMap<String, ApiProperty>();
        for (AmAppapi amAppapi : list) {
            this.convert2ApiProperty(amAppapi, apiPropMap, paramMap);
        }
        DisUtil.setVer((String)"EcoreAppapi-pro", (String)JsonUtil.buildNormalBinder().toJson(apiPropMap));
    }

    @Override
    public void queryApiRouterCache() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("dataState", 1);
        List<AmAppapiRouter> routerList = this.queryRouter(param);
        if (CollectionUtils.isNotEmpty(routerList)) {
            HashMap<String, ApiRouterProperty> routeMap = new HashMap<String, ApiRouterProperty>();
            for (AmAppapiRouter router : routerList) {
                this.convert2RouterProperty(router, routeMap);
            }
            DisUtil.setVer((String)"EcoreAppapiRouter-pro", (String)JsonUtil.buildNormalBinder().toJson(routeMap));
        }
    }

    private void refreshParamCache(AmAppapiParam amAppapiParam, Integer dataState) {
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(DisUtil.get((String)"EcoreAppapi-pro"), String.class, ApiProperty.class);
        if (map == null) {
            return;
        }
        String key = amAppapiParam.getAppapiCode() + "-" + "1.0";
        ApiProperty apiProperty = (ApiProperty)map.get(key);
        if (apiProperty == null) {
            return;
        }
        if (dataState == 1) {
            Map<String, List<Dataparam>> dataparamMap = this.dataparamService.queryDataparamToMap();
            this.saveParamCache(amAppapiParam, dataparamMap, apiProperty);
        } else {
            this.deleteParamCache(amAppapiParam, apiProperty);
        }
        DisUtil.setVer((String)"EcoreAppapi-pro", (String)JsonUtil.buildNormalBinder().toJson((Object)map));
    }

    private void saveParamCache(AmAppapiParam amAppapiParam, Map<String, List<Dataparam>> dataparamMap, ApiProperty apiProperty) {
        if (apiProperty == null) {
            return;
        }
        List<ApiParam> list = null;
        if ("1.0".equals(amAppapiParam.getAppapiVersion())) {
            list = apiProperty.getApiParamList();
            if (list == null) {
                list = new ArrayList();
                apiProperty.setApiParamList(list);
            }
        } else {
            if (MapUtil.isEmpty((Map)apiProperty.getOtherApiParamMap())) {
                apiProperty.setOtherApiParamMap(new HashMap());
            }
            if ((list = (List)apiProperty.getOtherApiParamMap().get(amAppapiParam.getAppapiVersion())) == null) {
                list = new ArrayList();
                apiProperty.getOtherApiParamMap().put(amAppapiParam.getAppapiVersion(), list);
            }
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!((ApiParam)list.get(i)).getAppapiParamId().equals(amAppapiParam.getAppapiParamId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, this.makeApiParam(amAppapiParam, dataparamMap));
        } else {
            list.add(this.makeApiParam(amAppapiParam, dataparamMap));
        }
    }

    private void deleteParamCache(AmAppapiParam amAppapiParam, ApiProperty apiProperty) {
        if (apiProperty == null) {
            return;
        }
        ArrayList list = null;
        if ("1.0".equals(amAppapiParam.getAppapiVersion())) {
            list = apiProperty.getApiParamList();
        } else {
            if (MapUtil.isEmpty((Map)apiProperty.getOtherApiParamMap())) {
                apiProperty.setOtherApiParamMap(new HashMap());
            }
            if ((list = (List)apiProperty.getOtherApiParamMap().get(amAppapiParam.getAppapiVersion())) == null) {
                list = new ArrayList();
                apiProperty.getOtherApiParamMap().put(amAppapiParam.getAppapiVersion(), list);
            }
        }
        if (list == null) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!((ApiParam)list.get(i)).getAppapiParamId().equals(amAppapiParam.getAppapiParamId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private void refreshRouterCache(AmAppapiRouter amAppapiRouter, boolean delete) {
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(DisUtil.get((String)"EcoreAppapiRouter-pro"), String.class, ApiRouterProperty.class);
        if (map == null) {
            return;
        }
        if (delete) {
            this.deleteRouterCache(amAppapiRouter, map);
        } else {
            this.convert2RouterProperty(amAppapiRouter, map);
        }
        DisUtil.setVer((String)"EcoreAppapiRouter-pro", (String)JsonUtil.buildNormalBinder().toJson((Object)map));
    }

    private void convert2RouterProperty(AmAppapiRouter router, Map<String, ApiRouterProperty> appapiMap) {
        String key = TokenUtil.genToken((Object[])new Object[]{router.getAppapiCode(), router.getAppapiVersion(), router.getRouterDire()});
        appapiMap.put(key, this.makeApiRouter(router));
    }

    private void convert2ApiProperty(AmAppapi api, Map<String, ApiProperty> appapiMap, Map<String, List<ApiParam>> paramMap) {
        String key = api.getAppapiCode() + "-" + api.getAppapiVersion();
        ApiProperty apiProperty = this.makeApi(api);
        if (null != paramMap && !paramMap.isEmpty()) {
            apiProperty.setApiParamList(paramMap.get(key));
            List<ApiParam> otherApiParamList = paramMap.get(api.getAppapiCode());
            if (ListUtil.isNotEmpty(otherApiParamList)) {
                HashMap otherApiParamMap = new HashMap();
                for (ApiParam apiParam : otherApiParamList) {
                    MapUtil.put(otherApiParamMap, (Object)apiParam.getAppapiVersion(), (Object)apiParam);
                }
                apiProperty.setOtherApiParamMap(otherApiParamMap);
            }
        }
        appapiMap.put(key, apiProperty);
    }

    private void deleteApiCache(AmAppapi router, Map<String, ApiProperty> appapiMap) {
        if (router == null || appapiMap == null) {
            return;
        }
        appapiMap.remove(TokenUtil.genToken((Object[])new Object[]{router.getAppapiCode(), router.getAppapiVersion()}));
    }

    private void deleteRouterCache(AmAppapiRouter router, Map<String, ApiRouterProperty> appapiMap) {
        if (router == null || appapiMap == null) {
            return;
        }
        appapiMap.remove(TokenUtil.genToken((Object[])new Object[]{router.getAppapiCode(), router.getAppapiVersion(), router.getRouterDire()}));
    }

    private void refreshApiCache(AmAppapi amAppapi, boolean delete) {
        HashMap<String, ApiProperty> map = (HashMap<String, ApiProperty>)JsonUtil.buildNormalBinder().getJsonToMap(DisUtil.get((String)"EcoreAppapi-pro"), String.class, ApiProperty.class);
        if (map == null) {
            map = new HashMap<String, ApiProperty>();
        }
        if (delete) {
            this.deleteApiCache(amAppapi, map);
        } else {
            this.convert2ApiProperty(amAppapi, map, this.getParamMap());
        }
        DisUtil.setVer((String)"EcoreAppapi-pro", (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    @Override
    public QueryResult<AmAppapi> queryAppapiPage(Map<String, Object> map) {
        List<AmAppapi> amAppapiList = this.queryApipage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countApi(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amAppapiList);
        return queryResult;
    }

    @Override
    public QueryResult<AmAppapi> queryAppapiPageFuzzy(Map<String, Object> map) {
        List<AmAppapi> amAppapiList = this.queryApipageFuzzy(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countApiFuzzy(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amAppapiList);
        return queryResult;
    }

    @Override
    public QueryResult<AmAppapiParam> queryAppapiParamPage(Map<String, Object> map) {
        List<AmAppapiParam> amAppapiParamList = this.queryParamPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countParam(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amAppapiParamList);
        return queryResult;
    }

    @Override
    public List<AmAppapiParamReDomain> queryAppapiParamList(Map<String, Object> map) {
        List<AmAppapiParam> amAppapiParamList = this.queryParamList(map);
        return this.makeReApiDomain(amAppapiParamList);
    }

    @Override
    public List<AmAppapiParam> queryAppapiList(Map<String, Object> map) {
        List<AmAppapi> amAppapiList = this.queryApipage(map);
        ArrayList<AmAppapiParam> apilist = new ArrayList<AmAppapiParam>();
        if (CollectionUtils.isNotEmpty(amAppapiList)) {
            for (AmAppapi amAppapi : amAppapiList) {
                String appapiCode = amAppapi.getAppapiCode();
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("appapiCode", appapiCode);
                List<AmAppapiParam> amAppapiParamList = this.queryAppapiListModel(paramMap);
                if (!CollectionUtils.isNotEmpty(amAppapiParamList)) continue;
                for (AmAppapiParam amAppapiParam : amAppapiParamList) {
                    apilist.add(amAppapiParam);
                }
            }
        }
        return apilist;
    }

    @Override
    public QueryResult<AmAppapiRouter> queryAppapiRouterPage(Map<String, Object> map) {
        List<AmAppapiRouter> amAppapiRouterList = this.queryRouterPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRouter(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amAppapiRouterList);
        return queryResult;
    }

    @Override
    public void updateAppapiState(Integer appapiId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAppapiMode(appapiId, dataState, oldDataState);
        this.refreshApiCache(this.getAppapi(appapiId), false);
    }

    @Override
    public void updateAppapiStateByCodeVersion(String appapiCode, String appapiVersion, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAppapiModeByCodeVersion(appapiCode, appapiVersion, dataState, oldDataState);
        this.refreshApiCache(this.getApiByCodeVersion(appapiCode, appapiVersion), false);
    }

    @Override
    public void updateAppapiBatchState(String appapiIdStrs, Integer dataState, Integer oldDataState) throws ApiException {
        String[] appapiIdArr = appapiIdStrs.split("\\|");
        for (int i = 0; i < appapiIdArr.length; ++i) {
            String appapiIdStr = appapiIdArr[i];
            if (null == appapiIdStr || "".equals(appapiIdStr)) continue;
            Integer appapiId = Integer.valueOf(appapiIdStr);
            this.updateStateAppapiMode(appapiId, dataState, oldDataState);
            this.refreshApiCache(this.getAppapi(appapiId), false);
        }
    }

    @Override
    public void updateAppapiCheck(Integer appapiId, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        this.updateAppapiCheckMode(appapiId, dataState, oldDataState, memo);
        this.refreshApiCache(this.getAppapi(appapiId), false);
    }

    @Override
    public void updateAppapiBatchCheck(String appapiIdStrs, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        String[] appapiIdArr = appapiIdStrs.split("\\|");
        for (int i = 0; i < appapiIdArr.length; ++i) {
            String appapiIdStr = appapiIdArr[i];
            if (null == appapiIdStr || "".equals(appapiIdStr)) continue;
            Integer appapiId = Integer.valueOf(appapiIdStr);
            this.updateAppapiCheckMode(appapiId, dataState, oldDataState, memo);
            this.refreshApiCache(this.getAppapi(appapiId), false);
        }
    }

    @Override
    public void updateAppapiParamState(Integer appapiParamId, Integer dataState, Integer dataCstate, Integer oldDataState) throws ApiException {
        this.updateStateAppapiParamMode(appapiParamId, dataState, dataCstate, oldDataState);
        this.refreshParamCache(this.getAppapiParam(appapiParamId), dataState);
    }

    @Override
    public void updateAppapiParamStateByUnique(String appapiCode, String appapiVersion, String paramName, String paramDire, Integer dataState, Integer dataCstate, Integer oldDataState) throws ApiException {
        this.updateStateAppapiParamModeByUnique(appapiCode, appapiVersion, paramName, paramDire, dataState, dataCstate, oldDataState);
        this.refreshParamCache(this.getAppapiByUniqueKey(appapiCode, appapiVersion, paramName, paramDire), dataState);
    }

    @Override
    public void updateAppapiParamStateBatch(String appapiCode, String appapiVersion, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == appapiCode || null == dataState) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiParamStateBatch.null", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiCode", appapiCode);
        map.put("appapiVersion", appapiVersion);
        List<AmAppapiParam> amAppapiParamList = this.queryParamPage(map);
        if (CollectionUtils.isNotEmpty(amAppapiParamList)) {
            for (AmAppapiParam amAppapiParam : amAppapiParamList) {
                Integer appapiParamId = amAppapiParam.getAppapiParamId();
                this.updateStateAppapiParamMode(appapiParamId, dataState, dataState, oldDataState);
                this.refreshParamCache(this.getAppapiParam(appapiParamId), dataState);
            }
        }
    }

    @Override
    public void updateAppapiRouterState(Integer appapiRouterId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAppapiRouterMode(appapiRouterId, dataState, oldDataState);
        this.refreshRouterCache(this.getAppapiRouter(appapiRouterId), false);
    }

    @Override
    public void updateAppapiErrorState(Integer errorId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAppapiErrorMode(errorId, dataState, oldDataState);
        this.refreshApiErrorCache(this.getAppapiError(errorId), dataState);
    }

    @Override
    public AmAppapi getApiForSafety(Integer appapiId) {
        return this.getApiByPrimaryKey(appapiId);
    }

    private AmAppapi getApiByPrimaryKey(Integer appapiId) {
        try {
            return this.amAppapiMapper.selectByPrimaryKey(appapiId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.selectByPrimaryKey", (Throwable)e);
            return null;
        }
    }

    private AmAppapi getApiByCodeVersion(String appapiCode, String appapiVersion) {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("appapiCode", appapiCode);
            parameters.put("appapiVersion", appapiVersion);
            return this.amAppapiMapper.selectByCodeVersion(parameters);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.selectByPrimaryKey", (Throwable)e);
            return null;
        }
    }

    private List<AmAppapiError> queryApierrorPage(Map<String, Object> parammap) {
        try {
            return this.amAppapiErrorMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.queryApierror", (Throwable)e);
            return null;
        }
    }

    private int countApiError(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amAppapiErrorMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.countApiError", (Throwable)e);
        }
        return i;
    }

    @Override
    public QueryResult<AmAppapiError> queryAppapiErrorPage(Map<String, Object> map) {
        List<AmAppapiError> amAppapiErrorList = this.queryApierrorPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countApiError(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amAppapiErrorList);
        return queryResult;
    }

    @Override
    public void updateAppapi(AmAppapiDomain amAppapiDomain) throws ApiException {
        String msg = this.checkDomain(amAppapiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapi.null", msg);
        }
        AmAppapi amAppapi = this.getAppapi(amAppapiDomain.getAppapiId());
        if (amAppapi == null) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapi.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        msg = this.check(amAppapi = this.makeModel(amAppapi, amAppapiDomain));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapi.null", msg);
        }
        this.setUpDefault(amAppapi);
        this.updateAppapiModel(amAppapi);
        this.refreshApiCache(amAppapi, false);
    }

    private void updateAppapiModel(AmAppapi amAppapi) throws ApiException {
        if (null == amAppapi) {
            return;
        }
        try {
            this.amAppapiMapper.updateByPrimaryKey(amAppapi);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiModel.ex");
        }
    }

    private void updateAppapiModelByUnique(AmAppapi amAppapi) throws ApiException {
        if (null == amAppapi) {
            return;
        }
        try {
            this.amAppapiMapper.updateByUniqueKey(amAppapi);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiModel.ex");
        }
    }

    @Override
    public void updateAppapiParam(AmAppapiParamDomain amAppapiParamDomain) throws ApiException {
        AmAppapiParam amAppapiParam = this.getAppapiParam(amAppapiParamDomain.getAppapiParamId());
        if (amAppapiParam == null) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiParam.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(amAppapiParam = this.makeModel(amAppapiParam, amAppapiParamDomain));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiParam.null", msg);
        }
        this.setUpDefault(amAppapiParam);
        this.updateAppapiParamModel(amAppapiParam);
        this.refreshParamCache(amAppapiParam, amAppapiParam.getDataState());
    }

    private void updateAppapiParamModel(AmAppapiParam amAppapiParam) throws ApiException {
        if (null == amAppapiParam) {
            return;
        }
        try {
            this.amAppapiParamMapper.updateByPrimaryKey(amAppapiParam);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiParamModel.ex");
        }
    }

    private void updateAppapiParamModelByUnique(AmAppapiParam amAppapiParam) throws ApiException {
        if (null == amAppapiParam) {
            return;
        }
        try {
            this.amAppapiParamMapper.updateByUniqueKey(amAppapiParam);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiParamModel.ex");
        }
    }

    @Override
    public void updateAppapiRouter(AmAppapiRouterDomain amAppapiRouterDomain) throws ApiException {
        AmAppapiRouter amAppapiRouter = this.getAppapiRouter(amAppapiRouterDomain.getAppapiRouterId());
        if (amAppapiRouter == null) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiRouter.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(amAppapiRouter = this.makeModel(amAppapiRouter, amAppapiRouterDomain));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiRouter.null", msg);
        }
        this.setUpDefault(amAppapiRouter);
        this.updateAppapiRouterModel(amAppapiRouter);
        this.refreshRouterCache(amAppapiRouter, false);
    }

    private void updateAppapiRouterModel(AmAppapiRouter amAppapiRouter) throws ApiException {
        if (null == amAppapiRouter) {
            return;
        }
        try {
            this.amAppapiRouterMapper.updateByPrimaryKey(amAppapiRouter);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiRouterModel.ex");
        }
    }

    @Override
    public void updateAppapiError(AmAppapiErrorDomain amAppapiErrorDomain) throws ApiException {
        AmAppapiError amAppapiError = this.getAppapiError(amAppapiErrorDomain.getErrorId());
        if (amAppapiError == null) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiError.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(amAppapiError = this.makeModel(amAppapiError, amAppapiErrorDomain));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiError.null", msg);
        }
        this.setUpDefault(amAppapiError);
        this.updateAppapiErrorModel(amAppapiError);
    }

    private void updateAppapiErrorModel(AmAppapiError amAppapiError) throws ApiException {
        if (null == amAppapiError) {
            return;
        }
        try {
            this.amAppapiErrorMapper.updateByPrimaryKey(amAppapiError);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiErrorModel.ex");
        }
    }

    private void deleteAppapiModel(Integer appapiId) throws ApiException {
        int i = 0;
        try {
            i = this.amAppapiMapper.deleteByPrimaryKey(appapiId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiModel.ex");
        }
        if (i < 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiModel.null");
        }
    }

    private void deleteAppapiRouterByApiCodeModel(String appapiCode, String appapiVersion) throws ApiException {
        int i = 0;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("appapiCode", appapiCode);
        try {
            i = this.amAppapiRouterMapper.deleteByApiCode(parameters);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiRouterByApiCodeModel.ex");
        }
        if (i < 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiRouterByApiCodeModel.null");
        }
    }

    private void deleteAppapiParamByApiCodeModel(String appapiCode, String appapiVersion) throws ApiException {
        int i = 0;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("appapiCode", appapiCode);
        try {
            i = this.amAppapiParamMapper.deleteByApiCode(parameters);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiParamByApiCodeModel.ex");
        }
        if (i < 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiParamByApiCodeModel.null");
        }
    }

    private void deleteAppapiErrorByApiCodeModel(String appapiCode, String appapiVersion) throws ApiException {
        int i = 0;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("appapiCode", appapiCode);
        try {
            i = this.amAppapiErrorMapper.deleteByApiCode(parameters);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiErrorByApiCodeModel.ex");
        }
        if (i < 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiErrorByApiCodeModel.null");
        }
    }

    @Override
    public void deleteAppapi(Integer appapiId) throws ApiException {
        AmAppapi amAppapi = this.getApiByPrimaryKey(appapiId);
        if (null == amAppapi) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapi.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        String appapiCode = amAppapi.getAppapiCode();
        String appapiVersion = amAppapi.getAppapiVersion();
        this.deleteAppapiModel(appapiId);
        this.deleteAppapiErrorByApiCodeModel(appapiCode, appapiVersion);
        this.deleteAppapiParamByApiCodeModel(appapiCode, appapiVersion);
        this.deleteAppapiRouterByApiCodeModel(appapiCode, appapiVersion);
        this.refreshApiCache(amAppapi, true);
    }

    private void deleteAppapiParamModel(Integer appapiParamId) throws ApiException {
        int i = 0;
        try {
            i = this.amAppapiParamMapper.deleteByPrimaryKey(appapiParamId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiParamModel.ex");
        }
        if (i < 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiParamModel.null");
        }
    }

    @Override
    public void deleteAppapiParam(Integer appapiParamId) throws ApiException {
        AmAppapiParam param = this.getAppapiByPrimaryKey(appapiParamId);
        if (param == null) {
            return;
        }
        this.deleteAppapiParamModel(appapiParamId);
        this.refreshParamCache(param, 0);
    }

    private void deleteAppapiRouterModel(Integer appapiRouterId) throws ApiException {
        int i = 0;
        try {
            i = this.amAppapiRouterMapper.deleteByPrimaryKey(appapiRouterId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiRouterModel.ex");
        }
        if (i < 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiRouterModel.null");
        }
    }

    @Override
    public void deleteAppapiRouter(Integer appapiRouterId) throws ApiException {
        AmAppapiRouter router = this.getAppapiRouterByPrimaryKey(appapiRouterId);
        if (router == null) {
            return;
        }
        this.deleteAppapiRouterModel(appapiRouterId);
        this.refreshRouterCache(router, true);
    }

    private void deleteAppapiErrorModel(Integer errorId) throws ApiException {
        int i = 0;
        try {
            i = this.amAppapiErrorMapper.deleteByPrimaryKey(errorId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiErrorModel.ex");
        }
        if (i < 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiErrorModel.null");
        }
    }

    @Override
    public void deleteAppapiError(Integer errorId) throws ApiException {
        this.deleteAppapiErrorModel(errorId);
    }

    @Override
    public AmAppapi getAppapi(Integer appapiId) throws ApiException {
        return this.getApiByPrimaryKey(appapiId);
    }

    @Override
    public AmAppapiReDomain getAppapiAll(Integer appapiId) throws ApiException {
        AmAppapi amAppapi = this.getApiByPrimaryKey(appapiId);
        AmAppapiReDomain amAppapiReDomain = this.makeReDomain(amAppapi);
        if (null == amAppapiReDomain) {
            return null;
        }
        this.makeAppapiReDomain(amAppapi.getAppapiCode(), amAppapi.getAppapiVersion(), amAppapiReDomain);
        return amAppapiReDomain;
    }

    @Override
    public AmAppapiReDomain getAppapiAllByCode(String appapiCode, String appapiVersion) throws ApiException {
        AmAppapiReDomain amAppapiReDomain = new AmAppapiReDomain();
        this.makeAppapiReDomain(appapiCode, appapiVersion, amAppapiReDomain);
        return amAppapiReDomain;
    }

    private void makeAppapiReDomain(String appapiCode, String appapiVersion, AmAppapiReDomain amAppapiReDomain) {
        if (null == amAppapiReDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiCode", appapiCode);
        map.put("appapiVersion", appapiVersion);
        amAppapiReDomain.setErrorList(this.makeReErrorDomain(this.queryApierrorPage(map)));
        amAppapiReDomain.setParamList(this.makeReApiDomain(this.queryParamPage(map)));
        map.remove("appapiVersion");
        amAppapiReDomain.setRouterList(this.makeReRouterDomain(this.queryRouterPage(map)));
    }

    private List<AmAppapiErrorReDomain> makeReErrorDomain(List<AmAppapiError> list) {
        if (null == list || list.isEmpty()) {
            return null;
        }
        ArrayList<AmAppapiErrorReDomain> reList = new ArrayList<AmAppapiErrorReDomain>();
        AmAppapiErrorReDomain amAppapiErrorReDomain = null;
        for (AmAppapiError amAppapiError : list) {
            amAppapiErrorReDomain = new AmAppapiErrorReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)amAppapiErrorReDomain, (Object)amAppapiError);
                reList.add(amAppapiErrorReDomain);
            }
            catch (Exception e) {
                this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.makeReDomain", (Throwable)e);
            }
        }
        return reList;
    }

    private List<AmAppapiRouterReDomain> makeReRouterDomain(List<AmAppapiRouter> list) {
        if (null == list || list.isEmpty()) {
            return null;
        }
        ArrayList<AmAppapiRouterReDomain> reList = new ArrayList<AmAppapiRouterReDomain>();
        AmAppapiRouterReDomain amAppapiRouterReDomain = null;
        for (AmAppapiRouter amAppapiRouter : list) {
            amAppapiRouterReDomain = new AmAppapiRouterReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)amAppapiRouterReDomain, (Object)amAppapiRouter);
                reList.add(amAppapiRouterReDomain);
            }
            catch (Exception e) {
                this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.makeReDomain", (Throwable)e);
            }
        }
        return reList;
    }

    private List<AmAppapiParamReDomain> makeReApiDomain(List<AmAppapiParam> list) {
        if (null == list || list.isEmpty()) {
            return null;
        }
        ArrayList<AmAppapiParamReDomain> reList = new ArrayList<AmAppapiParamReDomain>();
        AmAppapiParamReDomain amAppapiParamReDomain = null;
        for (AmAppapiParam amAppapiParam : list) {
            amAppapiParamReDomain = new AmAppapiParamReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)amAppapiParamReDomain, (Object)amAppapiParam);
                this.makeParamData(amAppapiParamReDomain);
                reList.add(amAppapiParamReDomain);
            }
            catch (Exception e) {
                this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.makeReDomain", (Throwable)e);
            }
        }
        return reList;
    }

    private void makeParamData(AmAppapiParamReDomain amAppapiParamReDomain) {
        if (null == amAppapiParamReDomain) {
            return;
        }
        if (1 != amAppapiParamReDomain.getParamPtype()) {
            return;
        }
        String dataparamCode = "List".equals(amAppapiParamReDomain.getParamType()) ? amAppapiParamReDomain.getParamListtype() : ("Map".equals(amAppapiParamReDomain.getParamType()) ? amAppapiParamReDomain.getParamListtype() : amAppapiParamReDomain.getParamClassname());
        List<AmDataparamListReDomain> dataparamList = this.dataparamService.queryDataparamListByCode(dataparamCode, amAppapiParamReDomain.getTenantCode());
        if ("SupQueryResult".equals(amAppapiParamReDomain.getParamType())) {
            List<AmDataparamListReDomain> dataparamsupList = this.dataparamService.queryDataparamListByCode(amAppapiParamReDomain.getParamListtype(), amAppapiParamReDomain.getTenantCode());
            for (AmDataparamListReDomain amDataparamListReDomain : dataparamList) {
                if (!"List".equals(amDataparamListReDomain.getParamType())) continue;
                amDataparamListReDomain.setDataparamList(dataparamsupList);
            }
        }
        amAppapiParamReDomain.setDataparamList(dataparamList);
    }

    private AmAppapiReDomain makeReDomain(AmAppapi amAppapi) {
        if (null == amAppapi) {
            return null;
        }
        AmAppapiReDomain amAppapiReDomain = new AmAppapiReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)amAppapiReDomain, (Object)amAppapi);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.makeReDomain", (Throwable)e);
        }
        return amAppapiReDomain;
    }

    private AmAppapiParam getAppapiByPrimaryKey(Integer appapiParamId) {
        try {
            return this.amAppapiParamMapper.selectByPrimaryKey(appapiParamId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.getAppapiByPrimaryKey", (Throwable)e);
            return null;
        }
    }

    private AmAppapiParam getAppapiByUniqueKey(String appapiCode, String appapiVersion, String paramName, String paramDire) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("appapiCode", appapiCode);
            map.put("appapiVersion", appapiVersion);
            map.put("paramName", paramName);
            map.put("paramDire", paramDire);
            return this.amAppapiParamMapper.selectByUniqueKey(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.getAppapiByPrimaryKey", (Throwable)e);
            return null;
        }
    }

    @Override
    public AmAppapiParam getAppapiParam(Integer appapiParamId) throws ApiException {
        return this.getAppapiByPrimaryKey(appapiParamId);
    }

    private AmAppapiRouter getAppapiRouterByPrimaryKey(Integer appapiRouterId) {
        try {
            return this.amAppapiRouterMapper.selectByPrimaryKey(appapiRouterId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.getAppapiRouterByPrimaryKey", (Throwable)e);
            return null;
        }
    }

    @Override
    public AmAppapiRouter getAppapiRouter(Integer appapiRouterId) throws ApiException {
        return this.getAppapiRouterByPrimaryKey(appapiRouterId);
    }

    private AmAppapiError getAppapiErrorByPrimaryKey(Integer errorId) {
        try {
            return this.amAppapiErrorMapper.selectByPrimaryKey(errorId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppapiServiceImpl.getAppapiErrorByPrimaryKey", (Throwable)e);
            return null;
        }
    }

    @Override
    public AmAppapiError getAppapiError(Integer errorId) throws ApiException {
        return this.getAppapiErrorByPrimaryKey(errorId);
    }

    private void setUpDefault(AmAppapi amAppapi) {
        if (null == amAppapi) {
            return;
        }
        amAppapi.setGmtModified(this.getSysDate());
    }

    private AmAppapi makeModel(AmAppapi amAppapi, AmAppapiDomain amAppapiDomain) {
        if (amAppapiDomain == null) {
            return null;
        }
        if (amAppapi == null) {
            amAppapi = new AmAppapi();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amAppapi, (Object)amAppapiDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amAppapi;
    }

    private void setUpDefault(AmAppapiParam amAppapiParam) {
        if (null == amAppapiParam) {
            return;
        }
        amAppapiParam.setGmtModified(this.getSysDate());
    }

    private AmAppapiParam makeModel(AmAppapiParam amAppapiParam, AmAppapiParamDomain amAppapiParamDomain) {
        if (amAppapiParamDomain == null) {
            return null;
        }
        if (amAppapiParam == null) {
            amAppapiParam = new AmAppapiParam();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amAppapiParam, (Object)amAppapiParamDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amAppapiParam;
    }

    private void setUpDefault(AmAppapiRouter amAppapiRouter) {
        if (null == amAppapiRouter) {
            return;
        }
        amAppapiRouter.setGmtModified(this.getSysDate());
    }

    private AmAppapiRouter makeModel(AmAppapiRouter amAppapiRouter, AmAppapiRouterDomain amAppapiRouterDomain) {
        if (amAppapiRouterDomain == null) {
            return null;
        }
        if (amAppapiRouter == null) {
            amAppapiRouter = new AmAppapiRouter();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amAppapiRouter, (Object)amAppapiRouterDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amAppapiRouter;
    }

    private void setUpDefault(AmAppapiError amAppapiError) {
        if (null == amAppapiError) {
            return;
        }
        amAppapiError.setGmtModified(this.getSysDate());
    }

    private AmAppapiError makeModel(AmAppapiError amAppapiError, AmAppapiErrorDomain amAppapiErrorDomain) {
        if (amAppapiErrorDomain == null) {
            return null;
        }
        if (amAppapiError == null) {
            amAppapiError = new AmAppapiError();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amAppapiError, (Object)amAppapiErrorDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amAppapiError;
    }

    @Override
    public void saveAppapiAll(List<AmAppapi> amAppapiList, List<AmAppapiParam> amAppapiParamList, List<AmAppapiRouter> amAppapiRouterList, List<AmAppapiError> amAppapiErrorList) throws ApiException {
        if (amAppapiList != null && !amAppapiList.isEmpty()) {
            for (AmAppapi amAppapi : amAppapiList) {
                if (this.getAmAppapi(amAppapi.getAppapiCode(), amAppapi.getAppapiVersion()) != null) continue;
                this.saveAppapi(amAppapi);
            }
        }
        if (amAppapiParamList != null && !amAppapiParamList.isEmpty()) {
            for (AmAppapiParam amAppapiParam : amAppapiParamList) {
                if (this.getAmParam(amAppapiParam.getAppapiCode(), amAppapiParam.getParamName(), amAppapiParam.getParamDire(), amAppapiParam.getAppapiVersion()) != null) continue;
                this.saveAppapiParam(amAppapiParam);
            }
        }
        if (amAppapiRouterList != null && !amAppapiRouterList.isEmpty()) {
            for (AmAppapiRouter amAppapiRouter : amAppapiRouterList) {
                if (this.getAmRouter(amAppapiRouter.getAppapiCode(), amAppapiRouter.getAppapiVersion(), amAppapiRouter.getRouterDire()) != null) continue;
                this.saveAppapiRouter(amAppapiRouter);
            }
        }
        if (amAppapiErrorList != null && !amAppapiErrorList.isEmpty()) {
            for (AmAppapiError amAppapiError : amAppapiErrorList) {
                if (this.getAmError(amAppapiError.getAppapiCode(), amAppapiError.getAppapiVersion(), amAppapiError.getErrorName()) != null) continue;
                this.saveAppapiError(amAppapiError);
            }
        }
    }

    private AmAppapi getAmAppapi(String appapiCode, String version) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiCode", appapiCode);
        map.put("appapiVersion", version);
        List<AmAppapi> list = this.queryApipage(map);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private AmAppapiRouter getAmRouter(String appapiCode, String version, int routerDire) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiCode", appapiCode);
        map.put("appapiVersion", version);
        map.put("routerDire", routerDire);
        List<AmAppapiRouter> list = this.queryRouterPage(map);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private AmAppapiParam getAmParam(String appapiCode, String paramName, int paramDire, String version) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiCode", appapiCode);
        map.put("appapiVersion", version);
        map.put("paramDire", paramDire);
        map.put("paramName", paramName);
        List<AmAppapiParam> list = this.queryParamPage(map);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private AmAppapiError getAmError(String appapiCode, String version, String errorName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiCode", appapiCode);
        map.put("appapiVersion", version);
        map.put("errorName", errorName);
        List<AmAppapiError> list = this.queryApierrorPage(map);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public void safetyApiUpdate(AmAppapiDomain amAppapiDomain) throws ApiException {
        String msg = this.checkForSafetyApiUpdate(amAppapiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateAppapiRouter.null", msg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiId", amAppapiDomain.getAppapiId());
        map.put("appapiOutshow", amAppapiDomain.getAppapiOutshow());
        map.put("appapiInshow", amAppapiDomain.getAppapiInshow());
        if (null != amAppapiDomain.getAppapiInproxy()) {
            map.put("appapiInproxy", amAppapiDomain.getAppapiInproxy());
        }
        if (null != amAppapiDomain.getAppapiOutproxy()) {
            map.put("appapiOutproxy", amAppapiDomain.getAppapiOutproxy());
        }
        this.safetyApiUpdateModel(map);
        AmAppapi amAppapi = this.getApiByPrimaryKey(amAppapiDomain.getAppapiId());
        this.refreshApiCache(amAppapi, false);
    }

    private int safetyApiUpdateModel(Map<String, Object> map) throws ApiException {
        int i = 0;
        try {
            i = this.amAppapiMapper.safetyApiUpdate(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiMode.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.updateStateAppapiMode.null");
        }
        return i;
    }

    private String checkForSafetyApiUpdate(AmAppapiDomain amAppapiDomain) {
        if (null == amAppapiDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amAppapiDomain.getAppapiId().toString())) {
            msg = msg + "AppapiId\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amAppapiDomain.getAppapiOutshow().toString())) {
            msg = msg + "AppapiOutshow\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amAppapiDomain.getAppapiInshow().toString())) {
            msg = msg + "AppapiInshow\u4e3a\u7a7a;";
        }
        return msg;
    }

    @Override
    public void updateReleaseSyncApi(List<AmAppapimng> amAppapimngList, List<AmAppapimngParam> amAppapimngParamList) {
        ArrayList<AmAppapi> addAmAppapiList = new ArrayList<AmAppapi>();
        ArrayList<AmAppapi> updateAmAppapiList = new ArrayList<AmAppapi>();
        ArrayList<AmAppapiParam> addAmAppapiParamList = new ArrayList<AmAppapiParam>();
        ArrayList<AmAppapiParam> updateAmAppapiParamList = new ArrayList<AmAppapiParam>();
        Date nowDate = this.getSysDate();
        this.makeReleaseApiList(amAppapimngList, addAmAppapiList, updateAmAppapiList, nowDate);
        this.makeReleaseApiParamList(amAppapimngParamList, addAmAppapiParamList, updateAmAppapiParamList, nowDate);
        this.saveOrUpdateApi(addAmAppapiList, true);
        this.saveOrUpdateApi(updateAmAppapiList, false);
        this.saveOrUpdateApiParam(addAmAppapiParamList, true);
        this.saveOrUpdateApiParam(updateAmAppapiParamList, false);
    }

    public void makeReleaseApiParamList(List<AmAppapimngParam> amAppapimngParamList, List<AmAppapiParam> addAmAppapiParamList, List<AmAppapiParam> updateAmAppapiParamList, Date nowDate) {
        if (CollectionUtils.isNotEmpty(amAppapimngParamList)) {
            for (AmAppapimngParam amAppapimngParam : amAppapimngParamList) {
                AmAppapiParam amAppapiParam = this.makeAmAppapiParam(amAppapimngParam);
                if (amAppapiParam == null) continue;
                amAppapiParam.setGmtModified(nowDate);
                if (amAppapimngParam.getUpdateType() == 1) {
                    amAppapiParam.setGmtCreate(nowDate);
                    if (amAppapimngParam.getDataState() == 1) {
                        amAppapiParam.setDataCstate(1);
                    } else {
                        amAppapiParam.setDataCstate(0);
                    }
                    addAmAppapiParamList.add(amAppapiParam);
                    continue;
                }
                if (amAppapimngParam.getUpdateType() == 3) {
                    amAppapiParam.setDataCstate(0);
                    amAppapiParam.setDataState(1);
                }
                updateAmAppapiParamList.add(amAppapiParam);
            }
        }
    }

    public void makeReleaseApiList(List<AmAppapimng> amAppapimngList, List<AmAppapi> addAmAppapiList, List<AmAppapi> updateAmAppapiList, Date nowDate) {
        if (CollectionUtils.isNotEmpty(amAppapimngList)) {
            for (AmAppapimng amAppapimng : amAppapimngList) {
                AmAppapi amAppapi;
                if (amAppapimng.getUpdateType() == 0 || (amAppapi = this.makeAmAppapi(amAppapimng)) == null) continue;
                amAppapi.setGmtModified(nowDate);
                amAppapi.setDataCstate(amAppapi.getDataState());
                if (amAppapimng.getUpdateType() == 1) {
                    amAppapi.setGmtCreate(nowDate);
                    if (amAppapimng.getDataState() == 1) {
                        amAppapi.setDataCstate(1);
                    } else {
                        amAppapi.setDataCstate(0);
                    }
                    addAmAppapiList.add(amAppapi);
                    continue;
                }
                if (amAppapimng.getUpdateType() == 3) {
                    amAppapi.setDataCstate(0);
                    amAppapi.setDataState(1);
                }
                updateAmAppapiList.add(amAppapi);
            }
        }
    }

    private void saveOrUpdateApi(List<AmAppapi> amAppapiList, boolean save) {
        if (CollectionUtils.isNotEmpty(amAppapiList)) {
            for (AmAppapi amAppapi : amAppapiList) {
                int i = this.countApiUpdate(amAppapi);
                if (save) {
                    if (i > 0) {
                        throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.saveOrUpdateApi.ex");
                    }
                    this.saveApiMode(amAppapi);
                    continue;
                }
                if (i < 1) {
                    throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.saveOrUpdateApi.ex");
                }
                this.updateAppapiModelByUnique(amAppapi);
            }
        }
    }

    private int countApiUpdate(AmAppapi amAppapi) {
        String apiCode = amAppapi.getAppapiCode();
        String apiVersion = amAppapi.getAppapiVersion();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiCode", apiCode);
        map.put("appapiVersion", apiVersion);
        return this.countApi(map);
    }

    private void saveOrUpdateApiParam(List<AmAppapiParam> amAppapiParamList, boolean save) {
        if (CollectionUtils.isNotEmpty(amAppapiParamList)) {
            for (AmAppapiParam amAppapiParam : amAppapiParamList) {
                int i = this.countApiParamUpdate(amAppapiParam);
                if (save) {
                    if (i > 0) {
                        throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.saveOrUpdateApiParam.ex");
                    }
                    this.saveApiParamMode(amAppapiParam);
                    continue;
                }
                if (i < 1) {
                    throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.saveOrUpdateApiParam.ex");
                }
                this.updateAppapiParamModelByUnique(amAppapiParam);
            }
        }
    }

    private int countApiParamUpdate(AmAppapiParam amAppapiParam) {
        String apiCode = amAppapiParam.getAppapiCode();
        String apiVersion = amAppapiParam.getAppapiVersion();
        String paramName = amAppapiParam.getParamName();
        String paramDire = amAppapiParam.getParamDire().toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiCode", apiCode);
        map.put("appapiVersion", apiVersion);
        map.put("paramName", paramName);
        map.put("paramDire", paramDire);
        return this.amAppapiParamMapper.count(map);
    }

    public AmAppapi makeAmAppapi(AmAppapimng amAppapimng) {
        if (amAppapimng == null) {
            return null;
        }
        AmAppapi amAppapi = new AmAppapi();
        try {
            BeanUtils.copyAllPropertys((Object)amAppapi, (Object)amAppapimng);
        }
        catch (Exception e) {
            return null;
        }
        return amAppapi;
    }

    public AmAppapiParam makeAmAppapiParam(AmAppapimngParam amAppapimngParam) {
        if (amAppapimngParam == null) {
            return null;
        }
        AmAppapiParam amAppapiParam = new AmAppapiParam();
        try {
            BeanUtils.copyAllPropertys((Object)amAppapiParam, (Object)amAppapimngParam);
        }
        catch (Exception e) {
            return null;
        }
        return amAppapiParam;
    }

    @Override
    public void queryApiErrorCache() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<AmAppapiError> list = this.queryApierrorPage(parammap);
        if (CollectionUtils.isEmpty(list)) {
            DisUtil.delVer((String)"EcoreAppapiError-pro");
            return;
        }
        HashMap<String, List<ApiError>> errorMap = new HashMap<String, List<ApiError>>();
        for (AmAppapiError amAppapiError : list) {
            this.saveApiErrorCache(errorMap, amAppapiError);
        }
        DisUtil.setVer((String)"EcoreAppapiError-pro", (String)JsonUtil.buildNormalBinder().toJson(errorMap));
    }

    private void saveApiErrorCache(Map<String, List<ApiError>> errorMap, AmAppapiError amAppapiError) {
        String key = amAppapiError.getAppapiCode() + "-" + amAppapiError.getAppapiVersion();
        ApiError apiError = this.makeApiError(amAppapiError);
        List<ApiError> apiErrorList = errorMap.get(key);
        if (ListUtil.isEmpty(apiErrorList)) {
            apiErrorList = new ArrayList<ApiError>();
            errorMap.put(key, apiErrorList);
        }
        apiErrorList.add(apiError);
    }

    private void refreshApiErrorCache(AmAppapiError amAppapiError, Integer dataState) {
        boolean addflag = dataState == 1;
        HashMap<String, List<ApiError>> map = DisUtil.getMapByListJson((String)"EcoreAppapiError-pro", String.class, ApiError.class);
        if (map == null) {
            map = new HashMap<String, List<ApiError>>();
        }
        if (addflag) {
            this.saveApiErrorCache(map, amAppapiError);
        } else {
            this.deleteErrorCache(amAppapiError, map);
        }
        DisUtil.setVer((String)"EcoreAppapiError-pro", (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    private void deleteErrorCache(AmAppapiError amAppapiError, Map<String, List<ApiError>> map) {
        if (map == null) {
            return;
        }
        String key = amAppapiError.getAppapiCode() + "-" + amAppapiError.getAppapiVersion();
        List<ApiError> list = map.get(key);
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getErrorId().equals(amAppapiError.getErrorId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    @Override
    public void deleteAppapiRouterByDire(Integer routerDire) throws ApiException {
        this.deleteAppapiRouterModelByDire(routerDire);
    }

    private void deleteAppapiRouterModelByDire(Integer routerDire) {
        int i = 0;
        try {
            i = this.amAppapiRouterMapper.deleteAppapiRouterByDire(routerDire);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiRouterModelByDire.ex");
        }
        if (i < 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppapiServiceImpl.deleteAppapiRouterModelByDire.null");
        }
    }

    @Override
    public QueryResult<AmAppapi> queryApiByCodes(Map<String, Object> map) {
        List<AmAppapi> amAppapiList = this.amAppapiMapper.queryByCodes(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countApi(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amAppapiList);
        return queryResult;
    }

    @Override
    public QueryResult<AmAppapiParam> queryApiParamByCodes(Map<String, Object> map) {
        List<AmAppapiParam> amAppapiList = this.amAppapiParamMapper.queryByCodes(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countApi(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amAppapiList);
        return queryResult;
    }
}

