/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.dao.AmAppapiJsonMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppapiJsonDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppapiJsonReDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppapiJson;
import com.yqbsoft.laser.service.esb.appmanage.service.AmAppapiJsonService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmAppapiJsonServiceImpl
extends BaseServiceImpl
implements AmAppapiJsonService {
    private static final String SYS_CODE = "am.ESB.APPMANAGE.AmAppapiJsonServiceImpl";
    private AmAppapiJsonMapper amAppapiJsonMapper;

    public void setAmAppapiJsonMapper(AmAppapiJsonMapper amAppapiJsonMapper) {
        this.amAppapiJsonMapper = amAppapiJsonMapper;
    }

    private Date getSysDate() {
        try {
            return this.amAppapiJsonMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAppapiJson(AmAppapiJsonDomain amAppapiJsonDomain) {
        if (null == amAppapiJsonDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amAppapiJsonDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAppapiJsonDefault(AmAppapiJson amAppapiJson) {
        if (null == amAppapiJson) {
            return;
        }
        if (null == amAppapiJson.getDataState()) {
            amAppapiJson.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == amAppapiJson.getGmtCreate()) {
            amAppapiJson.setGmtCreate(date);
        }
        amAppapiJson.setGmtModified(date);
        if (StringUtils.isBlank((String)amAppapiJson.getAppapiCode())) {
            amAppapiJson.setAppapiCode(this.getNo(null, "AmAppapiJson", "amAppapiJson", amAppapiJson.getTenantCode()));
        }
    }

    private int getAppapiJsonMaxCode() {
        int code = 0;
        try {
            return this.amAppapiJsonMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.getAppapiJsonMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAppapiJsonUpdataDefault(AmAppapiJson amAppapiJson) {
        if (null == amAppapiJson) {
            return;
        }
        amAppapiJson.setGmtModified(this.getSysDate());
    }

    private void saveAppapiJsonModel(AmAppapiJson amAppapiJson) throws ApiException {
        if (null == amAppapiJson) {
            return;
        }
        try {
            this.amAppapiJsonMapper.insert(amAppapiJson);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.saveAppapiJsonModel.ex", (Throwable)e);
        }
    }

    private void saveAppapiJsonBatchModel(List<AmAppapiJson> amAppapiJsonList) throws ApiException {
        if (null == amAppapiJsonList || amAppapiJsonList.isEmpty()) {
            return;
        }
        try {
            this.amAppapiJsonMapper.insertBatch(amAppapiJsonList);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.saveAppapiJsonBatchModel.ex", (Throwable)e);
        }
    }

    private AmAppapiJson getAppapiJsonModelById(Integer appapiJsonId) {
        if (null == appapiJsonId) {
            return null;
        }
        try {
            return this.amAppapiJsonMapper.selectByPrimaryKey(appapiJsonId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.getAppapiJsonModelById", (Throwable)e);
            return null;
        }
    }

    private AmAppapiJson getAppapiJsonModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.amAppapiJsonMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.getAppapiJsonModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAppapiJsonModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.amAppapiJsonMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.delAppapiJsonModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.delAppapiJsonModelByCode.num");
        }
    }

    private void deleteAppapiJsonModel(Integer appapiJsonId) throws ApiException {
        if (null == appapiJsonId) {
            return;
        }
        int i = 0;
        try {
            i = this.amAppapiJsonMapper.deleteByPrimaryKey(appapiJsonId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.deleteAppapiJsonModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.deleteAppapiJsonModel.num");
        }
    }

    private void updateAppapiJsonModel(AmAppapiJson amAppapiJson) throws ApiException {
        if (null == amAppapiJson) {
            return;
        }
        int i = 0;
        try {
            i = this.amAppapiJsonMapper.updateByPrimaryKeySelective(amAppapiJson);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.updateAppapiJsonModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.updateAppapiJsonModel.num");
        }
    }

    private void updateStateAppapiJsonModel(Integer appapiJsonId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == appapiJsonId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appapiJsonId", appapiJsonId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.amAppapiJsonMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.updateStateAppapiJsonModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.updateStateAppapiJsonModel.null");
        }
    }

    private void updateStateAppapiJsonModelByCode(String tenantCode, String appapiCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)appapiCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("appapiCode", appapiCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.amAppapiJsonMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.updateStateAppapiJsonModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.updateStateAppapiJsonModelByCode.null");
        }
    }

    private AmAppapiJson makeAppapiJson(AmAppapiJsonDomain amAppapiJsonDomain, AmAppapiJson amAppapiJson) {
        if (null == amAppapiJsonDomain) {
            return null;
        }
        if (null == amAppapiJson) {
            amAppapiJson = new AmAppapiJson();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amAppapiJson, (Object)amAppapiJsonDomain);
            return amAppapiJson;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.makeAppapiJson", (Throwable)e);
            return null;
        }
    }

    private AmAppapiJsonReDomain makeAmAppapiJsonReDomain(AmAppapiJson amAppapiJson) {
        if (null == amAppapiJson) {
            return null;
        }
        AmAppapiJsonReDomain amAppapiJsonReDomain = new AmAppapiJsonReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)amAppapiJsonReDomain, (Object)amAppapiJson);
            return amAppapiJsonReDomain;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.makeAmAppapiJsonReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AmAppapiJson> queryAppapiJsonModelPage(Map<String, Object> parammap) {
        try {
            return this.amAppapiJsonMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.queryAppapiJsonModel", (Throwable)e);
            return null;
        }
    }

    private int countAppapiJson(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amAppapiJsonMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.countAppapiJson", (Throwable)e);
        }
        return i;
    }

    private AmAppapiJson createAmAppapiJson(AmAppapiJsonDomain amAppapiJsonDomain) {
        String msg = this.checkAppapiJson(amAppapiJsonDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.saveAppapiJson.checkAppapiJson", msg);
        }
        AmAppapiJson amAppapiJson = this.makeAppapiJson(amAppapiJsonDomain, null);
        this.setAppapiJsonDefault(amAppapiJson);
        return amAppapiJson;
    }

    @Override
    public String saveAppapiJson(AmAppapiJsonDomain amAppapiJsonDomain) throws ApiException {
        AmAppapiJson amAppapiJson = this.createAmAppapiJson(amAppapiJsonDomain);
        this.saveAppapiJsonModel(amAppapiJson);
        return amAppapiJson.getAppapiCode();
    }

    @Override
    public String saveAppapiJsonBatch(List<AmAppapiJsonDomain> amAppapiJsonDomainList) throws ApiException {
        if (null == amAppapiJsonDomainList || amAppapiJsonDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AmAppapiJson> amAppapiJsonList = new ArrayList<AmAppapiJson>();
        String code = "";
        for (AmAppapiJsonDomain amAppapiJsonDomain : amAppapiJsonDomainList) {
            AmAppapiJson amAppapiJson = this.createAmAppapiJson(amAppapiJsonDomain);
            code = amAppapiJson.getAppapiCode();
            amAppapiJsonList.add(amAppapiJson);
        }
        this.saveAppapiJsonBatchModel(amAppapiJsonList);
        return code;
    }

    @Override
    public void updateAppapiJsonState(Integer appapiJsonId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == appapiJsonId) {
            return;
        }
        this.updateStateAppapiJsonModel(appapiJsonId, dataState, oldDataState, map);
    }

    @Override
    public void updateAppapiJsonStateByCode(String tenantCode, String appapiCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)appapiCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAppapiJsonModelByCode(tenantCode, appapiCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAppapiJson(AmAppapiJsonDomain amAppapiJsonDomain) throws ApiException {
        String msg = this.checkAppapiJson(amAppapiJsonDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.updateAppapiJson.checkAppapiJson", msg);
        }
        AmAppapiJson oldAmAppapiJson = this.getAppapiJsonModelById(amAppapiJsonDomain.getAppapiJsonId());
        if (null == oldAmAppapiJson) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppapiJsonServiceImpl.updateAppapiJson.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmAppapiJson amAppapiJson = this.makeAppapiJson(amAppapiJsonDomain, oldAmAppapiJson);
        this.setAppapiJsonUpdataDefault(amAppapiJson);
        this.updateAppapiJsonModel(amAppapiJson);
    }

    @Override
    public AmAppapiJson getAppapiJson(Integer appapiJsonId) {
        if (null == appapiJsonId) {
            return null;
        }
        return this.getAppapiJsonModelById(appapiJsonId);
    }

    @Override
    public void deleteAppapiJson(Integer appapiJsonId) throws ApiException {
        if (null == appapiJsonId) {
            return;
        }
        this.deleteAppapiJsonModel(appapiJsonId);
    }

    @Override
    public QueryResult<AmAppapiJson> queryAppapiJsonPage(Map<String, Object> map) {
        List<AmAppapiJson> amAppapiJsonList = this.queryAppapiJsonModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAppapiJson(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amAppapiJsonList);
        return queryResult;
    }

    @Override
    public AmAppapiJson getAppapiJsonByCode(String tenantCode, String appapiCode) throws ApiException {
        if (StringUtils.isBlank((String)appapiCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("appapiCode", appapiCode);
        return this.getAppapiJsonModelByCode(map);
    }

    @Override
    public void deleteAppapiJsonByCode(String tenantCode, String appapiCode) throws ApiException {
        if (StringUtils.isBlank((String)appapiCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("appapiCode", appapiCode);
        this.delAppapiJsonModelByCode(map);
    }
}

