/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.channel.service.impl;

import com.yqbsoft.laser.service.esb.channel.dao.McChannelListMapper;
import com.yqbsoft.laser.service.esb.channel.dao.McChannelMapper;
import com.yqbsoft.laser.service.esb.channel.domain.McChannelDomainBean;
import com.yqbsoft.laser.service.esb.channel.domain.McChannelListDomainBean;
import com.yqbsoft.laser.service.esb.channel.model.McChannel;
import com.yqbsoft.laser.service.esb.channel.model.McChannelList;
import com.yqbsoft.laser.service.esb.channel.service.ChannelService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.jms.invo.ConnetBean;
import com.yqbsoft.laser.service.esb.core.jms.invo.ProducerSessionBean;
import com.yqbsoft.laser.service.esb.core.jms.invo.SessionBean;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChannelServiceImpl
extends BaseServiceImpl
implements ChannelService {
    public static final String SYS_CODE = "mc.ESB.CHANNEL.ChannelServiceImpl";
    private McChannelListMapper mcChannelListMapper;
    private McChannelMapper mcChannelMapper;

    public McChannelListMapper getMcChannelListMapper() {
        return this.mcChannelListMapper;
    }

    public void setMcChannelListMapper(McChannelListMapper mcChannelListMapper) {
        this.mcChannelListMapper = mcChannelListMapper;
    }

    public McChannelMapper getMcChannelMapper() {
        return this.mcChannelMapper;
    }

    public void setMcChannelMapper(McChannelMapper mcChannelMapper) {
        this.mcChannelMapper = mcChannelMapper;
    }

    private String check(McChannel mcChannel) {
        if (null == mcChannel) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mcChannel.getAppmanageIcode())) {
            msg = msg + "Icode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)mcChannel.getChannelName())) {
            msg = msg + "ChannelName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)mcChannel.getChannelUrl())) {
            msg = msg + "ChannelUrl\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)mcChannel.getChannelClentid())) {
            msg = msg + "ChannelClentid\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String check(McChannelList mcChannelList) {
        if (null == mcChannelList) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mcChannelList.getChannelClentid())) {
            msg = msg + "ChannelClentid\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)mcChannelList.getChannelListName())) {
            msg = msg + "ChannelListName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)mcChannelList.getChannelListType())) {
            msg = msg + "ChannelListType\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(McChannel mcChannel) {
        if (null == mcChannel) {
            return;
        }
        if (null == mcChannel.getDataState()) {
            mcChannel.setDataState(0);
        }
        if (null == mcChannel.getGmtCreate()) {
            mcChannel.setGmtCreate(this.getSysDate());
        }
    }

    private void saveChannelMode(McChannel mcChannel) throws ApiException {
        if (null == mcChannel) {
            return;
        }
        try {
            this.mcChannelMapper.insert(mcChannel);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.saveChannelMode.ex");
        }
    }

    private Date getSysDate() {
        try {
            return this.mcChannelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mc.ESB.CHANNEL.ChannelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String check(McChannelListDomainBean mcChannelListDomainBean) {
        if (null == mcChannelListDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mcChannelListDomainBean.getChannelClentid())) {
            msg = msg + "ChannelClentid\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)mcChannelListDomainBean.getChannelListName())) {
            msg = msg + "ChannelListName\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(McChannelList mcChannelList) {
        if (null == mcChannelList) {
            return;
        }
        if (null == mcChannelList.getDataState()) {
            mcChannelList.setDataState(0);
        }
        if (null == mcChannelList.getGmtCreate()) {
            mcChannelList.setGmtCreate(this.getSysDate());
        }
    }

    private void saveChannelMode(McChannelList mcChannelList) throws ApiException {
        if (null == mcChannelList) {
            return;
        }
        try {
            this.mcChannelListMapper.insert(mcChannelList);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.saveChannelMode.ex");
        }
    }

    private void updateStateChannelMode(Integer channelId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == channelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelId", channelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mcChannelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.updateStateListMode.ex");
        }
        if (i <= 0) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.updateStateListMode.null");
        }
    }

    private void updateStateListMode(Integer channelListId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == channelListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelListId", channelListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mcChannelListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.updateStateListMode.ex");
        }
        if (i <= 0) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.updateStateListMode.null");
        }
    }

    private void createSeesion(String connectName, String appmanageIcode, List<McChannelList> mcChannelListList, Map<String, List<ProducerSessionBean>> pmap, Map<String, List<SessionBean>> cmap, Map<String, List<String>> icodemap) {
        if (null == mcChannelListList || mcChannelListList.isEmpty() || null == icodemap || null == pmap || null == cmap) {
            return;
        }
        if (StringUtils.isBlank((String)connectName)) {
            return;
        }
        List<ProducerSessionBean> plist = null;
        List<SessionBean> clist = null;
        List<String> icodelist = null;
        String channelListIcode = null;
        String icodeKey = null;
        for (McChannelList mcChannelList : mcChannelListList) {
            SessionBean sessionBean;
            channelListIcode = mcChannelList.getChannelListIcode();
            if (StringUtils.isNotBlank((String)channelListIcode) && "Producer".equals(mcChannelList.getChannelListType())) {
                icodeKey = appmanageIcode + "-" + channelListIcode + "-" + mcChannelList.getChannelListType();
                icodelist = icodemap.get(icodeKey);
                if (null == icodelist) {
                    icodelist = new ArrayList<String>();
                    icodemap.put(icodeKey, icodelist);
                }
                icodelist.add(mcChannelList.getChannelListName());
            }
            if ("Producer".equals(mcChannelList.getChannelListType())) {
                ProducerSessionBean producerSessionBean;
                plist = pmap.get(connectName + "-" + "Producer");
                if (null == plist) {
                    plist = new ArrayList<ProducerSessionBean>();
                    pmap.put(connectName + "-" + "Producer", plist);
                }
                if (null != (producerSessionBean = this.makeProducerBean(mcChannelList))) {
                    producerSessionBean.setConnectName(connectName);
                }
                plist.add(producerSessionBean);
                continue;
            }
            clist = cmap.get(connectName + "-" + "Consumer");
            if (null == clist) {
                clist = new ArrayList<SessionBean>();
                cmap.put(connectName + "-" + "Consumer", clist);
            }
            if (null != (sessionBean = this.makeSessionBean(mcChannelList))) {
                sessionBean.setConnectName(connectName);
            }
            clist.add(sessionBean);
        }
    }

    private ProducerSessionBean makeProducerBean(McChannelList mcChannelList) {
        String strValue;
        if (null == mcChannelList) {
            return null;
        }
        Map paramMap = null;
        StringBuffer paramSB = null;
        if (null != mcChannelList.getChannelListMesparam() && mcChannelList.getChannelListMesparam().length() > 0) {
            paramSB = new StringBuffer("?");
            paramMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(mcChannelList.getChannelListMesparam(), String.class, String.class);
            for (String key : paramMap.keySet()) {
                strValue = (String)paramMap.get(key);
                paramSB.append(key + "=" + (null == strValue ? "" : strValue));
            }
            mcChannelList.setChannelListMesname(mcChannelList.getChannelListMesname() + paramSB.toString());
        }
        if (null != mcChannelList.getChannelListRepmesparam() && mcChannelList.getChannelListMesparam().length() > 0) {
            paramSB = new StringBuffer("?");
            paramMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(mcChannelList.getChannelListMesparam(), String.class, String.class);
            for (String key : paramMap.keySet()) {
                strValue = (String)paramMap.get(key);
                paramSB.append(key + "=" + (null == strValue ? "" : strValue));
            }
            mcChannelList.setChannelListMesname(mcChannelList.getChannelListRepmesname() + paramSB.toString());
        }
        ProducerSessionBean producerSessionBean = new ProducerSessionBean();
        producerSessionBean.setAckMode(mcChannelList.getChannelListAckmode().intValue());
        producerSessionBean.setDeliveryMode(mcChannelList.getChannelListDelmode().intValue());
        producerSessionBean.setMessageName(mcChannelList.getChannelListMesname());
        producerSessionBean.setMessageType(mcChannelList.getChannelListMestype());
        producerSessionBean.setName(mcChannelList.getChannelListName());
        producerSessionBean.setReplyAckMode(mcChannelList.getChannelListRepackmode().intValue());
        producerSessionBean.setReplyDeliveryMode(mcChannelList.getChannelListRepdelmode().intValue());
        producerSessionBean.setReplyMessageName(mcChannelList.getChannelListRepmesname());
        if (1 == mcChannelList.getChannelListIsreptran()) {
            producerSessionBean.setReplyTransacted(true);
        } else {
            producerSessionBean.setReplyTransacted(false);
        }
        producerSessionBean.setReplyType(String.valueOf(mcChannelList.getChannelListReptype()));
        if (1 == mcChannelList.getChannelListIstran()) {
            producerSessionBean.setTransacted(true);
        } else {
            producerSessionBean.setTransacted(false);
        }
        return producerSessionBean;
    }

    private SessionBean makeSessionBean(McChannelList mcChannelList) {
        String strValue;
        if (null == mcChannelList) {
            return null;
        }
        Map paramMap = null;
        StringBuffer paramSB = null;
        if (null != mcChannelList.getChannelListMesparam() && mcChannelList.getChannelListMesparam().length() > 0) {
            paramSB = new StringBuffer("?");
            paramMap = JsonUtil.getJsonToMap((String)mcChannelList.getChannelListMesparam());
            for (String key : paramMap.keySet()) {
                strValue = (String)paramMap.get(key);
                paramSB.append(key + "=" + (null == strValue ? "" : strValue));
            }
            mcChannelList.setChannelListMesname(mcChannelList.getChannelListMesname() + paramSB.toString());
        }
        if (null != mcChannelList.getChannelListRepmesparam() && mcChannelList.getChannelListMesparam().length() > 0) {
            paramSB = new StringBuffer("?");
            paramMap = JsonUtil.getJsonToMap((String)mcChannelList.getChannelListRepmesparam());
            for (String key : paramMap.keySet()) {
                strValue = (String)paramMap.get(key);
                paramSB.append(key + "=" + (null == strValue ? "" : strValue));
            }
            mcChannelList.setChannelListMesname(mcChannelList.getChannelListRepmesname() + paramSB.toString());
        }
        SessionBean sessionBean = new SessionBean();
        sessionBean.setAckMode(mcChannelList.getChannelListAckmode().intValue());
        sessionBean.setDeliveryMode(mcChannelList.getChannelListDelmode().intValue());
        sessionBean.setMessageName(mcChannelList.getChannelListMesname());
        sessionBean.setMessageType(mcChannelList.getChannelListMestype());
        sessionBean.setName(mcChannelList.getChannelListName());
        sessionBean.setReplyAckMode(mcChannelList.getChannelListRepackmode().intValue());
        sessionBean.setReplyDeliveryMode(mcChannelList.getChannelListRepdelmode().intValue());
        sessionBean.setReplyType(String.valueOf(mcChannelList.getChannelListReptype()));
        sessionBean.setCorePoolSize(null == mcChannelList.getChannelListCorepoolsize() ? 0 : mcChannelList.getChannelListCorepoolsize());
        sessionBean.setMaximumPoolSize(null == mcChannelList.getChannelListMaximumpoolsize() ? 0 : mcChannelList.getChannelListMaximumpoolsize());
        sessionBean.setKeepAliveTime(null == mcChannelList.getChannelListKeepalivetime() ? 0L : (long)mcChannelList.getChannelListKeepalivetime().intValue());
        if (1 == mcChannelList.getChannelListIsreptran()) {
            sessionBean.setReplyTransacted(true);
        } else {
            sessionBean.setReplyTransacted(false);
        }
        if (1 == mcChannelList.getChannelListIstran()) {
            sessionBean.setTransacted(true);
        } else {
            sessionBean.setTransacted(false);
        }
        return sessionBean;
    }

    private ConnetBean makeBean(McChannel mcChannel) {
        if (null == mcChannel) {
            return null;
        }
        ConnetBean connetBean = new ConnetBean();
        connetBean.setBrokerURL(mcChannel.getChannelUrl());
        connetBean.setClientID(mcChannel.getChannelClentid());
        connetBean.setName(mcChannel.getChannelName());
        connetBean.setMqAppkey(mcChannel.getChannelMqappkey());
        return connetBean;
    }

    private Map<String, List<McChannelList>> makeMap(List<McChannelList> mcChannelListList) {
        if (null == mcChannelListList || mcChannelListList.isEmpty()) {
            return null;
        }
        HashMap<String, List<McChannelList>> map = new HashMap<String, List<McChannelList>>();
        ArrayList<McChannelList> list = null;
        for (McChannelList mcChannelList : mcChannelListList) {
            list = (ArrayList<McChannelList>)map.get(mcChannelList.getChannelClentid());
            if (null == list) {
                list = new ArrayList<McChannelList>();
                map.put(mcChannelList.getChannelClentid(), list);
            }
            list.add(mcChannelList);
        }
        return map;
    }

    private List<McChannel> queryChannel(Map<String, Object> map) {
        try {
            return this.mcChannelMapper.queryChannel(map);
        }
        catch (Exception e) {
            this.logger.error("mc.ESB.CHANNEL.ChannelServiceImpl.queryChannel", (Throwable)e);
            return null;
        }
    }

    private List<McChannelList> queryChannelList(Map<String, Object> map) {
        try {
            return this.mcChannelListMapper.queryChannelList(map);
        }
        catch (Exception e) {
            this.logger.error("mc.ESB.CHANNEL.ChannelServiceImpl.queryChannelList", (Throwable)e);
            return null;
        }
    }

    @Override
    public void saveMcChannel(McChannelDomainBean mcChannelDomainBean) throws ApiException {
        McChannel mcChannel = new McChannel();
        String msg = this.check(mcChannel = this.makeModel(mcChannel, mcChannelDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.saveMcChannel.null", msg);
        }
        this.setDefault(mcChannel);
        this.saveChannelMode(mcChannel);
    }

    private McChannel makeModel(McChannel mcChannel, McChannelDomainBean mcChannelDomainBean) {
        if (mcChannelDomainBean == null) {
            return null;
        }
        if (mcChannel == null) {
            mcChannel = new McChannel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mcChannel, (Object)mcChannelDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mcChannel;
    }

    private McChannelList makeModel(McChannelList mcChannelList, McChannelListDomainBean mcChannelListDomainBean) {
        if (mcChannelListDomainBean == null) {
            return null;
        }
        if (mcChannelList == null) {
            mcChannelList = new McChannelList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mcChannelList, (Object)mcChannelListDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mcChannelList;
    }

    @Override
    public void saveMcChannelList(McChannelListDomainBean mcChannelListDomainBean) throws ApiException {
        String msg = this.check(mcChannelListDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.saveMcChannelList.null", msg);
        }
        McChannelList mcChannelList = new McChannelList();
        mcChannelList = this.makeModel(mcChannelList, mcChannelListDomainBean);
        this.setDefault(mcChannelList);
        this.saveChannelMode(mcChannelList);
    }

    @Override
    public void queryLoadChannelInit() {
        this.info("mc.ESB.CHANNEL.ChannelServiceImpl.queryLoadChannelInit", "=====chiannel==start====");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", 1);
        List<McChannel> mcChannelList = this.queryChannel(map);
        String cachekey = "McChannel-start";
        String listpkey = "McChannelList-p-start";
        String listckey = "McChannelList-c-start";
        String listicodekey = "McChannelList-icode-start";
        if (null == mcChannelList || mcChannelList.isEmpty()) {
            DisUtil.delVer((String)cachekey);
            DisUtil.delVer((String)listpkey);
            DisUtil.delVer((String)listckey);
            DisUtil.delVer((String)listicodekey);
            return;
        }
        Map<String, List<McChannelList>> listMap = this.makeMap(this.queryChannelList(map));
        this.logger.debug("mc.ESB.CHANNEL.ChannelServiceImpl.queryLoadChannelInit listMap is ", (Object)JsonUtil.buildNormalBinder().toJson(listMap));
        HashMap<String, ArrayList<ConnetBean>> connetMap = new HashMap<String, ArrayList<ConnetBean>>();
        ArrayList<ConnetBean> connetList = null;
        HashMap<String, List<ProducerSessionBean>> pmap = new HashMap<String, List<ProducerSessionBean>>();
        HashMap<String, List<SessionBean>> cmap = new HashMap<String, List<SessionBean>>();
        HashMap<String, List<String>> icodemap = new HashMap<String, List<String>>();
        for (McChannel mcChannel : mcChannelList) {
            connetList = (ArrayList<ConnetBean>)connetMap.get(mcChannel.getAppmanageIcode());
            if (null == connetList) {
                connetList = new ArrayList<ConnetBean>();
                connetMap.put(mcChannel.getAppmanageIcode(), connetList);
            }
            connetList.add(this.makeBean(mcChannel));
            this.createSeesion(mcChannel.getChannelName(), mcChannel.getAppmanageIcode(), listMap.get(mcChannel.getChannelClentid()), pmap, cmap, icodemap);
        }
        HashMap<String, String> cacheconnetMap = new HashMap<String, String>();
        for (String key : connetMap.keySet()) {
            cacheconnetMap.put(key, JsonUtil.buildNormalBinder().toJson(connetMap.get(key)));
        }
        HashMap<String, String> cachepMap = new HashMap<String, String>();
        for (String key : pmap.keySet()) {
            cachepMap.put(key, JsonUtil.buildNormalBinder().toJson(pmap.get(key)));
        }
        HashMap<String, String> cachecMap = new HashMap<String, String>();
        for (String key : cmap.keySet()) {
            cachecMap.put(key, JsonUtil.buildNormalBinder().toJson(cmap.get(key)));
        }
        DisUtil.setJsonVer((String)cachekey, cacheconnetMap);
        DisUtil.setJsonVer((String)listpkey, cachepMap);
        DisUtil.setJsonVer((String)listckey, cachecMap);
        DisUtil.setJsonVer((String)listicodekey, icodemap);
        this.info("mc.ESB.CHANNEL.ChannelServiceImpl.queryLoadChannelInit", "=====chiannel==end====");
    }

    @Override
    public void updateChannelState(Integer channelId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateChannelMode(channelId, dataState, oldDataState);
    }

    @Override
    public void updateChannelListState(Integer channelListId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateListMode(channelListId, dataState, oldDataState);
    }

    @Override
    public QueryResult<McChannel> queryMcChannelPage(Map<String, Object> map) {
        List<McChannel> mcChannelList = this.queryMcChannel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMcChannel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mcChannelList);
        return queryResult;
    }

    @Override
    public QueryResult<McChannelList> queryMcChannelListPage(Map<String, Object> map) {
        List<McChannelList> mcChannelList = this.queryChannelListPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMcChannelList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mcChannelList);
        return queryResult;
    }

    private int countMcChannel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mcChannelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mc.ESB.CHANNEL.ChannelServiceImpl.countMcChannel", (Throwable)e);
        }
        return i;
    }

    private int countMcChannelList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mcChannelListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mc.ESB.CHANNEL.ChannelServiceImpl.countMcChannel", (Throwable)e);
        }
        return i;
    }

    private List<McChannel> queryMcChannel(Map<String, Object> parameters) {
        try {
            return this.mcChannelMapper.query(parameters);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    private List<McChannelList> queryChannelListPage(Map<String, Object> parameters) {
        try {
            return this.mcChannelListMapper.query(parameters);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteChannelById(Integer channelId) throws ApiException {
        this.deleteChannel(channelId);
    }

    @Override
    public void deleteChannelListById(Integer channelListId) throws ApiException {
        this.deleteChannelList(channelListId);
    }

    private void deleteChannel(Integer channelId) throws ApiException {
        int i = 0;
        try {
            i = this.mcChannelMapper.deleteByPrimaryKey(channelId);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.deleteChannel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.deleteChannel.no");
        }
    }

    private void deleteChannelList(Integer channelListId) throws ApiException {
        int i = 0;
        try {
            i = this.mcChannelListMapper.deleteByPrimaryKey(channelListId);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.deleteChannel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.deleteChannel.no");
        }
    }

    private void deleteChannelListByIcode(String channelListIcode) throws ApiException {
        int i = 0;
        try {
            i = this.mcChannelListMapper.deleteChannelListByIcode(channelListIcode);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.deleteChannelListByIcode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.deleteChannelListByIcode.no");
        }
    }

    private void deleteByChannelClentid(String channelClentid) throws ApiException {
        int i = 0;
        try {
            i = this.mcChannelListMapper.deleteByChannelClentid(channelClentid);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.deleteChannelList.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.deleteChannelList.no");
        }
    }

    @Override
    public McChannel getMcChannel(Integer channelId) {
        return this.mcChannelMapper.selectByPrimaryKey(channelId);
    }

    public McChannelList queryMcChannelList(Integer channelListId) {
        return this.mcChannelListMapper.selectByPrimaryKey(channelListId);
    }

    @Override
    public McChannelList getMcChannelList(Integer channelListId) {
        McChannelList mcChannelList = this.queryMcChannelList(channelListId);
        return mcChannelList;
    }

    @Override
    public void updateMcChannel(McChannelDomainBean mcChannelDomainBean) throws ApiException {
        McChannel mcChannel = this.getMcChannel(mcChannelDomainBean.getChannelId());
        if (mcChannel == null) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.updateMcChannel.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(mcChannel = this.makeModel(mcChannel, mcChannelDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.updateMcChannel.check", msg);
        }
        this.setUpdateDefaultValue(mcChannel);
        this.updateChannel(mcChannel);
    }

    @Override
    public void updateMcChannelList(McChannelListDomainBean mcChannelListDomainBean) throws ApiException {
        McChannelList mcChannelList = this.queryMcChannelList(mcChannelListDomainBean.getChannelListId());
        if (mcChannelList == null) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.updateMcChannelList.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(mcChannelList = this.makeModel(mcChannelList, mcChannelListDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.updateMcChannelList.check", msg);
        }
        this.setUpdateDefaultValue(mcChannelList);
        this.updateChannelList(mcChannelList);
    }

    private void setUpdateDefaultValue(McChannel mcChannel) {
        if (null == mcChannel) {
            return;
        }
        if (null == mcChannel.getDataState()) {
            mcChannel.setDataState(0);
        }
        if (null == mcChannel.getGmtModified()) {
            mcChannel.setGmtModified(this.getSysDate());
        }
    }

    private void setUpdateDefaultValue(McChannelList mcChannelList) {
        if (null == mcChannelList) {
            return;
        }
        if (null == mcChannelList.getDataState()) {
            mcChannelList.setDataState(0);
        }
        if (null == mcChannelList.getGmtModified()) {
            mcChannelList.setGmtModified(this.getSysDate());
        }
    }

    private void updateChannel(McChannel mcChannel) throws ApiException {
        try {
            this.mcChannelMapper.updateByPrimaryKey(mcChannel);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.updateChannel", "", (Throwable)e);
        }
    }

    private void updateChannelList(McChannelList mcChannelList) throws ApiException {
        try {
            this.mcChannelListMapper.updateByPrimaryKey(mcChannelList);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.ChannelServiceImpl.updateChannel", "", (Throwable)e);
        }
    }

    @Override
    public List<McChannel> queryMcChannelList(Map<String, Object> map) {
        return this.queryMcChannel(map);
    }

    @Override
    public void saveMcChannelByNew(McChannelDomainBean mcChannelDomainBean, List<McChannelListDomainBean> mcChannelListDomainBeanList) throws ApiException {
        this.saveMcChannel(mcChannelDomainBean);
        if (ListUtil.isNotEmpty(mcChannelListDomainBeanList)) {
            for (McChannelListDomainBean mcChannelListDomainBean : mcChannelListDomainBeanList) {
                this.saveMcChannelList(mcChannelListDomainBean);
            }
        }
    }

    @Override
    public void deleteChannelDetail(Integer channelId) throws ApiException {
        McChannel vc = this.getMcChannel(channelId);
        this.deleteByChannelClentid(vc.getChannelClentid());
        this.deleteChannelListByIcode(vc.getAppmanageIcode());
        this.deleteChannel(channelId);
    }

    @Override
    public void updateChannelDetailState(Integer channelId, Integer dataState, Integer oldDataState) throws ApiException {
        McChannel mcChannel = this.getMcChannel(channelId);
        if (mcChannel == null) {
            return;
        }
        this.updateChannelState(channelId, dataState, oldDataState);
        String[] appIcode = mcChannel.getAppmanageIcode().split("\\.");
        List<McChannelList> mcChannelListList = this.queryChannelListPage(this.getQueryParamMap("channelListMesname", new Object[]{"fr-" + appIcode[appIcode.length - 1]}));
        if (ListUtil.isEmpty(mcChannelListList)) {
            return;
        }
        for (McChannelList mcChannelList : mcChannelListList) {
            try {
                this.updateChannelListState(mcChannelList.getChannelListId(), dataState, oldDataState);
            }
            catch (Exception exception) {}
        }
        this.queryLoadChannelInit();
    }
}

