/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.channel.service.impl;

import com.yqbsoft.laser.service.esb.channel.dao.McMqserverMapper;
import com.yqbsoft.laser.service.esb.channel.domain.McMqserverDomainBean;
import com.yqbsoft.laser.service.esb.channel.model.McMqserver;
import com.yqbsoft.laser.service.esb.channel.service.MqService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.jms.invo.BrokerBean;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MqServiceImpl
extends BaseServiceImpl
implements MqService {
    public static final String SYS_CODE = "mc.ESB.CHANNEL.MqServiceImpl";
    private McMqserverMapper mcMqserverMapper;

    public McMqserverMapper getMcMqserverMapper() {
        return this.mcMqserverMapper;
    }

    public void setMcMqserverMapper(McMqserverMapper mcMqserverMapper) {
        this.mcMqserverMapper = mcMqserverMapper;
    }

    private void insertMqService(McMqserver mcMqserver) throws ApiException {
        try {
            this.mcMqserverMapper.insert(mcMqserver);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.MqServiceImpl.insertMqService", "", (Throwable)e);
        }
    }

    private void updateMqService(McMqserver mcMqserver) throws ApiException {
        try {
            this.mcMqserverMapper.updateByPrimaryKey(mcMqserver);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.MqServiceImpl.updateMqService", "", (Throwable)e);
        }
    }

    private String check(McMqserver mcMqserver) {
        if (null == mcMqserver) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mcMqserver.getMqserverName())) {
            msg = msg + "MqserverName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)mcMqserver.getMqserverUrl())) {
            msg = msg + "MqserverUrl\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInsertDefaultValue(McMqserver mcMqserver) {
        if (null == mcMqserver) {
            return;
        }
        if (null == mcMqserver.getDataState()) {
            mcMqserver.setDataState(0);
        }
        if (null == mcMqserver.getGmtCreate()) {
            mcMqserver.setGmtCreate(this.getSysDate());
        }
    }

    private void setUpdateDefaultValue(McMqserver mcMqserver) {
        if (null == mcMqserver) {
            return;
        }
        if (null == mcMqserver.getDataState()) {
            mcMqserver.setDataState(0);
        }
        if (null == mcMqserver.getGmtModified()) {
            mcMqserver.setGmtModified(this.getSysDate());
        }
    }

    private Date getSysDate() {
        try {
            return this.mcMqserverMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mc.ESB.CHANNEL.MqServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void deleteMq(Integer mqserverId) throws ApiException {
        int i = 0;
        try {
            i = this.mcMqserverMapper.deleteByPrimaryKey(mqserverId);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.MqServiceImpl.deleteMq.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mc.ESB.CHANNEL.MqServiceImpl.deleteMq.no");
        }
    }

    private void updateStateMode(Integer mqserverId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == mqserverId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mqserverId", mqserverId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mcMqserverMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.MqServiceImpl.updateStateMode.ex");
        }
        if (i <= 0) {
            throw new ApiException("mc.ESB.CHANNEL.MqServiceImpl.updateStateMode.null");
        }
    }

    private List<McMqserver> queryByIcode(Map<String, Object> map) {
        try {
            return this.mcMqserverMapper.queryByIcode(map);
        }
        catch (Exception e) {
            this.logger.error("mc.ESB.CHANNEL.MqServiceImpl.queryByIcode", (Throwable)e);
            return null;
        }
    }

    private BrokerBean createStartBean(McMqserver mcMqserver) {
        if (null == mcMqserver) {
            return null;
        }
        BrokerBean brokerBean = new BrokerBean();
        brokerBean.setBrokerName(mcMqserver.getMqserverName());
        brokerBean.setBrokerUrl(mcMqserver.getMqserverUrl());
        brokerBean.setConnectorPort(mcMqserver.getMqserverConnectport().intValue());
        brokerBean.setBrokerConfig(mcMqserver.getMqserverBrokerconfig());
        String extstr = mcMqserver.getMqserverConparam();
        if (StringUtils.isNotBlank((String)extstr)) {
            brokerBean.setExtParam((Map)JsonUtil.getAllJsonUtil().getJsonToMap(extstr, String.class, String.class));
        }
        if (1 == mcMqserver.getMqserverCreatecon()) {
            brokerBean.setCreateConnector(true);
        } else {
            brokerBean.setCreateConnector(false);
        }
        if (1 == mcMqserver.getMqserverCreatemb()) {
            brokerBean.setCreateMBeanServer(true);
        } else {
            brokerBean.setCreateMBeanServer(false);
        }
        if (1 == mcMqserver.getMqserverPer()) {
            brokerBean.setPersistent(true);
        } else {
            brokerBean.setPersistent(false);
        }
        if (1 == mcMqserver.getMqserverUserjmx()) {
            brokerBean.setUseJmx(true);
        } else {
            brokerBean.setUseJmx(false);
        }
        return brokerBean;
    }

    @Override
    public void queryLoadMqToInit() {
        this.info("mc.ESB.CHANNEL.MqServiceImpl.queryLoadMqToInit", "=====mqServerInt==start====");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", 1);
        List<McMqserver> mqLIst = this.queryByIcode(map);
        String cachekey = "McMqserver-start";
        if (null == mqLIst || mqLIst.isEmpty()) {
            DisUtil.delVer((String)cachekey);
            this.info("mc.ESB.CHANNEL.MqServiceImpl.queryLoadMqToInit", "=====mqServerInt==del==end====");
            return;
        }
        ArrayList<BrokerBean> brokerList = null;
        HashMap<String, ArrayList<BrokerBean>> brokerMap = new HashMap<String, ArrayList<BrokerBean>>();
        for (McMqserver mcMqserver : mqLIst) {
            if (StringUtils.isBlank((String)mcMqserver.getAppmanageAppkey())) {
                mcMqserver.setAppmanageAppkey(mcMqserver.getAppmanageIcode());
            }
            if (null == (brokerList = (ArrayList<BrokerBean>)brokerMap.get(mcMqserver.getAppmanageAppkey()))) {
                brokerList = new ArrayList<BrokerBean>();
                brokerMap.put(mcMqserver.getAppmanageAppkey(), brokerList);
            }
            brokerList.add(this.createStartBean(mcMqserver));
        }
        HashMap<String, String> cacheMap = new HashMap<String, String>();
        for (String key : brokerMap.keySet()) {
            cacheMap.put(key, JsonUtil.buildNormalBinder().toJson(brokerMap.get(key)));
        }
        DisUtil.setJsonVer((String)cachekey, cacheMap);
        this.info("mc.ESB.CHANNEL.MqServiceImpl.queryLoadMqToInit", "=====mqServerInt==end====");
    }

    @Override
    public void saveMcMqserver(McMqserverDomainBean mcMqserverDomainBean) throws ApiException {
        McMqserver mcMqserver = new McMqserver();
        String msg = this.check(mcMqserver = this.makeModel(mcMqserver, mcMqserverDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mc.ESB.CHANNEL.MqServiceImpl.saveMcMqserver.check", msg);
        }
        this.setInsertDefaultValue(mcMqserver);
        this.insertMqService(mcMqserver);
    }

    @Override
    public void updateMqserver(McMqserverDomainBean mcMqserverDomainBean) throws ApiException {
        McMqserver mcMqserver = this.getMqserver(mcMqserverDomainBean.getMqserverId());
        if (mcMqserver == null) {
            throw new ApiException("mc.ESB.CHANNEL.MqServiceImpl.updateMpermission.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(mcMqserver = this.makeModel(mcMqserver, mcMqserverDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mc.ESB.CHANNEL.MqServiceImpl.updateMqserver.check", msg);
        }
        this.setUpdateDefaultValue(mcMqserver);
        this.updateMqService(mcMqserver);
    }

    private McMqserver makeModel(McMqserver mcMqserver, McMqserverDomainBean mcMqserverDomainBean) {
        if (mcMqserverDomainBean == null) {
            return null;
        }
        if (mcMqserver == null) {
            mcMqserver = new McMqserver();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mcMqserver, (Object)mcMqserverDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mcMqserver;
    }

    @Override
    public void deleteMcMqserverById(Integer mqserverId) throws ApiException {
        this.deleteMq(mqserverId);
    }

    @Override
    public void updateMqState(Integer mqserverId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMode(mqserverId, dataState, oldDataState);
    }

    @Override
    public McMqserver getMqserver(Integer mqserverId) {
        return this.mcMqserverMapper.selectByPrimaryKey(mqserverId);
    }

    @Override
    public QueryResult<McMqserver> queryMcMqserverPage(Map<String, Object> map) {
        List<McMqserver> McMqserverList = this.queryMcMqserver(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMpermission(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(McMqserverList);
        return queryResult;
    }

    @Override
    public void updateMqserverState(Integer mqserverId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMqserver(mqserverId, dataState, oldDataState);
    }

    private void updateStateMqserver(Integer mqserverId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == mqserverId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mqserverId", mqserverId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mcMqserverMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mc.ESB.CHANNEL.MqServiceImpl.updateStateMqserver.ex");
        }
        if (i <= 0) {
            throw new ApiException("mc.ESB.CHANNEL.MqServiceImpl.updateStateMqserver.null");
        }
    }

    private int countMpermission(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mcMqserverMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mc.ESB.CHANNEL.MqServiceImpl.countMpermission", (Throwable)e);
        }
        return i;
    }

    private List<McMqserver> queryMcMqserver(Map<String, Object> parameters) {
        try {
            return this.mcMqserverMapper.query(parameters);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<McMqserver> queryMcMqserverList(Map<String, Object> map) {
        return this.queryMcMqserver(map);
    }
}

