/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.rest.dis.controller;

import com.yqbsoft.laser.service.esb.core.netty.ConnServerProperty;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.rest.controller.HttpSupper;
import com.yqbsoft.laser.service.esb.rest.controller.HttpUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.VfinOpenConstants;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/laserDis"})
public class DisHttpController
extends HttpSupper {
    private static final SupperLogUtil logger = new SupperLogUtil(DisHttpController.class);
    private static final String ROUTER_ERROR = "8";
    private static final long serialVersionUID = -3303989459344719626L;

    @RequestMapping(value={"/http/post/{icode}/{channelCode}/{memberCode}/{tenantCode}"}, method={RequestMethod.POST})
    public void execute(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="channelCode") String channelCode, @PathVariable(value="memberCode") String memberCode, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, channelCode, memberCode, tenantCode, resStream);
    }

    @RequestMapping(value={"/http/post/{icode}/{channelCode}/{tenantCode}"}, method={RequestMethod.POST})
    public void execute(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="channelCode") String channelCode, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, channelCode, "", tenantCode, resStream);
    }

    private void execl(HttpServletRequest request, HttpServletResponse response, String icode, String channelCode, String memberCode, String tenantCode, String resStream) {
        String routerDire = this.injectionRouterDire(icode);
        logger.info("\u6e20\u9053\u56de\u8c03\uff1apostData[" + JsonUtil.buildNormalBinder().toJson((Object)request.getParameterMap()) + "]stream:[" + resStream + "]");
        request.setAttribute("memberCode", (Object)memberCode);
        request.setAttribute("channelCode", (Object)channelCode);
        request.setAttribute(HttpUtil.BANK_TENANTCODE, (Object)tenantCode);
        request.setAttribute("method", (Object)"cmc.disOauth.updateToken");
        request.setAttribute("version", (Object)"1.0");
        this.invoke(request, response, routerDire);
    }

    @RequestMapping(value={"/http/get/{icode}/{channelCode}/{memberCode}/{tenantCode}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="channelCode") String channelCode, @PathVariable(value="memberCode") String memberCode, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, channelCode, memberCode, tenantCode, resStream);
    }

    @RequestMapping(value={"/http/get/{icode}/{channelCode}/{tenantCode}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="channelCode") String channelCode, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, channelCode, "", tenantCode, resStream);
    }

    private String injectionRouterDire(String icode) {
        if (StringUtils.isBlank((String)icode)) {
            return ROUTER_ERROR;
        }
        Map cspMap = LocalCache.getConnServerMap();
        if (MapUtil.isEmpty((Map)cspMap)) {
            return ROUTER_ERROR;
        }
        List cspList = (List)cspMap.get(VfinOpenConstants.SERVER_TYPE_HTTP);
        if (ListUtil.isEmpty((Collection)cspList)) {
            return ROUTER_ERROR;
        }
        for (ConnServerProperty connServerProperty : cspList) {
            if (!icode.equals(connServerProperty.getConnIcode())) continue;
            Integer routerDire = connServerProperty.getRouterDire();
            if (routerDire == null) {
                return ROUTER_ERROR;
            }
            return routerDire.toString();
        }
        return ROUTER_ERROR;
    }

    public Set<String> getIgnoreKey() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("app_id");
        keys.add("version");
        return keys;
    }
}

