/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.rest.intell.controller;

import com.yqbsoft.laser.service.esb.core.SysException;
import com.yqbsoft.laser.service.esb.core.netty.ConnServerProperty;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.rest.controller.HttpSupper;
import com.yqbsoft.laser.service.tool.VfinOpenConstants;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/laserIntell"})
public class IntellHttpController
extends HttpSupper {
    private static final String ROUTER_ERROR = "-1";
    private static final long serialVersionUID = -3303989459344719626L;

    @RequestMapping(value={"/http/post/{icode}"}, method={RequestMethod.POST})
    public void execute(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode) {
        String routerDire = this.injectionRouterDire(icode);
        if (routerDire == null || ROUTER_ERROR == routerDire) {
            throw new SysException("\u975e\u6cd5\u8bf7\u6c42\uff01");
        }
        this.invoke(request, response, routerDire);
    }

    @RequestMapping(value={"/http/get/{icode}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode) {
        String routerDire = this.injectionRouterDire(icode);
        if (routerDire == null || ROUTER_ERROR == routerDire) {
            throw new SysException("\u975e\u6cd5\u8bf7\u6c42\uff01");
        }
        this.invoke(request, response, routerDire);
    }

    private String injectionRouterDire(String icode) {
        if (StringUtils.isBlank((String)icode)) {
            return ROUTER_ERROR;
        }
        Map cspMap = LocalCache.getConnServerMap();
        if (MapUtil.isEmpty((Map)cspMap)) {
            return ROUTER_ERROR;
        }
        List cspList = (List)cspMap.get(VfinOpenConstants.SERVER_TYPE_HTTP);
        if (ListUtil.isEmpty((Collection)cspList)) {
            return ROUTER_ERROR;
        }
        for (ConnServerProperty connServerProperty : cspList) {
            if (!icode.equals(connServerProperty.getConnIcode())) continue;
            Integer routerDire = connServerProperty.getRouterDire();
            if (routerDire == null) {
                return ROUTER_ERROR;
            }
            return routerDire.toString();
        }
        return ROUTER_ERROR;
    }
}

