/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.evaluate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.evaluate.dao.ResEvaluateAddMapper;
import com.yqbsoft.laser.service.evaluate.dao.ResEvaluateGoodsMapper;
import com.yqbsoft.laser.service.evaluate.dao.ResEvaluateScopeMapper;
import com.yqbsoft.laser.service.evaluate.dao.ResEvaluateShopMapper;
import com.yqbsoft.laser.service.evaluate.domain.ResEvaluateAddDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResEvaluateGoodsDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResEvaluateGoodsReDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResEvaluateScopeDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResEvaluateScopeReDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResEvaluateShopDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResEvaluateShopReDomain;
import com.yqbsoft.laser.service.evaluate.model.ResEvaluateAdd;
import com.yqbsoft.laser.service.evaluate.model.ResEvaluateGoods;
import com.yqbsoft.laser.service.evaluate.model.ResEvaluateScope;
import com.yqbsoft.laser.service.evaluate.model.ResEvaluateShop;
import com.yqbsoft.laser.service.evaluate.service.ResEvaluateService;
import com.yqbsoft.laser.service.suppercore.SupperApiException;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResEvaluateServiceImpl
extends BaseServiceImpl
implements ResEvaluateService {
    private static final String SYS_CODE = "res.ResEvaluateServiceImpl";
    private ResEvaluateShopMapper resEvaluateShopMapper;
    private ResEvaluateGoodsMapper resEvaluateGoodsMapper;
    private ResEvaluateAddMapper resEvaluateAddMapper;
    private ResEvaluateScopeMapper resEvaluateScopeMapper;

    public void setResEvaluateShopMapper(ResEvaluateShopMapper resEvaluateShopMapper) {
        this.resEvaluateShopMapper = resEvaluateShopMapper;
    }

    public void setResEvaluateGoodsMapper(ResEvaluateGoodsMapper resEvaluateGoodsMapper) {
        this.resEvaluateGoodsMapper = resEvaluateGoodsMapper;
    }

    public void setResEvaluateAddMapper(ResEvaluateAddMapper resEvaluateAddMapper) {
        this.resEvaluateAddMapper = resEvaluateAddMapper;
    }

    public void setResEvaluateScopeMapper(ResEvaluateScopeMapper resEvaluateScopeMapper) {
        this.resEvaluateScopeMapper = resEvaluateScopeMapper;
    }

    private Date getSysDate() {
        try {
            return this.resEvaluateShopMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkEvaluateShop(ResEvaluateShopDomain resEvaluateShopDomain) {
        if (null == resEvaluateShopDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)resEvaluateShopDomain.getContractBillcode())) {
            msg = msg + "contractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateShopDomain.getMemberBcode())) {
            msg = msg + "memberBcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateShopDomain.getMemberBname())) {
            msg = msg + "memberBname\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateShopDomain.getMemberCode())) {
            msg = msg + "memberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateShopDomain.getMemberName())) {
            msg = msg + "memberName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateShopDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setEvaluateShopDefault(ResEvaluateShop resEvaluateShop) {
        if (null == resEvaluateShop) {
            return;
        }
        if (null == resEvaluateShop.getDataState()) {
            resEvaluateShop.setDataState(0);
        }
        if (null == resEvaluateShop.getGmtCreate()) {
            resEvaluateShop.setGmtCreate(this.getSysDate());
        }
        resEvaluateShop.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)resEvaluateShop.getEvaluateShopCode())) {
            resEvaluateShop.setEvaluateShopCode(this.createUUIDString());
        }
        if (resEvaluateShop.getEvaluateShopShow() == null) {
            resEvaluateShop.setEvaluateShopShow(true);
        }
    }

    private int getEvaluateShopMaxCode() {
        int code = 0;
        try {
            return this.resEvaluateShopMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateShopMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setEvaluateShopUpdataDefault(ResEvaluateShop resEvaluateShop) {
        if (null == resEvaluateShop) {
            return;
        }
        resEvaluateShop.setGmtModified(this.getSysDate());
    }

    private void saveEvaluateShopModel(ResEvaluateShop resEvaluateShop) throws ApiException {
        if (null == resEvaluateShop) {
            return;
        }
        this.resEvaluateShopMapper.insert(resEvaluateShop);
    }

    private ResEvaluateShop getEvaluateShopModelById(Integer evaluateShopId) {
        if (null == evaluateShopId) {
            return null;
        }
        try {
            return this.resEvaluateShopMapper.selectByPrimaryKey(evaluateShopId);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateShopModelById", (Throwable)e);
            return null;
        }
    }

    private ResEvaluateShop getEvaluateShopModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.resEvaluateShopMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateShopModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delEvaluateShopModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.resEvaluateShopMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.delEvaluateShopModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResEvaluateServiceImpl.delEvaluateShopModelByCode.num");
        }
    }

    private void deleteEvaluateShopModel(Integer evaluateShopId) throws ApiException {
        if (null == evaluateShopId) {
            return;
        }
        int i = 0;
        try {
            i = this.resEvaluateShopMapper.deleteByPrimaryKey(evaluateShopId);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.deleteEvaluateShopModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResEvaluateServiceImpl.deleteEvaluateShopModel.num");
        }
    }

    private void updateEvaluateShopModel(ResEvaluateShop resEvaluateShop) throws ApiException {
        if (null == resEvaluateShop) {
            return;
        }
        int i = 0;
        try {
            i = this.resEvaluateShopMapper.updateByPrimaryKeySelective(resEvaluateShop);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateShopModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateShopModel.num");
        }
    }

    private void updateStateEvaluateShopModel(Integer evaluateShopId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == evaluateShopId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("evaluateShopId", evaluateShopId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.resEvaluateShopMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateStateEvaluateShopModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateStateEvaluateShopModel.null");
        }
    }

    private ResEvaluateShop makeEvaluateShop(ResEvaluateShopDomain resEvaluateShopDomain, ResEvaluateShop resEvaluateShop) {
        if (null == resEvaluateShopDomain) {
            return null;
        }
        if (null == resEvaluateShop) {
            resEvaluateShop = new ResEvaluateShop();
        }
        try {
            BeanUtils.copyAllPropertys((Object)resEvaluateShop, (Object)resEvaluateShopDomain);
            return resEvaluateShop;
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.makeEvaluateShop", (Throwable)e);
            return null;
        }
    }

    private List<ResEvaluateShop> queryEvaluateShopModelPage(Map<String, Object> parammap) {
        try {
            return this.resEvaluateShopMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.queryEvaluateShopModel", (Throwable)e);
            return null;
        }
    }

    private int countEvaluateShop(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.resEvaluateShopMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.countEvaluateShop", (Throwable)e);
        }
        return i;
    }

    private String checkEvaluateGoods(ResEvaluateGoodsDomain resEvaluateGoodsDomain) {
        if (null == resEvaluateGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)resEvaluateGoodsDomain.getGoodsCode())) {
            msg = msg + "goodsCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateGoodsDomain.getGoodsName())) {
            msg = msg + "goodsName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateGoodsDomain.getContractBillcode())) {
            msg = msg + "contractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateGoodsDomain.getMemberBcode())) {
            msg = msg + "memberBcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateGoodsDomain.getMemberBname())) {
            msg = msg + "memberBname\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateGoodsDomain.getSkuCode())) {
            msg = msg + "skuCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateGoodsDomain.getEvaluateGoodsContent())) {
            msg = msg + "EvaluateGoodsContent\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setEvaluateGoodsDefault(ResEvaluateGoods resEvaluateGoods) {
        if (null == resEvaluateGoods) {
            return;
        }
        if (null == resEvaluateGoods.getDataState()) {
            resEvaluateGoods.setDataState(0);
        }
        if (null == resEvaluateGoods.getGmtCreate()) {
            resEvaluateGoods.setGmtCreate(this.getSysDate());
        }
        resEvaluateGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)resEvaluateGoods.getEvaluateGoodsCode())) {
            resEvaluateGoods.setEvaluateGoodsCode(this.createUUIDString());
        }
        if (resEvaluateGoods.getEvaluateGoodsShow().booleanValue()) {
            resEvaluateGoods.setEvaluateGoodsShow(true);
        }
    }

    private int getEvaluateGoodsMaxCode() {
        int code = 0;
        try {
            return this.resEvaluateGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setEvaluateGoodsUpdataDefault(ResEvaluateGoods resEvaluateGoods) {
        if (null == resEvaluateGoods) {
            return;
        }
        resEvaluateGoods.setGmtModified(this.getSysDate());
    }

    private void saveEvaluateGoodsModel(ResEvaluateGoods resEvaluateGoods) throws ApiException {
        if (null == resEvaluateGoods) {
            return;
        }
        try {
            this.resEvaluateGoodsMapper.insert(resEvaluateGoods);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateGoodsModel.ex", (Throwable)e);
        }
    }

    private ResEvaluateGoods getEvaluateGoodsModelById(Integer evaluateGoodsId) {
        if (null == evaluateGoodsId) {
            return null;
        }
        try {
            return this.resEvaluateGoodsMapper.selectByPrimaryKey(evaluateGoodsId);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private ResEvaluateGoods getEvaluateGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.resEvaluateGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delEvaluateGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.resEvaluateGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.delEvaluateGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResEvaluateServiceImpl.delEvaluateGoodsModelByCode.num");
        }
    }

    private void deleteEvaluateGoodsModel(Integer evaluateGoodsId) throws ApiException {
        if (null == evaluateGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.resEvaluateGoodsMapper.deleteByPrimaryKey(evaluateGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.deleteEvaluateGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResEvaluateServiceImpl.deleteEvaluateGoodsModel.num");
        }
    }

    private void updateEvaluateGoodsModel(ResEvaluateGoods resEvaluateGoods) throws ApiException {
        if (null == resEvaluateGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.resEvaluateGoodsMapper.updateByPrimaryKeySelective(resEvaluateGoods);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateGoodsModel.num");
        }
    }

    private void updateStateEvaluateGoodsModel(Integer evaluateGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == evaluateGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("evaluateGoodsId", evaluateGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.resEvaluateGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateStateEvaluateGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateStateEvaluateGoodsModel.null");
        }
    }

    private ResEvaluateGoods makeEvaluateGoods(ResEvaluateGoodsDomain resEvaluateGoodsDomain, ResEvaluateGoods resEvaluateGoods) {
        if (null == resEvaluateGoodsDomain) {
            return null;
        }
        if (null == resEvaluateGoods) {
            resEvaluateGoods = new ResEvaluateGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)resEvaluateGoods, (Object)resEvaluateGoodsDomain);
            return resEvaluateGoods;
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.makeEvaluateGoods", (Throwable)e);
            return null;
        }
    }

    private List<ResEvaluateGoods> queryEvaluateGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.resEvaluateGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.queryEvaluateGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countEvaluateGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.resEvaluateGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.countEvaluateGoods", (Throwable)e);
        }
        return i;
    }

    private String checkEvaluateAdd(ResEvaluateAddDomain resEvaluateAddDomain) {
        if (null == resEvaluateAddDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)resEvaluateAddDomain.getEvaluateAddContent())) {
            msg = msg + "evaluateAddContent\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateAddDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setEvaluateAddDefault(ResEvaluateAdd resEvaluateAdd) {
        if (null == resEvaluateAdd) {
            return;
        }
        if (null == resEvaluateAdd.getDataState()) {
            resEvaluateAdd.setDataState(0);
        }
        if (null == resEvaluateAdd.getGmtCreate()) {
            resEvaluateAdd.setGmtCreate(this.getSysDate());
        }
        resEvaluateAdd.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)resEvaluateAdd.getEvaluateAddCode())) {
            resEvaluateAdd.setEvaluateAddCode(this.createUUIDString());
        }
    }

    private int getEvaluateAddMaxCode() {
        int code = 0;
        try {
            return this.resEvaluateAddMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateAddMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setEvaluateAddUpdataDefault(ResEvaluateAdd resEvaluateAdd) {
        if (null == resEvaluateAdd) {
            return;
        }
        resEvaluateAdd.setGmtModified(this.getSysDate());
    }

    private void saveEvaluateAddModel(ResEvaluateAdd resEvaluateAdd) throws ApiException {
        if (null == resEvaluateAdd) {
            return;
        }
        try {
            this.resEvaluateAddMapper.insert(resEvaluateAdd);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateAddModel.ex", (Throwable)e);
        }
    }

    private ResEvaluateAdd getEvaluateAddModelById(Integer evaluateAddId) {
        if (null == evaluateAddId) {
            return null;
        }
        try {
            return this.resEvaluateAddMapper.selectByPrimaryKey(evaluateAddId);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateAddModelById", (Throwable)e);
            return null;
        }
    }

    private ResEvaluateAdd getEvaluateAddModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.resEvaluateAddMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateAddModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delEvaluateAddModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.resEvaluateAddMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.delEvaluateAddModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResEvaluateServiceImpl.delEvaluateAddModelByCode.num");
        }
    }

    private void deleteEvaluateAddModel(Integer evaluateAddId) throws ApiException {
        if (null == evaluateAddId) {
            return;
        }
        int i = 0;
        try {
            i = this.resEvaluateAddMapper.deleteByPrimaryKey(evaluateAddId);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.deleteEvaluateAddModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResEvaluateServiceImpl.deleteEvaluateAddModel.num");
        }
    }

    private void updateEvaluateAddModel(ResEvaluateAdd resEvaluateAdd) throws ApiException {
        if (null == resEvaluateAdd) {
            return;
        }
        int i = 0;
        try {
            i = this.resEvaluateAddMapper.updateByPrimaryKeySelective(resEvaluateAdd);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateAddModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateAddModel.num");
        }
    }

    private void updateStateEvaluateAddModel(Integer evaluateAddId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == evaluateAddId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("evaluateAddId", evaluateAddId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.resEvaluateAddMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateStateEvaluateAddModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateStateEvaluateAddModel.null");
        }
    }

    private ResEvaluateAdd makeEvaluateAdd(ResEvaluateAddDomain resEvaluateAddDomain, ResEvaluateAdd resEvaluateAdd) {
        if (null == resEvaluateAddDomain) {
            return null;
        }
        if (null == resEvaluateAdd) {
            resEvaluateAdd = new ResEvaluateAdd();
        }
        try {
            BeanUtils.copyAllPropertys((Object)resEvaluateAdd, (Object)resEvaluateAddDomain);
            return resEvaluateAdd;
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.makeEvaluateAdd", (Throwable)e);
            return null;
        }
    }

    private List<ResEvaluateAdd> queryEvaluateAddModelPage(Map<String, Object> parammap) {
        try {
            return this.resEvaluateAddMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.queryEvaluateAddModel", (Throwable)e);
            return null;
        }
    }

    private int countEvaluateAdd(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.resEvaluateAddMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.countEvaluateAdd", (Throwable)e);
        }
        return i;
    }

    private String checkEvaluateScope(ResEvaluateScopeDomain resEvaluateScopeDomain) {
        if (null == resEvaluateScopeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)resEvaluateScopeDomain.getTemplateType())) {
            msg = msg + "templateType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateScopeDomain.getEvaluateSgCode())) {
            msg = msg + "evaluateSgCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateScopeDomain.getTemplateCode())) {
            msg = msg + "templateCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateScopeDomain.getTemplateTitle())) {
            msg = msg + "templateTitle\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateScopeDomain.getTemplateContentType())) {
            msg = msg + "templateContentType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateScopeDomain.getEvaluateScopeValue())) {
            msg = msg + "evaluateScopeValue\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resEvaluateScopeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setEvaluateScopeDefault(ResEvaluateScope resEvaluateScope) {
        if (null == resEvaluateScope) {
            return;
        }
        if (null == resEvaluateScope.getDataState()) {
            resEvaluateScope.setDataState(0);
        }
        if (null == resEvaluateScope.getGmtCreate()) {
            resEvaluateScope.setGmtCreate(this.getSysDate());
        }
        resEvaluateScope.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)resEvaluateScope.getEvaluateScopeCode())) {
            resEvaluateScope.setEvaluateScopeCode(this.createUUIDString());
        }
    }

    private int getEvaluateScopeMaxCode() {
        int code = 0;
        try {
            return this.resEvaluateScopeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateScopeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setEvaluateScopeUpdataDefault(ResEvaluateScope resEvaluateScope) {
        if (null == resEvaluateScope) {
            return;
        }
        resEvaluateScope.setGmtModified(this.getSysDate());
    }

    private void saveEvaluateScopeModel(ResEvaluateScope resEvaluateScope) throws ApiException {
        if (null == resEvaluateScope) {
            return;
        }
        try {
            this.resEvaluateScopeMapper.insert(resEvaluateScope);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateScopeModel.ex", (Throwable)e);
        }
    }

    private ResEvaluateScope getEvaluateScopeModelById(Integer evaluateScopeId) {
        if (null == evaluateScopeId) {
            return null;
        }
        try {
            return this.resEvaluateScopeMapper.selectByPrimaryKey(evaluateScopeId);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateScopeModelById", (Throwable)e);
            return null;
        }
    }

    private ResEvaluateScope getEvaluateScopeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.resEvaluateScopeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateScopeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delEvaluateScopeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.resEvaluateScopeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.delEvaluateScopeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResEvaluateServiceImpl.delEvaluateScopeModelByCode.num");
        }
    }

    private void deleteEvaluateScopeModel(Integer evaluateScopeId) throws ApiException {
        if (null == evaluateScopeId) {
            return;
        }
        int i = 0;
        try {
            i = this.resEvaluateScopeMapper.deleteByPrimaryKey(evaluateScopeId);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.deleteEvaluateScopeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResEvaluateServiceImpl.deleteEvaluateScopeModel.num");
        }
    }

    private void updateEvaluateScopeModel(ResEvaluateScope resEvaluateScope) throws ApiException {
        if (null == resEvaluateScope) {
            return;
        }
        int i = 0;
        try {
            i = this.resEvaluateScopeMapper.updateByPrimaryKeySelective(resEvaluateScope);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateScopeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateScopeModel.num");
        }
    }

    private void updateStateEvaluateScopeModel(Integer evaluateScopeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == evaluateScopeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("evaluateScopeId", evaluateScopeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.resEvaluateScopeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateStateEvaluateScopeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateStateEvaluateScopeModel.null");
        }
    }

    private ResEvaluateScope makeEvaluateScope(ResEvaluateScopeDomain resEvaluateScopeDomain, ResEvaluateScope resEvaluateScope) {
        if (null == resEvaluateScopeDomain) {
            return null;
        }
        if (null == resEvaluateScope) {
            resEvaluateScope = new ResEvaluateScope();
        }
        try {
            BeanUtils.copyAllPropertys((Object)resEvaluateScope, (Object)resEvaluateScopeDomain);
            return resEvaluateScope;
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.makeEvaluateScope", (Throwable)e);
            return null;
        }
    }

    private List<ResEvaluateScope> queryEvaluateScopeModelPage(Map<String, Object> parammap) {
        try {
            return this.resEvaluateScopeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.queryEvaluateScopeModel", (Throwable)e);
            return null;
        }
    }

    private int countEvaluateScope(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.resEvaluateScopeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.countEvaluateScope", (Throwable)e);
        }
        return i;
    }

    private ResEvaluateScope createEvaluateScope(ResEvaluateScopeDomain evaluateScopeDomain) {
        ResEvaluateScope evaluateScope = this.makeEvaluateScope(evaluateScopeDomain, null);
        this.setEvaluateScopeDefault(evaluateScope);
        return evaluateScope;
    }

    private void saveEvaluateScopeBatchModel(List<ResEvaluateScope> resEvaluateScopeList) {
        if (resEvaluateScopeList == null || resEvaluateScopeList.isEmpty()) {
            return;
        }
        try {
            this.resEvaluateScopeMapper.insertBatch(resEvaluateScopeList);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateScopeBarchModel.ex", (Throwable)e);
        }
    }

    private void saveEvaluateScopeList(List<ResEvaluateScopeDomain> evaluateScopeDomainList, String evaluateCode, String templateType) {
        if (evaluateScopeDomainList == null || evaluateScopeDomainList.isEmpty()) {
            return;
        }
        ArrayList<ResEvaluateScope> scopeList = new ArrayList<ResEvaluateScope>();
        for (ResEvaluateScopeDomain scopeDomain : evaluateScopeDomainList) {
            scopeDomain.setEvaluateSgCode(evaluateCode);
            scopeDomain.setTemplateType(templateType);
            String msg = this.checkEvaluateScope(scopeDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateScopeList." + evaluateCode, msg);
            }
            if ("txt".equals(scopeDomain.getTemplateContentType()) || "img".equals(scopeDomain.getTemplateContentType())) continue;
            if ("txt".equals(scopeDomain.getTemplateContentType())) {
                scopeDomain.setEvaluateScopeValue(this.replaceSensitiveword(scopeDomain.getEvaluateScopeValue()));
            }
            ResEvaluateScope evaluateScope = this.createEvaluateScope(scopeDomain);
            this.setEvaluateScopeDefault(evaluateScope);
            scopeList.add(evaluateScope);
        }
        this.saveEvaluateScopeBatchModel(scopeList);
    }

    private String replaceSensitiveword(String content) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", null);
        paramMap.put("checkWords", content);
        paramMap.put("replaceWords", "***");
        HashMap result = (HashMap)super.getInternalRouter().inInvoke("sw.swSensitiveword.checkSensitiveword", paramMap);
        return (String)result.get("checkwords");
    }

    private void upShopShow(Integer evaluateShopId, Boolean show) {
        int i = 0;
        try {
            ResEvaluateShop shop = new ResEvaluateShop();
            shop.setEvaluateShopId(evaluateShopId);
            shop.setEvaluateShopShow(show);
            i = this.resEvaluateShopMapper.updateByPrimaryKeySelective(shop);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.upShopShow.ex", (Throwable)e);
        }
        if (i == 0) {
            throw new ApiException("res.ResEvaluateServiceImpl.upShopShow.num");
        }
    }

    private void asyncUpdateScoresShop(String evaluateShopCode) {
        if (StringUtils.isBlank((String)evaluateShopCode)) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("evaluateShopCode", evaluateShopCode);
        try {
            this.getInternalRouter().inAsyncInvoke("res.resScore.updateScoresGoods", "1.0", "0", paramMap);
        }
        catch (SupperApiException e) {
            this.logger.error("res.ResEvaluateServiceImpl.asyncUpdateScoresShop.ex", (Throwable)e);
        }
    }

    private void asyncUpdateScoresGoods(String evaluateGoodsCode) {
        if (StringUtils.isBlank((String)evaluateGoodsCode)) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("evaluateGoodsCode", evaluateGoodsCode);
        try {
            this.getInternalRouter().inAsyncInvoke("res.resScore.updateScoresGoods", "1.0", "0", paramMap);
        }
        catch (SupperApiException e) {
            this.logger.error("res.ResEvaluateServiceImpl.asyncUpdateScoresGoods.ex", (Throwable)e);
        }
    }

    private ResEvaluateGoodsReDomain makeEvaluateGoodsReDomain(ResEvaluateGoods resEvaluateGoods) {
        ResEvaluateGoodsReDomain evaluateGoodsReDomain = new ResEvaluateGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)evaluateGoodsReDomain, (Object)resEvaluateGoods);
            return evaluateGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.makeEvaluateGoodsReDomain.ex", (Throwable)e);
            return null;
        }
    }

    private List<ResEvaluateGoodsReDomain> makeEvaluateGoodsReDomainList(List<ResEvaluateGoods> resEvaluateGoodsList) {
        if (ListUtil.isEmpty(resEvaluateGoodsList)) {
            return null;
        }
        ArrayList<ResEvaluateGoodsReDomain> goodsReDomainList = new ArrayList<ResEvaluateGoodsReDomain>();
        for (ResEvaluateGoods resEvaluateGoods : resEvaluateGoodsList) {
            ResEvaluateGoodsReDomain goodsReDomain = this.makeEvaluateGoodsReDomain(resEvaluateGoods);
            if (goodsReDomain == null) continue;
            goodsReDomain.setEvaluateScopeList(this.makeEvaluateScopeReDomainList(this.queryScopeListBySGCode(goodsReDomain.getEvaluateGoodsCode(), "txt")));
            goodsReDomainList.add(goodsReDomain);
        }
        return goodsReDomainList;
    }

    @Override
    public String saveEvaluateShop(ResEvaluateShopDomain resEvaluateShopDomain, List<ResEvaluateScopeDomain> resEvaluateScopeDomainList) throws ApiException {
        String msg = this.checkEvaluateShop(resEvaluateShopDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateShop.checkEvaluateShop", msg);
        }
        if (ListUtil.isEmpty(resEvaluateScopeDomainList)) {
            throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateShop.resEvaluateScopeDomainList", "\u8bc4\u5206\u9879\u4e3a\u7a7a");
        }
        msg = this.checkCanEvaluate(resEvaluateShopDomain.getContractBillcode(), resEvaluateShopDomain.getMemberCode(), "shop");
        if (msg != null) {
            throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateGoods.checkCanEvaluate", msg);
        }
        resEvaluateShopDomain.setEvaluateShopContent(this.replaceSensitiveword(resEvaluateShopDomain.getEvaluateShopContent()));
        ResEvaluateShop resEvaluateShop = this.makeEvaluateShop(resEvaluateShopDomain, null);
        this.setEvaluateShopDefault(resEvaluateShop);
        this.saveEvaluateShopModel(resEvaluateShop);
        this.saveEvaluateScopeList(resEvaluateScopeDomainList, resEvaluateShop.getEvaluateShopCode(), "shop");
        this.asyncUpdateScoresShop(resEvaluateShop.getEvaluateShopCode());
        return resEvaluateShop.getEvaluateShopCode();
    }

    @Override
    public void updateEvaluateShopState(Integer evaluateShopId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateEvaluateShopModel(evaluateShopId, dataState, oldDataState);
    }

    @Override
    public void updateEvaluateShop(ResEvaluateShopDomain resEvaluateShopDomain) throws ApiException {
        String msg = this.checkEvaluateShop(resEvaluateShopDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateShop.checkEvaluateShop", msg);
        }
        ResEvaluateShop oldResEvaluateShop = this.getEvaluateShopModelById(resEvaluateShopDomain.getEvaluateShopId());
        if (null == oldResEvaluateShop) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateShop.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ResEvaluateShop resEvaluateShop = this.makeEvaluateShop(resEvaluateShopDomain, oldResEvaluateShop);
        this.setEvaluateShopUpdataDefault(resEvaluateShop);
        this.updateEvaluateShopModel(resEvaluateShop);
    }

    private List<ResEvaluateScopeReDomain> makeEvaluateScopeReDomainList(List<ResEvaluateScope> evaluateScopeList) {
        if (ListUtil.isEmpty(evaluateScopeList)) {
            return null;
        }
        try {
            ArrayList<ResEvaluateScopeReDomain> scopeReDomainList = new ArrayList<ResEvaluateScopeReDomain>();
            for (ResEvaluateScope scope : evaluateScopeList) {
                ResEvaluateScopeReDomain scopeReDomain = new ResEvaluateScopeReDomain();
                BeanUtils.copyAllPropertys((Object)scopeReDomain, (Object)scope);
                if (scopeReDomain == null) continue;
                scopeReDomainList.add(scopeReDomain);
            }
            return scopeReDomainList;
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.makeEvaluateScopeReDomain.ex", (Throwable)e);
            return null;
        }
    }

    private ResEvaluateShopReDomain makeShopReDomain(ResEvaluateShop evaluateShop, String templateContentType) {
        String SYS_CODE_M = "res.ResEvaluateServiceImpl.makeShopReDomain.";
        if (evaluateShop == null) {
            return null;
        }
        ResEvaluateShopReDomain reDomain = new ResEvaluateShopReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)reDomain, (Object)evaluateShop);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.makeShopReDomain.ex", (Throwable)e);
            return null;
        }
        reDomain.setEvaluateScopeReList(this.makeEvaluateScopeReDomainList(this.queryScopeListBySGCode(reDomain.getEvaluateShopCode(), templateContentType)));
        return reDomain;
    }

    @Override
    public ResEvaluateShopReDomain getEvaluateShop(Integer evaluateShopId) {
        return this.makeShopReDomain(this.getEvaluateShopModelById(evaluateShopId), null);
    }

    @Override
    public void deleteEvaluateShop(Integer evaluateShopId) throws ApiException {
        this.deleteEvaluateShopModel(evaluateShopId);
    }

    @Override
    public QueryResult<ResEvaluateShop> queryEvaluateShopPage(Map<String, Object> map) {
        List<ResEvaluateShop> resEvaluateShopList = this.queryEvaluateShopModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countEvaluateShop(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(resEvaluateShopList);
        return queryResult;
    }

    @Override
    public ResEvaluateShopReDomain getEvaluateShopByCode(Map<String, Object> map) {
        return this.makeShopReDomain(this.getEvaluateShopModelByCode(map), null);
    }

    @Override
    public void deleteEvaluateShopByCode(Map<String, Object> map) throws ApiException {
        this.delEvaluateShopModelByCode(map);
    }

    private List<ResEvaluateScope> queryScopeListBySGCode(String sgCode, String templateContentType) {
        try {
            HashMap<String, Object> scopeParMap = new HashMap<String, Object>();
            scopeParMap.put("evaluateSgCode", sgCode);
            if (StringUtils.isNotBlank((String)templateContentType)) {
                scopeParMap.put("templateContentType", templateContentType);
            }
            return this.resEvaluateScopeMapper.query(scopeParMap);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.queryScopeListBySGCode.ex", "\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
    }

    @Override
    public ResEvaluateShopReDomain getEvaluateShopByOrderCode(String contractBillcode) {
        try {
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            parammap.put("contractBillcode", contractBillcode);
            List<ResEvaluateShop> shopList = this.queryEvaluateShopModelPage(parammap);
            if (shopList.isEmpty()) {
                return null;
            }
            return this.makeShopReDomain(shopList.get(0), null);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateShopByOrderCode.ex", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateShopShow(Integer evaluateShopId, Boolean show) {
        this.upShopShow(evaluateShopId, show);
    }

    @Override
    public String checkCanEvaluate(String orderCode, String sgCode, String type) {
        int count;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", orderCode);
        if ("shop".equals(type)) {
            map.put("memberCode", sgCode);
            count = this.countEvaluateShop(map);
        } else if ("goods".equals(type)) {
            map.put("contractGoodsCode", sgCode);
            count = this.countEvaluateGoods(map);
        } else {
            return "\u7c7b\u578b\u53c2\u6570\u6709\u8bef";
        }
        if (count > 0) {
            return "\u5df2\u8bc4\u4ef7\uff0c\u4e0d\u53ef\u91cd\u590d\u8bc4\u4ef7";
        }
        return null;
    }

    private void upGoodsShow(Integer evaluateGoodsId, Boolean show) {
        if (show == null) {
            throw new ApiException("res.ResEvaluateServiceImpl.upGoodsShow.show.null", "\u53c2\u6570\u6709\u8bef");
        }
        int i = 0;
        try {
            ResEvaluateGoods goods = new ResEvaluateGoods();
            goods.setEvaluateGoodsId(evaluateGoodsId);
            goods.setEvaluateGoodsShow(show);
            i = this.resEvaluateGoodsMapper.updateByPrimaryKeySelective(goods);
        }
        catch (Exception e) {
            throw new ApiException("res.ResEvaluateServiceImpl.upGoodsShow.ex", (Throwable)e);
        }
        if (i == 0) {
            throw new ApiException("res.ResEvaluateServiceImpl.upGoodsShow.num");
        }
    }

    @Override
    public String saveEvaluateGoods(ResEvaluateGoodsDomain resEvaluateGoodsDomain, List<ResEvaluateScopeDomain> resEvaluateScopeDomainList) throws ApiException {
        String msg = this.checkEvaluateGoods(resEvaluateGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateGoods.checkEvaluateGoods", msg);
        }
        if (ListUtil.isEmpty(resEvaluateScopeDomainList)) {
            throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateGoods.resEvaluateScopeDomainList", "\u8bc4\u5206\u9879\u4e3a\u7a7a");
        }
        msg = this.checkCanEvaluate(resEvaluateGoodsDomain.getContractBillcode(), resEvaluateGoodsDomain.getGoodsCode(), "goods");
        if (msg != null) {
            throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateGoods.checkCanEvaluate", msg);
        }
        resEvaluateGoodsDomain.setEvaluateGoodsContent(this.replaceSensitiveword(resEvaluateGoodsDomain.getEvaluateGoodsContent()));
        ResEvaluateGoods resEvaluateGoods = this.makeEvaluateGoods(resEvaluateGoodsDomain, null);
        this.setEvaluateGoodsDefault(resEvaluateGoods);
        this.saveEvaluateGoodsModel(resEvaluateGoods);
        this.saveEvaluateScopeList(resEvaluateScopeDomainList, resEvaluateGoods.getEvaluateGoodsCode(), "goods");
        this.asyncUpdateScoresGoods(resEvaluateGoods.getEvaluateGoodsCode());
        return resEvaluateGoods.getEvaluateGoodsCode();
    }

    @Override
    public void updateEvaluateGoodsState(Integer evaluateGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateEvaluateGoodsModel(evaluateGoodsId, dataState, oldDataState);
    }

    @Override
    public void updateEvaluateGoods(ResEvaluateGoodsDomain resEvaluateGoodsDomain) throws ApiException {
        String msg = this.checkEvaluateGoods(resEvaluateGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateGoods.checkEvaluateGoods", msg);
        }
        ResEvaluateGoods oldResEvaluateGoods = this.getEvaluateGoodsModelById(resEvaluateGoodsDomain.getEvaluateGoodsId());
        if (null == oldResEvaluateGoods) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ResEvaluateGoods resEvaluateGoods = this.makeEvaluateGoods(resEvaluateGoodsDomain, oldResEvaluateGoods);
        this.setEvaluateGoodsUpdataDefault(resEvaluateGoods);
        this.updateEvaluateGoodsModel(resEvaluateGoods);
    }

    private List<ResEvaluateScopeReDomain> makeScopeReDomainList(String sgcode, String templateContentType) {
        List<ResEvaluateScope> evaluateScopeList = this.queryScopeListBySGCode(sgcode, templateContentType);
        if (ListUtil.isEmpty(evaluateScopeList)) {
            return null;
        }
        return this.makeEvaluateScopeReDomainList(evaluateScopeList);
    }

    @Override
    public ResEvaluateGoodsReDomain getEvaluateGoods(Integer evaluateGoodsId) {
        ResEvaluateGoods evaluateGoods = this.getEvaluateGoodsModelById(evaluateGoodsId);
        ResEvaluateGoodsReDomain evaluateGoodsReDomain = new ResEvaluateGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)evaluateGoodsReDomain, (Object)evaluateGoods);
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.getEvaluateGoods.ex", (Throwable)e);
            return null;
        }
        evaluateGoodsReDomain.setEvaluateScopeList(this.makeScopeReDomainList(evaluateGoods.getEvaluateGoodsCode(), null));
        return evaluateGoodsReDomain;
    }

    @Override
    public void deleteEvaluateGoods(Integer evaluateGoodsId) throws ApiException {
        this.deleteEvaluateGoodsModel(evaluateGoodsId);
    }

    @Override
    public QueryResult<ResEvaluateGoodsReDomain> queryEvaluateGoodsPage(Map<String, Object> map) {
        int count = this.countEvaluateGoods(map);
        List<Object> resEvaluateGoodsList = count > 0 ? this.makeEvaluateGoodsReDomainList(this.queryEvaluateGoodsModelPage(map)) : new ArrayList();
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(resEvaluateGoodsList);
        return queryResult;
    }

    private ResEvaluateGoodsReDomain makeGoodsReDomain(ResEvaluateGoods evaluateGoods) {
        String SYS_CODE_M = "res.ResEvaluateServiceImpl.makeShopReDomain.";
        if (evaluateGoods == null) {
            return null;
        }
        try {
            ResEvaluateGoodsReDomain reDomain = new ResEvaluateGoodsReDomain();
            BeanUtils.copyAllPropertys((Object)reDomain, (Object)evaluateGoods);
            reDomain.setEvaluateScopeList(this.makeEvaluateScopeReDomainList(this.queryScopeListBySGCode(reDomain.getEvaluateGoodsCode(), null)));
            return reDomain;
        }
        catch (Exception e) {
            this.logger.error("res.ResEvaluateServiceImpl.makeShopReDomain.ex", (Throwable)e);
            return null;
        }
    }

    @Override
    public ResEvaluateGoodsReDomain getEvaluateGoodsByCode(Map<String, Object> map) {
        return this.makeGoodsReDomain(this.getEvaluateGoodsModelByCode(map));
    }

    @Override
    public void deleteEvaluateGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delEvaluateGoodsModelByCode(map);
    }

    @Override
    public void updateGoodsShow(Integer evaluateGoodsId, Boolean show) {
        this.upGoodsShow(evaluateGoodsId, show);
    }

    @Override
    public String saveEvaluateAdd(ResEvaluateAddDomain resEvaluateAddDomain) throws ApiException {
        String msg = this.checkEvaluateAdd(resEvaluateAddDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateAdd.checkEvaluateAdd", msg);
        }
        ResEvaluateAdd resEvaluateAdd = this.makeEvaluateAdd(resEvaluateAddDomain, null);
        this.setEvaluateAddDefault(resEvaluateAdd);
        this.saveEvaluateAddModel(resEvaluateAdd);
        return resEvaluateAdd.getEvaluateAddCode();
    }

    @Override
    public void updateEvaluateAddState(Integer evaluateAddId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateEvaluateAddModel(evaluateAddId, dataState, oldDataState);
    }

    @Override
    public void updateEvaluateAdd(ResEvaluateAddDomain resEvaluateAddDomain) throws ApiException {
        String msg = this.checkEvaluateAdd(resEvaluateAddDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateAdd.checkEvaluateAdd", msg);
        }
        ResEvaluateAdd oldResEvaluateAdd = this.getEvaluateAddModelById(resEvaluateAddDomain.getEvaluateAddId());
        if (null == oldResEvaluateAdd) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateAdd.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ResEvaluateAdd resEvaluateAdd = this.makeEvaluateAdd(resEvaluateAddDomain, oldResEvaluateAdd);
        this.setEvaluateAddUpdataDefault(resEvaluateAdd);
        this.updateEvaluateAddModel(resEvaluateAdd);
    }

    @Override
    public ResEvaluateAdd getEvaluateAdd(Integer evaluateAddId) {
        return this.getEvaluateAddModelById(evaluateAddId);
    }

    @Override
    public void deleteEvaluateAdd(Integer evaluateAddId) throws ApiException {
        this.deleteEvaluateAddModel(evaluateAddId);
    }

    @Override
    public QueryResult<ResEvaluateAdd> queryEvaluateAddPage(Map<String, Object> map) {
        List<ResEvaluateAdd> resEvaluateAddList = this.queryEvaluateAddModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countEvaluateAdd(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(resEvaluateAddList);
        return queryResult;
    }

    @Override
    public ResEvaluateAdd getEvaluateAddByCode(Map<String, Object> map) {
        return this.getEvaluateAddModelByCode(map);
    }

    @Override
    public void deleteEvaluateAddByCode(Map<String, Object> map) throws ApiException {
        this.delEvaluateAddModelByCode(map);
    }

    @Override
    public String saveEvaluateScope(ResEvaluateScopeDomain resEvaluateScopeDomain) throws ApiException {
        String msg = this.checkEvaluateScope(resEvaluateScopeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResEvaluateServiceImpl.saveEvaluateScope.checkEvaluateScope", msg);
        }
        ResEvaluateScope resEvaluateScope = this.makeEvaluateScope(resEvaluateScopeDomain, null);
        this.setEvaluateScopeDefault(resEvaluateScope);
        this.saveEvaluateScopeModel(resEvaluateScope);
        return resEvaluateScope.getEvaluateScopeCode();
    }

    @Override
    public void updateEvaluateScopeState(Integer evaluateScopeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateEvaluateScopeModel(evaluateScopeId, dataState, oldDataState);
    }

    @Override
    public void updateEvaluateScope(ResEvaluateScopeDomain resEvaluateScopeDomain) throws ApiException {
        String msg = this.checkEvaluateScope(resEvaluateScopeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateScope.checkEvaluateScope", msg);
        }
        ResEvaluateScope oldResEvaluateScope = this.getEvaluateScopeModelById(resEvaluateScopeDomain.getEvaluateScopeId());
        if (null == oldResEvaluateScope) {
            throw new ApiException("res.ResEvaluateServiceImpl.updateEvaluateScope.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ResEvaluateScope resEvaluateScope = this.makeEvaluateScope(resEvaluateScopeDomain, oldResEvaluateScope);
        this.setEvaluateScopeUpdataDefault(resEvaluateScope);
        this.updateEvaluateScopeModel(resEvaluateScope);
    }

    @Override
    public ResEvaluateScope getEvaluateScope(Integer evaluateScopeId) {
        return this.getEvaluateScopeModelById(evaluateScopeId);
    }

    @Override
    public void deleteEvaluateScope(Integer evaluateScopeId) throws ApiException {
        this.deleteEvaluateScopeModel(evaluateScopeId);
    }

    @Override
    public QueryResult<ResEvaluateScope> queryEvaluateScopePage(Map<String, Object> map) {
        List<ResEvaluateScope> resEvaluateScopeList = this.queryEvaluateScopeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countEvaluateScope(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(resEvaluateScopeList);
        return queryResult;
    }

    @Override
    public ResEvaluateScope getEvaluateScopeByCode(Map<String, Object> map) {
        return this.getEvaluateScopeModelByCode(map);
    }

    @Override
    public void deleteEvaluateScopeByCode(Map<String, Object> map) throws ApiException {
        this.delEvaluateScopeModelByCode(map);
    }
}

