/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.evaluate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.evaluate.dao.ResConfigMapper;
import com.yqbsoft.laser.service.evaluate.domain.ResConfigDomain;
import com.yqbsoft.laser.service.evaluate.enums.ResConfigKey;
import com.yqbsoft.laser.service.evaluate.model.ResConfig;
import com.yqbsoft.laser.service.evaluate.service.ResConfigService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResConfigServiceImpl
extends BaseServiceImpl
implements ResConfigService {
    private static final String SYS_CODE = "res.ResConfigServiceImpl";
    private ResConfigMapper resConfigMapper;

    public void setResConfigMapper(ResConfigMapper resConfigMapper) {
        this.resConfigMapper = resConfigMapper;
    }

    private Date getSysDate() {
        try {
            return this.resConfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("res.ResConfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkConfig(ResConfigDomain resConfigDomain) {
        if (null == resConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (resConfigDomain.getConfigKey() == null) {
            msg = msg + "configKey\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resConfigDomain.getConfigValue())) {
            msg = msg + "configValue\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resConfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setConfigDefault(ResConfig resConfig) {
        if (null == resConfig) {
            return;
        }
        if (null == resConfig.getDataState()) {
            resConfig.setDataState(0);
        }
        if (null == resConfig.getGmtCreate()) {
            resConfig.setGmtCreate(this.getSysDate());
        }
        resConfig.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)resConfig.getConfigCode())) {
            resConfig.setConfigCode(this.createUUIDString());
        }
    }

    private int getConfigMaxCode() {
        int code = 0;
        try {
            return this.resConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("res.ResConfigServiceImpl.getConfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setConfigUpdataDefault(ResConfig resConfig) {
        if (null == resConfig) {
            return;
        }
        resConfig.setGmtModified(this.getSysDate());
    }

    private void saveConfigModel(ResConfig resConfig) throws ApiException {
        if (null == resConfig) {
            return;
        }
        try {
            this.resConfigMapper.insert(resConfig);
        }
        catch (Exception e) {
            throw new ApiException("res.ResConfigServiceImpl.saveConfigModel.ex", (Throwable)e);
        }
    }

    private ResConfig getConfigModelById(Integer configId) {
        if (null == configId) {
            return null;
        }
        try {
            return this.resConfigMapper.selectByPrimaryKey(configId);
        }
        catch (Exception e) {
            this.logger.error("res.ResConfigServiceImpl.getConfigModelById", (Throwable)e);
            return null;
        }
    }

    private ResConfig getConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.resConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResConfigServiceImpl.getConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.resConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResConfigServiceImpl.delConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResConfigServiceImpl.delConfigModelByCode.num");
        }
    }

    private void deleteConfigModel(Integer configId) throws ApiException {
        if (null == configId) {
            return;
        }
        int i = 0;
        try {
            i = this.resConfigMapper.deleteByPrimaryKey(configId);
        }
        catch (Exception e) {
            throw new ApiException("res.ResConfigServiceImpl.deleteConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResConfigServiceImpl.deleteConfigModel.num");
        }
    }

    private void updateConfigModel(ResConfig resConfig) throws ApiException {
        if (null == resConfig) {
            return;
        }
        int i = 0;
        try {
            i = this.resConfigMapper.updateByPrimaryKeySelective(resConfig);
        }
        catch (Exception e) {
            throw new ApiException("res.ResConfigServiceImpl.updateConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResConfigServiceImpl.updateConfigModel.num");
        }
    }

    private void updateStateConfigModel(Integer configId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == configId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configId", configId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.resConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResConfigServiceImpl.updateStateConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("res.ResConfigServiceImpl.updateStateConfigModel.null");
        }
    }

    private ResConfig makeConfig(ResConfigDomain resConfigDomain, ResConfig resConfig) {
        if (null == resConfigDomain) {
            return null;
        }
        if (null == resConfig) {
            resConfig = new ResConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)resConfig, (Object)resConfigDomain);
            return resConfig;
        }
        catch (Exception e) {
            this.logger.error("res.ResConfigServiceImpl.makeConfig", (Throwable)e);
            return null;
        }
    }

    private List<ResConfig> queryConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.resConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("res.ResConfigServiceImpl.queryConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.resConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResConfigServiceImpl.countConfig", (Throwable)e);
        }
        return i;
    }

    private String getConfigValueByKey(ResConfigKey configKey, String tenantCode) {
        if (configKey == null) {
            return null;
        }
        try {
            return this.resConfigMapper.selectByConfigKey(configKey, tenantCode);
        }
        catch (Exception e) {
            this.logger.error("res.ResConfigServiceImpl.getConfigValueByKey.ex", (Throwable)e);
            return null;
        }
    }

    private String saveDefaultConfig(ResConfigKey configKey, String tenantCode) {
        if (configKey == null) {
            return null;
        }
        ResConfigDomain configDomain = new ResConfigDomain();
        configDomain.setConfigKey(configKey);
        configDomain.setConfigValue(configKey.getDefaultValue());
        configDomain.setTenantCode(tenantCode);
        configDomain.setAppmanageIcode(null);
        configDomain.setConfigRemark("");
        this.saveConfig(configDomain);
        return configDomain.getConfigValue();
    }

    @Override
    public String saveConfig(ResConfigDomain resConfigDomain) throws ApiException {
        String msg = this.checkConfig(resConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResConfigServiceImpl.saveConfig.checkConfig", msg);
        }
        ResConfig resConfig = this.makeConfig(resConfigDomain, null);
        this.setConfigDefault(resConfig);
        this.saveConfigModel(resConfig);
        return resConfig.getConfigCode();
    }

    @Override
    public void updateConfigState(Integer configId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateConfigModel(configId, dataState, oldDataState);
    }

    @Override
    public void updateConfig(ResConfigDomain resConfigDomain) throws ApiException {
        String msg = this.checkConfig(resConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResConfigServiceImpl.updateConfig.checkConfig", msg);
        }
        ResConfig oldResConfig = this.getConfigModelById(resConfigDomain.getConfigId());
        if (null == oldResConfig) {
            throw new ApiException("res.ResConfigServiceImpl.updateConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ResConfigKey key = oldResConfig.getConfigKey();
        ResConfig resConfig = this.makeConfig(resConfigDomain, oldResConfig);
        resConfig.setConfigKey(key);
        this.setConfigUpdataDefault(resConfig);
        this.updateConfigModel(resConfig);
    }

    @Override
    public ResConfig getConfig(Integer configId) {
        return this.getConfigModelById(configId);
    }

    @Override
    public void deleteConfig(Integer configId) throws ApiException {
        this.deleteConfigModel(configId);
    }

    @Override
    public QueryResult<ResConfig> queryConfigPage(Map<String, Object> map) {
        List<ResConfig> resConfigList = this.queryConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(resConfigList);
        return queryResult;
    }

    @Override
    public ResConfig getConfigByCode(Map<String, Object> map) {
        return this.getConfigModelByCode(map);
    }

    @Override
    public void deleteConfigByCode(Map<String, Object> map) throws ApiException {
        this.delConfigModelByCode(map);
    }

    @Override
    public String saveGetConfigByKey(ResConfigKey configKey, String tenantCode) {
        if (configKey == null) {
            return null;
        }
        String value = this.getConfigValueByKey(configKey, tenantCode);
        if (value == null) {
            value = this.saveDefaultConfig(configKey, tenantCode);
        }
        return value;
    }
}

