/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exception.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.exception.dao.EmExceptionMsgMapper;
import com.yqbsoft.laser.service.exception.domain.EmExceptionMsgDomain;
import com.yqbsoft.laser.service.exception.model.EmExceptionMsg;
import com.yqbsoft.laser.service.exception.service.ExceptionMsgService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExceptionMsgServiceImpl
extends BaseServiceImpl
implements ExceptionMsgService {
    public static final String SYS_CODE = "em.EXCEPTION.ExceptionMsgServiceImpl";
    private EmExceptionMsgMapper emExceptionMsgMapper;

    public void setEmExceptionMsgMapper(EmExceptionMsgMapper emExceptionMsgMapper) {
        this.emExceptionMsgMapper = emExceptionMsgMapper;
    }

    private Date getSysDate() {
        try {
            return this.emExceptionMsgMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionMsgServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkExceptionMsg(EmExceptionMsgDomain emExceptionMsgDomain) {
        if (null == emExceptionMsgDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setExceptionMsgDefault(EmExceptionMsg emExceptionMsg) {
        if (null == emExceptionMsg) {
            return;
        }
        if (null == emExceptionMsg.getDataState()) {
            emExceptionMsg.setDataState(0);
        }
        if (null == emExceptionMsg.getGmtCreate()) {
            emExceptionMsg.setGmtCreate(this.getSysDate());
        }
        emExceptionMsg.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.emExceptionMsgMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionMsgServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setExceptionMsgUpdataDefault(EmExceptionMsg emExceptionMsg) {
        if (null == emExceptionMsg) {
            return;
        }
        emExceptionMsg.setGmtModified(this.getSysDate());
    }

    private void saveExceptionMsgModel(EmExceptionMsg emExceptionMsg) throws ApiException {
        if (null == emExceptionMsg) {
            return;
        }
        try {
            this.emExceptionMsgMapper.insert(emExceptionMsg);
        }
        catch (Exception e) {
            throw new ApiException("em.EXCEPTION.ExceptionMsgServiceImpl.saveExceptionMsgModel.ex", (Throwable)e);
        }
    }

    private EmExceptionMsg getExceptionMsgModelById(Integer exceptionMsgId) {
        if (null == exceptionMsgId) {
            return null;
        }
        try {
            return this.emExceptionMsgMapper.selectByPrimaryKey(exceptionMsgId);
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionMsgServiceImpl.getExceptionMsgModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteExceptionMsgModel(Integer exceptionMsgId) throws ApiException {
        if (null == exceptionMsgId) {
            return;
        }
        int i = 0;
        try {
            i = this.emExceptionMsgMapper.deleteByPrimaryKey(exceptionMsgId);
        }
        catch (Exception e) {
            throw new ApiException("em.EXCEPTION.ExceptionMsgServiceImpl.deleteExceptionMsgModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("em.EXCEPTION.ExceptionMsgServiceImpl.deleteExceptionMsgModel.num");
        }
    }

    private void updateExceptionMsgModel(EmExceptionMsg emExceptionMsg) throws ApiException {
        if (null == emExceptionMsg) {
            return;
        }
        try {
            this.emExceptionMsgMapper.updateByPrimaryKeySelective(emExceptionMsg);
        }
        catch (Exception e) {
            throw new ApiException("em.EXCEPTION.ExceptionMsgServiceImpl.updateExceptionMsgModel.ex", (Throwable)e);
        }
    }

    private void updateStateExceptionMsgModel(Integer exceptionMsgId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == exceptionMsgId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exceptionMsgId", exceptionMsgId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.emExceptionMsgMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("em.EXCEPTION.ExceptionMsgServiceImpl.updateStateExceptionMsgModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("em.EXCEPTION.ExceptionMsgServiceImpl.updateStateExceptionMsgModel.null");
        }
    }

    private EmExceptionMsg makeExceptionMsg(EmExceptionMsgDomain emExceptionMsgDomain, EmExceptionMsg emExceptionMsg) {
        if (null == emExceptionMsgDomain) {
            return null;
        }
        if (null == emExceptionMsg) {
            emExceptionMsg = new EmExceptionMsg();
        }
        try {
            BeanUtils.copyAllPropertys((Object)emExceptionMsg, (Object)emExceptionMsgDomain);
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionMsgServiceImpl.makeExceptionMsg", (Throwable)e);
        }
        return emExceptionMsg;
    }

    private List<EmExceptionMsg> queryExceptionMsgModelPage(Map<String, Object> parammap) {
        try {
            return this.emExceptionMsgMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionMsgServiceImpl.queryExceptionMsgModel", (Throwable)e);
            return null;
        }
    }

    private int countExceptionMsg(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.emExceptionMsgMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionMsgServiceImpl.countExceptionMsg", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveExceptionMsg(EmExceptionMsgDomain emExceptionMsgDomain) throws ApiException {
        String msg = this.checkExceptionMsg(emExceptionMsgDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("em.EXCEPTION.ExceptionMsgServiceImpl.saveExceptionMsg.checkExceptionMsg", msg);
        }
        EmExceptionMsg emExceptionMsg = this.makeExceptionMsg(emExceptionMsgDomain, null);
        this.setExceptionMsgDefault(emExceptionMsg);
        this.saveExceptionMsgModel(emExceptionMsg);
    }

    @Override
    public void updateExceptionMsgState(Integer exceptionMsgId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateExceptionMsgModel(exceptionMsgId, dataState, oldDataState);
    }

    @Override
    public void updateExceptionMsg(EmExceptionMsgDomain emExceptionMsgDomain) throws ApiException {
        String msg = this.checkExceptionMsg(emExceptionMsgDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("em.EXCEPTION.ExceptionMsgServiceImpl.updateExceptionMsg.checkExceptionMsg", msg);
        }
        EmExceptionMsg oldEmExceptionMsg = this.getExceptionMsgModelById(emExceptionMsgDomain.getExceptionMsgId());
        if (null == oldEmExceptionMsg) {
            throw new ApiException("em.EXCEPTION.ExceptionMsgServiceImpl.updateExceptionMsg.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EmExceptionMsg emExceptionMsg = this.makeExceptionMsg(emExceptionMsgDomain, oldEmExceptionMsg);
        this.setExceptionMsgUpdataDefault(emExceptionMsg);
        this.updateExceptionMsgModel(emExceptionMsg);
    }

    @Override
    public EmExceptionMsg getExceptionMsg(Integer exceptionMsgId) {
        return this.getExceptionMsgModelById(exceptionMsgId);
    }

    @Override
    public void deleteExceptionMsg(Integer exceptionMsgId) throws ApiException {
        this.deleteExceptionMsgModel(exceptionMsgId);
    }

    @Override
    public QueryResult<EmExceptionMsg> queryExceptionMsgPage(Map<String, Object> map) {
        List<EmExceptionMsg> emExceptionMsgList = this.queryExceptionMsgModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countExceptionMsg(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(emExceptionMsgList);
        return queryResult;
    }
}

