/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exception.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.ErrorApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.exception.dao.EmExceptionMapper;
import com.yqbsoft.laser.service.exception.domain.EmExceptionDomain;
import com.yqbsoft.laser.service.exception.model.EmException;
import com.yqbsoft.laser.service.exception.service.ExceptionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExceptionServiceImpl
extends BaseServiceImpl
implements ExceptionService {
    public static final String SYS_CODE = "em.EXCEPTION.ExceptionServiceImpl";
    public static final String CACHE_KEY = "EcoreException-pro";
    private EmExceptionMapper emExceptionMapper;

    public void setEmExceptionMapper(EmExceptionMapper emExceptionMapper) {
        this.emExceptionMapper = emExceptionMapper;
    }

    private Date getSysDate() {
        try {
            return this.emExceptionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkException(EmExceptionDomain emExceptionDomain) {
        if (null == emExceptionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setExceptionDefault(EmException emException) {
        if (null == emException) {
            return;
        }
        if (null == emException.getDataState()) {
            emException.setDataState(0);
        }
        if (null == emException.getGmtCreate()) {
            emException.setGmtCreate(this.getSysDate());
        }
        emException.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.emExceptionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setExceptionUpdataDefault(EmException emException) {
        if (null == emException) {
            return;
        }
        emException.setGmtModified(this.getSysDate());
    }

    private void saveExceptionModel(EmException emException) throws ApiException {
        if (null == emException) {
            return;
        }
        try {
            this.emExceptionMapper.insert(emException);
        }
        catch (Exception e) {
            throw new ApiException("em.EXCEPTION.ExceptionServiceImpl.saveExceptionModel.ex", (Throwable)e);
        }
    }

    private EmException getExceptionModelById(Integer exceptionId) {
        if (null == exceptionId) {
            return null;
        }
        try {
            return this.emExceptionMapper.selectByPrimaryKey(exceptionId);
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionServiceImpl.getExceptionModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteExceptionModel(Integer exceptionId) throws ApiException {
        if (null == exceptionId) {
            return;
        }
        int i = 0;
        try {
            i = this.emExceptionMapper.deleteByPrimaryKey(exceptionId);
        }
        catch (Exception e) {
            throw new ApiException("em.EXCEPTION.ExceptionServiceImpl.deleteExceptionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("em.EXCEPTION.ExceptionServiceImpl.deleteExceptionModel.num");
        }
    }

    private void updateExceptionModel(EmException emException) throws ApiException {
        if (null == emException) {
            return;
        }
        try {
            this.emExceptionMapper.updateByPrimaryKeySelective(emException);
        }
        catch (Exception e) {
            throw new ApiException("em.EXCEPTION.ExceptionServiceImpl.updateExceptionModel.ex", (Throwable)e);
        }
    }

    private void updateStateExceptionModel(Integer exceptionId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == exceptionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exceptionId", exceptionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.emExceptionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("em.EXCEPTION.ExceptionServiceImpl.updateStateExceptionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("em.EXCEPTION.ExceptionServiceImpl.updateStateExceptionModel.null");
        }
    }

    private EmException makeException(EmExceptionDomain emExceptionDomain, EmException emException) {
        if (null == emExceptionDomain) {
            return null;
        }
        if (null == emException) {
            emException = new EmException();
        }
        try {
            BeanUtils.copyAllPropertys((Object)emException, (Object)emExceptionDomain);
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionServiceImpl.makeException", (Throwable)e);
        }
        return emException;
    }

    private List<EmException> queryExceptionModelPage(Map<String, Object> parammap) {
        try {
            return this.emExceptionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionServiceImpl.queryExceptionModel", (Throwable)e);
            return null;
        }
    }

    private int countException(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.emExceptionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionServiceImpl.countException", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveException(EmExceptionDomain emExceptionDomain) throws ApiException {
        String msg = this.checkException(emExceptionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("em.EXCEPTION.ExceptionServiceImpl.saveException.checkException", msg);
        }
        EmException emException = this.makeException(emExceptionDomain, null);
        this.setExceptionDefault(emException);
        this.saveExceptionModel(emException);
    }

    @Override
    public void updateExceptionState(Integer exceptionId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateExceptionModel(exceptionId, dataState, oldDataState);
        this.refreshCache(this.getException(exceptionId), oldDataState);
    }

    @Override
    public void updateException(EmExceptionDomain emExceptionDomain) throws ApiException {
        String msg = this.checkException(emExceptionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("em.EXCEPTION.ExceptionServiceImpl.updateException.checkException", msg);
        }
        EmException oldEmException = this.getExceptionModelById(emExceptionDomain.getExceptionId());
        if (null == oldEmException) {
            throw new ApiException("em.EXCEPTION.ExceptionServiceImpl.updateException.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EmException emException = this.makeException(emExceptionDomain, oldEmException);
        this.setExceptionUpdataDefault(emException);
        this.updateExceptionModel(emException);
    }

    @Override
    public EmException getException(Integer exceptionId) {
        return this.getExceptionModelById(exceptionId);
    }

    @Override
    public void deleteException(Integer exceptionId) throws ApiException {
        this.deleteExceptionModel(exceptionId);
    }

    @Override
    public QueryResult<EmException> queryExceptionPage(Map<String, Object> map) {
        List<EmException> emExceptionList = this.queryExceptionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countException(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(emExceptionList);
        return queryResult;
    }

    @Override
    public void queryExceptionCache() {
        this.info("em.EXCEPTION.ExceptionServiceImpl.queryExceptionCache", "=======queryExceptionCache\u8c03\u5ea6start=======");
        List<EmException> emExceptionList = this.queryExceptionModelPage(this.getQueryParamMap("dataState", new Object[]{1}));
        if (emExceptionList == null || emExceptionList.isEmpty()) {
            DisUtil.delVer((String)CACHE_KEY);
            this.info("em.EXCEPTION.ExceptionServiceImpl.queryExceptionCache", "=======queryExceptionCache\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, List<ErrorApiException>> smap = new HashMap<String, List<ErrorApiException>>();
        for (EmException emException : emExceptionList) {
            this.saveCache(emException, smap);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(smap));
        this.info("em.EXCEPTION.ExceptionServiceImpl.queryExceptionCache", "=======queryExceptionCache\u8c03\u5ea6end=======");
    }

    private void refreshCache(EmException emException, Integer dataState) {
        boolean addflag = dataState == 1;
        HashMap<String, List<ErrorApiException>> map = DisUtil.getMapByListJson((String)CACHE_KEY, String.class, ErrorApiException.class);
        if (map == null) {
            map = new HashMap<String, List<ErrorApiException>>();
        }
        if (addflag) {
            this.saveCache(emException, map);
        } else {
            this.deleteCache(emException, map);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    private void deleteCache(EmException emException, Map<String, List<ErrorApiException>> map) {
        if (map == null) {
            return;
        }
        String key = emException.getAppapiCode();
        List<ErrorApiException> list = map.get(key);
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getExceptionId().equals(emException.getExceptionId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private void saveCache(EmException emException, Map<String, List<ErrorApiException>> map) {
        ErrorApiException apiException = this.makeApiException(emException);
        String key = apiException.getAppapiCode();
        List<ErrorApiException> list = map.get(key);
        if (list == null) {
            list = new ArrayList<ErrorApiException>();
            map.put(key, list);
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getExceptionId().equals(emException.getExceptionId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, apiException);
        } else {
            list.add(apiException);
        }
    }

    private ErrorApiException makeApiException(EmException emException) {
        if (null == emException) {
            return null;
        }
        ErrorApiException apiException = new ErrorApiException();
        try {
            BeanUtils.copyAllPropertys((Object)apiException, (Object)emException);
        }
        catch (Exception e) {
            this.logger.error("em.EXCEPTION.ExceptionServiceImpl.makeException", (Throwable)e);
        }
        return apiException;
    }
}

