/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.fc.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.fc.dao.FcFranchiUserMapper;
import com.yqbsoft.laser.service.fc.domain.FcFranchiUserDomain;
import com.yqbsoft.laser.service.fc.domain.FcFranchiUserReDomain;
import com.yqbsoft.laser.service.fc.model.FcFranchiUser;
import com.yqbsoft.laser.service.fc.service.FcFranchiUserService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FcFranchiUserServiceImpl
extends BaseServiceImpl
implements FcFranchiUserService {
    private static final String SYS_CODE = "fc.franchi.FcFranchiUserServiceImpl";
    private FcFranchiUserMapper fcFranchiUserMapper;

    public void setFcFranchiUserMapper(FcFranchiUserMapper fcFranchiUserMapper) {
        this.fcFranchiUserMapper = fcFranchiUserMapper;
    }

    private Date getSysDate() {
        try {
            return this.fcFranchiUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiUserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFranchiUser(FcFranchiUserDomain fcFranchiUserDomain) {
        if (null == fcFranchiUserDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)fcFranchiUserDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFranchiUserDefault(FcFranchiUser fcFranchiUser) {
        if (null == fcFranchiUser) {
            return;
        }
        if (null == fcFranchiUser.getDataState()) {
            fcFranchiUser.setDataState(0);
        }
        if (null == fcFranchiUser.getGmtCreate()) {
            fcFranchiUser.setGmtCreate(this.getSysDate());
        }
        fcFranchiUser.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)fcFranchiUser.getFranchiUserCode())) {
            fcFranchiUser.setFranchiUserCode(this.createUUIDString());
        }
    }

    private int getFranchiUserMaxCode() {
        int code = 0;
        try {
            return this.fcFranchiUserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiUserServiceImpl.getFranchiUserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFranchiUserUpdataDefault(FcFranchiUser fcFranchiUser) {
        if (null == fcFranchiUser) {
            return;
        }
        fcFranchiUser.setGmtModified(this.getSysDate());
    }

    private void saveFranchiUserModel(FcFranchiUser fcFranchiUser) throws ApiException {
        if (null == fcFranchiUser) {
            return;
        }
        try {
            this.fcFranchiUserMapper.insert(fcFranchiUser);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.saveFranchiUserModel.ex", (Throwable)e);
        }
    }

    private void saveFranchiUserBatchModel(List<FcFranchiUser> fcFranchiUserList) throws ApiException {
        if (null == fcFranchiUserList || fcFranchiUserList.isEmpty()) {
            return;
        }
        try {
            this.fcFranchiUserMapper.insertBatch(fcFranchiUserList);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.saveFranchiUserBatchModel.ex", (Throwable)e);
        }
    }

    private FcFranchiUser getFranchiUserModelById(Integer franchiUserId) {
        if (null == franchiUserId) {
            return null;
        }
        try {
            return this.fcFranchiUserMapper.selectByPrimaryKey(franchiUserId);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiUserServiceImpl.getFranchiUserModelById", (Throwable)e);
            return null;
        }
    }

    private FcFranchiUser getFranchiUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.fcFranchiUserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiUserServiceImpl.getFranchiUserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delFranchiUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.fcFranchiUserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.delFranchiUserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.delFranchiUserModelByCode.num");
        }
    }

    private void deleteFranchiUserModel(Integer franchiUserId) throws ApiException {
        if (null == franchiUserId) {
            return;
        }
        int i = 0;
        try {
            i = this.fcFranchiUserMapper.deleteByPrimaryKey(franchiUserId);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.deleteFranchiUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.deleteFranchiUserModel.num");
        }
    }

    private void updateFranchiUserModel(FcFranchiUser fcFranchiUser) throws ApiException {
        if (null == fcFranchiUser) {
            return;
        }
        int i = 0;
        try {
            i = this.fcFranchiUserMapper.updateByPrimaryKeySelective(fcFranchiUser);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.updateFranchiUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.updateFranchiUserModel.num");
        }
    }

    private void updateStateFranchiUserModel(Integer franchiUserId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == franchiUserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("franchiUserId", franchiUserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.fcFranchiUserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.updateStateFranchiUserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.updateStateFranchiUserModel.null");
        }
    }

    private void updateStateFranchiUserModelByCode(String tenantCode, String franchiUserCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)franchiUserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("franchiUserCode", franchiUserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.fcFranchiUserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.updateStateFranchiUserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.updateStateFranchiUserModelByCode.null");
        }
    }

    private FcFranchiUser makeFranchiUser(FcFranchiUserDomain fcFranchiUserDomain, FcFranchiUser fcFranchiUser) {
        if (null == fcFranchiUserDomain) {
            return null;
        }
        if (null == fcFranchiUser) {
            fcFranchiUser = new FcFranchiUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)fcFranchiUser, (Object)fcFranchiUserDomain);
            return fcFranchiUser;
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiUserServiceImpl.makeFranchiUser", (Throwable)e);
            return null;
        }
    }

    private FcFranchiUserReDomain makeFcFranchiUserReDomain(FcFranchiUser fcFranchiUser) {
        if (null == fcFranchiUser) {
            return null;
        }
        FcFranchiUserReDomain fcFranchiUserReDomain = new FcFranchiUserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)fcFranchiUserReDomain, (Object)fcFranchiUser);
            return fcFranchiUserReDomain;
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiUserServiceImpl.makeFcFranchiUserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<FcFranchiUser> queryFranchiUserModelPage(Map<String, Object> parammap) {
        try {
            return this.fcFranchiUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiUserServiceImpl.queryFranchiUserModel", (Throwable)e);
            return null;
        }
    }

    private int countFranchiUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.fcFranchiUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiUserServiceImpl.countFranchiUser", (Throwable)e);
        }
        return i;
    }

    private FcFranchiUser createFcFranchiUser(FcFranchiUserDomain fcFranchiUserDomain) {
        String msg = this.checkFranchiUser(fcFranchiUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.saveFranchiUser.checkFranchiUser", msg);
        }
        FcFranchiUser fcFranchiUser = this.makeFranchiUser(fcFranchiUserDomain, null);
        this.setFranchiUserDefault(fcFranchiUser);
        return fcFranchiUser;
    }

    @Override
    public String saveFranchiUser(FcFranchiUserDomain fcFranchiUserDomain) throws ApiException {
        FcFranchiUser fcFranchiUser = this.createFcFranchiUser(fcFranchiUserDomain);
        this.saveFranchiUserModel(fcFranchiUser);
        return fcFranchiUser.getFranchiUserCode();
    }

    @Override
    public String saveFranchiUserBatch(List<FcFranchiUserDomain> fcFranchiUserDomainList) throws ApiException {
        if (null == fcFranchiUserDomainList || fcFranchiUserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<FcFranchiUser> fcFranchiUserList = new ArrayList<FcFranchiUser>();
        String code = "";
        for (FcFranchiUserDomain fcFranchiUserDomain : fcFranchiUserDomainList) {
            FcFranchiUser fcFranchiUser = this.createFcFranchiUser(fcFranchiUserDomain);
            code = fcFranchiUser.getFranchiUserCode();
            fcFranchiUserList.add(fcFranchiUser);
        }
        this.saveFranchiUserBatchModel(fcFranchiUserList);
        return code;
    }

    @Override
    public void updateFranchiUserState(Integer franchiUserId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFranchiUserModel(franchiUserId, dataState, oldDataState);
    }

    @Override
    public void updateFranchiUserStateByCode(String tenantCode, String franchiUserCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFranchiUserModelByCode(tenantCode, franchiUserCode, dataState, oldDataState);
    }

    @Override
    public void updateFranchiUser(FcFranchiUserDomain fcFranchiUserDomain) throws ApiException {
        String msg = this.checkFranchiUser(fcFranchiUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.updateFranchiUser.checkFranchiUser", msg);
        }
        FcFranchiUser oldFcFranchiUser = this.getFranchiUserModelById(fcFranchiUserDomain.getFranchiUserId());
        if (null == oldFcFranchiUser) {
            throw new ApiException("fc.franchi.FcFranchiUserServiceImpl.updateFranchiUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FcFranchiUser fcFranchiUser = this.makeFranchiUser(fcFranchiUserDomain, oldFcFranchiUser);
        this.setFranchiUserUpdataDefault(fcFranchiUser);
        this.updateFranchiUserModel(fcFranchiUser);
    }

    @Override
    public FcFranchiUser getFranchiUser(Integer franchiUserId) {
        return this.getFranchiUserModelById(franchiUserId);
    }

    @Override
    public void deleteFranchiUser(Integer franchiUserId) throws ApiException {
        this.deleteFranchiUserModel(franchiUserId);
    }

    @Override
    public QueryResult<FcFranchiUser> queryFranchiUserPage(Map<String, Object> map) {
        List<FcFranchiUser> fcFranchiUserList = this.queryFranchiUserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFranchiUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fcFranchiUserList);
        return queryResult;
    }

    @Override
    public FcFranchiUser getFranchiUserByCode(String tenantCode, String franchiUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("franchiUserCode", franchiUserCode);
        return this.getFranchiUserModelByCode(map);
    }

    @Override
    public void deleteFranchiUserByCode(String tenantCode, String franchiUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("franchiUserCode", franchiUserCode);
        this.delFranchiUserModelByCode(map);
    }
}

