/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.fc.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.fc.dao.FcTraintemMapper;
import com.yqbsoft.laser.service.fc.domain.FcTraintemDomain;
import com.yqbsoft.laser.service.fc.domain.FcTraintemReDomain;
import com.yqbsoft.laser.service.fc.model.FcTraintem;
import com.yqbsoft.laser.service.fc.service.FcTraintemService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FcTraintemServiceImpl
extends BaseServiceImpl
implements FcTraintemService {
    private static final String SYS_CODE = "fc.franchi.FcTraintemServiceImpl";
    private FcTraintemMapper fcTraintemMapper;

    public void setFcTraintemMapper(FcTraintemMapper fcTraintemMapper) {
        this.fcTraintemMapper = fcTraintemMapper;
    }

    private Date getSysDate() {
        try {
            return this.fcTraintemMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTraintemServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTraintem(FcTraintemDomain fcTraintemDomain) {
        if (null == fcTraintemDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)fcTraintemDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTraintemDefault(FcTraintem fcTraintem) {
        if (null == fcTraintem) {
            return;
        }
        if (null == fcTraintem.getDataState()) {
            fcTraintem.setDataState(0);
        }
        if (null == fcTraintem.getGmtCreate()) {
            fcTraintem.setGmtCreate(this.getSysDate());
        }
        fcTraintem.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)fcTraintem.getTraintemCode())) {
            fcTraintem.setTraintemCode(this.createUUIDString());
        }
    }

    private int getTraintemMaxCode() {
        int code = 0;
        try {
            return this.fcTraintemMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTraintemServiceImpl.getTraintemMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTraintemUpdataDefault(FcTraintem fcTraintem) {
        if (null == fcTraintem) {
            return;
        }
        fcTraintem.setGmtModified(this.getSysDate());
    }

    private void saveTraintemModel(FcTraintem fcTraintem) throws ApiException {
        if (null == fcTraintem) {
            return;
        }
        try {
            this.fcTraintemMapper.insert(fcTraintem);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.saveTraintemModel.ex", (Throwable)e);
        }
    }

    private void saveTraintemBatchModel(List<FcTraintem> fcTraintemList) throws ApiException {
        if (null == fcTraintemList || fcTraintemList.isEmpty()) {
            return;
        }
        try {
            this.fcTraintemMapper.insertBatch(fcTraintemList);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.saveTraintemBatchModel.ex", (Throwable)e);
        }
    }

    private FcTraintem getTraintemModelById(Integer traintemId) {
        if (null == traintemId) {
            return null;
        }
        try {
            return this.fcTraintemMapper.selectByPrimaryKey(traintemId);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTraintemServiceImpl.getTraintemModelById", (Throwable)e);
            return null;
        }
    }

    private FcTraintem getTraintemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.fcTraintemMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTraintemServiceImpl.getTraintemModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTraintemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.fcTraintemMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.delTraintemModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.delTraintemModelByCode.num");
        }
    }

    private void deleteTraintemModel(Integer traintemId) throws ApiException {
        if (null == traintemId) {
            return;
        }
        int i = 0;
        try {
            i = this.fcTraintemMapper.deleteByPrimaryKey(traintemId);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.deleteTraintemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.deleteTraintemModel.num");
        }
    }

    private void updateTraintemModel(FcTraintem fcTraintem) throws ApiException {
        if (null == fcTraintem) {
            return;
        }
        int i = 0;
        try {
            i = this.fcTraintemMapper.updateByPrimaryKeySelective(fcTraintem);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.updateTraintemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.updateTraintemModel.num");
        }
    }

    private void updateStateTraintemModel(Integer traintemId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == traintemId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("traintemId", traintemId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.fcTraintemMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.updateStateTraintemModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.updateStateTraintemModel.null");
        }
    }

    private void updateStateTraintemModelByCode(String tenantCode, String traintemCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)traintemCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("traintemCode", traintemCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.fcTraintemMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.updateStateTraintemModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.updateStateTraintemModelByCode.null");
        }
    }

    private FcTraintem makeTraintem(FcTraintemDomain fcTraintemDomain, FcTraintem fcTraintem) {
        if (null == fcTraintemDomain) {
            return null;
        }
        if (null == fcTraintem) {
            fcTraintem = new FcTraintem();
        }
        try {
            BeanUtils.copyAllPropertys((Object)fcTraintem, (Object)fcTraintemDomain);
            return fcTraintem;
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTraintemServiceImpl.makeTraintem", (Throwable)e);
            return null;
        }
    }

    private FcTraintemReDomain makeFcTraintemReDomain(FcTraintem fcTraintem) {
        if (null == fcTraintem) {
            return null;
        }
        FcTraintemReDomain fcTraintemReDomain = new FcTraintemReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)fcTraintemReDomain, (Object)fcTraintem);
            return fcTraintemReDomain;
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTraintemServiceImpl.makeFcTraintemReDomain", (Throwable)e);
            return null;
        }
    }

    private List<FcTraintem> queryTraintemModelPage(Map<String, Object> parammap) {
        try {
            return this.fcTraintemMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTraintemServiceImpl.queryTraintemModel", (Throwable)e);
            return null;
        }
    }

    private int countTraintem(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.fcTraintemMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTraintemServiceImpl.countTraintem", (Throwable)e);
        }
        return i;
    }

    private FcTraintem createFcTraintem(FcTraintemDomain fcTraintemDomain) {
        String msg = this.checkTraintem(fcTraintemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.saveTraintem.checkTraintem", msg);
        }
        FcTraintem fcTraintem = this.makeTraintem(fcTraintemDomain, null);
        this.setTraintemDefault(fcTraintem);
        return fcTraintem;
    }

    @Override
    public String saveTraintem(FcTraintemDomain fcTraintemDomain) throws ApiException {
        FcTraintem fcTraintem = this.createFcTraintem(fcTraintemDomain);
        this.saveTraintemModel(fcTraintem);
        return fcTraintem.getTraintemCode();
    }

    @Override
    public String saveTraintemBatch(List<FcTraintemDomain> fcTraintemDomainList) throws ApiException {
        if (null == fcTraintemDomainList || fcTraintemDomainList.isEmpty()) {
            return null;
        }
        ArrayList<FcTraintem> fcTraintemList = new ArrayList<FcTraintem>();
        String code = "";
        for (FcTraintemDomain fcTraintemDomain : fcTraintemDomainList) {
            FcTraintem fcTraintem = this.createFcTraintem(fcTraintemDomain);
            code = fcTraintem.getTraintemCode();
            fcTraintemList.add(fcTraintem);
        }
        this.saveTraintemBatchModel(fcTraintemList);
        return code;
    }

    @Override
    public void updateTraintemState(Integer traintemId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTraintemModel(traintemId, dataState, oldDataState);
    }

    @Override
    public void updateTraintemStateByCode(String tenantCode, String traintemCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTraintemModelByCode(tenantCode, traintemCode, dataState, oldDataState);
    }

    @Override
    public void updateTraintem(FcTraintemDomain fcTraintemDomain) throws ApiException {
        String msg = this.checkTraintem(fcTraintemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.updateTraintem.checkTraintem", msg);
        }
        FcTraintem oldFcTraintem = this.getTraintemModelById(fcTraintemDomain.getTraintemId());
        if (null == oldFcTraintem) {
            throw new ApiException("fc.franchi.FcTraintemServiceImpl.updateTraintem.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FcTraintem fcTraintem = this.makeTraintem(fcTraintemDomain, oldFcTraintem);
        this.setTraintemUpdataDefault(fcTraintem);
        this.updateTraintemModel(fcTraintem);
    }

    @Override
    public FcTraintem getTraintem(Integer traintemId) {
        return this.getTraintemModelById(traintemId);
    }

    @Override
    public void deleteTraintem(Integer traintemId) throws ApiException {
        this.deleteTraintemModel(traintemId);
    }

    @Override
    public QueryResult<FcTraintem> queryTraintemPage(Map<String, Object> map) {
        List<FcTraintem> fcTraintemList = this.queryTraintemModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTraintem(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fcTraintemList);
        return queryResult;
    }

    @Override
    public FcTraintem getTraintemByCode(String tenantCode, String traintemCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("traintemCode", traintemCode);
        return this.getTraintemModelByCode(map);
    }

    @Override
    public void deleteTraintemByCode(String tenantCode, String traintemCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("traintemCode", traintemCode);
        this.delTraintemModelByCode(map);
    }
}

