/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.fc.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.fc.dao.FcFranchiMapper;
import com.yqbsoft.laser.service.fc.domain.FcFranchiDomain;
import com.yqbsoft.laser.service.fc.domain.FcFranchiReDomain;
import com.yqbsoft.laser.service.fc.model.FcFranchi;
import com.yqbsoft.laser.service.fc.service.FcFranchiService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FcFranchiServiceImpl
extends BaseServiceImpl
implements FcFranchiService {
    private static final String SYS_CODE = "fc.franchi.FcFranchiServiceImpl";
    private FcFranchiMapper fcFranchiMapper;

    public void setFcFranchiMapper(FcFranchiMapper fcFranchiMapper) {
        this.fcFranchiMapper = fcFranchiMapper;
    }

    private Date getSysDate() {
        try {
            return this.fcFranchiMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFranchi(FcFranchiDomain fcFranchiDomain) {
        if (null == fcFranchiDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)fcFranchiDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFranchiDefault(FcFranchi fcFranchi) {
        if (null == fcFranchi) {
            return;
        }
        if (null == fcFranchi.getDataState()) {
            fcFranchi.setDataState(0);
        }
        if (null == fcFranchi.getGmtCreate()) {
            fcFranchi.setGmtCreate(this.getSysDate());
        }
        fcFranchi.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)fcFranchi.getFranchiCode())) {
            fcFranchi.setFranchiCode(this.createUUIDString());
        }
    }

    private int getFranchiMaxCode() {
        int code = 0;
        try {
            return this.fcFranchiMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiServiceImpl.getFranchiMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFranchiUpdataDefault(FcFranchi fcFranchi) {
        if (null == fcFranchi) {
            return;
        }
        fcFranchi.setGmtModified(this.getSysDate());
    }

    private void saveFranchiModel(FcFranchi fcFranchi) throws ApiException {
        if (null == fcFranchi) {
            return;
        }
        try {
            this.fcFranchiMapper.insert(fcFranchi);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.saveFranchiModel.ex", (Throwable)e);
        }
    }

    private void saveFranchiBatchModel(List<FcFranchi> fcFranchiList) throws ApiException {
        if (null == fcFranchiList || fcFranchiList.isEmpty()) {
            return;
        }
        try {
            this.fcFranchiMapper.insertBatch(fcFranchiList);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.saveFranchiBatchModel.ex", (Throwable)e);
        }
    }

    private FcFranchi getFranchiModelById(Integer franchiId) {
        if (null == franchiId) {
            return null;
        }
        try {
            return this.fcFranchiMapper.selectByPrimaryKey(franchiId);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiServiceImpl.getFranchiModelById", (Throwable)e);
            return null;
        }
    }

    private FcFranchi getFranchiModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.fcFranchiMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiServiceImpl.getFranchiModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delFranchiModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.fcFranchiMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.delFranchiModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.delFranchiModelByCode.num");
        }
    }

    private void deleteFranchiModel(Integer franchiId) throws ApiException {
        if (null == franchiId) {
            return;
        }
        int i = 0;
        try {
            i = this.fcFranchiMapper.deleteByPrimaryKey(franchiId);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.deleteFranchiModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.deleteFranchiModel.num");
        }
    }

    private void updateFranchiModel(FcFranchi fcFranchi) throws ApiException {
        if (null == fcFranchi) {
            return;
        }
        int i = 0;
        try {
            i = this.fcFranchiMapper.updateByPrimaryKeySelective(fcFranchi);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.updateFranchiModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.updateFranchiModel.num");
        }
    }

    private void updateStateFranchiModel(Integer franchiId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == franchiId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("franchiId", franchiId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.fcFranchiMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.updateStateFranchiModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.updateStateFranchiModel.null");
        }
    }

    private void updateStateFranchiModelByCode(String tenantCode, String franchiCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)franchiCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("franchiCode", franchiCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.fcFranchiMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.updateStateFranchiModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.updateStateFranchiModelByCode.null");
        }
    }

    private FcFranchi makeFranchi(FcFranchiDomain fcFranchiDomain, FcFranchi fcFranchi) {
        if (null == fcFranchiDomain) {
            return null;
        }
        if (null == fcFranchi) {
            fcFranchi = new FcFranchi();
        }
        try {
            BeanUtils.copyAllPropertys((Object)fcFranchi, (Object)fcFranchiDomain);
            return fcFranchi;
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiServiceImpl.makeFranchi", (Throwable)e);
            return null;
        }
    }

    private FcFranchiReDomain makeFcFranchiReDomain(FcFranchi fcFranchi) {
        if (null == fcFranchi) {
            return null;
        }
        FcFranchiReDomain fcFranchiReDomain = new FcFranchiReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)fcFranchiReDomain, (Object)fcFranchi);
            return fcFranchiReDomain;
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiServiceImpl.makeFcFranchiReDomain", (Throwable)e);
            return null;
        }
    }

    private List<FcFranchi> queryFranchiModelPage(Map<String, Object> parammap) {
        try {
            return this.fcFranchiMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiServiceImpl.queryFranchiModel", (Throwable)e);
            return null;
        }
    }

    private int countFranchi(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.fcFranchiMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcFranchiServiceImpl.countFranchi", (Throwable)e);
        }
        return i;
    }

    private FcFranchi createFcFranchi(FcFranchiDomain fcFranchiDomain) {
        String msg = this.checkFranchi(fcFranchiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.saveFranchi.checkFranchi", msg);
        }
        FcFranchi fcFranchi = this.makeFranchi(fcFranchiDomain, null);
        this.setFranchiDefault(fcFranchi);
        return fcFranchi;
    }

    @Override
    public String saveFranchi(FcFranchiDomain fcFranchiDomain) throws ApiException {
        FcFranchi fcFranchi = this.createFcFranchi(fcFranchiDomain);
        this.saveFranchiModel(fcFranchi);
        return fcFranchi.getFranchiCode();
    }

    @Override
    public String saveFranchiBatch(List<FcFranchiDomain> fcFranchiDomainList) throws ApiException {
        if (null == fcFranchiDomainList || fcFranchiDomainList.isEmpty()) {
            return null;
        }
        ArrayList<FcFranchi> fcFranchiList = new ArrayList<FcFranchi>();
        String code = "";
        for (FcFranchiDomain fcFranchiDomain : fcFranchiDomainList) {
            FcFranchi fcFranchi = this.createFcFranchi(fcFranchiDomain);
            code = fcFranchi.getFranchiCode();
            fcFranchiList.add(fcFranchi);
        }
        this.saveFranchiBatchModel(fcFranchiList);
        return code;
    }

    @Override
    public void updateFranchiState(Integer franchiId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFranchiModel(franchiId, dataState, oldDataState);
    }

    @Override
    public void updateFranchiStateByCode(String tenantCode, String franchiCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFranchiModelByCode(tenantCode, franchiCode, dataState, oldDataState);
    }

    @Override
    public void updateFranchi(FcFranchiDomain fcFranchiDomain) throws ApiException {
        String msg = this.checkFranchi(fcFranchiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.updateFranchi.checkFranchi", msg);
        }
        FcFranchi oldFcFranchi = this.getFranchiModelById(fcFranchiDomain.getFranchiId());
        if (null == oldFcFranchi) {
            throw new ApiException("fc.franchi.FcFranchiServiceImpl.updateFranchi.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FcFranchi fcFranchi = this.makeFranchi(fcFranchiDomain, oldFcFranchi);
        this.setFranchiUpdataDefault(fcFranchi);
        this.updateFranchiModel(fcFranchi);
    }

    @Override
    public FcFranchi getFranchi(Integer franchiId) {
        return this.getFranchiModelById(franchiId);
    }

    @Override
    public void deleteFranchi(Integer franchiId) throws ApiException {
        this.deleteFranchiModel(franchiId);
    }

    @Override
    public QueryResult<FcFranchi> queryFranchiPage(Map<String, Object> map) {
        List<FcFranchi> fcFranchiList = this.queryFranchiModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFranchi(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fcFranchiList);
        return queryResult;
    }

    @Override
    public FcFranchi getFranchiByCode(String tenantCode, String franchiCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("franchiCode", franchiCode);
        return this.getFranchiModelByCode(map);
    }

    @Override
    public void deleteFranchiByCode(String tenantCode, String franchiCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("franchiCode", franchiCode);
        this.delFranchiModelByCode(map);
    }
}

