/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.fc.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.fc.FcConstants;
import com.yqbsoft.laser.service.fc.dao.FcInvestigateMapper;
import com.yqbsoft.laser.service.fc.domain.FcInvestigateDomain;
import com.yqbsoft.laser.service.fc.domain.FcInvestigateReDomain;
import com.yqbsoft.laser.service.fc.model.FcInvestigate;
import com.yqbsoft.laser.service.fc.service.FcInvestigateService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FcInvestigateServiceImpl
extends BaseServiceImpl
implements FcInvestigateService {
    private static final String SYS_CODE = "fc.franchi.FcInvestigateServiceImpl";
    private FcInvestigateMapper fcInvestigateMapper;

    public void setFcInvestigateMapper(FcInvestigateMapper fcInvestigateMapper) {
        this.fcInvestigateMapper = fcInvestigateMapper;
    }

    private Date getSysDate() {
        try {
            return this.fcInvestigateMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcInvestigateServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkInvestigate(FcInvestigateDomain fcInvestigateDomain) {
        if (null == fcInvestigateDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)fcInvestigateDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInvestigateDefault(FcInvestigate fcInvestigate) {
        if (null == fcInvestigate) {
            return;
        }
        if (null == fcInvestigate.getDataState()) {
            fcInvestigate.setDataState(0);
        }
        if (null == fcInvestigate.getGmtCreate()) {
            fcInvestigate.setGmtCreate(this.getSysDate());
        }
        fcInvestigate.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)fcInvestigate.getInvestigateCode())) {
            fcInvestigate.setInvestigateCode(this.createUUIDString());
        }
    }

    private int getInvestigateMaxCode() {
        int code = 0;
        try {
            return this.fcInvestigateMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcInvestigateServiceImpl.getInvestigateMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setInvestigateUpdataDefault(FcInvestigate fcInvestigate) {
        if (null == fcInvestigate) {
            return;
        }
        fcInvestigate.setGmtModified(this.getSysDate());
    }

    private void saveInvestigateModel(FcInvestigate fcInvestigate) throws ApiException {
        if (null == fcInvestigate) {
            return;
        }
        try {
            this.fcInvestigateMapper.insert(fcInvestigate);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.saveInvestigateModel.ex", (Throwable)e);
        }
    }

    private void saveInvestigateBatchModel(List<FcInvestigate> fcInvestigateList) throws ApiException {
        if (null == fcInvestigateList || fcInvestigateList.isEmpty()) {
            return;
        }
        try {
            this.fcInvestigateMapper.insertBatch(fcInvestigateList);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.saveInvestigateBatchModel.ex", (Throwable)e);
        }
    }

    private FcInvestigate getInvestigateModelById(Integer investigateId) {
        if (null == investigateId) {
            return null;
        }
        try {
            return this.fcInvestigateMapper.selectByPrimaryKey(investigateId);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcInvestigateServiceImpl.getInvestigateModelById", (Throwable)e);
            return null;
        }
    }

    private FcInvestigate getInvestigateModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.fcInvestigateMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcInvestigateServiceImpl.getInvestigateModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delInvestigateModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.fcInvestigateMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.delInvestigateModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.delInvestigateModelByCode.num");
        }
    }

    private void deleteInvestigateModel(Integer investigateId) throws ApiException {
        if (null == investigateId) {
            return;
        }
        int i = 0;
        try {
            i = this.fcInvestigateMapper.deleteByPrimaryKey(investigateId);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.deleteInvestigateModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.deleteInvestigateModel.num");
        }
    }

    private void updateInvestigateModel(FcInvestigate fcInvestigate) throws ApiException {
        if (null == fcInvestigate) {
            return;
        }
        int i = 0;
        try {
            i = this.fcInvestigateMapper.updateByPrimaryKeySelective(fcInvestigate);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.updateInvestigateModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.updateInvestigateModel.num");
        }
    }

    private void updateStateInvestigateModel(Integer investigateId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == investigateId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("investigateId", investigateId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.fcInvestigateMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.updateStateInvestigateModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.updateStateInvestigateModel.null");
        }
    }

    private void updateStateInvestigateModelByCode(String tenantCode, String investigateCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)investigateCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("investigateCode", investigateCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.fcInvestigateMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.updateStateInvestigateModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.updateStateInvestigateModelByCode.null");
        }
    }

    private FcInvestigate makeInvestigate(FcInvestigateDomain fcInvestigateDomain, FcInvestigate fcInvestigate) {
        if (null == fcInvestigateDomain) {
            return null;
        }
        if (null == fcInvestigate) {
            fcInvestigate = new FcInvestigate();
        }
        try {
            BeanUtils.copyAllPropertys((Object)fcInvestigate, (Object)fcInvestigateDomain);
            return fcInvestigate;
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcInvestigateServiceImpl.makeInvestigate", (Throwable)e);
            return null;
        }
    }

    private FcInvestigateReDomain makeFcInvestigateReDomain(FcInvestigate fcInvestigate) {
        if (null == fcInvestigate) {
            return null;
        }
        FcInvestigateReDomain fcInvestigateReDomain = new FcInvestigateReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)fcInvestigateReDomain, (Object)fcInvestigate);
            return fcInvestigateReDomain;
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcInvestigateServiceImpl.makeFcInvestigateReDomain", (Throwable)e);
            return null;
        }
    }

    private List<FcInvestigate> queryInvestigateModelPage(Map<String, Object> parammap) {
        try {
            return this.fcInvestigateMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcInvestigateServiceImpl.queryInvestigateModel", (Throwable)e);
            return null;
        }
    }

    private int countInvestigate(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.fcInvestigateMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcInvestigateServiceImpl.countInvestigate", (Throwable)e);
        }
        return i;
    }

    private FcInvestigate createFcInvestigate(FcInvestigateDomain fcInvestigateDomain) {
        String msg = this.checkInvestigate(fcInvestigateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.saveInvestigate.checkInvestigate", msg);
        }
        FcInvestigate fcInvestigate = this.makeInvestigate(fcInvestigateDomain, null);
        this.setInvestigateDefault(fcInvestigate);
        return fcInvestigate;
    }

    @Override
    public String saveInvestigate(FcInvestigateDomain fcInvestigateDomain) throws ApiException {
        FcInvestigate fcInvestigate = this.createFcInvestigate(fcInvestigateDomain);
        this.saveInvestigateModel(fcInvestigate);
        return fcInvestigate.getInvestigateCode();
    }

    @Override
    public String saveInvestigateBatch(List<FcInvestigateDomain> fcInvestigateDomainList) throws ApiException {
        if (null == fcInvestigateDomainList || fcInvestigateDomainList.isEmpty()) {
            return null;
        }
        ArrayList<FcInvestigate> fcInvestigateList = new ArrayList<FcInvestigate>();
        String code = "";
        for (FcInvestigateDomain fcInvestigateDomain : fcInvestigateDomainList) {
            FcInvestigate fcInvestigate = this.createFcInvestigate(fcInvestigateDomain);
            code = fcInvestigate.getInvestigateCode();
            fcInvestigateList.add(fcInvestigate);
        }
        this.saveInvestigateBatchModel(fcInvestigateList);
        return code;
    }

    @Override
    public void updateInvestigateState(Integer investigateId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateInvestigateModel(investigateId, dataState, oldDataState);
    }

    @Override
    public void updateInvestigateStateByCode(String tenantCode, String investigateCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateInvestigateModelByCode(tenantCode, investigateCode, dataState, oldDataState);
    }

    @Override
    public void updateInvestigate(FcInvestigateDomain fcInvestigateDomain) throws ApiException {
        String msg = this.checkInvestigate(fcInvestigateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.updateInvestigate.checkInvestigate", msg);
        }
        FcInvestigate oldFcInvestigate = this.getInvestigateModelById(fcInvestigateDomain.getInvestigateId());
        if (null == oldFcInvestigate) {
            throw new ApiException("fc.franchi.FcInvestigateServiceImpl.updateInvestigate.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FcInvestigate fcInvestigate = this.makeInvestigate(fcInvestigateDomain, oldFcInvestigate);
        this.setInvestigateUpdataDefault(fcInvestigate);
        this.updateInvestigateModel(fcInvestigate);
    }

    @Override
    public FcInvestigate getInvestigate(Integer investigateId) {
        return this.getInvestigateModelById(investigateId);
    }

    @Override
    public void deleteInvestigate(Integer investigateId) throws ApiException {
        this.deleteInvestigateModel(investigateId);
    }

    @Override
    public QueryResult<FcInvestigate> queryInvestigatePage(Map<String, Object> map) {
        List<FcInvestigate> fcInvestigateList = this.queryInvestigateModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countInvestigate(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fcInvestigateList);
        return queryResult;
    }

    @Override
    public FcInvestigate getInvestigateByCode(String tenantCode, String investigateCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("investigateCode", investigateCode);
        return this.getInvestigateModelByCode(map);
    }

    @Override
    public void deleteInvestigateByCode(String tenantCode, String investigateCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("investigateCode", investigateCode);
        this.delInvestigateModelByCode(map);
    }

    @Override
    public String updateInvestigateCallBack(String tenantCode, String investigateCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)investigateCode)) {
            return "ERROR";
        }
        this.updateInvestigateStateByCode(tenantCode, investigateCode, FcConstants.FcInvestigateDataState_1, 0);
        return "SUCCESS";
    }
}

