/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.fc.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.fc.dao.FcTraintemEntryMapper;
import com.yqbsoft.laser.service.fc.dao.FcTrainuserEntryMapper;
import com.yqbsoft.laser.service.fc.dao.FcTrainuserMapper;
import com.yqbsoft.laser.service.fc.domain.FcTrainuserDomain;
import com.yqbsoft.laser.service.fc.domain.FcTrainuserReDomain;
import com.yqbsoft.laser.service.fc.domain.OcContractDomain;
import com.yqbsoft.laser.service.fc.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.fc.model.FcTraintemEntry;
import com.yqbsoft.laser.service.fc.model.FcTrainuser;
import com.yqbsoft.laser.service.fc.model.FcTrainuserEntry;
import com.yqbsoft.laser.service.fc.service.FcTrainuserService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FcTrainuserServiceImpl
extends BaseServiceImpl
implements FcTrainuserService {
    private static final String SYS_CODE = "fc.franchi.FcTrainuserServiceImpl";
    private FcTrainuserMapper fcTrainuserMapper;
    private FcTrainuserEntryMapper fcTrainuserEntryMapper;
    private FcTraintemEntryMapper fcTraintemEntryMapper;

    public void setFcTrainuserMapper(FcTrainuserMapper fcTrainuserMapper) {
        this.fcTrainuserMapper = fcTrainuserMapper;
    }

    public void setFcTraintemEntryMapper(FcTraintemEntryMapper fcTrainuserEntryMapper) {
        this.fcTraintemEntryMapper = fcTrainuserEntryMapper;
    }

    public void setFcTrainuserEntryMapper(FcTrainuserEntryMapper fcTrainuserEntryMapper) {
        this.fcTrainuserEntryMapper = fcTrainuserEntryMapper;
    }

    private Date getSysDate() {
        try {
            return this.fcTrainuserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTrainuserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTrainuser(FcTrainuserDomain fcTrainuserDomain) {
        if (null == fcTrainuserDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)fcTrainuserDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTrainuserDefault(FcTrainuser fcTrainuser) {
        if (null == fcTrainuser) {
            return;
        }
        if (null == fcTrainuser.getDataState()) {
            fcTrainuser.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == fcTrainuser.getGmtCreate()) {
            fcTrainuser.setGmtCreate(date);
        }
        fcTrainuser.setGmtModified(date);
        if (StringUtils.isBlank((String)fcTrainuser.getTrainuserCode())) {
            fcTrainuser.setTrainuserCode(this.getNo(null, "FcTrainuser", "fcTrainuser", fcTrainuser.getTenantCode()));
        }
    }

    private int getTrainuserMaxCode() {
        int code = 0;
        try {
            return this.fcTrainuserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTrainuserServiceImpl.getTrainuserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTrainuserUpdataDefault(FcTrainuser fcTrainuser) {
        if (null == fcTrainuser) {
            return;
        }
        fcTrainuser.setGmtModified(this.getSysDate());
    }

    private void saveTrainuserModel(FcTrainuser fcTrainuser) throws ApiException {
        if (null == fcTrainuser) {
            return;
        }
        try {
            this.fcTrainuserMapper.insert(fcTrainuser);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.saveTrainuserModel.ex", (Throwable)e);
        }
    }

    private void saveTrainuserBatchModel(List<FcTrainuser> fcTrainuserList) throws ApiException {
        if (null == fcTrainuserList || fcTrainuserList.isEmpty()) {
            return;
        }
        try {
            this.fcTrainuserMapper.insertBatch(fcTrainuserList);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.saveTrainuserBatchModel.ex", (Throwable)e);
        }
    }

    private FcTrainuser getTrainuserModelById(Integer trainuserId) {
        if (null == trainuserId) {
            return null;
        }
        try {
            return this.fcTrainuserMapper.selectByPrimaryKey(trainuserId);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTrainuserServiceImpl.getTrainuserModelById", (Throwable)e);
            return null;
        }
    }

    private FcTrainuser getTrainuserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.fcTrainuserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTrainuserServiceImpl.getTrainuserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTrainuserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.fcTrainuserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.delTrainuserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.delTrainuserModelByCode.num");
        }
    }

    private void deleteTrainuserModel(Integer trainuserId) throws ApiException {
        if (null == trainuserId) {
            return;
        }
        int i = 0;
        try {
            i = this.fcTrainuserMapper.deleteByPrimaryKey(trainuserId);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.deleteTrainuserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.deleteTrainuserModel.num");
        }
    }

    private void updateTrainuserModel(FcTrainuser fcTrainuser) throws ApiException {
        if (null == fcTrainuser) {
            return;
        }
        int i = 0;
        try {
            i = this.fcTrainuserMapper.updateByPrimaryKey(fcTrainuser);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.updateTrainuserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.updateTrainuserModel.num");
        }
    }

    private void updateStateTrainuserModel(Integer trainuserId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == trainuserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("trainuserId", trainuserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.fcTrainuserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.updateStateTrainuserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.updateStateTrainuserModel.null");
        }
    }

    private void updateStateTrainuserModelByCode(String tenantCode, String trainuserCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)trainuserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("trainuserCode", trainuserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.fcTrainuserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.updateStateTrainuserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.updateStateTrainuserModelByCode.null");
        }
    }

    private FcTrainuser makeTrainuser(FcTrainuserDomain fcTrainuserDomain, FcTrainuser fcTrainuser) {
        if (null == fcTrainuserDomain) {
            return null;
        }
        if (null == fcTrainuser) {
            fcTrainuser = new FcTrainuser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)fcTrainuser, (Object)fcTrainuserDomain);
            return fcTrainuser;
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTrainuserServiceImpl.makeTrainuser", (Throwable)e);
            return null;
        }
    }

    private FcTrainuserReDomain makeFcTrainuserReDomain(FcTrainuser fcTrainuser) {
        if (null == fcTrainuser) {
            return null;
        }
        FcTrainuserReDomain fcTrainuserReDomain = new FcTrainuserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)fcTrainuserReDomain, (Object)fcTrainuser);
            return fcTrainuserReDomain;
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTrainuserServiceImpl.makeFcTrainuserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<FcTrainuser> queryTrainuserModelPage(Map<String, Object> parammap) {
        try {
            return this.fcTrainuserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTrainuserServiceImpl.queryTrainuserModel", (Throwable)e);
            return null;
        }
    }

    private int countTrainuser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.fcTrainuserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTrainuserServiceImpl.countTrainuser", (Throwable)e);
        }
        return i;
    }

    private FcTrainuser createFcTrainuser(FcTrainuserDomain fcTrainuserDomain) {
        String msg = this.checkTrainuser(fcTrainuserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.saveTrainuser.checkTrainuser", msg);
        }
        FcTrainuser fcTrainuser = this.makeTrainuser(fcTrainuserDomain, null);
        this.setTrainuserDefault(fcTrainuser);
        return fcTrainuser;
    }

    @Override
    public String saveTrainuser(FcTrainuserDomain fcTrainuserDomain) throws ApiException {
        FcTrainuser fcTrainuser = this.createFcTrainuser(fcTrainuserDomain);
        this.saveTrainuserModel(fcTrainuser);
        return fcTrainuser.getTrainuserCode();
    }

    @Override
    public String saveTrainuserBatch(List<FcTrainuserDomain> fcTrainuserDomainList) throws ApiException {
        if (null == fcTrainuserDomainList || fcTrainuserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<FcTrainuser> fcTrainuserList = new ArrayList<FcTrainuser>();
        String code = "";
        for (FcTrainuserDomain fcTrainuserDomain : fcTrainuserDomainList) {
            FcTrainuser fcTrainuser = this.createFcTrainuser(fcTrainuserDomain);
            code = fcTrainuser.getTrainuserCode();
            fcTrainuserList.add(fcTrainuser);
        }
        this.saveTrainuserBatchModel(fcTrainuserList);
        return code;
    }

    @Override
    public void updateTrainuserState(Integer trainuserId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == trainuserId) {
            return;
        }
        this.updateStateTrainuserModel(trainuserId, dataState, oldDataState, map);
    }

    @Override
    public void updateTrainuserStateByCode(String tenantCode, String trainuserCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)trainuserCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateTrainuserModelByCode(tenantCode, trainuserCode, dataState, oldDataState, map);
    }

    @Override
    public void updateTrainuser(FcTrainuserDomain fcTrainuserDomain) throws ApiException {
        String msg = this.checkTrainuser(fcTrainuserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.updateTrainuser.checkTrainuser", msg);
        }
        FcTrainuser oldFcTrainuser = this.getTrainuserModelById(fcTrainuserDomain.getTrainuserId());
        if (null == oldFcTrainuser) {
            throw new ApiException("fc.franchi.FcTrainuserServiceImpl.updateTrainuser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FcTrainuser fcTrainuser = this.makeTrainuser(fcTrainuserDomain, oldFcTrainuser);
        this.setTrainuserUpdataDefault(fcTrainuser);
        this.updateTrainuserModel(fcTrainuser);
    }

    @Override
    public FcTrainuser getTrainuser(Integer trainuserId) {
        if (null == trainuserId) {
            return null;
        }
        return this.getTrainuserModelById(trainuserId);
    }

    @Override
    public void deleteTrainuser(Integer trainuserId) throws ApiException {
        if (null == trainuserId) {
            return;
        }
        this.deleteTrainuserModel(trainuserId);
    }

    @Override
    public QueryResult<FcTrainuser> queryTrainuserPage(Map<String, Object> map) {
        List<FcTrainuser> fcTrainuserList = this.queryTrainuserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTrainuser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fcTrainuserList);
        return queryResult;
    }

    @Override
    public FcTrainuser getTrainuserByCode(String tenantCode, String trainuserCode) throws ApiException {
        if (StringUtils.isBlank((String)trainuserCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("trainuserCode", trainuserCode);
        return this.getTrainuserModelByCode(map);
    }

    @Override
    public void deleteTrainuserByCode(String tenantCode, String trainuserCode) throws ApiException {
        if (StringUtils.isBlank((String)trainuserCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("trainuserCode", trainuserCode);
        this.delTrainuserModelByCode(map);
    }

    @Override
    public String saveTrainuserByOc(OcContractDomain ocContractDomain) throws ApiException {
        if (ocContractDomain == null) {
            this.logger.error("===========goodsList===========");
            return "false";
        }
        this.logger.error("---------\u5f00\u59cb----------", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            FcTrainuser fcTrainuser;
            boolean isSuccess = this.insertTrainuserEntryBatch(ocContractGoodsDomain, ocContractDomain, (fcTrainuser = this.makeTrainuserByOc(ocContractGoodsDomain, ocContractDomain)).getTrainuserCode());
            if (!isSuccess) {
                return "false";
            }
            try {
                this.fcTrainuserMapper.insertSelective(fcTrainuser);
            }
            catch (Exception e) {
                throw new ApiException("fc.franchi.FcTrainuserServiceImpl.saveTrainuserByOc.ex", (Throwable)e);
            }
        }
        return "success";
    }

    private boolean insertTrainuserEntryBatch(OcContractGoodsDomain ocContractGoodsDomain, OcContractDomain ocContractDomain, String trainuserCode) {
        this.logger.error("===========createUserEntry==========");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fuzzy", false);
        map.put("traintemNo", ocContractGoodsDomain.getGoodsNo());
        List<Object> fcTraintemEntryList = new ArrayList();
        try {
            fcTraintemEntryList = this.fcTraintemEntryMapper.query(map);
        }
        catch (Exception e) {
            this.logger.error("fc.franchi.FcTrainuserServiceImpl.queryTraintemEntryModel", (Throwable)e);
        }
        if (ListUtil.isEmpty(fcTraintemEntryList)) {
            return false;
        }
        for (FcTraintemEntry fcTraintemEntry : fcTraintemEntryList) {
            FcTrainuserEntry fcTrainuserEntry = new FcTrainuserEntry();
            fcTrainuserEntry.setTrainuserCode(trainuserCode);
            fcTrainuserEntry.setTraintemEntryCode(fcTraintemEntry.getTraintemEntryCode());
            fcTrainuserEntry.setTraintemEntryName(fcTraintemEntry.getTraintemEntryName());
            fcTrainuserEntry.setTraintemEntryType(fcTraintemEntry.getTraintemEntryType());
            fcTrainuserEntry.setTraintemEntryUrl(fcTraintemEntry.getTraintemEntryUrl());
            fcTrainuserEntry.setTraintemEntryUrl1(fcTraintemEntry.getTraintemEntryUrl1());
            fcTrainuserEntry.setMemberBcode(ocContractDomain.getMemberBcode());
            fcTrainuserEntry.setMemberBname(ocContractDomain.getMemberBname());
            fcTrainuserEntry.setMemberCode(ocContractDomain.getMemberCode());
            fcTrainuserEntry.setMemberName(ocContractDomain.getMemberName());
            fcTrainuserEntry.setMemberCcode(ocContractDomain.getMemberCcode());
            fcTrainuserEntry.setMemberCname(ocContractDomain.getMemberCname());
            fcTrainuserEntry.setTraintemOcode(ocContractDomain.getContractBillcode());
            fcTrainuserEntry.setTraintemOcode1(ocContractDomain.getContractBbillcode());
            fcTrainuserEntry.setTraintemOcode2(fcTraintemEntry.getTraintemEntryOrder().toString());
            fcTrainuserEntry.setTraintemOcode3("1");
            fcTrainuserEntry.setAppmanageIcode(ocContractDomain.getAppmanageIcode());
            fcTrainuserEntry.setTenantCode(fcTraintemEntry.getTenantCode());
            fcTrainuserEntry.setGoodsName(ocContractGoodsDomain.getGoodsName());
            fcTrainuserEntry.setGoodsRemark(ocContractGoodsDomain.getGoodsRemark());
            fcTrainuserEntry.setTraintemEntryUrl2(ocContractGoodsDomain.getDataPic());
            fcTrainuserEntry.setTrainuserEntryAmt(ocContractDomain.getDataBmoney());
            fcTrainuserEntry.setInvestigateAreaCode(ocContractGoodsDomain.getGoodsNo());
            this.setTrainuserEntryDefault(fcTrainuserEntry);
            try {
                this.fcTrainuserEntryMapper.insertSelective(fcTrainuserEntry);
            }
            catch (Exception e) {
                throw new ApiException("fc.franchi.FcTrainuserServiceImpl.saveTrainuserEntryByOc.ex", (Throwable)e);
            }
        }
        return true;
    }

    private void setTrainuserEntryDefault(FcTrainuserEntry fcTrainuserEntry) {
        if (null == fcTrainuserEntry) {
            return;
        }
        if (null == fcTrainuserEntry.getDataState()) {
            fcTrainuserEntry.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == fcTrainuserEntry.getGmtCreate()) {
            fcTrainuserEntry.setGmtCreate(date);
        }
        fcTrainuserEntry.setGmtModified(date);
        if (StringUtils.isBlank((String)fcTrainuserEntry.getTrainuserEntryCode())) {
            fcTrainuserEntry.setTrainuserEntryCode(this.createUUIDString());
        }
    }

    private FcTrainuser makeTrainuserByOc(OcContractGoodsDomain ocContractGoodsDomain, OcContractDomain ocContractDomain) {
        FcTrainuser fcTrainuser = new FcTrainuser();
        fcTrainuser.setTraintemCode(ocContractGoodsDomain.getGoodsCode());
        fcTrainuser.setTraintemName(ocContractGoodsDomain.getGoodsName());
        fcTrainuser.setTraintemEntryUrl1(ocContractGoodsDomain.getDataPic());
        fcTrainuser.setMemberBcode(ocContractDomain.getMemberBcode());
        fcTrainuser.setMemberBname(ocContractDomain.getMemberBname());
        fcTrainuser.setMemberCode(ocContractDomain.getMemberCode());
        fcTrainuser.setMemberName(ocContractDomain.getMemberName());
        fcTrainuser.setMemberCcode(ocContractDomain.getMemberCcode());
        fcTrainuser.setMemberCname(ocContractDomain.getMemberCname());
        fcTrainuser.setMemberPhone(ocContractDomain.getGoodsReceiptPhone());
        fcTrainuser.setTrainuserAamt(ocContractDomain.getDataBmoney());
        fcTrainuser.setTrainuserAmt(ocContractDomain.getGoodsMoney());
        fcTrainuser.setAppmanageIcode(ocContractDomain.getAppmanageIcode());
        fcTrainuser.setTenantCode(ocContractDomain.getTenantCode());
        this.setTrainuserDefault(fcTrainuser);
        fcTrainuser.setDataState(2);
        return fcTrainuser;
    }
}

