/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.file.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.file.dao.FmMfileMapper;
import com.yqbsoft.laser.service.file.domain.FmMfileDomain;
import com.yqbsoft.laser.service.file.domain.FmMfileReDomain;
import com.yqbsoft.laser.service.file.model.FmMfile;
import com.yqbsoft.laser.service.file.service.FmMfileService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FmMfileServiceImpl
extends BaseServiceImpl
implements FmMfileService {
    private static final String SYS_CODE = "fm.FILE.FmMfileServiceImpl";
    private FmMfileMapper fmMfileMapper;

    public void setFmMfileMapper(FmMfileMapper fmMfileMapper) {
        this.fmMfileMapper = fmMfileMapper;
    }

    private Date getSysDate() {
        try {
            return this.fmMfileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmMfileServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMfile(FmMfileDomain fmMfileDomain) {
        if (null == fmMfileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)fmMfileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMfileDefault(FmMfile fmMfile) {
        if (null == fmMfile) {
            return;
        }
        if (null == fmMfile.getDataState()) {
            fmMfile.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == fmMfile.getGmtCreate()) {
            fmMfile.setGmtCreate(date);
        }
        fmMfile.setGmtModified(date);
        if (StringUtils.isBlank((String)fmMfile.getMfileCode())) {
            fmMfile.setMfileCode(this.createUUIDString());
        }
    }

    private int getMfileMaxCode() {
        int code = 0;
        try {
            return this.fmMfileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmMfileServiceImpl.getMfileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMfileUpdataDefault(FmMfile fmMfile) {
        if (null == fmMfile) {
            return;
        }
        fmMfile.setGmtModified(this.getSysDate());
    }

    private void saveMfileModel(FmMfile fmMfile) throws ApiException {
        if (null == fmMfile) {
            return;
        }
        try {
            this.fmMfileMapper.insert(fmMfile);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.saveMfileModel.ex", (Throwable)e);
        }
    }

    private void saveMfileBatchModel(List<FmMfile> fmMfileList) throws ApiException {
        if (null == fmMfileList || fmMfileList.isEmpty()) {
            return;
        }
        try {
            this.fmMfileMapper.insertBatch(fmMfileList);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.saveMfileBatchModel.ex", (Throwable)e);
        }
    }

    private FmMfile getMfileModelById(Integer mfileId) {
        if (null == mfileId) {
            return null;
        }
        try {
            return this.fmMfileMapper.selectByPrimaryKey(mfileId);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmMfileServiceImpl.getMfileModelById", (Throwable)e);
            return null;
        }
    }

    private FmMfile getMfileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.fmMfileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmMfileServiceImpl.getMfileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMfileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.fmMfileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.delMfileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.delMfileModelByCode.num");
        }
    }

    private void deleteMfileModel(Integer mfileId) throws ApiException {
        if (null == mfileId) {
            return;
        }
        int i = 0;
        try {
            i = this.fmMfileMapper.deleteByPrimaryKey(mfileId);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.deleteMfileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.deleteMfileModel.num");
        }
    }

    private void updateMfileModel(FmMfile fmMfile) throws ApiException {
        if (null == fmMfile) {
            return;
        }
        int i = 0;
        try {
            i = this.fmMfileMapper.updateByPrimaryKey(fmMfile);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.updateMfileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.updateMfileModel.num");
        }
    }

    private void updateStateMfileModel(Integer mfileId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == mfileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mfileId", mfileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.fmMfileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.updateStateMfileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.updateStateMfileModel.null");
        }
    }

    private void updateStateMfileModelByCode(String tenantCode, String mfileCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)mfileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mfileCode", mfileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.fmMfileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.updateStateMfileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.updateStateMfileModelByCode.null");
        }
    }

    private FmMfile makeMfile(FmMfileDomain fmMfileDomain, FmMfile fmMfile) {
        if (null == fmMfileDomain) {
            return null;
        }
        if (null == fmMfile) {
            fmMfile = new FmMfile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)fmMfile, (Object)fmMfileDomain);
            return fmMfile;
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmMfileServiceImpl.makeMfile", (Throwable)e);
            return null;
        }
    }

    private FmMfileReDomain makeFmMfileReDomain(FmMfile fmMfile) {
        if (null == fmMfile) {
            return null;
        }
        FmMfileReDomain fmMfileReDomain = new FmMfileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)fmMfileReDomain, (Object)fmMfile);
            return fmMfileReDomain;
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmMfileServiceImpl.makeFmMfileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<FmMfile> queryMfileModelPage(Map<String, Object> parammap) {
        try {
            return this.fmMfileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmMfileServiceImpl.queryMfileModel", (Throwable)e);
            return null;
        }
    }

    private int countMfile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.fmMfileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmMfileServiceImpl.countMfile", (Throwable)e);
        }
        return i;
    }

    private FmMfile createFmMfile(FmMfileDomain fmMfileDomain) {
        String msg = this.checkMfile(fmMfileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.saveMfile.checkMfile", msg);
        }
        FmMfile fmMfile = this.makeMfile(fmMfileDomain, null);
        this.setMfileDefault(fmMfile);
        return fmMfile;
    }

    @Override
    public String saveMfile(FmMfileDomain fmMfileDomain) throws ApiException {
        FmMfile fmMfile = this.createFmMfile(fmMfileDomain);
        this.saveMfileModel(fmMfile);
        return fmMfile.getMfileCode();
    }

    @Override
    public String saveMfileBatch(List<FmMfileDomain> fmMfileDomainList) throws ApiException {
        if (null == fmMfileDomainList || fmMfileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<FmMfile> fmMfileList = new ArrayList<FmMfile>();
        String code = "";
        for (FmMfileDomain fmMfileDomain : fmMfileDomainList) {
            FmMfile fmMfile = this.createFmMfile(fmMfileDomain);
            code = fmMfile.getMfileCode();
            fmMfileList.add(fmMfile);
        }
        this.saveMfileBatchModel(fmMfileList);
        return code;
    }

    @Override
    public void updateMfileState(Integer mfileId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == mfileId) {
            return;
        }
        this.updateStateMfileModel(mfileId, dataState, oldDataState, map);
    }

    @Override
    public void updateMfileStateByCode(String tenantCode, String mfileCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)mfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateMfileModelByCode(tenantCode, mfileCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMfile(FmMfileDomain fmMfileDomain) throws ApiException {
        String msg = this.checkMfile(fmMfileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.updateMfile.checkMfile", msg);
        }
        FmMfile oldFmMfile = this.getMfileModelById(fmMfileDomain.getMfileId());
        if (null == oldFmMfile) {
            throw new ApiException("fm.FILE.FmMfileServiceImpl.updateMfile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FmMfile fmMfile = this.makeMfile(fmMfileDomain, oldFmMfile);
        this.setMfileUpdataDefault(fmMfile);
        this.updateMfileModel(fmMfile);
    }

    @Override
    public FmMfile getMfile(Integer mfileId) {
        if (null == mfileId) {
            return null;
        }
        return this.getMfileModelById(mfileId);
    }

    @Override
    public void deleteMfile(Integer mfileId) throws ApiException {
        if (null == mfileId) {
            return;
        }
        this.deleteMfileModel(mfileId);
    }

    @Override
    public QueryResult<FmMfile> queryMfilePage(Map<String, Object> map) {
        List<FmMfile> fmMfileList = this.queryMfileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMfile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fmMfileList);
        return queryResult;
    }

    @Override
    public FmMfile getMfileByCode(String tenantCode, String mfileCode) throws ApiException {
        if (StringUtils.isBlank((String)mfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mfileCode", mfileCode);
        return this.getMfileModelByCode(map);
    }

    @Override
    public void deleteMfileByCode(String tenantCode, String mfileCode) throws ApiException {
        if (StringUtils.isBlank((String)mfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mfileCode", mfileCode);
        this.delMfileModelByCode(map);
    }
}

