/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.finterface.client.jd.b2b;

import com.jd.open.api.sdk.request.imgzone.ImgzonePictureUploadRequest;
import com.jd.open.api.sdk.request.ware.ImageWriteDeleteRequest;
import com.jd.open.api.sdk.request.ware.ImageWriteUpdateRequest;
import com.jd.open.api.sdk.request.ware.SkuWriteDeleteSkuRequest;
import com.jd.open.api.sdk.request.ware.WareAddRequest;
import com.jd.open.api.sdk.request.ware.WareSkuAddRequest;
import com.jd.open.api.sdk.request.ware.WareSkuUpdateRequest;
import com.jd.open.api.sdk.request.ware.WareUpdateRequest;
import com.jd.open.api.sdk.request.ware.WareWriteUpOrDownRequest;
import com.jd.open.api.sdk.response.imgzone.ImgzonePictureUploadResponse;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.finterface.client.jd.constant.JdListingTypeEnum;
import com.yqbsoft.laser.service.finterface.client.jd.iface.JingDongInterfaceServiceImpl;
import com.yqbsoft.laser.service.finterface.iface.b2b.bean.ListingTypeEnum;
import com.yqbsoft.laser.service.finterface.iface.b2b.bean.PropsBean;
import com.yqbsoft.laser.service.finterface.iface.b2b.domain.B2bGoodsRequest;
import com.yqbsoft.laser.service.finterface.iface.b2b.v1.B2bGoodsService;
import com.yqbsoft.laser.service.finterface.iface.base.InterfaceRequest;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class JingDongB2bGoodsServiceImpl
extends JingDongInterfaceServiceImpl
implements B2bGoodsService {
    private static final String DEFAULT_NUM = "0";
    private static final String DEFAULT_COLOR_ID = "0000000000";
    private static final Long DEFAULT_PICTURE_CATE_ID = null;

    public Object storeGoods(B2bGoodsRequest request) {
        if (request == null || request.getGoodsImage() == null || request.getGoodsImage().getBody() == null || StringUtils.isBlank((String)request.getCategroyIdMapping())) {
            throw new ApiException("PARAMS.INVALID", "params is invalid");
        }
        WareAddRequest req = new WareAddRequest();
        req.setCid(request.getCategroyIdMapping());
        req.setTitle(request.getGoodsName());
        req.setItemNum(request.getGoodsCode());
        req.setStockNum(request.getGoodsSupplynum() != null ? request.getGoodsSupplynum().toString() : DEFAULT_NUM);
        req.setLength(DEFAULT_NUM);
        req.setWide(DEFAULT_NUM);
        req.setHigh(DEFAULT_NUM);
        req.setWeight(request.getGoodsWeight() == null ? DEFAULT_NUM : request.getGoodsWeight().toString());
        if (request.getPricesetPrefprice() != null) {
            req.setMarketPrice(request.getPricesetMakeprice().setScale(2, 6).toPlainString());
        }
        if (request.getPricesetNprice() != null) {
            req.setJdPrice(request.getPricesetNprice().setScale(2, 6).toPlainString());
        }
        req.setNotes(request.getGoodsRemark());
        req.setWareImage(request.getGoodsImage().getBody());
        StringBuffer attributes = new StringBuffer();
        for (PropsBean mapping : request.getPropertiesListMapping()) {
            if (attributes.length() > 0) {
                attributes.append("|");
            }
            attributes.append(mapping.getPropertiesCode() + ":" + mapping.getPropertiesValueValue());
        }
        req.setAttributes(attributes.toString());
        req.setOptionType(JdListingTypeEnum.OFFSALE.getOptionType());
        return this.execute((InterfaceRequest)request, req);
    }

    public Object updateGoods(B2bGoodsRequest request) {
        if (request == null || StringUtils.isBlank((String)request.getGoodsCodeMapping())) {
            throw new ApiException("PARAMS.INVALID", " params is invalid");
        }
        WareUpdateRequest req = new WareUpdateRequest();
        req.setWareId(request.getGoodsCodeMapping());
        req.setTitle(request.getGoodsName());
        req.setItemNum(request.getGoodsCode());
        req.setStockNum(request.getGoodsSupplynum().toString());
        req.setWeight(request.getGoodsWeight() == null ? DEFAULT_NUM : request.getGoodsWeight().toString());
        if (request.getPricesetPrefprice() != null) {
            req.setMarketPrice(request.getPricesetMakeprice().setScale(2, 6).toPlainString());
        }
        if (request.getPricesetNprice() != null) {
            req.setJdPrice(request.getPricesetNprice().setScale(2, 6).toPlainString());
        }
        req.setNotes(request.getGoodsRemark());
        return this.execute((InterfaceRequest)request, req);
    }

    public Object storeGoodsImg(B2bGoodsRequest request) {
        if (request == null || StringUtils.isBlank((String)request.getGoodsCodeMapping()) || request.getGoodsImage() == null) {
            throw new ApiException("PARAMS.INVALID", " params is invalid");
        }
        ImgzonePictureUploadRequest imgRequest = new ImgzonePictureUploadRequest();
        imgRequest.setImageData(request.getGoodsImage().getBody());
        imgRequest.setPictureCateId(DEFAULT_PICTURE_CATE_ID);
        if (request.getGoodsImage().getImageName() != null && request.getGoodsImage().getImageName().getBytes().length <= 64) {
            imgRequest.setPictureName(request.getGoodsImage().getImageName());
        }
        ImgzonePictureUploadResponse response = (ImgzonePictureUploadResponse)this.execute((InterfaceRequest)request, imgRequest);
        ImageWriteUpdateRequest req = new ImageWriteUpdateRequest();
        req.setWareId(Long.valueOf(Long.parseLong(request.getGoodsCodeMapping())));
        req.setColorId(DEFAULT_COLOR_ID);
        if (request.getGoodsImage().getImageIndex() != null) {
            req.setImgIndex(Integer.valueOf(1 - request.getGoodsImage().getImageIndex()).toString());
        }
        req.setImgUrl(response.getPictureUrl());
        req.setImgZoneId(response.getPictureId());
        return this.execute((InterfaceRequest)request, req);
    }

    public Object deleteGoodsImg(B2bGoodsRequest request) {
        if (request == null || request.getGoodsImage() == null || StringUtils.isBlank((String)request.getGoodsCodeMapping())) {
            throw new ApiException("PARAMS.INVALID", " params is invalid");
        }
        ImageWriteDeleteRequest req = new ImageWriteDeleteRequest();
        req.setWareId(Long.valueOf(Long.parseLong(request.getGoodsCodeMapping())));
        req.setColorIds(DEFAULT_COLOR_ID);
        if (request.getGoodsImage().getImageIndex() != null) {
            req.setImgIndexes(Integer.valueOf(1 - request.getGoodsImage().getImageIndex()).toString());
        }
        return this.execute((InterfaceRequest)request, req);
    }

    public Object storeSku(B2bGoodsRequest request) {
        if (request == null || CollectionUtils.isEmpty((Collection)request.getPropertiesListMapping()) || StringUtils.isBlank((String)request.getGoodsCodeMapping())) {
            throw new ApiException("PARAMS.INVALID", " params is invalid");
        }
        WareSkuAddRequest req = new WareSkuAddRequest();
        req.setWareId(request.getGoodsCodeMapping());
        StringBuffer attributes = new StringBuffer();
        for (PropsBean mapping : request.getPropertiesListMapping()) {
            if (attributes.length() > 0) {
                attributes.append("^");
            }
            attributes.append(mapping.getPropertiesCode() + ":" + mapping.getPropertiesValueValue());
        }
        req.setAttributes(attributes.toString());
        if (request.getPricesetNprice() != null) {
            req.setJdPrice(request.getPricesetNprice().setScale(2, 6).toPlainString());
        }
        req.setStockNum(request.getGoodsSupplynum() != null ? request.getGoodsSupplynum().toString() : DEFAULT_NUM);
        return this.execute((InterfaceRequest)request, req);
    }

    public Object updateSku(B2bGoodsRequest request) {
        if (request == null || StringUtils.isBlank((String)request.getSkuIdMapping()) || StringUtils.isBlank((String)request.getGoodsCodeMapping())) {
            throw new ApiException("PARAMS.INVALID", " params is invalid");
        }
        WareSkuUpdateRequest req = new WareSkuUpdateRequest();
        req.setSkuId(request.getSkuIdMapping());
        req.setWareId(request.getGoodsCodeMapping());
        req.setOuterId(request.getSkuCode());
        if (request.getPricesetNprice() != null) {
            req.setJdPrice(request.getPricesetNprice().setScale(2, 6).toPlainString());
        }
        req.setStockNum(request.getGoodsSupplynum() != null ? request.getGoodsSupplynum().toString() : DEFAULT_NUM);
        return this.execute((InterfaceRequest)request, req);
    }

    public Object deleteSku(B2bGoodsRequest request) {
        if (request == null || StringUtils.isBlank((String)request.getSkuIdMapping())) {
            throw new ApiException("PARAMS.INVALID", " params is invalid");
        }
        SkuWriteDeleteSkuRequest req = new SkuWriteDeleteSkuRequest();
        req.setSkuId(Long.valueOf(Long.parseLong(request.getSkuIdMapping())));
        return this.execute((InterfaceRequest)request, req);
    }

    public Object listingGoods(B2bGoodsRequest request) {
        WareWriteUpOrDownRequest req = new WareWriteUpOrDownRequest();
        if (ListingTypeEnum.DELISTING.getType().equals(request.getLisingType())) {
            req.setOpType(JdListingTypeEnum.getListingTypeForJd(ListingTypeEnum.DELISTING).getCode());
        } else if (ListingTypeEnum.LISTING.getType().equals(request.getLisingType())) {
            req.setOpType(JdListingTypeEnum.getListingTypeForJd(ListingTypeEnum.LISTING).getCode());
        }
        req.setWareId(Long.valueOf(Long.parseLong(request.getGoodsCode())));
        return this.execute((InterfaceRequest)request, req);
    }
}

