/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.finterface.client.jd.iface;

import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.JdException;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.response.AbstractResponse;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.finterface.client.jd.util.JdErrorHandler;
import com.yqbsoft.laser.service.finterface.iface.base.BaseInterfaceServiceImpl;
import com.yqbsoft.laser.service.finterface.iface.base.InterfaceRequest;
import java.util.Map;

public abstract class JingDongInterfaceServiceImpl
extends BaseInterfaceServiceImpl {
    private static final String SERVICEURL_key = "serviceUrl";
    private static final String APPKEY_KEY = "appKey";
    private static final String APPSECRET_KEY = "appSecret";
    private static final String SUCCESS = "0";

    protected void loadConfig(InterfaceRequest request) {
        super.loadConfig(request);
        Map configMap = request.getConfigMap();
        if (!(null != configMap && configMap.containsKey(SERVICEURL_key) && configMap.containsKey(APPKEY_KEY) && configMap.containsKey(APPSECRET_KEY))) {
            throw new ApiException("FCLIENT-JINGDONG", "JingDong platform Config missing");
        }
    }

    protected final Map<String, String> getConfigMap(InterfaceRequest request) {
        this.loadConfig(request);
        return request.getConfigMap();
    }

    protected <T extends AbstractResponse> T execute(InterfaceRequest origin, JdRequest<T> request) {
        try {
            JdClient client = this.getDefaultJdClient(origin);
            AbstractResponse response = client.execute(request);
            if (response == null || !SUCCESS.equals(response.getCode())) {
                throw new ApiException("FCLIENT-JINGDONG", JdErrorHandler.getErrorDesc(response.getCode()));
            }
            return (T)response;
        }
        catch (JdException e) {
            throw new ApiException("FCLIENT-JINGDONG", e.getErrMsg() != null ? e.getErrMsg() : "JingDong platform invoke excption");
        }
    }

    private JdClient getDefaultJdClient(InterfaceRequest origin) {
        Map<String, String> configMap = this.getConfigMap(origin);
        return new DefaultJdClient(configMap.get(SERVICEURL_key), origin.getToken(), configMap.get(APPKEY_KEY), configMap.get(APPSECRET_KEY));
    }
}

